/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.eas.fi.rpt.client.FormulaWizardUI;
import com.kingdee.eas.ma.bg.BgDimensionEnum;
import com.kingdee.eas.ma.bg.BgItemCollection;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.BgTypeFactory;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.IBgType;
import com.kingdee.eas.ma.bg.ValidBgDimensionInfo;
import com.kingdee.eas.ma.bg.client.BgOrgUnitF7SelectorHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.IllegalComponentStateException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BgProjectF7SelectorForRpt
extends KDDialog
implements KDPromptSelector {
    protected boolean isOK = false;
    KDButton btnOk = null;
    KDButton btnCancel = null;
    FormulaWizardUI formulaWizardUI = null;
    private KDTable kdtable = this.initKDtable();
    private final String NUMBER = "number";
    private final String NAME = "name";
    private final String UOM = "uom";

    public BgProjectF7SelectorForRpt() throws HeadlessException {
        this.kdtable.getStyleAttributes().setLocked(true);
        this.kdtable.setBounds(10, 20, 380, 200);
        this.kdtable.setVisible(true);
        KDPanel jp = new KDPanel();
        jp.setLayout(null);
        jp.add((Component)this.kdtable);
        String strConfirm = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"confirm");
        this.btnOk = new KDButton("OK");
        this.btnOk.setText(strConfirm);
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BgProjectF7SelectorForRpt.this.close(true);
            }
        });
        this.btnOk.setEnabled(true);
        this.btnOk.setBounds(100, 230, 80, 26);
        jp.add((Component)this.btnOk);
        String strCancel = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"cancel");
        this.btnCancel = new KDButton("CANCEL");
        this.btnCancel.setText(strCancel);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BgProjectF7SelectorForRpt.this.close(false);
            }
        });
        this.btnCancel.setBounds(200, 230, 80, 26);
        this.btnCancel.setEnabled(true);
        jp.add((Component)this.btnCancel);
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        c.add((Component)jp, "Center");
        this.setSize(400, 300);
    }

    public boolean isCanceled() {
        return !this.isOK;
    }

    public Object getData() {
        StringBuffer strBuffer = new StringBuffer();
        ArrayList arrayList = this.kdtable.getSelectManager().getBlocks();
        if (arrayList != null) {
            Object[] objArr = arrayList.toArray();
            for (int i = 0; i < objArr.length; ++i) {
                int start;
                KDTBlock kdTBlock = (KDTBlock)objArr[i];
                for (int j = start = kdTBlock.getTop(); j <= kdTBlock.getBottom(); ++j) {
                    IRow iRow = this.kdtable.getRow(j);
                    String strValue = ((BgItemInfo)iRow.getUserObject()).getItemNumber();
                    if (strBuffer.toString().length() > 0) {
                        strBuffer.append("," + strValue);
                        continue;
                    }
                    strBuffer.append(strValue);
                }
            }
        }
        return strBuffer.toString();
    }

    public static void main(String[] args) {
        BgProjectF7SelectorForRpt bgElementF7Selector = new BgProjectF7SelectorForRpt();
        bgElementF7Selector.show();
    }

    public void show() {
        this.setModal(true);
        if (this.getFormulaWizardUI() != null) {
            String strBgTypeNumber = this.getFormulaWizardUI().getParam("bgType");
            String strOrgNumber = this.getFormulaWizardUI().getParam("orgUnit");
            this.putDataToKDTable(strBgTypeNumber, strOrgNumber);
        }
        super.show();
    }

    private void close(boolean isOk) {
        this.isOK = isOk;
        this.setVisible(false);
    }

    public KDTable initKDtable() {
        if (this.kdtable == null) {
            this.kdtable = new KDTable();
        }
        this.kdtable.checkParsed();
        IColumn iColumn = this.kdtable.addColumn();
        iColumn.setKey("number");
        IColumn iColumn1 = this.kdtable.addColumn();
        iColumn1.setKey("name");
        IColumn iColumn2 = this.kdtable.addColumn();
        iColumn2.setKey("uom");
        IRow iRow = this.kdtable.addHeadRow();
        String strNumber = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"number");
        String strName = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"name");
        String strUom = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"uom");
        iRow.getCell("number").setValue((Object)strNumber);
        iRow.getCell("name").setValue((Object)strName);
        iRow.getCell("uom").setValue((Object)strUom);
        this.kdtable.getSelectManager().setSelectMode(2);
        return this.kdtable;
    }

    public void putDataToKDTable(String strNumber, String strOrgUnitNumber) {
        block9: {
            try {
                if (strNumber == null || strNumber.length() == 0) {
                    String strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"pleaseSelectBgType");
                    MsgBox.showWarning((Component)((Object)this), (String)strErr);
                    return;
                }
                if (strOrgUnitNumber == null || strOrgUnitNumber.length() == 0) {
                    String strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"pleaseSelectOrgUnit");
                    MsgBox.showWarning((Component)((Object)this), (String)strErr);
                    return;
                }
                IBgType iBgType = BgTypeFactory.getRemoteInstance();
                BgTypeInfo bgTypeInfo = iBgType.getValueByNumber(strNumber);
                if (bgTypeInfo != null) {
                    BgTemplateInfo bgTemplateInfo = BgOrgUnitF7SelectorHelper.findBgTemplateInfoOfPath(bgTypeInfo, strOrgUnitNumber);
                    if (bgTemplateInfo == null) {
                        return;
                    }
                    String strDimNumber = this.getFormulaWizardUI().getParam("bgDimension");
                    ValidBgDimensionInfo vlidBgDimensionInfo = this.getValidBgDimensionInfo(bgTypeInfo, strDimNumber);
                    BgItemCollection bgItemCollection = null;
                    if (vlidBgDimensionInfo != null && bgTemplateInfo.getRefDim(vlidBgDimensionInfo.getBgDimension()) != null) {
                        bgItemCollection = bgTemplateInfo.getRefDim(vlidBgDimensionInfo.getBgDimension()).getBgItems();
                    }
                    if (bgItemCollection != null) {
                        Iterator iterator = bgItemCollection.iterator();
                        this.kdtable.removeRows();
                        while (iterator.hasNext()) {
                            BgItemInfo bgItemInfo = (BgItemInfo)iterator.next();
                            IRow iRow = this.kdtable.addRow();
                            iRow.setUserObject((Object)bgItemInfo);
                            iRow.getCell("number").setValue((Object)bgItemInfo.getItemNumber());
                            iRow.getCell("name").setValue((Object)bgItemInfo.getItemName());
                            iRow.getCell("uom").setValue((Object)bgItemInfo.getMeasureUnit());
                        }
                    }
                    break block9;
                }
                String strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"pleaseSelectBgType");
                MsgBox.showWarning((Component)((Object)this), (String)strErr);
                return;
            }
            catch (BOSException e) {
                throw new IllegalComponentStateException(e.toString());
            }
        }
    }

    private ValidBgDimensionInfo getValidBgDimensionInfo(BgTypeInfo bgTypeInfo, String strDimNumber) {
        Iterator iterator = bgTypeInfo.getValidBgDimensions().iterator();
        List list = BgDimensionEnum.getEnumList();
        Iterator iter = list.iterator();
        BgDimensionEnum bgDimensionEnum = null;
        int value = new Integer(strDimNumber);
        while (iter.hasNext() && (bgDimensionEnum = (BgDimensionEnum)((Object)iter.next())).getValue() != value) {
        }
        if (bgDimensionEnum == null) {
            String strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"pleaseSelectDimension");
            MsgBox.showWarning((Component)((Object)this), (String)strErr);
            return null;
        }
        ValidBgDimensionInfo validBgDimensionInfo = null;
        while (iterator.hasNext() && (validBgDimensionInfo = (ValidBgDimensionInfo)iterator.next()).getBgDimension().getValue() != bgDimensionEnum.getValue()) {
        }
        return validBgDimensionInfo;
    }

    public FormulaWizardUI getFormulaWizardUI() {
        return this.formulaWizardUI;
    }

    public void setFormulaWizardUI(FormulaWizardUI wizardUI) {
        this.formulaWizardUI = wizardUI;
    }
}

