/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitCommon;
import com.kingdee.eas.basedata.org.OrgUnitCommonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.bg.BgAdjustFormFactory;
import com.kingdee.eas.ma.bg.BgCycleTypeEnum;
import com.kingdee.eas.ma.bg.BgEntryCollection;
import com.kingdee.eas.ma.bg.BgFormFactory;
import com.kingdee.eas.ma.bg.BgFormHelper;
import com.kingdee.eas.ma.bg.BgOrgHelper;
import com.kingdee.eas.ma.bg.BgPeriodNode;
import com.kingdee.eas.ma.bg.BgRollFormFactory;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.IBgAdjustForm;
import com.kingdee.eas.ma.bg.IBgForm;
import com.kingdee.eas.ma.bg.client.AbstractBgRollFormEditUI;
import com.kingdee.eas.ma.bg.client.BgClientHelper;
import com.kingdee.eas.ma.bg.client.BgFormEditHelper;
import com.kingdee.eas.ma.bg.client.BgSelectPeriodUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;

public class BgRollFormEditUI
extends AbstractBgRollFormEditUI {
    private String curLockId = null;
    private static final String RESOURCE = "com.kingdee.eas.ma.bg.client.BgRollFormResource";
    private IOrgUnitCommon com;
    private boolean onLoanded;

    @Override
    public void onLoad() throws Exception {
        this.actionSubmit.setBindWorkFlow(true);
        this.onLoanded = false;
        super.onLoad();
        this.com = OrgUnitCommonFactory.getRemoteInstance();
        this.onLoanded = true;
        this.separator1.setVisible(false);
        this.txtNumber.setEditable(false);
        this.canModify();
        String number = this.editData.getNumber();
        if (number.indexOf("V1.") == -1) {
            this.txtNumber.setText(number + "V1.1");
        } else {
            String[] result = number.split("V1.");
            int index = Integer.parseInt(result[1]);
            this.txtNumber.setText(result[0] + "V1." + (index + 1));
        }
        if ("EDIT".equals(this.getOprtState())) {
            this.curLockId = this.editData.getId().toString();
        }
        this.separator1.setVisible(true);
        this.separator3.setVisible(false);
    }

    @Override
    public boolean destroyWindow() {
        if (this.curLockId != null) {
            super.releaseObjectLock(this.curLockId);
        }
        return super.destroyWindow();
    }

    public String getUITitle() {
        return this.resHelper.getString("this.title");
    }

    @Override
    public void loadFields() {
        if (!this.oprtState.equals("ADDNEW")) {
            this.initPeriod();
        }
        BgFormEditHelper.loadFields(this);
        this.kdtBgFormData.getDataRequestManager().setDataRequestMode(0);
        this.kdtBgFormData.getMergeManager().setMergeMode(0);
        this.kdtBgFormData.getGroupManager().setGroup(true);
        if (!this.editData.getBgType().isIsRptBgForm()) {
            for (int i = 0; i < this.editData.getBgTemplate().getVisibleDims().size(); ++i) {
                this.kdtBgFormData.getColumn(i).setGroup(true);
                this.kdtBgFormData.getColumn(i).setMergeable(true);
            }
        }
    }

    public void initPeriod() {
        FullOrgUnitInfo orgInfo = this.editData.getOrgUnit();
        BgTemplateInfo bgTemInfo = this.editData.getBgTemplate();
        BgCycleTypeEnum cycle = bgTemInfo.getBgCycle();
        BgCycleTypeEnum rollCycle = bgTemInfo.getRollingBgCycle();
        CompanyOrgUnitInfo companyInfo = null;
        Object targetPeriod = null;
        try {
            IOrgUnitCommon iOrgUnitCommon = OrgUnitCommonFactory.getRemoteInstance();
            companyInfo = iOrgUnitCommon.getCompany(orgInfo.getId());
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        BgEntryCollection coll = this.editData.getBgEntries();
        Iterator iter = coll.iterator();
        PeriodInfo period1 = null;
        PeriodInfo period2 = null;
        try {
            period1 = BgRollFormFactory.getRemoteInstance().getFinalPeriod(this.editData.getId().toString(), rollCycle);
            int year = period1.getPeriodYear();
            int quarter = period1.getPeriodQuarter();
            int number = period1.getPeriodNumber();
            PeriodCollection pColl1 = PeriodUtils.getPeriodc((int)year, (CompanyOrgUnitInfo)companyInfo);
            PeriodCollection pColl2 = PeriodUtils.getPeriodc((int)year, (int)quarter, (CompanyOrgUnitInfo)companyInfo);
            int yLen = pColl1.size();
            int qLen = pColl2.size();
            if (rollCycle.equals((Object)BgCycleTypeEnum.Season)) {
                period2 = number + qLen > yLen ? PeriodUtils.getPeriodInfo((int)(year + 1), (int)1, (CompanyOrgUnitInfo)companyInfo) : PeriodUtils.getPeriodInfo((int)year, (int)(number + qLen), (CompanyOrgUnitInfo)companyInfo);
            } else if (rollCycle.equals((Object)BgCycleTypeEnum.Period)) {
                period2 = number + 1 > yLen ? PeriodUtils.getPeriodInfo((int)(year + 1), (int)1, (CompanyOrgUnitInfo)companyInfo) : PeriodUtils.getPeriodInfo((int)year, (int)(number + 1), (CompanyOrgUnitInfo)companyInfo);
            }
            if (period2 != null && period2.isIsAdjustPeriod()) {
                period2 = PeriodUtils.getNextPeriodInfo(period2);
            }
            if (period2 == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"noAddPeriod"));
                this.curLockId = this.editData.getId().toString();
                super.releaseObjectLock(this.curLockId);
                SysUtil.abort();
            }
            String orgUnitId = this.editData.getOrgUnit().getId().toString();
            String bgTypeId = this.editData.getBgType().getId().toString();
            int beginNumber = period1.getPeriodYear() * 100 + period1.getPeriodNumber();
            int endNumber = period2.getPeriodYear() * 100 + period2.getPeriodNumber();
            if (rollCycle.equals((Object)BgCycleTypeEnum.Season) && cycle.equals((Object)BgCycleTypeEnum.Period)) {
                PeriodInfo pp = PeriodUtils.getPeriodInfo((int)period2.getPeriodYear(), (int)(period2.getPeriodNumber() - 1), (CompanyOrgUnitInfo)companyInfo);
                if (pp == null) {
                    pp = PeriodUtils.getPeriodInfo((int)(period2.getPeriodYear() - 1), (int)PeriodUtils.getMaxPeriodNumber(null, (int)(period2.getPeriodYear() - 1), (IObjectPK)new ObjectUuidPK(companyInfo.getId())), (CompanyOrgUnitInfo)companyInfo);
                }
                beginNumber = pp.getPeriodYear() * 100 + pp.getPeriodNumber();
                PeriodCollection pc = PeriodUtils.getPeriodc((int)period2.getPeriodYear(), (int)period2.getPeriodQuarter(), (CompanyOrgUnitInfo)companyInfo);
                int last = pc.size();
                endNumber = pc.get(last - 1).getPeriodYear() * 100 + pc.get(last - 1).getPeriodNumber();
            }
            if (BgRollFormFactory.getRemoteInstance().checkAddedPeriod(this.editData.getId().toString(), orgUnitId, bgTypeId, beginNumber, endNumber)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"notRoll"));
                this.curLockId = this.editData.getId().toString();
                super.releaseObjectLock(this.curLockId);
                SysUtil.abort();
            }
            this.editData.addLostPeriod(companyInfo, period1, period2, cycle, rollCycle);
            this.editData.addPeriod(period1, period2, cycle, rollCycle);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (SQLException e) {
            this.handUIException(e);
        }
    }

    @Override
    public void actionRollSave_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        this.verifyInput(e);
        if (!BgFormHelper.checkBgFormValid(this.editData.getId().toString())) {
            SysUtil.abort();
        }
        IBgAdjustForm iBgAdjustForm = BgAdjustFormFactory.getRemoteInstance();
        this.editData.setHasEffected(true);
        this.editData.setCU(BgOrgHelper.getDefCU());
        iBgAdjustForm.adjust(this.editData);
        super.setSave(true);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_TemporarilySave_OK"));
        this.getUIWindow().close();
        BgClientHelper.refreshBgFormList((CoreUI)this);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        this.verifyInput(e);
        if (!BgFormHelper.checkBgFormValid(this.editData.getId().toString())) {
            SysUtil.abort();
        }
        IBgAdjustForm iBgAdjustForm = BgAdjustFormFactory.getRemoteInstance();
        this.editData.setHasEffected(true);
        this.bgForm = this.editData;
        this.bgForm.setCU(BgOrgHelper.getDefCU());
        ObjectUuidPK pk = (ObjectUuidPK)iBgAdjustForm.adjust(this.bgForm);
        this.bgForm.setId(BOSUuid.read((String)pk.toString()));
        if (this.wfContext.isBindWorkFlow()) {
            this.wfContext.getDataMap().clear();
            this.wfContext.addToDataMap((Object)pk.toString(), (IObjectValue)this.bgForm);
        }
        if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"confirmSubmit")) == 0) {
            IBgForm ibf = BgFormFactory.getRemoteInstance();
            ibf.submitRollBgFormWF(this.bgForm.getId());
        }
        super.setSave(true);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgAllApproveResource", (String)"HasSWF"));
        this.getUIWindow().close();
        BgClientHelper.refreshBgFormList((CoreUI)this);
    }

    @Override
    protected void treeBgPeriod_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeBgPeriod_valueChanged(e);
        BgPeriodNode bgPeriodNode = BgClientHelper.getCurrentBgPeriodNode(this.treeBgPeriod);
        if (bgPeriodNode == null) {
            return;
        }
        if (this.onLoanded) {
            if (this.com == null) {
                this.com = OrgUnitCommonFactory.getRemoteInstance();
            }
            Date nowDate = new Date(System.currentTimeMillis());
            BOSUuid id = this.com.getCompany(this.editData.getOrgUnit().getId()).getId();
            PeriodInfo period = PeriodUtils.getPeriodInfo((Date)nowDate, (IObjectPK)new ObjectUuidPK(id));
            int endNum = period.getPeriodNumber();
            int endQuarter = period.getPeriodQuarter();
            int endYear = period.getPeriodYear();
            int currNum = bgPeriodNode.getPeriod().getPeriodNumber();
            int currQuarter = bgPeriodNode.getPeriod().getPeriodQuarter();
            int currYear = bgPeriodNode.getPeriod().getPeriodYear();
            if (this.editData.getBgTemplate().getBgCycle().equals((Object)BgCycleTypeEnum.Period)) {
                if (endYear > currYear || endYear == currYear && endNum > currNum) {
                    this.kdtBgFormData.getStyleAttributes().setLocked(true);
                }
            } else if (this.editData.getBgTemplate().getBgCycle().equals((Object)BgCycleTypeEnum.Season)) {
                if (endYear > currYear || endYear == currYear && endQuarter > currQuarter) {
                    this.kdtBgFormData.getStyleAttributes().setLocked(true);
                }
            } else if (this.editData.getBgTemplate().getBgCycle().equals((Object)BgCycleTypeEnum.Year) && endYear > currYear) {
                this.kdtBgFormData.getStyleAttributes().setLocked(true);
            }
        }
    }

    public boolean canModify() throws Exception {
        int childCount = ((DefaultKingdeeTreeNode)this.treeBgPeriod.getLastSelectedPathComponent()).getChildCount();
        if (childCount > 0) {
            return true;
        }
        BgPeriodNode bgPeriodNode = BgClientHelper.getCurrentBgPeriodNode(this.treeBgPeriod);
        if (bgPeriodNode == null) {
            return false;
        }
        Date nowDate = new Date(System.currentTimeMillis());
        BOSUuid id = this.com.getCompany(this.editData.getOrgUnit().getId()).getId();
        PeriodInfo period = PeriodUtils.getPeriodInfo((Date)nowDate, (IObjectPK)new ObjectUuidPK(id));
        int endNum = period.getPeriodNumber();
        int endQuarter = period.getPeriodQuarter();
        int endYear = period.getPeriodYear();
        int currNum = bgPeriodNode.getPeriod().getPeriodNumber();
        int currQuarter = bgPeriodNode.getPeriod().getPeriodQuarter();
        int currYear = bgPeriodNode.getPeriod().getPeriodYear();
        if (this.editData.getBgTemplate().getBgCycle().equals((Object)BgCycleTypeEnum.Period)) {
            if ((endYear > currYear || endYear == currYear && endNum > currNum) && this.onLoanded) {
                this.kdtBgFormData.getStyleAttributes().setLocked(true);
                return false;
            }
        } else if (this.editData.getBgTemplate().getBgCycle().equals((Object)BgCycleTypeEnum.Season)) {
            if ((endYear > currYear || endYear == currYear && endQuarter > currQuarter) && this.onLoanded) {
                this.kdtBgFormData.getStyleAttributes().setLocked(true);
                return false;
            }
        } else if (this.editData.getBgTemplate().getBgCycle().equals((Object)BgCycleTypeEnum.Year) && endYear > currYear && this.onLoanded) {
            this.kdtBgFormData.getStyleAttributes().setLocked(true);
            return false;
        }
        return true;
    }

    @Override
    public void setIcon() {
        super.setIcon();
        this.btnRollSave.setIcon(EASResource.getIcon((String)"imgTbtn_temporarilysave"));
        this.btnRollSave.setText("");
        this.btnSubmit.setToolTipText(EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgAdjustFormResource", (String)"submit"));
    }

    @Override
    protected void kdtBgFormData_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2 && !this.canModify()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"notModify"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        if (this.txtName.getText().trim().equals("")) {
            this.txtName.requestFocus();
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"noName"));
            SysUtil.abort();
        }
        this.editData.setName(this.txtName.getText().trim());
        BgPeriodNode bgPeriodNode1 = BgClientHelper.getEndBgPeriodNode(this.treeBgPeriod);
        if (bgPeriodNode1 == null) {
            return;
        }
        Date nowDate = new Date(System.currentTimeMillis());
        BOSUuid id = this.com.getCompany(this.editData.getOrgUnit().getId()).getId();
        PeriodInfo period = PeriodUtils.getPeriodInfo((Date)nowDate, (IObjectPK)new ObjectUuidPK(id));
        int currentNumber = period.getPeriodNumber();
        int currentYear = period.getPeriodYear();
        int endNumber = bgPeriodNode1.getPeriod().getPeriodNumber();
        int endYear = bgPeriodNode1.getPeriod().getPeriodYear();
        if (endYear < currentYear || endYear == currentYear && endNumber < currentNumber) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"notImport"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"editData", (Object)this.editData);
        uiContext.put((Object)"treeBgPeriod", (Object)this.treeBgPeriod);
        uiContext.put((Object)"name", (Object)this.txtName.getText());
        uiContext.put((Object)"kdtBgFormData", (Object)this.kdtBgFormData);
        uiContext.put((Object)"periodNode", (Object)this.get2Period());
        uiContext.put((Object)"inOrOut", (Object)"in");
        uiContext.put((Object)"kindName", (Object)"bgValue");
        BgCycleTypeEnum cycle = this.editData.getBgTemplate().getBgCycle();
        uiContext.put((Object)"adjustYear", (Object)new Integer(period.getPeriodYear()));
        if (cycle.equals((Object)BgCycleTypeEnum.Period)) {
            uiContext.put((Object)"adjustPeriod", (Object)new Integer(period.getPeriodNumber()));
        } else if (cycle.equals((Object)BgCycleTypeEnum.Season)) {
            uiContext.put((Object)"adjustPeriod", (Object)new Integer(period.getPeriodQuarter()));
        } else if (cycle.equals((Object)BgCycleTypeEnum.Year)) {
            uiContext.put((Object)"adjustPeriod", (Object)new Integer(period.getPeriodYear()));
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgSelectPeriodUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        this.goLeaf();
    }
}

