/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.EASVerifyException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.bg.BgVerifyException;
import java.util.Iterator;
import java.util.List;

public class BgRptHelper {
    private BgRptHelper() {
    }

    public static void insertAmtCollPeriod(KDTable tblMain, String key, CurrencyCollection curs) {
        int index = tblMain.getColumnIndex(key);
        tblMain.getColumn(index).setKey(key + "_0");
        for (int i = 1; i < curs.size(); ++i) {
            IColumn col = tblMain.addColumn(index + i);
            col.setKey(key + "_" + i);
        }
        IRow headRow1 = tblMain.getHeadRow(1);
        IRow headRow2 = tblMain.getHeadRow(2);
        for (int i = 0; i < curs.size(); ++i) {
            headRow2.getCell(index + i).setValue((Object)curs.get(i).getName());
        }
        tblMain.getHeadMergeManager().mergeBlock(1, index, 1, index + curs.size() - 1);
    }

    public static void insertDimsColl(KDTable tblMain, List dimList, String key) {
        int i;
        int index = tblMain.getColumnIndex(key + "0");
        int size = dimList.size();
        for (i = 1; i < size; ++i) {
            IColumn col = tblMain.addColumn(index + i);
            col.setKey(key + i);
        }
        for (i = 0; i < size; ++i) {
            tblMain.getHeadRow(0).getCell(index + i).setValue(dimList.get(i));
            tblMain.getHeadMergeManager().mergeBlock(0, index + i, 2, index + i);
        }
        int n = dimList.size();
        for (i = 0; i < n; ++i) {
            tblMain.getColumn("bgItem" + i).setWidth(150);
        }
    }

    public static String getPeriodIDs(int year, int month, int year2, int month2, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        if (company == null) {
            throw new EASVerifyException(BgVerifyException.CHECKBLANK, new Object[]{"Company"});
        }
        PeriodCollection coll = null;
        PeriodInfo beginPeriod = PeriodUtils.getPeriodInfo((int)year, (int)month, (CompanyOrgUnitInfo)company);
        PeriodInfo endPeriod = PeriodUtils.getPeriodInfo((int)year2, (int)month2, (CompanyOrgUnitInfo)company);
        coll = PeriodUtils.getPeriodc((PeriodInfo)beginPeriod, (PeriodInfo)endPeriod, (CompanyOrgUnitInfo)company);
        StringBuffer sb = new StringBuffer();
        Iterator iter = coll.iterator();
        int i = 0;
        while (iter.hasNext()) {
            PeriodInfo period = (PeriodInfo)iter.next();
            sb.append("'" + period.getId().toString() + "',");
            ++i;
        }
        sb.append("''");
        return sb.toString();
    }

    public static String getIds(Object[] object) {
        StringBuffer sb = new StringBuffer();
        if (object != null) {
            int length = object.length;
            for (int i = 0; i < length; ++i) {
                CoreBaseInfo coreInfo = (CoreBaseInfo)object[i];
                if (coreInfo == null) continue;
                sb.append("'" + coreInfo.getId() + "',");
            }
        }
        sb.append("''");
        return sb.toString();
    }

    protected static void setStat(IColumn col) {
        col.setGroup(true);
        col.setMergeable(true);
        col.setStat(true);
    }
}

