/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.ma.bg.BgRptRowDirectionEnum;
import com.kingdee.eas.ma.bg.BgRptRowPrefixTypeEnum;
import com.kingdee.eas.ma.bg.BgRptRowTypeEnum;
import com.kingdee.eas.ma.bg.BgRptTemplateFormatEnum;
import com.kingdee.eas.ma.bg.BgRptTemplateInfo;
import com.kingdee.eas.ma.bg.BgRptTemplateRowInfo;
import com.kingdee.eas.ma.bg.BgRptTpHelper;
import com.kingdee.eas.ma.bg.BgTemplateException;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.util.Iterator;
import java.util.Vector;

public class BgRptTpEditHelper {
    public static void readBgRptRow(BgRptTemplateInfo editData, KDTable kdtBgRptTpRows) throws BgTemplateException {
        editData.getBgRptTpRows().clear();
        int size = kdtBgRptTpRows.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = kdtBgRptTpRows.getRow(i);
            BgRptTemplateRowInfo bgRptTpRowInfo = new BgRptTemplateRowInfo();
            bgRptTpRowInfo.setSeq(i + 1);
            if (row.getUserObject() != null) {
                bgRptTpRowInfo.setIsFromParent(((BgRptTemplateRowInfo)row.getUserObject()).isIsFromParent());
            } else {
                bgRptTpRowInfo.setIsFromParent(false);
            }
            ICell cell = row.getCell("number");
            if (cell.getValue() == null) {
                bgRptTpRowInfo.setNumber(String.valueOf(bgRptTpRowInfo.getSeq()));
            } else {
                bgRptTpRowInfo.setNumber(cell.getValue().toString());
            }
            cell = row.getCell("name");
            if (cell.getValue() == null) {
                MsgBox.showWarning((String)(EASResource.getString((String)"com.kingdee.eas.ma.bg.BgRptTpResource", (String)"MissName") + (i + 1) + EASResource.getString((String)"com.kingdee.eas.ma.bg.BgRptTpResource", (String)"MissName1")));
                SysUtil.abort();
            } else {
                bgRptTpRowInfo.setName(cell.getValue().toString());
            }
            BgRptRowTypeEnum type = (BgRptRowTypeEnum)((Object)row.getCell("type").getValue());
            if (type != null) {
                bgRptTpRowInfo.setType(type);
            }
            bgRptTpRowInfo.setPrefixType((BgRptRowPrefixTypeEnum)((Object)row.getCell("prefixType").getValue()));
            bgRptTpRowInfo.setPrefix(row.getCell("prefix").getValue() == null ? "" : row.getCell("prefix").getValue().toString());
            if (row.getCell("direction").getValue() != null) {
                bgRptTpRowInfo.setDirection((BgRptRowDirectionEnum)((Object)row.getCell("direction").getValue()));
            }
            Object formulaObject = null;
            formulaObject = type.getValue() == 3 ? row.getCell("formula").getUserObject() : (type.getValue() == 2 ? row.getCell("formula").getValue() : null);
            bgRptTpRowInfo.setFormula(formulaObject == null ? "" : formulaObject.toString());
            editData.getBgRptTpRows().add(bgRptTpRowInfo);
        }
    }

    private static String getTotalFormula(Vector vector) {
        int beginRow = (Integer)vector.get(0);
        int endRow = (Integer)vector.get(1);
        StringBuffer sb = new StringBuffer();
        for (int i = beginRow; i <= endRow; ++i) {
            sb.append("cell(" + String.valueOf(i) + ",?).getValue()");
            if (i == endRow) continue;
            sb.append("+");
        }
        return sb.toString();
    }

    public static void initKdtBgRptRow(BgRptTemplateInfo editData, KDTable kdtBgRptTpRows) {
        kdtBgRptTpRows.removeRows();
        Iterator iter = editData.getBgRptTpRows().iterator();
        while (iter.hasNext()) {
            BgRptTemplateRowInfo bgRptTpRowInfo = (BgRptTemplateRowInfo)iter.next();
            IRow row = kdtBgRptTpRows.addRow();
            row.setUserObject((Object)bgRptTpRowInfo);
            BgRptTpEditHelper.fillKdtBgRptRow(bgRptTpRowInfo, row);
        }
    }

    public static void fillKdtBgRptRow(BgRptTemplateRowInfo bgRptTpRowInfo, IRow row) {
        row.getCell("number").setValue((Object)bgRptTpRowInfo.getNumber());
        if (bgRptTpRowInfo.getNumber() != null && (bgRptTpRowInfo.getNumber().equals("TotalAssets") || bgRptTpRowInfo.getNumber().equals("TotalLiabilitiesAndEquity"))) {
            row.getCell("type").getStyleAttributes().setLocked(true);
        }
        row.getCell("name").setValue((Object)bgRptTpRowInfo.getName());
        row.getCell("type").setValue((Object)bgRptTpRowInfo.getType());
        BgRptTpEditHelper.onEditType(row, bgRptTpRowInfo.getType());
        row.getCell("prefixType").setValue((Object)bgRptTpRowInfo.getPrefixType());
        BgRptTpEditHelper.onEditPrifixType(row, bgRptTpRowInfo.getPrefixType());
        row.getCell("prefix").setValue((Object)bgRptTpRowInfo.getPrefix());
        row.getCell("direction").setValue((Object)bgRptTpRowInfo.getDirection());
        String formula = bgRptTpRowInfo.getFormula();
        if (formula != null && !formula.equals("")) {
            row.getCell("formula").setValue((Object)formula);
            row.getCell("formula").setUserObject((Object)formula);
        }
        if (bgRptTpRowInfo.isIsFromParent()) {
            row.getStyleAttributes().setLocked(true);
        }
    }

    public static void onEditPrifixType(IRow row, BgRptRowPrefixTypeEnum thePrefixType) {
        ICell prefixCell = row.getCell("prefix");
        if (thePrefixType.equals((Object)BgRptRowPrefixTypeEnum.Add) || thePrefixType.equals((Object)BgRptRowPrefixTypeEnum.Minus)) {
            prefixCell.setValue((Object)(" " + thePrefixType.getAlias() + ":"));
            prefixCell.getStyleAttributes().setLocked(true);
        } else if (thePrefixType.equals((Object)BgRptRowPrefixTypeEnum.None)) {
            row.getCell("prefix").setValue((Object)"");
            prefixCell.getStyleAttributes().setLocked(true);
        } else if (thePrefixType.equals((Object)BgRptRowPrefixTypeEnum.Other)) {
            row.getCell("prefix").setValue((Object)"");
            prefixCell.getStyleAttributes().setLocked(false);
        }
    }

    public static void onEditType(IRow row, BgRptRowTypeEnum bgRptRowType) {
        ICell formulaCell = row.getCell("formula");
        ICell directionCell = row.getCell("direction");
        if (bgRptRowType.equals((Object)BgRptRowTypeEnum.Common)) {
            formulaCell.setValue((Object)"");
            formulaCell.getStyleAttributes().setLocked(false);
            directionCell.setValue((Object)BgRptRowDirectionEnum.Positive);
            directionCell.getStyleAttributes().setLocked(false);
        }
        if (bgRptRowType.equals((Object)BgRptRowTypeEnum.Total)) {
            formulaCell.setValue((Object)BgRptTpHelper.number2TemplateDisplay("0", "0"));
            formulaCell.setUserObject(null);
            formulaCell.getStyleAttributes().setLocked(false);
            directionCell.setValue(null);
            directionCell.getStyleAttributes().setLocked(true);
        }
    }

    public static int getMaxRowCount(BgTypeInfo bgTypeInfo, BgRptTemplateFormatEnum bgRptTemplateFormatEnum) {
        int rowCount = 0;
        if (bgTypeInfo.getNumber().equals("IncomeStatementBudget")) {
            if (bgRptTemplateFormatEnum.getValue() == 1) {
                rowCount = 18;
            } else if (bgRptTemplateFormatEnum.getValue() == 2) {
                rowCount = 17;
            }
        } else if (bgRptTemplateFormatEnum.getValue() == 1) {
            rowCount = 63;
        } else if (bgRptTemplateFormatEnum.getValue() == 2) {
            rowCount = 67;
        }
        return rowCount;
    }

    public static void readKDSSheetData(KDTable kdtBgRptTpRows, BgTypeInfo bgTypeInfo, KDSSheet sheet) {
        int columnCount = 7;
        kdtBgRptTpRows.removeRows();
        String strName = null;
        Object strSpaceNumber = null;
        String strType = null;
        String strPrefixType = null;
        String strDirection = null;
        String strPre = null;
        String strFounula = null;
        String strNameSum = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgRptTpResource", (String)"TotalAssets");
        String strNameTotal = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgRptTpResource", (String)"TotalLiabilitiesAndEquity");
        for (int rowIndex = 1; rowIndex != -1 && !(strName = sheet.getCell(rowIndex, 1, false).getText()).equals(""); ++rowIndex) {
            String strNameTrim = strName.trim();
            IRow iRowTemp = kdtBgRptTpRows.addRow();
            BgRptTemplateRowInfo bgRptTpRowInfo = new BgRptTemplateRowInfo();
            if (bgTypeInfo.getNumber().equals("BalanceSheetBudget")) {
                if (strName.equals(strNameSum)) {
                    bgRptTpRowInfo.setNumber("TotalAssets");
                } else if (strName.equals(strNameTotal)) {
                    bgRptTpRowInfo.setNumber("TotalLiabilitiesAndEquity");
                }
            }
            bgRptTpRowInfo.setName(strName);
            strType = sheet.getCell(rowIndex, 2, false).getText().trim();
            if (!strType.equals("")) {
                for (BgRptRowTypeEnum bgRptRowTypeEnum : BgRptRowTypeEnum.getEnumList()) {
                    if (!strType.equals(bgRptRowTypeEnum.getAlias())) continue;
                    bgRptTpRowInfo.setType(bgRptRowTypeEnum);
                    break;
                }
            }
            if (!(strPrefixType = sheet.getCell(rowIndex, 3, false).getText().trim()).equals("")) {
                for (BgRptRowPrefixTypeEnum bgRptRowPrefixTypeEnum : BgRptRowPrefixTypeEnum.getEnumList()) {
                    if (!strPrefixType.equals(bgRptRowPrefixTypeEnum.getAlias())) continue;
                    bgRptTpRowInfo.setPrefixType(bgRptRowPrefixTypeEnum);
                    break;
                }
            }
            if (!(strPre = sheet.getCell(rowIndex, 4, false).getText().trim()).equals("")) {
                bgRptTpRowInfo.setPrefix(strPre);
            }
            if (!(strDirection = sheet.getCell(rowIndex, 5, false).getText().trim()).equals("")) {
                for (BgRptRowDirectionEnum bgRptRowDirectionEnum : BgRptRowDirectionEnum.getEnumList()) {
                    if (!strDirection.equals(bgRptRowDirectionEnum.getAlias())) continue;
                    bgRptTpRowInfo.setDirection(bgRptRowDirectionEnum);
                    break;
                }
            }
            if (!(strFounula = sheet.getCell(rowIndex, 6, false).getText().trim()).equals("")) {
                bgRptTpRowInfo.setFormula(strFounula);
            }
            BgRptTpEditHelper.fillKdtBgRptRow(bgRptTpRowInfo, iRowTemp);
        }
    }
}

