/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitCommon;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCommonFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.OrgClientUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.bg.AbstractBgTypeInfo;
import com.kingdee.eas.ma.bg.BgModelNodeCollection;
import com.kingdee.eas.ma.bg.BgModelNodeInfo;
import com.kingdee.eas.ma.bg.BgOrgHelper;
import com.kingdee.eas.ma.bg.BgSchemeException;
import com.kingdee.eas.ma.bg.BgSchemeFactory;
import com.kingdee.eas.ma.bg.BgSchemeInfo;
import com.kingdee.eas.ma.bg.BgTemplateCollection;
import com.kingdee.eas.ma.bg.BgTemplateFactory;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.BgTypeFactory;
import com.kingdee.eas.ma.bg.BgTypeHelper;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.IBgScheme;
import com.kingdee.eas.ma.bg.IBgTemplate;
import com.kingdee.eas.ma.bg.client.AbstractBgSchemeEditUI;
import com.kingdee.eas.ma.bg.client.BgClientHelper;
import com.kingdee.eas.ma.bg.client.BgFormulaEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class BgSchemeEditUI
extends AbstractBgSchemeEditUI {
    private CtrlUnitInfo orgCtrl = null;

    public BgSchemeEditUI() throws Exception {
        this.kdtBgModelNodes.putBindContents("editData", new String[]{"bgTemplate.id", "bgTemplate.number", "bgTemplate.name", "bgTemplate.bgType.name", "bgTemplate.creator.name", "bgTemplate.createTime"});
    }

    @Override
    public void loadFields() {
        if (this.editData == null) {
            return;
        }
        this.kdtBgModelNodes.checkParsed();
        if (this.getOprtState().equals("ADDNEW")) {
            FullOrgUnitInfo orgUintInfo = (FullOrgUnitInfo)this.getUIContext().get("EditOrg");
            this.orgCtrl = (CtrlUnitInfo)this.getUIContext().get("EditCtrlOrg");
            IOrgUnitCommon iOrgUnitCommon = null;
            CompanyOrgUnitInfo companyInfo = null;
            try {
                iOrgUnitCommon = OrgUnitCommonFactory.getRemoteInstance();
                companyInfo = iOrgUnitCommon.getCompany(orgUintInfo.getId());
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            if (orgUintInfo != null) {
                this.editData.setOrgUnit(orgUintInfo);
                this.editData.setCompany(companyInfo);
            }
        }
        this.txtNumber.setText(this.editData.getNumber());
        this.txtName.setText(this.editData.getName());
        this.chkIsFormal.setSelected(this.editData.isIsFormal());
        this.dataBinder.bindDataToTable(this.kdtBgModelNodes, (IObjectCollection)this.editData.getBgModelNodes());
        this.bizPromptOrgUnit.setData((Object)this.editData.getOrgUnit());
        Calendar calendar = Calendar.getInstance();
        int currYear = calendar.get(1);
        if (this.editData.getPeriodFrom() != null) {
            this.kDSpinnerStartYear.setValue((Object)new Integer(this.editData.getPeriodFrom().getPeriodYear()));
        } else {
            this.kDSpinnerStartYear.setValue((Object)new Integer(currYear));
        }
        if (this.editData.getPeriodFrom() != null) {
            this.kDSpinnerStartMonth.setValue((Object)new Integer(this.editData.getPeriodFrom().getPeriodNumber()));
        } else {
            this.kDSpinnerStartMonth.setValue((Object)new Integer(1));
        }
        if (this.editData.getPeriodTo() != null) {
            this.kDSpinnerEndYear.setValue((Object)new Integer(this.editData.getPeriodTo().getPeriodYear()));
        } else {
            this.kDSpinnerEndYear.setValue((Object)new Integer(currYear));
        }
        if (this.editData.getPeriodTo() != null) {
            this.kDSpinnerEndMonth.setValue((Object)new Integer(this.editData.getPeriodTo().getPeriodNumber()));
        } else {
            this.kDSpinnerEndMonth.setValue((Object)new Integer(2));
        }
        if (this.editData.getParentScheme() != null && this.editData.getParentScheme().getName() != null) {
            this.kDTextFieldParentScheme.setText(this.editData.getParentScheme().getName());
        }
        this.setSendDownSchemeEditStatus();
        this.setBtnEditFormulaState();
        if ("ADDNEW".equals(this.getOprtState())) {
            try {
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                String orgId = null;
                if (this.editData.getOrgUnit() != null && this.editData.getOrgUnit().getId() != null) {
                    orgId = this.editData.getOrgUnit().getId().toString();
                }
                if (orgId == null || orgId.equals("")) {
                    return;
                }
                String number = iCodingRuleManager.getNumber((IObjectValue)this.editData, orgId);
                this.txtNumber.setText(number);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    @Override
    public void storeFields() {
        int number;
        int year;
        if (this.editData == null) {
            return;
        }
        this.editData.setNumber(this.txtNumber.getText());
        this.editData.setName(this.txtName.getText());
        this.editData.setIsFormal(this.chkIsFormal.isSelected());
        this.dataBinder.bindTableToData(this.kdtBgModelNodes, (IObjectCollection)this.editData.getBgModelNodes());
        this.editData.setOrgUnit((OrgUnitInfo)this.bizPromptOrgUnit.getData());
        if (this.editData.getPeriodFrom() != null) {
            this.editData.getPeriodFrom().setPeriodYear(Integer.parseInt(this.kDSpinnerStartYear.getValue().toString()));
            this.editData.getPeriodFrom().setPeriodNumber(Integer.parseInt(this.kDSpinnerStartMonth.getValue().toString()));
        } else {
            year = Integer.parseInt(this.kDSpinnerStartYear.getValue().toString());
            number = Integer.parseInt(this.kDSpinnerStartMonth.getValue().toString());
            this.editData.setPeriodFrom(this.getPeroidInfo(year, number));
        }
        if (this.editData.getPeriodTo() != null) {
            this.editData.getPeriodTo().setPeriodYear(Integer.parseInt(this.kDSpinnerEndYear.getValue().toString()));
            this.editData.getPeriodTo().setPeriodNumber(Integer.parseInt(this.kDSpinnerEndMonth.getValue().toString()));
        } else {
            year = Integer.parseInt(this.kDSpinnerEndYear.getValue().toString());
            number = Integer.parseInt(this.kDSpinnerEndMonth.getValue().toString());
            this.editData.setPeriodTo(this.getPeroidInfo(year, number));
        }
        if (this.editData.getParentScheme() != null) {
            this.editData.getParentScheme().setName(this.kDTextFieldParentScheme.getText());
        }
        try {
            if (this.editData.getCompany() == null) {
                IOrgUnitCommon iOrgCommon = OrgUnitCommonFactory.getRemoteInstance();
                if (this.editData.getOrgUnit() != null) {
                    this.editData.setCompany(iOrgCommon.getCompany(this.editData.getOrgUnit().getId()));
                }
            }
            this.storePeriod();
        }
        catch (EASBizException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        catch (BOSException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
    }

    protected IObjectValue createNewDetailData() {
        BgModelNodeInfo bgModelNodeInfo = new BgModelNodeInfo();
        bgModelNodeInfo.setId(BOSUuid.create((BOSObjectType)bgModelNodeInfo.getBOSType()));
        return bgModelNodeInfo;
    }

    protected KDTable getDetailTable() {
        return this.kdtBgModelNodes;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(SysContext.getSysContext().getCurrentCtrlUnit().getId());
    }

    protected IObjectValue createNewData() {
        return new BgSchemeInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgSchemeFactory.getRemoteInstance();
    }

    @Override
    public void actionFormula_actionPerformed(ActionEvent e) throws Exception {
        int currRow = this.kdtBgModelNodes.getSelectManager().getActiveRowIndex();
        if (currRow == -1) {
            String strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"pleaseSelectedTemplate");
            MsgBox.showWarning((Component)((Object)this), (String)strErr);
            return;
        }
        IRow iRow = this.kdtBgModelNodes.getRow(currRow);
        BgModelNodeInfo bgModelNodeInfo = (BgModelNodeInfo)iRow.getUserObject();
        if (bgModelNodeInfo == null) {
            String strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"pleaseSelectedTemplate");
            MsgBox.showWarning((Component)((Object)this), (String)strErr);
            return;
        }
        this.showFormulaEditUI("EDIT");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initListener();
        OrgType[] CompanyType = new OrgType[]{OrgType.Company};
        OrgClientUtils.setOrgPrompt((IUIObject)this, (KDBizPromptBox)this.bizPromptOrgUnit, (OrgType[])CompanyType, (boolean)false);
        this.setWorkBtnEdit();
        if (this.editData != null && this.editData.getId() == null) {
            Calendar calendar = Calendar.getInstance();
            int currYear = calendar.get(1);
            this.kDSpinnerStartYear.setValue((Object)new Integer(currYear));
            this.kDSpinnerEndYear.setValue((Object)new Integer(currYear));
            IOrgUnitCommon iOrg = OrgUnitCommonFactory.getRemoteInstance();
            String orgUnitId = ((FullOrgUnitInfo)this.bizPromptOrgUnit.getData()).getId().toString();
            CompanyOrgUnitInfo info = iOrg.getCompany(BOSUuid.read((String)orgUnitId));
            int maxNumber = PeriodUtils.getMaxPeriodNumber(null, (int)currYear, (String)info.getId().toString());
            int currentNumber = PeriodUtils.getPeriodInfo((Date)new Date(System.currentTimeMillis()), (IObjectPK)new ObjectUuidPK(info.getId())).getPeriodNumber();
            SpinnerNumberModel model1 = new SpinnerNumberModel(new Integer(currentNumber), new Integer(1), null, new Integer(1));
            this.kDSpinnerStartMonth.setModel((SpinnerModel)model1);
            SpinnerNumberModel model2 = new SpinnerNumberModel(new Integer(maxNumber), new Integer(1), null, new Integer(1));
            this.kDSpinnerEndMonth.setModel((SpinnerModel)model2);
        }
        this.refreshTemplate();
        this.kdtBgModelNodes.getStyleAttributes().setLocked(true);
        this.setIcon();
        this.kdtBgModelNodes.getSelectManager().setSelectMode(2);
        if (this.oprtState.equals(OprtState.EDIT)) {
            this.setEditable();
            this.btnEdit.setVisible(false);
        }
    }

    public void setIcon() {
        this.btnEditFormula.setIcon(EASResource.getIcon((String)"imgTbtn_editformula"));
    }

    @Override
    protected void onBizPromptOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        FullOrgUnitInfo orgUnitInfo = (FullOrgUnitInfo)this.bizPromptOrgUnit.getData();
        this.editData.setOrgUnit(orgUnitInfo);
        IBgTemplate iBgTemplate = BgTemplateFactory.getRemoteInstance();
        BgTemplateCollection bgTempColl = iBgTemplate.getCollctionByOrgUnit(orgUnitInfo.getId().toString(), true);
        if (bgTempColl != null && bgTempColl.size() > 0) {
            BgModelNodeCollection bgNodeColl = new BgModelNodeCollection();
            Iterator iterator = bgTempColl.iterator();
            while (iterator.hasNext()) {
                BgTemplateInfo bgTemplateInfo = (BgTemplateInfo)iterator.next();
                BgModelNodeInfo bgNodeInfo = (BgModelNodeInfo)this.createNewDetailData();
                bgNodeInfo.setBgScheme(this.editData);
                bgNodeInfo.setBgTemplate(bgTemplateInfo);
                bgNodeColl.add(bgNodeInfo);
            }
            this.dataBinder.bindDataToTable(this.kdtBgModelNodes, (IObjectCollection)bgNodeColl);
            this.setBtnEditFormulaState();
        }
    }

    private void storePeriod() throws EASBizException, BOSException {
        ICompanyOrgUnit iCompanyOrgUnit;
        BOSUuid companyId = null;
        if (this.editData.getCompany() != null) {
            companyId = this.editData.getCompany().getId();
        }
        if (companyId == null && this.editData.getOrgUnit() != null) {
            companyId = BOSUuid.read((String)"");
            this.editData.setCompany(null);
        }
        if (companyId == null) {
            CompanyOrgUnitInfo companyOrgUnitInfo = BgClientHelper.getCompanyOrgUnitInfo();
            this.editData.setCompany(companyOrgUnitInfo);
        }
        PeriodInfo periodFrom = null;
        CompanyOrgUnitInfo companyOrgUnitInfo = this.editData.getCompany();
        if (!(companyOrgUnitInfo.getAccountPeriodType() != null || companyOrgUnitInfo.getAccountPeriodType() != null && companyOrgUnitInfo.getAccountPeriodType().getId() != null || (companyOrgUnitInfo = (iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance()).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyOrgUnitInfo.getId()))).getAccountPeriodType() != null && companyOrgUnitInfo.getAccountPeriodType().getId() != null)) {
            String strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"pleaseSetPeriodType");
            MsgBox.showWarning((Component)((Object)this), (String)strErr);
            SysUtil.abort();
        }
        periodFrom = PeriodUtils.getPeriodInfo((int)this.editData.getPeriodFrom().getPeriodYear(), (int)this.editData.getPeriodFrom().getPeriodNumber(), (CompanyOrgUnitInfo)this.editData.getCompany());
        PeriodInfo periodTo = null;
        periodTo = PeriodUtils.getPeriodInfo((int)this.editData.getPeriodTo().getPeriodYear(), (int)this.editData.getPeriodTo().getPeriodNumber(), (CompanyOrgUnitInfo)this.editData.getCompany());
        if (periodFrom == null) {
            this.kDSpinnerStartMonth.requestFocus(true);
            throw new BgSchemeException(BgSchemeException.BEGINPERIODERROR);
        }
        if (periodTo == null) {
            this.kDSpinnerEndMonth.requestFocus(true);
            throw new BgSchemeException(BgSchemeException.ENDPERIODERROR);
        }
        this.editData.setPeriodFrom(periodFrom);
        this.editData.setPeriodTo(periodTo);
    }

    public void showFormulaEditUI(String oprtState) throws UIException {
        UIContext uiContext = new UIContext((Object)this);
        int currRow = this.kdtBgModelNodes.getSelectManager().getActiveRowIndex();
        IRow iRow = this.kdtBgModelNodes.getRow(currRow);
        BgModelNodeInfo bgNodeInfo = (BgModelNodeInfo)iRow.getUserObject();
        if (bgNodeInfo != null) {
            uiContext.put((Object)"ID", (Object)bgNodeInfo);
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, oprtState);
        uiWindow.show();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected String getEditUIName() {
        return BgFormulaEditUI.class.getName();
    }

    private void setBtnEditFormulaState() {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.btnEditFormula.setEnabled(false);
        } else {
            int rowCount = this.kdtBgModelNodes.getRowCount();
            if (rowCount <= 0) {
                this.btnEditFormula.setEnabled(false);
            } else {
                this.btnEditFormula.setEnabled(true);
            }
        }
    }

    protected PeriodInfo getPeroidInfo(int year, int number) {
        PeriodInfo periodInfoFrom = new PeriodInfo();
        periodInfoFrom.setPeriodYear(year);
        periodInfoFrom.setPeriodNumber(number);
        return periodInfoFrom;
    }

    public boolean isModify() {
        return false;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        String strErr;
        String strErr2;
        super.verifyInput(e);
        if (this.txtNumber.getText().trim().equals("")) {
            strErr2 = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"noNumber");
            this.txtNumber.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)strErr2);
            SysUtil.abort();
        }
        if (this.txtName.getText().trim().equals("")) {
            strErr2 = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"noName");
            this.txtName.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)strErr2);
            SysUtil.abort();
        }
        int yearFrom = this.editData.getPeriodFrom().getPeriodYear();
        int numberFrom = this.editData.getPeriodFrom().getPeriodNumber();
        int yearTo = this.editData.getPeriodTo().getPeriodYear();
        int numberTo = this.editData.getPeriodTo().getPeriodNumber();
        if (yearFrom > yearTo || yearFrom == yearTo && numberFrom > numberTo) {
            strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"startPeriodNotBiggerEntPeriod");
            this.kDSpinnerStartMonth.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)strErr);
            SysUtil.abort();
        }
        if (this.editData.getOrgUnit() == null) {
            strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"pleaseSelectOrgUnit");
            this.bizPromptOrgUnit.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)strErr);
            SysUtil.abort();
        }
    }

    protected void setWorkBtnEdit() {
        this.bizPromptOrgUnit.setEnabled(false);
    }

    protected void refreshTemplate() throws EASBizException {
        BgTemplateCollection bgTemplateCollection = this.findValidBgTemplate();
        BgModelNodeCollection bgModelNodeCollection = new BgModelNodeCollection();
        Iterator iteratorTemp = bgTemplateCollection.iterator();
        while (iteratorTemp.hasNext()) {
            BgTemplateInfo bgTemplateInfo = (BgTemplateInfo)iteratorTemp.next();
            boolean isExit = this.isExistBgTemplate(this.editData.getBgModelNodes(), bgTemplateInfo);
            if (!isExit) {
                BgModelNodeInfo bgModelNodeInfo = (BgModelNodeInfo)this.createNewDetailData();
                bgModelNodeInfo.setBgScheme(this.editData);
                bgModelNodeInfo.setBgTemplate(bgTemplateInfo);
                bgModelNodeCollection.add(bgModelNodeInfo);
                continue;
            }
            Iterator iterator = this.editData.getBgModelNodes().iterator();
            while (iterator.hasNext()) {
                BgModelNodeInfo bgModelNodeInfo = (BgModelNodeInfo)iterator.next();
                if (!bgModelNodeInfo.getBgTemplate().getId().equals((Object)bgTemplateInfo.getId())) continue;
                bgModelNodeCollection.add(bgModelNodeInfo);
            }
        }
        this.editData.getBgModelNodes().clear();
        this.editData.getBgModelNodes().addCollection(bgModelNodeCollection);
        this.dataBinder.bindDataToTable(this.kdtBgModelNodes, (IObjectCollection)this.editData.getBgModelNodes());
    }

    public BgTemplateCollection findValidBgTemplate() throws EASBizException {
        BgTemplateCollection bgTemplateCollection = new BgTemplateCollection();
        try {
            IBgTemplate iBgTemplate = BgTemplateFactory.getRemoteInstance();
            boolean isValid = true;
            bgTemplateCollection = iBgTemplate.getCollctionByOrgUnit(this.editData.getOrgUnit().getId().toString(), isValid);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return bgTemplateCollection;
    }

    protected boolean isExistBgTemplate(BgModelNodeCollection bgModelNodeCollection, BgTemplateInfo bgTemplateInfo) {
        Iterator iteratorNode = bgModelNodeCollection.iterator();
        while (iteratorNode.hasNext()) {
            BgModelNodeInfo bgModelNodeInfo = (BgModelNodeInfo)iteratorNode.next();
            if (!bgModelNodeInfo.getBgTemplate().getId().equals((Object)bgTemplateInfo.getId())) continue;
            return true;
        }
        return false;
    }

    private void setBtnEditFormulaState(BgTemplateInfo bgTemplateInfo) {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            return;
        }
        BgTypeInfo bgTypeInfo = bgTemplateInfo.getBgType();
        if (bgTypeInfo != null) {
            AbstractBgTypeInfo info = null;
            try {
                info = BgTypeFactory.getRemoteInstance().getBgTypeInfo("select isRptBgForm where id='" + bgTypeInfo.getId().toString() + "'");
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            boolean isRptBudget = info == null ? false : info.isIsRptBgForm();
            System.out.println("\u662f\u5426\u662f:" + isRptBudget);
            if (isRptBudget) {
                this.btnEditFormula.setEnabled(false);
            } else {
                this.btnEditFormula.setEnabled(true);
            }
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.setOprtState(OprtState.EDIT);
        if (this.editData.getId() == null) {
            this.editData.setId(BOSUuid.create((BOSObjectType)this.editData.getBOSType()));
        }
        if (this.orgCtrl == null) {
            this.orgCtrl = BgOrgHelper.getDefCU();
        }
        this.editData.setCU(this.orgCtrl);
        super.actionSubmit_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isFormal"));
        sic.add(new SelectorItemInfo("bgModelNodes.bgTemplate.createTime"));
        sic.add(new SelectorItemInfo("bgModelNodes.bgTemplate.bgType.name"));
        sic.add(new SelectorItemInfo("bgModelNodes.bgTemplate.number"));
        sic.add(new SelectorItemInfo("bgModelNodes.bgTemplate.creator.name"));
        sic.add(new SelectorItemInfo("bgModelNodes.bgTemplate.name"));
        sic.add(new SelectorItemInfo("bgModelNodes.bgTemplate.id"));
        sic.add(new SelectorItemInfo("periodTo.periodYear"));
        sic.add(new SelectorItemInfo("periodTo.periodNumber"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("orgUnit"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("periodFrom.periodYear"));
        sic.add(new SelectorItemInfo("periodFrom.periodNumber"));
        sic.add(new SelectorItemInfo("parentScheme"));
        sic.add(new SelectorItemInfo("parentScheme.name"));
        return sic;
    }

    public void setSendDownSchemeEditStatus() {
        if (this.editData.getParentScheme() != null) {
            this.kDSpinnerStartYear.setEnabled(false);
            this.kDSpinnerStartMonth.setEnabled(false);
            this.kDSpinnerEndYear.setEnabled(false);
            this.kDSpinnerEndMonth.setEnabled(false);
            this.bizPromptOrgUnit.setEnabled(false);
        }
        boolean isUsed = false;
        try {
            IBgScheme ibt = BgSchemeFactory.getRemoteInstance();
            if (this.editData.getId() != null) {
                isUsed = ibt.isUsedBgScheme(this.editData.getId());
            }
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        if (isUsed) {
            this.kDSpinnerStartYear.setEnabled(false);
            this.kDSpinnerStartMonth.setEnabled(false);
            this.kDSpinnerEndYear.setEnabled(false);
            this.kDSpinnerEndMonth.setEnabled(false);
            this.bizPromptOrgUnit.setEnabled(false);
            this.chkIsFormal.setEnabled(false);
        }
    }

    @Override
    protected void onkdtBgModelNodes_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            int rowIndex = this.kdtBgModelNodes.getSelectManager().getActiveRowIndex();
            IRow iRow = this.kdtBgModelNodes.getRow(rowIndex);
            if (iRow == null) {
                return;
            }
            BgModelNodeInfo bgModelNodeInfo = (BgModelNodeInfo)iRow.getUserObject();
            if (bgModelNodeInfo == null) {
                return;
            }
            BgTypeInfo bgTypeInfo = bgModelNodeInfo.getBgTemplate().getBgType();
            if (bgTypeInfo != null) {
                boolean isRptBudget = BgTypeHelper.isRptBudget(bgTypeInfo);
                if (isRptBudget) {
                    String strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"RPTTemplateNotViewFormula");
                    MsgBox.showConfirm2((Component)((Object)this), (String)strErr);
                    return;
                }
                this.showFormulaEditUI("VIEW");
            }
        }
    }

    @Override
    protected void onkdtBgModelNodes_tableSelectChanged(KDTSelectEvent e) throws Exception {
        int rowIndex = this.kdtBgModelNodes.getSelectManager().getActiveRowIndex();
        IRow iRow = this.kdtBgModelNodes.getRow(rowIndex);
        BgModelNodeInfo bgModelNodeInfo = (BgModelNodeInfo)iRow.getUserObject();
        if (bgModelNodeInfo != null) {
            this.setBtnEditFormulaState(bgModelNodeInfo.getBgTemplate());
        }
    }

    public boolean checkBeforeWindowClosing() {
        return true;
    }

    public void actionEdit_actionPerformed(ActionEvent arg0) throws Exception {
        super.actionEdit_actionPerformed(arg0);
        this.bizPromptOrgUnit.setEnabled(false);
        this.chkIsFormal.setEnabled(false);
        this.kDSpinnerStartYear.setEnabled(false);
        this.kDSpinnerStartMonth.setEnabled(false);
        this.kDSpinnerEndYear.setEnabled(false);
        this.kDSpinnerEndMonth.setEnabled(false);
        this.setEditable();
    }

    private void setEditable() throws Exception {
        BOSUuid id;
        IBgScheme ibt = BgSchemeFactory.getRemoteInstance();
        if (ibt.isUsedBgScheme(id = this.editData.getId())) {
            this.btnEditFormula.setEnabled(false);
        }
    }
}

