/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.bg.BgCycleTypeEnum;
import com.kingdee.eas.ma.bg.BgPeriodNode;
import com.kingdee.eas.ma.bg.BgSplitFactory;
import com.kingdee.eas.ma.bg.IBgSplit;
import com.kingdee.eas.ma.bg.client.AbstractBgSetSplitRateUI;
import com.kingdee.eas.ma.bg.client.BgClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;

public class BgSetSplitRateUI
extends AbstractBgSetSplitRateUI {
    private boolean isCancel = false;
    private IBgSplit ibs;
    private String bgFormId;
    private BgCycleTypeEnum sourceCycle;
    private BigDecimal[][] scale;
    private PeriodCollection pc;
    private PeriodCollection[] subPc;
    private BgCycleTypeEnum targetBgCycle;
    private int[][] checkYearSeason;
    private int beginYear;
    private int beginNumber;
    private int endYear;
    private int endNumber;

    @Override
    public void loadFields() {
        super.loadFields();
        this.initTable();
    }

    public void initTable() {
        this.tblMain.removeHeadRows();
        this.tblMain.removeRows();
        this.tblMain.removeColumns();
        IColumn col1 = this.tblMain.addColumn();
        col1.setKey("period");
        col1.getStyleAttributes().setLocked(true);
        IColumn col2 = this.tblMain.addColumn();
        col2.setKey("scale");
        IColumn col3 = this.tblMain.addColumn();
        col3.setKey("x");
        col3.getStyleAttributes().setHided(true);
        col3.getStyleAttributes().setLocked(true);
        IColumn col4 = this.tblMain.addColumn();
        col4.setKey("y");
        col4.getStyleAttributes().setHided(true);
        col4.getStyleAttributes().setLocked(true);
        IRow mainHeadRow1 = this.tblMain.addHeadRow();
        mainHeadRow1.getCell("period").setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSplitResource", (String)"Period"));
        mainHeadRow1.getCell("scale").setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSplitResource", (String)"Scale"));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadFields();
        this.beginYear = (Integer)this.getUIContext().get("beginYear");
        this.beginNumber = (Integer)this.getUIContext().get("beginNumber");
        this.endYear = (Integer)this.getUIContext().get("endYear");
        this.endNumber = (Integer)this.getUIContext().get("endNumber");
        this.sourceCycle = (BgCycleTypeEnum)((Object)this.getUIContext().get("sourceCycle"));
        this.sourceCycleText.setText(this.sourceCycle.getAlias(SysContext.getSysContext().getLocale()));
        this.initTargetCycle(this.sourceCycle);
        this.bgFormId = (String)this.getUIContext().get("bgFormId");
        this.ibs = BgSplitFactory.getRemoteInstance();
        this.pc = this.ibs.getBgPeriods(this.bgFormId, this.sourceCycle);
        int size = this.pc.size();
        if (size == 0) {
            if (this.sourceCycle.equals((Object)BgCycleTypeEnum.Year)) {
                this.pc = this.ibs.getBgPeriods(this.bgFormId, BgCycleTypeEnum.Season);
                size = this.pc.size();
                if (size == 0) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSplitResource", (String)"NotSplit3"));
                    SysUtil.abort();
                } else {
                    this.targetCycleComBo.setSelectedIndex(1);
                    this.targetCycleComBo.setEnabled(false);
                    this.sourceCycle = BgCycleTypeEnum.Season;
                    this.pc = this.ibs.getBgPeriods(this.bgFormId, BgCycleTypeEnum.Season);
                }
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSplitResource", (String)"NotSplit3"));
                SysUtil.abort();
            }
        }
        this.subPc = new PeriodCollection[size];
        this.checkYearSeason = new int[size][2];
        this.scale = new BigDecimal[this.pc.size()][];
        this.targetBgCycle = (BgCycleTypeEnum)((Object)this.targetCycleComBo.getItemAt(this.targetCycleComBo.getSelectedIndex()));
        int flagYear = 0;
        int flagSeason = 0;
        boolean isAddSeason = this.sourceCycle.equals((Object)BgCycleTypeEnum.Year) && this.targetBgCycle.equals((Object)BgCycleTypeEnum.Period);
        this.initTableArea(size, flagYear, flagSeason, isAddSeason);
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        super.tblMain_editStopped(e);
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        if (colIndex == 1 && this.tblMain.getRow(rowIndex).getCell(colIndex).getValue() != null) {
            String value = ((String)this.tblMain.getRow(rowIndex).getCell(colIndex).getValue()).trim();
            if (!BgClientHelper.verifyIsNumber(value)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"inputNumber"));
                this.tblMain.getEditManager().editCellAt(rowIndex, colIndex);
                this.tblMain.getRow(rowIndex).getCell(colIndex).setValue((Object)new BigDecimal("0"));
                return;
            }
            if (!BgClientHelper.verifyIsPlus1(value)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"inputPlus"));
                this.tblMain.getEditManager().editCellAt(rowIndex, colIndex);
                return;
            }
        }
    }

    public void initTableArea(int size, int flagYear, int flagSeason, boolean isAddSeason) throws BOSException, EASBizException {
        for (int i = 0; i < size; ++i) {
            BgPeriodNode node;
            IRow row;
            PeriodInfo period = this.pc.get(i);
            if (this.sourceCycle.equals((Object)BgCycleTypeEnum.Season) && flagYear != period.getPeriodYear()) {
                flagYear = period.getPeriodYear();
                row = this.tblMain.addRow();
                node = new BgPeriodNode();
                node.setBgCycle(BgCycleTypeEnum.Year);
                node.setPeriod(period);
                row.getCell("period").setValue((Object)node);
                row.getCell("scale").getStyleAttributes().setLocked(true);
                row.getStyleAttributes().setBackground(Color.YELLOW);
            }
            row = this.tblMain.addRow();
            node = new BgPeriodNode();
            node.setBgCycle(this.sourceCycle);
            node.setPeriod(period);
            row.getCell("period").setValue((Object)("    " + node));
            row.getCell("scale").getStyleAttributes().setLocked(true);
            row.getStyleAttributes().setBackground(Color.YELLOW);
            this.subPc[i] = this.ibs.getBgPeriods(period.getId().toString(), this.sourceCycle, this.targetBgCycle, period.getPeriodYear(), period.getPeriodQuarter(), this.beginYear, this.beginNumber, this.endYear, this.endNumber);
            this.checkYearSeason[i][0] = period.getPeriodYear();
            this.checkYearSeason[i][1] = period.getPeriodQuarter();
            int subSize = this.subPc[i].size();
            this.scale[i] = new BigDecimal[subSize];
            for (int j = 0; j < subSize; ++j) {
                PeriodInfo subPeriod;
                BgPeriodNode subNode;
                IRow subRow;
                if (isAddSeason && flagSeason != this.subPc[i].get(j).getPeriodQuarter()) {
                    flagSeason = this.subPc[i].get(j).getPeriodQuarter();
                    subRow = this.tblMain.addRow();
                    subNode = new BgPeriodNode();
                    subNode.setBgCycle(BgCycleTypeEnum.Season);
                    subPeriod = this.subPc[i].get(j);
                    subNode.setPeriod(subPeriod);
                    subRow.getCell("period").setValue((Object)("      " + subNode));
                    subRow.getCell("scale").getStyleAttributes().setLocked(true);
                    subRow.getStyleAttributes().setBackground(Color.YELLOW);
                }
                subRow = this.tblMain.addRow();
                subNode = new BgPeriodNode();
                subNode.setBgCycle((BgCycleTypeEnum)((Object)this.targetCycleComBo.getItemAt(this.targetCycleComBo.getSelectedIndex())));
                subPeriod = this.subPc[i].get(j);
                subNode.setPeriod(subPeriod);
                subRow.getCell("period").setValue((Object)("        " + subNode));
                subRow.getCell("x").setValue((Object)new Integer(i));
                subRow.getCell("y").setValue((Object)new Integer(j));
            }
        }
    }

    public void initTargetCycle(BgCycleTypeEnum sourceCycle) {
        this.targetCycleComBo.setEnabled(false);
        if (sourceCycle.equals((Object)BgCycleTypeEnum.Year)) {
            this.targetCycleComBo.addItem((Object)BgCycleTypeEnum.Season);
            this.targetCycleComBo.addItem((Object)BgCycleTypeEnum.Period);
            this.targetCycleComBo.setSelectedIndex(0);
            this.targetCycleComBo.setEnabled(true);
        } else if (sourceCycle.equals((Object)BgCycleTypeEnum.Season)) {
            this.targetCycleComBo.addItem((Object)BgCycleTypeEnum.Period);
            this.targetCycleComBo.setSelectedIndex(0);
            this.targetCycleComBo.setEnabled(false);
        }
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        this.storeScale();
        this.checkScale();
        this.getUIWindow().close();
    }

    public void storeScale() {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            BigDecimal rate;
            IRow row = this.tblMain.getRow(i);
            if (row.getCell("x").getValue() == null) continue;
            int x = (Integer)row.getCell("x").getValue();
            int y = (Integer)row.getCell("y").getValue();
            String value = (String)row.getCell("scale").getValue();
            this.verifyInput(value, i);
            this.scale[x][y] = rate = new BigDecimal(value);
        }
    }

    private void verifyInput(String value, int i) {
        if (value == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSplitResource", (String)"inputScale"));
            this.tblMain.getEditManager().editCellAt(i, 1);
            SysUtil.abort();
        }
        if (!BgClientHelper.verifyIsNumber(value)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"inputNumber"));
            this.tblMain.getEditManager().editCellAt(i, 1);
            SysUtil.abort();
        }
        if (!BgClientHelper.verifyIsPlus1(value)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"inputPlus"));
            this.tblMain.getEditManager().editCellAt(i, 1);
            SysUtil.abort();
        }
    }

    private void checkScale() {
        int xSize = this.scale.length;
        for (int i = 0; i < xSize; ++i) {
            int ySize = this.scale[i].length;
            float value = 0.0f;
            for (int j = 0; j < ySize; ++j) {
                value += this.scale[i][j].floatValue();
            }
            if ((double)Math.abs(value - 100.0f) < 9.9E-324) continue;
            String dataStr = this.checkYearSeason[i][0] + EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSplitResource", (String)"Year");
            if (this.sourceCycle.equals((Object)BgCycleTypeEnum.Season) && this.targetBgCycle.equals((Object)BgCycleTypeEnum.Period)) {
                dataStr = dataStr + this.checkYearSeason[i][1] + EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSplitResource", (String)"Season") + "\uff0c";
            }
            MsgBox.showWarning((Component)((Object)this), (String)(dataStr + EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSplitResource", (String)"errorScale")));
            SysUtil.abort();
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCancel = true;
        this.getUIWindow().close();
    }

    public PeriodCollection getPc() {
        return this.pc;
    }

    public BigDecimal[][] getScale() {
        return this.scale;
    }

    public PeriodCollection[] getSubPc() {
        return this.subPc;
    }

    public BgCycleTypeEnum getTargetBgCycle() {
        return this.targetBgCycle;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    @Override
    protected void targetCycleComBo_itemStateChanged(ItemEvent e) throws Exception {
        super.onLoad();
        if (!this.targetCycleComBo.isEnabled()) {
            return;
        }
        this.tblMain.removeRows();
        this.pc = this.ibs.getBgPeriods(this.bgFormId, this.sourceCycle);
        int size = this.pc.size();
        this.subPc = new PeriodCollection[size];
        this.checkYearSeason = new int[size][2];
        this.scale = new BigDecimal[this.pc.size()][];
        this.targetBgCycle = (BgCycleTypeEnum)((Object)this.targetCycleComBo.getItemAt(this.targetCycleComBo.getSelectedIndex()));
        int flagYear = 0;
        int flagSeason = 0;
        boolean isAddSeason = this.sourceCycle.equals((Object)BgCycleTypeEnum.Year) && this.targetBgCycle.equals((Object)BgCycleTypeEnum.Period);
        this.initTableArea(size, flagYear, flagSeason, isAddSeason);
    }

    public BgCycleTypeEnum getSourceCycle() {
        return this.sourceCycle;
    }
}

