/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitCommon;
import com.kingdee.eas.basedata.org.OrgUnitCommonFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.ma.bg.BgCtrlTypeEnum;
import com.kingdee.eas.ma.bg.BgCycleTypeEnum;
import com.kingdee.eas.ma.bg.BgDimensionEnum;
import com.kingdee.eas.ma.bg.BgElementInfo;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.BgItemCollection;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.eas.ma.bg.BgMethodEnum;
import com.kingdee.eas.ma.bg.BgORMEngine;
import com.kingdee.eas.ma.bg.BgOrgHelper;
import com.kingdee.eas.ma.bg.BgTemplateColumnCollection;
import com.kingdee.eas.ma.bg.BgTemplateColumnInfo;
import com.kingdee.eas.ma.bg.BgTemplateDAFactory;
import com.kingdee.eas.ma.bg.BgTemplateFactory;
import com.kingdee.eas.ma.bg.BgTemplateHelper;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.BgTemplateRowInfo;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.IBgTemplate;
import com.kingdee.eas.ma.bg.IBgTemplateDA;
import com.kingdee.eas.ma.bg.ReferencedCurrencyInfo;
import com.kingdee.eas.ma.bg.ReferencedDimensionCollection;
import com.kingdee.eas.ma.bg.ReferencedDimensionInfo;
import com.kingdee.eas.ma.bg.client.AbstractBgTemplateEdit;
import com.kingdee.eas.ma.bg.client.BgClientHelper;
import com.kingdee.eas.ma.bg.client.BgElementFormulaUI;
import com.kingdee.eas.ma.bg.client.BgItemHelperFactory;
import com.kingdee.eas.ma.bg.client.BgTemplateEditHelper;
import com.kingdee.eas.ma.bg.client.IBgItemHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;

public class BgTemplateEdit
extends AbstractBgTemplateEdit {
    private boolean isBgItemOld = false;
    private boolean isBgTpRowOld = false;
    private boolean save = false;
    boolean isAssignedFormUpper = false;
    boolean isRefByForm = false;
    boolean isRefByChild = false;
    Hashtable itemsCountTable;
    Hashtable bgTpRowTable;
    String[] ormObject = new String[]{"dim", "item", "refcur", "tpcol", "tprow"};
    List deleteBgItemList = new ArrayList();
    List deleteRefBgItemList = new ArrayList();
    List deleteBgTpCList = new ArrayList();
    List deleteBgTpRList = new ArrayList();
    List deleteRefCur = new ArrayList();
    String[] mainPropertyAry = new String[]{"name", "number", "bgCycle", "rollingBgCycle", "isCurrent", "bgMethod", "bgCtrlType"};
    String[] itemPropertyAry = new String[]{"isLeaf"};
    String[] refDimPropertyAry = new String[]{"seq", "isPrimary"};
    String[] refCurPropertyAry = new String[0];
    String[] bgTpCPropertyAry = new String[]{"isControlled", "formula"};
    String[] bgTpRPropertyAry = new String[]{"bgControlType", "isFlexibleCtrl", "flexibleBgCtrlParam"};

    protected IObjectValue createNewData() {
        return new BgTemplateInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgTemplateFactory.getRemoteInstance();
    }

    @Override
    public void loadFields() {
        try {
            this.beforeLoadFields();
        }
        catch (BOSException e1) {
            this.handUIException(e1);
            SysUtil.abort();
        }
        try {
            super.loadFields();
        }
        catch (Exception e) {
            e.getMessage();
        }
        try {
            this.afterLoadFields();
        }
        catch (EASBizException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        catch (BOSException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        this.kdtRefDimensions.getColumn("seq").getStyleAttributes().setLocked(true);
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.kdtBgItem.getStyleAttributes().setLocked(true);
            this.kdtBgTpColumns.getStyleAttributes().setLocked(true);
            this.kdtBgTpRows.getStyleAttributes().setLocked(true);
            this.kdtRefDimensions.getStyleAttributes().setLocked(true);
            this.bizPromptBoxCurrency.setEnabled(false);
            this.comboBoxBgCtrlType.setEnabled(false);
            this.comboBoxBgCycle.setEnabled(false);
            this.comboBoxBgMethod.setEnabled(false);
            this.comboBoxRollingBgCycle.setEnabled(false);
            this.txtName.setEnabled(false);
            this.btnAddColumn.setEnabled(false);
            this.btnDeleteColumn.setEnabled(false);
            this.btnAddBgItem.setEnabled(false);
            this.btnDeleteBgItem.setEnabled(false);
            this.btnAddDimension.setEnabled(false);
            this.btnDeleteDimension.setEnabled(false);
        }
    }

    protected void beforeLoadFields() throws BOSException {
        this.bizPromptBoxCurrency.setEnabledMultiSelection(true);
        this.kdtBgItem.checkParsed();
        this.kdtBgTpColumns.checkParsed();
        this.kdtBgTpRows.checkParsed();
        this.kdtRefDimensions.checkParsed();
        this.comboBoxRollingBgCycle.removeAllItems();
        this.comboBoxRollingBgCycle.addItem((Object)BgCycleTypeEnum.Season);
        this.comboBoxRollingBgCycle.addItem((Object)BgCycleTypeEnum.Period);
        if (this.getOprtState().equals(OprtState.EDIT)) {
            this.btnEdit.setVisible(false);
        }
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.btnEdit.setVisible(true);
            this.btnEdit.setEnabled(true);
        }
        if (this.getOprtState().equals("EDIT")) {
            this.dealRef();
        }
    }

    private void afterLoadFields() throws EASBizException, BOSException {
        this.kDTabbedPane.setEnabledAt(1, false);
        this.kDTabbedPane.setEnabledAt(2, false);
        this.kDTabbedPane.setEnabledAt(3, false);
        this.kDTabbedPane.setEnabledAt(4, false);
        this.kdtBgTpColumns.getSelectManager().setSelectMode(2);
        this.kdtRefDimensions.getSelectManager().setSelectMode(2);
        this.kdtBgItem.getSelectManager().setSelectMode(10);
        this.kdtBgTpRows.getSelectManager().setSelectMode(2);
        if (this.getOprtState().equals("ADDNEW")) {
            this.afterLoadFields_AddNew();
        }
        if (this.getOprtState().equals("EDIT") || this.getOprtState().equals("VIEW")) {
            this.afterLoadFields_Edit();
        }
    }

    protected void afterLoadFields_Edit() throws BOSException {
        CurrencyInfo[] cys = new CurrencyInfo[this.editData.getRefCurrencies().size()];
        for (int i = 0; i < this.editData.getRefCurrencies().size(); ++i) {
            CurrencyInfo cyInfo;
            cys[i] = cyInfo = this.editData.getRefCurrencies().get(i).getCurrency();
        }
        this.bizPromptBoxCurrency.setData((Object)cys);
        this.kDTabbedPane.setEnabledAt(1, true);
        this.kDTabbedPane.setEnabledAt(2, true);
        this.kDTabbedPane.setEnabledAt(3, true);
        BgTemplateEditHelper.initKdtBgTpCol(this.editData, this.kdtBgTpColumns);
        BgTemplateEditHelper.initKdtRefDimension(this.editData, this.kdtRefDimensions);
        this.initBgItemTabbedPane();
        if (BgTemplateHelper.isCtrlParamEnable(this.editData)) {
            this.kDTabbedPane.setEnabledAt(4, true);
            this.initBgTpRowsTabbedPane();
        }
        this.onBgMethodChanged();
        if (this.comboBoxBgCtrlType.isEnabled()) {
            this.comboBoxBgCtrlType.setEnabled(this.editData.getBgType().isControllable());
        }
        if (!"ADDNEW".equals(this.getOprtState()) && "EDIT".equals(this.getOprtState())) {
            this.addModelChangeListener();
        }
    }

    private void dealRef() throws BOSException {
        block6: {
            block5: {
                this.isRefByForm = BgTemplateHelper.checkRefed(this.editData);
                this.isAssignedFormUpper = this.editData.getParent() != null;
                this.isRefByChild = BgTemplateHelper.checkRefedByChild(this.editData);
                if (!this.isRefByForm && !this.isRefByChild) break block5;
                this.disableWhenRef();
                this.comboBoxBgCycle.setEnabled(false);
                this.btnAddBgItem.setEnabled(false);
                this.btnDeleteBgItem.setEnabled(false);
                this.kdtBgItem.getStyleAttributes().setLocked(true);
                this.comboBoxBgCtrlType.setEnabled(false);
                this.kdtBgTpRows.getStyleAttributes().setLocked(true);
                if (!this.isAssignedFormUpper) break block6;
                this.initBgTpRowTalbe();
                break block6;
            }
            if (this.isAssignedFormUpper) {
                this.disableWhenRef();
                this.initItemsCountTable();
                this.initBgTpRowTalbe();
                BgCycleTypeEnum bgCycleTypeEnum = this.editData.getBgCycle();
                if (bgCycleTypeEnum.equals((Object)BgCycleTypeEnum.Period)) {
                    this.comboBoxBgCycle.setEnabled(false);
                } else if (bgCycleTypeEnum.equals((Object)BgCycleTypeEnum.Season)) {
                    for (int i = 0; i < this.comboBoxBgCycle.getItemCount(); ++i) {
                        if (!((BgCycleTypeEnum)((Object)this.comboBoxBgCycle.getItemAt(i))).equals((Object)BgCycleTypeEnum.Year)) continue;
                        this.comboBoxBgCycle.removeItemAt(i);
                        this.comboBoxBgCycle.setSelectedItem((Object)BgCycleTypeEnum.Season);
                        break;
                    }
                }
            }
        }
    }

    private void initBgTpRowTalbe() {
        Iterator iter = this.editData.getBgTpRows().iterator();
        this.bgTpRowTable = new Hashtable();
        while (iter.hasNext()) {
            BgTemplateRowInfo bgTp = (BgTemplateRowInfo)iter.next();
            this.bgTpRowTable.put(bgTp.getBgItemsKey(), bgTp);
        }
    }

    private void disableWhenRef() throws BOSException {
        this.comboBoxBgMethod.setEnabled(false);
        this.comboBoxRollingBgCycle.setEnabled(false);
        this.bizPromptBoxCurrency.setEnabled(false);
        this.btnDeleteColumn.setEnabled(false);
        this.btnAddColumn.setEnabled(false);
        this.btnEditFormula.setEnabled(false);
        this.kdtBgTpColumns.getStyleAttributes().setLocked(true);
        this.btnDeleteDimension.setEnabled(false);
        this.btnAddDimension.setEnabled(false);
        this.kdtRefDimensions.getStyleAttributes().setLocked(true);
    }

    private void initItemsCountTable() {
        this.itemsCountTable = new Hashtable();
        Iterator iter = this.editData.getRefDimensions().iterator();
        while (iter.hasNext()) {
            ReferencedDimensionInfo refDimInfo = (ReferencedDimensionInfo)iter.next();
            this.itemsCountTable.put(refDimInfo.getBgDimension(), new Integer(refDimInfo.getBgItems().size()));
        }
    }

    private void addModelChangeListener() {
        BgORMEngine.addCollectionRemoveLisener((IObjectCollection)this.editData.getRefCurrencies(), this.deleteRefCur);
        BgORMEngine.addCollectionRemoveLisener((IObjectCollection)this.editData.getRefDimensions(), this.deleteRefBgItemList);
        BgORMEngine.addVOColectionChangeLisener((IObjectCollection)this.editData.getRefDimensions(), this.refDimPropertyAry);
        int size = this.editData.getRefDimensions().size();
        for (int i = 0; i < size; ++i) {
            BgORMEngine.addCollectionRemoveLisener((IObjectCollection)this.editData.getRefDimensions().get(i).getBgItems(), this.deleteBgItemList);
            BgORMEngine.addVOColectionChangeLisener((IObjectCollection)this.editData.getRefDimensions().get(i).getBgItems(), this.itemPropertyAry);
        }
        BgORMEngine.addCollectionRemoveLisener((IObjectCollection)this.editData.getBgTpRows(), this.deleteBgTpRList);
        BgORMEngine.addVOColectionChangeLisener((IObjectCollection)this.editData.getBgTpRows(), this.bgTpRPropertyAry);
        BgORMEngine.addCollectionRemoveLisener((IObjectCollection)this.editData.getBgTpColumns(), this.deleteBgTpCList);
        BgORMEngine.addVOColectionChangeLisener((IObjectCollection)this.editData.getBgTpColumns(), this.bgTpCPropertyAry);
    }

    protected void afterLoadFields_AddNew() throws EASBizException, BOSException {
        BgTypeInfo inBgTypeInfo = (BgTypeInfo)this.getUIContext().get("BgType");
        if (inBgTypeInfo == null) {
            SysUtil.abort();
        }
        this.editData.setBgType(inBgTypeInfo);
        this.bizPromptBgType.setData((Object)inBgTypeInfo);
        OrgUnitInfo inOrgUnitInfo = (OrgUnitInfo)this.getUIContext().get("EditOrg");
        if (inOrgUnitInfo == null) {
            SysUtil.abort();
        }
        this.editData.setOrgUnit(inOrgUnitInfo);
        this.bizPromptOrgUnit.setData((Object)inOrgUnitInfo);
        if (inOrgUnitInfo.isIsCompanyOrgUnit()) {
            CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
            companyInfo.setId(inOrgUnitInfo.getId());
            companyInfo.setNumber(inOrgUnitInfo.getNumber());
            this.editData.setCompany(companyInfo);
        } else {
            IOrgUnitCommon iOrgUnitCommon = OrgUnitCommonFactory.getRemoteInstance();
            CompanyOrgUnitInfo companyInfo = iOrgUnitCommon.getCompany(inOrgUnitInfo.getId());
            if (companyInfo != null) {
                this.editData.setCompany(companyInfo);
            }
        }
        if (!this.kDCheckBoxIsCurrNew.isSelected()) {
            this.kDCheckBoxIsCurrNew.setSelected(true);
        }
        this.setDefaultData();
        BgTemplateEditHelper.addCodeRule(this.txtNumber, this.editData);
    }

    private void setDefaultData() throws EASBizException, BOSException {
        if (this.editData.getCompany() != null) {
            ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getRemoteInstance();
            CompanyOrgUnitInfo companyInfo = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.editData.getCompany().getId()), BgTemplateHelper.getLocalCySelectors());
            CurrencyInfo cyInfo = companyInfo.getBaseCurrency();
            this.bizPromptBoxCurrency.setData((Object)new Object[]{cyInfo});
        }
        BgClientHelper.initDefaultCreator(this.bizPromptCreator);
        this.comboBoxRollingBgCycle.setSelectedIndex(0);
        this.comboBoxBgCtrlType.setSelectedIndex(0);
        if (this.comboBoxBgMethod.getItemCount() > 0 && this.comboBoxBgMethod.getSelectedItem() == null) {
            this.comboBoxBgMethod.setSelectedIndex(0);
        }
        if (this.comboBoxBgCycle.getItemCount() > 0 && this.comboBoxBgCycle.getSelectedItem() == null) {
            this.comboBoxBgCycle.setSelectedItem((Object)BgCycleTypeEnum.Period);
        }
        this.setDefaultTabbedPane();
        this.setDefaultCtrlType();
        this.kDDatePickerEditDate.setValue((Object)Calendar.getInstance().getTime());
    }

    protected void setDefaultTabbedPane() {
        this.kDTabbedPane.setEnabledAt(1, true);
        this.kDTabbedPane.setEnabledAt(2, true);
        this.initBgColumnTabbedPane();
        this.initRefDimTabbedPane();
        this.setBgItemOld(true);
    }

    public void setDefaultCtrlType() {
        if (this.editData.getBgType().isControllable()) {
            this.editData.setBgCtrlType(BgCtrlTypeEnum.PeriodCtrl);
            this.comboBoxBgCtrlType.setSelectedItem((Object)this.editData.getBgCtrlType());
            this.comboBoxBgCtrlType.setEnabled(true);
        } else {
            this.editData.setBgCtrlType(BgCtrlTypeEnum.NoCtrl);
            this.comboBoxBgCtrlType.setSelectedItem((Object)this.editData.getBgCtrlType());
            this.comboBoxBgCtrlType.setEnabled(false);
        }
    }

    @Override
    public void storeFields() {
        try {
            super.storeFields();
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        CurrencyCollection currencyCollection = BgTemplateEditHelper.getCurrencyFromBox(this.bizPromptBoxCurrency);
        this.editData.initRefCurrency(currencyCollection);
        if (!this.kdtBgTpColumns.getStyleAttributes().isLocked()) {
            BgTemplateEditHelper.readKdtBgTpCol(this.editData, this.kdtBgTpColumns);
        }
        if (BgTemplateHelper.isCtrlParamEnable(this.editData)) {
            if (this.isBgTpRowOld && BgTemplateHelper.isCtrlParamEnable(this.editData)) {
                this.kDTabbedPane.setSelectedIndex(4);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"CompleteBgCtrlParam"));
                SysUtil.abort();
            }
            BgTemplateEditHelper.readKdtBgTpRows(this.editData, this.kdtBgTpRows);
        } else if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.editData.initBgTpRows();
        } else {
            boolean isChangeDim = BgTemplateEditHelper.isChangeDim(this.editData.getRefDimensions());
            if (isChangeDim) {
                this.editData.initBgTpRows();
            } else {
                this.editData.removeBgTpRowByDeleteBgItem(this.deleteBgItemList, this.editData.getBgTpRows());
                this.editData.initBgTpRowsNew();
            }
        }
    }

    @Override
    protected void onkDTabbedPaneStateChanged(ChangeEvent e) throws Exception {
        super.onkDTabbedPaneStateChanged(e);
        int currentTabIndex = this.kDTabbedPane.getSelectedIndex();
        switch (currentTabIndex) {
            case 3: {
                this.onTabBgItem();
                break;
            }
            case 4: {
                this.onTabBgTpRow();
                break;
            }
        }
    }

    private void onTabBgItem() {
        if (!this.isBgItemOld) {
            return;
        }
        try {
            BgTemplateEditHelper.readKdtBgRefDimensions(this.editData, this.kdtRefDimensions);
        }
        catch (Exception ex) {
            this.kDTabbedPane.setSelectedIndex(2);
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"CompleteRefDim"));
            return;
        }
        if (this.editData.isIsMultidimensional()) {
            if (this.editData.getPrimaryRefDim() == null) {
                this.kDTabbedPane.setSelectedIndex(2);
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"CompletePrimaryDim"));
                return;
            }
        } else if (!BgTemplateHelper.checkRefDimSeq(this.editData.getRefDimensions())) {
            this.kDTabbedPane.setSelectedIndex(2);
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"CompleteSeq"));
            return;
        }
        this.initBgItemTabbedPane();
        this.isBgItemOld = false;
        this.isBgTpRowOld = true;
        if (BgTemplateHelper.isCtrlParamEnable(this.editData)) {
            this.kDTabbedPane.setEnabledAt(4, true);
        }
    }

    private void initBgItem() {
        if (!this.isBgItemOld) {
            return;
        }
        try {
            BgTemplateEditHelper.readKdtBgRefDimensions(this.editData, this.kdtRefDimensions);
        }
        catch (Exception ex) {
            this.kDTabbedPane.setSelectedIndex(2);
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"CompleteRefDim"));
            return;
        }
        if (!BgTemplateHelper.checkRefDimSeq(this.editData.getRefDimensions())) {
            this.kDTabbedPane.setSelectedIndex(2);
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"CompleteSeq"));
            return;
        }
        this.initBgItemTabbedPane();
        this.isBgItemOld = false;
        this.isBgTpRowOld = true;
        if (BgTemplateHelper.isCtrlParamEnable(this.editData)) {
            this.kDTabbedPane.setEnabledAt(4, true);
        }
    }

    private void onTabBgTpRow() {
        if (!this.isBgTpRowOld) {
            return;
        }
        this.initBgTpRowsTabbedPane();
        this.isBgTpRowOld = false;
    }

    private void initBgItemTabbedPane() {
        ReferencedDimensionInfo refDimInfo;
        this.kdtBgItem.removeRows();
        if (this.isBgItemOld) {
            Iterator iter = this.editData.getRefDimensions().iterator();
            while (iter.hasNext()) {
                refDimInfo = (ReferencedDimensionInfo)iter.next();
                BgItemCollection bic = refDimInfo.getBgItems();
                if (bic != null && bic.size() != 0) continue;
                try {
                    IBgItemHelper iBgItemHepler = new BgItemHelperFactory().getBgItemHelper(this.editData.getBgType(), refDimInfo.getBgDimension(), this.editData.getOrgUnit());
                    bic = iBgItemHepler.fetcheBgItems();
                    for (int i = 0; i < bic.size(); ++i) {
                        bic.get(i).setRefDimension(refDimInfo);
                        BgORMEngine.setIsNew((IObjectValue)bic.get(i), true);
                    }
                    refDimInfo.getBgItems().addCollection(bic);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
        }
        this.comboBoxDimOfBgItem.removeAllItems();
        Iterator refDimIter = this.editData.getRefDimensions().iterator();
        while (refDimIter.hasNext()) {
            refDimInfo = (ReferencedDimensionInfo)refDimIter.next();
            this.comboBoxDimOfBgItem.addItem((Object)refDimInfo.getBgDimension());
        }
        if (this.comboBoxDimOfBgItem.getItemCount() > 0) {
            this.comboBoxDimOfBgItem.setSelectedIndex(0);
        }
    }

    @Override
    protected void comboBoxDimOfBgItem_actionPerformed(ActionEvent e) throws Exception {
        super.comboBoxDimOfBgItem_actionPerformed(e);
        if (this.comboBoxDimOfBgItem.getSelectedIndex() == -1) {
            this.kdtBgItem.removeRows();
            return;
        }
        BgDimensionEnum bgDimensionEnum = (BgDimensionEnum)((Object)this.comboBoxDimOfBgItem.getSelectedItem());
        if (bgDimensionEnum.getValue() != 1100) {
            this.lab.setVisible(false);
        } else {
            this.lab.setVisible(true);
        }
        BgTemplateEditHelper.initKdtBgItem(this.editData, bgDimensionEnum, this.kdtBgItem, (IUIObject)this);
        if (this.isAssignedFormUpper && this.itemsCountTable != null) {
            Integer size = (Integer)this.itemsCountTable.get((Object)bgDimensionEnum);
            for (int i = 0; i < size; ++i) {
                this.kdtBgItem.getRow(i).getStyleAttributes().setLocked(true);
            }
        }
        if (!this.isAssignedFormUpper && !this.isRefByForm && this.kdtBgItem.getRowCount() == 0) {
            this.kdtBgItem.addRow();
        }
    }

    @Override
    protected void btnAddBgItem_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddBgItem_actionPerformed(e);
        if (this.comboBoxDimOfBgItem.getSelectedIndex() == -1) {
            return;
        }
        this.kdtBgItem.addRow();
    }

    @Override
    protected void btnDeleteBgItem_actionPerformed(ActionEvent e) throws Exception {
        super.btnDeleteBgItem_actionPerformed(e);
        if (!this.canDeleteByRef()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"SubTemplateRemoveItemNotAllowed"));
            return;
        }
        BgDimensionEnum curBgDimOfItem = (BgDimensionEnum)((Object)this.comboBoxDimOfBgItem.getSelectedItem());
        if (curBgDimOfItem == null) {
            return;
        }
        BgItemCollection bgItems = this.editData.getRefDim(curBgDimOfItem).getBgItems();
        Set set = BgClientHelper.getSelectedRows(this.kdtBgItem);
        Iterator iter = set.iterator();
        int deletedCount = 0;
        while (iter.hasNext()) {
            Integer theInt = (Integer)iter.next();
            if (theInt == null) continue;
            int theRow = theInt - deletedCount;
            this.deleteItemAtRow(theRow, bgItems);
            ++deletedCount;
        }
        this.isBgTpRowOld = true;
    }

    private boolean canDeleteByRef() {
        int selectedRow = this.kdtBgItem.getSelectManager().getActiveRowIndex();
        IRow iRow = this.kdtBgItem.getRow(selectedRow);
        if (iRow == null) {
            return false;
        }
        Object obj = this.kdtBgItem.getRow(selectedRow).getUserObject();
        if (obj != null) {
            BgItemInfo bgItemInfo = (BgItemInfo)obj;
            bgItemInfo.setCU(BgOrgHelper.getDefCU());
            if (bgItemInfo.isIsFromParent()) {
                return false;
            }
        }
        return true;
    }

    private void deleteItemAtRow(int theRow, BgItemCollection bgItems) {
        BgItemInfo bgItemInfo = null;
        if (this.kdtBgItem.getRow(theRow) == null) {
            return;
        }
        if (this.kdtBgItem.getRow(theRow).getUserObject() != null) {
            bgItemInfo = (BgItemInfo)this.kdtBgItem.getRow(theRow).getUserObject();
        }
        this.kdtBgItem.removeRow(theRow);
        if (bgItemInfo != null) {
            bgItems.remove(bgItemInfo);
        }
        this.isBgTpRowOld = true;
    }

    @Override
    protected void kdtBgItem_editStopped(KDTEditEvent e) throws Exception {
        super.kdtBgItem_editStopped(e);
        if (this.comboBoxDimOfBgItem.getSelectedIndex() == -1) {
            return;
        }
        BgDimensionEnum bgDimEnum = (BgDimensionEnum)((Object)this.comboBoxDimOfBgItem.getSelectedItem());
        int nCell = e.getColIndex();
        if (nCell != 0) {
            return;
        }
        int nRow = e.getRowIndex();
        IRow row = this.kdtBgItem.getRow(nRow);
        BgItemCollection bic = this.editData.getRefDim(bgDimEnum).getBgItems();
        ICell cell = row.getCell(nCell);
        if (!(cell.getValue() instanceof ObjectBaseInfo)) {
            return;
        }
        ObjectBaseInfo objectBaseInfo = (ObjectBaseInfo)cell.getValue();
        IBgItemHelper iBgItemHelper = new BgItemHelperFactory().getBgItemHelper(this.editData.getBgType(), bgDimEnum, this.editData.getOrgUnit());
        BgItemInfo addedBgItemInfo = iBgItemHelper.convertBgItem(objectBaseInfo);
        addedBgItemInfo.setCU(BgOrgHelper.getDefCU());
        if (addedBgItemInfo == null) {
            return;
        }
        if (this.checkDuplicate(nRow, addedBgItemInfo)) {
            BgTemplateEditHelper.fillBgItemTableRow(row, (BgItemInfo)row.getUserObject());
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"ErrorSameItem"));
            return;
        }
        if (row.getUserObject() != null) {
            bic.remove((BgItemInfo)row.getUserObject());
        }
        addedBgItemInfo.setRefDimension(this.editData.getRefDim(bgDimEnum));
        BgORMEngine.setIsNew((IObjectValue)addedBgItemInfo, true);
        bic.add(addedBgItemInfo);
        BgTemplateEditHelper.fillBgItemTableRow(row, addedBgItemInfo);
        this.isBgTpRowOld = true;
    }

    private boolean checkDuplicate(int nRow, BgItemInfo addedBgItemInfo) {
        boolean isDuplicate = false;
        int size = this.kdtBgItem.getRowCount();
        for (int i = 0; i < size; ++i) {
            BgItemInfo coparedBgItemInfo;
            if (i == nRow || (coparedBgItemInfo = (BgItemInfo)this.kdtBgItem.getRow(i).getUserObject()) == null || !coparedBgItemInfo.getItemNumber().equals(addedBgItemInfo.getItemNumber())) continue;
            isDuplicate = true;
            break;
        }
        return isDuplicate;
    }

    @Override
    protected void comboBoxBgMethod_actionPerformed(ActionEvent e) throws Exception {
        super.comboBoxBgMethod_actionPerformed(e);
        this.onBgMethodChanged();
    }

    private void onBgMethodChanged() {
        if (!this.comboBoxBgMethod.isEnabled()) {
            return;
        }
        if (this.comboBoxBgMethod.getSelectedItem() == null) {
            return;
        }
        BgMethodEnum bgMethodEnum = (BgMethodEnum)((Object)this.comboBoxBgMethod.getSelectedItem());
        if (bgMethodEnum.getValue() == 1) {
            this.comboBoxRollingBgCycle.setEnabled(false);
            int itemCount = this.comboBoxBgCycle.getItemCount();
            boolean isExist = false;
            for (int i = 0; i < itemCount; ++i) {
                BgCycleTypeEnum bgCycleTypeEnumTemp = (BgCycleTypeEnum)((Object)this.comboBoxBgCycle.getItemAt(i));
                if (bgCycleTypeEnumTemp.getValue() != 1) continue;
                isExist = true;
                break;
            }
            if (!isExist) {
                this.comboBoxBgCycle.addItem((Object)BgCycleTypeEnum.Year);
            }
        } else {
            this.comboBoxRollingBgCycle.setEnabled(true);
            this.comboBoxBgCycle.removeItem((Object)BgCycleTypeEnum.Year);
            this.onBgCycleChange();
        }
    }

    private void initRefDimTabbedPane() {
        this.editData.getRefDimensions().clear();
        this.editData.getRefDimensions().addCollection(BgTemplateHelper.generateRefDims(this.editData.getBgType()));
        BgTemplateEditHelper.initKdtRefDimension(this.editData, this.kdtRefDimensions);
        this.editData.setIsMultidimensional(true);
        this.setBgItemOld(true);
    }

    @Override
    protected void btnAddDimension_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddDimension_actionPerformed(e);
        IRow irow = this.kdtRefDimensions.addRow();
        ReferencedDimensionInfo refDimInfo = new ReferencedDimensionInfo();
        refDimInfo.setIsPrimary(false);
        irow.setUserObject((Object)refDimInfo);
        this.setDimensionSeq();
    }

    @Override
    protected void btnDeleteDimension_actionPerformed(ActionEvent e) throws Exception {
        super.btnDeleteDimension_actionPerformed(e);
        if (this.kdtRefDimensions.getRowCount() == 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"DimNotNull"));
            return;
        }
        int nRow = this.kdtRefDimensions.getSelectManager().getActiveRowIndex();
        if (nRow == -1) {
            this.kdtRefDimensions.getSelectManager().select(0, -1);
            return;
        }
        IRow iRow = this.kdtRefDimensions.getRow(nRow);
        BgDimensionEnum bgDimensionEnum = (BgDimensionEnum)((Object)iRow.getCell("bgDimension").getValue());
        if (bgDimensionEnum != null) {
            this.comboBoxDimOfBgItem.removeItem((Object)bgDimensionEnum);
            ReferencedDimensionCollection refs = this.editData.getRefDimensions();
            int size = refs.size();
            for (int i = 0; i < size; ++i) {
                ReferencedDimensionInfo referencedDimensionInfoTemp = refs.get(i);
                BgORMEngine.setIsChanged((IObjectValue)referencedDimensionInfoTemp, true);
                if (referencedDimensionInfoTemp.getBgDimension().getValue() != bgDimensionEnum.getValue()) continue;
                refs.removeObject(i);
                break;
            }
        }
        this.kdtRefDimensions.removeRow(nRow);
        this.setBgItemOld(true);
        this.setDimensionSeq();
    }

    @Override
    protected void kdtRefDimensions_editStopped(KDTEditEvent e) throws Exception {
        super.kdtRefDimensions_editStopped(e);
        if (e.getColIndex() == this.kdtRefDimensions.getColumnIndex("bgDimension")) {
            this.onDimensionSelected();
        } else if (e.getColIndex() == this.kdtRefDimensions.getColumnIndex("isPrimary")) {
            this.onPrimaryDimensionChange();
        }
        this.setBgItemOld(true);
        this.initBgItem();
    }

    protected void onPrimaryDimensionChange() {
        int nRow = this.kdtRefDimensions.getSelectManager().getActiveRowIndex();
        int rowCount = this.kdtRefDimensions.getRowCount();
        int nCell = this.kdtRefDimensions.getColumnIndex("isPrimary");
        for (int i = 0; i < rowCount; ++i) {
            IRow iRow = this.kdtRefDimensions.getRow(i);
            ICell iCell = iRow.getCell(nCell);
            if (i == nRow) {
                iCell.setValue((Object)new Boolean(true));
                continue;
            }
            iCell.setValue((Object)new Boolean(false));
        }
    }

    protected void onDimensionSelected() {
        int nRow = this.kdtRefDimensions.getSelectManager().getActiveRowIndex();
        int nCell = this.kdtRefDimensions.getSelectManager().getActiveColumnIndex();
        IRow iRow = this.kdtRefDimensions.getRow(nRow);
        ICell iCell = iRow.getCell(nCell);
        BgDimensionEnum bgDimensionEnum = (BgDimensionEnum)((Object)iCell.getValue());
        if (bgDimensionEnum == null) {
            return;
        }
        int countRow = this.kdtRefDimensions.getRowCount();
        for (int i = 0; i < countRow; ++i) {
            BgDimensionEnum bgDimensionEnum1;
            IRow curRow;
            ICell curCell;
            if (i == nRow || (curCell = (curRow = this.kdtRefDimensions.getRow(i)).getCell(nCell)).getValue() == null || (bgDimensionEnum1 = (BgDimensionEnum)((Object)curCell.getValue())) == null || bgDimensionEnum.getValue() != bgDimensionEnum1.getValue()) continue;
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"ErrorSameDim"));
            iCell.setValue(null);
        }
        iRow.getCell("isPrimary").setValue((Object)new Boolean(false));
    }

    private void initBgColumnTabbedPane() {
        this.editData.getBgTpColumns().clear();
        this.editData.getBgTpColumns().addCollection(BgTemplateHelper.generateBgTpColumns(this.editData.getBgType()));
        BgTemplateEditHelper.initKdtBgTpCol(this.editData, this.kdtBgTpColumns);
    }

    @Override
    protected void btnAddColumn_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddColumn_actionPerformed(e);
        IRow irow = this.kdtBgTpColumns.addRow();
        irow.getCell("isControlled").setValue((Object)Boolean.FALSE);
    }

    @Override
    protected void kdtBgTpColumns_editStopped(KDTEditEvent e) throws Exception {
        IRow row;
        super.kdtBgTpColumns_editStopped(e);
        if (e.getColIndex() != 0) {
            return;
        }
        BgElementInfo bgElementInfo = null;
        Object userObj = this.kdtBgTpColumns.getRow(e.getRowIndex()).getCell(e.getColIndex()).getValue();
        if (userObj == null) {
            return;
        }
        if (!(userObj instanceof BgElementInfo)) {
            return;
        }
        bgElementInfo = (BgElementInfo)userObj;
        boolean isDupicate = false;
        for (int i = 0; i < this.kdtBgTpColumns.getRowCount(); ++i) {
            if (i == e.getRowIndex() || (row = this.kdtBgTpColumns.getRow(i)) == null || row.getUserObject() == null || !(row.getUserObject() instanceof BgTemplateColumnInfo)) continue;
            String compareNumber = ((BgTemplateColumnInfo)row.getUserObject()).getBgElement().getNumber();
            if (!bgElementInfo.getNumber().equals(compareNumber)) continue;
            isDupicate = true;
            break;
        }
        if (isDupicate) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"DuplicateElement"));
            this.kdtBgTpColumns.getRow(e.getRowIndex()).getCell(e.getColIndex()).setValue(null);
            return;
        }
        BgTemplateColumnInfo bgTpColInfo = new BgTemplateColumnInfo();
        bgTpColInfo.generateFromBgElement(bgElementInfo);
        this.editData.getBgTpColumns().add(bgTpColInfo);
        row = this.kdtBgTpColumns.getRow(e.getRowIndex());
        BgTemplateEditHelper.fillBgColumnTableRow(row, bgTpColInfo);
    }

    @Override
    protected void btnDeleteColumn_actionPerformed(ActionEvent e) throws Exception {
        BgTemplateColumnInfo selectInfo;
        super.btnDeleteColumn_actionPerformed(e);
        int nRow = this.kdtBgTpColumns.getSelectManager().getActiveRowIndex();
        if (nRow >= 0 && (selectInfo = (BgTemplateColumnInfo)this.kdtBgTpColumns.getRow(nRow).getUserObject()) != null) {
            String selectElement = selectInfo.getBgElement().getName();
            int n = this.kdtBgTpColumns.getRowCount();
            for (int i = 0; i < n; ++i) {
                String otherFormula;
                if (i == nRow) continue;
                BgTemplateColumnInfo otherInfo = (BgTemplateColumnInfo)this.kdtBgTpColumns.getRow(i).getUserObject();
                String string = otherFormula = otherInfo == null ? null : otherInfo.getFormula();
                if (otherFormula == null || otherFormula.indexOf(selectElement) < 0) continue;
                otherInfo.setFormula(null);
                this.kdtBgTpColumns.getRow(i).getCell("formula").setValue((Object)"");
            }
        }
        this.kdtBgTpColumns.removeRow(nRow);
    }

    private void initBgTpRowsTabbedPane() {
        if (this.comboBoxBgCtrlType.getSelectedItem() == null) {
            this.editData.setBgCtrlType(BgCtrlTypeEnum.NoCtrl);
        } else {
            this.editData.setBgCtrlType((BgCtrlTypeEnum)((Object)this.comboBoxBgCtrlType.getSelectedItem()));
        }
        BgTemplateEditHelper.renewKdtBgTpRows(this.kdtBgTpRows);
        if (this.isBgTpRowOld) {
            if (this.getOprtState().equals(OprtState.EDIT)) {
                boolean isChangeDim = BgTemplateEditHelper.isChangeDim(this.editData.getRefDimensions());
                if (isChangeDim) {
                    this.editData.initBgTpRows();
                } else {
                    this.editData.initBgTpRows();
                }
            } else {
                this.editData.initBgTpRows();
            }
        }
        this.kdtBgTpRows.getColumn("flexibleBgCtrlParam").getStyleAttributes().setNumberFormat(BgClientHelper.getNumberFtm());
        BgTemplateEditHelper.initKdtBgTpRows(this.editData, this.kdtBgTpRows);
    }

    private void hideFlexibleColumn() {
        this.kdtBgTpRows.getColumn("isFlexibleCtrl").getStyleAttributes().setHided(true);
        this.kdtBgTpRows.getColumn("flexibleBgCtrlParam").getStyleAttributes().setHided(true);
    }

    @Override
    protected void kdtBgTpRows_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (colIndex == this.kdtBgTpRows.getColumnIndex("bgControlType") || colIndex == this.kdtBgTpRows.getColumnIndex("isFlexibleCtrl")) {
            BgTemplateEditHelper.adjustAKdtBgRow(this.kdtBgTpRows.getRow(rowIndex));
        } else if (colIndex == this.kdtBgTpRows.getColumnIndex("flexibleBgCtrlParam")) {
            boolean isLogical = true;
            String value = (String)this.kdtBgTpRows.getRow(rowIndex).getCell(colIndex).getValue();
            if (value == null || value.trim().equals("")) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"inputNumber"));
                this.kdtBgTpRows.getEditManager().editCellAt(rowIndex, colIndex);
                isLogical = false;
            }
            if (isLogical && !BgClientHelper.verifyIsNumber(value)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"inputNumber"));
                this.kdtBgTpRows.getEditManager().editCellAt(rowIndex, colIndex);
                isLogical = false;
            }
            if (isLogical && !BgClientHelper.verifyIsPlus(value)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"inputPlus"));
                this.kdtBgTpRows.getEditManager().editCellAt(rowIndex, colIndex);
                isLogical = false;
            }
            if (isLogical) {
                DecimalFormat format = BgClientHelper.getDecimalFormat();
                value = format.format(new BigDecimal(value));
                this.kdtBgTpRows.getRow(rowIndex).getCell(colIndex).setValue((Object)value);
            }
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.doSave(e);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_TemporarilySave_OK"));
        this.getUIWindow().close();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.doSave(e);
        this.checkRefByChild();
        this.getUIWindow().close();
    }

    private void checkRefByChild() throws BOSException {
        if (this.editData.getId() == null) {
            return;
        }
        IBgTemplate ibt = BgTemplateFactory.getRemoteInstance();
        boolean isRefByChild = ibt.checkRefByChild(this.editData.getId());
        if (isRefByChild) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"InfoAssignAgain"));
        }
    }

    private void doSave(ActionEvent e) throws Exception {
        Serializable info;
        this.verifyInput(e);
        this.storeFields();
        CtrlUnitInfo cuInfo = BgOrgHelper.getDefCU();
        this.editData.setCU(cuInfo);
        for (int i = 0; i < this.editData.getRefDimensions().size(); ++i) {
            info = this.editData.getRefDimensions().get(i);
            for (int j = 0; j < info.getBgItems().size(); ++j) {
                info.getBgItems().get(j).setCU(cuInfo);
            }
        }
        IBgTemplate ibt = BgTemplateFactory.getRemoteInstance();
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            IObjectPK pk = ibt.addnew((CoreBaseInfo)this.editData);
            this.editData.setId(BOSUuid.read((String)pk.toString()));
            this.setOprtState(OprtState.EDIT);
            this.addModelChangeListener();
        } else if (this.getOprtState().equals(OprtState.EDIT)) {
            if (BgHelper.ISDeBug) {
                info = this.buildSaveBgTemplate(this.editData);
                ibt.updateCurrent((IObjectPK)new ObjectUuidPK(info.getId()), (BgTemplateInfo)info);
                this.addModelChangeListener();
            } else {
                ibt.updateCurrent((IObjectPK)new ObjectUuidPK(this.editData.getId()), this.editData);
            }
        }
        this.save = true;
    }

    private BgTemplateInfo buildSaveBgTemplate(BgTemplateInfo editData) {
        ArrayList<IObjectValue> refDimColl = new ArrayList<IObjectValue>();
        ArrayList<ReferencedCurrencyInfo> refCurColl = new ArrayList<ReferencedCurrencyInfo>();
        ArrayList<IObjectValue> itemColl = new ArrayList<IObjectValue>();
        ArrayList<IObjectValue> tpCColl = new ArrayList<IObjectValue>();
        ArrayList<IObjectValue> tpRColl = new ArrayList<IObjectValue>();
        BgTemplateInfo info = (BgTemplateInfo)BgORMEngine.newVO((IObjectValue)editData);
        Iterator iter = editData.getBgTpColumns().iterator();
        while (iter.hasNext()) {
            BgTemplateColumnInfo tpC = (BgTemplateColumnInfo)iter.next();
            if (!BgORMEngine.isNeedUpdate((IObjectValue)tpC)) continue;
            tpC.setBgTemplate(editData);
            IObjectValue newTpc = BgORMEngine.newVO((IObjectValue)tpC);
            tpCColl.add(newTpc);
        }
        iter = editData.getBgTpRows().iterator();
        while (iter.hasNext()) {
            BgTemplateRowInfo tpR = (BgTemplateRowInfo)iter.next();
            if (!BgORMEngine.isNeedUpdate((IObjectValue)tpR)) continue;
            tpR.setBgTemplate(editData);
            IObjectValue newTpR = BgORMEngine.newVO((IObjectValue)tpR);
            tpRColl.add(newTpR);
        }
        iter = editData.getRefCurrencies().iterator();
        while (iter.hasNext()) {
            ReferencedCurrencyInfo refCur = (ReferencedCurrencyInfo)iter.next();
            if (!BgORMEngine.isNeedUpdate((IObjectValue)refCur)) continue;
            refCur.setBgTemplate(editData);
            IObjectValue newRefCur = BgORMEngine.newVO((IObjectValue)refCur);
            refCurColl.add(refCur);
        }
        iter = editData.getRefDimensions().iterator();
        while (iter.hasNext()) {
            ReferencedDimensionInfo refDim = (ReferencedDimensionInfo)iter.next();
            refDim.setBgTemplate(info);
            IObjectValue newRefDim = BgORMEngine.newVO((IObjectValue)refDim);
            Iterator dataIter = refDim.getBgItems().iterator();
            while (dataIter.hasNext()) {
                BgItemInfo bgItem = (BgItemInfo)dataIter.next();
                if (!BgORMEngine.isNeedUpdate((IObjectValue)bgItem)) continue;
                bgItem.setRefDimension((ReferencedDimensionInfo)newRefDim);
                IObjectValue newItem = BgORMEngine.newVO((IObjectValue)bgItem);
                itemColl.add(newItem);
            }
            if (!BgORMEngine.isNeedUpdate((IObjectValue)refDim)) continue;
            if (newRefDim.get("id") == null) {
                newRefDim.put("id", (Object)BOSUuid.create((BOSObjectType)refDim.getBOSType()));
                BgORMEngine.setIsNew(newRefDim, true);
            }
            refDimColl.add(newRefDim);
        }
        BgORMEngine.setORMObjectAry((IObjectValue)info, this.ormObject);
        BgORMEngine.setMainPropertyAry((IObjectValue)info, this.mainPropertyAry);
        int i = 0;
        if (refDimColl.size() > 0) {
            info.put(this.ormObject[i] + "key", refDimColl.toArray(new ReferencedDimensionInfo[0]));
            info.put(this.ormObject[i] + "property", this.refDimPropertyAry);
        }
        info.put(this.ormObject[i++] + "deletedIds", this.deleteRefBgItemList.toArray(new BOSUuid[0]));
        if (itemColl.size() > 0) {
            info.put(this.ormObject[i] + "key", itemColl.toArray(new BgItemInfo[0]));
            info.put(this.ormObject[i] + "property", this.itemPropertyAry);
        }
        info.put(this.ormObject[i++] + "deletedIds", this.deleteBgItemList.toArray(new BOSUuid[0]));
        if (refCurColl.size() > 0) {
            info.put(this.ormObject[i] + "key", refCurColl.toArray(new ReferencedCurrencyInfo[0]));
            info.put(this.ormObject[i] + "property", this.refCurPropertyAry);
        }
        info.put(this.ormObject[i++] + "deletedIds", this.deleteRefCur.toArray(new BOSUuid[0]));
        if (tpCColl.size() > 0) {
            info.put(this.ormObject[i] + "key", tpCColl.toArray(new BgTemplateColumnInfo[0]));
            info.put(this.ormObject[i] + "property", this.bgTpCPropertyAry);
        }
        info.put(this.ormObject[i++] + "deletedIds", this.deleteBgTpCList.toArray(new BOSUuid[0]));
        if (tpRColl.size() > 0) {
            info.put(this.ormObject[i] + "key", tpRColl.toArray(new BgTemplateRowInfo[0]));
            info.put(this.ormObject[i] + "property", this.bgTpRPropertyAry);
        }
        info.put(this.ormObject[i++] + "deletedIds", this.deleteBgTpRList.toArray(new BOSUuid[0]));
        info.setBoolean("_IsBgOrm", true);
        return info;
    }

    public boolean isSave() {
        return this.save;
    }

    private void setBgItemOld(boolean isOld) {
        this.isBgItemOld = isOld;
        if (this.isBgItemOld) {
            this.isBgTpRowOld = true;
            this.kDTabbedPane.setEnabledAt(3, true);
            this.kDTabbedPane.setEnabledAt(4, false);
        } else if (BgTemplateHelper.isCtrlParamEnable(this.editData)) {
            this.kDTabbedPane.setEnabledAt(4, true);
        }
    }

    protected void initOldData(IObjectValue dataObject) {
    }

    public boolean checkBeforeWindowClosing() {
        return true;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return BgTemplateHelper.getFullDataSelectors();
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        IBgTemplateDA ibtda = BgTemplateDAFactory.getRemoteInstance();
        return ibtda.getBgTemplate(pk.toString());
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        int cycle;
        int rCycle;
        int i;
        super.verifyInput(e);
        int countRow = this.kdtRefDimensions.getRowCount();
        for (int i2 = 0; i2 < countRow; ++i2) {
            IRow row = this.kdtRefDimensions.getRow(i2);
            if (row.getCell("bgDimension").getValue() != null) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"bgDimensionNotNull"));
            this.kdtRefDimensions.getSelectManager().set(i2, 0);
            this.kDTabbedPane.setSelectedIndex(2);
            SysUtil.abort();
        }
        countRow = this.kdtBgItem.getRowCount();
        for (i = 0; i < countRow; ++i) {
            IRow iRow = this.kdtBgItem.getRow(i);
            if (iRow.getCell("projectNumber").getValue() != null) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"bgProjectNotNull"));
            this.kdtBgItem.getSelectManager().set(i, 0);
            this.kDTabbedPane.setSelectedIndex(3);
            SysUtil.abort();
        }
        if (this.txtNumber.getText().trim().equals("")) {
            this.txtNumber.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"noNumber"));
            SysUtil.abort();
        }
        if (this.txtName.getText().trim().equals("")) {
            this.txtName.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"noName"));
            SysUtil.abort();
        }
        if (this.bizPromptBgType.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"noBgType"));
            SysUtil.abort();
        }
        if (this.bizPromptOrgUnit.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"noOrgUnit"));
            SysUtil.abort();
        }
        if (this.comboBoxBgMethod.getSelectedIndex() == -1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"noBgMethod"));
            SysUtil.abort();
        }
        if (((BgMethodEnum)((Object)this.comboBoxBgMethod.getSelectedItem())).equals((Object)BgMethodEnum.RollingBudget) && this.comboBoxRollingBgCycle.getSelectedIndex() == -1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"noRollingBgCycle"));
            SysUtil.abort();
        }
        if (this.comboBoxBgCycle.getSelectedIndex() == -1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"noBgCycle"));
            SysUtil.abort();
        }
        if (((BgMethodEnum)((Object)this.comboBoxBgMethod.getSelectedItem())).equals((Object)BgMethodEnum.RollingBudget) && (rCycle = ((BgCycleTypeEnum)((Object)this.comboBoxRollingBgCycle.getSelectedItem())).getValue()) > (cycle = ((BgCycleTypeEnum)((Object)this.comboBoxBgCycle.getSelectedItem())).getValue())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"notRollSmallerCycle"));
            SysUtil.abort();
        }
        if (this.bizPromptBoxCurrency.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"noCurrency"));
            SysUtil.abort();
        }
        if (this.bizPromptBoxCurrency.getText() == null || this.bizPromptBoxCurrency.getText().equals("")) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"noCurrency"));
            SysUtil.abort();
        }
        if (this.comboBoxBgCtrlType.getSelectedIndex() == -1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"noBgCtrlType"));
            SysUtil.abort();
        }
        if (this.editData.getBgTpColumns().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"noBgTpColumn"));
            SysUtil.abort();
        }
        if (this.editData.getRefDimensions().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"noRefDimensions"));
            SysUtil.abort();
        }
        if (this.comboBoxDimOfBgItem.getItemCount() != 0) {
            for (i = 0; i < this.comboBoxDimOfBgItem.getItemCount(); ++i) {
                BgDimensionEnum enums = (BgDimensionEnum)((Object)this.comboBoxDimOfBgItem.getItemAt(i));
                if (this.editData.getRefDim(enums).getBgItems().size() != 0) continue;
                this.kDTabbedPane.setSelectedIndex(3);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"noBgItem"));
                SysUtil.abort();
            }
        }
        if (this.isBgItemOld) {
            this.kDTabbedPane.setSelectedIndex(3);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"CompleteBgItem"));
            SysUtil.abort();
        }
        if (this.isBgTpRowOld && BgTemplateHelper.isCtrlParamEnable(this.editData)) {
            this.kDTabbedPane.setSelectedIndex(4);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"CompleteBgCtrlParam"));
            SysUtil.abort();
        }
        if (!((BgCtrlTypeEnum)((Object)this.comboBoxBgCtrlType.getSelectedItem())).equals((Object)BgCtrlTypeEnum.NoCtrl)) {
            for (i = 0; i < this.kdtBgTpRows.getRowCount(); ++i) {
                ICell cell1 = this.kdtBgTpRows.getRow(i).getCell("isFlexibleCtrl");
                ICell cell2 = this.kdtBgTpRows.getRow(i).getCell("flexibleBgCtrlParam");
                if (!((Boolean)cell1.getValue()).booleanValue()) continue;
                String value = null;
                value = cell2.getValue() instanceof BigDecimal ? ((BigDecimal)cell2.getValue()).toString() : (String)cell2.getValue();
                if (value == null) {
                    this.kDTabbedPane.setSelectedIndex(4);
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"flexibleBgCtrlParamPlus"));
                    SysUtil.abort();
                }
                if (BgClientHelper.verifyIsPlus(value)) continue;
                this.kDTabbedPane.setSelectedIndex(4);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"flexibleBgCtrlParamPlus"));
                SysUtil.abort();
            }
        }
    }

    public void setDimensionSeq() {
        int rowCount = this.kdtRefDimensions.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow iRow = this.kdtRefDimensions.getRow(i);
            iRow.getCell("seq").setValue((Object)new Integer(i + 1));
        }
    }

    @Override
    protected void comboBoxBgCtrlType_actionPerformed(ActionEvent e) throws Exception {
        if (!this.comboBoxBgCtrlType.isEnabled()) {
            return;
        }
        BgCtrlTypeEnum ctrlType = (BgCtrlTypeEnum)((Object)this.comboBoxBgCtrlType.getSelectedItem());
        if (ctrlType == null) {
            return;
        }
        if (!this.kdtBgTpRows.getStyleAttributes().isLocked() && BgTemplateHelper.isCtrlParamEnable(this.editData) && !this.isBgTpRowOld) {
            int size = this.kdtBgTpRows.getRowCount();
            for (int i = 0; i < size; ++i) {
                IRow row = this.kdtBgTpRows.getRow(i);
                row.getCell("bgControlType").setValue((Object)ctrlType);
                BgTemplateEditHelper.adjustByCtrlType(row.getCell("bgControlType"), row.getCell("isFlexibleCtrl"), row.getCell("flexibleBgCtrlParam"));
            }
        }
    }

    public void sendDownBgItemNotDelete() {
        if (this.isAssignedFormUpper) {
            int rowIndex = this.kdtBgItem.getSelectManager().getActiveRowIndex();
            IRow iRow = this.kdtBgItem.getRow(rowIndex);
            Object obj = iRow.getCell("projectNumber").getValue();
            if (obj == null) {
                return;
            }
            BgDimensionEnum bgDimension = null;
            if (obj instanceof BgDimensionEnum) {
                bgDimension = (BgDimensionEnum)((Object)obj);
            }
            if (bgDimension == null) {
                return;
            }
            Iterator iterator = this.editData.getBgTpRows().iterator();
            while (iterator.hasNext()) {
                ReferencedDimensionInfo refDimInfo = (ReferencedDimensionInfo)((Object)iterator);
                if (!refDimInfo.getBgDimension().equals((Object)bgDimension)) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"flexibleBgCtrlParamPlus"));
            }
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setIcon();
        if (this.editData.getCompany() != null) {
            String orgId = this.editData.getCompany().getId().toString();
            ICompanyOrgUnit iCom = CompanyOrgUnitFactory.getRemoteInstance();
            CompanyOrgUnitInfo info = iCom.getCompanyOrgUnitInfo("select accountTable.name where id='" + orgId + "'");
            this.comBoAccoutTable.addItem((Object)info.getAccountTable());
        }
        this.comBoAccoutTable.setEnabled(false);
    }

    public void setIcon() {
        this.btnAddBgItem.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnAddColumn.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnAddDimension.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDeleteBgItem.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnDeleteColumn.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnDeleteDimension.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    @Override
    protected void onkdtBgTpRows_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.onkdtBgTpRows_tableSelectChanged(e);
        if (!this.isAssignedFormUpper) {
            return;
        }
        if (this.bgTpRowTable == null) {
            return;
        }
        BgCtrlTypeEnum bgCtrlTypeEnum = (BgCtrlTypeEnum)((Object)this.comboBoxBgCtrlType.getSelectedItem());
        int rowIndex = this.kdtBgTpRows.getSelectManager().getActiveRowIndex();
        IRow iRow = this.kdtBgTpRows.getRow(rowIndex);
        String itemKey = (String)iRow.getUserObject();
        Object bgRowId = null;
        if (itemKey != null && this.bgTpRowTable.get(itemKey) != null) {
            if (bgCtrlTypeEnum.getValue() == 1) {
                iRow.getCell("bgControlType").getStyleAttributes().setLocked(false);
            } else {
                iRow.getCell("bgControlType").getStyleAttributes().setLocked(true);
            }
        }
    }

    @Override
    protected void oncomboBoxBgCycle_itemStateChanged(ItemEvent e) throws Exception {
        super.oncomboBoxBgCycle_itemStateChanged(e);
        this.onBgCycleChange();
    }

    private void onBgCycleChange() {
        BgCycleTypeEnum bgCycleTypeEnum;
        BgMethodEnum bgMethodEnum = (BgMethodEnum)((Object)this.comboBoxBgMethod.getSelectedItem());
        if (bgMethodEnum != null && bgMethodEnum.getValue() == 2 && (bgCycleTypeEnum = (BgCycleTypeEnum)((Object)this.comboBoxBgCycle.getSelectedItem())) != null) {
            if (bgCycleTypeEnum.getValue() == 2) {
                this.comboBoxRollingBgCycle.setSelectedItem((Object)bgCycleTypeEnum);
                this.comboBoxRollingBgCycle.setEnabled(false);
            } else if (bgCycleTypeEnum.getValue() == 3) {
                this.comboBoxRollingBgCycle.setEnabled(true);
            }
        }
    }

    @Override
    protected void btnEditFormula_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        int index = this.kdtBgTpColumns.getSelectManager().getActiveRowIndex();
        if (index < 0) {
            return;
        }
        BgTemplateColumnInfo selectInfo = (BgTemplateColumnInfo)this.kdtBgTpColumns.getRow(index).getUserObject();
        if (selectInfo == null || selectInfo.getBgElement() == null) {
            return;
        }
        BgTemplateColumnCollection otherInfo = new BgTemplateColumnCollection();
        int n = this.kdtBgTpColumns.getRowCount();
        for (int i = 0; i < n; ++i) {
            BgTemplateColumnInfo tmpInfo;
            if (i == index || (tmpInfo = (BgTemplateColumnInfo)this.kdtBgTpColumns.getRow(i).getUserObject()) == null) continue;
            otherInfo.add(tmpInfo);
        }
        boolean exist = false;
        int n2 = otherInfo.size();
        for (int i = 0; i < n2; ++i) {
            String formula = otherInfo.get(i).getFormula();
            if (formula != null && !formula.trim().equals("")) continue;
            exist = true;
            break;
        }
        if (!exist) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgTemplateResource", (String)"OneColumnAtLeast"));
            return;
        }
        Object[] otherInfoArray = otherInfo.toArray();
        int n3 = otherInfoArray.length;
        for (int i = 0; i < n3; ++i) {
            String selectName = selectInfo.getBgElement().getName();
            String tmpFormula = ((BgTemplateColumnInfo)otherInfoArray[i]).getFormula();
            if (tmpFormula == null || tmpFormula.indexOf(selectName) < 0) continue;
            otherInfo.remove((BgTemplateColumnInfo)otherInfoArray[i]);
        }
        uiContext.put((Object)"SelectInfo", (Object)selectInfo);
        uiContext.put((Object)"OtherInfo", (Object)otherInfo);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgElementFormulaUI.class.getName(), (Map)uiContext, null, this.oprtState);
        uiWindow.show();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.dealRefForView();
    }

    private void dealRefForView() throws BOSException {
        this.isRefByForm = BgTemplateHelper.checkRefed(this.editData);
        this.isAssignedFormUpper = this.editData.getParent() != null;
        this.isRefByChild = BgTemplateHelper.checkRefedByChild(this.editData);
        this.kdtBgItem.getStyleAttributes().setLocked(true);
        this.kdtBgTpRows.getStyleAttributes().setLocked(true);
        this.kdtBgTpColumns.getStyleAttributes().setLocked(true);
        this.kdtRefDimensions.getStyleAttributes().setLocked(true);
        this.txtName.setEnabled(false);
        this.txtNumber.setEnabled(false);
        this.bizPromptBoxCurrency.setEnabled(false);
        this.comboBoxBgCycle.setEnabled(false);
        this.comboBoxBgMethod.setEnabled(false);
        this.comboBoxRollingBgCycle.setEnabled(false);
        this.kDCheckBoxIsCurrNew.setEnabled(false);
        this.btnDeleteColumn.setEnabled(false);
        this.btnAddColumn.setEnabled(false);
        this.btnEditFormula.setEnabled(false);
        this.btnDeleteDimension.setEnabled(false);
        this.btnAddDimension.setEnabled(false);
        this.btnAddBgItem.setEnabled(false);
        this.btnDeleteBgItem.setEnabled(false);
        this.comboBoxBgCtrlType.setEnabled(false);
        if (this.isRefByForm || this.isRefByChild) {
            this.disableWhenRefForView();
            this.kDCheckBoxIsCurrNew.setEnabled(true);
            this.comboBoxBgCycle.setEnabled(false);
            this.btnAddBgItem.setEnabled(false);
            this.btnDeleteBgItem.setEnabled(false);
            this.comboBoxBgCtrlType.setEnabled(false);
            if (this.isAssignedFormUpper) {
                this.initBgTpRowTalbe();
            }
        } else if (this.isAssignedFormUpper) {
            this.disableWhenRefForView();
            this.initItemsCountTable();
            this.initBgTpRowTalbe();
            BgCycleTypeEnum bgCycleTypeEnum = this.editData.getBgCycle();
            if (bgCycleTypeEnum.equals((Object)BgCycleTypeEnum.Period)) {
                this.comboBoxBgCycle.setEnabled(false);
            } else if (bgCycleTypeEnum.equals((Object)BgCycleTypeEnum.Season)) {
                for (int i = 0; i < this.comboBoxBgCycle.getItemCount(); ++i) {
                    if (!((BgCycleTypeEnum)((Object)this.comboBoxBgCycle.getItemAt(i))).equals((Object)BgCycleTypeEnum.Year)) continue;
                    this.comboBoxBgCycle.removeItemAt(i);
                    this.comboBoxBgCycle.setSelectedItem((Object)BgCycleTypeEnum.Season);
                    break;
                }
            }
        } else {
            this.txtName.setEnabled(true);
            this.txtNumber.setEnabled(true);
            this.bizPromptBoxCurrency.setEnabled(true);
            this.comboBoxBgCycle.setEnabled(true);
            this.comboBoxBgMethod.setEnabled(true);
            this.comboBoxRollingBgCycle.setEnabled(true);
            this.kDCheckBoxIsCurrNew.setEnabled(true);
            this.btnDeleteColumn.setEnabled(true);
            this.btnAddColumn.setEnabled(true);
            this.btnEditFormula.setEnabled(true);
            this.btnDeleteDimension.setEnabled(true);
            this.btnAddDimension.setEnabled(true);
            this.btnAddBgItem.setEnabled(true);
            this.btnDeleteBgItem.setEnabled(true);
            this.comboBoxBgCtrlType.setEnabled(true);
        }
    }

    private void disableWhenRefForView() throws BOSException {
        this.comboBoxBgMethod.setEnabled(false);
        this.comboBoxRollingBgCycle.setEnabled(false);
        this.bizPromptBoxCurrency.setEnabled(false);
        this.btnDeleteColumn.setEnabled(false);
        this.btnAddColumn.setEnabled(false);
        this.btnEditFormula.setEnabled(false);
        this.btnDeleteDimension.setEnabled(false);
        this.btnAddDimension.setEnabled(false);
    }
}

