/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.bg.AbstractReferencedDimensionInfo;
import com.kingdee.eas.ma.bg.BgCtrlTypeEnum;
import com.kingdee.eas.ma.bg.BgDimensionEnum;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.eas.ma.bg.BgORMEngine;
import com.kingdee.eas.ma.bg.BgTemplateColumnInfo;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.BgTemplateRowInfo;
import com.kingdee.eas.ma.bg.BgTypeFactory;
import com.kingdee.eas.ma.bg.BgTypeHelper;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.IBgType;
import com.kingdee.eas.ma.bg.ReferencedDimensionCollection;
import com.kingdee.eas.ma.bg.ReferencedDimensionInfo;
import com.kingdee.eas.ma.bg.VOComparator;
import com.kingdee.eas.ma.bg.ValidBgDimensionInfo;
import com.kingdee.eas.ma.bg.client.BgClientHelper;
import com.kingdee.eas.ma.bg.client.BgElementF7Selector;
import com.kingdee.eas.ma.bg.client.BgItemHelperFactory;
import com.kingdee.eas.ma.bg.client.IBgItemHelper;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.JComboBox;

public class BgTemplateEditHelper {
    public static final int INDEX_BASIC = 0;
    public static final int INDEX_ELEMENT = 1;
    public static final int INDEX_REFDIM = 2;
    public static final int INDEX_BGITEM = 3;
    public static final int INDEX_CTRLPARAM = 4;
    public static final String EDIT_ORG = "EditOrg";
    public static final String EDIT_BGTYPE = "BgType";
    public static final String EDIT_ORGPATH = "OrgPath";

    public static void initKdtRefDimension(BgTemplateInfo entityBgTemplate, KDTable kdtRefDimensions) {
        KDComboBox kdComboBox = new KDComboBox();
        if (entityBgTemplate.getBgType() == null) {
            return;
        }
        if (entityBgTemplate.getBgType().getValidBgDimensions() == null) {
            try {
                IBgType iBgType = BgTypeFactory.getRemoteInstance();
                BgTypeInfo bgTypeInfo = iBgType.getBgTypeInfo((IObjectPK)new ObjectUuidPK(entityBgTemplate.getBgType().getId()), BgTypeHelper.getFullDataSelectors());
                entityBgTemplate.setBgType(bgTypeInfo);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        Iterator iterator = entityBgTemplate.getBgType().getValidBgDimensions().iterator();
        while (iterator.hasNext()) {
            kdComboBox.addItem((Object)((ValidBgDimensionInfo)iterator.next()).getBgDimension());
        }
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JComboBox)kdComboBox);
        kdtRefDimensions.getColumn("bgDimension").setEditor((ICellEditor)cellEditor);
        kdtRefDimensions.removeRows();
        Iterator iter = entityBgTemplate.getRefDimensions().iterator();
        while (iter.hasNext()) {
            ReferencedDimensionInfo refDimInfo = (ReferencedDimensionInfo)iter.next();
            IRow ir = kdtRefDimensions.addRow();
            ir.setUserObject((Object)refDimInfo);
            ICell cell = ir.getCell(0);
            cell.setValue((Object)refDimInfo.getBgDimension());
            cell = ir.getCell(1);
            cell.setValue((Object)new Boolean(refDimInfo.isIsPrimary()));
            cell = ir.getCell(2);
            cell.setValue((Object)new Integer(refDimInfo.getSeq()));
        }
    }

    public static void readKdtBgRefDimensions(BgTemplateInfo entityBgTemplate, KDTable kdtRefDimensions) {
        ReferencedDimensionCollection refs = entityBgTemplate.getRefDimensions();
        boolean isMultiDim = entityBgTemplate.isIsMultidimensional();
        int rowCount = kdtRefDimensions.getRowCount();
        BgDimensionEnum[] bgDimArr = new BgDimensionEnum[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            boolean isPrimary;
            int seq;
            AbstractReferencedDimensionInfo refDimInfo = null;
            IRow ir = kdtRefDimensions.getRow(i);
            ICell cell = ir.getCell("bgDimension");
            BgDimensionEnum bgDimensionEnumTemp = (BgDimensionEnum)((Object)cell.getValue());
            if (bgDimensionEnumTemp == null) continue;
            bgDimArr[i] = bgDimensionEnumTemp;
            Iterator iteratorRef = refs.iterator();
            while (iteratorRef.hasNext()) {
                ReferencedDimensionInfo referencedDimensionInfoTemp = (ReferencedDimensionInfo)iteratorRef.next();
                if (referencedDimensionInfoTemp.getBgDimension().getValue() != bgDimensionEnumTemp.getValue()) continue;
                refDimInfo = referencedDimensionInfoTemp;
                break;
            }
            if (refDimInfo == null) {
                refDimInfo = new ReferencedDimensionInfo();
                refDimInfo.setBgDimension(bgDimensionEnumTemp);
                if (isMultiDim) {
                    cell = ir.getCell("seq");
                    seq = Integer.parseInt(cell.getValue().toString());
                    refDimInfo.setSeq(seq);
                    if (seq == 1) {
                        refDimInfo.setIsPrimary(true);
                    } else {
                        refDimInfo.setIsPrimary(false);
                    }
                } else {
                    cell = ir.getCell("isPrimary");
                    isPrimary = (Boolean)cell.getValue();
                    refDimInfo.setIsPrimary(isPrimary);
                    if (isPrimary) {
                        refDimInfo.setSeq(1);
                    } else {
                        refDimInfo.setSeq(2);
                    }
                }
                refDimInfo.setBgTemplate(entityBgTemplate);
                refDimInfo.setId(BOSUuid.create((BOSObjectType)refDimInfo.getBOSType()));
                entityBgTemplate.getRefDimensions().add((ReferencedDimensionInfo)refDimInfo);
                continue;
            }
            if (refDimInfo.getBgItems().size() > 0) {
                BgItemInfo bgItem = refDimInfo.getBgItems().get(0);
                if (bgItem.getBgDimension() != null) {
                    if (!bgItem.getBgDimension().equals((Object)refDimInfo.getBgDimension())) {
                        refDimInfo.getBgItems().clear();
                    }
                } else {
                    refDimInfo.getBgItems().clear();
                }
            }
            if (isMultiDim) {
                cell = ir.getCell("seq");
                seq = Integer.parseInt(cell.getValue().toString());
                refDimInfo.setSeq(seq);
                if (seq == 1) {
                    refDimInfo.setIsPrimary(true);
                    continue;
                }
                refDimInfo.setIsPrimary(false);
                continue;
            }
            cell = ir.getCell("isPrimary");
            isPrimary = (Boolean)cell.getValue();
            refDimInfo.setIsPrimary(isPrimary);
            if (isPrimary) {
                refDimInfo.setSeq(1);
                continue;
            }
            refDimInfo.setSeq(2);
        }
        int size = refs.size();
        if (size > rowCount) {
            int[] indexArr = new int[size];
            block2: for (int i = 0; i < size; ++i) {
                ReferencedDimensionInfo refDimInfoTemp = refs.get(i);
                for (int j = 0; j < rowCount; ++j) {
                    if (refDimInfoTemp.getBgDimension().equals((Object)bgDimArr[j])) continue;
                    indexArr[i] = 1;
                    continue block2;
                }
            }
            for (int k = size - 1; k >= 0; --k) {
                if (indexArr[k] != 1) continue;
                refs.removeObject(k);
            }
        }
        int size1 = refs.size();
        VOComparator comparate = new VOComparator(new String[]{"seq"});
        Object[] ar = refs.toArray();
        Arrays.sort(ar, comparate);
        refs.clear();
        for (int i = 0; i < size1; ++i) {
            refs.add((ReferencedDimensionInfo)ar[i]);
        }
    }

    public static void initKdtBgTpRows(BgTemplateInfo entityBgTemplate, KDTable kdtBgTpRows) {
        KDComboBox kdComboBox = new KDComboBox();
        Iterator iterator = BgCtrlTypeEnum.iterator();
        while (iterator.hasNext()) {
            kdComboBox.addItem(iterator.next());
        }
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JComboBox)kdComboBox);
        kdtBgTpRows.getColumn("bgControlType").setEditor((ICellEditor)cellEditor);
        BgClientHelper.initBgItemColumnAndRow(entityBgTemplate, kdtBgTpRows);
        for (int r = 0; r < kdtBgTpRows.getRowCount(); ++r) {
            IRow row = kdtBgTpRows.getRow(r);
            BgTemplateRowInfo bgTpRowInfo = entityBgTemplate.getBgTpRows().get(r);
            ICell cell = row.getCell("bgControlType");
            cell.setValue((Object)bgTpRowInfo.getBgControlType());
            cell = row.getCell("isFlexibleCtrl");
            cell.setValue((Object)new Boolean(bgTpRowInfo.isIsFlexibleCtrl()));
            cell = row.getCell("flexibleBgCtrlParam");
            cell.setValue((Object)bgTpRowInfo.getFlexibleBgCtrlParam());
        }
        BgTemplateEditHelper.adjustKdtBgRows(kdtBgTpRows);
        kdtBgTpRows.doLayout();
    }

    public static void renewKdtBgTpRows(KDTable kdtBgTpRows) {
        kdtBgTpRows.removeRows();
        int bgCtrlTypeColumnIdx = kdtBgTpRows.getColumnIndex("bgControlType");
        for (int i = 0; i < bgCtrlTypeColumnIdx; ++i) {
            kdtBgTpRows.removeColumn(0);
        }
    }

    public static void readKdtBgTpRows(BgTemplateInfo entityBgTemplate, KDTable kdtBgTpRows) {
        int itemColumnsNum = entityBgTemplate.getVisibleDims().size();
        Iterator iter = entityBgTemplate.getBgTpRows().iterator();
        int rowCount = 0;
        while (iter.hasNext()) {
            BgTemplateRowInfo bgTpRowInfo = (BgTemplateRowInfo)iter.next();
            IRow ir = kdtBgTpRows.getRow(rowCount);
            ICell cell = ir.getCell(itemColumnsNum + 0);
            bgTpRowInfo.setBgControlType((BgCtrlTypeEnum)((Object)cell.getValue()));
            cell = ir.getCell(itemColumnsNum + 1);
            bgTpRowInfo.setIsFlexibleCtrl((Boolean)cell.getValue());
            cell = ir.getCell(itemColumnsNum + 2);
            if (cell.getValue() instanceof BigDecimal) {
                bgTpRowInfo.setFlexibleBgCtrlParam((BigDecimal)cell.getValue());
            } else {
                String str = (String)cell.getValue();
                if (str == null || str.equals("")) {
                    str = "0";
                }
                BigDecimal big = new BigDecimal(str);
                bgTpRowInfo.setFlexibleBgCtrlParam(big);
            }
            bgTpRowInfo.setBgTemplate(entityBgTemplate);
            ++rowCount;
        }
    }

    public static void initKdtBgItem(BgTemplateInfo editData, BgDimensionEnum bgDimensionEnum, KDTable kDTableItems, IUIObject uiObj) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        kDTableItems.removeRows();
        Iterator iter = editData.getRefDim(bgDimensionEnum).getBgItems().iterator();
        while (iter.hasNext()) {
            BgItemInfo bii = (BgItemInfo)iter.next();
            IRow row = kDTableItems.addRow();
            BgTemplateEditHelper.fillBgItemTableRow(row, bii);
        }
        kDTableItems.doLayout();
        BgTemplateEditHelper.renderBgItemTable(editData.getOrgUnit(), editData.getBgType(), bgDimensionEnum, kDTableItems, "projectNumber", false, uiObj);
        if (bgDimensionEnum.getValue() == 100 || bgDimensionEnum.getValue() == 110) {
            kDTableItems.getColumn("UOM").getStyleAttributes().setHided(false);
        } else {
            kDTableItems.getColumn("UOM").getStyleAttributes().setHided(true);
        }
    }

    private static void renderBgItemTable(FullOrgUnitInfo orgUnitInfo, BgTypeInfo bgTypeInfo, BgDimensionEnum bgDimensionEnum, KDTable kDTableItems, String cellKey, boolean editable, IUIObject uiObj) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        IBgItemHelper iBgItemHelper = new BgItemHelperFactory().getBgItemHelper(bgTypeInfo, bgDimensionEnum, orgUnitInfo);
        KDBizPromptBox kDBizPromptBox = iBgItemHelper.getBizPromptBox(uiObj);
        if (kDBizPromptBox != null) {
            kDBizPromptBox.setEditable(editable);
            KDTDefaultCellEditor kDTDefaultCellEditor = new KDTDefaultCellEditor((IKDEditor)kDBizPromptBox);
            kDTableItems.getColumn(cellKey).setEditor((ICellEditor)kDTDefaultCellEditor);
        }
    }

    public static void fillBgItemTableRow(IRow row, BgItemInfo bgItemInfo) {
        if (bgItemInfo == null) {
            row.setUserObject(null);
            row.getCell("projectNumber").setValue(null);
            row.getCell("projectName").setValue(null);
            row.getCell("UOM").setValue(null);
        } else {
            row.setUserObject((Object)bgItemInfo);
            row.getCell("projectNumber").setValue((Object)bgItemInfo.getItemNumber());
            row.getCell("projectName").setValue((Object)bgItemInfo.getItemName());
            if (bgItemInfo.getMeasureUnit() != null) {
                MeasureUnitInfo measure = bgItemInfo.getMeasureUnit();
                if (measure.getName() == null) {
                    try {
                        IMeasureUnit iMeasure = MeasureUnitFactory.getRemoteInstance();
                        MeasureUnitInfo tmp = (MeasureUnitInfo)iMeasure.getValue((IObjectPK)new ObjectUuidPK(measure.getId()));
                        measure.setName(tmp.getName());
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                    catch (EASBizException e) {
                        e.printStackTrace();
                    }
                }
                row.getCell("UOM").setValue((Object)bgItemInfo.getMeasureUnit().getName());
            }
        }
    }

    public static void initKdtBgTpCol(BgTemplateInfo editData, KDTable kdtBgTpCol) {
        kdtBgTpCol.removeRows();
        Iterator iter = editData.getBgTpColumns().iterator();
        while (iter.hasNext()) {
            BgTemplateColumnInfo bgTpColInfo = (BgTemplateColumnInfo)iter.next();
            IRow row = kdtBgTpCol.addRow();
            BgTemplateEditHelper.fillBgColumnTableRow(row, bgTpColInfo);
        }
        kdtBgTpCol.doLayout();
        BgTemplateEditHelper.renderKdtBgTpColumn(editData, kdtBgTpCol);
    }

    private static void renderKdtBgTpColumn(BgTemplateInfo bgTemplateInfo, KDTable kdtBgTpColumns) {
        BgElementF7Selector bgEleF7 = new BgElementF7Selector();
        bgEleF7.setBgTypeInfo(bgTemplateInfo.getBgType());
        KDBizPromptBox elePromptBox = new KDBizPromptBox();
        elePromptBox.setSelector((KDPromptSelector)bgEleF7);
        elePromptBox.setDisplayFormat("$number$");
        elePromptBox.setEditFormat("$number$");
        elePromptBox.setEditable(false);
        KDTDefaultCellEditor kDTDefaultCellEditor = new KDTDefaultCellEditor((IKDEditor)elePromptBox);
        kdtBgTpColumns.getColumn("bgElement.number").setEditor((ICellEditor)kDTDefaultCellEditor);
    }

    public static void readKdtBgTpCol(BgTemplateInfo editData, KDTable kdtBgTpCol) {
        editData.getBgTpColumns().clear();
        int size = kdtBgTpCol.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = kdtBgTpCol.getRow(i);
            if (row.getUserObject() == null || !(row.getUserObject() instanceof BgTemplateColumnInfo)) continue;
            BgTemplateColumnInfo bgTpColInfo = (BgTemplateColumnInfo)row.getUserObject();
            bgTpColInfo.setBgTemplate(editData);
            ICell cell = null;
            cell = row.getCell("seq");
            bgTpColInfo.setSeq(Integer.parseInt(cell.getValue().toString()));
            cell = row.getCell("isControlled");
            bgTpColInfo.setIsControlled((Boolean)cell.getValue());
            cell = row.getCell("formula");
            if (cell != null && cell.getValue() != null) {
                bgTpColInfo.setFormula(cell.getValue().toString());
            }
            editData.getBgTpColumns().add(bgTpColInfo);
        }
    }

    public static void fillBgColumnTableRow(IRow row, BgTemplateColumnInfo bgTpColInfo) {
        row.setUserObject((Object)bgTpColInfo);
        row.getCell("bgElement.number").setValue((Object)bgTpColInfo.getBgElement().getNumber());
        row.getCell("bgElement.name").setValue((Object)bgTpColInfo.getBgElement().getName());
        row.getCell("seq").setValue((Object)new BigDecimal(Integer.toString(bgTpColInfo.getSeq())));
        row.getCell("isControlled").setValue((Object)new Boolean(bgTpColInfo.isIsControlled()));
        row.getCell("formula").setValue((Object)bgTpColInfo.getFormula());
    }

    public static CurrencyCollection getCurrencyFromBox(KDBizPromptBox bizPromptBoxCurrency) {
        Object[] objects = (Object[])bizPromptBoxCurrency.getData();
        CurrencyCollection currencyCollection = new CurrencyCollection();
        for (int i = 0; i < objects.length; ++i) {
            CurrencyInfo cyInfo = (CurrencyInfo)objects[i];
            if (cyInfo == null) continue;
            currencyCollection.add(cyInfo);
        }
        return currencyCollection;
    }

    public static void adjustKdtBgRows(KDTable kdtBgTpRows) {
        if (kdtBgTpRows.getStyleAttributes().isLocked()) {
            return;
        }
        int size = kdtBgTpRows.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = kdtBgTpRows.getRow(i);
            BgTemplateEditHelper.adjustAKdtBgRow(row);
        }
    }

    public static void adjustAKdtBgRow(IRow row) {
        ICell ctrlTypeCell = row.getCell("bgControlType");
        ICell isFlexibleCell = row.getCell("isFlexibleCtrl");
        ICell paramCell = row.getCell("flexibleBgCtrlParam");
        BgTemplateEditHelper.adjustByCtrlType(ctrlTypeCell, isFlexibleCell, paramCell);
        BgTemplateEditHelper.adjustByFlexible(isFlexibleCell, paramCell);
    }

    public static void adjustByCtrlType(ICell ctrlTypeCell, ICell isFlexibleCell, ICell paramCell) {
        BgCtrlTypeEnum ctrlType = (BgCtrlTypeEnum)((Object)ctrlTypeCell.getValue());
        if (ctrlType == null) {
            ctrlType = BgCtrlTypeEnum.NoCtrl;
        }
        if (ctrlType.equals((Object)BgCtrlTypeEnum.NoCtrl)) {
            isFlexibleCell.setValue((Object)new Boolean(false));
            paramCell.setValue(null);
            isFlexibleCell.getStyleAttributes().setLocked(true);
            paramCell.getStyleAttributes().setLocked(true);
        } else {
            isFlexibleCell.getStyleAttributes().setLocked(false);
            paramCell.getStyleAttributes().setLocked(false);
        }
    }

    public static void adjustByFlexible(ICell isFlexibleCell, ICell paramCell) {
        Boolean isFlexibleCtrl = (Boolean)isFlexibleCell.getValue();
        if (isFlexibleCtrl.booleanValue()) {
            if (paramCell.getValue() == null) {
                paramCell.setValue((Object)BgClientHelper.getDecimalFormat().format(new BigDecimal("1.00")));
            }
            paramCell.getStyleAttributes().setLocked(false);
        } else {
            paramCell.setValue(null);
            paramCell.getStyleAttributes().setLocked(true);
        }
    }

    public static void addCodeRule(KDTextField txtNumber, BgTemplateInfo bgTpInfo) {
        String number = null;
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            String orgId = null;
            orgId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
            if (orgId == null || orgId.equals("")) {
                return;
            }
            number = iCodingRuleManager.getNumber((IObjectValue)bgTpInfo, orgId);
        }
        catch (Exception e) {
            number = null;
        }
        if (number != null) {
            txtNumber.setText(number);
        }
    }

    public static boolean isChangeDim(ReferencedDimensionCollection referencedDimensionCollection) {
        boolean isChange = false;
        Iterator iterator = referencedDimensionCollection.iterator();
        while (iterator.hasNext()) {
            ReferencedDimensionInfo refDim = (ReferencedDimensionInfo)iterator.next();
            if (!BgORMEngine.isNeedUpdate((IObjectValue)refDim)) continue;
            isChange = true;
            break;
        }
        return isChange;
    }
}

