/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.OrgViewUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.BgOrgHelper;
import com.kingdee.eas.ma.bg.BgRptTemplateFactory;
import com.kingdee.eas.ma.bg.BgTemplateDAFactory;
import com.kingdee.eas.ma.bg.BgTemplateFactory;
import com.kingdee.eas.ma.bg.BgTemplateHelper;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.BgTypeFactory;
import com.kingdee.eas.ma.bg.BgTypeHelper;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.IBgTemplate;
import com.kingdee.eas.ma.bg.IBgTemplateDA;
import com.kingdee.eas.ma.bg.IBgType;
import com.kingdee.eas.ma.bg.client.AbstractBgTemplateListUI;
import com.kingdee.eas.ma.bg.client.BgClientHelper;
import com.kingdee.eas.ma.bg.client.BgRptTemplateEditUI;
import com.kingdee.eas.ma.bg.client.BgSubOrgUnitSelectorUI;
import com.kingdee.eas.ma.bg.client.BgTemplateEdit;
import com.kingdee.eas.ma.bg.client.BgTypeSelectorUI;
import com.kingdee.eas.ma.bg.client.BizTemplateListHandler;
import com.kingdee.eas.ma.bg.client.ITemplateListHandler;
import com.kingdee.eas.ma.bg.client.RptTemplatetListHandler;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.TreeSelectionEvent;

public class BgTemplateListUI
extends AbstractBgTemplateListUI {
    private OrgViewType[] orgView = null;
    BgTypeInfo selectedBgTypeInfo;
    boolean isGroupStart = BgHelper.isStartGroupUsing();

    @Override
    protected void enableBtns(boolean flag) {
        super.enableBtns(flag);
        if (this.btnAssign != null) {
            this.btnAssign.setEnabled(flag);
            this.btnClone.setEnabled(flag);
            this.actionAddNew.setEnabled(flag);
            this.btnAddNew.setEnabled(flag);
        }
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor queryExecutor = super.getQueryExecutor(queryPK, viewInfo);
        try {
            queryExecutor.setParameter(1, (Object)this.getOrgUnitId());
        }
        catch (BOSException e) {
            e.getMessage();
        }
        return queryExecutor;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        FullOrgUnitInfo orgUnitInfo = this.getBGOrgUnitInfo();
        if (orgUnitInfo == null) {
            String strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"plsSelectOrgType");
            MsgBox.showWarning((Component)((Object)this), (String)strErr);
            SysUtil.abort();
        }
        CtrlUnitInfo orgCtrl = SysContext.getSysContext().getCurrentCtrlUnit();
        BgClientHelper.checkIsOnCU((CoreUI)this, orgUnitInfo, orgCtrl);
        int orgType = 0;
        if (BgTemplateHelper.getOrgViewType(orgUnitInfo).getValue() == 15) {
            if (orgUnitInfo.isIsCompanyOrgUnit()) {
                orgType = 1;
            }
            if (!orgUnitInfo.isIsCompanyOrgUnit() && orgUnitInfo.isIsProfitOrgUnit()) {
                orgType = 6;
            }
            if (!orgUnitInfo.isIsCompanyOrgUnit() && !orgUnitInfo.isIsProfitOrgUnit() && orgUnitInfo.isIsCostOrgUnit()) {
                orgType = 5;
            }
        } else {
            orgType = NewOrgViewHelper.convert((OrgViewType)BgTemplateHelper.getOrgViewType(orgUnitInfo)).getValue();
        }
        if (orgUnitInfo == null) {
            return;
        }
        IBgTemplateDA ibtda = BgTemplateDAFactory.getRemoteInstance();
        boolean isGroup = ibtda.getIsGrouping(orgUnitInfo.getId().toString());
        if (isGroup && !this.isGroupStart) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"GroupNotUsing"));
            SysUtil.abort();
        }
        UIContext uiContext1 = new UIContext((Object)this);
        uiContext1.put((Object)"orgType", (Object)new Integer(orgType));
        IUIWindow typeSelector = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgTypeSelectorUI.class.getName(), (Map)uiContext1, null, null);
        typeSelector.show();
        this.selectedBgTypeInfo = ((BgTypeSelectorUI)typeSelector.getUIObject()).getBgTypeInfo();
        if (this.selectedBgTypeInfo == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"EditOrg", (Object)orgUnitInfo);
        uiContext.put((Object)"identity", (Object)String.valueOf(System.currentTimeMillis()));
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        if (((EditUI)uiWindow.getUIObject()).isSave()) {
            this.execQuery();
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
            this.showMessage();
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        FullOrgUnitInfo orgUnitInfo = this.getBGOrgUnitInfo();
        CtrlUnitInfo orgCtrl = SysContext.getSysContext().getCurrentCtrlUnit();
        BgClientHelper.checkIsOnCU((CoreUI)this, orgUnitInfo, orgCtrl);
        String id = this.getSelectedKeyValue();
        this.checkRemovable(id);
        if (!this.confirmRemove(id)) {
            return;
        }
        this.initSelectedBgTypeInfo();
        ITemplateListHandler clientHandler = this.getClientHandler(this.selectedBgTypeInfo);
        clientHandler.delete((IObjectPK)new ObjectUuidPK(id));
        this.execQuery();
    }

    protected boolean confirmRemove(String id) throws BOSException {
        boolean confirmResult = false;
        IBgTemplate ibt = BgTemplateFactory.getRemoteInstance();
        if (ibt.checkRefByBgScheme(BOSUuid.read((String)id))) {
            confirmResult = MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"Confirm_Delete_For_Scheme")));
        } else {
            return super.confirmRemove();
        }
        return confirmResult;
    }

    private void checkRemovable(String id) throws BOSException {
        IBgTemplate ibt = BgTemplateFactory.getRemoteInstance();
        if (ibt.checkRefByBgForm(BOSUuid.read((String)id))) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"InfoNoDeleteForForm"));
            SysUtil.abort();
        }
        if (ibt.checkRefByChild(BOSUuid.read((String)id))) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"InfoNoDeleteForChild"));
            SysUtil.abort();
        }
    }

    public String getUITitle() {
        return EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"BgTemplate");
    }

    private void checkAssignLogic(FullOrgUnitInfo currOrgUnitInfo, OrgUnitCollection orgs) throws EASBizException, BOSException {
        Vector validOrgTypeVec = BgTypeHelper.getOrgTypeByBgType(this.selectedBgTypeInfo);
        OrgType[] orgType = null;
        if (BgTemplateHelper.getOrgViewType(currOrgUnitInfo).getValue() == 15) {
            orgType = new OrgType[1];
            if (currOrgUnitInfo.isIsCompanyOrgUnit()) {
                orgType[0] = OrgType.Company;
            } else if (!currOrgUnitInfo.isIsCompanyOrgUnit() && currOrgUnitInfo.isIsProfitOrgUnit()) {
                orgType[0] = OrgType.ProfitCenter;
            } else if (!currOrgUnitInfo.isIsCompanyOrgUnit() && !currOrgUnitInfo.isIsProfitOrgUnit() && currOrgUnitInfo.isIsCostOrgUnit()) {
                orgType[0] = OrgType.CostCenter;
            }
        } else {
            orgType = new OrgType[]{NewOrgViewHelper.convert((OrgViewType)BgTemplateHelper.getOrgViewType(currOrgUnitInfo))};
        }
        Iterator orgIter = orgs.iterator();
        for (int i = 0; i < orgType.length; ++i) {
            if (validOrgTypeVec.contains(orgType[i])) continue;
            MsgBox.showInfo((Component)((Object)this), (String)(this.selectedBgTypeInfo.getName() + EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"NotAssignTo") + orgType[i].getAlias()));
            SysUtil.abort();
        }
    }

    private void checkAssignValid() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        boolean isCurrent = false;
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            ICell cell = row.getCell("BgTemplate.isCurrent");
            isCurrent = (Boolean)cell.getValue();
        }
        if (!isCurrent) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"notAssign"));
            SysUtil.abort();
        }
    }

    @Override
    protected void treeOrgUnit_valueChanged(TreeSelectionEvent e) throws Exception {
        boolean isPermiss;
        FullOrgUnitInfo orgInfo;
        if (!this.treeOrgUnit.isEnabled()) {
            return;
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        if (node != null && OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node)) {
            this.tblMain.removeRows();
            this.enableBtns(false);
            if (this.isInit) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"SelectPermiUnit"));
                this.enableBtns(false);
                SysUtil.abort();
            }
        } else {
            FullOrgUnitInfo orgUnitInfo = this.getBGOrgUnitInfo();
            this.enableBtns(true);
            if (orgUnitInfo == null) {
                return;
            }
            this.tblMain.removeRows();
            this.execQuery();
        }
        if ((orgInfo = this.getBGOrgUnitInfo()) == null) {
            return;
        }
        int count = node.getChildCount();
        if (this.btnAssign != null) {
            if (count == 0) {
                this.btnAssign.setEnabled(false);
                this.itemAssign.setEnabled(false);
            } else {
                this.btnAssign.setEnabled(true);
                this.itemAssign.setEnabled(true);
            }
        }
        if (isPermiss = this.checkPermissionByOrg((OrgUnitInfo)orgInfo)) {
            this.actionAddNew.setEnabled(true);
            this.btnAddNew.setEnabled(true);
        } else {
            this.actionAddNew.setEnabled(isPermiss);
            this.btnAddNew.setEnabled(isPermiss);
        }
    }

    protected String getEditUIName() {
        if (this.selectedBgTypeInfo == null) {
            return null;
        }
        if (this.selectedBgTypeInfo.isIsRptBgForm()) {
            return BgRptTemplateEditUI.class.getName();
        }
        return BgTemplateEdit.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        this.initSelectedBgTypeInfo();
        if (BgTypeHelper.isRptBudget(this.selectedBgTypeInfo)) {
            return BgRptTemplateFactory.getRemoteInstance();
        }
        return BgTemplateFactory.getRemoteInstance();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    private void initSelectedBgTypeInfo() throws EASBizException, BOSException {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock == null) {
            return;
        }
        int rowIndex = selectBlock.getTop();
        IRow row = this.tblMain.getRow(rowIndex);
        String id = (String)row.getCell("bgType.id").getValue();
        IBgType bgType = BgTypeFactory.getRemoteInstance();
        this.selectedBgTypeInfo = bgType.getBgTypeInfo("select id,name,number,isRptBgForm where id='" + id + "'");
    }

    private ITemplateListHandler getClientHandler(BgTypeInfo bgTypeInfo) {
        ITemplateListHandler handler = null;
        handler = bgTypeInfo.isIsRptBgForm() ? new RptTemplatetListHandler() : new BizTemplateListHandler();
        return handler;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        FullOrgUnitInfo orgUnitInfo = this.getBGOrgUnitInfo();
        CtrlUnitInfo orgCtrl = SysContext.getSysContext().getCurrentCtrlUnit();
        BgClientHelper.checkIsOnCU((CoreUI)this, orgUnitInfo, orgCtrl);
        String id = this.getSelectedKeyValue();
        this.initSelectedBgTypeInfo();
        super.actionEdit_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.initSelectedBgTypeInfo();
        super.actionView_actionPerformed(e);
    }

    @Override
    public void onLoad() throws Exception {
        OrgUnitInfo org = SysContext.getSysContext().getCurrentOrgUnit();
        Vector vec = BgOrgHelper.getOrgViewTypes(org);
        this.orgView = new OrgViewType[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            this.orgView[i] = (OrgViewType)vec.get(i);
        }
        super.onLoad();
        this.setIcon();
        this.separator2.setVisible(false);
        this.kDSeparator2.setVisible(false);
    }

    public void setIcon() {
        this.btnClone.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
        this.btnAssign.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        super.tblMain_doRequestRowSet(e);
        this.setMerge();
    }

    private void setMerge() {
        int size = this.tblMain.getColumnCount();
        for (int i = 0; i < size; ++i) {
            IColumn column = this.tblMain.getColumn(i);
            String key = column.getKey();
            if (key.equals("bgType.name")) {
                column.setMergeable(true);
                continue;
            }
            column.setMergeable(false);
        }
        this.tblMain.getMergeManager().setMergeMode(1);
    }

    @Override
    public void actionAssign_actionPerformed(ActionEvent e) throws Exception {
        super.actionAssign_actionPerformed(e);
        this.checkSelected();
        FullOrgUnitInfo org = this.getBGOrgUnitInfo();
        CtrlUnitInfo orgCtrl = SysContext.getSysContext().getCurrentCtrlUnit();
        BgClientHelper.checkIsOnCU((CoreUI)this, org, orgCtrl);
        this.initSelectedBgTypeInfo();
        boolean isGroupModel = BgHelper.isGroupModel();
        this.checkAssignValid();
        if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"confirmAssign")) == 2) {
            return;
        }
        String id = this.getSelectedKeyValue();
        INewOrgViewFacade iNew = NewOrgViewFacadeFactory.getRemoteInstance();
        int orgView = (Integer)org.get("treeType");
        OrgUnitCollection orgUnitCollectionSub = iNew.getChildren(org.getId().toString(), OrgViewType.getEnum((int)orgView));
        if (orgUnitCollectionSub == null || orgUnitCollectionSub.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"NoSubOrg"));
            return;
        }
        OrgUnitCollection orgUnitFilterCollectionSub = new OrgUnitCollection();
        if (orgUnitCollectionSub.size() > 0) {
            orgUnitFilterCollectionSub = BgTypeHelper.getOrgUnitCollByBgType(this.selectedBgTypeInfo, orgUnitCollectionSub);
        }
        if (orgUnitFilterCollectionSub.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"NoMatchSubOrgs"));
            return;
        }
        UIContext uiContextOrg = new UIContext((Object)this);
        uiContextOrg.put((Object)"EditOrg", (Object)orgUnitFilterCollectionSub);
        IUIWindow orgSelectorUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgSubOrgUnitSelectorUI.class.getName(), (Map)uiContextOrg, null, null);
        orgSelectorUI.show();
        OrgUnitCollection subOrgs = ((BgSubOrgUnitSelectorUI)orgSelectorUI.getUIObject()).getOrgUnitCollectionSub();
        if (subOrgs == null || subOrgs.size() == 0) {
            return;
        }
        this.checkAssignLogic(org, subOrgs);
        if (!isGroupModel) {
            this.checkBgTypeForDisperseModel(this.selectedBgTypeInfo);
            for (int i = 0; i < subOrgs.size(); ++i) {
                OrgUnitInfo orgUnitInfo = subOrgs.get(i);
                if (!orgUnitInfo.isIsCompanyOrgUnit()) continue;
                String strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"CanNotAssignToCompany");
                MsgBox.showWarning((Component)((Object)this), (String)strErr);
                SysUtil.abort();
            }
        }
        int size1 = subOrgs.size();
        Vector<String> orgIdVec = new Vector<String>(size1);
        for (int i = 0; i < size1; ++i) {
            orgIdVec.add(subOrgs.get(i).getId().toString());
        }
        ITemplateListHandler clientHandler = this.getClientHandler(this.selectedBgTypeInfo);
        clientHandler.assign(orgIdVec, (IObjectPK)new ObjectUuidPK(id));
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"InfoAssignOK"));
        this.execQuery();
    }

    @Override
    public void actionClone_actionPerformed(ActionEvent e) throws Exception {
        super.actionClone_actionPerformed(e);
        this.checkSelected();
        FullOrgUnitInfo orgUnitInfo = this.getBGOrgUnitInfo();
        CtrlUnitInfo orgCtrl = SysContext.getSysContext().getCurrentCtrlUnit();
        BgClientHelper.checkIsOnCU((CoreUI)this, orgUnitInfo, orgCtrl);
        if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"confirmCopy")) == 2) {
            return;
        }
        String id = this.getSelectedKeyValue();
        BgTemplateInfo bgTpInfo = BgTemplateDAFactory.getRemoteInstance().getBgTemplate(id);
        BgTemplateInfo bgTpInfo1 = bgTpInfo.deepClone();
        bgTpInfo1.setId(null);
        bgTpInfo1.setName("Clone_" + bgTpInfo1.getName());
        bgTpInfo1.setNumber("Clone_" + bgTpInfo1.getNumber());
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        uiContext.put((Object)"InitDataObject", (Object)bgTpInfo1);
        uiContext.put((Object)"BgType", (Object)bgTpInfo1.getBgType());
        uiContext.put((Object)"EditOrg", (Object)bgTpInfo1.getOrgUnit());
        uiContext.put((Object)"OrgPath", (Object)this.getOrgIDPath());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        this.execQuery();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"BgType", (Object)this.selectedBgTypeInfo);
        try {
            uiContext.put((Object)"OrgPath", (Object)this.getOrgIDPath());
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
    }

    public void checkBgTypeForDisperseModel(BgTypeInfo bgTypeInfo) throws EASBizException, BOSException {
        boolean isPass = true;
        String strNum = bgTypeInfo.getNumber();
        if (strNum.equals("IncomeBudget") || strNum.equals("ExpenseBudget") || strNum.equals("AccountBudget") || strNum.equals("ProjectBudget")) {
            String strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"noStartGroupAppModel");
            MsgBox.showWarning((Component)((Object)this), (String)strErr);
            SysUtil.abort();
        }
    }

    @Override
    protected void ontblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.ontblMain_tableSelectChanged(e);
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow iRow = this.tblMain.getRow(rowIndex);
        if (iRow == null) {
            return;
        }
        String id = (String)iRow.getCell("id").getValue();
        this.initSelectedBgTypeInfo();
        String strNum = this.selectedBgTypeInfo.getNumber();
        if (strNum.equals("IncomeStatementBudget") || strNum.equals("BalanceSheetBudget")) {
            IBgTemplate ibt = BgTemplateFactory.getRemoteInstance();
            if (ibt.checkRefByBgForm(BOSUuid.read((String)id))) {
                this.btnEdit.setEnabled(false);
            } else {
                this.btnEdit.setEnabled(true);
            }
        } else {
            this.btnEdit.setEnabled(true);
        }
    }
}

