/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgTypeCollection;
import com.kingdee.eas.ma.bg.BgTypeFactory;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.IBgType;
import com.kingdee.eas.ma.bg.client.AbstractBgTypeF7UI2;
import com.kingdee.eas.ma.bg.client.BgTypeF7UI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class BgTypeF7UI2
extends AbstractBgTypeF7UI2 {
    private boolean isCancel = true;
    private BgTypeInfo result = null;
    private final String NAME = "name";
    private final String NUMBER = "number";
    private static final Logger logger = CoreUIObject.getLogger(BgTypeF7UI.class);

    public void initKDtable() {
        this.kdtable.removeHeadRows();
        this.kdtable.removeRows();
        this.kdtable.removeColumns();
        this.kdtable.checkParsed();
        this.kdtable.getStyleAttributes().setLocked(true);
        IColumn iColumn = this.kdtable.addColumn();
        iColumn.setKey("number");
        iColumn.setWidth(170);
        IColumn iColumn1 = this.kdtable.addColumn();
        iColumn1.setKey("name");
        iColumn1.setWidth(170);
        IRow iRow = this.kdtable.addHeadRow();
        String strNumber = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"number");
        String strName = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"name");
        iRow.getCell("number").setValue((Object)strNumber);
        iRow.getCell("name").setValue((Object)strName);
        this.kdtable.getSelectManager().setSelectMode(2);
    }

    public BgTypeF7UI2() throws Exception {
        this.initKDtable();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        int currRow = this.kdtable.getSelectManager().getActiveRowIndex();
        if (currRow != -1) {
            IRow iRow = this.kdtable.getRow(currRow);
            this.result = (BgTypeInfo)iRow.getUserObject();
        } else {
            this.result = null;
        }
        this.isCancel = false;
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCancel = true;
        this.getUIWindow().close();
    }

    @Override
    protected void kdtable_tableClicked(KDTMouseEvent e) throws Exception {
        super.kdtable_tableClicked(e);
        if (e.getClickCount() == 2) {
            this.onBtnOK();
        }
    }

    private void onBtnOK() throws BOSException, EASBizException {
        KDTSelectBlock selectBlock = this.kdtable.getSelectManager().get();
        if (selectBlock == null) {
            return;
        }
        int currRow = this.kdtable.getSelectManager().getActiveRowIndex();
        IRow iRow = this.kdtable.getRow(currRow);
        this.result = (BgTypeInfo)iRow.getUserObject();
        this.isCancel = false;
        this.getUIWindow().close();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        String strOrgNumber = (String)this.getUIContext().get("orgNumber");
        this.putDataToKDTable(strOrgNumber);
    }

    public void putDataToKDTable(String strOrgNumber) {
        block4: {
            try {
                IBgType iBgType = BgTypeFactory.getRemoteInstance();
                BgTypeCollection bgTypeCollection = iBgType.getBgTypeCollection("select id,name,number");
                if (bgTypeCollection != null) {
                    Iterator iterator = bgTypeCollection.iterator();
                    this.kdtable.removeRows();
                    while (iterator.hasNext()) {
                        BgTypeInfo bgTypeInfo = (BgTypeInfo)iterator.next();
                        IRow iRow = this.kdtable.addRow();
                        iRow.setUserObject((Object)bgTypeInfo);
                        iRow.getCell("number").setValue((Object)bgTypeInfo.getNumber());
                        iRow.getCell("name").setValue((Object)bgTypeInfo.getName());
                    }
                    break block4;
                }
                this.kdtable.removeRows();
                String strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"pleaseSelectBgType");
                MsgBox.showWarning((Component)((Object)this), (String)strErr);
                return;
            }
            catch (BOSException e) {
                throw new IllegalComponentStateException(e.toString());
            }
        }
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public BgTypeInfo getResult() {
        return this.result;
    }
}

