/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.IUserCellDisplayParser;
import com.kingdee.bos.ctrl.kdf.table.KDTEditHelper;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionEvent;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgElementEnum;
import com.kingdee.eas.ma.bg.BgElementInfo;
import com.kingdee.eas.ma.bg.BgFormDAFactory;
import com.kingdee.eas.ma.bg.BgFormFactory;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgFormProcessFactory;
import com.kingdee.eas.ma.bg.BgItemCollection;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.eas.ma.bg.BgRptTemplateInfo;
import com.kingdee.eas.ma.bg.BgRptTemplateRowCollection;
import com.kingdee.eas.ma.bg.BgRptTemplateRowInfo;
import com.kingdee.eas.ma.bg.BgTemplateColumnCollection;
import com.kingdee.eas.ma.bg.BgTemplateColumnInfo;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.BgV2ManagerFactory;
import com.kingdee.eas.ma.bg.IBgForm;
import com.kingdee.eas.ma.bg.IBgFormProcess;
import com.kingdee.eas.ma.bg.IBgV2Manager;
import com.kingdee.eas.ma.bg.client.AbstractBgV2FormEditUI;
import com.kingdee.eas.ma.bg.client.BgAgreeUI;
import com.kingdee.eas.ma.bg.client.BgCellDisplayParser;
import com.kingdee.eas.ma.bg.client.BgClientHelper;
import com.kingdee.eas.ma.bg.client.BgFormLogViewUI;
import com.kingdee.eas.ma.bg.client.BgPastRecordEditUI;
import com.kingdee.eas.ma.bg.client.BgPostilUI;
import com.kingdee.eas.ma.bg.client.BgPostilViewUI;
import com.kingdee.eas.ma.bg.client.BgV2FormEditUIHelper;
import com.kingdee.eas.ma.bg.client.BgV2FormHeadUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgV2FormEditUI
extends AbstractBgV2FormEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BgV2FormEditUI.class);
    public int totalPage = 0;
    public int CAPACITY = 23;
    public int currentPage = 0;
    public BgItemCollection[] bgItem;
    public Vector totalBgItem;
    public String bgFormId;
    public BgTemplateInfo bgTemInfo;
    public BgRptTemplateInfo bgRptTemInfo = null;
    public int dimSize;
    public Hashtable needSubmitDataMap = new Hashtable();
    public Hashtable colMap = new Hashtable();
    public Hashtable upTable = new Hashtable();
    public Hashtable downTable = new Hashtable();
    public Hashtable allDownTable = new Hashtable();
    public BigDecimal one = new BigDecimal(1);
    public String currencyId;
    public Hashtable pastDataMap = new Hashtable();
    protected String FIELD = "bgValue";
    protected boolean isLoad = false;
    public BgTypeInfo bgTypeInfo = null;
    public boolean isRptBgForm = false;
    public boolean isPageSaved = false;
    public Hashtable htElementRelation = new Hashtable();

    @Override
    public void actionViewPastRecord_actionPerformed(ActionEvent e) throws Exception {
        this.pastRecordShow();
    }

    protected IObjectValue createNewData() {
        return new BgFormInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgFormFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        this.kdt.setUserCellDisplayParser((IUserCellDisplayParser)new BgCellDisplayParser());
        this.kdt.setBeforeAction((BeforeActionListener)new TableBeforeAction());
        super.onLoad();
        this.comboCurrency.setEditable(true);
        this.comboCurrency.setEnabled(true);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.kdt.setEditable(true);
        this.setIcon();
        BgV2FormEditUIHelper.loadFields(this);
    }

    @Override
    protected void btnGo_actionPerformed(ActionEvent e) throws Exception {
        super.btnGo_actionPerformed(e);
        String page = this.txtPage.getText();
        int temp = 0;
        try {
            temp = Integer.parseInt(page);
        }
        catch (NumberFormatException e1) {
            MsgBox.showWarning((Component)((Object)this), (String)"\u8bf7\u8f93\u5165\u6570\u5b57\uff01");
            SysUtil.abort();
        }
        if (--temp < 0 || temp >= this.totalPage) {
            MsgBox.showWarning((Component)((Object)this), (String)("\u8bf7\u8f93\u51651\u5230" + this.totalPage + "\u4e4b\u95f4\u7684\u6574\u6570\uff01"));
            SysUtil.abort();
        }
        this.confirmPgChgAndSubmit();
        this.kdt.removeRows();
        this.currentPage = temp;
        this.goToCurrentPage();
        this.checkBtnState();
    }

    public void init(int i) {
        this.totalPage = this.totalBgItem.size() % i == 0 ? this.totalBgItem.size() / i : this.totalBgItem.size() / i + 1;
    }

    protected Vector getCurrentBgItem(int currentPage) {
        Vector currBgItem = new Vector(5);
        if (currentPage != this.totalPage) {
            int count = 0;
            int n = this.totalBgItem.size();
            for (int i = currentPage * this.CAPACITY; i < n && count != this.CAPACITY; ++count, ++i) {
                currBgItem.add(this.totalBgItem.get(i));
            }
        } else {
            int n = this.totalBgItem.size();
            for (int i = currentPage * this.CAPACITY; i < n; ++i) {
                currBgItem.add(this.totalBgItem.get(i));
            }
        }
        return currBgItem;
    }

    protected void putDataToTable(String bgFormId, IBgV2Manager iBgV2, int dimLength) {
        this.currencyId = ((CurrencyInfo)this.comboCurrency.getSelectedItem()).getId().toString();
        Hashtable bgDataMap = new Hashtable();
        int n = this.kdt.getRowCount();
        for (int i = 0; i < n; ++i) {
            int j;
            Vector<Object> bgItemVec = new Vector<Object>();
            int m = dimLength;
            for (j = 0; j < m; ++j) {
                bgItemVec.add(this.kdt.getRow(i).getCell(j).getValue());
            }
            try {
                bgDataMap = iBgV2.getBgDatas(bgItemVec, this.currencyId, bgFormId, this.FIELD);
                if (bgDataMap.isEmpty()) {
                    BgItemInfo[] info = new BgItemInfo[dimLength];
                    int b = dimLength;
                    for (int a = 0; a < b; ++a) {
                        info[a] = (BgItemInfo)this.kdt.getRow(i).getCell(a).getValue();
                    }
                    this.kdt.getRow(i).setUserObject((Object)info);
                }
            }
            catch (EASBizException e1) {
                this.handleException((Exception)((Object)e1));
            }
            catch (BOSException e1) {
                this.handleException((Exception)((Object)e1));
            }
            m = this.kdt.getColumnCount();
            for (j = dimLength; j < m; ++j) {
                if (bgDataMap.get(this.kdt.getColumnKey(j)) == null) {
                    this.kdt.getRow(i).getCell(j).setValue((Object)"");
                } else {
                    this.kdt.getRow(i).getCell(j).setValue((Object)((BgDataInfo)bgDataMap.get(this.kdt.getColumnKey(j))).getBigDecimal(this.FIELD));
                    if (this.pastDataMap.containsKey(((BgDataInfo)bgDataMap.get(this.kdt.getColumnKey(j))).getId().toString()) && !this.kdt.getRow(i).getCell(j).getStyleAttributes().getBackground().equals(BgClientHelper.TOTAL_COLOR)) {
                        this.kdt.getRow(i).getCell(j).getStyleAttributes().setBackground(BgClientHelper.PASTRECORD_COLOR);
                    }
                }
                this.kdt.getRow(i).getCell(j).setUserObject(bgDataMap.get(this.kdt.getColumnKey(j)));
            }
        }
        boolean is = false;
        int n2 = this.kdt.getRowCount();
        for (int i = 0; i < n2; ++i) {
            IRow row = this.kdt.getRow(i);
            if (row.getUserObject() == null || !(row.getUserObject() instanceof BgItemInfo[])) continue;
            this.remove((BgItemInfo[])row.getUserObject());
            if (is) continue;
            is = true;
        }
        if (is) {
            this.kdt.removeRows();
            this.init(this.CAPACITY);
            try {
                this.goToCurrentPage();
            }
            catch (BOSException e1) {
                this.handUIException(e1);
                e1.printStackTrace();
            }
            this.checkBtnState();
        }
    }

    public void remove(BgItemInfo[] item) {
        for (int i = this.totalBgItem.size() - 1; i >= 0; --i) {
            BgItemInfo[] temp = (BgItemInfo[])this.totalBgItem.get(i);
            boolean is = true;
            for (int j = 0; j < item.length; ++j) {
                if (item[j].getId().toString().equals(temp[j].getId().toString())) continue;
                is = false;
                break;
            }
            if (!is) continue;
            this.totalBgItem.remove(i);
        }
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        BgV2FormEditUIHelper.selectPeriod(this, this.dimSize, "out");
        this.kdt.removeRows();
        this.currentPage = 0;
        this.goToCurrentPage();
        this.checkBtnState();
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        BgV2FormEditUIHelper.selectPeriod(this, this.dimSize, "in");
        IBgFormProcess ibfp = BgFormProcessFactory.getRemoteInstance();
        if (this.editData.getBgType().isIsRptBgForm()) {
            ibfp.balanceRptBgForm(this.editData.getBgType().getId(), this.bgFormId, this.bgTemInfo.getId());
        } else {
            ibfp.balanceBgForm(this.editData.getId().toString(), 1);
        }
        this.kdt.removeRows();
        this.currentPage = 0;
        this.goToCurrentPage();
        this.checkBtnState();
    }

    @Override
    protected void kdt_editStopped(KDTEditEvent e) throws Exception {
        super.kdt_editStopped(e);
        int x = e.getRowIndex();
        int y = e.getColIndex();
        int dimSize = this.bgItem.length;
        if (!this.kdt.getColumnKey(y).startsWith("dim")) {
            IRow row = this.kdt.getRow(x);
            ICell cell = row.getCell(y);
            BgDataInfo data = (BgDataInfo)cell.getUserObject();
            PeriodInfo targetPeriod = (PeriodInfo)this.kdt.getHeadRow(0).getCell(y).getUserObject();
            PeriodInfo currentPeriod = PeriodUtils.getPeriodInfo((Date)new Date(System.currentTimeMillis()), (IObjectPK)new ObjectUuidPK(this.editData.getCompany().getId()));
            if (this.isLoad && this.editData.getState().getValue() == 4) {
                boolean isShowMsg = false;
                if (this.bgTemInfo.getBgCycle().getValue() == 3) {
                    if (targetPeriod.getPeriodYear() * 100 + targetPeriod.getPeriodNumber() < currentPeriod.getPeriodYear() * 100 + currentPeriod.getPeriodNumber()) {
                        isShowMsg = true;
                    }
                } else if (this.bgTemInfo.getBgCycle().getValue() == 2) {
                    if (targetPeriod.getPeriodYear() * 100 + targetPeriod.getPeriodQuarter() < currentPeriod.getPeriodYear() * 100 + currentPeriod.getPeriodQuarter()) {
                        isShowMsg = true;
                    }
                } else if (this.bgTemInfo.getBgCycle().getValue() == 1 && targetPeriod.getPeriodYear() < currentPeriod.getPeriodYear()) {
                    isShowMsg = true;
                }
                if (isShowMsg) {
                    MsgBox.showWarning((Component)((Object)this), (String)"\u5f53\u524d\u671f\u95f4\u4e4b\u524d\u7684\u6570\u636e\u4e0d\u80fd\u4fee\u6539\uff01");
                    cell.setValue((Object)data.getBgValue());
                    SysUtil.abort();
                }
            }
            Object obj = cell.getValue();
            BigDecimal bgValue = null;
            if (obj instanceof BigDecimal) {
                bgValue = (BigDecimal)obj;
            } else {
                String str = (String)cell.getValue();
                if (str == null || str.trim().equals("")) {
                    str = "0.00";
                }
                try {
                    bgValue = new BigDecimal(str).divide(this.one, 2, 6);
                }
                catch (NumberFormatException e1) {
                    bgValue = new BigDecimal("0.00").divide(this.one, 2, 6);
                    cell.setValue((Object)new BigDecimal("0.00"));
                }
            }
            BigDecimal diff = bgValue.subtract(data.getBigDecimal(this.FIELD));
            String key = "";
            for (int i = 0; i < dimSize; ++i) {
                key = key + ((BgItemInfo)row.getCell("dim" + i).getValue()).getId().toString() + "#";
            }
            if (this.allDownTable.containsKey(key = key.substring(0, key.length() - 1))) {
                String str = (String)this.allDownTable.get(key);
                int i = 0;
                for (i = this.isRptBgForm ? this.kdt.getRowCount() - 1 : x - 1; i >= 0; --i) {
                    if (i == x) continue;
                    String ids = "";
                    for (int kk = 0; kk < dimSize; ++kk) {
                        ids = ids + ((BgItemInfo)this.kdt.getRow(i).getCell("dim" + kk).getValue()).getId().toString() + "#";
                    }
                    ids = ids.substring(0, ids.length() - 1);
                    if (this.isRptBgForm) {
                        if (str.indexOf(ids + "+") != -1) {
                            BigDecimal old = (BigDecimal)this.kdt.getRow(i).getCell(y).getValue();
                            this.kdt.getRow(i).getCell(y).setValue((Object)old.add(diff));
                            continue;
                        }
                        if (str.indexOf(ids + "-") == -1) continue;
                        BigDecimal old = (BigDecimal)this.kdt.getRow(i).getCell(y).getValue();
                        this.kdt.getRow(i).getCell(y).setValue((Object)old.subtract(diff));
                        continue;
                    }
                    if (str.indexOf(ids) == -1) continue;
                    BigDecimal old = (BigDecimal)this.kdt.getRow(i).getCell(y).getValue();
                    this.kdt.getRow(i).getCell(y).setValue((Object)old.add(diff));
                }
            }
            if (!(Math.abs(data.getBigDecimal(this.FIELD).doubleValue() - bgValue.doubleValue()) > 0.0) || !(Math.abs(data.getBigDecimal(this.FIELD).doubleValue() - bgValue.doubleValue()) < 1.0E-5)) {
                data.setBigDecimal(this.FIELD, bgValue);
                diff = data.get("diff") == null ? diff : ((BigDecimal)data.get("diff")).add(diff);
                data.put("diff", diff);
                data.put("bgItemIds", key);
                String periodId = ((PeriodInfo)this.kdt.getHeadRow(0).getCell(y).getUserObject()).getId().toString();
                data.put("periodId", periodId);
                String elementNumber = ((BgElementInfo)this.kdt.getHeadRow(1).getCell(y).getValue()).getNumber();
                data.put("elementNumber", elementNumber);
                if (!this.needSubmitDataMap.containsKey(data.getId().toString())) {
                    this.needSubmitDataMap.remove(data.getId().toString());
                    this.needSubmitDataMap.put(data.getId().toString(), data);
                } else {
                    this.needSubmitDataMap.put(data.getId().toString(), data);
                }
            }
            this.kdt.getScriptManager().runAll();
            String eleNumber = ((BgElementInfo)this.kdt.getHeadRow(1).getCell(y).getValue()).getNumber();
            if (this.htElementRelation.get(eleNumber) != null) {
                Vector vec = (Vector)this.htElementRelation.get(eleNumber);
                String key1 = this.kdt.getColumnKey(y);
                for (int i = 0; i < vec.size(); ++i) {
                    String subNumber = (String)vec.get(i);
                    String subKey = new String(key1);
                    String subKey1 = subKey.substring(0, 47);
                    String subKey2 = subKey.substring(48, subKey.length() - 1);
                    subKey2 = subKey2.replaceAll(eleNumber, subNumber);
                    int subY = this.kdt.getColumnIndex(subKey1 + subKey2);
                    ICell subCell = this.kdt.getCell(x, subY);
                    BigDecimal temp = new BigDecimal(subCell.getValue().toString());
                    KDTEditEvent event = new KDTEditEvent((Object)subCell);
                    event.setRowIndex(x);
                    event.setColIndex(subY);
                    try {
                        this.kdt_editStopped(event);
                        continue;
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
    }

    protected void pastRecordShow() {
        int nRowIndex = this.kdt.getSelectManager().getActiveRowIndex();
        int nColumnIndex = this.kdt.getSelectManager().getActiveColumnIndex();
        if (nRowIndex == -1 || nColumnIndex == -1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"selectCell"));
            return;
        }
        IRow iRow = this.kdt.getRow(nRowIndex);
        ICell iCell = iRow.getCell(nColumnIndex);
        if (!iCell.getStyleAttributes().getBackground().equals(BgClientHelper.PASTRECORD_COLOR)) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u6ca1\u6709\u5dee\u5f02\u8bb0\u5f55\uff01");
            return;
        }
        Object obj = iCell.getUserObject();
        if (obj instanceof BgDataInfo) {
            BgDataInfo bgDataInfo = (BgDataInfo)obj;
            String formatString = iCell.getStyleAttributes().getNumberFormat();
            String id = bgDataInfo.getId().toString();
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)id);
            uiContext.put((Object)"formatString", (Object)formatString);
            uiContext.put((Object)"formState", (Object)new Integer(this.editData.getState().getValue()));
            String strClassName = BgPastRecordEditUI.class.getName();
            try {
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(strClassName, (Map)uiContext, null, OprtState.VIEW);
                uiWindow.show();
            }
            catch (UIException e) {
                this.handUIException(e);
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"noPastRecord"));
        }
    }

    public void setIcon() {
        this.btnGo.setIcon(EASResource.getIcon((String)"imgTbtn_post"));
        this.btnFstPg.setIcon(EASResource.getIcon((String)"imgTbtn_first"));
        this.btnPrePg.setIcon(EASResource.getIcon((String)"imgTbtn_previous"));
        this.btnNxtPg.setIcon(EASResource.getIcon((String)"imgTbtn_next"));
        this.btnLstPg.setIcon(EASResource.getIcon((String)"imgTbtn_last"));
        this.btnImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnViewPastRecord.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.btnViewPostil.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.btnViewLog.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.btnAgree.setIcon(EASResource.getIcon((String)"imgTbtn_postil"));
        this.btnPostil.setIcon(EASResource.getIcon((String)"imgTbtn_reportpostil"));
        this.btnRename.setIcon(EASResource.getIcon((String)"imgTbtn_creat"));
        this.btnFstPg.setText(null);
        this.btnPrePg.setText(null);
        this.btnNxtPg.setText(null);
        this.btnLstPg.setText(null);
        this.btnEdit.setVisible(false);
        if (this.oprtState.equals(OprtState.EDIT)) {
            this.btnEdit.setVisible(false);
            this.btnRename.setEnabled(true);
            this.btnImport.setEnabled(true);
            this.btnExport.setEnabled(true);
            this.btnPostil.setVisible(false);
            this.btnAgree.setVisible(false);
            this.btnViewLog.setEnabled(true);
            this.btnViewPastRecord.setEnabled(true);
            this.btnViewPostil.setEnabled(true);
        } else if (this.oprtState.equals(OprtState.VIEW)) {
            this.btnEdit.setVisible(false);
            this.btnEdit.setEnabled(true);
            this.btnRename.setEnabled(false);
            this.btnImport.setEnabled(false);
            this.btnExport.setEnabled(false);
            this.btnViewLog.setEnabled(true);
            this.btnViewPastRecord.setEnabled(true);
            this.btnViewPostil.setEnabled(true);
            this.btnPostil.setEnabled(true);
            this.btnAgree.setEnabled(true);
        } else if (this.oprtState.equals(OprtState.ADDNEW)) {
            this.btnPostil.setVisible(false);
            this.btnAgree.setVisible(false);
            this.btnViewLog.setVisible(false);
            this.btnViewPastRecord.setVisible(false);
            this.btnViewPostil.setVisible(false);
        }
        if (this.getUIContext().get("isAddNew") != null && ((Boolean)this.getUIContext().get("isAddNew")).booleanValue()) {
            this.btnPostil.setVisible(false);
            this.btnAgree.setVisible(false);
            this.btnViewLog.setVisible(false);
            this.btnViewPastRecord.setVisible(false);
            this.btnViewPostil.setVisible(false);
        }
        if (this.editData.getBgType().getNumber().equals("BalanceSheetBudget")) {
            this.btnCheckRpt.setEnabled(true);
        }
    }

    public void playBgItem(Vector bgItem) {
        int i;
        Hashtable formulaModeMap = new Hashtable();
        for (Object key : this.colMap.keySet()) {
            Vector cols = (Vector)this.colMap.get(key);
            String formulaMode = "=";
            int m = cols.size();
            for (int j = 0; j < m; ++j) {
                int colIndex = (Integer)cols.get(j);
                formulaMode = formulaMode + "cell(&," + (colIndex + 1) + ").getValue()+";
            }
            formulaMode = formulaMode.substring(0, formulaMode.length() - 1);
            formulaModeMap.put(key, formulaMode);
        }
        int n = bgItem.size();
        for (i = 0; i < n; ++i) {
            BgItemInfo[] item = (BgItemInfo[])bgItem.get(i);
            IRow row = this.kdt.addRow();
            int rowIndex = row.getRowIndex();
            for (Object key : formulaModeMap.keySet()) {
                int colIndex = (Integer)key;
                String fMode = (String)formulaModeMap.get(key);
                String realFormula = fMode.replaceAll("&", String.valueOf(rowIndex + 1));
                row.getCell(colIndex).setExpressions(realFormula);
            }
            for (int j = 0; j < item.length; ++j) {
                row.getCell("dim" + j).setValue((Object)item[j]);
                if (!this.upTable.containsKey(item[j].getId().toString())) continue;
                row.getStyleAttributes().setLocked(true);
                row.getStyleAttributes().setBackground(BgClientHelper.TOTAL_COLOR);
            }
        }
        if (this.editData.getBgType().getNumber().equals("BalanceSheetBudget")) {
            for (i = 0; i < this.kdt.getRowCount(); ++i) {
                IRow row = this.kdt.getRow(i);
                for (int j = this.dimSize; j < this.kdt.getColumnCount(); j += 4) {
                    String formula = "=cell(" + (i + 1) + "," + (j + 1) + ").getValue() +  cell(" + (i + 1) + "," + (j + 2) + ").getValue() -  cell(" + (i + 1) + "," + (j + 3) + ").getValue() ";
                    row.getCell(j + 3).setExpressions(formula);
                }
            }
        } else if (!this.editData.getBgType().isIsRptBgForm()) {
            BgV2FormEditUI.initColumnRelation(this.bgTemInfo, this.kdt, this.dimSize);
        }
    }

    public static void initColumnRelation(BgTemplateInfo template, KDTable table, int dimSize) {
        Hashtable<String, String> name2Formula = new Hashtable<String, String>();
        BgTemplateColumnCollection tpColumnCol = template.getBgTpColumns();
        int n = tpColumnCol.size();
        for (int i = 0; i < n; ++i) {
            BgTemplateColumnInfo tpColumn = tpColumnCol.get(i);
            String formula = tpColumn.getFormula();
            if (formula == null || formula.trim().equals("")) continue;
            name2Formula.put(tpColumn.getBgElement().getName(), formula);
        }
        int eleSize = tpColumnCol.size();
        int n2 = table.getColumnCount();
        for (int i = dimSize; i < n2; ++i) {
            String element = ((BgElementInfo)table.getHeadRow(1).getCell(i).getValue()).getName();
            String key1 = table.getColumnKey(i).substring(0, 46);
            if (!name2Formula.containsKey(element)) continue;
            Hashtable<String, Integer> name2Index = new Hashtable<String, Integer>();
            int m = i + eleSize;
            for (int j = i - eleSize; j < m && j < table.getColumnCount(); ++j) {
                if (j < dimSize) continue;
                String elementName = ((BgElementInfo)table.getHeadRow(1).getCell(j).getValue()).getName();
                String elementNumber = ((BgElementInfo)table.getHeadRow(1).getCell(j).getValue()).getName();
                String key = table.getColumnKey(j);
                if (key.indexOf(key1) == -1 || elementName.equals(element)) continue;
                int index = table.getColumnIndex(key);
                name2Index.put(elementName, new Integer(index));
            }
            String formula = (String)name2Formula.get(element);
            int m2 = table.getRowCount();
            for (int row = 0; row < m2; ++row) {
                ICell iCell = table.getRow(row).getCell(i);
                if (iCell.getStyleAttributes().isLocked()) continue;
                String expression = "= " + (String)name2Formula.get(element);
                Enumeration keys = name2Index.keys();
                while (keys.hasMoreElements()) {
                    String elementName = (String)keys.nextElement();
                    Integer index = (Integer)name2Index.get(elementName);
                    String replace = " cell(" + (row + 1) + "," + (index + 1) + ").getValue() ";
                    expression = expression.replaceAll(elementName, replace);
                }
                expression = expression.replaceAll(" ", "");
                iCell.setExpressions(expression);
                iCell.getStyleAttributes().setLocked(true);
                iCell.getStyleAttributes().setBackground(BgClientHelper.TOTAL1_COLOR);
            }
        }
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        BgTypeInfo inBgTypeInfo = (BgTypeInfo)this.getUIContext().get("BgType");
        return BgFormDAFactory.getRemoteInstance().getFormHeadInfo(pk.toString());
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void comboCurrency_actionPerformed(ActionEvent e) throws Exception {
        super.comboCurrency_actionPerformed(e);
        if (this.kdt.getRowCount() > 0) {
            this.loadFields();
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getBgType().getNumber().equals("BalanceSheetBudget") && !this.checkBalanceSheet(false)) {
            SysUtil.abort();
        }
        this.submitCurrentBgData();
        if (this.editData.getState().getValue() == 9) {
            IBgV2Manager iBgV2 = BgV2ManagerFactory.getRemoteInstance();
            iBgV2.updateBgFormState(this.bgFormId, 1);
        }
        MsgBox.showInfo((Component)((Object)this), (String)"\u4fdd\u5b58\u6210\u529f\uff01");
        this.save = true;
        this.getUIWindow().close();
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getBgType().getNumber().equals("BalanceSheetBudget") && !this.checkBalanceSheet(false)) {
            SysUtil.abort();
        }
        this.submitCurrentBgData();
        if (this.editData.getState().getValue() == 9) {
            IBgV2Manager iBgV2 = BgV2ManagerFactory.getRemoteInstance();
            iBgV2.updateBgFormState(this.bgFormId, 1);
        }
        if (this.editData.getBgScheme().isIsFormal() && MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"confirmSubmit")) == 0) {
            IBgForm ibf = BgFormFactory.getRemoteInstance();
            ibf.submitBgForm(BOSUuid.read((String)this.bgFormId));
            MsgBox.showInfo((Component)((Object)this), (String)"\u63d0\u4ea4\u5de5\u4f5c\u6d41\u6210\u529f\uff01");
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)"\u4fdd\u5b58\u6210\u529f\uff01");
        }
        this.save = true;
        this.getUIWindow().close();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    @Override
    protected void btnFstPg_actionPerformed(ActionEvent e) throws Exception {
        super.btnFstPg_actionPerformed(e);
        this.confirmPgChgAndSubmit();
        this.kdt.removeRows();
        this.currentPage = 0;
        this.goToCurrentPage();
        this.checkBtnState();
    }

    @Override
    protected void btnLstPg_actionPerformed(ActionEvent e) throws Exception {
        super.btnLstPg_actionPerformed(e);
        this.confirmPgChgAndSubmit();
        this.kdt.removeRows();
        this.currentPage = this.totalPage - 1;
        this.goToCurrentPage();
        this.checkBtnState();
    }

    @Override
    protected void btnNxtPg_actionPerformed(ActionEvent e) throws Exception {
        super.btnNxtPg_actionPerformed(e);
        this.confirmPgChgAndSubmit();
        this.kdt.removeRows();
        ++this.currentPage;
        this.goToCurrentPage();
        this.checkBtnState();
    }

    @Override
    protected void btnPrePg_actionPerformed(ActionEvent e) throws Exception {
        super.btnPrePg_actionPerformed(e);
        this.confirmPgChgAndSubmit();
        this.kdt.removeRows();
        --this.currentPage;
        this.goToCurrentPage();
        this.checkBtnState();
    }

    protected void submitCurrentBgData() throws BOSException, EASBizException {
        if ("EDIT".equals(this.getOprtState())) {
            int j;
            int i;
            if (this.editData.getBgType().getNumber().equals("BalanceSheetBudget")) {
                for (i = 0; i < this.kdt.getColumnCount(); ++i) {
                    if (this.kdt.getColumnKey(i).indexOf(BgElementEnum.ClosingBalance.getName()) == -1) continue;
                    for (j = 0; j < this.kdt.getRowCount(); ++j) {
                        ICell cell = this.kdt.getRow(j).getCell(i);
                        if (cell.getStyleAttributes().isLocked()) continue;
                        BigDecimal bgValue = (BigDecimal)cell.getValue();
                        BgDataInfo data = (BgDataInfo)cell.getUserObject();
                        BigDecimal diff = bgValue.subtract(data.getBigDecimal(this.FIELD));
                        String key = ((BgItemInfo)this.kdt.getRow(j).getCell("dim0").getValue()).getId().toString();
                        if (Math.abs(data.getBigDecimal(this.FIELD).doubleValue() - bgValue.doubleValue()) > 0.0 && Math.abs(data.getBigDecimal(this.FIELD).doubleValue() - bgValue.doubleValue()) < 1.0E-5) continue;
                        data.setBigDecimal(this.FIELD, bgValue);
                        diff = data.get("diff") == null ? diff : ((BigDecimal)data.get("diff")).add(diff);
                        data.put("diff", diff);
                        data.put("bgItemIds", key);
                        String periodId = ((PeriodInfo)this.kdt.getHeadRow(0).getCell(i).getUserObject()).getId().toString();
                        data.put("periodId", periodId);
                        String elementNumber = ((BgElementInfo)this.kdt.getHeadRow(1).getCell(i).getValue()).getNumber();
                        data.put("elementNumber", elementNumber);
                        if (!this.needSubmitDataMap.containsKey(data.getId().toString())) {
                            this.needSubmitDataMap.remove(data.getId().toString());
                            this.needSubmitDataMap.put(data.getId().toString(), data);
                            continue;
                        }
                        this.needSubmitDataMap.put(data.getId().toString(), data);
                    }
                }
            } else {
                for (i = 0; i < this.kdt.getColumnCount(); ++i) {
                    for (j = 0; j < this.kdt.getRowCount(); ++j) {
                        ICell cell = this.kdt.getRow(j).getCell(i);
                        if (!cell.getStyleAttributes().getBackground().equals(BgClientHelper.TOTAL1_COLOR)) continue;
                        BigDecimal bgValue = new BigDecimal(cell.getValue().toString());
                        BgDataInfo data = (BgDataInfo)cell.getUserObject();
                        BigDecimal diff = bgValue.subtract(data.getBigDecimal(this.FIELD));
                        String key = ((BgItemInfo)this.kdt.getRow(j).getCell("dim0").getValue()).getId().toString();
                        if (Math.abs(data.getBigDecimal(this.FIELD).doubleValue() - bgValue.doubleValue()) > 0.0 && Math.abs(data.getBigDecimal(this.FIELD).doubleValue() - bgValue.doubleValue()) < 1.0E-5) continue;
                        data.setBigDecimal(this.FIELD, bgValue);
                        diff = data.get("diff") == null ? diff : ((BigDecimal)data.get("diff")).add(diff);
                        data.put("diff", diff);
                        data.put("bgItemIds", key);
                        String periodId = ((PeriodInfo)this.kdt.getHeadRow(0).getCell(i).getUserObject()).getId().toString();
                        data.put("periodId", periodId);
                        String elementNumber = ((BgElementInfo)this.kdt.getHeadRow(1).getCell(i).getValue()).getNumber();
                        data.put("elementNumber", elementNumber);
                        if (!this.needSubmitDataMap.containsKey(data.getId().toString())) {
                            this.needSubmitDataMap.remove(data.getId().toString());
                            this.needSubmitDataMap.put(data.getId().toString(), data);
                            continue;
                        }
                        this.needSubmitDataMap.put(data.getId().toString(), data);
                    }
                }
            }
            if (!this.needSubmitDataMap.isEmpty()) {
                boolean isRptBgForm = this.editData.getBgType().isIsRptBgForm();
                IBgV2Manager iBgV2 = BgV2ManagerFactory.getRemoteInstance();
                iBgV2.updateBgDatas(this.FIELD, this.bgFormId, this.currencyId, this.needSubmitDataMap, this.allDownTable, isRptBgForm);
                this.needSubmitDataMap.clear();
                this.isPageSaved = true;
            }
        }
    }

    public void checkBtnState() {
        if (this.totalPage == 1) {
            this.btnFstPg.setEnabled(false);
            this.btnLstPg.setEnabled(false);
            this.btnNxtPg.setEnabled(false);
            this.btnPrePg.setEnabled(false);
        } else if (this.currentPage == 0) {
            this.btnFstPg.setEnabled(false);
            this.btnLstPg.setEnabled(true);
            this.btnNxtPg.setEnabled(true);
            this.btnPrePg.setEnabled(false);
        } else if (this.currentPage == this.totalPage - 1) {
            this.btnFstPg.setEnabled(true);
            this.btnLstPg.setEnabled(false);
            this.btnNxtPg.setEnabled(false);
            this.btnPrePg.setEnabled(true);
        } else {
            this.btnFstPg.setEnabled(true);
            this.btnLstPg.setEnabled(true);
            this.btnNxtPg.setEnabled(true);
            this.btnPrePg.setEnabled(true);
        }
    }

    public void goToCurrentPage() throws BOSException {
        this.labPageIndex.setText("\u7b2c " + (this.currentPage + 1) + " / " + this.totalPage + " \u9875");
        Vector currBgItem = this.getCurrentBgItem(this.currentPage);
        this.playBgItem(currBgItem);
        IBgV2Manager iBgV2 = BgV2ManagerFactory.getRemoteInstance();
        this.putDataToTable(this.bgFormId, iBgV2, this.bgTemInfo.getRefDimensions().size());
        try {
            this.kdt.getScriptManager().runAll();
        }
        catch (Exception err) {
            err.getMessage();
        }
        this.save = false;
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setIcon();
    }

    @Override
    public void actionRename_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        uiContext.put((Object)"status", (Object)OprtState.EDIT);
        uiContext.put((Object)"bgForm", (Object)this.editData);
        uiContext.put((Object)"identity", (Object)String.valueOf(System.currentTimeMillis()));
        IUIWindow popUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgV2FormHeadUI.class.getName(), (Map)uiContext);
        popUI.show();
        this.setUITitle(this.getUITitle().substring(0, 5));
        this.onLoad();
    }

    @Override
    public void actionAgree_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.editData);
        uiContext.put((Object)"listUI", this.getUIContext().get("Owner"));
        String className = BgAgreeUI.class.getName();
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
        }
        catch (UIException er) {
            this.handUIException(er);
        }
    }

    @Override
    public void actionCheckRpt_actionPerformed(ActionEvent e) throws Exception {
        this.checkBalanceSheet(true);
    }

    @Override
    public void actionPostil_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.editData);
        uiContext.put((Object)"listUI", this.getUIContext().get("Owner"));
        String className = BgPostilUI.class.getName();
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
        }
        catch (UIException er) {
            this.handUIException(er);
        }
    }

    @Override
    public void actionViewLog_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            return;
        }
        String strId = this.editData.getId().toString();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)strId);
        String className = BgFormLogViewUI.class.getName();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionViewPostil_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            return;
        }
        String strId = this.editData.getId().toString();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)strId);
        String className = BgPostilViewUI.class.getName();
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
        catch (UIException er) {
            this.handUIException(er);
        }
    }

    public boolean checkBeforeWindowClosing() {
        super.removeMainStatusBar();
        boolean isAddNew = false;
        if (this.getUIContext() != null && this.getUIContext().get("isAddNew") != null && ((Boolean)this.getUIContext().get("isAddNew")).booleanValue()) {
            isAddNew = true;
        }
        if (this.save) {
            return true;
        }
        if (this.needSubmitDataMap.size() > 0) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
            if (result == 0) {
                try {
                    this.actionSave.setDaemonRun(false);
                    ActionEvent event = new ActionEvent(this.btnSave, 1001, this.btnSave.getActionCommand());
                    this.actionSave.actionPerformed(event);
                    return !this.actionSave.isInvokeFailed();
                }
                catch (Exception exc) {
                    return false;
                }
            }
            if (result == 1) {
                if (isAddNew && !this.isPageSaved) {
                    this.deleteCurrentForm();
                    try {
                        BgClientHelper.refreshBgFormList((CoreUI)this);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return true;
                }
                return true;
            }
            return false;
        }
        if (isAddNew && !this.isPageSaved) {
            this.deleteCurrentForm();
            try {
                BgClientHelper.refreshBgFormList((CoreUI)this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        return true;
    }

    private boolean checkBalanceSheet(boolean isNeedShowOk) {
        IRow totalAssertRow = null;
        IRow totalLERow = null;
        if (this.bgRptTemInfo == null) {
            return false;
        }
        BgRptTemplateRowCollection brtrc = this.bgRptTemInfo.getBgRptTpRows();
        int size = brtrc.size();
        for (int i = 0; i < size; ++i) {
            BgRptTemplateRowInfo brtri = brtrc.get(i);
            String rptNumber = brtri.getNumber();
            if (rptNumber == null) continue;
            if (rptNumber.equals("TotalAssets")) {
                totalAssertRow = this.kdt.getRow(i);
                continue;
            }
            if (!rptNumber.equals("TotalLiabilitiesAndEquity")) continue;
            totalLERow = this.kdt.getRow(i);
        }
        String strPath = "com.kingdee.eas.ma.bg.BgFormResource";
        String strRptPath = "com.kingdee.eas.ma.bg.BgRptFormResource";
        if (totalAssertRow == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)strPath, (String)"MissingTotalAsserts"));
            SysUtil.abort();
        }
        if (totalLERow == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)strPath, (String)"MissingTotalLE"));
            SysUtil.abort();
        }
        String opening = "OpeningBalance";
        String closing = "ClosingBalance";
        BigDecimal openingTA = new BigDecimal("0.00");
        BigDecimal openingTLE = new BigDecimal("0.00");
        BigDecimal closingTA = new BigDecimal("0.00");
        BigDecimal closingTLE = new BigDecimal("0.00");
        for (int i = 1; i < this.kdt.getColumnCount(); ++i) {
            if ((Integer)((PeriodInfo)this.kdt.getHeadRow(0).getCell(i).getUserObject()).get("bgCycle") > 1) continue;
            IRow headRow = this.kdt.getHeadRow(1);
            ICell headCell = headRow.getCell(i);
            BgElementInfo bgElementInfo = (BgElementInfo)headCell.getValue();
            if (bgElementInfo.getNumber().equals(opening)) {
                openingTA = openingTA.add((BigDecimal)totalAssertRow.getCell(i).getValue());
                openingTLE = openingTLE.add((BigDecimal)totalLERow.getCell(i).getValue());
            }
            if (!bgElementInfo.getNumber().equals(closing)) continue;
            closingTA = closingTA.add((BigDecimal)totalAssertRow.getCell(i).getValue());
            closingTLE = closingTLE.add((BigDecimal)totalLERow.getCell(i).getValue());
        }
        String str1 = null;
        String str2 = null;
        String str3 = null;
        String str4 = null;
        String str5 = null;
        String str6 = null;
        boolean isBalacned = true;
        if (openingTA.compareTo(openingTLE) != 0) {
            isBalacned = false;
            String strAssetStart = EASResource.getString((String)strRptPath, (String)"AssetTotalPeriodStart");
            String strOwesStart = EASResource.getString((String)strRptPath, (String)"OwesTotalPeriodStart");
            str1 = strAssetStart + "=" + openingTA.setScale(3, 4) + ";";
            str2 = strOwesStart + "= " + openingTLE.setScale(3, 4) + ";";
            str3 = EASResource.getString((String)strRptPath, (String)"NotEqual") + ".";
        }
        if (closingTA.compareTo(closingTLE) != 0) {
            isBalacned = false;
            String strAssetEnd = EASResource.getString((String)strRptPath, (String)"AssetTotalPeriodEnd");
            String strOwesEnd = EASResource.getString((String)strRptPath, (String)"OwesTotalPeriodEnd");
            str4 = strAssetEnd + "=" + closingTA.setScale(3, 4) + ";";
            str5 = strOwesEnd + "=" + closingTLE.setScale(3, 4) + ";";
            str6 = EASResource.getString((String)strRptPath, (String)"NotEqual") + ".";
        }
        if (!isBalacned) {
            StringBuffer sbMsg = new StringBuffer("");
            if (str1 != null && str2 != null && str3 != null) {
                sbMsg.append(str1);
                sbMsg.append("\n");
                sbMsg.append(str2);
                sbMsg.append("\n");
                sbMsg.append(str3);
                sbMsg.append("\n\n");
            }
            if (str4 != null && str5 != null && str6 != null) {
                sbMsg.append(str4);
                sbMsg.append("\n");
                sbMsg.append(str5);
                sbMsg.append("\n");
                sbMsg.append(str6);
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)strRptPath, (String)"BalancCheckNotPassed"), (String)sbMsg.toString(), (int)1);
            return false;
        }
        if (isNeedShowOk) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)strRptPath, (String)"BalancCheckPassed"));
        }
        return true;
    }

    private void deleteCurrentForm() {
        String strAdjustingFormId = this.bgFormId;
        try {
            BgFormProcessFactory.getRemoteInstance().deleteBgForm(strAdjustingFormId);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void confirmPgChgAndSubmit() throws EASBizException, BOSException {
        if (!this.needSubmitDataMap.isEmpty()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)"\u672c\u9875\u6570\u636e\u5df2\u4fee\u6539\uff0c\u662f\u5426\u4fdd\u5b58\uff1f");
            if (result == 0) {
                this.submitCurrentBgData();
            } else if (result == 1) {
                this.needSubmitDataMap.clear();
            } else {
                SysUtil.abort();
            }
        }
    }

    private final class TableBeforeAction
    implements BeforeActionListener {
        private TableBeforeAction() {
        }

        public void beforeAction(BeforeActionEvent e) {
            KDTable table = (KDTable)e.getSource();
            boolean deletable = true;
            ICell cell = null;
            switch (e.getType()) {
                case 7: {
                    int mark = (Integer)e.getParameter();
                    if (KDTEditHelper.isUserObject((int)mark)) {
                        KDTRange range = table.getSelectManager().toRange();
                        Iterator iterator = range.iterator();
                        KDTSelectBlock block = null;
                        Object o = null;
                        int rowEnd = 0;
                        int colEnd = 0;
                        while (iterator.hasNext()) {
                            block = (KDTSelectBlock)iterator.next();
                            colEnd = block.getEndCol();
                            if (colEnd == 0) {
                                // empty if block
                            }
                            for (int col = block.getBeginCol(); col <= colEnd; ++col) {
                                rowEnd = block.getEndRow();
                                if (rowEnd == 0) {
                                    rowEnd = table.getExpandedRowCount() - 1;
                                }
                                for (int row = block.getBeginRow(); row <= rowEnd; ++row) {
                                    cell = table.getCell(row, col);
                                    if (!(cell.getUserObject() instanceof BgDataInfo) || cell.getStyleAttributes().isLocked()) continue;
                                    BigDecimal zero = new BigDecimal("0.00");
                                    cell.setValue((Object)zero);
                                    BgDataInfo data = (BgDataInfo)cell.getUserObject();
                                    KDTEditEvent event = new KDTEditEvent((Object)cell);
                                    event.setRowIndex(cell.getRowIndex());
                                    event.setColIndex(cell.getColumnIndex());
                                    try {
                                        BgV2FormEditUI.this.kdt_editStopped(event);
                                        continue;
                                    }
                                    catch (Exception e1) {
                                        e1.printStackTrace();
                                    }
                                }
                            }
                        }
                    }
                    e.setCancel(true);
                }
            }
        }
    }
}

