/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.ma.bg.BgFormDAFactory;
import com.kingdee.eas.ma.bg.BgFormException;
import com.kingdee.eas.ma.bg.BgFormFactory;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgFormProcessFactory;
import com.kingdee.eas.ma.bg.BgRptTemplateDAFactory;
import com.kingdee.eas.ma.bg.BgRptTemplateInfo;
import com.kingdee.eas.ma.bg.BgSchemeInfo;
import com.kingdee.eas.ma.bg.BgTemplateException;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.BgTypeCollection;
import com.kingdee.eas.ma.bg.BgTypeFactory;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.IBgFormDA;
import com.kingdee.eas.ma.bg.IBgType;
import com.kingdee.eas.ma.bg.client.AbstractBgV2FormHeadUI;
import com.kingdee.eas.ma.bg.client.BgClientHelper;
import com.kingdee.eas.ma.bg.client.BgFormEditHelper;
import com.kingdee.eas.ma.bg.client.BgV2FormEditUI;
import com.kingdee.eas.ma.bg.client.IBgFormEditHandler;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgV2FormHeadUI
extends AbstractBgV2FormHeadUI {
    IBgFormEditHandler editHandler;
    Map ctx;
    String oprstatus = null;
    private static final Logger logger = CoreUIObject.getLogger(BgV2FormHeadUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.ctx = this.getUIContext();
        this.oprstatus = (String)this.ctx.get("status");
        if (this.oprstatus != null && this.oprstatus.equals(OprtState.EDIT)) {
            this.setUITitle(this.getUITitle() + "\u4fee\u6539");
        } else {
            this.setUITitle(this.getUITitle() + "\u65b0\u589e");
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.btnOK.setEnabled(true);
        this.btnCancel.setEnabled(true);
        try {
            if (this.oprstatus != null && this.oprstatus.equals(OprtState.EDIT)) {
                this.afterLoadFields_Edit();
            } else {
                this.afterLoadFields_AddNew();
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        String bgFormId = null;
        if (this.oprstatus != null && this.oprstatus.equals(OprtState.EDIT)) {
            this.actionOK_forEdit();
        } else {
            BgFormInfo bgForm = new BgFormInfo();
            bgForm.setName(this.txtName.getText());
            bgForm.setNumber(this.txtNumber.getText());
            bgForm.setBgType((BgTypeInfo)this.combxType.getSelectedItem());
            bgForm.setBgTemplate((BgTemplateInfo)this.prbxTemplate.getValue());
            bgForm.setBgScheme((BgSchemeInfo)this.combxScheme.getSelectedItem());
            bgForm.setOrgUnit((FullOrgUnitInfo)this.prbxOrg.getValue());
            this.checkMustInputAndSelect();
            this.checkNumberDupe(bgForm);
            this.checkBgFormExist((BgTemplateInfo)this.prbxTemplate.getData(), (BgSchemeInfo)this.combxScheme.getSelectedItem(), (BgTypeInfo)this.combxType.getSelectedItem(), (FullOrgUnitInfo)this.prbxOrg.getValue());
            boolean isRptBgForm = ((BgTypeInfo)this.combxType.getSelectedItem()).isIsRptBgForm();
            if (isRptBgForm) {
                BgRptTemplateInfo rptTemInfo = BgRptTemplateDAFactory.getRemoteInstance().getBgRptTpByBgTp(((BgTemplateInfo)this.prbxTemplate.getValue()).getId().toString());
                bgForm.setBgRptTemplate(rptTemInfo);
            }
            bgFormId = this.addNewBgForm(bgForm, isRptBgForm);
        }
        BgClientHelper.refreshBgFormList(this);
        this.getUIWindow().close();
        if (bgFormId != null) {
            this.popEditWindow(bgFormId);
        }
    }

    public void actionOK_forEdit() throws Exception {
        this.checkMustInputAndSelect();
        BgFormInfo bgForm = (BgFormInfo)this.ctx.get("bgForm");
        bgForm.setName(this.txtName.getText());
        bgForm.setNumber(this.txtNumber.getText());
        this.checkNumberDupe(bgForm);
        this.renameBgForm(bgForm);
    }

    private void afterLoadFields_AddNew() throws EASBizException, BOSException {
        FullOrgUnitInfo inOrgUnitInfo = (FullOrgUnitInfo)this.getUIContext().get("EditOrg");
        if (inOrgUnitInfo == null) {
            throw new EASBizException(BgFormException.NOORG);
        }
        this.prbxOrg.setData((Object)inOrgUnitInfo);
        BgFormInfo editData = new BgFormInfo();
        editData.setOrgUnit(inOrgUnitInfo);
        BgFormEditHelper.initComboBoxBgScheme(editData, this.combxScheme);
        BgTypeCollection btc = this.initBgType(inOrgUnitInfo);
        if (btc == null) {
            throw new EASBizException(BgFormException.ERRORONINITBGTYPE);
        }
        this.combxType.setEnabled(false);
        this.combxType.addItems(btc.toArray());
        this.combxType.setSelectedIndex(-1);
        this.combxType.setEnabled(true);
    }

    @Override
    protected void combxScheme_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    protected void combxType_actionPerformed(ActionEvent e) throws Exception {
        if (!this.combxType.isEnabled()) {
            return;
        }
        BgTypeInfo bti = (BgTypeInfo)this.combxType.getSelectedItem();
        if (bti == null) {
            return;
        }
        BgFormInfo editData = new BgFormInfo();
        editData.setBgType(bti);
        this.editHandler = BgFormEditHelper.generateEditHandler(bti);
        Vector orgIdVector = (Vector)this.getUIContext().get("OrgIDPath");
        try {
            this.editHandler.bindTemplate(editData, orgIdVector);
        }
        catch (BgTemplateException e1) {
            this.combxType.setPopupVisible(false);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"noCurrentTemplate"));
            SysUtil.abort();
        }
        this.prbxTemplate.setData((Object)editData.getBgTemplate());
        BgFormEditHelper.bandCurrencyInfoV2(this.prbxCurrency, editData.getBgTemplate());
    }

    private BgTypeCollection initBgType(FullOrgUnitInfo inOrgUnitInfo) throws EASBizException, BOSException {
        IBgType ibt = BgTypeFactory.getRemoteInstance();
        int orgView = (Integer)inOrgUnitInfo.get("treeType");
        BgTypeCollection btc = null;
        if (!OrgViewType.getEnum((int)orgView).equals((Object)OrgViewType.RESPONSECENTER)) {
            btc = ibt.getCollection(NewOrgViewHelper.convert((OrgViewType)OrgViewType.getEnum((int)orgView)).getValue());
        } else {
            BgTypeInfo info;
            int i;
            int n;
            Hashtable<BOSUuid, BgTypeInfo> hash;
            if (inOrgUnitInfo.isIsCompanyOrgUnit()) {
                btc = ibt.getCollection(1);
                hash = new Hashtable<BOSUuid, BgTypeInfo>();
                n = btc.size();
                for (i = 0; i < n; ++i) {
                    info = btc.get(i);
                    hash.put(info.getId(), info);
                }
            }
            if (!inOrgUnitInfo.isIsCompanyOrgUnit() && inOrgUnitInfo.isIsProfitOrgUnit()) {
                btc = ibt.getCollection(6);
                hash = new Hashtable();
                n = btc.size();
                for (i = 0; i < n; ++i) {
                    info = btc.get(i);
                    hash.put(info.getId(), info);
                }
            }
            if (!inOrgUnitInfo.isIsCompanyOrgUnit() && !inOrgUnitInfo.isIsProfitOrgUnit() && inOrgUnitInfo.isIsCostOrgUnit()) {
                btc = ibt.getCollection(5);
                hash = new Hashtable();
                n = btc.size();
                for (i = 0; i < n; ++i) {
                    info = btc.get(i);
                    hash.put(info.getId(), info);
                }
            }
        }
        return btc;
    }

    private void checkBgFormExist(BgTemplateInfo tempInfo, BgSchemeInfo scheInfo, BgTypeInfo bgType, FullOrgUnitInfo orgUnit) {
        try {
            IBgFormDA iBgFormDA = BgFormDAFactory.getRemoteInstance();
            BgFormInfo editData = iBgFormDA.matchFormWithTemplate(bgType.getId().toString(), orgUnit.getId().toString(), scheInfo.getId().toString(), tempInfo.getId().toString(), false);
            if (editData != null && editData.getId() != null) {
                MsgBox.showInfo((Component)((Object)this), (String)(EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"FormExist") + editData.getState().getAlias() + EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"FormExist1")));
                SysUtil.abort();
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
    }

    private String addNewBgForm(BgFormInfo bgForm, boolean isRptBgForm) {
        String bgFormId = null;
        try {
            bgFormId = isRptBgForm ? BgFormProcessFactory.getRemoteInstance().addnewRptBgForm(bgForm) : BgFormProcessFactory.getRemoteInstance().addnewBgForm(bgForm);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return bgFormId;
    }

    private void renameBgForm(BgFormInfo bgForm) {
        Object bgFormId = null;
        try {
            BgFormProcessFactory.getRemoteInstance().renameBgForm(bgForm);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void checkMustInputAndSelect() {
        if (this.txtName.getText() == null || this.txtName.getText().trim().length() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"noName"));
            SysUtil.abort();
        }
        if (this.txtNumber.getText() == null || this.txtNumber.getText().trim().length() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"noNumber"));
            SysUtil.abort();
        }
        if (this.combxType.getSelectedItem() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"noBgType"));
            SysUtil.abort();
        }
        if (this.combxScheme.getSelectedItem() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"noByScheme"));
            SysUtil.abort();
        }
        if (this.prbxOrg.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"noOrgUnit"));
            SysUtil.abort();
        }
        if (this.prbxTemplate.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"noBgTemplate"));
            SysUtil.abort();
        }
    }

    private void checkNumberDupe(BgFormInfo bgForm) {
        try {
            BgFormFactory.getRemoteInstance().checkNumberDup(null, (CoreBillBaseInfo)bgForm);
        }
        catch (EASBizException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        catch (BOSException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
    }

    private void afterLoadFields_Edit() throws EASBizException, BOSException {
        BgFormInfo bgForm = (BgFormInfo)this.ctx.get("bgForm");
        FullOrgUnitInfo inOrgUnitInfo = bgForm.getOrgUnit();
        if (inOrgUnitInfo == null) {
            throw new EASBizException(BgFormException.NOORG);
        }
        this.prbxOrg.setData((Object)inOrgUnitInfo);
        this.prbxTemplate.setData((Object)bgForm.getBgTemplate());
        BgFormEditHelper.bandCurrencyInfoV2(this.prbxCurrency, bgForm.getBgTemplate());
        this.txtName.setText(bgForm.getName());
        this.txtNumber.setText(bgForm.getNumber());
        this.combxScheme.addItem((Object)bgForm.getBgScheme());
        this.combxScheme.setSelectedItem((Object)bgForm.getBgScheme());
        this.combxScheme.setEnabled(false);
        this.combxType.setEnabled(false);
        this.combxType.addItems(new Object[]{bgForm.getBgType()});
        this.combxType.setSelectedItem((Object)bgForm.getBgType());
    }

    private void popEditWindow(String strId) throws UIException {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)strId);
        uiContext.put((Object)"BgType", this.combxType.getSelectedItem());
        uiContext.put((Object)"identity", (Object)String.valueOf(System.currentTimeMillis()));
        uiContext.put((Object)"isAddNew", (Object)true);
        uiContext.put((Object)"EditOrg", this.prbxOrg.getValue());
        IUIWindow popUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(BgV2FormEditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        popUI.show();
    }
}

