/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgRptFormDAFactory;
import com.kingdee.eas.ma.bg.BgRptRowTypeEnum;
import com.kingdee.eas.ma.bg.BgRptTemplateRowInfo;
import com.kingdee.eas.ma.bg.BgRptTpHelper;
import com.kingdee.eas.ma.bg.IBgRptFormDA;
import com.kingdee.eas.ma.bg.client.BgClientHelper;
import com.kingdee.eas.ma.bg.client.BizBgFormEditHandler;
import java.util.Hashtable;
import java.util.Vector;

public class RptBgFormEditHandler
extends BizBgFormEditHandler {
    @Override
    public void initFormTable(KDTable table, BgFormInfo editData) {
        BgClientHelper.initBgRptFormTable(editData.getBgRptTemplate(), table);
    }

    @Override
    public void initKdtRelation(KDTable table, BgFormInfo editData, Hashtable columnSubjectTable, Vector periodNodeVector) {
        int i;
        table.getScriptManager().setAutoRun(false);
        int rowCount = table.getRowCount();
        for (i = 0; i < rowCount; ++i) {
            String totalFormula;
            BgRptTemplateRowInfo bgRptTemplateRowInfo = editData.getBgRptTemplate().getBgRptTpRows().get(i);
            if (!bgRptTemplateRowInfo.getType().equals((Object)BgRptRowTypeEnum.Total) || (totalFormula = bgRptTemplateRowInfo.getFormula()) == null || totalFormula.equals("")) continue;
            int columnCount = table.getColumnCount();
            for (int j = 1; j < columnCount; ++j) {
                table.getRow(i).getCell(j).setExpressions(BgRptTpHelper.totalFormula2KdtableFormat(totalFormula, editData.getBgRptTemplate().getBgRptTpRows(), i + 1, j + 1));
            }
        }
        if (editData.getBgType().getNumber().equals("BalanceSheetBudget")) {
            rowCount = table.getRowCount();
            int columnCount = table.getColumnCount();
            for (i = 0; i < rowCount; ++i) {
                int rowIndex = i + 1;
                String formula = "= cell(" + rowIndex + ",2).getValue()+cell(" + rowIndex + ",3).getValue()-cell(" + rowIndex + ",4).getValue()";
                ICell icell = table.getRow(i).getCell(columnCount - 1);
                icell.setExpressions(formula);
            }
        }
        table.getScriptManager().setAutoRun(true);
    }

    @Override
    public BgFormInfo generateDetailedEditData(BgFormInfo editData) throws EASBizException, BOSException {
        IBgRptFormDA iBgRptFormDa = BgRptFormDAFactory.getRemoteInstance();
        return iBgRptFormDa.getFormWithTemplate(editData.getBgType().getId().toString(), editData.getOrgUnit().getId().toString(), editData.getBgScheme().getId().toString(), editData.getBgTemplate().getId().toString(), true);
    }

    @Override
    public BgFormInfo getValue(IObjectPK pk) throws EASBizException, BOSException {
        IBgRptFormDA iBgRptFormDa = BgRptFormDAFactory.getRemoteInstance();
        return iBgRptFormDa.getBgForm4Edit(pk);
    }
}

