/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.ma.bgcsl.IBgElimContext;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import java.io.Serializable;
import java.util.Hashtable;

public class BgElimContext
implements IBgElimContext,
Serializable,
Cloneable {
    private static BgElimContext ctx = new BgElimContext();
    private Hashtable list = new Hashtable();

    private BgElimContext() {
    }

    public static BgElimContext getInstance() {
        return ctx;
    }

    @Override
    public boolean isInitialized() {
        return !this.list.isEmpty();
    }

    public Object clone() throws CloneNotSupportedException {
        super.clone();
        BgElimContext o = (BgElimContext)super.clone();
        o.list = (Hashtable)this.list.clone();
        return o;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        boolean flag = true;
        if (obj == null) return false;
        if (!(obj instanceof BgElimContext)) return false;
        BgElimContext c = (BgElimContext)obj;
        try {
            if (c.getCurOrgBound() == null || this.getCurOrgBound() == null || c.getCurOrgBound().getId().equals((Object)this.getCurOrgBound().getId())) {
                flag = false;
            }
            if (c.getCurOrgGroup() == null || this.getCurOrgGroup() == null || c.getCurOrgGroup().getId().equals((Object)this.getCurOrgGroup().getId())) {
                flag = false;
            }
            if (c.getCurBgScheme() == null) return false;
            if (this.getCurBgScheme() == null) return false;
            if (!c.getCurBgScheme().getId().equals((Object)this.getCurBgScheme().getId())) return flag;
            return false;
        }
        catch (BOSException e) {
            return false;
        }
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public BgSchemeInfo getCurBgScheme() throws BOSException {
        return (BgSchemeInfo)this.getDetailValue(BG_CURRENT_BGSCHEME);
    }

    @Override
    public OrgTreeInfo getCurOrgBound() throws BOSException {
        return (OrgTreeInfo)this.getDetailValue(BG_CURRENT_ORGBOUND);
    }

    @Override
    public OrgUnitInfo getCurOrgGroup() throws BOSException {
        return (OrgUnitInfo)this.getDetailValue(BG_CURRENT_ORGGROUP);
    }

    @Override
    public OrgUnitInfo getCurMappedOrgUnit() throws BOSException {
        return (OrgUnitInfo)this.getDetailValue(BG_CURRENT_MAPPEDORGUNIT);
    }

    public void setCurBgScheme(BgSchemeInfo value) {
        this.setDetailValue(BG_CURRENT_BGSCHEME, value);
    }

    public void setCurOrgBound(OrgTreeInfo value) {
        this.setDetailValue(BG_CURRENT_ORGBOUND, value);
    }

    public void setCurOrgGroup(OrgUnitInfo value) {
        this.setDetailValue(BG_CURRENT_ORGGROUP, value);
    }

    public void setCurMappedOrgUnit(OrgUnitInfo value) {
        this.setDetailValue(BG_CURRENT_MAPPEDORGUNIT, value);
    }

    private Object getDetailValue(Integer key) {
        if (this.list.containsKey(key)) {
            return this.list.get(key);
        }
        return null;
    }

    private synchronized void setDetailValue(Integer key, Object value) {
        if (this.list.containsKey(key)) {
            this.list.remove(key);
        }
        if (value != null) {
            this.list.put(key, value);
        }
    }

    public void destroyContext() {
        this.list.clear();
    }
}

