/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgPeriodException;
import com.kingdee.eas.ma.bgcsl.BgCslAdjFormFactory;
import com.kingdee.eas.ma.bgcsl.BgCslAdjFormInfo;
import com.kingdee.eas.ma.bgcsl.client.BgCslAdjFormProcessUI;
import com.kingdee.eas.ma.bgcsl.client.cslAdjForm.BgCslAdjFormSpecialProvider;
import com.kingdee.eas.ma.bgcsl.client.cslTemplate.BgSpecialBudgetHelper;
import com.kingdee.eas.ma.bgcsl.client.notify.CellDoubleClickListener;
import com.kingdee.eas.ma.bgcsl.client.utils.BgCslClientHelper;
import com.kingdee.eas.ma.bgcsl.utils.BgCslDimensionMemberCheckHelper;
import com.kingdee.eas.ma.bgcsl.utils.BgSpecialCommonHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.IBgSpecialFormProcessUI;
import com.kingdee.eas.ma.mbg.client.utils.IBgSpecialTemplateProcessUI;
import com.kingdee.eas.ma.mbg.common.BgSheetRange;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgViewManagerImpl;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgNTemplateHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgCslAdjFormSpecialProcessUi
extends BgCslAdjFormProcessUI
implements IBgSpecialTemplateProcessUI,
IBgSpecialFormProcessUI {
    private static final long serialVersionUID = -381352580153814597L;
    private static final Logger logger = CoreUIObject.getLogger(BgCslAdjFormSpecialProcessUi.class);
    private List<Cell> cells = new ArrayList<Cell>();
    public static final String OLD_MBG_ITEMFORMULA = "OLD_MBG_ITEMFORMULA";
    private boolean isFillItemFormula = false;
    private Component pageDimensionPanel = null;
    private Boolean isElementRequired = null;
    private Boolean isScenarioRequired = null;

    @Override
    public boolean isElementRequired() {
        if (this.isElementRequired == null) {
            try {
                this.isElementRequired = !BgSpecialCommonHelper.isInSpecialItem(DimensionConstants.DEF_ELEMENT_NUMBER, this.getBgFormInfo(), this.getSchemeHelper());
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return this.isElementRequired;
    }

    @Override
    public boolean isScenarioRequired() {
        if (this.isScenarioRequired == null) {
            try {
                this.isScenarioRequired = !BgSpecialCommonHelper.isInSpecialItem(DimensionConstants.DEF_SCENARIO_NUMBER, this.getBgFormInfo(), this.getSchemeHelper());
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return this.isScenarioRequired;
    }

    @Override
    public Map<String, Set<String>> getFilterMap() throws EASBizException, BOSException {
        Map<String, Set<String>> filterMap = BgSpecialBudgetHelper.getFilterMapByBgTemplate(this.getEditData(), this.getSchemeHelper());
        filterMap = BgCslClientHelper.addClsAdjFilter(filterMap);
        return filterMap;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.addPagePanel();
        if (!this.isElementRequired()) {
            this.actionAddBgElement.setEnabled(false);
            this.btnAddElement.setEnabled(false);
            this.menuItemAddElement.setEnabled(false);
        }
        if (!this.isScenarioRequired()) {
            this.actionAddBgScenario.setEnabled(false);
            this.btnAddScenario.setEnabled(false);
            this.menuItemAddScenario.setEnabled(false);
        }
    }

    public String getUITitle() {
        StringBuffer title = new StringBuffer();
        title.append(BgNFCHelper.getMessageStr((String)"Title")).append(" - ").append(BgNFCHelper.getMessageStr((String)(this.getOprtState() + "_FIX")));
        String _name = (String)this.getEditData().get("name");
        if (!StringUtils.isEmpty((String)_name)) {
            title.append(" - ").append(_name);
        }
        return title.toString();
    }

    @Override
    public void actionAddBgItem_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.isFillItemFormula = true;
            super.actionAddBgItem_actionPerformed(e);
        }
        finally {
            this.isFillItemFormula = false;
        }
    }

    @Override
    public void actionBgItemFill_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.isFillItemFormula = true;
            super.actionBgItemFill_actionPerformed(e);
        }
        finally {
            this.isFillItemFormula = false;
        }
    }

    @Override
    public void actionCreateItemFormula_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.isFillItemFormula = true;
            super.actionCreateItemFormula_actionPerformed(e);
        }
        finally {
            this.isFillItemFormula = false;
        }
    }

    @Override
    public void actionMutiUpdateFormula_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.isFillItemFormula = true;
            super.actionMutiUpdateFormula_actionPerformed(e);
        }
        finally {
            this.isFillItemFormula = false;
        }
    }

    @Override
    protected void cell_Content_Changed(SheetChangeEvent e) throws Exception {
        super.cell_Content_Changed(e);
        if (this.isFillItemFormula || e.getSheet() == null) {
            return;
        }
        Sheet _sheet = e.getSheet();
        int rowCount = _sheet.getMaxRowIndex();
        int colCount = _sheet.getMaxColIndex();
        CellBlock _block = null;
        Cell _cell = null;
        String formula = null;
        int size = e.getChangedBlocks().size();
        for (int index = 0; index < size; ++index) {
            _block = e.getChangedBlocks().getBlock(index);
            if (_block == null) continue;
            int rowBegin = _block.getRow();
            int rowEnd = _block.getRow2() > rowCount ? rowCount : _block.getRow2();
            int colBegin = _block.getCol();
            int colEnd = _block.getCol2() > colCount ? colCount : _block.getCol2();
            for (int rowIndex = rowBegin; rowIndex <= rowEnd; ++rowIndex) {
                for (int colIndex = colBegin; colIndex <= colEnd; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    formula = BgNFSHelper.getFormulaOfCell((Cell)_cell);
                    if (StringUtils.isEmpty((String)formula) || StringUtils.equals((String)formula, (String)this.getOldFormula(_cell))) continue;
                    this.addCell(_cell);
                }
            }
        }
        this.fillSpecialItem();
        this.afterFill();
    }

    public void addPagePanel() throws Exception {
        this.pageDimensionPanel = BgSpecialBudgetHelper.getPageDimensionPanel(this.getSpreadManager().getSpreadContainer(), (CoreUI)this, this.getBgFormInfo(), this.getSchemeHelper(), this.getOrgUnitInfo());
        this.getUIContentPane().add(this.pageDimensionPanel, "Center");
    }

    protected BgCslAdjFormInfo getBgFormInfo() {
        return this.getEditData();
    }

    @Override
    public IBookProvider getBudgetProvider() {
        if (this.provider == null) {
            this.provider = new BgCslAdjFormSpecialProvider(this);
        }
        return this.provider;
    }

    public void addCell(Cell cell) {
        if (cell != null) {
            this.cells.add(cell);
        }
    }

    public void fillSpecialItem() {
        if (this.cells.isEmpty()) {
            return;
        }
        BgSheetRange range = new BgSheetRange(this.getBook().getActiveSheet());
        for (Cell cell : this.cells) {
            range.addCell(cell.getRow(), cell.getCol());
        }
        ArrayList<Range> ranges = new ArrayList<Range>();
        ranges.add(range.getRange());
        try {
            BgSpecialBudgetHelper.buildFormula((Range)ranges.get(0), BgSpecialBudgetHelper.getBgSpecialItem(this.getBgFormInfo()), this.getBgFormInfo().getBgPeriod().getNumber(), this.getBgFormInfo().getCurrency().getNumber());
            BgNTemplateHelper.dealWith(ranges, (String)this.getOrgUnitID(), (Map)this.getItemFormulMap(), (boolean)true, (boolean)true, null, (boolean)true, (boolean)false, null, (BgSchemeDimensionHelper)this.getSchemeHelper(), (boolean)true, null, (boolean)true, (boolean)true);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    @Override
    protected void showCell(Cell cell) throws Exception {
        super.showCell(cell);
        if (cell != null) {
            this.setOldFormula(cell, BgNFSHelper.getFormulaOfCell((Cell)cell));
        }
    }

    private String getOldFormula(Cell cell) {
        return (String)BgNFSHelper.getCellExtData((Cell)cell, (String)OLD_MBG_ITEMFORMULA);
    }

    private void setOldFormula(Cell cell, String formula) {
        if (StringUtils.isEmpty((String)formula)) {
            BgNFSHelper.removeCellExtData((Cell)cell, (String)OLD_MBG_ITEMFORMULA);
        } else {
            BgNFSHelper.setCellExtData((Cell)cell, (String)OLD_MBG_ITEMFORMULA, (Object)formula);
        }
    }

    public void afterFill() {
        if (this.cells == null || this.cells.isEmpty()) {
            return;
        }
        try {
            this.beforeShowCell(this.cells);
            for (Cell cell : this.cells) {
                this.showCell(cell);
            }
            this.lockCell();
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        finally {
            this.cells.clear();
        }
    }

    private void beforeShowCell(List<Cell> cells) {
        if (cells == null || cells.isEmpty()) {
            return;
        }
        ArrayList<String> formulaList = new ArrayList<String>();
        for (Cell cell : cells) {
            if (!BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) continue;
            formulaList.add(BgNFSHelper.getFormulaOfCell((Cell)cell));
        }
        HashSet<String> versionNumber = new HashSet<String>();
        versionNumber.add(this.getEditData().getBgVersion().getNumber());
        try {
            MbgViewManagerImpl view = DimensionFormulaHelper.buildViewMamager(null, formulaList, versionNumber);
            Map newDataMap = BgCslAdjFormFactory.getRemoteInstance().getBgDataInfo(this.getEditData(), (IMbgViewBase)view);
            if (newDataMap != null) {
                if (this.bgDataMap == null) {
                    this.bgDataMap = newDataMap;
                } else {
                    this.bgDataMap.putAll(newDataMap);
                }
            }
            BgCslDimensionMemberCheckHelper newCheckHelper = BgCslDimensionMemberCheckHelper.getRemoteIntance(null, this.getEditData().getOrgUnit().getId().toString(), this.getEditData().getBgScheme().getOrgUnit().getId().toString(), null, this.getSchemeHelper(), (IMbgViewManager)view);
            if (this.checkHelper == null || this.checkHelper instanceof DimensionMemberCheckHelper.DimensionNullCheckHelper) {
                this.checkHelper = newCheckHelper;
            } else if (newCheckHelper != null) {
                this.checkHelper.addCheckHelper((DimensionMemberCheckHelper)newCheckHelper);
            }
        }
        catch (BgPeriodException ex) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)ex.getMessage(), (String)ex.getCause().getMessage(), (int)0);
            SysUtil.abort();
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    public Component getPageDimensionPanel() {
        return this.pageDimensionPanel;
    }

    public void doubleClickCell() {
        Cell cell = this.getBook().getActiveSheet().getActiveCell();
        if (this.getCheckHelper() instanceof BgCslDimensionMemberCheckHelper) {
            CellDoubleClickListener cellDoubleClickListener = new CellDoubleClickListener(this.getMainStatusBar(), cell, this.getBgFormInfo(), (DimensionMemberCheckHelper)((BgCslDimensionMemberCheckHelper)this.getCheckHelper()), this.getBgDataMap());
            cellDoubleClickListener.doubleClick();
        }
    }
}

