/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.bgcsl.BgCslSpecialItemsInfo;
import com.kingdee.eas.ma.bgcsl.BgCslSpecialRelationGroupCollection;
import com.kingdee.eas.ma.bgcsl.BgCslSpecialRelationGroupFactory;
import com.kingdee.eas.ma.bgcsl.client.AbstractBgCslAdjSpecialPanelUI;
import com.kingdee.eas.ma.bgcsl.client.cslTemplate.BgSpecialBudgetHelper;
import com.kingdee.eas.ma.bgcsl.common.IBgCslSpecialInfo;
import com.kingdee.eas.ma.bgcsl.utils.BgCslSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.DimRelashipGroupEntryCollection;
import com.kingdee.eas.ma.mbg.DimRelashipGroupEntryInfo;
import com.kingdee.eas.ma.mbg.DimensionRelationshipFactory;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupInfo;
import com.kingdee.eas.ma.mbg.DimensionRelationshipInfo;
import com.kingdee.eas.ma.mbg.client.NewDimensionSelectDialog;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgSpecialBudgetClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.NewDimensionMemberSelectDialog;
import com.kingdee.eas.ma.mbg.client.utils.SpecialDimRelationshipSelectDialog;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimSettingDisplayInfo;
import com.kingdee.eas.ma.mbg.utils.IGetSchemeHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgCslAdjSpecialPanelUI
extends AbstractBgCslAdjSpecialPanelUI
implements IGetSchemeHelper {
    private static final Logger logger = CoreUIObject.getLogger(BgCslAdjSpecialPanelUI.class);
    private String unionGroupId;
    private BgSchemeInfo schemeInfo;
    private IBgCslSpecialInfo bgTemplateInfo;
    private final String COL_DIMENSION = "dimension";
    private final String COL_MEMBER = "member";
    private final String COL_DIMRELAGROUP = "dimRelaGroup";
    private BgSchemeDimensionHelper schemeHelper = null;
    protected boolean isCanceled = true;

    public void onLoad() throws Exception {
        super.onLoad();
        this.prepareContext();
        this.tblMain.removeRows();
        if (null == this.bgTemplateInfo || StringUtils.isEmpty((String)this.unionGroupId)) {
            return;
        }
        this.initDimensionTableByBgTemplate(this.bgTemplateInfo, true);
    }

    private void prepareContext() {
        this.unionGroupId = (String)this.getUIContext().get("ORGTREEUNIT_ID");
        this.schemeInfo = (BgSchemeInfo)this.getUIContext().get(BgBaseConstants.BGSCHEME_INFO);
        this.bgTemplateInfo = (IBgCslSpecialInfo)this.getUIContext().get("IBgCslSpecialInfo");
    }

    public BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        if (this.schemeHelper == null && this.schemeInfo.getId() != null) {
            this.schemeHelper = new BgCslSchemeDimensionHelper(this.schemeInfo.getId().toString());
        }
        return this.schemeHelper;
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        if (this.tblMain.getRowCount() > 0) {
            this.checkMemberEmpty();
            this.updateTemplateInfo();
        }
        this.setCanceled(false);
        this.getUIWindow().close();
    }

    private void checkMemberEmpty() {
        int count = this.tblMain.getRowCount();
        for (int rowIndex = 0; rowIndex < count; ++rowIndex) {
            Object obj;
            ICell dCell = this.tblMain.getCell(rowIndex, "dimension");
            ICell mCell = this.tblMain.getCell(rowIndex, "member");
            if (mCell == null || dCell == null || mCell.getValue() != null || !((obj = dCell.getValue()) instanceof DimSettingDisplayInfo)) continue;
            String dimName = ((DimSettingDisplayInfo)obj).getDimSettingInfo().getDimName();
            BgNFCHelper.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgNFormResource", (String)"chooseDimMember", (Object[])new String[]{dimName}));
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setCanceled(true);
        this.getUIWindow().close();
    }

    protected void initDimensionTableByBgTemplate(IBgCslSpecialInfo bgTemplateInfo, boolean isFromTemplate) throws BOSException, EASBizException {
        if (bgTemplateInfo == null) {
            return;
        }
        if (!BgTemFormTypeEnum.SPECIALFORM.equals((Object)bgTemplateInfo.getFormType())) {
            return;
        }
        BgCslSpecialItemsInfo itemsInfo = BgSpecialBudgetHelper.getBgSpecialItem(bgTemplateInfo);
        if (itemsInfo == null) {
            return;
        }
        itemsInfo = BgCslSpecialRelationGroupFactory.getRemoteInstance().addDimRelaGroupForBgSpecialItems(itemsInfo);
        bgTemplateInfo.getBgSpecialItems().clear();
        bgTemplateInfo.getBgSpecialItems().add(itemsInfo);
        BgSpecialBudgetHelper.loadDimensionTable(this.tblMain, this.getSchemeHelper(), itemsInfo);
        this.afterDimenisonTableInited(isFromTemplate);
        this.initDimRelations(itemsInfo);
    }

    private void afterDimenisonTableInited(boolean isFromTemplate) throws EASBizException, BOSException {
        this.lockDimensionColumn();
        this.lockDimRelaGroupColumn();
        this.lockMemberColumn(isFromTemplate);
        this.initPrmtDimension();
        this.initPrmtMember();
    }

    private void initPrmtDimension() {
        KDBizPromptBox prmptDimension = new KDBizPromptBox();
        this.formatePrmtDimension(prmptDimension);
        KDTDefaultCellEditor dimEditor = new KDTDefaultCellEditor((IKDEditor)prmptDimension);
        this.tblMain.getRow(0).getCell("dimension").setEditor((ICellEditor)dimEditor);
    }

    private void formatePrmtDimension(KDBizPromptBox prmptDim) {
        prmptDim.setRequired(true);
        NewDimensionSelectDialog dialog = this.initDimensionF7();
        prmptDim.addDataChangeListener((DataChangeListener)dialog);
        prmptDim.setEditable(false);
        prmptDim.setSelector((KDPromptSelector)dialog);
        prmptDim.setRequestFocusEnabled(true);
    }

    protected NewDimensionSelectDialog initDimensionF7() {
        NewDimensionSelectDialog dialog = new NewDimensionSelectDialog((CoreUI)this, true);
        dialog.setOnlyMbgDim(Boolean.valueOf(true));
        dialog.setCsl(true);
        dialog.setBgSchemeId(this.schemeInfo.getId().toString());
        return dialog;
    }

    private void initPrmtMember() throws EASBizException, BOSException {
        int count = this.tblMain.getRowCount();
        IRow row = null;
        Object dimension = null;
        for (int index = 0; index < count; ++index) {
            row = this.tblMain.getRow(index);
            dimension = row.getCell("dimension").getValue();
            if (!(dimension instanceof DimSettingDisplayInfo)) continue;
            this.setPrmtValue(row, (DimSettingDisplayInfo)dimension);
        }
    }

    private void setPrmtValue(IRow row, DimSettingDisplayInfo dimension) throws EASBizException, BOSException {
        if (row == null || dimension == null) {
            return;
        }
        String dimNumber = dimension.getDimSettingInfo().getDimNumber();
        KDBizPromptBox prmptMember = new KDBizPromptBox();
        prmptMember.setEditable(false);
        KDTDefaultCellEditor memberEditor = new KDTDefaultCellEditor((IKDEditor)prmptMember);
        if (row.getCell("dimension").getEditor() != null && row.getCell("dimension").getEditor().getComponent() instanceof KDBizPromptBox) {
            ((KDBizPromptBox)row.getCell("dimension").getEditor().getComponent()).setDataNoNotify((Object)dimension);
        } else {
            row.getCell("dimension").setValue((Object)dimension);
        }
        prmptMember.setSelector((KDPromptSelector)this.getMemberDialog(this.getSchemeHelper().getDimension(dimNumber), this.getOrgUnitId()));
        row.getCell("member").setEditor((ICellEditor)memberEditor);
        if (row.getCell("member").getValue() instanceof List) {
            if (((List)row.getCell("member").getValue()).get(0) instanceof BgDimensionMember && !((BgDimensionMember)((List)row.getCell("member").getValue()).get(0)).getType().equals(dimNumber)) {
                row.getCell("member").setValue(null);
            }
        } else if (row.getCell("member").getValue() instanceof BgDimensionMember && !((BgDimensionMember)row.getCell("member").getValue()).getType().equals(dimNumber)) {
            row.getCell("member").setValue(null);
        }
        if (row.getCell("dimRelaGroup").getValue() != null) {
            prmptMember.setSelector(this.getRelationshipDialog(((DimensionRelationshipGroupInfo)row.getCell("dimRelaGroup").getValue()).getId().toString(), this.getOrgUnitId()));
            this.prmptMember_dataChange(prmptMember);
        }
    }

    private KDPromptSelector getRelationshipDialog(String groupId, String orgId) {
        ArrayList<DimensionRelationshipGroupInfo> groups = new ArrayList<DimensionRelationshipGroupInfo>();
        if (groupId != null) {
            DimensionRelationshipGroupInfo group = new DimensionRelationshipGroupInfo();
            group.setId(BOSUuid.read((String)groupId));
            groups.add(group);
        }
        SpecialDimRelationshipSelectDialog dialog = new SpecialDimRelationshipSelectDialog((CoreUI)this);
        dialog.setOrgId(orgId);
        dialog.setUnionGroupId(this.unionGroupId);
        dialog.setGroupIds(groups);
        dialog.setMultipleSelect(false);
        return dialog;
    }

    private void prmptMember_dataChange(KDBizPromptBox prmptMember) {
        prmptMember.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (eventObj.getNewValue() instanceof DimensionRelationshipInfo) {
                    ((KDBizPromptBox)eventObj.getSource()).setEdittedStop(true);
                    DimensionRelationshipInfo dimRela = (DimensionRelationshipInfo)eventObj.getNewValue();
                    BgCslAdjSpecialPanelUI.this.parseRelationshipMember(dimRela);
                } else if (eventObj.getNewValue() == null) {
                    int rowIndex = BgCslAdjSpecialPanelUI.this.tblMain.getSelectManager().getActiveRowIndex();
                    DimensionRelationshipGroupInfo delGroup = (DimensionRelationshipGroupInfo)BgCslAdjSpecialPanelUI.this.tblMain.getRow(rowIndex).getCell("dimRelaGroup").getValue();
                    int count = BgCslAdjSpecialPanelUI.this.tblMain.getRowCount();
                    for (int index = 0; index < count; ++index) {
                        DimensionRelationshipGroupInfo group = (DimensionRelationshipGroupInfo)BgCslAdjSpecialPanelUI.this.tblMain.getRow(index).getCell("dimRelaGroup").getValue();
                        if (group != delGroup) continue;
                        BgCslAdjSpecialPanelUI.this.tblMain.getRow(index).getCell("member").setValue(null);
                    }
                }
            }
        });
    }

    private NewDimensionMemberSelectDialog getMemberDialog(BgDimensionInfo dimen, String orgId) {
        NewDimensionMemberSelectDialog memberDialog = new NewDimensionMemberSelectDialog((Component)((Object)this), this.schemeInfo.getId().toString(), (BgDimensionBaseInfo)dimen, orgId, false, false);
        memberDialog.setUninGroupId(this.unionGroupId);
        memberDialog.setCanntFilterOrg(true);
        return memberDialog;
    }

    private void lockDimensionColumn() {
        this.tblMain.getColumn("dimension").getStyleAttributes().setLocked(true);
    }

    private void lockDimRelaGroupColumn() {
        this.tblMain.getColumn("dimRelaGroup").getStyleAttributes().setLocked(true);
    }

    private void lockMemberColumn(boolean isFromTemplate) {
        int count = this.tblMain.getRowCount();
        for (int rowIndex = 0; rowIndex < count; ++rowIndex) {
            ICell cell = this.tblMain.getCell(rowIndex, "member");
            if (cell.getValue() != null && isFromTemplate) {
                cell.getStyleAttributes().setLocked(true);
                continue;
            }
            cell.getStyleAttributes().setBackground(BgSpecialBudgetClientHelper.REQUIRED_COLOR);
        }
    }

    private void initDimRelations(BgCslSpecialItemsInfo itemsInfo) throws EASBizException, BOSException {
        if (itemsInfo == null) {
            return;
        }
        HashSet<String> groupId = new HashSet<String>();
        HashMap<String, DimensionRelationshipGroupInfo> groupMap = new HashMap<String, DimensionRelationshipGroupInfo>();
        BgCslSpecialRelationGroupCollection coll = itemsInfo.getDimRelaGroupRef();
        for (int i = 0; i < coll.size(); ++i) {
            groupId.add(coll.get(i).getDimRelaGroup().getId().toString());
            groupMap.put(coll.get(i).getDimRelaGroup().getId().toString(), coll.get(i).getDimRelaGroup());
        }
        Map relaMap = DimensionRelationshipFactory.getRemoteInstance().getOnlyRelationshipByGourps(groupId, this.unionGroupId, null);
        for (String gourpId : relaMap.keySet()) {
            DimensionRelationshipInfo rela = (DimensionRelationshipInfo)relaMap.get(gourpId);
            rela.setDimensionGroup((DimensionRelationshipGroupInfo)groupMap.get(rela.getDimensionGroup().getId().toString()));
            this.parseRelationshipMember((DimensionRelationshipInfo)relaMap.get(gourpId));
        }
    }

    private void parseRelationshipMember(DimensionRelationshipInfo dimRela) {
        if (dimRela == null) {
            return;
        }
        DimRelashipGroupEntryCollection colls = dimRela.getDimensionGroup().getEntries();
        BgSchemeDimensionHelper helper = null;
        try {
            helper = this.getSchemeHelper();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        HashMap<String, DimRelashipGroupEntryInfo> entryMap = new HashMap<String, DimRelashipGroupEntryInfo>();
        DimRelashipGroupEntryInfo entry = null;
        for (int i = 0; i < colls.size(); ++i) {
            entry = colls.get(i);
            entryMap.put(helper.getSrcNumber(entry.getDimNumber()), entry);
        }
        String dimNumber = dimRela.getDimensionNumber();
        String dimName = dimRela.getDimensionName();
        String[] dimNumbers = dimNumber.split(DimensionConstants.COMMA_SEPARATOR);
        String[] dimNames = dimName.split(DimensionConstants.TICK_SEPARATOR);
        HashMap<String, BgDimensionMember> memberMap = new HashMap<String, BgDimensionMember>();
        for (int i = 0; i < dimNumbers.length; ++i) {
            String srcNum = dimNumbers[i].split(DimensionConstants.COLON_SEPARATOR)[0];
            String memberNum = dimNumbers[i].split(DimensionConstants.COLON_SEPARATOR)[1];
            BgDimensionInfo dimension = helper.getDimension(((DimRelashipGroupEntryInfo)entryMap.get(srcNum)).getDimNumber());
            BgDimensionMember member = new BgDimensionMember(dimension.getType(), dimension.getAttribute(), dimNames[i], memberNum);
            memberMap.put(member.getType(), member);
        }
        int count = this.tblMain.getRowCount();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0) {
            this.tblMain.getRow(rowIndex).getCell("member").setValue(null);
        }
        for (int index = 0; index < count; ++index) {
            DimSettingDisplayInfo dimSett = (DimSettingDisplayInfo)this.tblMain.getRow(index).getCell("dimension").getValue();
            if (!memberMap.containsKey(dimSett.getDimSettingInfo().getDimNumber())) continue;
            this.tblMain.getRow(index).getCell("member").setValue(memberMap.get(dimSett.getDimSettingInfo().getDimNumber()));
        }
    }

    protected String getOrgUnitId() {
        if (SysContext.getSysContext().getCurrentCostUnit() != null) {
            return SysContext.getSysContext().getCurrentCostUnit().getId().toString();
        }
        if (this.schemeInfo != null) {
            return this.schemeInfo.getOrgUnit().getId().toString();
        }
        return "00000000-0000-0000-0000-000000000000CCE7AED4";
    }

    protected void checkTableParsed() {
        this.tblMain.checkParsed();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean isCanceled) {
        this.isCanceled = isCanceled;
    }

    public Object getData() {
        return this.bgTemplateInfo;
    }

    public void dataChanged(DataChangeEvent eventObj) {
        Object newValue = eventObj.getNewValue();
        Object oldValue = eventObj.getOldValue();
        if (null != newValue && newValue instanceof IBgCslSpecialInfo && !BgCommCHelper.isEqualsPK((IObjectValue)((IObjectValue)oldValue), (IObjectValue)((IObjectValue)newValue))) {
            try {
                this.tblMain.removeRows();
                this.initDimensionTableByBgTemplate((IBgCslSpecialInfo)newValue, false);
                this.bgTemplateInfo = (IBgCslSpecialInfo)newValue;
            }
            catch (Exception var) {
                logger.error((Object)"", (Throwable)var);
                this.handUIException(var);
            }
        }
    }

    private void updateTemplateInfo() throws BOSException, EASBizException {
        if (this.bgTemplateInfo.getBgSpecialItems() != null && !this.bgTemplateInfo.getBgSpecialItems().isEmpty()) {
            BgSpecialBudgetHelper.updateBgSpecialInfo(this.tblMain, this.bgTemplateInfo, this.getSchemeHelper());
        } else {
            BgCslSpecialItemsInfo newInfo = BgSpecialBudgetHelper.getNewInfo(this.tblMain, this.bgTemplateInfo, this.getSchemeHelper(), true);
            if (newInfo != null) {
                this.bgTemplateInfo.getBgSpecialItems().add(newInfo);
            }
        }
    }
}

