/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.action.NotifyEvent;
import com.kingdee.bos.ctrl.excel.impl.action.NotifyListener;
import com.kingdee.bos.ctrl.excel.impl.action.SpreadAction;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.UserObject;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.newrpt.client.designer.IMenuStrategy;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.bgcsl.BgCslSpecialItemsCollection;
import com.kingdee.eas.ma.bgcsl.BgCslSpecialItemsInfo;
import com.kingdee.eas.ma.bgcsl.client.BgCslAdjTemplateProcessUI;
import com.kingdee.eas.ma.bgcsl.client.cslAdjTemplate.BgCslAdjTemplateMenuManager;
import com.kingdee.eas.ma.bgcsl.client.cslAdjTemplate.BgCslAdjTemplateProvider;
import com.kingdee.eas.ma.bgcsl.client.cslTemplate.BgSpecialBudgetHelper;
import com.kingdee.eas.ma.bgcsl.client.cslTemplate.SpecialImportAction;
import com.kingdee.eas.ma.bgcsl.client.utils.BgCslClientHelper;
import com.kingdee.eas.ma.bgcsl.utils.BgSpecialCommonHelper;
import com.kingdee.eas.ma.mbg.client.BgTemFormatImportUI;
import com.kingdee.eas.ma.mbg.client.utils.DimensionFillHelper;
import com.kingdee.eas.ma.mbg.client.utils.IBgSpecialTemplateProcessUI;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgNTemplateHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgCslAdjSpecialTemplateProcessUI
extends BgCslAdjTemplateProcessUI
implements IBgSpecialTemplateProcessUI {
    private static final long serialVersionUID = -7137456291220149877L;
    private static final Logger logger = CoreUIObject.getLogger(BgCslAdjSpecialTemplateProcessUI.class);
    private Boolean isElementRequired = null;
    private Boolean isScenarioRequired = null;
    private KDPanel pagePanel = null;

    @Override
    public boolean isElementRequired() {
        if (this.isElementRequired == null) {
            try {
                this.isElementRequired = !BgSpecialCommonHelper.isInSpecialItem(DimensionConstants.DEF_ELEMENT_NUMBER, this.getBgCslTemplate(), this.getSchemeHelper());
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return this.isElementRequired;
    }

    @Override
    public boolean isScenarioRequired() {
        if (this.isScenarioRequired == null) {
            try {
                this.isScenarioRequired = !BgSpecialCommonHelper.isInSpecialItem(DimensionConstants.DEF_SCENARIO_NUMBER, this.getBgCslTemplate(), this.getSchemeHelper());
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return this.isScenarioRequired;
    }

    public Map<String, Set<String>> getFilterMap() throws EASBizException, BOSException {
        Map<String, Set<String>> filterMap = BgSpecialBudgetHelper.getFilterMapByBgTemplate(this.getBgCslTemplate(), this.getSchemeHelper());
        filterMap = BgCslClientHelper.addClsAdjFilter(filterMap);
        return filterMap;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.addPagePanel();
        if (!this.isElementRequired()) {
            this.actionAddBgElement.setEnabled(false);
            this.btnAddElement.setEnabled(false);
            this.itemAddBgElement.setEnabled(false);
        }
        if (!this.isScenarioRequired()) {
            this.actionAddBgScenario.setEnabled(false);
            this.btnAddScenario.setEnabled(false);
            this.itemAddBgScenario.setEnabled(false);
        }
    }

    @Override
    public void actionBgItemFill_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        uiContext.put((Object)"ORGUNITID", (Object)this.getOrgUnitID());
        uiContext.put((Object)BgBaseConstants.UNIONGROUP_ID, (Object)this.getOrgGroupID());
        uiContext.put((Object)"item_formula_map", (Object)this.getItemFormulMap());
        uiContext.put((Object)"this_is_from_template", (Object)Boolean.TRUE);
        uiContext.put((Object)"BGSCHEME_ID", (Object)this.getBgSchemeId());
        uiContext.put((Object)"filterValueMap", this.getFilterMap());
        uiContext.put((Object)"IS_SPECIAL_BUDGET", (Object)Boolean.TRUE);
        uiContext.put((Object)"IS_ELEMENT_REQUIRED", (Object)this.isElementRequired());
        uiContext.put((Object)"IS_SCENARIO_REQUIRED", (Object)this.isScenarioRequired());
        uiContext.put((Object)"IS_CSL_ON_COL", (Object)Boolean.TRUE);
        try {
            uiContext.put((Object)"BGSCHEME_HELPER", (Object)this.getSchemeHelper());
        }
        catch (EASBizException ex) {
            logger.error((Object)"", (Throwable)ex);
            this.handUIExceptionAndAbort((Exception)((Object)ex));
        }
        catch (BOSException ex) {
            logger.error((Object)"", (Throwable)ex);
            this.handUIExceptionAndAbort((Exception)((Object)ex));
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgTemFormatImportUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        uiWindow.show();
        this.getSpreadManager().getSpreadContainer().repaint();
    }

    @Override
    public void actionAddBgItem_actionPerformed(ActionEvent e) throws Exception {
        this.getBook().getUndoManager().startGroup();
        String orgUnitId = this.getOrgUnitID();
        try {
            DimensionFillHelper.showBgItem((IUIObject)this, (String)this.getBgSchemeId(), (Sheet)this.getBook().getActiveSheet(), (boolean)true, (String)"", (String)"", (Map)this.getItemFormulMap(), null, (boolean)false, (boolean)false, (String)orgUnitId, (String)this.getOrgGroupID(), (boolean)true, this.getFilterMap(), (boolean)this.isElementRequired(), (boolean)this.isScenarioRequired());
            this.getSpreadManager().getSpreadContainer().repaint();
        }
        finally {
            this.getBook().getUndoManager().endGroup();
        }
    }

    @Override
    public void actionMutiUpdateFormula_actionPerformed(ActionEvent e) throws Exception {
        String orgUnitId = this.getOrgUnitID();
        this.getBook().getUndoManager().startGroup();
        try {
            DimensionFillHelper.mutiUpdateBgItemFormula((IUIObject)this, (Sheet)this.getBook().getActiveSheet(), null, (String)orgUnitId, (String)this.getOrgGroupID(), (BgSchemeDimensionHelper)this.getSchemeHelper(), this.getFilterMap());
            this.getSpreadManager().getSpreadContainer().repaint();
        }
        finally {
            this.getBook().getUndoManager().endGroup();
        }
    }

    @Override
    public void actionCreateItemFormula_actionPerformed(ActionEvent e) throws Exception {
        this.getBook().getUndoManager().startGroup();
        String orgUnitId = this.getOrgUnitID();
        try {
            DimensionFillHelper.createItemFormula((IUIObject)this, (Sheet)this.getBook().getActiveSheet(), (IObjectValue)this.getBgCslTemplate(), (Map)this.getItemFormulMap(), (boolean)true, (boolean)false, (boolean)false, (String)orgUnitId, (boolean)true, this.getFilterMap(), (boolean)this.isElementRequired(), (boolean)this.isScenarioRequired());
            this.getSpreadManager().getSpreadContainer().repaint();
        }
        finally {
            this.getBook().getUndoManager().endGroup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionCreateBgFormula_actionPerformed(ActionEvent e) throws Exception {
        this.getBook().getUndoManager().startGroup();
        String orgUnitId = this.getOrgUnitID();
        try {
            Map<String, Set<String>> filterValueMap = this.getFilterMap();
            if (e.getActionCommand().equalsIgnoreCase("MbgActualS")) {
                DimensionFillHelper.createBgFormula((IUIObject)this, (Sheet)this.getBook().getActiveSheet(), (IObjectValue)this.getBgCslTemplate(), (String)"MbgActualS", (boolean)false, (boolean)false, (String)orgUnitId, (boolean)true, filterValueMap, (boolean)this.isElementRequired(), (boolean)this.isScenarioRequired(), (boolean)true);
            } else if (e.getActionCommand().equalsIgnoreCase("MbgAggregate")) {
                DimensionFillHelper.createBgFormula((IUIObject)this, (Sheet)this.getBook().getActiveSheet(), (IObjectValue)this.getBgCslTemplate(), (String)"MbgAggregate", (boolean)false, (boolean)false, (String)orgUnitId, (boolean)true, filterValueMap, (boolean)this.isElementRequired(), (boolean)this.isScenarioRequired(), (boolean)true);
            } else if (e.getActionCommand().equalsIgnoreCase("MbgFormula")) {
                DimensionFillHelper.createBgFormula((IUIObject)this, (Sheet)this.getBook().getActiveSheet(), (IObjectValue)this.getBgCslTemplate(), (String)"MbgFormula", (boolean)false, (boolean)false, (String)orgUnitId, (boolean)true, filterValueMap, (boolean)this.isElementRequired(), (boolean)this.isScenarioRequired(), (boolean)true);
            } else if (e.getActionCommand().equalsIgnoreCase("MbgActualSF")) {
                DimensionFillHelper.createBgFormulaFromItemFormula((IUIObject)this, (Sheet)this.getBook().getActiveSheet(), (IObjectValue)this.getBgCslTemplate(), (String)"MbgActualS", (boolean)false, (boolean)false, (String)orgUnitId, (boolean)true, filterValueMap, (boolean)this.isElementRequired(), (boolean)this.isScenarioRequired(), (boolean)true);
            } else if (e.getActionCommand().equalsIgnoreCase("MbgAggregateF")) {
                DimensionFillHelper.createBgFormulaFromItemFormula((IUIObject)this, (Sheet)this.getBook().getActiveSheet(), (IObjectValue)this.getBgCslTemplate(), (String)"MbgAggregate", (boolean)false, (boolean)false, (String)orgUnitId, (boolean)true, filterValueMap, (boolean)this.isElementRequired(), (boolean)this.isScenarioRequired(), (boolean)true);
            } else if (e.getActionCommand().equalsIgnoreCase("MbgFormulaF")) {
                DimensionFillHelper.createBgFormulaFromItemFormula((IUIObject)this, (Sheet)this.getBook().getActiveSheet(), (IObjectValue)this.getBgCslTemplate(), (String)"MbgFormula", (boolean)false, (boolean)false, (String)orgUnitId, (boolean)true, filterValueMap, (boolean)this.isElementRequired(), (boolean)this.isScenarioRequired(), (boolean)true);
            }
            this.getSpreadManager().getSpreadContainer().repaint();
        }
        finally {
            this.getBook().getUndoManager().endGroup();
        }
    }

    @Override
    protected void initAction() {
        super.initAction();
        SpreadAction actionBeforeClearCell_DefaultAction = this.getSpreadActionManager().getAction("Clear_CellFormulaAndValue");
        actionBeforeClearCell_DefaultAction.setAfterAction(new NotifyListener(){

            public void doNotify(NotifyEvent evt) {
                this.actionAfterClearCell_DefaultAction(evt);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void actionAfterClearCell_DefaultAction(NotifyEvent evt) {
                BgCslAdjSpecialTemplateProcessUI.this.getBook().getUndoManager().startGroup();
                try {
                    Cell cell = null;
                    Sheet sheet = BgCslAdjSpecialTemplateProcessUI.this.getBook().getActiveSheet();
                    int maxRowIndex = sheet.getMaxRowIndex();
                    int maxColIndex = sheet.getMaxColIndex();
                    Range range = sheet.getSelectionRange();
                    int num = range.size();
                    if (num <= 0) {
                        return;
                    }
                    for (int i = 0; i < range.size(); ++i) {
                        CellBlock block = range.getBlock(i);
                        int rowBegin = block.getRow();
                        int rowEnd = block.getRow2() > maxRowIndex ? maxRowIndex : block.getRow2();
                        int colBegin = block.getCol();
                        int colEnd = block.getCol2() > maxColIndex ? maxColIndex : block.getCol2();
                        for (int j = rowBegin; j <= rowEnd; ++j) {
                            for (int k = colBegin; k <= colEnd; ++k) {
                                cell = sheet.getCell(j, k, false);
                                if (cell == null) continue;
                                BgNFSHelper.clearBgItemInfo((Cell)cell);
                            }
                        }
                    }
                }
                finally {
                    BgCslAdjSpecialTemplateProcessUI.this.getBook().getUndoManager().endGroup();
                }
            }
        });
    }

    @Override
    protected void beforeSaveDealWithBgItems() {
        try {
            Book book = this.getBook();
            String orgUnitId = this.getOrgUnitID();
            BgNTemplateHelper.dealWith((Book)book, (String)orgUnitId, (Map)this.getItemFormulMap(), (boolean)true, (boolean)true, (String)"bgData", (boolean)false, (boolean)false, null, (BgSchemeDimensionHelper)this.getSchemeHelper(), (boolean)true, this.getFilterMap(), (boolean)this.isElementRequired(), (boolean)this.isScenarioRequired());
        }
        catch (EASBizException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
    }

    @Override
    public IMenuStrategy getBudgetMenuStrategy() {
        return new BgCslAdjTemplateMenuManager((Component)((Object)this));
    }

    @Override
    public IBookProvider getBudgetProvider() {
        return new BgCslAdjTemplateProvider(this);
    }

    private KDPanel getPagePanel() {
        if (this.pagePanel == null) {
            this.pagePanel = new KDPanel();
            this.pagePanel.setLayout((LayoutManager)new BorderLayout());
        }
        return this.pagePanel;
    }

    private SpreadContext getSpreadContext() {
        return this.getSpreadManager().getSpreadContainer();
    }

    private Component getPageDimensionPanel() throws Exception {
        KDPanel kdPanel = this.getPagePanel();
        kdPanel.removeAll();
        SpreadContext sc = this.getSpreadContext();
        kdPanel.add(this.getBgSpecialItemsComponet(), (Object)"North");
        kdPanel.add((Component)sc, (Object)"Center");
        kdPanel.revalidate();
        return kdPanel;
    }

    public void addPagePanel() throws Exception {
        this.getUIContentPane().add(this.getPageDimensionPanel(), "Center");
    }

    private Component getBgSpecialItemsComponet() throws Exception {
        return BgSpecialBudgetHelper.parseSpecialItemsComponet((CoreUI)this, this.getBgCslTemplate(), this.getSchemeHelper(), this.getOrgUnitID());
    }

    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        Book _book = this.getBook();
        Sheet _sheet = null;
        HashMap<String, Object> creatorMap = new HashMap<String, Object>();
        int sheetSizeBegin = 0;
        if (_book != null) {
            int sheetIndex = 0;
            sheetSizeBegin = _book.getSheetCount();
            Object sheetCreater = null;
            for (sheetIndex = 0; sheetIndex < sheetSizeBegin; ++sheetIndex) {
                _sheet = _book.getSheet(sheetIndex);
                sheetCreater = _sheet.getUserObjectValue("SHEET_CREATER_ID");
                creatorMap.put(String.valueOf(sheetIndex), sheetCreater);
            }
        }
        SpecialImportAction ea = new SpecialImportAction(this.getSpreadManager().getSpreadContainer(), this.getSchemeHelper(), this.getBgCslTemplate());
        ea.actionPerformed(e);
        this.getSpreadManager().getModifyManager().setModified();
        if (_book != null) {
            int sheetIndex;
            BgNFSHelper.setBookProtection((Book)_book, (boolean)false, (List)BgNFSHelper.getMaxOperation());
            int sheetSizeAfter = _book.getSheetCount();
            if (sheetSizeBegin >= sheetSizeAfter) {
                for (sheetIndex = 0; sheetIndex < sheetSizeAfter; ++sheetIndex) {
                    _sheet = _book.getSheet(sheetIndex);
                    _sheet.setUserObject("SHEET_CREATER_ID", creatorMap.get(String.valueOf(sheetIndex)));
                }
            } else {
                for (sheetIndex = 0; sheetIndex < sheetSizeBegin; ++sheetIndex) {
                    _sheet = _book.getSheet(sheetIndex);
                    _sheet.setUserObject("SHEET_CREATER_ID", creatorMap.get(String.valueOf(sheetIndex)));
                }
                for (sheetIndex = sheetSizeBegin; sheetIndex < sheetSizeAfter; ++sheetIndex) {
                    _sheet = _book.getSheet(sheetIndex);
                    _sheet.setUserObject("SHEET_CREATER_ID", (Object)SysContext.getSysContext().getCurrentUserInfo().getId());
                }
            }
            for (int i = 0; i < _book.getSheetCount(); ++i) {
                BgNFSHelper.setSheetProtection((Sheet)_book.getSheet(i), (boolean)false, (List)BgNFSHelper.getMaxOperation());
            }
            BookChangeEvent bce = new BookChangeEvent(_book.getActiveSheet(), "Sheet_Active", false);
            this.getSpreadActionManager().changed(bce);
        }
        this.getSpreadManager().getSpreadContainer().repaint();
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        Book book = this.getBook();
        BgCslSpecialItemsCollection colls = this.getBgCslTemplate().getBgSpecialItems();
        ArrayList itemList = new ArrayList();
        for (int i = 0; i < colls.size(); ++i) {
            HashMap<String, String> itemMap = new HashMap<String, String>();
            BgCslSpecialItemsInfo item = colls.get(i);
            itemMap.put("dimensionNumber", item.getDimensionNumber());
            itemMap.put("dimensionName", item.getDimensionName());
            itemMap.put("memberName", item.getMemberName());
            itemMap.put("memberDisplayName", item.getMemberDisplayName());
            itemList.add(itemMap);
        }
        UserObject obj = new UserObject("bgSpecialItems", itemList);
        book.getUserObjects().append((Object)obj);
        super.actionExport_actionPerformed(e);
    }
}

