/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.resource.KDResourceManager;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bgcsl.BgCslAdjTemplateInfo;
import com.kingdee.eas.ma.bgcsl.client.AbstractBgCslAdjTemplateF7UI;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class BgCslAdjTemplateF7UI
extends AbstractBgCslAdjTemplateF7UI {
    private static final long serialVersionUID = -9153977782221836038L;
    private static final Logger logger = CoreUIObject.getLogger(BgCslAdjTemplateF7UI.class);
    public static final String ISMULTISELECT = "ISMULTISELECT";
    protected static final String COL_SELECT = "select";
    private OrgTreeInfo orgTree = null;
    private BgSchemeInfo bgScheme = null;
    private boolean isCancel = true;
    private boolean isMultiSelect = true;
    private Object[] data = null;
    private Map<String, Map<String, BgCslAdjTemplateInfo>> selectedMap = new HashMap<String, Map<String, BgCslAdjTemplateInfo>>();

    public OrgTreeInfo getOrgTree() {
        if (this.orgTree == null) {
            this.orgTree = (OrgTreeInfo)this.getUIContext().get("orgTreeInfo");
        }
        return this.orgTree;
    }

    public BgSchemeInfo getBgScheme() {
        if (this.bgScheme == null) {
            this.bgScheme = (BgSchemeInfo)this.getUIContext().get("BGSCHEME_INFO");
        }
        return this.bgScheme;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public Object getData() {
        if (this.data == null || this.data.length == 0) {
            return null;
        }
        if (this.isMultiSelect) {
            return this.data;
        }
        return this.data[0];
    }

    @Override
    public void onLoad() throws Exception {
        this.isMultiSelect = !Boolean.FALSE.equals(this.getUIContext().get(ISMULTISELECT));
        Object data = this.getUIContext().get("InitDataObject");
        if (data instanceof Object[]) {
            for (Object obj : (Object[])data) {
                this.addSelectedMap(obj);
            }
        } else {
            this.addSelectedMap(data);
        }
        super.onLoad();
        this.btnSelectAll.setVisible(this.isMultiSelect);
        this.btnClearAll.setVisible(this.isMultiSelect);
        this.rbCurrOrgUnit.setVisible(false);
        this.rbImmOrgUnit.setVisible(false);
        this.rbAllOrgUnit.setVisible(false);
        this.tblMain.getSelectManager().setSelectMode(2);
        if (this.isMultiSelect) {
            this.tblMain.setEditable(true);
            this.tblMain.getColumn(COL_SELECT).getStyleAttributes().setLocked(false);
        } else {
            this.tblMain.getColumn(COL_SELECT).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COL_SELECT).getStyleAttributes().setLocked(true);
        }
        this.btnSearch.setIcon((Icon)new ImageIcon(KDResourceManager.getImageOfRapid((String)"prompt_off.gif")));
        this.btnSearch.setBackground(new Color(7645403));
        this.btnSearch.setDisabledIcon((Icon)new ImageIcon(KDResourceManager.getImageOfRapid((String)"prompt_disable.gif")));
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BgCslAdjTemplateF7UI.this.refreshList();
                }
                catch (Exception e1) {
                    BgCslAdjTemplateF7UI.this.handUIExceptionAndAbort(e1);
                }
            }
        });
        this.txtSearch.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    try {
                        BgCslAdjTemplateF7UI.this.refreshList();
                    }
                    catch (Exception e1) {
                        BgCslAdjTemplateF7UI.this.handUIExceptionAndAbort(e1);
                    }
                }
            }
        });
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.txtSearch, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.tblMain.checkParsed();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                BgCslAdjTemplateF7UI.this.f7_afterDataFill(e);
            }
        });
    }

    private void addSelectedMap(Object obj) {
        if (!(obj instanceof BgCslAdjTemplateInfo)) {
            return;
        }
        BgCslAdjTemplateInfo info = (BgCslAdjTemplateInfo)obj;
        if (!this.selectedMap.containsKey(info.getOrgUnit().getNumber())) {
            this.selectedMap.put(info.getOrgUnit().getNumber(), new HashMap());
        }
        this.selectedMap.get(info.getOrgUnit().getNumber()).put(info.getNumber(), info);
    }

    @Override
    protected void initOrgTreeF7() throws Exception {
        super.initOrgTreeF7();
        BgNFCHelper.setSelectObject((KDComboBox)this.combOrgTree, (Object)this.getOrgTree());
    }

    @Override
    protected void initBgScheme() throws BOSException, EASBizException {
        this.prmtBgScheme.setData((Object)this.getBgScheme());
        this.prmtBgScheme.setEditable(false);
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        this.confirm();
    }

    private void confirm() {
        this.storeCurrSelect(this.treeOrgUnit.getLastSelectedPathComponent());
        ArrayList<BgCslAdjTemplateInfo> selected = new ArrayList<BgCslAdjTemplateInfo>();
        for (Map<String, BgCslAdjTemplateInfo> tmpMap : this.selectedMap.values()) {
            selected.addAll(tmpMap.values());
        }
        this.data = selected.isEmpty() ? null : selected.toArray();
        this.isCancel = false;
        this.destroyWindow();
    }

    protected void treeOrgUnit_valueChanged(TreeSelectionEvent e) throws Exception {
        if (e.getOldLeadSelectionPath() != null) {
            this.storeCurrSelect(e.getOldLeadSelectionPath().getLastPathComponent());
        }
        super.treeOrgUnit_valueChanged(e);
    }

    private void storeCurrSelect(Object curNode) {
        if (curNode != null) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)curNode;
            FullOrgUnitInfo orgUnit = this.getOrgUnitInfo(node);
            if (this.isMultiSelect) {
                this.tblMain.getEditManager().stopEditing();
                BgCslAdjTemplateInfo info = null;
                HashMap<String, BgCslAdjTemplateInfo> tmpMap = new HashMap<String, BgCslAdjTemplateInfo>();
                for (int r = 0; r < this.tblMain.getRowCount(); ++r) {
                    if (this.tblMain.getRow(r).getStyleAttributes().isHided() || !Boolean.TRUE.equals(this.tblMain.getCell(r, COL_SELECT).getValue())) continue;
                    info = this.getCurrInfo(r, orgUnit);
                    tmpMap.put(info.getNumber(), info);
                }
                this.selectedMap.put(orgUnit.getNumber(), tmpMap);
            } else {
                this.selectedMap.clear();
                int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
                if (rowIndex >= 0) {
                    BgCslAdjTemplateInfo info = this.getCurrInfo(rowIndex, orgUnit);
                    HashMap<String, BgCslAdjTemplateInfo> tmpMap = new HashMap<String, BgCslAdjTemplateInfo>();
                    tmpMap.put(info.getNumber(), info);
                    this.selectedMap.put(orgUnit.getNumber(), tmpMap);
                }
            }
        }
    }

    private BgCslAdjTemplateInfo getCurrInfo(int rowIndex, FullOrgUnitInfo orgUnit) {
        IRow row = this.tblMain.getRow(rowIndex);
        if (row == null) {
            return null;
        }
        if (orgUnit == null) {
            orgUnit = (FullOrgUnitInfo)this.getOrgUnitInfo();
        }
        BgCslAdjTemplateInfo info = new BgCslAdjTemplateInfo();
        info.setOrgUnit(orgUnit);
        info.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
        info.setNumber((String)row.getCell("number").getValue());
        info.setName((String)row.getCell("name").getValue());
        return info;
    }

    @Override
    protected void btnClose_actionPerformed(ActionEvent e) throws Exception {
        super.btnClose_actionPerformed(e);
        this.actionExitCurrent_actionPerformed(e);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.doubleClick();
            return;
        }
        if (e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            return;
        }
        super.tblMain_tableClicked(e);
    }

    private void doubleClick() {
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex < 0) {
            return;
        }
        if (this.isMultiSelect) {
            ICell cell;
            Boolean value = (Boolean)(cell = this.tblMain.getCell(rowIndex, COL_SELECT)).getValue();
            cell.setValue((Object)(value == false ? 1 : 0));
        } else {
            this.confirm();
        }
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnSelectAll_actionPerformed(e);
        this.selectAll(true);
    }

    @Override
    protected void btnClearAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnClearAll_actionPerformed(e);
        this.selectAll(false);
    }

    private void selectAll(boolean isSelect) {
        for (int r = 0; r < this.tblMain.getRowCount(); ++r) {
            this.tblMain.getCell(r, COL_SELECT).setValue((Object)isSelect);
        }
    }

    protected void f7_afterDataFill(KDTDataRequestEvent e) {
        String queryText = this.txtSearch.getText().trim();
        if (!StringUtils.isEmpty((String)queryText)) {
            boolean isHide = true;
            for (int r = e.getFirstRow(); r <= e.getLastRow(); ++r) {
                isHide = true;
                for (int c = 0; c < this.tblMain.getColumnCount(); ++c) {
                    if (!(this.tblMain.getCell(r, c).getValue() instanceof String) || this.tblMain.getColumn(c).getStyleAttributes().isHided() || StringUtils.cnulls((Object)this.tblMain.getCell(r, c).getValue()).indexOf(queryText) < 0) continue;
                    isHide = false;
                    break;
                }
                if (!isHide) continue;
                this.tblMain.getRow(r).getStyleAttributes().setHided(true);
            }
        }
        if (!this.isMultiSelect) {
            return;
        }
        Map<String, BgCslAdjTemplateInfo> tmpMap = null;
        if (this.getOrgUnitInfo() != null) {
            tmpMap = this.selectedMap.get(this.getOrgUnitInfo().getNumber());
        }
        BgCslAdjTemplateInfo info = null;
        for (int r = e.getFirstRow(); r <= e.getLastRow(); ++r) {
            if (this.tblMain.getRow(r).getStyleAttributes().isHided()) continue;
            info = this.getCurrInfo(r, null);
            this.tblMain.getCell(r, COL_SELECT).setValue((Object)(tmpMap != null && info != null && tmpMap.containsKey(info.getNumber()) && tmpMap.get(info.getNumber()).getId().equals((Object)info.getId()) ? 1 : 0));
        }
    }
}

