/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.bgcsl.BgCslAdjTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BgCslAdjTemplateFactory;
import com.kingdee.eas.ma.bgcsl.BgCslAdjTemplateInfo;
import com.kingdee.eas.ma.bgcsl.IBgCslAdjTemplate;
import com.kingdee.eas.ma.bgcsl.client.AbstractBgCslAdjustTemplateAntiDispatchUI;
import com.kingdee.eas.ma.mbg.BgFacadeFactory;
import com.kingdee.eas.ma.mbg.client.SearchKeyEnum;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDispatchUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgCslAdjustTemplateAntiDispatchUI
extends AbstractBgCslAdjustTemplateAntiDispatchUI {
    private static final Logger logger = CoreUIObject.getLogger(BgCslAdjustTemplateAntiDispatchUI.class);
    private BgCslAdjTemplateCollection temColls = new BgCslAdjTemplateCollection();

    @Override
    protected Object executeAssign() throws EASBizException, BOSException {
        List<String> bgTemplateIds = this.getSelectedTemplateIds();
        List<String> bgOrgUnitIds = this.getSelectedOrgUnitIds();
        return BgCslAdjTemplateFactory.getRemoteInstance().unAssign(this.getBgSchemeId(), bgOrgUnitIds, bgTemplateIds);
    }

    public BgCslAdjTemplateCollection getElimTemColls() {
        return this.temColls;
    }

    @Override
    protected void initDispatchData() throws Exception {
        this.dispatchMap = BgCslAdjTemplateFactory.getRemoteInstance().getDispatchInfo(this.getBgSchemeId());
    }

    @Override
    protected void initBgTemplate() throws Exception {
        this.temTable.checkParsed();
        this.temTable.getSelectManager().setSelectMode(10);
        this.temTable.getColumn("lastupdatetime").getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getNationalDateFormatString());
        this.getElimTemColls().clear();
        BgCslAdjTemplateCollection colls = this.getBgCslAdjTemplateColls(this.getBgSchemeId(), this.getOrgUnitId());
        if (colls != null) {
            int i;
            BgCslAdjTemplateInfo template = null;
            int in = colls.size();
            for (i = 0; i < in; ++i) {
                template = colls.get(i);
                if (!this.selectIds.contains(template.getId().toString())) continue;
                this.getElimTemColls().add(template);
                this.addRowByTemplate(this.temTable, template, true);
            }
            in = colls.size();
            for (i = 0; i < in; ++i) {
                template = colls.get(i);
                if (this.selectIds.contains(template.getId().toString())) continue;
                this.getElimTemColls().add(template);
                this.addRowByTemplate(this.temTable, template, false);
            }
        }
        this.selectIds.clear();
        this.fillDispatchInfo();
    }

    protected void addRowByTemplate(KDTable table, BgCslAdjTemplateInfo template, boolean isChoose) {
        if (table == null || template == null) {
            return;
        }
        IRow row = this.temTable.addRow();
        row.setUserObject((Object)template);
        row.getCell("id").setValue((Object)template.getId());
        row.getCell("select").setValue((Object)isChoose);
        row.getCell("number").setValue((Object)template.getNumber());
        row.getCell("name").setValue((Object)template.getName());
        row.getCell("lastupdateUser").setValue((Object)template.getCreator().getName());
        row.getCell("lastupdatetime").setValue((Object)template.getCreateTime());
    }

    private BgCslAdjTemplateCollection getBgCslAdjTemplateColls(String bgSchemeId, String orgUnitId) throws Exception {
        BgCslAdjTemplateCollection colls = new BgCslAdjTemplateCollection();
        if (StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)orgUnitId)) {
            return colls;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)("Select FBgTemplateId FROM T_MBG_BgCslAdjTempNode Where FOrgUnitId = '" + orgUnitId + "'"), CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("templateStatus", (Object)0, CompareType.EQUALS));
        view.setFilter(filter);
        view.getSelector().addObjectCollection((IObjectCollection)BgSchemeDispatchUtils.getSelectBgTemplate());
        view.getSorter().add(new SorterItemInfo("number"));
        IBgCslAdjTemplate iElimTemp = null;
        iElimTemp = BgCslAdjTemplateFactory.getRemoteInstance();
        BgCslAdjTemplateCollection bgCslAdjTemplateCollection = iElimTemp.getBgCslAdjTemplateCollection(view);
        return bgCslAdjTemplateCollection;
    }

    private void fillDispatchInfo() throws Exception {
        HashSet<String> selectTemplateIds = new HashSet<String>(this.getSelectedTemplateIds());
        if (!this.selectIds.equals(selectTemplateIds)) {
            this.selectIds = selectTemplateIds;
            if (this.treeOrgUnit.getModel() == null) {
                return;
            }
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
            this.fillDispatchInfo(root, selectTemplateIds);
            this.treeOrgUnit.repaint();
        }
    }

    @Override
    protected List<String> getSelectedTemplateIds() {
        ArrayList<String> selBgTemplateIds = new ArrayList<String>();
        Object obj = null;
        IRow row = null;
        BgCslAdjTemplateInfo template = null;
        int in = this.temTable.getRowCount();
        for (int i = 0; i < in; ++i) {
            row = this.temTable.getRow(i);
            template = (BgCslAdjTemplateInfo)row.getUserObject();
            obj = row.getCell("select").getValue();
            if (!(obj instanceof Boolean) || !((Boolean)obj).booleanValue()) continue;
            selBgTemplateIds.add(template.getId().toString());
        }
        return selBgTemplateIds;
    }

    @Override
    protected boolean isOffset() {
        return false;
    }

    @Override
    public void verifyData() throws Exception {
        List<String> bgOrgUnitIds;
        List<String> bgTemplateIds = this.getSelectedTemplateIds();
        if (bgTemplateIds == null || bgTemplateIds.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryResource", (String)"adjtempUnAssign"));
            SysUtil.abort();
        }
        if ((bgOrgUnitIds = this.getSelectedOrgUnitIds()) == null || bgOrgUnitIds.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryResource", (String)("selectBgOrgUnit" + this.getMessageFlag())));
            SysUtil.abort();
        }
    }

    @Override
    protected void restartTemplateColls() {
        List<String> selectIds = this.getSelectedTemplateIds();
        BgCslAdjTemplateCollection colls = this.getElimTemColls();
        this.temTable.removeRows();
        if (colls == null) {
            return;
        }
        BgCslAdjTemplateInfo template = null;
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            template = colls.get(i);
            this.addRowByTemplate(this.temTable, template, selectIds != null && selectIds.contains(template.getId().toString()));
        }
        this.temTable.repaint();
    }

    @Override
    protected void reFillTemplate(String value, SearchKeyEnum keyEnum) {
        if (keyEnum.getValue() == 30) {
            this.filterTemplateColls(this.getElimTemColls(), "number", value, true);
        } else if (keyEnum.getValue() == 20) {
            this.filterTemplateColls(this.getElimTemColls(), "name", value, true);
        }
    }

    private void filterTemplateColls(BgCslAdjTemplateCollection colls, String fields, String value, boolean isBlured) {
        this.temTable.removeRows();
        if (colls == null || fields == null || value == null) {
            return;
        }
        BgCslAdjTemplateInfo template = null;
        Object obj = null;
        String tmpValue = null;
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            template = colls.get(i);
            obj = template.get(fields);
            if (obj == null) continue;
            tmpValue = obj.toString();
            if (isBlured) {
                if (tmpValue.indexOf(value) < 0) continue;
                this.addRowByTemplate(this.temTable, template, false);
                continue;
            }
            if (!tmpValue.equals(value)) continue;
            this.addRowByTemplate(this.temTable, template, false);
        }
        this.temTable.repaint();
    }

    protected Set<String> isHasPermisson4Org(String orgId) throws EASBizException, BOSException {
        FullOrgUnitCollection authorizedOrg = BgFacadeFactory.getRemoteInstance().getAuthorizedOrg((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), OrgType.UnionDebt, (IObjectPK)new ObjectUuidPK(this.getOrgTree().getId()), "csl_adjtemplate01_list");
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i < authorizedOrg.size(); ++i) {
            ids.add(authorizedOrg.get(i).getId().toString());
        }
        return ids;
    }

    @Override
    protected void setNoPermissionNode4Org(DefaultKingdeeTreeNode root) throws EASBizException, BOSException {
        String orgUnitId = null;
        Set<String> ids = this.isHasPermisson4Org(orgUnitId);
        int in = root.getChildCount();
        for (int i = 0; i < in; ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (node.getUserObject() instanceof OrgStructureInfo) {
                OrgStructureInfo oui = (OrgStructureInfo)node.getUserObject();
                if (oui.getUnit() != null) {
                    orgUnitId = oui.getUnit().getId().toString();
                }
            } else {
                if (!(node.getUserObject() instanceof OrgUnitInfo)) continue;
                OrgUnitInfo tmpUnit = (OrgUnitInfo)node.getUserObject();
                orgUnitId = tmpUnit.getId().toString();
            }
            if (ids.contains(orgUnitId)) continue;
            node.setCheckBoxEnabled(false);
            node.setCheckBoxVisible(false);
            node.setChecked(false);
        }
    }
}

