/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.IUserCellDisplayParser;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ITableLocate;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.bgcsl.BgCslAdjTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BgCslAdjTemplateInfo;
import com.kingdee.eas.ma.bgcsl.BgCslException;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateInfo;
import com.kingdee.eas.ma.bgcsl.BgElimContextHelper;
import com.kingdee.eas.ma.bgcsl.BgNWorkTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BgNWorkTemplateInfo;
import com.kingdee.eas.ma.bgcsl.BizRefCslTemplateFactory;
import com.kingdee.eas.ma.bgcsl.IBizRefCslTemplate;
import com.kingdee.eas.ma.bgcsl.client.AbstractBgCslBizCalcListUI;
import com.kingdee.eas.ma.bgcsl.client.BgCslBizCalcGroupEditUI;
import com.kingdee.eas.ma.bgcsl.client.BgCslBizCalcHistListUI;
import com.kingdee.eas.ma.bgcsl.client.BgCslBizCalcMainUI;
import com.kingdee.eas.ma.bgcsl.client.BgCslBizCalcPropertyEditUI;
import com.kingdee.eas.ma.bgcsl.client.IBgElimContextUI;
import com.kingdee.eas.ma.bgcsl.client.utils.BgCslAdjTemplateDialog;
import com.kingdee.eas.ma.bgcsl.client.utils.BgCslBizCalcExportHelper;
import com.kingdee.eas.ma.bgcsl.client.utils.BgCslClientHelper;
import com.kingdee.eas.ma.bgcsl.utils.BgNWorkTemplateHelper;
import com.kingdee.eas.ma.biz.BizCalcFactory;
import com.kingdee.eas.ma.biz.BizCalcInfo;
import com.kingdee.eas.ma.biz.BizRelyFactory;
import com.kingdee.eas.ma.biz.client.utils.BizCalcClientHelper;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import org.apache.log4j.Logger;

public class BgCslBizCalcListUI
extends AbstractBgCslBizCalcListUI
implements IBgElimContextUI {
    private static final long serialVersionUID = -6859578804157530968L;
    private static final Logger logger = CoreUIObject.getLogger(BgCslBizCalcListUI.class);
    protected static final String WORK_TEMPLATE_COL = "workTemplate";
    protected static final String BG_TEMPLATE_ADJ_COL = "bgAdjTemplate";

    public void onLoad() throws Exception {
        if (BgElimContextHelper.isInitialized((CoreUIObject)this, this.getUIContext())) {
            BgElimContextHelper.registUIObject(this);
            super.onLoad();
        } else {
            SysUtil.abort();
        }
    }

    @Override
    protected void combOrgTree_itemStateChanged(ItemEvent e) throws Exception {
        super.combOrgTree_itemStateChanged(e);
        if (e.getStateChange() == 1) {
            return;
        }
        if (this.combOrgTree.getSelectedItem() instanceof OrgTreeInfo) {
            OrgTreeInfo orgTreeInfo = (OrgTreeInfo)this.combOrgTree.getSelectedItem();
            this.prmtBgScheme.setEntityViewInfo(null);
            BgCslClientHelper.setBgSchemeView(this.prmtBgScheme, orgTreeInfo);
        }
        this.initTree();
        this.tblMain.refresh();
    }

    protected void init() throws Exception {
        BgCslClientHelper.initOrgTreeComboBox(this.combOrgTree);
        super.init();
        this.initPrmptBgScheme();
        this.initPrmtTemplate();
        this.initTree();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnExecute.setVisible(false);
        this.btnExeReport.setVisible(false);
        this.btnBGExe.setVisible(false);
        this.btnCancelBGExe.setVisible(false);
        this.menuItemExecute.setVisible(false);
        this.menuItemExeReport.setVisible(false);
        this.menuItemBGExe.setVisible(false);
        this.menuItemCancelBGExe.setVisible(false);
    }

    protected void initPrmptBgScheme() throws Exception {
        BgSchemeInfo bgSchemeInfo = BgElimContextHelper.getBgElimContext().getCurBgScheme();
        if (bgSchemeInfo != null) {
            this.prmtBgScheme.setData((Object)bgSchemeInfo);
        } else {
            this.prmtBgScheme.setDataNoNotify(null);
        }
        OrgTreeInfo orgTreeInfo = null;
        if (this.getOrgTreeInfo() != null) {
            orgTreeInfo = this.getOrgTreeInfo();
        } else if (BgElimContextHelper.getBgElimContext().getCurOrgBound() != null) {
            orgTreeInfo = BgElimContextHelper.getBgElimContext().getCurOrgBound();
        }
        BgCslClientHelper.setBgSchemeView(this.prmtBgScheme, orgTreeInfo);
        if (this.getUIContext().get("ref_form") instanceof BgAccountInfo) {
            BgAccountInfo accInfo = (BgAccountInfo)this.getUIContext().get("ref_form");
            BgSchemeInfo schemeInfo = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo((IObjectPK)new ObjectUuidPK(accInfo.getId()));
            this.prmtBgScheme.setData((Object)schemeInfo);
        }
    }

    protected void initPrmtTemplate() throws BOSException {
        BgCslClientHelper.setWorkTemplateView(this.prmtWorkTemplate, this.getBgSchemeInfo(), this.getOrgTreeInfo());
        BgCslClientHelper.setBgCslTemplateView(this.prmtBgTemplate, this.getBgSchemeInfo(), this.getOrgTreeInfo());
    }

    protected void prmtBgTemplate_willShow(SelectorEvent e) throws Exception {
        if (this.prmtBgScheme.getData() == null) {
            this.prmtBgScheme.requestFocus();
            this.showSchemeNullWarning();
            e.setCanceled(true);
        } else {
            BgCslClientHelper.setBgCslTemplateView(this.prmtBgTemplate, this.getBgSchemeInfo(), this.getOrgTreeInfo());
        }
    }

    @Override
    protected void prmtAdjTemplate_willShow(SelectorEvent e) throws Exception {
        super.prmtAdjTemplate_willShow(e);
        if (this.prmtBgScheme.getData() == null) {
            this.prmtBgScheme.requestFocus();
            this.showSchemeNullWarning();
            e.setCanceled(true);
        } else {
            BgCslAdjTemplateDialog.setF7((CoreUI)this, this.prmtAdjTemplate, this.getOrgTreeInfo(), this.getBgSchemeInfo(), false);
        }
    }

    protected void showSchemeNullWarning() {
        MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)BgNWorkTemplateHelper.RES, (String)"isNullBgScheme"));
    }

    @Override
    protected void prmtWorkTemplate_willShow(SelectorEvent e) throws Exception {
        if (this.prmtBgScheme.getData() == null) {
            this.prmtBgScheme.requestFocus();
            this.showSchemeNullWarning();
            e.setCanceled(true);
        } else {
            BgCslClientHelper.setWorkTemplateView(this.prmtWorkTemplate, this.getBgSchemeInfo(), this.getOrgTreeInfo());
        }
    }

    protected String getBizCalcHistUIName() {
        return BgCslBizCalcHistListUI.class.getName();
    }

    protected void prmtBgTemplate_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgTemplate_dataChanged(e);
        this.tblMain.refresh();
    }

    @Override
    protected void prmtWorkTemplate_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtWorkTemplate_dataChanged(e);
        this.tblMain.refresh();
    }

    @Override
    protected void prmtAdjTemplate_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtAdjTemplate_dataChanged(e);
        this.tblMain.refresh();
    }

    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgScheme_dataChanged(e);
    }

    protected void setBgTemplateView(BgSchemeInfo bgScheme) throws Exception {
        BgCslClientHelper.setBgCslTemplateView(this.prmtBgTemplate, bgScheme, this.getOrgTreeInfo());
        BgCslClientHelper.setWorkTemplateView(this.prmtWorkTemplate, bgScheme, this.getOrgTreeInfo());
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
    }

    protected void fillTemplateList(KDTDataRequestEvent e) {
        if (this.prmtBgScheme.getData() == null) {
            return;
        }
        int firstRow = e.getFirstRow();
        int lastRow = e.getLastRow();
        HashSet<String> idSet = new HashSet<String>();
        for (int i = firstRow; i <= lastRow; ++i) {
            String id = (String)this.tblMain.getRow(i).getCell("id").getValue();
            idSet.add(id);
        }
        if (idSet.size() > 0) {
            Map preBizCalcMap = null;
            Map templateMap = null;
            try {
                preBizCalcMap = BizRelyFactory.getRemoteInstance().getPreCalc(idSet);
                templateMap = BizRefCslTemplateFactory.getRemoteInstance().getRefTemplates(idSet);
            }
            catch (Exception exe) {
                ExceptionHandler.handle((Throwable)exe);
            }
            BgNWorkTemplateCollection workColls = null;
            BgCslTemplateCollection cslColls = null;
            BgCslAdjTemplateCollection cslAdjColls = null;
            for (int i = firstRow; i <= lastRow; ++i) {
                IRow row = this.tblMain.getRow(i);
                String id = (String)row.getCell("id").getValue();
                if (preBizCalcMap != null && preBizCalcMap.containsKey(id)) {
                    List preBizCalc = (List)preBizCalcMap.get(id);
                    row.getCell("preCalc").setValue((Object)preBizCalc);
                }
                if (templateMap == null || !templateMap.containsKey(id)) continue;
                if (templateMap.get(id) instanceof Map && ((Map)templateMap.get(id)).containsKey("WORKTEMPLATE_COLLECTION")) {
                    workColls = (BgNWorkTemplateCollection)((Object)((Map)templateMap.get(id)).get("WORKTEMPLATE_COLLECTION"));
                    row.getCell(WORK_TEMPLATE_COL).setValue((Object)workColls.toArray());
                }
                if (templateMap.get(id) instanceof Map && ((Map)templateMap.get(id)).containsKey("bgtemplate")) {
                    cslColls = (BgCslTemplateCollection)((Object)((Map)templateMap.get(id)).get("bgtemplate"));
                    row.getCell("bgTemplate").setValue((Object)cslColls.toArray());
                }
                if (!(templateMap.get(id) instanceof Map) || !((Map)templateMap.get(id)).containsKey("bgcsladjtemplate")) continue;
                cslAdjColls = (BgCslAdjTemplateCollection)((Object)((Map)templateMap.get(id)).get("bgcsladjtemplate"));
                row.getCell(BG_TEMPLATE_ADJ_COL).setValue((Object)cslAdjColls.toArray());
            }
        }
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.tblMain.setUserCellDisplayParser(new IUserCellDisplayParser(){

            public Object parse(int rowIndex, int colIndex, ICell cell, Object value) {
                if (colIndex == BgCslBizCalcListUI.this.tblMain.getColumnIndex(BgCslBizCalcListUI.WORK_TEMPLATE_COL) || colIndex == BgCslBizCalcListUI.this.tblMain.getColumnIndex("bgTemplate") || colIndex == BgCslBizCalcListUI.this.tblMain.getColumnIndex(BgCslBizCalcListUI.BG_TEMPLATE_ADJ_COL)) {
                    return BgCslBizCalcListUI.this.formatTemplateColumn(value, cell);
                }
                return value;
            }
        });
    }

    protected String formatTemplateColumn(Object value, ICell cell) {
        String str = null;
        if (value != null && value instanceof Object[]) {
            StringBuffer display = new StringBuffer();
            Object[] colls = (Object[])value;
            VirtualSheetParamInfo info = null;
            for (int i = 0; i < colls.length; ++i) {
                if (colls[i] == null || !(colls[i] instanceof VirtualSheetParamInfo)) continue;
                info = (VirtualSheetParamInfo)colls[i];
                display.append(info.getName());
                if (i == colls.length - 1) continue;
                display.append(",");
            }
            str = display.toString();
        }
        return str;
    }

    protected void prmtBgScheme_willShow(SelectorEvent e) throws Exception {
        BgCslClientHelper.setBgSchemeView(this.prmtBgScheme, this.getOrgTreeInfo());
    }

    protected void processQueryExecutor(EntityViewInfo viewInfo) {
        if (viewInfo.getFilter() == null) {
            viewInfo.setFilter(new FilterInfo());
        }
        FilterInfo filter = viewInfo.getFilter();
        this.processBgSchemeFilter(filter);
        this.processTemplateFilter(filter);
        this.processOrgTreeFilter(filter);
        logger.error((Object)("BgCslBizCalcListUI Query Filter is :" + filter.toString()));
    }

    protected void processBgSchemeFilter(FilterInfo filter) {
        BgSchemeInfo bgScheme = (BgSchemeInfo)this.prmtBgScheme.getData();
        FilterItemInfo filterItem = new FilterItemInfo("bgScheme.id", (Object)(bgScheme == null ? "" : bgScheme.getId().toString()), CompareType.EQUALS);
        if (BgNFCHelper.findFilterItem((FilterInfo)filter, (String)"bgScheme.id") != null) {
            BgNFCHelper.removeFilterItems((FilterInfo)filter, (FilterItemInfo)filterItem);
            filter.getFilterItems().add(filterItem);
        } else {
            filter.getFilterItems().add(filterItem);
            if (filter.getMaskString() == null) {
                filter.setMaskString("#" + (filter.getFilterItems().size() - 1));
            } else {
                filter.setMaskString("(" + filter.getMaskString() + ") AND #" + (filter.getFilterItems().size() - 1));
            }
        }
    }

    protected void processTemplateFilter(FilterInfo filter) {
        BgNWorkTemplateInfo workTemplate = (BgNWorkTemplateInfo)this.prmtWorkTemplate.getData();
        BgCslTemplateInfo cslTemplate = (BgCslTemplateInfo)this.prmtBgTemplate.getData();
        BgCslAdjTemplateInfo cslAdjTemplate = (BgCslAdjTemplateInfo)this.prmtAdjTemplate.getData();
        StringBuffer oql = new StringBuffer();
        this.addOql(oql, (CoreBaseInfo)workTemplate);
        this.addOql(oql, (CoreBaseInfo)cslTemplate);
        this.addOql(oql, (CoreBaseInfo)cslAdjTemplate);
        if (oql.length() > 0) {
            oql.append(")");
            FilterItemInfo tempFilterItem = new FilterItemInfo("id", (Object)oql.toString(), CompareType.INNER);
            if (BgNFCHelper.findFilterItem((FilterInfo)filter, (String)"id") != null) {
                BgNFCHelper.removeFilterItems((FilterInfo)filter, (FilterItemInfo)tempFilterItem);
                filter.getFilterItems().add(tempFilterItem);
            } else {
                filter.getFilterItems().add(tempFilterItem);
                filter.setMaskString(filter.getMaskString() + " AND #" + (filter.getFilterItems().size() - 1));
            }
        } else if (BgNFCHelper.findFilterItem((FilterInfo)filter, (String)"id") != null) {
            FilterItemInfo tempFilterItem = new FilterItemInfo("id", null, CompareType.INNER);
            BgNFCHelper.removeFilterItems((FilterInfo)filter, (FilterItemInfo)tempFilterItem);
            filter.setMaskString(filter.getMaskString().substring(0, filter.getMaskString().lastIndexOf("AND")));
        }
    }

    private void addOql(StringBuffer oql, CoreBaseInfo info) {
        if (info == null) {
            return;
        }
        if (oql.length() == 0) {
            oql.append("select FBizCalcID from T_MBG_BizRefCslTemplate where FTemplateID in (");
            oql.append("'").append(info.getId()).append("'");
        } else {
            oql.append(", '").append(info.getId()).append("'");
        }
    }

    protected void processOrgTreeFilter(FilterInfo filter) {
        FilterItemInfo filterItem = new FilterItemInfo("orgTree.id", this.getOrgTreeInfo() != null ? this.getOrgTreeInfo().getId() : "000000000000000000000000000=", CompareType.EQUALS);
        if (BgNFCHelper.findFilterItem((FilterInfo)filter, (String)"orgTree.id") != null) {
            BgNFCHelper.removeFilterItems((FilterInfo)filter, (FilterItemInfo)filterItem);
            filter.getFilterItems().add(filterItem);
        } else {
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("(" + filter.getMaskString() + ") AND #" + (filter.getFilterItems().size() - 1));
        }
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"ORGTREE_INFO", (Object)this.getOrgTreeInfo());
        uiContext.put((Object)BgBaseConstants.BGTEMPLATE_INFO, this.prmtBgTemplate.getData());
        uiContext.put((Object)"WORKTEMPLATE_INFO", this.prmtWorkTemplate.getData());
    }

    protected OrgTreeInfo getOrgTreeInfo() {
        return this.combOrgTree.getSelectedItem() instanceof OrgTreeInfo ? (OrgTreeInfo)this.combOrgTree.getSelectedItem() : null;
    }

    protected BgSchemeInfo getBgSchemeInfo() {
        return this.prmtBgScheme.getData() instanceof BgSchemeInfo ? (BgSchemeInfo)this.prmtBgScheme.getData() : null;
    }

    protected String getEditUIName() {
        return BgCslBizCalcPropertyEditUI.class.getName();
    }

    protected String getBizCalcMainUI() {
        return BgCslBizCalcMainUI.class.getName();
    }

    @Override
    public void update(Observable o, Object arg) {
        BgElimContextHelper.update(o, (CoreUI)this);
    }

    protected IObjectPK getOrgPK() {
        try {
            if (BgElimContextHelper.getBgElimContext().getCurOrgGroup() != null) {
                return new ObjectUuidPK(BgElimContextHelper.getBgElimContext().getCurOrgGroup().getId());
            }
        }
        catch (BOSException e) {
            logger.error((Object)"error", (Throwable)e);
            this.handUIException(e);
        }
        return super.getOrgPK();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        try {
            ObjectUuidPK orgPK = null;
            if (this.getOrgTreeInfo() != null) {
                if (BgElimContextHelper.getBgElimContext().getCurOrgBound() != null && BgElimContextHelper.getBgElimContext().getCurOrgBound().getId().equals((Object)this.getOrgTreeInfo().getId()) && BgElimContextHelper.getBgElimContext().getCurOrgGroup() != null && (orgPK = new ObjectUuidPK(BgElimContextHelper.getBgElimContext().getCurOrgGroup().getId())) != null) {
                    return orgPK;
                }
                try {
                    orgPK = BgCslClientHelper.getOrgPk(this.getOrgTreeInfo().getId().toString(), this.getMetaDataPK(), action);
                }
                catch (EASBizException e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
            if (orgPK == null && BgElimContextHelper.getBgElimContext().getCurOrgGroup() != null) {
                orgPK = new ObjectUuidPK(BgElimContextHelper.getBgElimContext().getCurOrgGroup().getId());
            }
            if (orgPK != null) {
                return orgPK;
            }
        }
        catch (BOSException e) {
            logger.error((Object)"error", (Throwable)e);
            this.handUIException(e);
        }
        return super.getOrgPK(action);
    }

    protected String getListPermissionItem() {
        return "csl_BizCalc01_list";
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isBgSchemeIsFiling();
        this.checkSelected();
        int selectIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        String bgSchemeId = ((BgSchemeInfo)this.prmtBgScheme.getData()).getId().toString();
        HashSet bizCalcIds = new HashSet();
        bizCalcIds.addAll(this.getSelectedIdValues());
        IBizRefCslTemplate iBizRefCslTemplate = BizRefCslTemplateFactory.getRemoteInstance();
        Map result = iBizRefCslTemplate.cancelCancelColls(bizCalcIds, bgSchemeId, this.getOrgTreeInfo() != null ? this.getOrgTreeInfo().getId().toString() : null);
        this.refreshList();
        this.tblMain.getSelectManager().select(selectIndex, 0);
        BizCalcClientHelper.dealWithErrorMsg((Component)((Object)this), (Map)result, (boolean)false, (boolean)false);
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        UIContext ctx = new UIContext((Object)this);
        OrgUnitInfo orgUnit = this.prmtOrgUnit.getData() != null ? (OrgUnitInfo)this.prmtOrgUnit.getData() : SysContext.getSysContext().getCurrentOrgUnit();
        ctx.put((Object)"ORGUNIT_ID", (Object)orgUnit.getId().toString());
        if (this.getOrgTreeInfo() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)BgNWorkTemplateHelper.RES, (String)"isNullOrgTree"));
            return;
        }
        ctx.put((Object)"ORGTREE_ID", (Object)this.getOrgTreeInfo().getId().toString());
        this.isBgSchemeIsFiling();
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.prmtBgScheme.getData();
        ctx.put((Object)"BGSCHEME_ID", (Object)bgSchemeInfo.getId().toString());
        ctx.put((Object)"BIZCALCGROUP", this.getSelectTreeObj());
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.ma.bgcsl.client.BgCslBizCalcImportUI", (Map)ctx, null, OprtState.VIEW);
        window.show();
        this.refresh(e);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.isBgSchemeIsFiling();
        UIContext uicontext = new UIContext((Object)this);
        uicontext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uicontext.put((Object)BgBaseConstants.ORGUNIT_INFO, this.prmtOrgUnit.getData());
        uicontext.put((Object)BgBaseConstants.BGSCHEME_INFO, this.prmtBgScheme.getData());
        uicontext.put((Object)BgBaseConstants.USER_INFO, (Object)SysContext.getSysContext().getCurrentUserInfo());
        uicontext.put((Object)"currBizCalcID", (Object)this.getSelectedKeyValue().toString());
        uicontext.put((Object)"prebizcalc", this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex()).getCell("preCalc").getValue());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("state");
        BizCalcInfo bizCalc = (BizCalcInfo)BizCalcFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()), selector);
        uicontext.put((Object)"bizState", (Object)bizCalc.getState());
        uicontext.put((Object)"ORGTREE_INFO", (Object)this.getOrgTreeInfo());
        IUIWindow copyUI = UIFactory.createUIFactory().create(this.getEditUIName(), (Map)uicontext, null, OprtState.COPYADDNEW);
        copyUI.show();
        ITableLocate locate = this.getTableLocate();
        this.tblMain.refresh();
        if (locate != null) {
            locate.locate();
        }
    }

    protected void exportBizCalc(List<String> selectIds, File file) throws Exception {
        BgCslBizCalcExportHelper.exportBizCalc(selectIds, file);
    }

    protected BOSUuid getUnionId() {
        return ((OrgTreeInfo)this.combOrgTree.getSelectedItem()).getId();
    }

    protected int getCalcType() {
        return 64;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelectedOrgTree();
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelectedOrgTree();
        super.actionView_actionPerformed(e);
    }

    protected void checkSelectedOrgTree() {
        BgSchemeInfo scheme = this.getBgSchemeInfo();
        if (scheme == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslTemplateResource", (String)"selectBgScheme"));
            SysUtil.abort();
        }
        BgCslClientHelper.checkHasCslScheme((CoreUI)this, scheme.getId().toString(), this.getUnionId().toString());
    }

    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
    }

    protected void checkFilling(BgSchemeInfo scheme) throws BOSException, EASBizException {
        if (scheme != null && scheme.isIsFiling()) {
            throw new BgCslException(BgCslException.CSLSCHEMEFILLED);
        }
    }

    protected void putUIContext(UIContext ctx) {
        ctx.put((Object)"IS_BGCSL", (Object)true);
        ctx.put((Object)"ORGTREE_INFO", (Object)this.getOrgTreeInfo());
    }

    protected void prepareGroupUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareGroupUIContext(uiContext, e);
        uiContext.put((Object)"ORGTREE_INFO", (Object)this.getOrgTreeInfo());
    }

    protected String getGroupEditUIName() {
        return BgCslBizCalcGroupEditUI.class.getName();
    }

    protected Boolean isCsl() {
        return true;
    }
}

