/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client;

import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.base.log.client.ExcelFileFilter;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.client.NumberExpandInfo;
import com.kingdee.eas.ma.base.client.NumberExpendRender;
import com.kingdee.eas.ma.base.client.utils.BgFileUtil;
import com.kingdee.eas.ma.bgcsl.BgCslFormCourseFacadeFactory;
import com.kingdee.eas.ma.bgcsl.IBgCslFormCourseFacade;
import com.kingdee.eas.ma.bgcsl.client.AbstractBgCslCoursePlanUI;
import com.kingdee.eas.ma.bgcsl.client.BgCslFormCourseListUI;
import com.kingdee.eas.ma.bgcsl.utils.BgCslFormCourseHelper;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class BgCslCoursePlanUI
extends AbstractBgCslCoursePlanUI {
    private static final long serialVersionUID = -5488670200834020978L;
    private static final Logger logger = CoreUIObject.getLogger(BgCslCoursePlanUI.class);
    private NumberExpendRender render = new NumberExpendRender(0);
    private boolean hasQueryType = true;
    private int sel_orgunit_type = 0;
    private int columns_count = 0;
    private BgCslFormCourseListUI ui = null;
    private OrgUnitInfo unitInfo = null;
    private String orgTreeId = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.ui = (BgCslFormCourseListUI)this.getUIContext().get("Owner");
        this.sel_orgunit_type = (Integer)this.getUIContext().get("SEL_ORGUNIT_TYPE");
        this.unitInfo = (OrgUnitInfo)this.getUIContext().get("SEL_ORGUNIT_INFO");
        this.orgTreeId = (String)this.getUIContext().get("CURR_ORGTREE_ID");
        this.viewOrgUnit();
        this.tHelper.getDisabledTables().add(this.tblMain);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.initShow();
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    BgCslCoursePlanUI.this.tblMain_tableClicked(e);
                }
                catch (Exception ex) {
                    BgCslCoursePlanUI.this.handUIException(ex);
                }
            }
        });
    }

    protected IBgCslFormCourseFacade getInterface() throws Exception {
        return BgCslFormCourseFacadeFactory.getRemoteInstance();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuTool.setEnabled(false);
        this.menuTool.setVisible(false);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        JMenuItem jmi = this.btnPrint.addAssistMenuItem((Action)((Object)this.actionPrintPreview));
        jmi.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
    }

    protected void initShow() {
        IUIWindow window = this.getUIWindow();
        if (window instanceof KDFrame) {
            ((KDFrame)window).setExtendedState(6);
        } else if (window instanceof Dialog) {
            ((Dialog)window).setSize(Toolkit.getDefaultToolkit().getScreenSize());
        }
    }

    protected KDTable getTableForCommon() {
        return this.tblMain;
    }

    protected boolean isCanCopyPaste() {
        return false;
    }

    @Override
    public void actionViewPlan_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewPlan_actionPerformed(e);
        if (this.hasQueryType) {
            this.viewOrgUnit();
        } else {
            this.viewTemplate();
        }
        this.setTotalCount(this.tblMain.getRowCount());
    }

    protected void viewOrgUnit() throws Exception {
        this.hasQueryType = false;
        this.initOrgHead();
        this.initOrgExpendInfo();
        this.fillOrgData();
    }

    protected void setTotalCount(int rowCount) {
        String msg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ShowListDataCount_0");
        Object[] objs = new Object[]{rowCount};
        this.setMessageBarText(MessageFormat.format(msg, objs));
    }

    protected void viewTemplate() throws Exception {
        this.hasQueryType = true;
        this.initTemplateHead();
        this.fillTemplateData();
    }

    protected void initHead() throws Exception {
        IRow row = null;
        this.tblMain.removeRows();
        this.tblMain.removeColumns();
        this.tblMain.removeHeadRows();
        this.columns_count = 16;
        this.tblMain.addColumns(this.columns_count);
        row = this.tblMain.addHeadRow();
        row.getCell(2).setValue((Object)BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormCourseResource", (String)"title_bgPeriod"));
        row.getCell(3).setValue((Object)BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormCourseResource", (String)"title_currency"));
        this.tblMain.getColumn(3).getStyleAttributes().setHided(true);
        row.getCell(4).setValue((Object)BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormCourseResource", (String)"title_version"));
        row.getCell(5).setValue((Object)BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormCourseResource", (String)"title_count"));
        row.getCell(6).setValue((Object)BgFormStateEnum.CANTEDIT.getAlias());
        row.getCell(8).setValue((Object)BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormCourseResource", (String)"unAudit"));
        row.getCell(10).setValue((Object)BgFormStateEnum.Approved.getAlias());
        row.getCell(12).setValue((Object)BgFormStateEnum.UnionReport.getAlias());
        row.getCell(14).setValue((Object)BgFormStateEnum.UnionReceive.getAlias());
        row = this.tblMain.addHeadRow();
        for (int i = 6; i < this.columns_count; ++i) {
            row.getCell(i).setValue((Object)BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormCourseResource", (String)"title_amount"));
            row.getCell(++i).setValue((Object)BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormCourseResource", (String)"title_rate"));
        }
        this.tblMain.getHeadMergeManager().mergeBlock(0, 0, 1, 0);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 1, 1, 1);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 2, 1, 2);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 3, 1, 3);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 4, 1, 4);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 5, 1, 5);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 6, 0, 7);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 8, 0, 9);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 9, 0, 10);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 10, 0, 11);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 12, 0, 13);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 14, 0, 15);
        this.tblMain.getColumn(0).setRenderer((IBasicRender)this.render);
        this.tblMain.getColumn(0).setWidth(250);
        this.tblMain.getColumn(1).setWidth(250);
        this.tblMain.getColumn(5).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(6).setUserObject((Object)BgFormStateEnum.CANTEDIT);
        this.tblMain.getColumn(6).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(7).getStyleAttributes().setNumberFormat("0.00%");
        this.tblMain.getColumn(7).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(8).setUserObject((Object)BgFormStateEnum.Edited);
        this.tblMain.getColumn(8).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(9).getStyleAttributes().setNumberFormat("0.00%");
        this.tblMain.getColumn(9).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(10).setUserObject((Object)BgFormStateEnum.Approved);
        this.tblMain.getColumn(10).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(11).getStyleAttributes().setNumberFormat("0.00%");
        this.tblMain.getColumn(11).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(12).setUserObject((Object)BgFormStateEnum.UnionReport);
        this.tblMain.getColumn(12).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(13).getStyleAttributes().setNumberFormat("0.00%");
        this.tblMain.getColumn(13).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(14).setUserObject((Object)BgFormStateEnum.UnionReceive);
        this.tblMain.getColumn(14).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(15).getStyleAttributes().setNumberFormat("0.00%");
        this.tblMain.getColumn(15).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.checkParsed(true);
    }

    protected void initOrgHead() throws Exception {
        this.initHead();
        this.tblMain.getHeadRow(0).getCell(0).setValue((Object)BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormCourseResource", (String)"title_orgUnit"));
        this.tblMain.getColumn(1).getStyleAttributes().setHided(true);
    }

    protected void initTemplateHead() throws Exception {
        this.initHead();
        this.tblMain.getHeadRow(0).getCell(0).setValue((Object)BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormCourseResource", (String)"title_cslTemplate"));
        this.tblMain.getHeadRow(0).getCell(1).setValue((Object)BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormCourseResource", (String)"title_bgTemplate"));
    }

    protected void initOrgExpendInfo() throws Exception {
        if (this.unitInfo == null) {
            return;
        }
        BgPeriodInfo[] bgPeriods = this.getBgPeriodArr();
        BgVersionInfo[] bgVersions = this.getBgVersionArr();
        if (bgPeriods == null || bgVersions == null) {
            return;
        }
        IRow row = null;
        boolean isOrgGroup = BgCslFormCourseHelper.isOrgGroup(null, this.unitInfo.getId().toString());
        BgPeriodInfo bgPeriodInfo = null;
        BgVersionInfo bgVersionInfo = null;
        for (int p = 0; p < bgPeriods.length; ++p) {
            bgPeriodInfo = bgPeriods[p];
            for (int v = 0; v < bgVersions.length; ++v) {
                bgVersionInfo = bgVersions[v];
                if (!isOrgGroup) {
                    row = this.tblMain.addRow();
                    NumberExpandInfo _expend = new NumberExpandInfo();
                    _expend.setId(this.unitInfo.getId().toString());
                    _expend.setName(this.unitInfo.getName());
                    _expend.setNumber(this.unitInfo.getNumber());
                    _expend.setLongNumber(this.unitInfo.getLongNumber());
                    _expend.setLevel(this.unitInfo.getLevel());
                    _expend.setLeaf(true);
                    row.getCell(0).setValue((Object)_expend);
                    row.getCell(2).setUserObject((Object)bgPeriodInfo);
                    row.getCell(4).setUserObject((Object)bgVersionInfo);
                    continue;
                }
                if (this.sel_orgunit_type == 2 || isOrgGroup && this.sel_orgunit_type == 1) {
                    this.createTreeModel(this.unitInfo.getLongNumber(), bgPeriodInfo, bgVersionInfo);
                    continue;
                }
                this.createTreeModel(bgPeriodInfo, bgVersionInfo);
            }
        }
    }

    protected TreeModel getTreeModel() throws Exception {
        return this.ui.orgTree.getModel();
    }

    protected void createTreeModel(String longnumber, BgPeriodInfo bgPeriodInfo, BgVersionInfo bgVersionInfo) throws Exception {
        if (longnumber == null) {
            return;
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.getTreeModel().getRoot();
        if (root.getUserObject() instanceof OrgStructureInfo) {
            OrgStructureInfo osi = (OrgStructureInfo)root.getUserObject();
            this.createTreeModel(longnumber, this.unitInfo, null, bgPeriodInfo, bgVersionInfo);
        }
    }

    protected void createTreeModel(String longnumber, OrgUnitInfo unitInfo, NumberExpandInfo expend, BgPeriodInfo bgPeriodInfo, BgVersionInfo bgVersionInfo) throws Exception {
        if (unitInfo == null) {
            return;
        }
        IRow row = null;
        NumberExpandInfo _expend = null;
        if (expend == null) {
            expend = new NumberExpandInfo();
        }
        if (unitInfo != null) {
            if (unitInfo.getLongNumber().startsWith(longnumber + "!") || unitInfo.getLongNumber().equals(longnumber)) {
                int _length2;
                int _length1 = unitInfo.getLongNumber().split("!").length;
                if (_length1 - (_length2 = longnumber.split("!").length) <= 1) {
                    _expend = new NumberExpandInfo();
                    _expend.setId(unitInfo.getId().toString());
                    _expend.setName(unitInfo.getName());
                    _expend.setNumber(unitInfo.getNumber());
                    _expend.setLongNumber(unitInfo.getLongNumber());
                    _expend.setLevel(expend.getLevel() + 1);
                    if (!longnumber.equals(unitInfo.getLongNumber())) {
                        _expend.setLeaf(true);
                    }
                    _expend.setExpandStatus(true);
                    row = this.tblMain.addRow();
                    row.getCell(0).setValue((Object)_expend);
                    row.getCell(2).setUserObject((Object)bgPeriodInfo);
                    row.getCell(4).setUserObject((Object)bgVersionInfo);
                }
            } else if (!longnumber.startsWith(unitInfo.getLongNumber() + "!")) {
                return;
            }
        }
        IOrgStructure iOrgStructure = OrgStructureFactory.getRemoteInstance();
        OrgStructureCollection orgUnitColl = null;
        if (unitInfo.getId() != null) {
            OrgStructureInfo osi = iOrgStructure.getOrgStructureInfo("select id, unit.number, unit.name, unit.longNumber, unit.id, unit.isGrouping, tree.id where unit.id = '" + unitInfo.getId() + "' and tree.id = '" + this.orgTreeId + "'");
            orgUnitColl = iOrgStructure.getOrgStructureCollection("select id,longNumber, level, isLeaf,  unit.id, unit.name, unit.number, unit.isGrouping where parent.id = '" + osi.getId().toString() + "' order by longNumber ");
        }
        if (orgUnitColl != null) {
            FullOrgUnitInfo _unitInfo = null;
            int in = orgUnitColl.size();
            for (int i = 0; i < in; ++i) {
                _unitInfo = orgUnitColl.get(i).getUnit();
                _unitInfo.setLongNumber(orgUnitColl.get(i).getLongNumber());
                if (_unitInfo.getId().equals((Object)unitInfo.getId())) continue;
                this.createTreeModel(longnumber, (OrgUnitInfo)_unitInfo, _expend, bgPeriodInfo, bgVersionInfo);
            }
        }
    }

    protected void createTreeModel(BgPeriodInfo bgPeriodInfo, BgVersionInfo bgVersionInfo) throws Exception {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.ui.orgTree.getLastSelectedPathComponent();
        this.createTreeModel(root, null, bgPeriodInfo, bgVersionInfo);
    }

    protected void createTreeModel(DefaultKingdeeTreeNode node, NumberExpandInfo expend, BgPeriodInfo bgPeriodInfo, BgVersionInfo bgVersionInfo) {
        if (node == null) {
            return;
        }
        IRow row = null;
        DefaultKingdeeTreeNode _node = null;
        NumberExpandInfo _expend = null;
        OrgStructureInfo osi = (OrgStructureInfo)node.getUserObject();
        FullOrgUnitInfo unitInfo = osi.getUnit();
        if (expend == null) {
            expend = new NumberExpandInfo();
        }
        if (unitInfo != null) {
            unitInfo.setLongNumber(osi.getLongNumber());
            _expend = new NumberExpandInfo();
            _expend.setId(unitInfo.getId().toString());
            _expend.setName(unitInfo.getName());
            _expend.setNumber(unitInfo.getNumber());
            _expend.setLongNumber(unitInfo.getLongNumber());
            _expend.setLevel(expend.getLevel() + 1);
            if (node.getChildCount() <= 0) {
                _expend.setLeaf(true);
            }
            _expend.setExpandStatus(true);
            row = this.tblMain.addRow();
            row.getCell(0).setValue((Object)_expend);
            row.getCell(2).setUserObject((Object)bgPeriodInfo);
            row.getCell(4).setUserObject((Object)bgVersionInfo);
        }
        int in = node.getChildCount();
        for (int i = 0; i < in; ++i) {
            _node = (DefaultKingdeeTreeNode)node.getChildAt(i);
            this.createTreeModel(_node, _expend, bgPeriodInfo, bgVersionInfo);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 1) {
            NumberExpandInfo _expend;
            Object _obj;
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            if (colIndex == 0 && (_obj = this.tblMain.getCell(rowIndex, colIndex).getValue()) != null && _obj instanceof NumberExpandInfo && this.render.inRect(_expend = (NumberExpandInfo)_obj, e.getX(), e.getY())) {
                this.expendStyle(rowIndex, colIndex, _expend);
            }
        }
    }

    protected void expendStyle(int rowIndex, int colIndex, NumberExpandInfo expend) {
        IRow _row = null;
        String _longNumber = null;
        NumberExpandInfo _expand = null;
        String longnumber = expend.getLongNumber();
        boolean isExpandStatus = expend.isExpandStatus();
        int _rowCount = this.tblMain.getRowCount();
        expend.setExpandStatus(!isExpandStatus);
        for (int _rowIndex = rowIndex + 1; _rowIndex < _rowCount && (_longNumber = (_expand = (NumberExpandInfo)(_row = this.tblMain.getRow(_rowIndex)).getCell(0).getValue()).getLongNumber()).startsWith(longnumber + "!"); ++_rowIndex) {
            _row.getStyleAttributes().setHided(isExpandStatus);
            _expand.setExpandStatus(true);
        }
    }

    private BgPeriodInfo[] getBgPeriodArr() {
        BgPeriodInfo[] periodArr = null;
        Object _obj = this.ui.getBgPeriodInfo();
        if (_obj != null) {
            Object[] _objs;
            if (_obj instanceof BgPeriodInfo) {
                periodArr = new BgPeriodInfo[]{(BgPeriodInfo)_obj};
            } else if (_obj instanceof Object[] && (_objs = (Object[])_obj).length > 0) {
                periodArr = new BgPeriodInfo[_objs.length];
                periodArr = (BgPeriodInfo[])_objs;
            }
        }
        return periodArr;
    }

    private BgVersionInfo[] getBgVersionArr() {
        int i;
        ArrayList<BgVersionInfo> bgVersions = new ArrayList<BgVersionInfo>();
        Object _obj = this.ui.getBgVersionInfo();
        if (_obj != null) {
            Object[] _objs;
            if (_obj instanceof BgVersionInfo) {
                bgVersions.add((BgVersionInfo)_obj);
            } else if (_obj instanceof Object[] && (_objs = (Object[])_obj).length > 0) {
                for (i = 0; i < _objs.length; ++i) {
                    if (bgVersions.contains(_objs[i])) continue;
                    bgVersions.add((BgVersionInfo)_objs[i]);
                }
            }
        }
        Collections.sort(bgVersions, new Comparator<BgVersionInfo>(){

            @Override
            public int compare(BgVersionInfo o1, BgVersionInfo o2) {
                return o1.getNumber().compareTo(o2.getNumber());
            }
        });
        BgVersionInfo[] bgVersionArr = null;
        if (!bgVersions.isEmpty()) {
            bgVersionArr = new BgVersionInfo[bgVersions.size()];
            for (i = 0; i < bgVersions.size(); ++i) {
                bgVersionArr[i] = (BgVersionInfo)bgVersions.get(i);
            }
        }
        return bgVersionArr;
    }

    protected void fillOrgData() throws Exception {
        Object[] _objs;
        this.btnViewPlan.setText(BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormCourseResource", (String)"btnViewTemplate"));
        IRow row = null;
        NumberExpandInfo expend = null;
        BgFormStateEnum state = null;
        BgSchemeInfo _bgSchemeInfo = null;
        CurrencyInfo _currencyInfo = null;
        boolean _state = false;
        Object _obj = null;
        Integer _key = null;
        BigDecimal _value = null;
        BigDecimal _count = null;
        BigDecimal _sum = null;
        Object _cant = null;
        BigDecimal _tmpValue = null;
        BigDecimal _usedTemplateSum = null;
        BigDecimal _formSum = null;
        BigDecimal _allForm = null;
        Map _tmpMap = null;
        Object _entry = null;
        _obj = this.ui.getBgSchemeInfo();
        if (_obj != null) {
            if (_obj instanceof BgSchemeInfo) {
                _bgSchemeInfo = _obj;
            } else if (_obj instanceof Object[] && (_objs = (Object[])_obj).length > 0 && _objs[0] != null) {
                _bgSchemeInfo = (BgSchemeInfo)_objs[0];
            }
        }
        if ((_obj = this.ui.getCurrencyInfo()) != null) {
            if (_obj instanceof CurrencyInfo) {
                _currencyInfo = (CurrencyInfo)_obj;
            } else if (_obj instanceof Object[] && (_objs = (Object[])_obj).length > 0 && _objs[0] != null) {
                _currencyInfo = (CurrencyInfo)_objs[0];
            }
        }
        BgPeriodInfo[] bgPeriods = this.getBgPeriodArr();
        BgVersionInfo[] bgVersions = this.getBgVersionArr();
        if (bgPeriods == null || bgVersions == null) {
            return;
        }
        Map _dataMap = this.getInterface().queryOrgInfo(this.ui.getQueryCourseMap());
        BgPeriodInfo bgPeriodInfo = null;
        BgVersionInfo bgVersionInfo = null;
        int in = this.tblMain.getRowCount();
        for (int i = 0; i < in; ++i) {
            int j;
            int jn;
            row = this.tblMain.getRow(i);
            bgPeriodInfo = (BgPeriodInfo)(row.getCell(2).getUserObject() instanceof BgPeriodInfo ? row.getCell(2).getUserObject() : this.getBgPeriodArr()[0]);
            bgVersionInfo = (BgVersionInfo)(row.getCell(4).getUserObject() instanceof BgVersionInfo ? row.getCell(4).getUserObject() : this.getBgVersionArr()[0]);
            row.getCell(1).setValue((Object)_bgSchemeInfo);
            row.getCell(2).setValue((Object)BgCslFormCourseHelper.getRrefixPeriodName(bgPeriodInfo));
            row.getCell(3).setValue((Object)_currencyInfo);
            row.getCell(4).setValue((Object)bgVersionInfo);
            expend = (NumberExpandInfo)row.getCell(0).getValue();
            String orgUnitId = expend.getId();
            String bgPeriodId = bgPeriodInfo.getId().toString();
            String bgVersionId = bgVersionInfo.getId().toString();
            String org_period_version = orgUnitId + ";" + bgPeriodId + ";" + bgVersionId;
            if (_dataMap.containsKey(expend.getId())) {
                _key = new Integer(100);
                _tmpMap = (Map)_dataMap.get(expend.getId());
                _count = _tmpMap.containsKey(_key) ? (BigDecimal)_tmpMap.get(_key) : BgNConstants.ZERO;
                if (_dataMap.containsKey(org_period_version)) {
                    _tmpMap = (Map)_dataMap.get(org_period_version);
                }
                _usedTemplateSum = _tmpMap.containsKey(_key = new Integer(10000)) ? new BigDecimal(((Set)_tmpMap.get(_key)).size()) : BgNConstants.ZERO;
                _key = new Integer(10001);
                _formSum = _tmpMap.containsKey(_key) ? (BigDecimal)_tmpMap.get(_key) : BgNConstants.ZERO;
                _allForm = _count.subtract(_usedTemplateSum).add(_formSum);
                row.getCell(5).setValue((Object)_allForm);
                jn = this.tblMain.getColumnCount();
                for (j = 8; j < jn; j += 2) {
                    state = (BgFormStateEnum)this.tblMain.getColumn(j).getUserObject();
                    if (_dataMap.containsKey(org_period_version)) {
                        _tmpMap = (Map)_dataMap.get(org_period_version);
                    }
                    _key = new Integer(state.getValue());
                    _value = BgNConstants.ZERO;
                    if (_tmpMap.containsKey(_key)) {
                        _value = (BigDecimal)_tmpMap.get(_key);
                    }
                    if (state.getValue() == 1) {
                        _key = new Integer(14);
                        if (_tmpMap.containsKey(_key)) {
                            _tmpValue = (BigDecimal)_tmpMap.get(_key);
                            _value = _value.add(_tmpValue);
                        }
                        if (_tmpMap.containsKey(_key = new Integer(25))) {
                            _tmpValue = (BigDecimal)_tmpMap.get(_key);
                            _value = _value.add(_tmpValue);
                        }
                        if (_tmpMap.containsKey(_key = new Integer(40))) {
                            _tmpValue = (BigDecimal)_tmpMap.get(_key);
                            _value = _value.add(_tmpValue);
                        }
                        if (_tmpMap.containsKey(_key = new Integer(41))) {
                            _tmpValue = (BigDecimal)_tmpMap.get(_key);
                            _value = _value.add(_tmpValue);
                        }
                        if (_tmpMap.containsKey(_key = new Integer(42))) {
                            _tmpValue = (BigDecimal)_tmpMap.get(_key);
                            _value = _value.add(_tmpValue);
                        }
                        if (_tmpMap.containsKey(_key = new Integer(98))) {
                            _tmpValue = (BigDecimal)_tmpMap.get(_key);
                            _value = _value.add(_tmpValue);
                        }
                        if (_tmpMap.containsKey(_key = new Integer(99))) {
                            _tmpValue = (BigDecimal)_tmpMap.get(_key);
                            _value = _value.add(_tmpValue);
                        }
                    } else if (state.getValue() == 2) {
                        _key = new Integer(4);
                        if (_tmpMap.containsKey(_key)) {
                            _tmpValue = (BigDecimal)_tmpMap.get(_key);
                            _value = _value.add(_tmpValue);
                        }
                    } else if (state.getValue() == 50 || state.getValue() == 51) {
                        // empty if block
                    }
                    row.getCell(j).setValue((Object)_value);
                    if (_allForm.compareTo(BgNConstants.ZERO) != 0) {
                        row.getCell(j + 1).setValue((Object)_value.divide(_allForm, 8, 4));
                        continue;
                    }
                    row.getCell(j + 1).setValue((Object)BgNConstants.ZERO);
                }
                _sum = BgNConstants.ZERO;
                row.getCell(6).setValue((Object)_count.subtract(_usedTemplateSum));
                if (_allForm.compareTo(BgNConstants.ZERO) != 0) {
                    row.getCell(7).setValue((Object)_count.subtract(_usedTemplateSum).divide(_allForm, 8, 4));
                    continue;
                }
                row.getCell(7).setValue((Object)BgNConstants.ZERO);
                continue;
            }
            row.getCell(5).setValue((Object)BgNConstants.ZERO);
            jn = this.tblMain.getColumnCount();
            for (j = 6; j < jn; j += 2) {
                row.getCell(j).setValue((Object)BgNConstants.ZERO);
                row.getCell(j + 1).setValue((Object)BgNConstants.ZERO);
            }
        }
    }

    protected void fillTemplateData() throws Exception {
        Map nameMap;
        Map _bgTemplateMap;
        this.btnViewPlan.setText(BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormCourseResource", (String)"btnViewOrgUnit"));
        this.tblMain.removeRows();
        Map _dataMap = this.getInterface().queryTempInfo(this.ui.getQueryCourseMap());
        Map _cslTemplateMap = _dataMap.containsKey("KEY_CSLORGUNIT") ? (Map)_dataMap.get("KEY_CSLORGUNIT") : null;
        Map map = _bgTemplateMap = _dataMap.containsKey("KEY_BGORGUNIT") ? (Map)_dataMap.get("KEY_BGORGUNIT") : null;
        if (_cslTemplateMap == null || _cslTemplateMap.isEmpty()) {
            this.tblMain.getColumn(0).getStyleAttributes().setHided(true);
        } else {
            this.tblMain.getColumn(0).getStyleAttributes().setHided(false);
            nameMap = (Map)(_cslTemplateMap.containsKey("KEY_CSLORGUNIT") ? _cslTemplateMap.get("KEY_CSLORGUNIT") : new HashMap());
            this.fillTemplateDetailData(_cslTemplateMap, nameMap, "KEY_CSLORGUNIT");
        }
        if (_bgTemplateMap == null || _bgTemplateMap.isEmpty()) {
            this.tblMain.getColumn(1).getStyleAttributes().setHided(true);
        } else {
            this.tblMain.getColumn(1).getStyleAttributes().setHided(false);
            nameMap = (Map)(_bgTemplateMap.containsKey("KEY_BGORGUNIT") ? _bgTemplateMap.get("KEY_BGORGUNIT") : new HashMap());
            this.fillTemplateDetailData(_bgTemplateMap, nameMap, "KEY_BGORGUNIT");
        }
    }

    protected void fillTemplateDetailData(Map _dataMap, Map templateMap, String orgType) {
        Object[] _objs;
        IRow row = null;
        BgFormStateEnum state = null;
        BgSchemeInfo _bgSchemeInfo = null;
        BgPeriodInfo _bgPeriodInfo = null;
        CurrencyInfo _currencyInfo = null;
        BgVersionInfo _bgVersion = null;
        boolean _state = false;
        String _name = null;
        Map.Entry _entry2 = null;
        Object _obj = null;
        Integer _key = null;
        BigDecimal _value = null;
        BigDecimal _count = null;
        Object _sum = null;
        Object _cant = null;
        BigDecimal _tmpValue = null;
        BigDecimal _usedOrUnitIdSum = null;
        BigDecimal _formSum = null;
        BigDecimal _allForm = null;
        Map _tmpMap = null;
        _obj = this.ui.getBgSchemeInfo();
        if (_obj != null) {
            if (_obj instanceof BgSchemeInfo) {
                _bgSchemeInfo = _obj;
            } else if (_obj instanceof Object[] && (_objs = (Object[])_obj).length > 0 && _objs[0] != null) {
                _bgSchemeInfo = (BgSchemeInfo)_objs[0];
            }
        }
        if ((_obj = this.ui.getCurrencyInfo()) != null) {
            if (_obj instanceof CurrencyInfo) {
                _currencyInfo = (CurrencyInfo)_obj;
            } else if (_obj instanceof Object[] && (_objs = (Object[])_obj).length > 0 && _objs[0] != null) {
                _currencyInfo = (CurrencyInfo)_objs[0];
            }
        }
        BgPeriodInfo[] bgPeriods = this.getBgPeriodArr();
        BgVersionInfo[] bgVersions = this.getBgVersionArr();
        if (bgPeriods == null || bgVersions == null) {
            return;
        }
        if (templateMap != null) {
            String pvKey = null;
            for (int p = 0; p < bgPeriods.length; ++p) {
                _bgPeriodInfo = bgPeriods[p];
                for (int v = 0; v < bgVersions.length; ++v) {
                    _bgVersion = bgVersions[v];
                    for (Map.Entry _entry2 : templateMap.entrySet()) {
                        String _rootId = (String)_entry2.getKey();
                        _name = (String)_entry2.getValue();
                        pvKey = _rootId + ";" + _bgPeriodInfo.getId().toString() + ";" + _bgVersion.getId().toString();
                        if (_dataMap.containsKey(_rootId)) {
                            _tmpMap = (Map)_dataMap.get(_rootId);
                        }
                        row = this.tblMain.addRow();
                        if ("KEY_CSLORGUNIT".equals(orgType)) {
                            row.getCell(0).setValue((Object)_name);
                        } else if ("KEY_BGORGUNIT".equals(orgType)) {
                            row.getCell(1).setValue((Object)_name);
                        }
                        row.getCell(2).setValue((Object)BgCslFormCourseHelper.getRrefixPeriodName(_bgPeriodInfo));
                        row.getCell(3).setValue((Object)_currencyInfo);
                        row.getCell(4).setValue((Object)_bgVersion);
                        pvKey = _rootId + ";" + _bgPeriodInfo.getId().toString() + ";" + _bgVersion.getId().toString();
                        _key = new Integer(100);
                        _count = _tmpMap != null && _tmpMap.containsKey(_key) ? (BigDecimal)_tmpMap.get(_key) : BgNConstants.ZERO;
                        if (_dataMap.containsKey(pvKey)) {
                            _tmpMap = (Map)_dataMap.get(pvKey);
                        }
                        _key = new Integer(10000);
                        _usedOrUnitIdSum = _tmpMap != null && _tmpMap.containsKey(_key) ? new BigDecimal(((Set)_tmpMap.get(_key)).size()) : BgNConstants.ZERO;
                        _key = new Integer(10001);
                        _formSum = _tmpMap != null && _tmpMap.containsKey(_key) ? (BigDecimal)_tmpMap.get(_key) : BgNConstants.ZERO;
                        _allForm = _count.subtract(_usedOrUnitIdSum).add(_formSum);
                        row.getCell(5).setValue((Object)_allForm);
                        int jn = this.tblMain.getColumnCount();
                        for (int j = 8; j < jn; j += 2) {
                            state = (BgFormStateEnum)this.tblMain.getColumn(j).getUserObject();
                            _key = new Integer(state.getValue());
                            _value = BgNConstants.ZERO;
                            if (_tmpMap != null && _tmpMap.containsKey(_key)) {
                                _value = (BigDecimal)_tmpMap.get(_key);
                            }
                            if (state.getValue() == 1) {
                                _key = new Integer(14);
                                if (_tmpMap != null && _tmpMap.containsKey(_key)) {
                                    _tmpValue = (BigDecimal)_tmpMap.get(_key);
                                    _value = _value.add(_tmpValue);
                                }
                                _key = new Integer(25);
                                if (_tmpMap != null && _tmpMap.containsKey(_key)) {
                                    _tmpValue = (BigDecimal)_tmpMap.get(_key);
                                    _value = _value.add(_tmpValue);
                                }
                                _key = new Integer(40);
                                if (_tmpMap != null && _tmpMap.containsKey(_key)) {
                                    _tmpValue = (BigDecimal)_tmpMap.get(_key);
                                    _value = _value.add(_tmpValue);
                                }
                                _key = new Integer(41);
                                if (_tmpMap != null && _tmpMap.containsKey(_key)) {
                                    _tmpValue = (BigDecimal)_tmpMap.get(_key);
                                    _value = _value.add(_tmpValue);
                                }
                                _key = new Integer(42);
                                if (_tmpMap != null && _tmpMap.containsKey(_key)) {
                                    _tmpValue = (BigDecimal)_tmpMap.get(_key);
                                    _value = _value.add(_tmpValue);
                                }
                                _key = new Integer(98);
                                if (_tmpMap != null && _tmpMap.containsKey(_key)) {
                                    _tmpValue = (BigDecimal)_tmpMap.get(_key);
                                    _value = _value.add(_tmpValue);
                                }
                                _key = new Integer(99);
                                if (_tmpMap != null && _tmpMap.containsKey(_key)) {
                                    _tmpValue = (BigDecimal)_tmpMap.get(_key);
                                    _value = _value.add(_tmpValue);
                                }
                            } else if (state.getValue() == 2) {
                                _key = new Integer(4);
                                if (_tmpMap != null && _tmpMap.containsKey(_key)) {
                                    _tmpValue = (BigDecimal)_tmpMap.get(_key);
                                    _value = _value.add(_tmpValue);
                                }
                            }
                            row.getCell(j).setValue((Object)_value);
                            if (_allForm.compareTo(BgNConstants.ZERO) != 0) {
                                row.getCell(j + 1).setValue((Object)_value.divide(_allForm, 8, 4));
                                continue;
                            }
                            row.getCell(j + 1).setValue((Object)BgNConstants.ZERO);
                        }
                        row.getCell(6).setValue((Object)_count.subtract(_usedOrUnitIdSum));
                        if (_allForm.compareTo(BgNConstants.ZERO) != 0) {
                            row.getCell(7).setValue((Object)_count.subtract(_usedOrUnitIdSum).divide(_allForm, 8, 4));
                            continue;
                        }
                        row.getCell(7).setValue((Object)BgNConstants.ZERO);
                    }
                }
            }
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        if (this.hasQueryType) {
            this.fillTemplateData();
        } else {
            this.fillOrgData();
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        BgNFCHelper.exportKDTableToExcel((Component)((Object)this), (KDTable)this.tblMain, (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslFormCourseResource", (String)"bgCslPlan_title"), (boolean)false);
    }

    public static void exportKDTableToExcel(Component ui, KDTable kdtabbed, boolean flag) throws Exception {
        String filePath = null;
        KDFileChooser fileChooser = new BgFileUtil().getFileChooserForExp(null);
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.setFileFilter((FileFilter)new ExcelFileFilter());
        StringBuffer str = new StringBuffer();
        str.append(fileChooser.getCurrentDirectory().getPath()).append("//").append(EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslFormCourseResource", (String)"bgCslPlan_title")).append(".xls");
        fileChooser.setSelectedFile(new File(str.toString()));
        String fileName = null;
        File fileDir = null;
        String totalFileName = null;
        if (fileChooser.showSaveDialog(ui) == 0) {
            filePath = fileChooser.getSelectedFile().getPath();
            fileDir = new File(filePath.substring(0, filePath.lastIndexOf("\\")));
            totalFileName = fileName = fileChooser.getSelectedFile().getName();
            if (!fileName.toLowerCase(Locale.ENGLISH).endsWith(".xls")) {
                totalFileName = fileName + ".xls";
            }
            if (!filePath.toLowerCase(Locale.ENGLISH).endsWith(".xls")) {
                filePath = filePath + ".xls";
            }
        } else {
            return;
        }
        if (fileName.lastIndexOf(".") != -1) {
            fileName = fileName.substring(0, fileName.lastIndexOf("."));
        }
        File[] files = null;
        int status = -1;
        if (fileDir != null && fileDir.isDirectory()) {
            files = fileDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isFile() || !files[i].getName().equals(totalFileName) || (status = MsgBox.showConfirm2((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslFormCourseResource", (String)"FileExisted"))) != 2) continue;
                return;
            }
        }
        KDSBook kdsBook = new KDSBook(fileName);
        KDSSheet kdsSheet = new KDSSheet(kdsBook, fileName);
        kdsSheet = flag ? kdtabbed.getIOManager().saveToKDSSheet(kdsBook, true, false, fileName) : kdtabbed.getIOManager().saveToKDSSheet(kdsBook, true, false, false, fileName);
        kdsBook.addSheet(null, kdsSheet);
        ExportManager export = new ExportManager();
        try {
            export.exportToExcel(kdsBook, filePath);
            if (ui instanceof CoreUI) {
                CoreUI ownerUI = (CoreUI)ui;
                ownerUI.setMessageText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.MBgImportAndExportResource", (String)"exportSucceed"));
                ownerUI.showMessage();
            }
            new BgFileUtil().storeDefaultPathForEXP((Object)filePath, null);
        }
        catch (RuntimeException e1) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslFormCourseResource", (String)"CheckFileOpen"));
        }
    }
}

