/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.popup.PopupMenuManager;
import com.kingdee.eas.ma.base.BgAccountCollection;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.bgcsl.BgCslFormFactory;
import com.kingdee.eas.ma.bgcsl.BgCslFormInfo;
import com.kingdee.eas.ma.bgcsl.BgCslViewListFormFacadeFactory;
import com.kingdee.eas.ma.bgcsl.IBgCslViewListFormFacade;
import com.kingdee.eas.ma.bgcsl.MbgWorkPaperInfo;
import com.kingdee.eas.ma.bgcsl.client.AbstractBgCslDimCellUI;
import com.kingdee.eas.ma.bgcsl.client.BgCslFormProcessUI;
import com.kingdee.eas.ma.bgcsl.client.BgCslFormSpecialProcessUi;
import com.kingdee.eas.ma.bgcsl.client.BgCslViewListFormProcessUI;
import com.kingdee.eas.ma.bgcsl.client.MbgWorkPaperProcessUI;
import com.kingdee.eas.ma.bgcsl.client.utils.BgCslDisplayValueProvider;
import com.kingdee.eas.ma.bgcsl.client.utils.BgCslViewListDispalyValueProvider;
import com.kingdee.eas.ma.bgcsl.client.utils.IBgCslDisplayHelper;
import com.kingdee.eas.ma.bgcsl.client.utils.IBgCslViewListDisplayHelper;
import com.kingdee.eas.ma.bgcsl.common.BgCslElimHelper;
import com.kingdee.eas.ma.bgcsl.utils.BgCslSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.BgDimCellQuerySetInfo;
import com.kingdee.eas.ma.mbg.BgMemberSelectTypeEnum;
import com.kingdee.eas.ma.mbg.client.utils.BgAnalyseDrillTableHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgExamineHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectDialog;
import com.kingdee.eas.ma.mbg.client.utils.NumberExpandExtInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.common.IBgNumberCellDisplayHelper;
import com.kingdee.eas.ma.mbg.common.MbgViewListResultData;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDrillParameter;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDrillResult;
import com.kingdee.eas.ma.mbg.dimension.face.IDimension;
import com.kingdee.eas.ma.mbg.dimension.face.IMember;
import com.kingdee.eas.ma.mbg.dimension.impl.DimDrillParameter;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.dimension.vo.DimensionObject;
import com.kingdee.eas.ma.mbg.utils.BgCslDimConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class BgCslDimCellUI
extends AbstractBgCslDimCellUI {
    private static final Logger logger = CoreUIObject.getLogger(BgCslDimCellUI.class);
    private Map<String, Map<String, Set<String>>> specialDimCheckMap;
    private Map<String, Set<String>> acc_DimNumbers;
    private KDBizPromptBox cslPrmt;
    BgCslDisplayValueProvider displayProvider;

    public KDBizPromptBox getCslPrmt() {
        return this.cslPrmt;
    }

    public void setCslPrmt(KDBizPromptBox cslPrmt) {
        this.cslPrmt = cslPrmt;
    }

    protected void registerBizCalcTraceAction(PopupMenuManager mgr) {
    }

    public void onShow() throws Exception {
        super.onShow();
        this.sealOrgShowCheckBox.setVisible(false);
        this.btnBizCalcTrace.setVisible(false);
    }

    protected void showData() throws Exception {
        this.dimTable.removeHeadRows();
        this.dimTable.removeRows();
        if (this.dealDimTable(this.orgDims, this.rowDims, this.colDims)) {
            List<String> newformulas = (List<String>)this.getUIContext().get("GATHER_FORMULA");
            if (newformulas == null || newformulas.isEmpty()) {
                newformulas = this.getFormulas();
            }
            newformulas = this.expandNewformulas(newformulas);
            this.removeChildFormula(newformulas);
            this.dealData(newformulas, this.getValues());
        }
        this.mergeCell();
    }

    private List<String> expandNewformulas(List<String> newformulas) throws EASBizException, BOSException {
        MbgViewListResultData data = (MbgViewListResultData)this.getCslPrmt().getData();
        if (null == data || data.getMembers().isEmpty()) {
            return newformulas;
        }
        HashSet<String> formulaSet = new HashSet<String>();
        for (int i = 0; i < newformulas.size(); ++i) {
            String _formula;
            String formula = _formula = newformulas.get(i);
            for (int j = 0; j < data.getMembers().size(); ++j) {
                BgDimensionMember member = (BgDimensionMember)data.getMembers().get(j);
                formula = this.replaceCslToDimDataKey(formula, member.getSrcNumber() + ":" + member.getNumber());
                formulaSet.add(formula);
            }
        }
        ArrayList<String> formulas = new ArrayList<String>(formulaSet);
        Collections.sort(formulas);
        return formulas;
    }

    protected KDPanel getDimPanel() {
        KDPanel view = super.getDimPanel();
        try {
            this.setCslPrmt(this.createCslViewPromptBox(view));
        }
        catch (BOSException var1) {
            logger.error((Object)"", (Throwable)var1);
            this.handUIExceptionAndAbort((Exception)((Object)var1));
        }
        catch (EASBizException var2) {
            logger.error((Object)"", (Throwable)var2);
            this.handUIExceptionAndAbort((Exception)((Object)var2));
        }
        return view;
    }

    private KDBizPromptBox createCslViewPromptBox(KDPanel view) throws BOSException, EASBizException {
        KDLabelContainer _container = this.createContainer();
        _container.setBoundLabelText(DimensionConstants.DEF_CSL_NAME);
        view.add((Component)_container);
        MbgViewListResultData data = this.selectCslMembers();
        KDBizPromptBox prmt = new KDBizPromptBox();
        prmt.setEditable(false);
        prmt.setEditFormat("$number$");
        prmt.setDisplayFormat("$name$");
        prmt.setCommitFormat("$number$");
        prmt.setSelector((KDPromptSelector)this.getCslDialog(data));
        prmt.setData((Object)data);
        prmt.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent event) {
                MbgViewListResultData oldValue = (MbgViewListResultData)event.getOldValue();
                MbgViewListResultData newValue = (MbgViewListResultData)event.getNewValue();
                if (oldValue != null && oldValue.equals(newValue)) {
                    return;
                }
                try {
                    BgCslDimCellUI.this.showData();
                    if (newValue != null && !newValue.getMembers().isEmpty()) {
                        BgCslDimCellUI.this.saveBgCellQuerySet();
                    }
                    BgCslDimCellUI.this.hideDimForOnlyOne(BgCslDimCellUI.this.dimHiddenBoxCheckBox);
                }
                catch (Exception exc) {
                    BgCslDimCellUI.this.handUIException(exc);
                }
            }
        });
        _container.setBoundEditor((JComponent)prmt);
        return prmt;
    }

    protected boolean extraFilter(String formulaStr) {
        String[] strs;
        if (StringUtils.isEmpty((String)formulaStr)) {
            return false;
        }
        KDBizPromptBox cslPrmt = this.getCslPrmt();
        MbgViewListResultData data = (MbgViewListResultData)cslPrmt.getData();
        if (null == data || data.getMembers().isEmpty()) {
            return false;
        }
        List members = data.getMembers();
        HashSet<String> numbers = new HashSet<String>(members.size());
        int in = members.size();
        for (int i = 0; i < in; ++i) {
            BgDimensionMember member = (BgDimensionMember)members.get(i);
            numbers.add(member.getNumber());
        }
        String oldItem = BgNFSHelper.parseFormulaPara((String)formulaStr)[0];
        for (String str : strs = oldItem.split(",")) {
            String[] fields = str.split(":");
            if (!DimensionConstants.DEF_CSL_SRCNUMBER.equals(fields[0])) continue;
            String field = fields[1];
            return numbers.contains(field);
        }
        return true;
    }

    private DimensionMemberSelectDialog getCslDialog(MbgViewListResultData data) throws BOSException, EASBizException {
        DimensionMemberSelectDialog dialog = BgExamineHelper.getDimensionMemberSelectDialog();
        dialog.setEnableProperty(true);
        dialog.setOwner((Component)((Object)this));
        dialog.setMulti(true);
        dialog.setOnlySelectItem(true);
        dialog.setSelectCombinItem(false);
        dialog.setOnlyRefDim(true);
        dialog.setDimension((Object)this.getSchemeHelper().getDimension(DimensionConstants.DEF_CSL_NUMBER));
        dialog.setOrgId(((OrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO)).getId().toString());
        dialog.setBgSchemeId(this.schemeInfo.getId().toString());
        dialog.setHiddenCslPartDim(true);
        dialog.setCurSelectFunction(data);
        HashMap<String, Set> filterValueMap = new HashMap<String, Set>(1);
        filterValueMap.put(DimensionConstants.DEF_CSL_NUMBER, BgCslDimConstants.canEditCslAjdNumberSet);
        dialog.setMemberFilter(filterValueMap);
        return dialog;
    }

    protected void expandRow(ICell cell, NumberExpandExtInfo expandInfo, boolean hided) {
        ICell prevCell;
        KDTMergeBlock prevMergeBlock;
        if (cell == null || expandInfo == null) {
            return;
        }
        KDTMergeBlock thisBlock = cell.getMergeBlock();
        IRow row = null;
        ICell _cell = null;
        ICell _tmpCell = null;
        ICell _firstCell = null;
        NumberExpandExtInfo _expandInfo = null;
        NumberExpandExtInfo _tmpExpandInfo = null;
        NumberExpandExtInfo nextTopExpandInfo = null;
        NumberExpandExtInfo nextExpandInfo = null;
        String nextTopExpandLongNumber = "";
        String nextExpandLongNumber = "";
        String longNumber = null;
        String parentLongNumber = expandInfo.getLongNumber();
        int rowIndex = cell.getRowIndex();
        int colIndex = cell.getColumnIndex();
        int _rowIndex = rowIndex + 1;
        int _rowCount = colIndex > 0 ? (null == (prevMergeBlock = (prevCell = this.dimTable.getCell(_rowIndex - 1, colIndex - 1)).getMergeBlock()) ? this.dimTable.getRowCount() : prevMergeBlock.getBottom() + 1) : this.dimTable.getRowCount();
        ICell _nextCell = this.dimTable.getRow(_rowIndex - 1).getCell(colIndex + 1);
        if (_nextCell.getValue() != null && _nextCell.getValue() instanceof NumberExpandExtInfo && !StringUtils.isEmpty((String)(nextTopExpandInfo = (NumberExpandExtInfo)_nextCell.getValue()).getNumber())) {
            nextTopExpandLongNumber = nextTopExpandInfo.getLongNumber();
        }
        HashSet<String> nextTopExpandLongNumbers = new HashSet<String>();
        if (thisBlock != null) {
            for (int i = thisBlock.getTop(); i <= thisBlock.getBottom(); ++i) {
                ICell nextCell = this.dimTable.getRow(i).getCell(colIndex + 1);
                if (nextCell.getValue() == null || !(nextCell.getValue() instanceof NumberExpandExtInfo) || StringUtils.isEmpty((String)(nextTopExpandInfo = (NumberExpandExtInfo)nextCell.getValue()).getNumber())) continue;
                nextTopExpandLongNumbers.add(nextTopExpandInfo.getLongNumber());
            }
        } else {
            nextTopExpandLongNumbers.add(nextTopExpandLongNumber);
        }
        String tmpLongNumber = null;
        while (_rowIndex < _rowCount) {
            if (thisBlock == null || _rowIndex < thisBlock.getTop() || _rowIndex > thisBlock.getBottom()) {
                row = this.dimTable.getRow(_rowIndex);
                _cell = row.getCell(colIndex);
                _firstCell = row.getCell(colIndex + 1);
                if (_firstCell.getValue() instanceof NumberExpandExtInfo) {
                    nextExpandInfo = (NumberExpandExtInfo)_firstCell.getValue();
                } else if (_firstCell.getMergeBlock() != null && (_firstCell = this.dimTable.getCell(_firstCell.getMergeBlock().getTop(), _firstCell.getMergeBlock().getLeft())).getValue() instanceof NumberExpandExtInfo) {
                    nextExpandInfo = (NumberExpandExtInfo)_firstCell.getValue();
                }
                if (nextExpandInfo != null && !StringUtils.isEmpty((String)nextExpandInfo.getNumber())) {
                    nextExpandLongNumber = nextExpandInfo.getLongNumber();
                }
                if ((_expandInfo = (NumberExpandExtInfo)row.getCell(colIndex).getValue()) != null && !_expandInfo.getNumber().equals(expandInfo.getNumber())) {
                    longNumber = _expandInfo.getLongNumber();
                    if (!longNumber.startsWith(parentLongNumber + "!")) break;
                    if (hided || !longNumber.startsWith(tmpLongNumber + "!")) {
                        if (!hided && !_expandInfo.isExpandStatus()) {
                            tmpLongNumber = _expandInfo.getLongNumber();
                        }
                        boolean hideSet = hided || this.isHideRow(row);
                        boolean isNextEqual = this.isNextEqual4Col(nextTopExpandLongNumbers, nextExpandLongNumber, colIndex);
                        if (hideSet) {
                            if (isNextEqual) {
                                row.getStyleAttributes().setHided(hideSet);
                            } else if (!row.getStyleAttributes().isHided() || !this.checkEmptyRow(row)) {
                                row.getStyleAttributes().setHided(false);
                            }
                        } else {
                            row.getStyleAttributes().setHided(hideSet);
                        }
                        if (!hided && this.checkEmptyRow(row)) {
                            row.getStyleAttributes().setHided(true);
                            this.setHideRow(row);
                        }
                    }
                } else {
                    KDTMergeBlock block = _cell.getMergeBlock();
                    if (block != null && (_tmpExpandInfo = (NumberExpandExtInfo)(_tmpCell = this.dimTable.getCell(block.getTop(), block.getLeft())).getValue()) != null) {
                        if (nextTopExpandInfo != null) {
                            nextTopExpandInfo.setExpandStatus(!hided);
                        }
                        String orgLongNumber = _tmpExpandInfo.getLongNumber();
                        longNumber = nextExpandInfo.getLongNumber();
                        if (!(_tmpExpandInfo != expandInfo && !orgLongNumber.startsWith(parentLongNumber + "!") || _tmpExpandInfo != expandInfo && !orgLongNumber.startsWith(parentLongNumber + "!") || !hided && longNumber.startsWith(tmpLongNumber + "!"))) {
                            if (!hided && !nextExpandInfo.isExpandStatus()) {
                                tmpLongNumber = nextExpandInfo.getLongNumber();
                            }
                            row.getStyleAttributes().setHided(hided || this.isHideRow(row));
                            if (!hided && this.checkEmptyRow(row)) {
                                row.getStyleAttributes().setHided(true);
                                this.setHideRow(row);
                            }
                        }
                    }
                }
            }
            ++_rowIndex;
        }
    }

    private MbgViewListResultData selectCslMembers() throws EASBizException, BOSException {
        IObjectPK userPk = this.getUserPk();
        HashSet<String> querySetCslNum = new HashSet<String>();
        int count = 0;
        BgDimCellQuerySetInfo setInfo = null;
        if (userPk != null) {
            if (this.getInterfaceForQuery().exists("where userId = '" + userPk.toString() + "'")) {
                setInfo = this.getInterfaceForQuery().getBgDimCellQuerySetCollection("where userId = '" + userPk.toString() + "'").get(0);
                String cslset = setInfo.getCslSet();
                if (!StringUtils.isEmpty((String)cslset)) {
                    String[] cslsets = cslset.split(",");
                    for (int i = 0; i < cslsets.length; ++i) {
                        querySetCslNum.add(cslsets[i]);
                    }
                }
                count = 2;
            } else {
                count = 1;
            }
        }
        MbgViewListResultData data = new MbgViewListResultData();
        data.setMemberType(BgMemberSelectTypeEnum.Member);
        ArrayList<BgDimensionMember> selectMembers = new ArrayList<BgDimensionMember>(5);
        Set cslNumbers = (Set)this.getUIContext().get("SELECT_CSL_MEMBERS");
        cslNumbers.addAll(querySetCslNum);
        if (count != 0) {
            this.saveCslSet(count, cslNumbers, setInfo);
        }
        for (String cslNumber : cslNumbers) {
            BgDimensionMember member = new BgDimensionMember(DimensionConstants.DEF_CSL_NUMBER, DimensionConstants.DEF_CSL_FIELD, (String)BgCslDimConstants.numberToNames.get(cslNumber), cslNumber);
            member.setSrcNumber(DimensionConstants.DEF_CSL_SRCNUMBER);
            selectMembers.add(member);
        }
        Collections.sort(selectMembers, new Comparator<BgDimensionMember>(){

            @Override
            public int compare(BgDimensionMember o1, BgDimensionMember o2) {
                return o1.getNumber().compareTo(o2.getNumber());
            }
        });
        data.setMembers(selectMembers);
        return data;
    }

    private void saveCslSet(int count, Set<String> cslNumbers, BgDimCellQuerySetInfo info) throws EASBizException, BOSException {
        StringBuffer str = new StringBuffer();
        for (String number : cslNumbers) {
            str.append(number).append(",");
        }
        if (count == 1) {
            info = new BgDimCellQuerySetInfo();
            info.setIsHideDim(false);
            info.setIsShowSealOrg(false);
            info.setIsCalcBiz(false);
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            info.setUserId(this.getUserPk().toString());
            info.setCslSet(str.substring(0, str.length() - 1));
        } else if (count == 2) {
            info.setCslSet(str.substring(0, str.length() - 1));
        }
        this.getInterfaceForQuery().save((CoreBaseInfo)info);
    }

    protected void mergeCell() {
        int top = 0;
        this.dimTable.getMergeManager().removeAllMergeBlock();
        for (int colIndex = 0; colIndex <= this.rowDims.size(); ++colIndex) {
            ICell prevCell = null;
            int bottom = colIndex == 0 ? this.dimTable.getRowCount() - 1 : 1;
            for (int rowIndex = 0; rowIndex < this.dimTable.getRowCount(); ++rowIndex) {
                ICell currCell = this.dimTable.getCell(rowIndex, colIndex);
                if (colIndex > 0) {
                    ICell beforeCell = this.dimTable.getCell(rowIndex, colIndex - 1);
                    if (BgAnalyseDrillTableHelper.isValidMerge((ICell)beforeCell)) {
                        KDTMergeBlock mergeBlock = beforeCell.getMergeBlock();
                        if (rowIndex > bottom) {
                            prevCell = null;
                        }
                        top = mergeBlock.getTop();
                        bottom = mergeBlock.getBottom();
                    } else {
                        prevCell = null;
                        continue;
                    }
                }
                if (prevCell != null) {
                    Object prevCellValue = prevCell.getValue();
                    Object currCellValue = currCell.getValue();
                    if (prevCellValue instanceof NumberExpandExtInfo && currCellValue instanceof NumberExpandExtInfo) {
                        if (top <= rowIndex && rowIndex <= bottom) {
                            if (((NumberExpandExtInfo)prevCellValue).getNumber().equals(((NumberExpandExtInfo)currCellValue).getNumber())) {
                                KDTMergeBlock prevMergeBlock = this.getMergeBlock(prevCell.getRowIndex(), colIndex);
                                if (prevMergeBlock != null) {
                                    this.mergeBlock(prevMergeBlock.getTop(), colIndex, rowIndex, colIndex);
                                } else {
                                    this.mergeBlock(prevCell.getRowIndex(), colIndex, rowIndex, colIndex);
                                }
                            } else {
                                this.mergeBlock(prevCell.getRowIndex(), colIndex, currCell.getRowIndex() - 1, colIndex);
                            }
                        } else {
                            this.mergeBlock(prevCell.getRowIndex(), colIndex, rowIndex, colIndex);
                        }
                    }
                }
                prevCell = currCell;
            }
        }
    }

    private void mergeBlock(int top, int left, int bottom, int right) {
        if (top != bottom) {
            this.dimTable.getMergeManager().mergeBlock(top, left, bottom, right);
        }
    }

    protected void sortFormulaByCsl(List<String> formulas) {
        if (formulas == null || formulas.size() < 2) {
            return;
        }
        Collections.sort(formulas, new Comparator<String>(){

            @Override
            public int compare(String formula1, String formula2) {
                String[] formulaPara1 = BgNFSHelper.parseFormulaPara((String)formula1);
                String[] formulaPara2 = BgNFSHelper.parseFormulaPara((String)formula2);
                String paraItem1 = formulaPara1[0];
                String paraItem2 = formulaPara2[0];
                String[] dimNumbers1 = paraItem1.split(",");
                String[] dimNumbers2 = paraItem2.split(",");
                int in = dimNumbers1.length;
                for (int i = 0; i < in; ++i) {
                    String srcNumber1 = dimNumbers1[i];
                    String srcNumber2 = dimNumbers2[i];
                    if (!DimensionConstants.DEF_CSL_SRCNUMBER.equals(srcNumber1.substring(0, srcNumber1.indexOf(":")))) continue;
                    if (srcNumber1.equals(srcNumber2)) {
                        return formula1.compareTo(formula2);
                    }
                    return srcNumber1.compareTo(srcNumber2);
                }
                return formula1.compareTo(formula2);
            }
        });
    }

    public BgSchemeDimensionHelper getSchemeHelper() throws BOSException, EASBizException {
        return this.schemeHelper != null ? this.schemeHelper : new BgCslSchemeDimensionHelper(this.schemeInfo.getId().toString());
    }

    protected NumberExpandExtInfo getOrgUnitExpandInfo() {
        OrgUnitInfo orgUnitInfo = this.result.getCurrUnionOrgUnit();
        return this.getOrgUnitExpandInfo(orgUnitInfo, null, 0, 0);
    }

    protected void prepareInitParameter() throws BOSException, EASBizException {
        this.specialDimCheckMap = BgCslElimHelper.getSpecialDimCheckMap(null, this.getSchemeHelper());
        this.queryParentAccMemberBySpecialDimMap();
    }

    protected boolean isNextEqual(String nextTopExpandLongNumber, String nextExpandLongNumber) {
        if (BgCslDimConstants.canEditCslAjdNumberSet.contains(nextTopExpandLongNumber)) {
            return true;
        }
        return nextExpandLongNumber.equals(nextTopExpandLongNumber) || nextExpandLongNumber.startsWith(nextTopExpandLongNumber + "!");
    }

    protected boolean isNextEqual4Col(Set<String> nextTopExpandLongNumbers, String nextExpandLongNumber, int colIndex) {
        BgDimensionBaseInfo baseInfo;
        String attribute;
        Object userObject = this.dimTable.getColumn(colIndex + 1).getUserObject();
        if (userObject != null && userObject instanceof BgDimensionBaseInfo && DimensionBaseConstants.DEF_CSL_FIELD.equals(attribute = (baseInfo = (BgDimensionBaseInfo)userObject).getAttribute())) {
            return true;
        }
        for (String nextTopExpandLongNumber : nextTopExpandLongNumbers) {
            if (!nextExpandLongNumber.startsWith(nextTopExpandLongNumber + "!") && !nextExpandLongNumber.equals(nextTopExpandLongNumber)) continue;
            return true;
        }
        return false;
    }

    protected void openFormUI(int rowIndex, int colIndex) {
        try {
            LongTimeDialog dialog = this.getLongTimeDialog();
            if (dialog == null) {
                return;
            }
            ICell cell = this.dimTable.getCell(rowIndex, colIndex);
            ICell orgCell = this.dimTable.getCell(rowIndex, this.getOrgUnitColIndex());
            String formula = (String)cell.getUserObject();
            NumberExpandExtInfo orgExpandInfo = (NumberExpandExtInfo)orgCell.getValue();
            if (orgExpandInfo == null && orgCell.getMergeBlock() != null) {
                KDTMergeBlock block = orgCell.getMergeBlock();
                orgCell = this.dimTable.getCell(block.getTop(), block.getLeft());
                orgExpandInfo = (NumberExpandExtInfo)orgCell.getValue();
            }
            Map parameter = this.getQueryParameter(formula, orgExpandInfo);
            String formId = this.getCslInterface().queryFormByData(parameter);
            int formType = 0;
            if (!StringUtils.isEmpty((String)formId)) {
                BOSObjectType bosObjectType = BOSUuid.getBOSObjectType((String)formId, (boolean)true);
                if (bosObjectType.equals((Object)new BgCslFormInfo().getBOSType())) {
                    BgCslFormInfo bgCslFormInfo = BgCslFormFactory.getRemoteInstance().getBgCslFormInfo("select bgCslTemplate.formType where id = '" + formId + "'");
                    formType = bgCslFormInfo.getBgCslTemplate().getFormType().getValue();
                }
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"ID", (Object)formId);
                uiContext.put((Object)"Version", (Object)((IMember)this.getVersionComboBox().getSelectedItem()).getNumber());
                uiContext.put((Object)"ORGUNITID", (Object)orgExpandInfo.getId());
                uiContext.put((Object)"FROMUI", (Object)this);
                uiContext.put((Object)"FORMULA", (Object)formula);
                IUIWindow ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getBgCslProcessUI(bosObjectType, formType), (Map)uiContext, null, OprtState.VIEW);
                ui.show();
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFormMsgResource", (String)"findnotform"));
                SysUtil.abort();
            }
        }
        catch (UIException ex) {
            ExceptionHandler.handle((Throwable)ex);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private String getBgCslProcessUI(BOSObjectType bosObjectType, int formType) {
        if (bosObjectType.equals((Object)new MbgWorkPaperInfo().getBOSType())) {
            return MbgWorkPaperProcessUI.class.getName();
        }
        if (formType == 2) {
            return BgCslViewListFormProcessUI.class.getName();
        }
        if (formType == 8) {
            return BgCslFormSpecialProcessUi.class.getName();
        }
        return BgCslFormProcessUI.class.getName();
    }

    private IBgCslViewListFormFacade getCslInterface() throws BOSException {
        return BgCslViewListFormFacadeFactory.getRemoteInstance();
    }

    private void queryParentAccMemberBySpecialDimMap() throws BOSException, EASBizException {
        if (null == this.specialDimCheckMap || this.specialDimCheckMap.isEmpty()) {
            return;
        }
        Set<String> dimNumbers = this.specialDimCheckMap.keySet();
        HashSet<String> numbers = new HashSet<String>(dimNumbers.size());
        for (String dimNumber : dimNumbers) {
            numbers.add(dimNumber.substring(dimNumber.indexOf(":") + 1));
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("longNumber"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgAccountView.id", (Object)this.getSchemeHelper().getDimension(DimensionConstants.DEF_INDEX_NUMBER).getViewId(), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("number", numbers, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        BgAccountCollection coll = BgAccountFactory.getRemoteInstance().getBgAccountCollection(viewInfo);
        Iterator iterator = coll.iterator();
        this.acc_DimNumbers = new HashMap<String, Set<String>>();
        while (iterator.hasNext()) {
            BgAccountInfo accountInfo = (BgAccountInfo)iterator.next();
            String longNumber = accountInfo.getLongNumber();
            if (null == longNumber) continue;
            if (longNumber.contains("!")) {
                String[] parentNumbers;
                for (String parentNumber : parentNumbers = longNumber.split("!")) {
                    if (numbers.contains(parentNumber)) continue;
                    String srcPnum = DimensionConstants.DEF_INDEX_SRCNUMBER.concat(":").concat(parentNumber);
                    if (this.acc_DimNumbers.containsKey(srcPnum)) {
                        this.acc_DimNumbers.get(srcPnum).add(DimensionConstants.DEF_INDEX_SRCNUMBER.concat(":").concat(accountInfo.getNumber()));
                        continue;
                    }
                    HashSet<String> nums = new HashSet<String>();
                    nums.add(DimensionConstants.DEF_INDEX_SRCNUMBER.concat(":").concat(accountInfo.getNumber()));
                    this.acc_DimNumbers.put(srcPnum, nums);
                }
                continue;
            }
            if (numbers.contains(longNumber)) continue;
            String srcPnum = DimensionConstants.DEF_INDEX_SRCNUMBER.concat(":").concat(longNumber);
            if (this.acc_DimNumbers.containsKey(srcPnum)) {
                this.acc_DimNumbers.get(srcPnum).add(DimensionConstants.DEF_INDEX_SRCNUMBER.concat(":").concat(accountInfo.getNumber()));
                continue;
            }
            HashSet<String> nums = new HashSet<String>();
            nums.add(DimensionConstants.DEF_INDEX_SRCNUMBER.concat(":").concat(accountInfo.getNumber()));
            this.acc_DimNumbers.put(srcPnum, nums);
        }
    }

    public OrgUnitInfo getQueryUnionOrgUnit(NumberExpandExtInfo expandInfo) {
        if (expandInfo != null && expandInfo.getObject() instanceof OrgUnitInfo) {
            return (OrgUnitInfo)expandInfo.getObject();
        }
        return null;
    }

    public List<OrgUnitInfo> getQueryUnionOrgUnitNums(NumberExpandExtInfo expandInfo) {
        OrgUnitInfo orgUnit = null;
        ArrayList<OrgUnitInfo> orgUnits = new ArrayList<OrgUnitInfo>();
        if (expandInfo != null) {
            orgUnit = new OrgUnitInfo();
            orgUnit.setId(BOSUuid.read((String)expandInfo.getId()));
            orgUnit.setNumber(expandInfo.getNumber());
            orgUnit.setName(expandInfo.getName());
            orgUnit.setLongNumber(expandInfo.getLongNumber());
            orgUnits.add(orgUnit);
        } else {
            ICell cell = null;
            NumberExpandExtInfo _expandInfo = null;
            int in = this.dimTable.getRowCount();
            for (int i = 0; i < in; ++i) {
                cell = this.dimTable.getCell(i, this.getOrgUnitColIndex());
                if (cell == null || !(cell.getValue() instanceof NumberExpandExtInfo)) continue;
                _expandInfo = (NumberExpandExtInfo)cell.getValue();
                orgUnit = new OrgUnitInfo();
                orgUnit.setId(BOSUuid.read((String)_expandInfo.getId()));
                orgUnit.setNumber(_expandInfo.getNumber());
                orgUnit.setLongNumber(_expandInfo.getLongNumber());
                if (_expandInfo.getObject() instanceof OrgUnitInfo) {
                    OrgUnitInfo _bgOrgUnit = (OrgUnitInfo)_expandInfo.getObject();
                    orgUnit.setId(_bgOrgUnit.getId());
                }
                orgUnits.add(orgUnit);
            }
        }
        return orgUnits;
    }

    public OrgUnitInfo getQueryUnionOrgUnit(ICell cell) {
        if (cell == null) {
            return null;
        }
        ICell orgCell = this.dimTable.getCell(cell.getRowIndex(), 0);
        if (orgCell != null) {
            orgCell = this.getMegerOrgCell(orgCell);
            NumberExpandExtInfo _expandInfo = (NumberExpandExtInfo)orgCell.getValue();
            return this.getQueryUnionOrgUnit(_expandInfo);
        }
        return null;
    }

    private List getCslMembers() {
        KDBizPromptBox cslPrmt = this.getCslPrmt();
        MbgViewListResultData data = (MbgViewListResultData)cslPrmt.getData();
        if (null == data || data.getMembers().isEmpty()) {
            return new ArrayList();
        }
        List members = data.getMembers();
        return members;
    }

    protected void expandOrgUnitDatas(Set<Integer> rowIndexSet, IDimDrillResult _result, ICell _cell, NumberExpandExtInfo _expandInfo) throws BOSException {
        IRow row = null;
        IMember bgVer = this.getSelBgVersion();
        IMember sceneMember = (IMember)this.getScenComboBox().getSelectedItem();
        if (!_result.getSubUnionOrgUnits().isEmpty()) {
            IRow pRow = this.dimTable.getRow(_cell.getRowIndex());
            boolean isMuiltOrgUnit = _result.getSubUnionOrgUnits().size() > 1;
            HashSet<String> csl01_RepeatKeys = new HashSet<String>();
            int in = _result.getSubUnionOrgUnits().size();
            for (int i = 0; i < in; ++i) {
                OrgUnitInfo orgUnitInfo = (OrgUnitInfo)_result.getSubUnionOrgUnits().get(i);
                NumberExpandExtInfo subExpandInfo = this.getOrgUnitExpandInfo(orgUnitInfo, _expandInfo, _cell.getRowIndex(), _cell.getColumnIndex());
                int addRowCount = 0;
                if (BgAnalyseDrillTableHelper.isValidMerge((ICell)_cell)) {
                    KDTMergeBlock mergeBlock = _cell.getMergeBlock();
                    for (int j = mergeBlock.getTop(); j < mergeBlock.getBottom() + 1; ++j) {
                        if (this.dimTable.getRow(j).getStyleAttributes().isHided()) continue;
                        row = this.addSubRow(_cell, _expandInfo, subExpandInfo);
                        this.dealMerge4Dim(_cell, row, pRow, ++addRowCount, j, i + 1, _result, orgUnitInfo, bgVer, sceneMember, isMuiltOrgUnit, rowIndexSet, _expandInfo, subExpandInfo, true, csl01_RepeatKeys);
                    }
                    csl01_RepeatKeys.clear();
                    continue;
                }
                row = this.addSubRow(_cell, _expandInfo, subExpandInfo);
                this.dealExtDim(_cell, row, pRow, ++addRowCount, _result, orgUnitInfo, bgVer, sceneMember, isMuiltOrgUnit, rowIndexSet, _expandInfo, subExpandInfo, true, csl01_RepeatKeys);
                csl01_RepeatKeys.clear();
            }
            _expandInfo.setHasExpendData(true);
        } else {
            _expandInfo.setLeaf(true);
            this.dimTable.repaint();
        }
        this.mergeCell();
    }

    private void fillExtDimData(ICell _cell, IDimDrillResult _result, OrgUnitInfo orgUnitInfo, IRow row, IRow pRow, IMember bgVer, IMember sceneMember, boolean isMuiltOrgUnit, Set<Integer> rowIndexSet, NumberExpandExtInfo _expandInfo, NumberExpandExtInfo subExpandInfo, boolean isExpandOrgUnit, Set<String> csl01_RepeatKeys) throws BOSException {
        ICell cell;
        ICell pCell;
        int colIndex;
        int colCount = this.getBgPeriodColIndex();
        for (colIndex = _cell.getColumnIndex() + 1; colIndex < colCount; ++colIndex) {
            pCell = pRow.getCell(colIndex);
            cell = row.getCell(colIndex);
            if (pCell.getValue() instanceof NumberExpandExtInfo) {
                NumberExpandExtInfo tmpExpandInfo = (NumberExpandExtInfo)pCell.getValue();
                NumberExpandExtInfo clone = tmpExpandInfo.clone(true);
                if (DimensionConstants.DEF_CSL_NUMBER.equals(tmpExpandInfo.getDimension().getNumber()) && orgUnitInfo.isIsLeaf()) {
                    this.replaceCslMerger(clone, "CSL-01", BgCslDimConstants.CSL_MERGER_01_NAME);
                    if (this.checkRepeatRowByCsl01(row, csl01_RepeatKeys, cell, clone)) {
                        return;
                    }
                }
                cell.setValue((Object)clone);
                continue;
            }
            cell.setValue(((ICell)pCell.clone()).getValue());
        }
        colCount = this.dimTable.getColumnCount();
        for (colIndex = this.getBgPeriodColIndex(); colIndex < colCount; ++colIndex) {
            IBgNData bgData;
            Map dataMap;
            pCell = pRow.getCell(colIndex);
            if (!(pCell.getUserObject() instanceof String)) continue;
            String formulaStr = (String)pCell.getUserObject();
            if (!isExpandOrgUnit) {
                String[] formulaStrs = BgNFSHelper.parseFormulaPara((String)formulaStr);
                formulaStrs[0] = formulaStrs[0].replaceAll(_expandInfo.getMember().getDimNumber(), subExpandInfo.getMember().getDimNumber());
                formulaStr = BgNFSHelper.getFormulaFromParam((String[])formulaStrs);
            }
            String keyStr = DimUtils.getDimDataKey((String)formulaStr, (String)bgVer.getNumber());
            if (orgUnitInfo.isIsLeaf()) {
                keyStr = this.replaceCslToDimDataKey(keyStr, BgCslDimConstants.csl01);
            }
            cell = row.getCell(colIndex);
            cell.setUserObject((Object)formulaStr);
            if (isMuiltOrgUnit) {
                if (!_result.getDimData().containsKey(orgUnitInfo.getId().toString()) || !(dataMap = (Map)_result.getDimData().get(orgUnitInfo.getId().toString())).containsKey(keyStr)) continue;
                bgData = (IBgNData)dataMap.get(keyStr);
                this.setCellValue(cell, bgData, sceneMember);
                this.setCellColor(bgData, cell);
                continue;
            }
            dataMap = (Map)_result.getDimData().get(orgUnitInfo.getId().toString());
            if (dataMap == null || !dataMap.containsKey(keyStr)) continue;
            bgData = (IBgNData)dataMap.get(keyStr);
            this.setCellValue(cell, bgData, sceneMember);
            this.setCellColor(bgData, cell);
        }
        if (this.checkEmptyRow(row)) {
            row.getStyleAttributes().setHided(true);
            this.setHideRow(row);
            rowIndexSet.remove(row.getRowIndex());
        }
    }

    private boolean checkRepeatRowByCsl01(IRow row, Set<String> csl01_RepeatKeys, ICell cell, NumberExpandExtInfo clone) {
        StringBuilder builder = new StringBuilder();
        int in = cell.getColumnIndex();
        for (int i = 0; i < in; ++i) {
            Object value = row.getCell(i).getValue();
            if (value instanceof NumberExpandExtInfo) {
                builder.append(((NumberExpandExtInfo)value).getNumber()).append("!");
                continue;
            }
            builder.append(cell.getValue().toString()).append("!");
        }
        builder.append(clone.getNumber());
        if (csl01_RepeatKeys.contains(builder.toString())) {
            this.dimTable.removeRow(row.getRowIndex());
            return true;
        }
        csl01_RepeatKeys.add(builder.toString());
        return false;
    }

    protected void queryExtDimData(ICell cell, NumberExpandExtInfo expandInfo, boolean isAllDim) throws Exception {
        super.queryExtDimData(cell, expandInfo, isAllDim);
    }

    protected String getOrgDimTableNameByDimension(BgDimensionBaseInfo dimension) {
        return EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"bgformqsORG");
    }

    protected String replaceCslToDimDataKey(String keyStr, String cslNumber) {
        if (keyStr.contains(BgCslDimConstants.csl04)) {
            keyStr = keyStr.replaceAll(BgCslDimConstants.csl04, cslNumber);
        } else if (keyStr.contains(BgCslDimConstants.csl05)) {
            keyStr = keyStr.replaceAll(BgCslDimConstants.csl05, cslNumber);
        } else if (keyStr.contains(BgCslDimConstants.csl06)) {
            keyStr = keyStr.replaceAll(BgCslDimConstants.csl06, cslNumber);
        } else if (keyStr.contains(BgCslDimConstants.csl07)) {
            keyStr = keyStr.replaceAll(BgCslDimConstants.csl07, cslNumber);
        } else if (keyStr.contains(BgCslDimConstants.csl08)) {
            keyStr = keyStr.replaceAll(BgCslDimConstants.csl08, cslNumber);
        }
        return keyStr;
    }

    private void replaceCslMerger(NumberExpandExtInfo tmpExpandInfo, String cslNum, String cslName) {
        tmpExpandInfo.setName(cslName);
        tmpExpandInfo.setNumber(cslNum);
        tmpExpandInfo.setLongNumber(cslNum);
        IMember member = tmpExpandInfo.getMember();
        member.setName(cslName);
        member.setNumber(cslNum);
        member.setMdxNumber(cslNum);
    }

    protected void sortRowDims() {
        super.sortRowDims();
    }

    protected IDimDrillParameter getQueryParam(ICell cell, NumberExpandExtInfo expandInfo) throws Exception {
        ICell _cell = null;
        boolean hasOrgUnit = false;
        boolean hasPeriod = false;
        DimDrillParameter parameter = new DimDrillParameter();
        parameter.setUnionId((BOSUuid)this.getUIContext().get("UNION_ID"));
        parameter.setViewStates(this.getViewStates());
        if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(expandInfo.getDimension().getNumber())) {
            hasOrgUnit = true;
            parameter.setCurUnionOrgUnit(this.getQueryUnionOrgUnit(expandInfo));
            parameter.getQueryUnionOrgUnits().addAll(this.getQueryUnionOrgUnitNums(expandInfo));
        } else if (DimensionConstants.DEF_PERIOD_NUMBER.equals(expandInfo.getDimension().getNumber())) {
            parameter.setCurUnionOrgUnit((OrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO));
            parameter.getQueryUnionOrgUnits().addAll(this.getQueryUnionOrgUnitNums(null));
        } else {
            parameter.setCurUnionOrgUnit(this.getQueryUnionOrgUnit(cell));
        }
        if (DimensionConstants.DEF_PERIOD_NUMBER.equals(expandInfo.getDimension().getNumber())) {
            hasPeriod = true;
            parameter.getQueryPeriods().addAll(this.getQueryPeriodNums(expandInfo));
        } else {
            parameter.getQueryPeriods().addAll(this.getQueryPeriodNums());
        }
        if (!hasOrgUnit && !hasPeriod) {
            parameter.getQueryDimNumbers().addAll(this.getQueryDimNumbers(expandInfo));
        }
        parameter.setBgOrgViewId(BOSUuid.read((String)this.getOrgViewId()));
        parameter.setBgSchemeId(this.getBgSchemeId());
        parameter.setValueType(64);
        parameter.setBgVersion(this.getSelBgVersion());
        parameter.setPeriodStandardNumber(this.getDimDataQuery().getBizPeriod().getNumber());
        if (this.dimDataQuery != null) {
            parameter.setBgTemplateIds(new BOSUuid[]{this.dimDataQuery.getBizTemplateId()});
        }
        if (expandInfo.isHasDownward()) {
            int colCount = this.dimTable.getColumnCount();
            for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                int top;
                KDTMergeBlock mergeBlock = cell.getMergeBlock();
                if (null == mergeBlock) {
                    _cell = this.dimTable.getCell(cell.getRowIndex(), colIndex);
                    if (_cell == null || !(_cell.getUserObject() instanceof String)) continue;
                    parameter.getDimDatas().add((String)_cell.getUserObject());
                    continue;
                }
                int bottom = mergeBlock.getBottom();
                int mn = bottom;
                for (int m = top = mergeBlock.getTop(); m <= mn; ++m) {
                    _cell = this.dimTable.getCell(m, colIndex);
                    if (_cell == null || !(_cell.getUserObject() instanceof String)) continue;
                    parameter.getDimDatas().add((String)_cell.getUserObject());
                }
            }
        } else {
            int rowCount = this.dimTable.getRowCount();
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                _cell = this.dimTable.getCell(rowIndex, cell.getColumnIndex());
                if (_cell == null || !(_cell.getUserObject() instanceof String)) continue;
                parameter.getDimDatas().add((String)_cell.getUserObject());
            }
        }
        parameter.setCalcBiz(this.calcBizCheckBox.isSelected());
        parameter.setDimDataQuery(this.dimDataQuery);
        parameter.setQueryAllCSL(true);
        return parameter;
    }

    private NumberExpandExtInfo getOrgUnitExpandInfo(OrgUnitInfo orgUnitInfo, NumberExpandExtInfo parentInfo, int rowIndex, int colIndex) {
        if (orgUnitInfo == null) {
            return null;
        }
        NumberExpandExtInfo expandInfo = new NumberExpandExtInfo();
        expandInfo.setId(orgUnitInfo.getId().toString());
        String keyString = null;
        if (null == parentInfo) {
            expandInfo.setLevel(0);
        } else {
            keyString = this.getKeyString(rowIndex, colIndex, orgUnitInfo.getLongNumber());
            String currentLongNumber = orgUnitInfo.getLongNumber();
            int sepCount = currentLongNumber.split("!").length - 1;
            expandInfo.setLevel(sepCount);
            expandInfo.setDimension(parentInfo.getDimension());
            if (this.orgLongNumberMap.containsKey(this.getKeyString(rowIndex, colIndex, this.subStringLongnumber(currentLongNumber)))) {
                NumberExpandExtInfo parentExpandExtInfo = (NumberExpandExtInfo)this.orgLongNumberMap.get(this.getKeyString(rowIndex, colIndex, this.subStringLongnumber(currentLongNumber)));
                parentExpandExtInfo.setExpandStatus(true);
                parentExpandExtInfo.setHasExpendData(true);
            }
        }
        expandInfo.setLeaf(orgUnitInfo.isIsLeaf());
        expandInfo.setNumber(orgUnitInfo.getNumber());
        expandInfo.setName(orgUnitInfo.getName());
        expandInfo.setLongNumber(orgUnitInfo.getLongNumber());
        expandInfo.setObject((Object)orgUnitInfo);
        expandInfo.setExpandStatus(false);
        expandInfo.setHasDownward(true);
        expandInfo.setHasExpendData(false);
        DimensionObject dimension = new DimensionObject();
        dimension.setNumber(DimensionConstants.DEF_ORGUNIT_NUMBER);
        expandInfo.setDimension((IDimension)dimension);
        if (null == keyString) {
            return expandInfo;
        }
        if (!this.orgLongNumberMap.containsKey(keyString)) {
            this.orgLongNumberMap.put(keyString, expandInfo);
        } else if (!expandInfo.equals(this.orgLongNumberMap.get(keyString))) {
            this.orgLongNumberMap.put(keyString, expandInfo);
        }
        return expandInfo;
    }

    protected IDimDrillParameter getInitDrillParameter() {
        DimDrillParameter parameter = new DimDrillParameter();
        parameter.setViewStates(this.getViewStates());
        parameter.setHasInit(true);
        parameter.setBgSchemeId(this.getBgSchemeId());
        parameter.setBgVersion(this.getSelBgVersion());
        parameter.getDimDatas().addAll(this.getFormulas());
        if (this.getOrgViewId() != null) {
            parameter.setBgOrgViewId(BOSUuid.read((String)this.getOrgViewId()));
        }
        parameter.setValueType(64);
        parameter.setBgTemplateIds(new BOSUuid[]{this.getDimDataQuery().getBizTemplateId()});
        parameter.setPeriodStandardNumber(this.getDimDataQuery().getBizPeriod().getNumber());
        parameter.setCalcBiz(this.calcBizCheckBox.isSelected());
        parameter.setDimDataQuery(this.dimDataQuery);
        BOSUuid uuid = (BOSUuid)this.getUIContext().get("UNION_ID");
        parameter.setUnionId(uuid);
        parameter.setCurUnionOrgUnit((OrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO));
        return parameter;
    }

    protected String getCurrOrgUnitId(IDimDrillResult _result) {
        String orgUnitId;
        String string = orgUnitId = _result.getCurrUnionOrgUnit() != null ? _result.getCurrUnionOrgUnit().getId().toString() : null;
        if (null == orgUnitId && !_result.getSubUnionOrgUnits().isEmpty()) {
            orgUnitId = ((OrgUnitInfo)_result.getSubUnionOrgUnits().get(0)).getId().toString();
        }
        return orgUnitId;
    }

    protected Object formatCellDisplay(int rowIndex, int colIndex, ICell cell, Object value) {
        if (value instanceof BigDecimal) {
            if (this.displayProvider == null) {
                if (this.getUIContext().get("Owner") instanceof IBgCslViewListDisplayHelper) {
                    this.displayProvider = new BgCslViewListDispalyValueProvider((IBgCslViewListDisplayHelper)this.getUIContext().get("Owner"));
                } else if (this.getUIContext().get("Owner") instanceof IBgNumberCellDisplayHelper) {
                    this.displayProvider = new BgCslDisplayValueProvider((IBgCslDisplayHelper)this.getUIContext().get("Owner"));
                }
            }
            if (this.displayProvider != null && cell.getUserObject() instanceof String) {
                String formulaStr = cell.getUserObject().toString();
                String accountNumber = this.getAccountNumber(cell);
                value = this.displayProvider.getMeasureUnitMap().isEmpty() ? this.displayProvider.getMeasureUnitDisplayValue(cell, formulaStr, value, false, accountNumber) : this.displayProvider.getMeasureUnitDisplayValue(cell, formulaStr, value, true, accountNumber);
            }
            if (value == null) {
                if (this.getDecFormat() == null) {
                    IMember member = (IMember)this.curComboBox.getSelectedItem();
                    CurrencyInfo currency = (CurrencyInfo)this.getCurrencyMap().get(member.getNumber());
                    DecimalFormat decFormat = new DecimalFormat(BgNationalFormatUIUtil.getNumberFormat((int)currency.getPrecision()));
                    this.setDecFormat(decFormat);
                }
                value = this.decFormat.format(value);
            }
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void setIsLeafToExpandInfo(String dimNumber, NumberExpandExtInfo expandInfo, IRow row, String srcNumber) {
        block12: {
            if (!this.getResult().getLeafDataMap().containsKey(dimNumber)) {
                expandInfo.setLeaf(true);
                return;
            }
            if (DimensionConstants.DEF_INDEX_SRCNUMBER.equals(srcNumber)) {
                expandInfo.setLeaf(((Boolean)this.getResult().getLeafDataMap().get(dimNumber)).booleanValue());
                return;
            }
            Integer accIndex = (Integer)this.getDimIndexMap().get(DimensionConstants.DEF_INDEX_SRCNUMBER);
            NumberExpandExtInfo accExpandExtInfo = (NumberExpandExtInfo)row.getCell(accIndex.intValue()).getValue();
            String accDimNumber = accExpandExtInfo.getMember().getDimNumber();
            if (null != this.acc_DimNumbers && this.acc_DimNumbers.containsKey(accDimNumber)) {
                if (this.acc_DimNumbers.get(accDimNumber) == null || this.acc_DimNumbers.get(accDimNumber).isEmpty()) {
                    expandInfo.setLeaf(((Boolean)this.getResult().getLeafDataMap().get(dimNumber)).booleanValue());
                    return;
                }
            } else {
                if (null != this.specialDimCheckMap && this.specialDimCheckMap.containsKey(accDimNumber)) {
                    Map<String, Set<String>> specialDimSets = this.specialDimCheckMap.get(accDimNumber);
                    if (null != specialDimSets && specialDimSets.containsKey(expandInfo.getDimension().getNumber())) {
                        Set<String> numbers = specialDimSets.get(srcNumber);
                        if (null == numbers || numbers.isEmpty()) {
                            expandInfo.setLeaf(((Boolean)this.getResult().getLeafDataMap().get(dimNumber)).booleanValue());
                            return;
                        }
                        if (numbers.contains(expandInfo.getNumber())) {
                            expandInfo.setLeaf(false);
                            return;
                        }
                        expandInfo.setLeaf(true);
                        return;
                    }
                    expandInfo.setLeaf(true);
                    return;
                }
                expandInfo.setLeaf(true);
                return;
            }
            Set<String> nums = this.acc_DimNumbers.get(accDimNumber);
            Iterator<String> iterator = nums.iterator();
            while (iterator.hasNext()) {
                String childAccNumber = iterator.next();
                if (null != this.specialDimCheckMap && this.specialDimCheckMap.containsKey(childAccNumber)) {
                    Map<String, Set<String>> specialDimSets = this.specialDimCheckMap.get(childAccNumber);
                    if (null != specialDimSets && specialDimSets.containsKey(expandInfo.getDimension().getNumber())) {
                        expandInfo.setLeaf(((Boolean)this.getResult().getLeafDataMap().get(dimNumber)).booleanValue());
                        return;
                    }
                    expandInfo.setLeaf(true);
                    continue;
                }
                break block12;
            }
            return;
        }
        expandInfo.setLeaf(true);
    }

    protected boolean checkHideDim(String number, Map<String, Boolean> map) {
        return this.isOnlyOneMember(map) && !DimensionBaseConstants.DEF_ACCOUNT_NUMBER.equals(number) && !DimensionBaseConstants.DEF_CSL_NUMBER.equals(number);
    }

    protected void expandExtDimDatas(Set<Integer> rowIndexSet, IDimDrillResult _result, ICell _cell, NumberExpandExtInfo _expandInfo) throws BOSException {
        IRow row = null;
        IMember bgVer = this.getSelBgVersion();
        IMember sceneMember = (IMember)this.getScenComboBox().getSelectedItem();
        boolean isMuiltOrgUnit = _result.getSubOrgUnits().size() > 1;
        IRow pRow = this.dimTable.getRow(_cell.getRowIndex());
        ICell pCell = this.dimTable.getCell(pRow.getRowIndex(), this.getOrgUnitColIndex());
        NumberExpandExtInfo orgExpandInfo = (NumberExpandExtInfo)this.dimTable.getCell(pRow.getRowIndex(), this.getOrgUnitColIndex()).getValue();
        if (orgExpandInfo == null && pCell.getMergeBlock() != null) {
            KDTMergeBlock block = pCell.getMergeBlock();
            pCell = this.dimTable.getCell(block.getTop(), block.getLeft());
            orgExpandInfo = (NumberExpandExtInfo)pCell.getValue();
        }
        OrgUnitInfo orgUnitInfo = (OrgUnitInfo)orgExpandInfo.getObject();
        HashSet<String> csl01_RepeatKeys = new HashSet<String>();
        int in = _result.getSubDimNumbers().size();
        for (int i = 0; i < in; ++i) {
            IMember subMember = (IMember)_result.getSubDimNumbers().get(i);
            if (_expandInfo.getNumber().equals(subMember.getNumber())) continue;
            NumberExpandExtInfo subExpandInfo = this.getMemberExpandInfo(subMember, _expandInfo, _cell.getRowIndex(), _cell.getColumnIndex());
            if (_result.getLeafDataMap().containsKey(subMember.getDimNumber())) {
                subExpandInfo.setLeaf(((Boolean)_result.getLeafDataMap().get(subMember.getDimNumber())).booleanValue());
            } else {
                subExpandInfo.setLeaf(true);
            }
            int addRowCount = 0;
            if (BgAnalyseDrillTableHelper.isValidMerge((ICell)_cell)) {
                KDTMergeBlock mergeBlock = _cell.getMergeBlock();
                for (int j = mergeBlock.getTop(); j < mergeBlock.getBottom() + 1; ++j) {
                    if (this.dimTable.getRow(j).getStyleAttributes().isHided()) continue;
                    row = this.addSubRow(_cell, _expandInfo, subExpandInfo);
                    this.dealMerge4Dim(_cell, row, pRow, ++addRowCount, j, i + 1, _result, orgUnitInfo, bgVer, sceneMember, isMuiltOrgUnit, rowIndexSet, _expandInfo, subExpandInfo, false, csl01_RepeatKeys);
                }
                csl01_RepeatKeys.clear();
                continue;
            }
            row = this.addSubRow(_cell, _expandInfo, subExpandInfo);
            this.dealExtDim(_cell, row, pRow, ++addRowCount, _result, orgUnitInfo, bgVer, sceneMember, isMuiltOrgUnit, rowIndexSet, _expandInfo, subExpandInfo, false, csl01_RepeatKeys);
            csl01_RepeatKeys.clear();
        }
        _expandInfo.setHasExpendData(true);
        this.mergeCell();
    }

    private void dealExtDim(ICell _cell, IRow row, IRow pRow, int addRowCount, IDimDrillResult _result, OrgUnitInfo orgUnitInfo, IMember bgVer, IMember sceneMember, boolean isMuiltOrgUnit, Set<Integer> rowIndexSet, NumberExpandExtInfo _expandInfo, NumberExpandExtInfo subExpandInfo, boolean isExpandOrgUnit, Set<String> csl01_RepeatKeys) throws BOSException {
        this.fillAfterCurCol(_cell, row, pRow, addRowCount);
        this.fillBeforeCurCol(_cell, row, pRow);
        this.fillExtDimData(_cell, _result, orgUnitInfo, row, pRow, bgVer, sceneMember, isMuiltOrgUnit, rowIndexSet, _expandInfo, subExpandInfo, isExpandOrgUnit, csl01_RepeatKeys);
    }

    private void dealMerge4Dim(ICell _cell, IRow row, IRow pRow, int addRowCount, int mergeIndex, int subMemberIndex, IDimDrillResult _result, OrgUnitInfo orgUnitInfo, IMember bgVer, IMember sceneMember, boolean isMuiltOrgUnit, Set<Integer> rowIndexSet, NumberExpandExtInfo _expandInfo, NumberExpandExtInfo subExpandInfo, boolean isExpandOrgUnit, Set<String> csl01_RepeatKeys) throws BOSException {
        this.fillAfterCurCol4Merge(_cell, row, pRow, addRowCount, subMemberIndex);
        this.fillBeforeCurCol(_cell, row, pRow);
        IRow mergeRow = this.dimTable.getRow(mergeIndex);
        this.fillExtDimData(_cell, _result, orgUnitInfo, row, mergeRow, bgVer, sceneMember, isMuiltOrgUnit, rowIndexSet, _expandInfo, subExpandInfo, isExpandOrgUnit, csl01_RepeatKeys);
    }

    private void fillAfterCurCol(ICell _cell, IRow row, IRow pRow, int addRowCount) {
        int colCount = this.getBgPeriodColIndex();
        for (int colIndex = _cell.getColumnIndex() + 1; colIndex < colCount; ++colIndex) {
            ICell pCell = pRow.getCell(colIndex);
            ICell cell = row.getCell(colIndex);
            boolean isValidMerge = BgAnalyseDrillTableHelper.isValidMerge((ICell)pCell);
            if (pCell.getValue() instanceof NumberExpandExtInfo) {
                NumberExpandExtInfo tmpExpandInfo = (NumberExpandExtInfo)pCell.getValue();
                if (isValidMerge) {
                    if (addRowCount > 1) {
                        ICell lastCell = this.dimTable.getCell(row.getRowIndex() - 1, colIndex);
                        cell.setValue(lastCell.getValue());
                        continue;
                    }
                    cell.setValue((Object)tmpExpandInfo.clone(true));
                    continue;
                }
                cell.setValue((Object)tmpExpandInfo.clone(true));
                continue;
            }
            cell.setValue(pCell.getValue());
        }
    }

    private void fillBeforeCurCol(ICell _cell, IRow row, IRow pRow) {
        int colCount = _cell.getColumnIndex();
        for (int colIndex = 0; colIndex < colCount; ++colIndex) {
            ICell pCell = pRow.getCell(colIndex);
            ICell cell = row.getCell(colIndex);
            if (pCell.getValue() instanceof NumberExpandExtInfo) {
                NumberExpandExtInfo tmpExpandInfo = (NumberExpandExtInfo)pCell.getValue();
                cell.setValue((Object)tmpExpandInfo);
                continue;
            }
            cell.setValue(((ICell)pCell.clone()).getValue());
        }
    }

    private void fillAfterCurCol4Merge(ICell _cell, IRow row, IRow pRow, int addRowCount, int subMemberIndex) {
        KDTMergeBlock _mergeBlock = _cell.getMergeBlock();
        int cycle = _mergeBlock.getBottom() - _mergeBlock.getTop() + 1;
        int colCount = this.getBgPeriodColIndex();
        for (int colIndex = _cell.getColumnIndex() + 1; colIndex < colCount; ++colIndex) {
            IRow mergeRow = this.dimTable.getRow(pRow.getRowIndex() + addRowCount - 1);
            if (mergeRow.getStyleAttributes().isHided()) continue;
            ICell mergeCell = mergeRow.getCell(colIndex);
            KDTMergeBlock mergeBlock = this.getMergeBlock(mergeCell.getRowIndex(), mergeCell.getColumnIndex());
            boolean isValidMerge = BgAnalyseDrillTableHelper.isValidMerge((ICell)mergeCell);
            if (isValidMerge) {
                mergeCell = this.dimTable.getCell(mergeBlock.getTop(), mergeBlock.getLeft());
            }
            ICell cell = row.getCell(colIndex);
            if (mergeCell == null) continue;
            if (mergeCell.getValue() instanceof NumberExpandExtInfo) {
                NumberExpandExtInfo tmpExpandInfo = (NumberExpandExtInfo)mergeCell.getValue();
                if (isValidMerge) {
                    if (cell.getRowIndex() - cycle * subMemberIndex == mergeBlock.getTop()) {
                        cell.setValue((Object)tmpExpandInfo.clone(true));
                        continue;
                    }
                    ICell lastCell = this.dimTable.getCell(row.getRowIndex() - 1, colIndex);
                    cell.setValue(((ICell)lastCell.clone()).getValue());
                    continue;
                }
                cell.setValue((Object)tmpExpandInfo.clone(true));
                continue;
            }
            cell.setValue(((ICell)mergeCell.clone()).getValue());
        }
    }

    private IRow addSubRow(ICell _cell, NumberExpandExtInfo _expandInfo, NumberExpandExtInfo subExpandInfo) {
        int insertRowIndex = this.getInsertRowIndex(_cell.getRowIndex(), _cell.getColumnIndex(), _expandInfo);
        IRow row = this.dimTable.addRow(insertRowIndex);
        row.getCell(_cell.getColumnIndex()).setValue((Object)subExpandInfo);
        return row;
    }

    protected void setBgDimCellQuerySetInfo() {
        super.setBgDimCellQuerySetInfo();
        KDBizPromptBox cslPrmt = this.getCslPrmt();
        MbgViewListResultData data = (MbgViewListResultData)cslPrmt.getData();
        List members = data.getMembers();
        StringBuffer str = new StringBuffer();
        int in = members.size();
        for (int i = 0; i < in; ++i) {
            BgDimensionMember member = (BgDimensionMember)members.get(i);
            str.append(member.getNumber()).append(",");
        }
        this.getBgDimCellQuerySetInfo().setCslSet(str.substring(0, str.length() - 1));
    }
}

