/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCodeNumberCHelper;
import com.kingdee.eas.ma.base.utils.BgCodeNumberHelper;
import com.kingdee.eas.ma.bgcsl.BgCslAdjFormInfo;
import com.kingdee.eas.ma.bgcsl.BgCslElimEntryCollection;
import com.kingdee.eas.ma.bgcsl.BgCslElimEntryInfo;
import com.kingdee.eas.ma.bgcsl.BgCslElimFactory;
import com.kingdee.eas.ma.bgcsl.BgCslElimInfo;
import com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryTemplateEntryCollection;
import com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryTemplateEntryFactory;
import com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryTemplateEntryInfo;
import com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryTemplateInfo;
import com.kingdee.eas.ma.bgcsl.ElimStatusEnum;
import com.kingdee.eas.ma.bgcsl.ElimTypeEnum;
import com.kingdee.eas.ma.bgcsl.client.AbstractBgCslElimEditUI;
import com.kingdee.eas.ma.bgcsl.client.BgCslElimListUI;
import com.kingdee.eas.ma.bgcsl.client.BgFormulaSelector;
import com.kingdee.eas.ma.bgcsl.client.DimensionMemberDialog;
import com.kingdee.eas.ma.bgcsl.client.utils.BgCslElimDimensionHelper;
import com.kingdee.eas.ma.bgcsl.common.BgCslElimHelper;
import com.kingdee.eas.ma.bgcsl.excel.budget.BgCslAdjCalculateContext;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.MBgAdjustConstants;
import com.kingdee.eas.ma.mbg.client.BgNFormListUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgDimensionMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgCellRenderHelper;
import com.kingdee.eas.ma.mbg.utils.BgNExpressionHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JTextField;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.log4j.Logger;

public class BgCslElimEditUI
extends AbstractBgCslElimEditUI {
    private static final long serialVersionUID = 1311988979848016987L;
    private static final Logger logger = CoreUIObject.getLogger(BgCslElimEditUI.class);
    private boolean isFireTemplateDataChange = true;
    public static int precision = 2;
    public static final String RESOURCE = "com.kingdee.eas.ma.bgcsl.BgCslElimResource";
    private BgCodeNumberHelper codeHelper = new BgCodeNumberHelper(null, null, null);
    private KDTDefaultCellEditor defNumEditor = null;
    Map<String, Object> calcResult = null;

    @Override
    public void onLoad() throws Exception {
        if (OprtState.EDIT.equals(this.getOprtState())) {
            this.isFireTemplateDataChange = false;
        }
        super.onLoad();
        this.btnAuditResult.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.MenuItemAttachment.setVisible(false);
        this.setButtonEnable();
        this.isFireTemplateDataChange = true;
        this.btnRiskInsight.setVisible(false);
        this.actionPre.setEnabled(false);
    }

    public void onShow() throws Exception {
        if (this.editData.getAuditTime() == null) {
            this.dateAuditTime.setValue(null);
        }
        super.onShow();
        if (this.codeHelper.isHasCodeNumber() && this.codeHelper.isHasShowCodeNumber() && !StringUtils.isEmpty((String)this.txtNumber.getText())) {
            this.txtNumber.setEnabled(false);
        }
    }

    @Override
    protected void loadData() throws Exception {
        super.loadData();
        this.applyCodeNumber();
    }

    protected void applyCodeNumber() {
        BgCslElimInfo info = (BgCslElimInfo)this.getEditData();
        this.initCodeHelper();
        if ((OprtState.ADDNEW.equals(this.getOprtState()) || OprtState.COPYADDNEW.equals(this.getOprtState())) && info.getNumber() == null) {
            CtrlUnitInfo cu = new CtrlUnitInfo();
            if (this.getCurrentCUID() != null) {
                cu.setId(BOSUuid.read((String)this.getCurrentCUID()));
            }
            if (cu.getId() != null) {
                this.editData.setCU(cu);
            }
            this.getNumberByCodingRule((IObjectValue)this.editData, info.getOrgUnit().getId().toString());
        }
    }

    protected void initCodeHelper() {
        BgCslElimInfo info = (BgCslElimInfo)this.getEditData();
        String orgId = info.getOrgUnit().getId().toString();
        try {
            this.codeHelper.init((IObjectValue)this.getEditData(), orgId);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort(e);
        }
    }

    protected void getNumberByCodingRule(IObjectValue caller, String orgId) {
        try {
            BgCodeNumberCHelper.getNumberByCodingRule((KDTextField)this.txtNumber, (IObjectValue)caller, (String)orgId, (BgCodeNumberHelper)this.codeHelper);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIException(e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIException(e);
        }
    }

    @Override
    protected void init() throws EASBizException, BOSException {
        super.init();
        this.initTemplate();
        this.initDimensionMember();
        this.initEntry();
        this.setPrecision();
    }

    private void initTemplate() {
        OrgTreeInfo orgTree = (OrgTreeInfo)this.getUIContext().get("orgTreeInfo");
        FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO);
        BgSchemeInfo bgScheme = this.getBgSchemeInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("elimType");
        sic.add("currency");
        sic.add("bgVersion");
        sic.add("bgScenario");
        sic.add("bgElement");
        sic.add("bgElement");
        sic.add("bgPeriod");
        sic.add("memberCombinNumber");
        sic.add("memberCombinName");
        sic.add("memberCombinRef");
        sic.add("Description");
        sic.add("entries.summary");
        sic.add("entries.indexMemberName");
        sic.add("entries.indexMemberNumber");
        sic.add("entries.indexMemberRef");
        sic.add("entries.memberCombinNumber");
        sic.add("entries.memberCombinName");
        sic.add("entries.memberCombinRef");
        sic.add("entries.creditAmount");
        sic.add("entries.debitAmount");
        sic.add("entries.debitFormula");
        sic.add("entries.creditFormula");
        this.prmtTemplate.setSelectorCollection(sic);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgScheme.getId().toString()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("orgTree.id", (Object)orgTree.getId().toString()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnit.getId().toString()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("templateStatus", (Object)0, CompareType.EQUALS));
        this.prmtTemplate.setEntityViewInfo(evi);
    }

    protected void initDimensionMember() throws EASBizException, BOSException {
        ArrayList<String> entryDim = new ArrayList<String>();
        KDTable table = this.getDetailTable();
        for (int i = 0; i < table.getRowCount(); ++i) {
            if (table.getCell(i, "mbgMember").getValue() instanceof MbgDimensionMember) {
                MbgDimensionMember member = (MbgDimensionMember)table.getCell(i, "mbgMember").getValue();
                if (null == member) continue;
                entryDim.add(member.getNumber());
                continue;
            }
            BgCslElimInfo info = this.editData;
            BgCslElimEntryCollection entries = info.getEntries();
            BgCslElimEntryInfo entry = new BgCslElimEntryInfo();
            entry = entries.get(i);
            if (null == table.getCell(i, "mbgMember").getValue()) continue;
            entryDim.add(entry.getMemberCombinNumber());
        }
        MbgDimensionMember dimMember = null;
        dimMember = this.prmtMbgMember.getValue() != null ? (MbgDimensionMember)this.prmtMbgMember.getValue() : null;
        DimensionMemberDialog dialog = new DimensionMemberDialog((CoreUI)this, this.getBgSchemeId(), ((OrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO)).getId().toString(), entryDim, dimMember);
        dialog.setOrgTreeId(((OrgTreeInfo)this.getUIContext().get("orgTreeInfo")).getId().toString());
        dialog.setCheckSpeicalDim(true);
        this.prmtMbgMember.setSelector((KDPromptSelector)dialog);
    }

    protected void initEntry() throws EASBizException, BOSException {
        KDTable table = this.getDetailTable();
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.addLine(table);
            this.addLine(table);
        }
        if (this.getSchemeHelper() != null) {
            table.getColumn("bgAccount").setRenderer((IBasicRender)this.getCellHelper().getOVRender(this.getSchemeHelper().getDimension(DimensionConstants.DEF_ACCOUNT_NUMBER).getViewId()));
            table.getColumn("bgAccount").setRenderer((IBasicRender)BgCellRenderHelper.getMemberComRender());
        }
    }

    public void setPrecision() {
        KDTable table = this.getDetailTable();
        KDFormattedTextField amountformatedTxtField = new KDFormattedTextField();
        amountformatedTxtField.setDataType(1);
        amountformatedTxtField.setPrecision(precision);
        String numFormatStr = BgNationalFormatUIUtil.getFormatStringForTable((int)precision);
        table.getColumn("creditAmount").setEditor((ICellEditor)this.getDefNumEditor());
        table.getColumn("debitAmount").setEditor((ICellEditor)this.getDefNumEditor());
        table.getColumn("creditAmount").getStyleAttributes().setNumberFormat(numFormatStr);
        table.getColumn("debitAmount").getStyleAttributes().setNumberFormat(numFormatStr);
    }

    protected KDTDefaultCellEditor getDefNumEditor() {
        if (this.defNumEditor == null) {
            this.defNumEditor = this.getNumberEditor(this.getCurrencyInfo());
        }
        return this.defNumEditor;
    }

    protected KDTDefaultCellEditor getNumberEditor(CurrencyInfo currency) {
        KDFormattedTextField kdfTextField = new KDFormattedTextField();
        kdfTextField.setDataType(1);
        kdfTextField.setPrecision(precision);
        kdfTextField.setSupportedEmpty(true);
        kdfTextField.setNegatived(true);
        return new MyCellEditor((JTextField)kdfTextField);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.loadprmtMbgMember();
        this.loadEntryFields();
        this.setPrmtEditable(false);
    }

    private void loadprmtMbgMember() {
        BgCslElimInfo info = this.editData;
        MbgDimensionMember dimMember = null;
        BgCslElimDimensionHelper helper = new BgCslElimDimensionHelper();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            try {
                dimMember = helper.assembleDefaultMbgDimMember(this.getBgSchemeId());
                if (info != null && dimMember != null) {
                    info.setMemberCombinName(dimMember.getDAndMName());
                    info.setMemberCombinNumber(dimMember.getNumber());
                    info.setMemberCombinRef(dimMember.getAttribute());
                }
            }
            catch (EASBizException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
        } else if (info != null && !StringUtils.isEmpty((String)info.getMemberCombinName())) {
            dimMember = helper.assembleMbgDimensionMember(info.getMemberCombinNumber(), info.getMemberCombinName(), info.getMemberCombinRef(), this.getBgSchemeId());
        }
        this.prmtMbgMember.setValue((Object)dimMember);
    }

    private void loadEntryFields() {
        BgCslElimEntryCollection entries = this.editData.getEntries();
        KDTable table = this.getDetailTable();
        MbgDimensionMember dimMember = null;
        BgCslElimEntryInfo entryInfo = null;
        this.expressionParseBefore();
        for (int i = 0; i < entries.size(); ++i) {
            String creditFormula;
            String debitFormula;
            entryInfo = entries.get(i);
            BgCslElimDimensionHelper helper = new BgCslElimDimensionHelper();
            if (!StringUtils.isEmpty((String)entryInfo.getMemberCombinName())) {
                dimMember = helper.assembleMbgDimensionMember(entryInfo.getMemberCombinNumber(), entryInfo.getMemberCombinName(), entryInfo.getMemberCombinRef(), this.getBgSchemeId());
                table.getCell(entries.get(i).getSeq() - 1, "mbgMember").setValue((Object)dimMember);
                table.getCell(entries.get(i).getSeq() - 1, "mbgMember").setUserObject((Object)dimMember);
            }
            if (!StringUtils.isEmpty((String)entryInfo.getIndexMemberNumber())) {
                BgDimensionMember member = helper.assembleBgAccountMember(entryInfo.getIndexMemberNumber(), entryInfo.getIndexMemberName(), this.getBgSchemeId());
                table.getCell(entryInfo.getSeq() - 1, "bgAccount").setValue((Object)member);
                table.getCell(entryInfo.getSeq() - 1, "bgAccount").setUserObject((Object)member);
            }
            if (!StringUtils.isEmpty((String)(debitFormula = entryInfo.getDebitFormula()))) {
                debitFormula = BgNExpressionHelper.checkExpression(null, (String)debitFormula, (String)this.getOrgBound().getNumber());
                table.getRow(entryInfo.getSeq() - 1).getCell("debitAmount").setUserObject((Object)debitFormula);
            }
            if (!StringUtils.isEmpty((String)(creditFormula = entryInfo.getCreditFormula()))) {
                creditFormula = BgNExpressionHelper.checkExpression(null, (String)creditFormula, (String)this.getOrgBound().getNumber());
                table.getRow(entryInfo.getSeq() - 1).getCell("creditAmount").setUserObject((Object)creditFormula);
            }
            this.initEntryBgDimMember(table.getRow(i));
            this.initBgAccountDialog(i);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.afterStoreFields();
    }

    protected void afterStoreFields() {
        BgCslElimInfo info = null;
        info = this.editData;
        BgCslElimEntryInfo entry = null;
        IRow row = null;
        BgDimensionMember bgIndexMember = null;
        BgCslElimEntryCollection entries = info.getEntries();
        this.saveBgMember(info);
        int rowCount = this.getDetailTable().getRowCount();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            entry = entries.get(rowIndex);
            row = this.getDetailTable().getRow(rowIndex);
            this.getBgAccount(row, bgIndexMember, entry);
            this.saveEntryBgMember(row, entry);
        }
        UserInfo editor = SysContext.getSysContext().getCurrentUserInfo();
        info.setLastUpdateUser(editor);
        this.editData = info;
        try {
            this.fillCalcCDAmount();
        }
        catch (Exception e) {
            logger.error((Object)"BgCslElimEditUI fillCalcCDAmount error", (Throwable)e);
        }
    }

    protected void saveBgMember(BgCslElimInfo info) {
        if (this.prmtMbgMember.getValue() instanceof MbgDimensionMember) {
            MbgDimensionMember member = (MbgDimensionMember)this.prmtMbgMember.getValue();
            if (null != member) {
                info.setMemberCombinNumber(member.getNumber());
                info.setMemberCombinName(member.getDAndMName());
                info.setMemberCombinRef(member.getAttribute());
            } else {
                info.setMemberCombinNumber(null);
                info.setMemberCombinName(null);
                info.setMemberCombinRef(null);
            }
        } else {
            info.setMemberCombinNumber(null);
            info.setMemberCombinName(null);
            info.setMemberCombinRef(null);
        }
    }

    protected void saveEntryBgMember(IRow row, BgCslElimEntryInfo info) {
        if (row.getCell("mbgMember").getValue() instanceof MbgDimensionMember) {
            MbgDimensionMember member;
            MbgDimensionMember dim = member = (MbgDimensionMember)row.getCell("mbgMember").getValue();
            if (null != member) {
                info.setMemberCombinNumber(dim.getNumber());
                info.setMemberCombinName(dim.getName());
                info.setMemberCombinRef(dim.getAttribute());
            }
        }
    }

    protected void getBgAccount(IRow row, BgDimensionMember bgIndexMember, BgCslElimEntryInfo entry) {
        if (row == null) {
            return;
        }
        ArrayList list = new ArrayList();
        if (row.getCell("bgAccount").getValue() instanceof ArrayList) {
            list = (ArrayList)row.getCell("bgAccount").getValue();
            bgIndexMember = (BgDimensionMember)list.get(0);
        } else if (row.getCell("bgAccount").getValue() instanceof BgDimensionMember) {
            bgIndexMember = (BgDimensionMember)row.getCell("bgAccount").getValue();
        }
        if (bgIndexMember != null) {
            entry.setIndexMemberNumber(MBgAdjustConstants.getDimNumber((BgDimensionMember)bgIndexMember));
            entry.setIndexMemberName(bgIndexMember.getName());
            entry.setIndexMemberRef(bgIndexMember.getAttribute());
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.loadData();
        this.init();
        this.initDimensionMember();
        this.initEntry();
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        if (!BgCodeNumberCHelper.hasCodeNumber((IObjectValue)this.getEditData(), (String)this.getOrgUnitInfo().getId().toString())) {
            this.txtNumber.setText(null);
        } else {
            this.editData.setNumber(null);
            this.applyCodeNumber();
        }
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.setButtonEnable();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.setButtonEnable();
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.addLine(this.getDetailTable());
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.isFireTemplateDataChange = false;
        this.checkNull();
        super.actionSave_actionPerformed(e);
        this.refreshOwerUI();
    }

    protected void doBeforeSave(ActionEvent e) throws Exception {
        super.doBeforeSave(e);
        this.checkEntryFormula();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        this.checkNull();
        IRow row = null;
        int size = this.getDetailTable().getRowCount();
        for (int index = 0; index < size; ++index) {
            row = this.getDetailTable().getRow(index);
            if (null == row.getCell("bgAccount").getValue()) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"bgAccountIsNUll", (Object[])new String[]{String.valueOf(++index)}));
                SysUtil.abort();
            }
            if (row.getCell("summary").getValue() == null || String.valueOf(row.getCell("summary").getValue()).length() <= 512) continue;
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryResource", (String)"summaryOverMax", (Object[])new String[]{String.valueOf(++index)}));
            SysUtil.abort();
        }
        BgCslElimInfo info = this.editData;
        BgCslElimEntryCollection entries = info.getEntries();
        if (entries.size() < 1) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getString("entriesIsNull"));
            SysUtil.abort();
        }
        this.checkEntry();
        this.checkEntrySpeicalDim();
    }

    protected void chcekNull() {
        this.checkTxtNumberNull();
        this.checkOffsetTypeNull();
    }

    protected void checkTxtNumberNull() {
        if (this.codeHelper.isHasCodeNumber()) {
            if (this.codeHelper.isHasShowCodeNumber() && StringUtils.isEmpty((String)this.txtNumber.getText())) {
                this.txtNumber.requestFocus();
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"numberisnull"));
                SysUtil.abort();
            }
        } else if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            this.txtNumber.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)this.getString("numberisnull"));
            SysUtil.abort();
        }
    }

    protected void checkNull() {
        this.checkTxtNumberNull();
        this.checkCurrencyNull();
        this.checkBgElementNull();
        this.checkBgPeriodNull();
        this.checkBgScenarioNull();
        this.checkBgVersionNull();
    }

    public void checkEntry() throws EASBizException, BOSException {
        if (this.editData.getEntries().size() < 1) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getString("entriesIsNull"));
            SysUtil.abort();
        }
        KDTable table = this.getDetailTable();
        for (int i = 0; i < table.getRowCount(); ++i) {
            this.checkEntryDimMember(table, i);
        }
    }

    private void checkEntryFormula() {
        KDTable table = this.getDetailTable();
        for (int i = 0; i < table.getRowCount(); ++i) {
            Object credit = table.getCell(i, "creditAmount").getValue();
            Object debit = table.getCell(i, "debitAmount").getValue();
            String creditCalc = StringUtils.cnulls((Object)table.getCell(i, "creditAmount").getUserObject());
            String debitCalc = StringUtils.cnulls((Object)table.getCell(i, "debitAmount").getUserObject());
            if (null == debit && credit == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"formulaIsNull", (Object[])new String[]{String.valueOf(++i)}));
                SysUtil.abort();
            }
            if (credit == null && StringUtils.isEmpty((String)creditCalc) || debit == null && StringUtils.isEmpty((String)debitCalc)) continue;
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"valueAllIsNotNull", (Object[])new String[]{String.valueOf(++i)}));
            SysUtil.abort();
        }
    }

    private void refreshOwerUI() throws Exception {
        if (this.getUIContext().get("Owner") instanceof BgCslElimListUI) {
            ((BgCslElimListUI)this.getUIContext().get("Owner")).refreshList();
        }
    }

    @Override
    protected void prmtTemplate_willShow(SelectorEvent e) throws Exception {
        super.prmtTemplate_willShow(e);
        this.isFireTemplateDataChange = true;
    }

    @Override
    protected void prmtTemplate_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.isFireTemplateDataChange) {
            return;
        }
        super.prmtTemplate_dataChanged(e);
        BgCslOffsetEntryTemplateInfo info = (BgCslOffsetEntryTemplateInfo)this.prmtTemplate.getData();
        if (null == info) {
            return;
        }
        BgCslElimDimensionHelper helper = new BgCslElimDimensionHelper();
        if (null != info.getElimType()) {
            this.cboOffsetType.setSelectedItem((Object)info.getElimType());
        }
        if (null != info.getCurrency()) {
            CurrencyInfo Currency2 = BgCslElimHelper.getCurrencyInfo(info.getCurrency().getId().toString());
            BgNFCHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)Currency2);
            precision = Currency2.getPrecision();
        }
        if (null != info.getBgVersion()) {
            BgVersionInfo version = BgCslElimHelper.getBgVersionInfo(info.getBgVersion().getId().toString());
            this.prmtBgVersion.setValue((Object)version);
        }
        if (null != info.getBgElement()) {
            BgElementInfo element = BgCslElimHelper.getBgElementInfo(info.getBgElement().getId().toString());
            this.prmtBgElement.setValue((Object)element);
        }
        if (null != info.getBgPeriod()) {
            BgPeriodInfo period = BgCslElimHelper.getBgPeriodInfo(info.getBgPeriod().getId().toString());
            this.prmtBgPeriod.setValue((Object)period);
        }
        if (null != info.getBgScenario()) {
            BgScenarioInfo scenario = BgCslElimHelper.getBgScenarioInfo(info.getBgScenario().getId().toString());
            this.prmtBgScenario.setValue((Object)scenario);
        }
        if (!StringUtils.isEmpty((String)info.getDescription())) {
            this.txtDescription.setText(info.getDescription());
        }
        if (!StringUtils.isEmpty((String)info.getMemberCombinName())) {
            MbgDimensionMember dimMember = null;
            String attribute = info.getMemberCombinRef();
            String name = info.getMemberCombinName();
            String number = info.getMemberCombinNumber();
            dimMember = helper.assembleMbgDimensionMember(number, name, attribute, this.getBgSchemeId());
            this.prmtMbgMember.setValue((Object)dimMember);
        } else {
            this.prmtMbgMember.setValue(null);
        }
        this.setEntryByTemplate(this.getTemplateEntries());
    }

    private void setEntryByTemplate(BgCslOffsetEntryTemplateEntryCollection entries) throws Exception {
        KDTable table = this.getDetailTable();
        int tcount = table.getRowCount();
        table.addRows(entries.size() - tcount);
        this.expressionParseBefore();
        for (int i = 0; i < entries.size(); ++i) {
            String creditFormula;
            String debitFormula;
            BgCslOffsetEntryTemplateEntryInfo entry = entries.get(i);
            if (!StringUtils.isEmpty((String)entry.getSummary())) {
                table.getRow(i).getCell("summary").setValue((Object)entry.getSummary());
            }
            if (!StringUtils.isEmpty((String)entry.getIndexMemberNumber()) && !StringUtils.isEmpty((String)entry.getIndexMemberName()) && entry.getIndexMemberNumber().contains(":")) {
                String[] arr = entry.getIndexMemberNumber().split(":");
                BgDimensionMember account = new BgDimensionMember("BG_Account", entry.getIndexMemberRef(), entry.getIndexMemberName(), arr[1]);
                account.setSrcNumber(arr[0]);
                table.getRow(i).getCell("bgAccount").setValue((Object)account);
            }
            if (!StringUtils.isEmpty((String)entry.getMemberCombinNumber()) && !StringUtils.isEmpty((String)entry.getMemberCombinName())) {
                BgCslElimDimensionHelper helper = new BgCslElimDimensionHelper();
                String number = entry.getMemberCombinNumber();
                String name = entry.getMemberCombinName();
                String attribute = entry.getMemberCombinRef();
                MbgDimensionMember dimMember = helper.assembleMbgDimensionMember(number, name, attribute, this.getBgSchemeId());
                table.getRow(i).getCell("mbgMember").setValue((Object)dimMember);
            }
            if (!StringUtils.isEmpty((String)(debitFormula = entry.getDebitFormula()))) {
                debitFormula = BgNExpressionHelper.checkExpression(null, (String)debitFormula, (String)this.getOrgBound().getNumber());
                table.getRow(i).getCell("debitAmount").setUserObject((Object)debitFormula);
            }
            if (StringUtils.isEmpty((String)(creditFormula = entry.getCreditFormula()))) continue;
            creditFormula = BgNExpressionHelper.checkExpression(null, (String)creditFormula, (String)this.getOrgBound().getNumber());
            table.getRow(i).getCell("creditAmount").setUserObject((Object)creditFormula);
        }
    }

    public void initEntryFormula(KDTable table) {
        for (int rowIndex = 0; rowIndex < table.getRowCount(); ++rowIndex) {
            if (null != table.getRow(rowIndex).getCell("creditAmount").getValue()) {
                table.getRow(rowIndex).getCell("debitAmount").getStyleAttributes().setLocked(true);
                continue;
            }
            if (null == table.getRow(rowIndex).getCell("debitAmount").getValue()) continue;
            table.getRow(rowIndex).getCell("creditAmount").getStyleAttributes().setLocked(true);
        }
        KDPromptBox prmtBoxD = new KDPromptBox();
        prmtBoxD.setSelector((KDPromptSelector)new BgFormulaSelector((CoreUIObject)this, 5));
        prmtBoxD.setEditable(true);
        KDTDefaultCellEditor formulaEditor = new KDTDefaultCellEditor((IKDEditor)prmtBoxD);
        table.getColumn("creditAmount").setEditor((ICellEditor)formulaEditor);
        table.getColumn("debitAmount").setEditor((ICellEditor)formulaEditor);
        table.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                BgCslElimEditUI.this.fillFormula(e);
            }
        });
    }

    @Override
    protected void kdtEntries_tableClicked(KDTMouseEvent e) throws Exception {
        super.kdtEntries_tableClicked(e);
        int rowIndex = e.getRowIndex();
        if (rowIndex < 0) {
            return;
        }
    }

    private void fillFormula(KDTActiveCellEvent e) {
        int rowIndex = e.getRowIndex();
        if (rowIndex > this.getDetailTable().getRowCount() || rowIndex < 0) {
            return;
        }
        this.putClientProperty("clientProperty_formula_credit", null);
        int colIndex = e.getColumnIndex();
        Object formulaObj = this.getDetailTable().getRow(rowIndex).getCell(colIndex).getValue();
        if (formulaObj != null && formulaObj.toString().trim().length() > 0) {
            this.putClientProperty("clientProperty_formula_credit", formulaObj.toString());
        }
    }

    protected String getString(String key) {
        return EASResource.getString((String)RESOURCE, (String)key);
    }

    @Override
    protected void kdtEntries_editStopped(KDTEditEvent e) throws Exception {
        String formula;
        this.lockAmount(e.getRowIndex(), e.getColIndex());
        String colKey = this.kdtEntries.getColumnKey(e.getColIndex());
        if (("creditAmount".equals(colKey) || "debitAmount".equals(colKey)) && !StringUtils.isEmpty((String)(formula = StringUtils.cnulls((Object)this.kdtEntries.getCell(e.getRowIndex(), e.getColIndex()).getUserObject())))) {
            BigDecimal newValue = this.convertToBigDecimal(e.getValue());
            BigDecimal oldValue = this.convertToBigDecimal(e.getOldValue());
            if (e.getOldValue() != e.getValue() && (newValue == null || oldValue == null || newValue.compareTo(oldValue) != 0)) {
                this.kdtEntries.getCell(e.getRowIndex(), e.getColIndex()).setUserObject(null);
            }
        }
    }

    private BigDecimal convertToBigDecimal(Object value) {
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        try {
            return new BigDecimal(value.toString());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected void cboCurrency_itemStateChanged(ItemEvent e) throws Exception {
        CurrencyInfo curr = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        if (curr != null) {
            precision = curr.getPrecision();
            this.setPrecision();
        }
        this.expressionParseBefore();
    }

    private List<String> getEntryDim() {
        ArrayList<String> entryDim = new ArrayList<String>();
        KDTable table = this.getDetailTable();
        BgCslElimInfo info = this.editData;
        BgCslElimEntryCollection entries = info.getEntries();
        for (int i = 0; i < table.getRowCount(); ++i) {
            if (table.getCell(i, "mbgMember").getValue() instanceof MbgDimensionMember) {
                MbgDimensionMember member = (MbgDimensionMember)table.getCell(i, "mbgMember").getValue();
                if (null == member) continue;
                entryDim.add(member.getNumber());
                continue;
            }
            BgCslElimEntryInfo entry = entries.get(i);
            if (null == table.getCell(i, "mbgMember").getValue()) continue;
            entryDim.add(entry.getMemberCombinNumber());
        }
        return entryDim;
    }

    @Override
    protected void prmtMbgMember_willShow(SelectorEvent e) throws Exception {
        super.prmtMbgMember_willShow(e);
        Object obj = e.getSource();
        if (obj == null || !(obj instanceof KDBizPromptBox)) {
            return;
        }
        KDBizPromptBox box = (KDBizPromptBox)obj;
        MbgDimensionMember dimMember = null;
        if (box.getData() instanceof MbgDimensionMember) {
            dimMember = (MbgDimensionMember)box.getData();
        }
        List<String> entryDim = this.getEntryDim();
        if (box.getSelector() instanceof DimensionMemberDialog) {
            ((DimensionMemberDialog)box.getSelector()).setHeadDim(entryDim);
            ((DimensionMemberDialog)box.getSelector()).setDimMember(dimMember);
        }
    }

    protected IObjectValue createNewData() {
        BgCslElimInfo info = new BgCslElimInfo();
        info.setOrgUnit((FullOrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO));
        info.setBgScheme(this.getBgSchemeInfo());
        info.setOrgTree(this.getOrgTree());
        info.setElimType(ElimTypeEnum.ComeAndGo);
        UserInfo CurrentUser = SysContext.getSysContext().getCurrentUserInfo();
        info.setCreator(CurrentUser);
        info.setLastUpdateUser(CurrentUser);
        info.setStatus(ElimStatusEnum.UNAUDITED);
        return info;
    }

    protected FullOrgUnitInfo getOrgBound() {
        return (FullOrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO);
    }

    protected OrgTreeInfo getOrgTree() {
        return (OrgTreeInfo)this.getUIContext().get("orgTreeInfo");
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        BgCslElimEntryInfo info = new BgCslElimEntryInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgCslElimFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("bgScheme.id"));
        sic.add(new SelectorItemInfo("orgTree.id"));
        sic.add(new SelectorItemInfo("orgTree.number"));
        sic.add(new SelectorItemInfo("orgTree.name"));
        sic.add(new SelectorItemInfo("memberCombinNumber"));
        sic.add(new SelectorItemInfo("memberCombinRef"));
        sic.add(new SelectorItemInfo("memberCombinName"));
        sic.add(new SelectorItemInfo("entries.indexMemberNumber"));
        sic.add(new SelectorItemInfo("entries.indexMemberName"));
        sic.add(new SelectorItemInfo("entries.indexMemberRef"));
        sic.add(new SelectorItemInfo("entries.memberCombinNumber"));
        sic.add(new SelectorItemInfo("entries.memberCombinName"));
        sic.add(new SelectorItemInfo("entries.memberCombinRef"));
        sic.add(new SelectorItemInfo("entries.seq"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        return sic;
    }

    public SelectorItemCollection getBaseEntrySelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("summary"));
        sic.add(new SelectorItemInfo("indexMemberNumber"));
        sic.add(new SelectorItemInfo("indexMemberName"));
        sic.add(new SelectorItemInfo("indexMemberRef"));
        sic.add(new SelectorItemInfo("memberCombinNumber"));
        sic.add(new SelectorItemInfo("memberCombinName"));
        sic.add(new SelectorItemInfo("memberCombinRef"));
        sic.add(new SelectorItemInfo("debitAmount"));
        sic.add(new SelectorItemInfo("debitFormula"));
        sic.add(new SelectorItemInfo("creditAmount"));
        sic.add(new SelectorItemInfo("creditFormula"));
        sic.add(new SelectorItemInfo("seq"));
        return sic;
    }

    protected BgCslOffsetEntryTemplateEntryCollection getTemplateEntries() throws BOSException {
        BgCslOffsetEntryTemplateInfo templateInfo = this.getTemplateInfo();
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getBaseEntrySelectors());
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("parent.id", (Object)templateInfo.getId().toString(), CompareType.EQUALS));
        BgCslOffsetEntryTemplateEntryCollection entries = BgCslOffsetEntryTemplateEntryFactory.getRemoteInstance().getBgCslOffsetEntryTemplateEntryCollection(view);
        entries.sort("seq");
        return entries;
    }

    protected BgCslOffsetEntryTemplateInfo getTemplateInfo() {
        Object obj = this.prmtTemplate.getData();
        BgCslOffsetEntryTemplateInfo templateInfo = null;
        if (obj instanceof BgCslOffsetEntryTemplateInfo) {
            templateInfo = (BgCslOffsetEntryTemplateInfo)obj;
        } else if (obj instanceof BgCslOffsetEntryTemplateInfo[]) {
            templateInfo = ((BgCslOffsetEntryTemplateInfo[])obj)[0];
        }
        return templateInfo;
    }

    protected void fillCalcCDAmount() throws Exception {
        this.calcResult = this.calcTemplateEntries(this.getTemplateEntries());
        int tcount = this.getDetailTable().getRowCount();
        IRow row = null;
        Object cellValue = null;
        String cellObj = null;
        for (int index = 0; index < tcount; ++index) {
            row = this.getDetailTable().getRow(index);
            cellValue = row.getCell("creditAmount").getValue();
            String string = cellObj = row.getCell("creditAmount").getUserObject() != null ? String.valueOf(row.getCell("creditAmount").getUserObject()) : null;
            if (!StringUtils.isEmpty(cellObj) && this.calcResult.containsKey("=" + cellObj)) {
                row.getCell("creditAmount").setValue(this.calcResult.get("=" + cellObj));
                if (row.getUserObject() instanceof BgCslElimEntryInfo) {
                    ((BgCslElimEntryInfo)row.getUserObject()).setCreditAmount((BigDecimal)this.calcResult.get("=" + cellObj));
                    ((BgCslElimEntryInfo)row.getUserObject()).setCreditFormula(cellObj);
                }
            }
            if (StringUtils.isEmpty((String)cellObj) && row.getUserObject() instanceof BgCslElimEntryInfo) {
                ((BgCslElimEntryInfo)row.getUserObject()).setCreditFormula(null);
            }
            cellValue = row.getCell("debitAmount").getValue();
            String string2 = cellObj = row.getCell("debitAmount").getUserObject() != null ? String.valueOf(row.getCell("debitAmount").getUserObject()) : null;
            if (!StringUtils.isEmpty((String)cellObj) && this.calcResult.containsKey("=" + cellObj)) {
                row.getCell("debitAmount").setValue(this.calcResult.get("=" + cellObj));
                if (row.getUserObject() instanceof BgCslElimEntryInfo) {
                    ((BgCslElimEntryInfo)row.getUserObject()).setDebitAmount((BigDecimal)this.calcResult.get("=" + cellObj));
                    ((BgCslElimEntryInfo)row.getUserObject()).setDebitFormula(cellObj);
                }
            }
            if (!StringUtils.isEmpty((String)cellObj) || !(row.getUserObject() instanceof BgCslElimEntryInfo)) continue;
            ((BgCslElimEntryInfo)row.getUserObject()).setDebitFormula(null);
        }
    }

    protected Map<String, Object> calcTemplateEntries(BgCslOffsetEntryTemplateEntryCollection entries) throws Exception {
        CaseInsensitiveMap calcResult = new CaseInsensitiveMap();
        if (entries == null || entries.isEmpty()) {
            return calcResult;
        }
        this.expressionParseBefore();
        Book book = Book.Manager.getNewBook((String)"Sheet1", (int)1);
        book.setCalculate(false);
        Sheet sheet = book.getSheet(0);
        Cell cell = null;
        for (int i = 0; i < entries.size(); ++i) {
            cell = sheet.getCell(i, 0, true);
            String debitFormula = entries.get(i).getDebitFormula();
            if ((debitFormula = BgNExpressionHelper.checkExpression(null, (String)debitFormula, (String)this.getOrgBound().getNumber())) != null) {
                cell.setFormula("=" + debitFormula);
            } else {
                cell.setFormula(null);
                cell.setValue(Variant.nullVariant);
            }
            cell = sheet.getCell(i, 1, true);
            String creditFormula = entries.get(i).getCreditFormula();
            creditFormula = BgNExpressionHelper.checkExpression(null, (String)creditFormula, (String)this.getOrgBound().getNumber());
            if (creditFormula != null) {
                cell.setFormula("=" + creditFormula);
                continue;
            }
            cell.setFormula(null);
            cell.setValue(Variant.nullVariant);
        }
        this.calcBook(book, this.getcalcFormInfo());
        int rowCount = sheet.getMaxRowIndex();
        int colCount = sheet.getMaxColIndex();
        boolean hasExpression = false;
        String expression = null;
        Object value = null;
        for (int r = 0; r <= rowCount; ++r) {
            for (int c = 0; c <= colCount; ++c) {
                cell = sheet.getCell(r, c, false);
                if (cell == null || !(hasExpression = BgNFSHelper.checkHasExpression((Cell)cell)) || BgNFSHelper.getValue((Cell)cell) == null) continue;
                expression = BgNFSHelper.getExpression((Cell)cell);
                value = BgNFSHelper.getValue((Cell)cell);
                calcResult.put(expression, value);
            }
        }
        return calcResult;
    }

    private void expressionParseBefore() {
        CurrencyInfo currencyInfo = this.getCurrencyInfo();
        if (currencyInfo != null) {
            HashSet<String> currencyNums = new HashSet<String>();
            currencyNums.add(currencyInfo.getNumber());
            BgNExpressionHelper.setCurrencyNums(currencyNums);
        } else {
            BgNExpressionHelper.setCurrencyNums(null);
        }
        BgPeriodInfo bgPeriodInfo = this.getBgPeriodInfo();
        if (bgPeriodInfo != null) {
            HashSet<String> periodNums = new HashSet<String>();
            periodNums.add(bgPeriodInfo.getNumber());
            BgNExpressionHelper.setPeriodNums(periodNums);
        } else {
            BgNExpressionHelper.setPeriodNums(null);
        }
    }

    protected BgCslAdjFormInfo getcalcFormInfo() throws EASBizException, BOSException {
        BgCslAdjFormInfo info = new BgCslAdjFormInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        info.setOrgTree(this.getOrgTree());
        info.setOrgUnit(this.getOrgBound());
        info.setBgScheme(this.getBgSchemeInfo());
        if (this.getBgPeriodInfo() != null) {
            BgPeriodInfo bgPeriodInfo = BgPeriodFactory.getRemoteInstance().getBgPeriodInfo((IObjectPK)new ObjectUuidPK(this.getBgPeriodInfo().getId()));
            info.setBgPeriod(bgPeriodInfo);
        } else {
            info.setBgPeriod(this.getBgPeriodInfo());
        }
        info.setBgVersion(this.getBgVersionInfo());
        info.setCurrency(this.getCurrencyInfo());
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        info.setCreateTime(this.editData.getCreateTime());
        return info;
    }

    protected void calcBook(Book calcBook, BgCslAdjFormInfo info) throws Exception {
        if (ReportVariables.loadFromBook((Book)calcBook) == null) {
            calcBook.setUserObject("VARIABLES", (Object)new ReportVariables());
        }
        FormulaDefinition.registerFormulaToBook((Book)calcBook, (ICalculateContextProvider)new BgCslAdjCalculateContext(calcBook, info));
        calcBook.calc();
    }

    @Override
    protected void checkTableParsed() {
        super.checkTableParsed();
        this.getDetailTable().checkParsed();
    }

    @Override
    protected void prmtBgVersion_willShow(SelectorEvent e) throws Exception {
        BgNFormListUI.addRollVersionFilter((KDBizPromptBox)this.prmtBgVersion);
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    @Override
    protected void prmtBgPeriod_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgPeriod_dataChanged(e);
        this.expressionParseBefore();
    }

    class MyCellEditor
    extends KDTDefaultCellEditor {
        public MyCellEditor(JTextField textField) {
            super(textField);
        }

        public Object getValue() {
            Object obj = super.getValue();
            if (obj instanceof String && StringUtils.isEmpty((String)((String)obj))) {
                return null;
            }
            return obj;
        }
    }
}

