/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.message.client.MessageCenterUI;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUI;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CheckedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.client.BgPeriodDialog;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCodeNumberCHelper;
import com.kingdee.eas.ma.base.utils.BgCodeNumberHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.bgcsl.BgCslFormFactory;
import com.kingdee.eas.ma.bgcsl.BgCslFormInfo;
import com.kingdee.eas.ma.bgcsl.BgCslFormMeasureUnitInfo;
import com.kingdee.eas.ma.bgcsl.BgCslFormStateEnum;
import com.kingdee.eas.ma.bgcsl.BgCslSpecialItemsFactory;
import com.kingdee.eas.ma.bgcsl.BgCslSpecialItemsInfo;
import com.kingdee.eas.ma.bgcsl.BgCslSpecialRelationGroupCollection;
import com.kingdee.eas.ma.bgcsl.BgCslSpecialRelationGroupFactory;
import com.kingdee.eas.ma.bgcsl.BgCslTemMeasureUnitCollection;
import com.kingdee.eas.ma.bgcsl.BgCslTemMeasureUnitInfo;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateFactory;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateInfo;
import com.kingdee.eas.ma.bgcsl.BgCslViewListFormFacadeFactory;
import com.kingdee.eas.ma.bgcsl.client.AbstractBgCslFormEditUI;
import com.kingdee.eas.ma.bgcsl.client.BgCslFormCommProcessUI;
import com.kingdee.eas.ma.bgcsl.client.BgCslFormListUI;
import com.kingdee.eas.ma.bgcsl.client.cslTemplate.BgSpecialBudgetHelper;
import com.kingdee.eas.ma.bgcsl.client.utils.BgCslClientHelper;
import com.kingdee.eas.ma.bgcsl.client.utils.BgCslOrgSelectDialog;
import com.kingdee.eas.ma.bgcsl.common.BgCslFormHelper;
import com.kingdee.eas.ma.bgcsl.common.BgCslTemplateHelper;
import com.kingdee.eas.ma.bgcsl.utils.BgCslCommonHelper;
import com.kingdee.eas.ma.bgcsl.utils.BgCslFormTemplateObject;
import com.kingdee.eas.ma.bgcsl.utils.BgCslSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.DimRelashipGroupEntryCollection;
import com.kingdee.eas.ma.mbg.DimRelashipGroupEntryInfo;
import com.kingdee.eas.ma.mbg.DimensionRelationshipFactory;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupInfo;
import com.kingdee.eas.ma.mbg.DimensionRelationshipInfo;
import com.kingdee.eas.ma.mbg.StyleSetFactory;
import com.kingdee.eas.ma.mbg.StyleSetInfo;
import com.kingdee.eas.ma.mbg.client.BgNFormListUI;
import com.kingdee.eas.ma.mbg.client.BgTemplateDialog;
import com.kingdee.eas.ma.mbg.client.NewDimensionSelectDialog;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgSpecialBudgetClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectHelper;
import com.kingdee.eas.ma.mbg.client.utils.NewDimensionMemberSelectDialog;
import com.kingdee.eas.ma.mbg.client.utils.SpecialDimRelationshipSelectDialog;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListXMLParser;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import com.kingdee.eas.ma.mbg.common.TemplateStyleInfo;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNExpressionHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeUtils;
import com.kingdee.eas.ma.mbg.utils.DimSettingDisplayInfo;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.IGetSchemeHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BgCslFormEditUI
extends AbstractBgCslFormEditUI
implements IGetSchemeHelper {
    private static final long serialVersionUID = 5057230703040891230L;
    private static final Logger logger = CoreUIObject.getLogger(BgCslFormEditUI.class);
    private final String COL_DIMENSION = "dimension";
    private final String COL_MEMBER = "member";
    private final String COL_DIMRELAGROUP = "dimRelaGroup";
    private BgCodeNumberHelper numberCodeHelper = new BgCodeNumberHelper(null, null, "sourceType");
    private BgCodeNumberHelper nameCodeHelper = new BgCodeNumberHelper(null, "name", "sourceType");
    private BgSchemeDimensionHelper schemeHelper = null;

    public void onLoad() throws Exception {
        this.cboFormType.addItem((Object)"");
        this.cboFormType.addItems(BgTemFormTypeEnum.getEnumList().toArray());
        this.initOrgUnit();
        super.onLoad();
        this.initCurrencyInfo();
        this.initVersionInfo();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            BgSchemeUtils.setDefualtMembers((BgSchemeDimensionHelper)this.getSchemeHelper(), (JComponent)this.prmtBgVersion, (JComponent)this.prmtBgPeriod, (JComponent)this.cboCurrency, (boolean)false, (boolean)false);
        } else {
            this.prmtOrgUnit.setEnabled(false);
        }
        this.initBgTemplateInfo();
        this.initBgPeriodInfo();
        this.txtName.setEnabled(true);
    }

    protected boolean checkIsMulti() {
        return DimensionCommonHelper.isMulti((Object)this.prmtOrgUnit.getData()) || DimensionCommonHelper.isMulti((Object)this.getTempColls(this.prmtBgCslTemplate.getData())) || DimensionCommonHelper.isMulti((Object)this.prmtBgPeriod.getData()) || DimensionCommonHelper.isMulti((Object)this.prmtBgVersion.getData()) || DimensionCommonHelper.isMulti((Object)this.cboCurrency.getSelectedItem());
    }

    private Object getTempColls(Object data) {
        Object[] result = null;
        if (data instanceof BgCslFormTemplateObject) {
            BgCslFormTemplateObject info = (BgCslFormTemplateObject)data;
            result = DimensionCommonHelper.getValues((Object)((Object)info.getResult()));
        } else {
            result = DimensionCommonHelper.getValues((Object)data);
        }
        return result;
    }

    protected void checkMultiAddNew() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            if (this.checkIsMulti()) {
                this.txtNumber.setEnabled(false);
                this.txtNumber.setText("");
                this.txtName.setEnabled(false);
                this.txtName.setText("");
            } else {
                this.txtNumber.setEnabled(true);
                this.txtName.setEnabled(true);
                BgCslFormInfo info = this.getEditData();
                if (info != null && info.getOrgUnit() != null) {
                    String orgId = info.getOrgUnit().getId().toString();
                    this.getNumberByCodingRule((IObjectValue)this.editData, orgId);
                }
            }
        }
    }

    public BgCslFormInfo getEditData() {
        return this.editData;
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if (OprtState.EDIT.equals(this.getOprtState())) {
            this.prmtBgCslTemplate.setEnabled(false);
            this.prmtBgPeriod.setEnabled(false);
            this.prmtBgVersion.setEnabled(false);
            this.cboCurrency.setEnabled(false);
        }
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.dimensionTable.checkParsed();
    }

    protected void applyCodeNumber() {
        BgCslFormInfo info = (BgCslFormInfo)this.getDataObject();
        String orgId = info.getOrgUnit().getId().toString();
        try {
            this.numberCodeHelper.init((IObjectValue)info, orgId);
            this.nameCodeHelper.init((IObjectValue)info, orgId);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort(e);
        }
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            if (info.getNumber() == null) {
                this.getNumberByCodingRule((IObjectValue)this.editData, orgId);
            }
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            try {
                this.txtNumber.setEnabled(this.numberCodeHelper.isModifiable((IObjectValue)this.editData, orgId));
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
                this.handUIException(e);
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                this.handUIException(e);
            }
        }
    }

    protected void getNumberByCodingRule(IObjectValue caller, String orgId) {
        try {
            BgCodeNumberCHelper.getNumberByCodingRule((KDTextField)this.txtNumber, (IObjectValue)caller, (String)orgId, (BgCodeNumberHelper)this.numberCodeHelper);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIException(e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIException(e);
        }
    }

    protected void initBgTemplateInfo() throws EASBizException, BOSException {
        OrgTreeInfo orgTree = (OrgTreeInfo)this.getUIContext().get("orgTreeInfo");
        BgSchemeInfo bgScheme = this.getBgSchemeInfo();
        this.prmtBgCslTemplate.setSelectorCollection(new SelectorItemCollection());
        this.prmtBgCslTemplate.getSelectorCollection().add("*");
        this.prmtBgCslTemplate.getSelectorCollection().add("bgType.id");
        this.prmtBgCslTemplate.getSelectorCollection().add("bgType.number");
        this.prmtBgCslTemplate.getSelectorCollection().add("bgType.name");
        this.prmtBgCslTemplate.getSelectorCollection().add("defaultMeasureUnit.id");
        this.prmtBgCslTemplate.getSelectorCollection().add("defaultMeasureUnit.number");
        this.prmtBgCslTemplate.getSelectorCollection().add("defaultMeasureUnit.name");
        this.prmtBgCslTemplate.getSelectorCollection().add("styleSet.id");
        this.prmtBgCslTemplate.getSelectorCollection().add("styleSet.data");
        this.prmtBgCslTemplate.getSelectorCollection().add("BgSpecialItems.*");
        this.prmtBgCslTemplate.getSelectorCollection().add("BgSpecialItems.dimRelaGroupRef.*");
        this.prmtBgCslTemplate.getSelectorCollection().add("description");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgScheme.getId().toString()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("orgTree.id", (Object)orgTree.getId().toString()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("templateStatus", (Object)0, CompareType.EQUALS));
        this.prmtBgCslTemplate.setEntityViewInfo(evi);
        BgTemplateDialog templateDialog = new BgTemplateDialog();
        templateDialog.setCslForm(true);
        templateDialog.setSchemeId(bgScheme.getId().toString());
        templateDialog.setFilterInfo(this.prmtBgCslTemplate.getEntityViewInfo().getFilter());
        this.prmtBgCslTemplate.setSelector((KDPromptSelector)templateDialog);
        this.prmtBgCslTemplate.setEnabledMultiSelection(true);
    }

    private void initOrgUnit() throws EASBizException, BOSException {
        BgCslOrgSelectDialog dialog = new BgCslOrgSelectDialog();
        dialog.setShowBtn4Order(false);
        OrgTreeInfo orgTreeInfo = (OrgTreeInfo)this.getUIContext().get("orgTreeInfo");
        dialog.setOrgTreeID(orgTreeInfo != null ? orgTreeInfo.getId().toString() : null);
        dialog.setDimension(this.getSchemeHelper().getDimension(DimensionBaseConstants.DEF_ORGUNIT_NUMBER));
        OrgUnitInfo group = (OrgUnitInfo)this.getUIContext().get("GROUPORG_ID");
        dialog.setOrgGroupID(group.getId().toString());
        dialog.setBgSchemeId(this.getBgSchemeInfo().getId().toString());
        dialog.setReturnOrgEntity(true);
        this.prmtOrgUnit.setSelector((KDPromptSelector)dialog);
        this.prmtOrgUnit.setRequired(true);
        this.prmtOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                KDPromptSelector selector = ((KDBizPromptBox)eventObj.getSource()).getSelector();
                if (selector instanceof DataChangeListener) {
                    ((DataChangeListener)selector).dataChanged(eventObj);
                }
            }
        });
    }

    protected void initVersionInfo() throws EASBizException, BOSException {
        DimensionMemberSelectHelper.addIdFilter((KDBizPromptBox)this.prmtBgVersion, (String)DimensionConstants.DEF_VERSION_NUMBER, (BgSchemeDimensionHelper)this.getSchemeHelper());
    }

    protected void initCurrencyInfo() throws EASBizException, BOSException {
        BgNFCHelper.setCurrency((KDComboBox)this.cboCurrency, (BOSUuid)BOSUuid.read((String)this.getOrgUnitId()), (boolean)true, (Set)this.getSchemeHelper().getMemberSet(DimensionConstants.DEF_CURRENCY_NUMBER, false));
        if (!OprtState.ADDNEW.equals(this.getOprtState()) && this.editData.getCurrency() != null) {
            BgNFCHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)this.editData.getCurrency());
        }
    }

    protected void initBgPeriodInfo() throws EASBizException, BOSException {
        BgPeriodDialog dialog = new BgPeriodDialog((CoreUIObject)this);
        dialog.setBgPeriodTypeNumbers(this.getSchemeHelper().getMemberSet(DimensionConstants.DEF_PERIOD_NUMBER, true));
        dialog.setBgSchemeID(this.getSchemeHelper().getBgSchemeId());
        BgSchemeInfo bgScheme = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo((IObjectPK)new ObjectStringPK(this.getSchemeHelper().getBgSchemeId()));
        dialog.setBgPeriodBeginDate(bgScheme.getDateFrom());
        dialog.setBgPeriodEndDate(bgScheme.getDateTo());
        dialog.setMultiSelect(true);
        this.prmtBgPeriod.setSelector((KDPromptSelector)dialog);
        this.prmtBgPeriod.addDataChangeListener((DataChangeListener)dialog);
        this.prmtBgPeriod.setEnabledMultiSelection(true);
    }

    public BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        if (this.schemeHelper == null && this.getBgSchemeId() != null) {
            this.schemeHelper = new BgCslSchemeDimensionHelper(this.getBgSchemeId());
        }
        return this.schemeHelper;
    }

    protected void loadData() throws Exception {
        super.loadData();
        this.applyCodeNumber();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            if (this.prmtBgCslTemplate.getData() instanceof BgCslTemplateInfo) {
                this.editData.setBgCslTemplate((BgCslTemplateInfo)this.prmtBgCslTemplate.getData());
            }
            if (this.prmtBgVersion.getData() instanceof BgVersionInfo) {
                this.editData.setBgVersion((BgVersionInfo)this.prmtBgVersion.getData());
            }
            this.editData.setBgScheme(this.getBgSchemeInfo());
            this.editData.setOrgTree((OrgTreeInfo)this.getUIContext().get("orgTreeInfo"));
            if (this.prmtOrgUnit.getData() instanceof FullOrgUnitInfo) {
                this.editData.setOrgUnit((FullOrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO));
            }
            if (this.prmtBgPeriod.getData() instanceof BgPeriodInfo) {
                this.editData.setBgPeriod((BgPeriodInfo)this.prmtBgPeriod.getData());
            }
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        try {
            this.storeBgSpecialItems();
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
    }

    protected void storeBgSpecialItems() throws EASBizException, BOSException {
        if (this.dimensionTable != null && this.dimensionTable.getRowCount() == 0) {
            return;
        }
        if (this.editData.getBgSpecialItems() != null && !this.editData.getBgSpecialItems().isEmpty()) {
            BgSpecialBudgetHelper.updateBgSpecialInfo(this.dimensionTable, this.editData, this.getSchemeHelper());
        } else {
            BgCslSpecialItemsInfo newInfo = BgSpecialBudgetHelper.getNewInfo(this.dimensionTable, this.editData, this.getSchemeHelper(), true);
            if (newInfo != null) {
                this.editData.getBgSpecialItems().add(newInfo);
            }
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(e);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.storeFields();
            this.doSubmintForAddNew(e);
        } else {
            super.actionSubmit_actionPerformed(e);
        }
        this.disposeUIWindow();
        BgNFCHelper.refreshListUI((CoreUI)this);
    }

    protected void doSubmintForAddNew(ActionEvent e) throws Exception {
        this.openProgressUI(true);
    }

    public boolean isModify() {
        if (this.isSaved()) {
            return false;
        }
        return super.isModify();
    }

    protected void doAfterSubmit(IObjectPK pk) throws Exception {
        boolean isAddNew = OprtState.ADDNEW.equals(this.getOprtState());
        super.doAfterSubmit(pk);
        this.destroyWindow();
        if (isAddNew) {
            this.openProcessUI(pk);
        }
    }

    protected void openProgressUI(boolean isBatch) throws Exception {
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                Object result = BgCslFormEditUI.this.submitBgFormInfo();
                return result;
            }

            public void afterExec(Object result) throws Exception {
                BgCslFormEditUI.this.endProgress(result);
            }
        });
        dialog.show();
    }

    public void endProgress(Object result) throws Exception {
        if (result != null) {
            BgNFCHelper.refreshListUI((CoreUI)this);
            if (result instanceof BgCslFormInfo && this.getUIContext().get("Owner") instanceof BgCslFormListUI) {
                BgCslFormInfo formInfo = (BgCslFormInfo)result;
                BgCslFormListUI listUi = (BgCslFormListUI)this.getUIContext().get("Owner");
                listUi.openProcessUI((IObjectPK)new ObjectUuidPK(formInfo.getId()), this.getUIContext(), formInfo.getFormType().getValue());
            }
        }
        this.setSaved(true);
        this.destroyWindow();
        this.setSaved(false);
    }

    private void openProcessUI(IObjectPK pk) throws UIException {
        if (pk == null) {
            return;
        }
        if (!(this.getUIContext().get("Owner") instanceof BgCslFormListUI)) {
            return;
        }
        int formType = ((BgTemFormTypeEnum)this.cboFormType.getSelectedItem()).getValue();
        BgCslFormListUI listUi = (BgCslFormListUI)this.getUIContext().get("Owner");
        listUi.openProcessUI(pk, this.getUIContext(), formType);
    }

    public Object submitBgFormInfo() throws Exception {
        Object[] orgUnits = BgCslCommonHelper.getValues(this.prmtOrgUnit.getData());
        Object[] templates = BgCslCommonHelper.getValues(this.prmtBgCslTemplate.getData());
        Object[] versions = BgCslCommonHelper.getValues(this.prmtBgVersion.getData());
        Object[] periods = BgCslCommonHelper.getValues(this.prmtBgPeriod.getData());
        OrgTreeInfo treeInfo = (OrgTreeInfo)this.getUIContext().get("orgTreeInfo");
        Object result = BgCslFormFactory.getRemoteInstance().batchAddCslFrom(orgUnits, templates, versions, periods, treeInfo, this.editData);
        if (result instanceof BgCslFormInfo) {
            return (BgCslFormInfo)result;
        }
        if (result instanceof Object[]) {
            BgNFCHelper.refreshListUI((CoreUI)this);
            Object[] str = (Object[])result;
            if (str.length >= 2 && !StringUtils.isEmpty((String)((String)str[1]))) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)((String)str[0]), (String)((String)str[1]), (int)1);
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)((String)str[0]));
            }
        }
        return result;
    }

    private BgCslTemplateInfo getBgCslTemplateInfo(BOSUuid id) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("formType");
        sic.add("data");
        sic.add("defaultMeasureUnit.id");
        sic.add("defaultMeasureUnit.number");
        sic.add("defaultMeasureUnit.name");
        sic.add("bgMeasureUnit.*");
        sic.add("dimensionData");
        return BgCslTemplateFactory.getRemoteInstance().getBgCslTemplateInfo((IObjectPK)new ObjectUuidPK(id), sic);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.prmtBgCslTemplate.getData() == null) {
            this.prmtBgCslTemplate.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslTemplateResource", (String)"selectCslTemplate"));
            SysUtil.abort();
        }
        if ((this.txtNumber.isEnabled() || !this.checkIsMulti() && this.numberCodeHelper.isHasShowCodeNumber()) && StringUtils.isEmpty((String)this.txtNumber.getText())) {
            this.txtNumber.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslTemplateResource", (String)"numberIsNull"));
            SysUtil.abort();
        }
        if ((this.txtName.isEnabled() || this.nameCodeHelper.isHasShowCodeNumber()) && StringUtils.isEmpty((String)this.txtName.getText())) {
            this.txtName.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslTemplateResource", (String)"nameIsNull"));
            SysUtil.abort();
        }
        if (this.prmtBgPeriod.getData() == null) {
            this.prmtBgPeriod.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslTemplateResource", (String)"selectBgPeriod"));
            SysUtil.abort();
        }
        if (DimensionCommonHelper.isEmpty((Object)this.cboCurrency.getSelectedItem())) {
            this.cboCurrency.requestFocus();
            BgNFCHelper.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr((String)"noCurrency"));
        }
        if (this.prmtBgVersion.getData() == null) {
            this.prmtBgVersion.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslTemplateResource", (String)"selectBgVersion"));
            SysUtil.abort();
        }
        if (DimensionCommonHelper.isEmpty((Object)this.prmtOrgUnit.getData())) {
            this.prmtOrgUnit.requestFocus();
            BgNFCHelper.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.MbgWorkPaperResource", (String)"unitUnionNotNull"));
        }
        this.checkMemberEmpty();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            // empty if block
        }
    }

    public static void checkRepeat(CoreUI ui, String bgSchemeId, String orgUnitId, String templateId, String bgPeriodId, String currencyId, String bgVersionId, String specialItemsNumber) throws EASBizException, BOSException {
        boolean isRepeat;
        if (StringUtils.isEmpty((String)specialItemsNumber)) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeId));
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId));
            filter.getFilterItems().add(new FilterItemInfo("bgCslTemplate.id", (Object)templateId));
            filter.getFilterItems().add(new FilterItemInfo("bgPeriod.id", (Object)bgPeriodId));
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
            filter.getFilterItems().add(new FilterItemInfo("bgVersion.id", (Object)bgVersionId));
            isRepeat = BgCslFormFactory.getRemoteInstance().exists(filter);
        } else {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bgForm.bgScheme.id", (Object)bgSchemeId));
            filter.getFilterItems().add(new FilterItemInfo("bgForm.orgUnit.id", (Object)orgUnitId));
            filter.getFilterItems().add(new FilterItemInfo("bgForm.bgCslTemplate.id", (Object)templateId));
            filter.getFilterItems().add(new FilterItemInfo("bgForm.bgPeriod.id", (Object)bgPeriodId));
            filter.getFilterItems().add(new FilterItemInfo("bgForm.currency.id", (Object)currencyId));
            filter.getFilterItems().add(new FilterItemInfo("bgForm.bgVersion.id", (Object)bgVersionId));
            filter.getFilterItems().add(new FilterItemInfo("dimensionNumber", (Object)specialItemsNumber));
            isRepeat = BgCslSpecialItemsFactory.getRemoteInstance().exists(filter);
        }
        if (isRepeat) {
            MsgBox.showInfo((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslTemplateResource", (String)"repeatBgCslForm"));
            SysUtil.abort();
        }
    }

    private void checkRepeat() throws EASBizException, BOSException {
        String specialItemsNumber = BgSpecialBudgetHelper.getSpecialItemDimNumber(this.dimensionTable, this.getSchemeHelper());
        boolean isRepeat = false;
        if (StringUtils.isEmpty((String)specialItemsNumber)) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)this.getBgSchemeId()));
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)((FullOrgUnitInfo)this.prmtOrgUnit.getData()).getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("bgCslTemplate.id", (Object)((BgCslTemplateInfo)this.prmtBgCslTemplate.getData()).getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("bgPeriod.id", (Object)((BgPeriodInfo)this.prmtBgPeriod.getData()).getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)((CurrencyInfo)this.cboCurrency.getSelectedItem()).getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("bgVersion.id", (Object)((BgVersionInfo)this.prmtBgVersion.getData()).getId().toString()));
            isRepeat = BgCslFormFactory.getRemoteInstance().exists(filter);
        } else {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bgForm.bgScheme.id", (Object)this.getBgSchemeId()));
            filter.getFilterItems().add(new FilterItemInfo("bgForm.orgUnit.id", (Object)((OrgUnitInfo)this.prmtOrgUnit.getData()).getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("bgForm.bgCslTemplate.id", (Object)((BgCslTemplateInfo)this.prmtBgCslTemplate.getData()).getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("bgForm.bgPeriod.id", (Object)((BgPeriodInfo)this.prmtBgPeriod.getData()).getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("bgForm.currency.id", (Object)((CurrencyInfo)this.cboCurrency.getSelectedItem()).getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("bgForm.bgVersion.id", (Object)((BgVersionInfo)this.prmtBgVersion.getData()).getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("dimensionNumber", (Object)specialItemsNumber));
            isRepeat = BgCslSpecialItemsFactory.getRemoteInstance().exists(filter);
        }
        if (isRepeat) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslTemplateResource", (String)"repeatBgCslForm"));
            SysUtil.abort();
        }
    }

    private void checkMemberEmpty() {
        int count = this.dimensionTable.getRowCount();
        ICell dCell = null;
        ICell mCell = null;
        for (int rowIndex = 0; rowIndex < count; ++rowIndex) {
            Object obj;
            dCell = this.dimensionTable.getCell(rowIndex, "dimension");
            mCell = this.dimensionTable.getCell(rowIndex, "member");
            if (mCell == null || dCell == null || mCell.getValue() != null || !((obj = dCell.getValue()) instanceof DimSettingDisplayInfo)) continue;
            String dimName = ((DimSettingDisplayInfo)obj).getDimSettingInfo().getDimName();
            BgNFCHelper.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgNFormResource", (String)"chooseDimMember", (Object[])new String[]{dimName}));
        }
    }

    @Override
    protected void prmtBgCslTemplate_dataChanged(DataChangeEvent e) throws Exception {
        this.checkMultiAddNew();
        super.prmtBgCslTemplate_dataChanged(e);
        Object newValue = e.getNewValue();
        if (newValue instanceof BgCslTemplateInfo) {
            BgCslTemplateInfo info = (BgCslTemplateInfo)newValue;
            BgCslTemplateCollection bgNWorkTemplateCollection = new BgCslTemplateCollection();
            bgNWorkTemplateCollection.add(info);
            Object[] values = DimensionCommonHelper.getValues((Object)((Object)bgNWorkTemplateCollection));
            this.getTmplateArr(values);
        } else if (newValue instanceof BgCslFormTemplateObject) {
            Object[] values = DimensionCommonHelper.getValues((Object)((Object)((BgCslFormTemplateObject)newValue).getResult()));
            this.getTmplateArr(values);
        } else if (newValue instanceof Object[]) {
            Object[] arr = (Object[])newValue;
            this.getTmplateArr(arr);
        }
        this.updateBgFormName();
        Object data = this.prmtBgCslTemplate.getData();
        Object[] bgTemplates = DimensionCommonHelper.getValues((Object)this.getTempColls(data));
        if (bgTemplates == null) {
            return;
        }
        if (bgTemplates.length == 1 && bgTemplates[0] instanceof BgCslTemplateInfo) {
            BgCslTemplateInfo bgTemplateInfo = (BgCslTemplateInfo)bgTemplates[0];
            if (bgTemplateInfo == null) {
                this.cboFormType.setSelectedItem((Object)"");
                this.prmtBgType.setData(null);
            } else {
                if (OprtState.ADDNEW.equals(this.getOprtState())) {
                    this.prmtBgType.setData((Object)bgTemplateInfo.getBgType());
                }
                this.cboFormType.setSelectedItem((Object)bgTemplateInfo.getFormType());
                if (BgTemFormTypeEnum.FIXEDFORM.equals((Object)bgTemplateInfo.getFormType()) || BgTemFormTypeEnum.SPECIALFORM.equals((Object)bgTemplateInfo.getFormType())) {
                    if (OprtState.ADDNEW.equals(this.getOprtState())) {
                        this.prmtUnit.setData((Object)bgTemplateInfo.getDefaultMeasureUnit());
                    } else {
                        this.prmtUnit.setData((Object)this.editData.getMeasureUnit());
                    }
                } else {
                    TemplateStyleInfo templateStyleInfo = null;
                    if (OprtState.ADDNEW.equals(this.getOprtState())) {
                        if (bgTemplateInfo.getStyleSet() != null && bgTemplateInfo.getStyleSet().getData() != null) {
                            templateStyleInfo = MbgXMLParser.parseStyle((byte[])bgTemplateInfo.getStyleSet().getData());
                        } else {
                            StyleSetInfo styleSet = StyleSetFactory.getRemoteInstance().getStyleSetInfo("select data where id = '" + bgTemplateInfo.getStyleSet().getId() + "'");
                            templateStyleInfo = MbgXMLParser.parseStyle((byte[])styleSet.getData());
                        }
                    } else {
                        templateStyleInfo = MbgXMLParser.parseStyle((byte[])this.editData.getBgCslTemplate().getStyleSet().getData());
                    }
                    this.prmtUnit.setData((Object)templateStyleInfo.getCurrencyUnitName());
                }
                if (OprtState.ADDNEW.equals(this.getOprtState())) {
                    this.initDimensionTableByBgTemplate(bgTemplateInfo);
                } else {
                    this.initDimensionTableByForm(this.editData);
                }
            }
        } else if (bgTemplates.length > 1) {
            this.cboFormType.setSelectedItem((Object)"");
            this.prmtBgType.setData(null);
            this.prmtUnit.setData(null);
            int specialCount = 0;
            if (bgTemplates != null) {
                BgCslTemplateInfo template = null;
                for (int i = 0; i < bgTemplates.length; ++i) {
                    template = (BgCslTemplateInfo)bgTemplates[i];
                    if (!BgTemFormTypeEnum.SPECIALFORM.equals((Object)template.getFormType())) continue;
                    ++specialCount;
                }
            }
            if (specialCount > 1) {
                this.prmtBgCslTemplate.setDataNoNotify(e.getOldValue());
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgDecomposeResource", (String)"checkAddNewSpecialMultiTemplate"));
                SysUtil.abort();
            }
            if (OprtState.ADDNEW.equals(this.getOprtState())) {
                Object[] objs = DimensionCommonHelper.getValues((Object)this.prmtBgCslTemplate.getData());
                if (objs != null) {
                    BgCslTemplateInfo bgTemplateInfo = null;
                    for (Object obj : objs) {
                        if (!BgTemFormTypeEnum.SPECIALFORM.equals((Object)((BgCslTemplateInfo)obj).getFormType())) continue;
                        bgTemplateInfo = (BgCslTemplateInfo)obj;
                        break;
                    }
                    if (bgTemplateInfo != null) {
                        this.initDimensionTableByBgTemplate(bgTemplateInfo);
                    } else {
                        this.dimensionTable.removeRows(false);
                    }
                } else {
                    this.dimensionTable.removeRows(false);
                }
            } else if (this.editData != null && BgTemFormTypeEnum.SPECIALFORM.equals((Object)this.editData.getBgCslTemplate().getFormType())) {
                this.initDimensionTableByForm(this.editData);
            }
        }
    }

    private void getTmplateArr(Object[] values) {
        BgCslTemplateInfo[] tArrs = new BgCslTemplateInfo[values.length];
        for (int i = 0; i < tArrs.length; ++i) {
            if (!(values[i] instanceof BgCslTemplateInfo)) continue;
            tArrs[i] = (BgCslTemplateInfo)values[i];
        }
        this.prmtBgCslTemplate.setDataNoNotify((Object)tArrs);
    }

    @Override
    protected void prmtBgPeriod_willShow(SelectorEvent e) throws Exception {
        super.prmtBgPeriod_willShow(e);
        KDPromptSelector selector = this.prmtBgPeriod.getSelector();
        if (selector instanceof BgPeriodDialog) {
            BgPeriodDialog dio = (BgPeriodDialog)selector;
            if (this.prmtBgPeriod.getData() instanceof BgPeriodInfo[]) {
                dio.setBgPeriods((BgPeriodInfo[])this.prmtBgPeriod.getData());
            }
        }
    }

    @Override
    protected void prmtBgPeriod_dataChanged(DataChangeEvent e) throws Exception {
        this.checkMultiAddNew();
        super.prmtBgPeriod_dataChanged(e);
        Object newValue = e.getNewValue();
        if (newValue instanceof BgPeriodInfo) {
            BgPeriodInfo info = (BgPeriodInfo)newValue;
            BgPeriodInfo[] periods = new BgPeriodInfo[]{info};
            this.prmtBgPeriod.setDataNoNotify((Object)periods);
        } else if (newValue instanceof Object[]) {
            Object[] arr = (Object[])newValue;
            if (arr[0] == null) {
                this.prmtBgPeriod.setDataNoNotify(null);
            } else {
                this.getPeriodArr(arr);
            }
        }
        this.updateBgFormName();
    }

    private void getPeriodArr(Object[] arr) {
        BgPeriodInfo[] periods = new BgPeriodInfo[arr.length];
        for (int i = 0; i < periods.length; ++i) {
            if (arr[i] instanceof BgPeriodInfo) {
                periods[i] = (BgPeriodInfo)arr[i];
                continue;
            }
            if (!(arr[i] instanceof BgPeriodInfo[])) continue;
            periods[i] = ((BgPeriodInfo[])arr[i])[0];
        }
        this.prmtBgPeriod.setDataNoNotify((Object)periods);
    }

    @Override
    protected void prmtBgVersion_dataChanged(DataChangeEvent e) throws Exception {
        this.checkMultiAddNew();
        super.prmtBgVersion_dataChanged(e);
        Object newValue = e.getNewValue();
        if (newValue instanceof Object[]) {
            Object[] arr = (Object[])newValue;
            BgVersionInfo[] versions = new BgVersionInfo[arr.length];
            for (int i = 0; i < versions.length; ++i) {
                if (!(arr[i] instanceof BgVersionInfo)) continue;
                versions[i] = (BgVersionInfo)arr[i];
            }
            this.prmtBgVersion.setDataNoNotify((Object)versions);
        } else if (newValue instanceof BgVersionInfo) {
            BgVersionInfo version = (BgVersionInfo)newValue;
            BgVersionInfo[] versions = new BgVersionInfo[]{version};
            this.prmtBgVersion.setDataNoNotify((Object)versions);
        }
        this.updateBgFormName();
    }

    @Override
    protected void cboCurrency_itemStateChanged(ItemEvent e) throws Exception {
        super.cboCurrency_itemStateChanged(e);
        if (e.getStateChange() == 1) {
            this.updateBgFormName();
        }
    }

    protected void updateBgFormName() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            if (this.checkCreateName()) {
                String name = this.getBgFormName();
                this.txtName.setEnabled(true);
                this.txtName.setText(name);
            } else {
                this.txtName.setText(null);
                this.txtName.setEnabled(false);
            }
        }
    }

    protected boolean checkCreateName() {
        return this.prmtBgPeriod.getData() instanceof BgPeriodInfo[] && ((BgPeriodInfo[])this.prmtBgPeriod.getData()).length == 1 && this.prmtBgCslTemplate.getData() instanceof BgCslTemplateInfo[] && ((BgCslTemplateInfo[])this.prmtBgCslTemplate.getData()).length == 1 && (this.prmtBgVersion.getData() instanceof Object[] && ((Object[])this.prmtBgVersion.getData()).length == 1 || this.prmtBgVersion.getData() instanceof BgVersionInfo);
    }

    protected String getBgFormName() {
        return this.getBgFormName(this.txtName.getMaxLength());
    }

    private String getBgFormName(int maxLength) {
        String name = ((BgPeriodInfo[])this.prmtBgPeriod.getData())[0].getName() + "-" + ((BgCslTemplateInfo[])this.prmtBgCslTemplate.getData())[0].getName() + "-";
        if (this.prmtBgVersion.getData() instanceof BgVersionInfo[]) {
            BgVersionInfo[] data = (BgVersionInfo[])this.prmtBgVersion.getData();
            name = name + data[0].getName();
        } else if (this.prmtBgVersion.getData() instanceof BgVersionInfo) {
            BgVersionInfo info = (BgVersionInfo)this.prmtBgVersion.getData();
            name = name + info.getName();
        }
        if (name.length() > maxLength) {
            name = name.substring(0, maxLength);
        }
        return name;
    }

    protected void initDimensionTableByBgTemplate(BgCslTemplateInfo bgTemplateInfo) throws BOSException, EASBizException {
        if (bgTemplateInfo == null) {
            return;
        }
        this.dimensionTable.removeRows(false);
        if (!BgTemFormTypeEnum.SPECIALFORM.equals((Object)bgTemplateInfo.getFormType())) {
            return;
        }
        BgCslSpecialItemsInfo itemsInfo = BgSpecialBudgetHelper.getBgSpecialItem(bgTemplateInfo);
        if (itemsInfo == null) {
            return;
        }
        itemsInfo.setBgTemplate(bgTemplateInfo);
        itemsInfo = BgCslSpecialRelationGroupFactory.getRemoteInstance().addDimRelaGroupForBgSpecialItems(itemsInfo);
        bgTemplateInfo.getBgSpecialItems().clear();
        bgTemplateInfo.getBgSpecialItems().add(itemsInfo);
        BgSpecialBudgetHelper.loadDimensionTable(this.dimensionTable, this.getSchemeHelper(), itemsInfo);
        this.afterDimenisonTableInited();
        this.initDimRelations(itemsInfo);
    }

    protected void initDimensionTableByForm(BgCslFormInfo bgFormInfo) throws BOSException, EASBizException {
        if (bgFormInfo == null) {
            return;
        }
        BgCslSpecialItemsInfo itemsInfo = BgSpecialBudgetHelper.getBgSpecialItem(bgFormInfo);
        if (itemsInfo == null) {
            return;
        }
        this.dimensionTable.removeRows(false);
        itemsInfo.setBgForm(bgFormInfo);
        itemsInfo = BgCslSpecialRelationGroupFactory.getRemoteInstance().addDimRelaGroupForBgSpecialItems(itemsInfo);
        itemsInfo.copyNewToOld();
        bgFormInfo.getBgSpecialItems().clear();
        bgFormInfo.getBgSpecialItems().add(itemsInfo);
        bgFormInfo.getBgSpecialItems().copyNewToOld();
        BgSpecialBudgetHelper.loadDimensionTable(this.dimensionTable, this.getSchemeHelper(), itemsInfo);
        this.lockDimensionColumn();
        this.lockDimRelaGroupColumn();
        this.lockMemberColumn();
    }

    private void afterDimenisonTableInited() throws EASBizException, BOSException {
        this.lockDimensionColumn();
        this.lockDimRelaGroupColumn();
        this.lockMemberColumn();
        this.initPrmtDimension();
        this.initPrmtMember();
    }

    private void lockDimensionColumn() {
        this.dimensionTable.getColumn("dimension").getStyleAttributes().setLocked(true);
    }

    private void lockDimRelaGroupColumn() {
        this.dimensionTable.getColumn("dimRelaGroup").getStyleAttributes().setLocked(true);
    }

    private void lockMemberColumn() {
        int count = this.dimensionTable.getRowCount();
        for (int rowIndex = 0; rowIndex < count; ++rowIndex) {
            ICell cell = this.dimensionTable.getCell(rowIndex, "member");
            if (cell.getValue() != null) {
                cell.getStyleAttributes().setLocked(true);
                continue;
            }
            cell.getStyleAttributes().setBackground(BgSpecialBudgetClientHelper.REQUIRED_COLOR);
        }
    }

    private void initPrmtDimension() {
        KDBizPromptBox prmptDimension = new KDBizPromptBox();
        this.formatePrmtDimension(prmptDimension);
        KDTDefaultCellEditor dimEditor = new KDTDefaultCellEditor((IKDEditor)prmptDimension);
        this.dimensionTable.getRow(0).getCell("dimension").setEditor((ICellEditor)dimEditor);
    }

    private void formatePrmtDimension(KDBizPromptBox prmptDim) {
        prmptDim.setRequired(true);
        NewDimensionSelectDialog dialog = this.initDimensionF7();
        prmptDim.addDataChangeListener((DataChangeListener)dialog);
        prmptDim.setEditable(false);
        prmptDim.setSelector((KDPromptSelector)dialog);
        prmptDim.setRequestFocusEnabled(true);
    }

    protected NewDimensionSelectDialog initDimensionF7() {
        NewDimensionSelectDialog dialog = new NewDimensionSelectDialog((CoreUI)this, true);
        dialog.setOnlyMbgDim(Boolean.valueOf(true));
        dialog.setCsl(true);
        dialog.setBgSchemeId(this.getBgSchemeId());
        return dialog;
    }

    private void initPrmtMember() throws EASBizException, BOSException {
        int count = this.dimensionTable.getRowCount();
        IRow row = null;
        Object dimension = null;
        for (int index = 0; index < count; ++index) {
            row = this.dimensionTable.getRow(index);
            dimension = row.getCell("dimension").getValue();
            if (!(dimension instanceof DimSettingDisplayInfo)) continue;
            this.setPrmtValue(row, (DimSettingDisplayInfo)dimension);
        }
    }

    private void setPrmtValue(IRow row, DimSettingDisplayInfo dimension) throws EASBizException, BOSException {
        if (row == null || dimension == null) {
            return;
        }
        String dimNumber = dimension.getDimSettingInfo().getDimNumber();
        KDBizPromptBox prmptMember = new KDBizPromptBox();
        prmptMember.setEditable(false);
        KDTDefaultCellEditor memberEditor = new KDTDefaultCellEditor((IKDEditor)prmptMember);
        if (row.getCell("dimension").getEditor() != null && row.getCell("dimension").getEditor().getComponent() instanceof KDBizPromptBox) {
            ((KDBizPromptBox)row.getCell("dimension").getEditor().getComponent()).setDataNoNotify((Object)dimension);
        } else {
            row.getCell("dimension").setValue((Object)dimension);
        }
        prmptMember.setSelector((KDPromptSelector)this.getMemberDialog(this.getSchemeHelper().getDimension(dimNumber), this.getOrgUnitId()));
        row.getCell("member").setEditor((ICellEditor)memberEditor);
        if (row.getCell("member").getValue() instanceof List) {
            if (((List)row.getCell("member").getValue()).get(0) instanceof BgDimensionMember && !((BgDimensionMember)((List)row.getCell("member").getValue()).get(0)).getType().equals(dimNumber)) {
                row.getCell("member").setValue(null);
            }
        } else if (row.getCell("member").getValue() instanceof BgDimensionMember && !((BgDimensionMember)row.getCell("member").getValue()).getType().equals(dimNumber)) {
            row.getCell("member").setValue(null);
        }
        if (row.getCell("dimRelaGroup").getValue() != null) {
            prmptMember.setSelector(this.getRelationshipDialog(((DimensionRelationshipGroupInfo)row.getCell("dimRelaGroup").getValue()).getId().toString(), this.getOrgUnitId()));
            this.prmptMember_dataChange(prmptMember);
        }
    }

    private NewDimensionMemberSelectDialog getMemberDialog(BgDimensionInfo dimen, String orgId) {
        NewDimensionMemberSelectDialog memberDialog = new NewDimensionMemberSelectDialog((Component)((Object)this), this.getBgSchemeId(), (BgDimensionBaseInfo)dimen, orgId, false, false);
        if (dimen != null && DimensionConstants.DEF_CSL_NUMBER.equals(dimen.getNumber())) {
            memberDialog.setFilterValueMap(BgCslClientHelper.addClsAdjFilter(null));
        }
        memberDialog.setUninGroupId(this.editData.getOrgUnit().getId().toString());
        memberDialog.setCanntFilterOrg(true);
        return memberDialog;
    }

    private String getBgSchemeId() {
        return this.getBgSchemeInfo().getId().toString();
    }

    private KDPromptSelector getRelationshipDialog(String groupId, String orgId) {
        ArrayList<DimensionRelationshipGroupInfo> groups = new ArrayList<DimensionRelationshipGroupInfo>();
        if (groupId != null) {
            DimensionRelationshipGroupInfo group = new DimensionRelationshipGroupInfo();
            group.setId(BOSUuid.read((String)groupId));
            groups.add(group);
        }
        SpecialDimRelationshipSelectDialog dialog = new SpecialDimRelationshipSelectDialog((CoreUI)this);
        dialog.setOrgId(orgId);
        dialog.setUnionGroupId(this.getUnionGroupId());
        dialog.setGroupIds(groups);
        dialog.setMultipleSelect(false);
        return dialog;
    }

    private void prmptMember_dataChange(KDBizPromptBox prmptMember) {
        prmptMember.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (eventObj.getNewValue() instanceof DimensionRelationshipInfo) {
                    ((KDBizPromptBox)eventObj.getSource()).setEdittedStop(true);
                    DimensionRelationshipInfo dimRela = (DimensionRelationshipInfo)eventObj.getNewValue();
                    BgCslFormEditUI.this.parseRelationshipMember(dimRela);
                } else if (eventObj.getNewValue() == null) {
                    int rowIndex = BgCslFormEditUI.this.dimensionTable.getSelectManager().getActiveRowIndex();
                    DimensionRelationshipGroupInfo delGroup = (DimensionRelationshipGroupInfo)BgCslFormEditUI.this.dimensionTable.getRow(rowIndex).getCell("dimRelaGroup").getValue();
                    int count = BgCslFormEditUI.this.dimensionTable.getRowCount();
                    for (int index = 0; index < count; ++index) {
                        DimensionRelationshipGroupInfo group = (DimensionRelationshipGroupInfo)BgCslFormEditUI.this.dimensionTable.getRow(index).getCell("dimRelaGroup").getValue();
                        if (group != delGroup) continue;
                        BgCslFormEditUI.this.dimensionTable.getRow(index).getCell("member").setValue(null);
                    }
                }
            }
        });
    }

    private void parseRelationshipMember(DimensionRelationshipInfo dimRela) {
        if (dimRela == null) {
            return;
        }
        DimRelashipGroupEntryCollection colls = dimRela.getDimensionGroup().getEntries();
        BgSchemeDimensionHelper helper = null;
        try {
            helper = this.getSchemeHelper();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        HashMap<String, DimRelashipGroupEntryInfo> entryMap = new HashMap<String, DimRelashipGroupEntryInfo>();
        DimRelashipGroupEntryInfo entry = null;
        for (int i = 0; i < colls.size(); ++i) {
            entry = colls.get(i);
            entryMap.put(helper.getSrcNumber(entry.getDimNumber()), entry);
        }
        String dimNumber = dimRela.getDimensionNumber();
        String dimName = dimRela.getDimensionName();
        String[] dimNumbers = dimNumber.split(DimensionConstants.COMMA_SEPARATOR);
        String[] dimNames = dimName.split(DimensionConstants.TICK_SEPARATOR);
        HashMap<String, BgDimensionMember> memberMap = new HashMap<String, BgDimensionMember>();
        for (int i = 0; i < dimNumbers.length; ++i) {
            String srcNum = dimNumbers[i].split(DimensionConstants.COLON_SEPARATOR)[0];
            String memberNum = dimNumbers[i].split(DimensionConstants.COLON_SEPARATOR)[1];
            BgDimensionInfo dimension = helper.getDimension(((DimRelashipGroupEntryInfo)entryMap.get(srcNum)).getDimNumber());
            BgDimensionMember member = new BgDimensionMember(dimension.getType(), dimension.getAttribute(), dimNames[i], memberNum);
            memberMap.put(member.getType(), member);
        }
        int count = this.dimensionTable.getRowCount();
        int rowIndex = this.dimensionTable.getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0) {
            this.dimensionTable.getRow(rowIndex).getCell("member").setValue(null);
        }
        for (int index = 0; index < count; ++index) {
            DimSettingDisplayInfo dimSett = (DimSettingDisplayInfo)this.dimensionTable.getRow(index).getCell("dimension").getValue();
            if (!memberMap.containsKey(dimSett.getDimSettingInfo().getDimNumber())) continue;
            this.dimensionTable.getRow(index).getCell("member").setValue(memberMap.get(dimSett.getDimSettingInfo().getDimNumber()));
        }
    }

    @Override
    protected void prmtBgVersion_willShow(SelectorEvent e) throws Exception {
        super.prmtBgVersion_willShow(e);
        BgNFormListUI.addRollVersionFilter((KDBizPromptBox)this.prmtBgVersion);
    }

    private void initDimRelations(BgCslSpecialItemsInfo itemsInfo) throws EASBizException, BOSException {
        if (itemsInfo == null) {
            return;
        }
        HashSet<String> groupId = new HashSet<String>();
        HashMap<String, DimensionRelationshipGroupInfo> groupMap = new HashMap<String, DimensionRelationshipGroupInfo>();
        BgCslSpecialRelationGroupCollection coll = itemsInfo.getDimRelaGroupRef();
        for (int i = 0; i < coll.size(); ++i) {
            groupId.add(coll.get(i).getDimRelaGroup().getId().toString());
            groupMap.put(coll.get(i).getDimRelaGroup().getId().toString(), coll.get(i).getDimRelaGroup());
        }
        Map relaMap = DimensionRelationshipFactory.getRemoteInstance().getOnlyRelationshipByGourps(groupId, this.getUnionGroupId(), null);
        for (String gourpId : relaMap.keySet()) {
            DimensionRelationshipInfo rela = (DimensionRelationshipInfo)relaMap.get(gourpId);
            rela.setDimensionGroup((DimensionRelationshipGroupInfo)groupMap.get(rela.getDimensionGroup().getId().toString()));
            this.parseRelationshipMember((DimensionRelationshipInfo)relaMap.get(gourpId));
        }
    }

    protected String getUnionGroupId() {
        return this.editData != null ? this.editData.getOrgUnit().getId().toString() : null;
    }

    protected String getOrgUnitId() {
        return SysContext.getSysContext().getCurrentCostUnit().getId().toString();
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        this.checkMultiAddNew();
        super.prmtOrgUnit_dataChanged(e);
        Object newValue = e.getNewValue();
        if (newValue instanceof FullOrgUnitInfo) {
            FullOrgUnitInfo info = (FullOrgUnitInfo)newValue;
            FullOrgUnitInfo[] infos = new FullOrgUnitInfo[]{info};
            this.prmtOrgUnit.setData((Object)infos);
        }
    }

    protected IObjectValue createNewData() {
        BgCslFormInfo info = new BgCslFormInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setSourceType(RptSrcTypeEnum.PT_BUDGET_REPORT);
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setState(BgCslFormStateEnum.EDIT);
        info.setOrgTree((OrgTreeInfo)this.getUIContext().get("orgTreeInfo"));
        info.setOrgUnit((FullOrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO));
        info.setBgScheme(this.getBgSchemeInfo());
        info.setStartDate(new Date());
        info.setEndDate(info.getStartDate());
        info.setCU((CtrlUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_CU));
        CompanyOrgUnitInfo companyInfo = null;
        try {
            companyInfo = BgCslTemplateHelper.getCompanyByOrgUnit(null, (OrgUnitInfo)info.getOrgUnit());
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        if (companyInfo != null) {
            info.setCompany(companyInfo);
        } else {
            companyInfo = SysContext.getSysContext().getCurrentFIUnit();
            if (companyInfo != null) {
                info.setCompany(companyInfo);
            }
        }
        info.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        info.setCheckedStatus(CheckedStatusEnum.UNCHECKED);
        info.setPeriodType(RptPeriodTypeEnum.YEARLY);
        info.setOrgType(OrgType.UnionDebt);
        return info;
    }

    protected void checkIsOUSealUp() throws Exception {
    }

    public BgSchemeInfo getBgSchemeInfo() {
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.getUIContext().get("BGSCHEME_INFO");
        if (bgSchemeInfo != null) {
            return bgSchemeInfo;
        }
        if (this.editData != null) {
            return this.editData.getBgScheme();
        }
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgCslFormFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = BgCslFormHelper.getSelector();
        sic.add("bgCslTemplate.bgType.id");
        sic.add("bgCslTemplate.bgType.number");
        sic.add("bgCslTemplate.bgType.name");
        sic.add("createTime");
        sic.add("creator.id");
        sic.add("creator.number");
        sic.add("creator.name");
        sic.add("description");
        return sic;
    }

    public static void setBookAndPeriod(BgCslTemplateInfo _bgTemplateInfo, BgCslFormInfo info) throws Exception {
        Book book = _bgTemplateInfo.getBook();
        if (book != null) {
            BgNExpressionHelper.dealAcctExpressionAtAddNew(null, (Book)book, (IObjectValue)info, (int)0);
            if (BgTemFormTypeEnum.SPECIALFORM.equals((Object)_bgTemplateInfo.getFormType())) {
                BgSpecialBudgetHelper.setNewSpecBook(book);
            }
            BgCslFormHelper.setNewBook(book);
            info.setData(IOHelper.packBook((Book)book));
        }
        info.setDimensionData(_bgTemplateInfo.getDimensionData());
        if (info.getBgPeriod() != null) {
            info.setBgPeriod(BgPeriodFactory.getRemoteInstance().getBgPeriodInfo((IObjectPK)new ObjectUuidPK(info.getBgPeriod().getId())));
        }
        BgNFSHelper.synPeriod((ReportBaseInfo)info, (BgPeriodInfo)info.getBgPeriod());
    }

    public static void setDimensionData4ViewList(BgCslTemplateInfo _bgTemplateInfo, BgCslFormInfo info) throws Exception {
        if (BgTemFormTypeEnum.VIEWLIST.equals((Object)_bgTemplateInfo.getFormType()) && info.getDimensionData() != null) {
            MbgViewListXMLParser parser = new MbgViewListXMLParser();
            MbgViewListManager view = parser.parse(info.getDimensionData());
            MbgViewListManager canView = BgCslViewListFormFacadeFactory.getRemoteInstance().reParseCanAddMembers(view, info, false);
            DimensionCommonHelper.fillViewListDefaultMember((CurrencyInfo)info.getCurrency(), (BgPeriodInfo)info.getBgPeriod(), (BgVersionInfo)info.getBgVersion(), (MbgViewListManager)view, (MbgViewListManager)canView);
            info.setDimensionData(parser.unParse(view));
        }
    }

    public static void setMeasureUnit(BgCslTemplateInfo _bgTemplateInfo, BgCslFormInfo info) {
        info.setMeasureUnit(_bgTemplateInfo.getDefaultMeasureUnit());
        BgCslFormMeasureUnitInfo bgMeasureUnit = null;
        if (_bgTemplateInfo.getBgMeasureUnit() != null && !_bgTemplateInfo.getBgMeasureUnit().isEmpty()) {
            BgCslTemMeasureUnitInfo bgTemMeaInfo = null;
            BgCslTemMeasureUnitCollection bgTemCol = _bgTemplateInfo.getBgMeasureUnit();
            Iterator iter = bgTemCol.iterator();
            while (iter.hasNext()) {
                bgTemMeaInfo = (BgCslTemMeasureUnitInfo)iter.next();
                bgMeasureUnit = new BgCslFormMeasureUnitInfo();
                bgMeasureUnit.setBgCslForm(info);
                bgMeasureUnit.setBgElement(bgTemMeaInfo.getBgElement());
                bgMeasureUnit.setMeasureUnit(bgTemMeaInfo.getMeasureUnit());
                info.getCslFormMeasureUnit().add(bgMeasureUnit);
            }
        }
    }

    public IUIObject getInstance(Map uiContext) {
        Object obj;
        if (BgNFCHelper.isFromWorkFlow((Map)uiContext) && ((obj = uiContext.get("Owner")) instanceof MessageCenterUI || obj instanceof MultiApproveUI)) {
            return BgCslFormCommProcessUI.getProcessUIInstance((CoreUI)this, uiContext);
        }
        return null;
    }
}

