/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.BookDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.wrapper.SXSSFExportWrapper;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.client.utils.BgFileUtil;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgElementHelper;
import com.kingdee.eas.ma.base.utils.Excel2007FileFilter;
import com.kingdee.eas.ma.base.utils.ExcelFile;
import com.kingdee.eas.ma.bgcsl.BgCslAdjFormCollection;
import com.kingdee.eas.ma.bgcsl.BgCslAdjFormFactory;
import com.kingdee.eas.ma.bgcsl.BgCslAdjFormInfo;
import com.kingdee.eas.ma.bgcsl.BgCslAdjFormMeasureUnitInfo;
import com.kingdee.eas.ma.bgcsl.BgCslFormCollection;
import com.kingdee.eas.ma.bgcsl.BgCslFormFactory;
import com.kingdee.eas.ma.bgcsl.BgCslFormInfo;
import com.kingdee.eas.ma.bgcsl.BgCslFormMeasureUnitInfo;
import com.kingdee.eas.ma.bgcsl.MbgWorkPaperCollection;
import com.kingdee.eas.ma.bgcsl.MbgWorkPaperFactory;
import com.kingdee.eas.ma.bgcsl.MbgWorkPaperHelper;
import com.kingdee.eas.ma.bgcsl.MbgWorkPaperInfo;
import com.kingdee.eas.ma.bgcsl.client.AbstractBgCslFormExportUI;
import com.kingdee.eas.ma.bgcsl.client.MbgWorkPaperExportProvider;
import com.kingdee.eas.ma.bgcsl.common.BgCslFormHelper;
import com.kingdee.eas.ma.bgcsl.provider.BgCslViewListFormExportProvider;
import com.kingdee.eas.ma.bgcsl.utils.BgCslSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.client.BgExportResultUI;
import com.kingdee.eas.ma.mbg.client.common.BookDimensionClientParse;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.IBookDimensionParse;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.provider.IProviderUI;
import com.kingdee.eas.ma.mbg.provider.ViewListProvider;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MbgViewlistMeasureUnitHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class BgCslFormExportUI
extends AbstractBgCslFormExportUI
implements IProviderUI {
    private static final long serialVersionUID = 556954950979417463L;
    private static final Logger logger = CoreUIObject.getLogger(BgCslFormExportUI.class);
    private DefaultKingdeeTreeNode orgUnitNode = null;
    private BgSchemeInfo bgScheme = null;
    IObjectCollection bgForms = null;
    Map<String, IObjectCollection> form = new HashMap<String, IObjectCollection>();
    boolean isExportWorkPaperInfo = false;
    boolean isExportCslAdjFormInfo = false;
    boolean isAllFormInfo = false;
    public static String file2007Format = ".xlsx";
    public static String file2003Format = ".xls";
    protected DimensionCacheHelper cacheHelper = new DimensionCacheHelper(null);
    private BgSchemeDimensionHelper schemeHelper = null;
    protected String selectFilterFilter = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.rbExcel.isSelected();
        this.rbKDF.setEnabled(false);
        this.rbKDF.setVisible(false);
        this.orgUnitNode = (DefaultKingdeeTreeNode)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO);
        this.bgScheme = (BgSchemeInfo)this.getUIContext().get("BGSCHEME_INFO");
        this.schemeHelper = new BgCslSchemeDimensionHelper(this.bgScheme.getId().toString());
        this.queryBgForms();
    }

    protected void queryBgForms() throws BOSException {
        Set bgFormIds = (Set)this.getUIContext().get("BGFORM_IDS");
        this.isExportWorkPaperInfo = (Boolean)this.getUIContext().get("isExportWorkPaperInfo") != null;
        this.isExportCslAdjFormInfo = (Boolean)this.getUIContext().get("isExportCslAdjFormInfo") != null;
        boolean bl = this.isAllFormInfo = (Boolean)this.getUIContext().get("isAllFormInfo") != null;
        if (this.isExportCslAdjFormInfo) {
            if (bgFormIds != null && !bgFormIds.isEmpty()) {
                EntityViewInfo evi = new EntityViewInfo();
                evi.setSelector(BgCslFormHelper.getSelector());
                evi.setFilter(new FilterInfo());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)bgFormIds, CompareType.INCLUDE));
                evi.setSorter(new SorterItemCollection());
                evi.getSorter().add(new SorterItemInfo("number"));
                this.bgForms = BgCslAdjFormFactory.getRemoteInstance().getBgCslAdjFormCollection(evi);
            }
        } else if (!this.isExportWorkPaperInfo && !this.isAllFormInfo) {
            if (bgFormIds != null && !bgFormIds.isEmpty()) {
                EntityViewInfo evi = new EntityViewInfo();
                evi.setSelector(BgCslFormHelper.getSelector());
                evi.setFilter(new FilterInfo());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)bgFormIds, CompareType.INCLUDE));
                evi.setSorter(new SorterItemCollection());
                evi.getSorter().add(new SorterItemInfo("number"));
                this.bgForms = BgCslFormFactory.getRemoteInstance().getBgCslFormCollection(evi);
            }
        } else if (this.isAllFormInfo) {
            EntityViewInfo evi;
            String bosType = null;
            Iterator it = bgFormIds.iterator();
            HashSet<String> bosSet = new HashSet<String>();
            HashSet<String> adjForm = new HashSet<String>();
            HashSet<String> workForm = new HashSet<String>();
            HashSet<String> cslForm = new HashSet<String>();
            String id = null;
            while (it.hasNext()) {
                id = (String)it.next();
                bosType = BOSUuid.read((String)id).getType().toString();
                if ("AD34C4CD".equals(bosType)) {
                    bosSet.add(bosType);
                    adjForm.add(id);
                    continue;
                }
                if ("9E7BD5E2".equals(bosType)) {
                    bosSet.add(bosType);
                    workForm.add(id);
                    continue;
                }
                if (!"655ADD42".equals(bosType)) continue;
                bosSet.add(bosType);
                cslForm.add(id);
            }
            if (bosSet.contains("AD34C4CD")) {
                this.isExportCslAdjFormInfo = true;
                evi = new EntityViewInfo();
                evi.setSelector(BgCslFormHelper.getSelector());
                evi.setFilter(new FilterInfo());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("id", adjForm, CompareType.INCLUDE));
                evi.setSorter(new SorterItemCollection());
                evi.getSorter().add(new SorterItemInfo("number"));
                this.bgForms = BgCslAdjFormFactory.getRemoteInstance().getBgCslAdjFormCollection(evi);
                this.form.put("adj", this.bgForms);
            }
            if (bosSet.contains("9E7BD5E2")) {
                evi = new EntityViewInfo();
                evi.setSelector(MbgWorkPaperHelper.getSelectors());
                evi.setFilter(new FilterInfo());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("id", workForm, CompareType.INCLUDE));
                evi.setSorter(new SorterItemCollection());
                evi.getSorter().add(new SorterItemInfo("number"));
                this.bgForms = MbgWorkPaperFactory.getRemoteInstance().getMbgWorkPaperCollection(evi);
                this.form.put("work", this.bgForms);
            }
            if (bosSet.contains("655ADD42")) {
                evi = new EntityViewInfo();
                evi.setSelector(BgCslFormHelper.getSelector());
                evi.setFilter(new FilterInfo());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("id", cslForm, CompareType.INCLUDE));
                evi.setSorter(new SorterItemCollection());
                evi.getSorter().add(new SorterItemInfo("number"));
                this.bgForms = BgCslFormFactory.getRemoteInstance().getBgCslFormCollection(evi);
                this.form.put("csl", this.bgForms);
            }
        } else if (bgFormIds != null && !bgFormIds.isEmpty()) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(MbgWorkPaperHelper.getSelectors());
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)bgFormIds, CompareType.INCLUDE));
            evi.setSorter(new SorterItemCollection());
            evi.getSorter().add(new SorterItemInfo("number"));
            this.bgForms = MbgWorkPaperFactory.getRemoteInstance().getMbgWorkPaperCollection(evi);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.setTitle();
    }

    protected void setTitle() {
        if (this.isExportWorkPaperInfo) {
            this.labTitle.setText(com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.MbgWorkPaperResource", (String)"workPaperExportTo"));
            this.setUITitle(com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.MbgWorkPaperResource", (String)"workPaperExportTitle"));
        } else if (this.isExportCslAdjFormInfo) {
            this.labTitle.setText(com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslAdjFormResource", (String)"bgCslAdjFormExportTo"));
            this.setUITitle(com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslAdjFormResource", (String)"bgCslAdjFormExportTitle"));
        }
        if (this.isAllFormInfo) {
            this.labTitle.setText(com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslWorkTableResource", (String)"formExportTo"));
            this.setUITitle(com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslWorkTableResource", (String)"exportTitle"));
        }
    }

    protected void verify() throws Exception {
        if (StringUtils.isEmpty((String)this.txtFilepath.getText())) {
            this.txtFilepath.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"selectOutFilepath"));
            SysUtil.abort();
        } else {
            File file = new File(this.txtFilepath.getText());
            if (!file.isDirectory()) {
                this.txtFilepath.requestFocus();
                MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"errorFilepath"));
                SysUtil.abort();
            }
        }
    }

    @Override
    protected void btnSelectPath_actionPerformed(ActionEvent e) throws Exception {
        KDFileChooser fc = new BgFileUtil().getFileChooserForExp((Object)this.getUIContext());
        fc.setFileSelectionMode(1);
        fc.setDialogTitle(this.getUITitle());
        fc.setFileFilter((FileFilter)new ExcelFile());
        fc.setFileFilter((FileFilter)new Excel2007FileFilter());
        if (fc.showSaveDialog((Component)((Object)this)) == 0) {
            File file = fc.getSelectedFile();
            this.txtFilepath.setText(file.getPath());
            this.selectFilterFilter = fc.getFileFilter() instanceof ExcelFile ? ".xls" : ".xlsx";
        }
    }

    @Override
    protected void btnExport_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                List reList = BgCslFormExportUI.this.exportFile(BgCslFormExportUI.this.txtFilepath.getText());
                new BgFileUtil().storeDefaultPathForEXP((Object)BgCslFormExportUI.this.txtFilepath, (Object)BgCslFormExportUI.this.getUIContext());
                return reList;
            }

            public void afterExec(Object result) throws Exception {
                UIContext uiContext = new UIContext((Object)BgCslFormExportUI.this);
                uiContext.put((Object)"EXAMINE_DATA", result);
                uiContext.put((Object)"UI_TITLE", (Object)BgCslFormExportUI.this.exportTitle());
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgExportResultUI.class.getName(), (Map)uiContext);
                uiWindow.show();
                BgCslFormExportUI.this.getUIWindow().close();
            }
        });
        dialog.show();
    }

    protected String exportTitle() {
        return EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"title_export_bgCslForm");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List exportFile(String filepath) throws Exception {
        ArrayList _exportInfoList = new ArrayList();
        try {
            HashMap<String, String> orgDir = new HashMap<String, String>();
            this.buildOrgDir(orgDir, this.orgUnitNode, this.orgUnitNode);
            this.exportExcelFile(orgDir, filepath, _exportInfoList);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return _exportInfoList;
    }

    protected void exportExcelFile(Map<String, String> orgDir, String filepath, List exportInfoList) {
        if (!this.form.isEmpty()) {
            if (this.form.get("adj") != null) {
                this.isExportCslAdjFormInfo = true;
                this.exportExcelFile(orgDir, filepath, this.form.get("adj"), exportInfoList);
            }
            if (this.form.get("work") != null) {
                this.isExportWorkPaperInfo = true;
                this.isExportCslAdjFormInfo = false;
                this.exportExcelFile(orgDir, filepath, this.form.get("work"), exportInfoList);
            }
            if (this.form.get("csl") != null) {
                this.isExportWorkPaperInfo = false;
                this.isExportCslAdjFormInfo = false;
                this.exportExcelFile(orgDir, filepath, this.form.get("csl"), exportInfoList);
            }
        } else {
            this.exportExcelFile(orgDir, filepath, this.bgForms, exportInfoList);
        }
    }

    private void buildOrgDir(Map<String, String> orgDir, DefaultKingdeeTreeNode rootNode, DefaultKingdeeTreeNode node) {
        this.buildOrgDirName(orgDir, rootNode, node);
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.buildOrgDir(orgDir, rootNode, (DefaultKingdeeTreeNode)node.getChildAt(i));
        }
    }

    private void buildOrgDirName(Map<String, String> orgDir, DefaultKingdeeTreeNode rootNode, DefaultKingdeeTreeNode node) {
        StringBuffer name = new StringBuffer();
        String number = ((OrgStructureInfo)node.getUserObject()).getUnit().getNumber();
        while (node != rootNode) {
            if (name.length() > 0) {
                name.insert(0, "/");
            }
            name.insert(0, node.getText());
            node = (DefaultKingdeeTreeNode)node.getParent();
        }
        if (name.length() > 0) {
            name.insert(0, "/");
        }
        name.insert(0, node.getText());
        orgDir.put(number, name.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportExcelFile(Map<String, String> orgDir, String filepath, IObjectCollection bgFormList, List exportInfoList) {
        if (orgDir == null || StringUtils.isEmpty((String)filepath) || bgFormList == null || bgFormList.isEmpty()) {
            return;
        }
        ExportManager em = null;
        KDSBook _kdsBook = null;
        Book _book = null;
        String[] _exportInfo = null;
        long ct = System.currentTimeMillis();
        logger.info((Object)("start new BgCslViewListFormExportProcessor : " + ct));
        if (this.isExportCslAdjFormInfo) {
            BgCslAdjFormInfo _bgFormInfo = null;
            for (int i = 0; i < bgFormList.size(); ++i) {
                _bgFormInfo = ((BgCslAdjFormCollection)bgFormList).get(i);
                boolean isOver = false;
                try {
                    if (this.selectFilterFilter == null || ".xlsx".equals(this.selectFilterFilter)) {
                        if (_bgFormInfo.getBgCslTemplate().getFormType().getValue() == 0 || _bgFormInfo.getBgCslTemplate().getFormType().getValue() == 8) {
                            _book = (Book)this.exportFixExcelFile(_bgFormInfo, file2007Format);
                        } else if (_bgFormInfo.getBgCslTemplate().getFormType().getValue() == 2) {
                            // empty if block
                        }
                        BookDataWrapper bookDataWrapper = new BookDataWrapper(_book);
                        bookDataWrapper.setExportHideCols(true);
                        bookDataWrapper.setExportHideRows(true);
                        if (this.rbDataANDExpression.isSelected()) {
                            bookDataWrapper.setExportFormula(true);
                            bookDataWrapper.setExportCustomerFomulas(true);
                        } else if (this.rbDataANDExcelExpression.isSelected()) {
                            bookDataWrapper.setExportFormula(true);
                            bookDataWrapper.setExportCustomerFomulas(false);
                        } else if (this.rbData.isSelected()) {
                            bookDataWrapper.setExportFormula(false);
                            bookDataWrapper.setExportCustomerFomulas(false);
                        }
                        SXSSFExportWrapper booksc = new SXSSFExportWrapper((AbstractDataWrapper)bookDataWrapper);
                        String fileName = filepath + ("/" + orgDir.get(_bgFormInfo.getOrgUnit().getNumber()) + "/" + this.getFileName((IObjectValue)_bgFormInfo, (OrgUnitInfo)_bgFormInfo.getOrgUnit(), file2007Format)).replaceAll(" ", "");
                        this.makeDir(fileName);
                        File file = new File(fileName);
                        if (file.exists()) {
                            if (file.delete()) {
                                file = new File(fileName);
                            } else {
                                _exportInfo = new String[]{_bgFormInfo.getOrgUnit().getName(), _bgFormInfo.getNumber() + " - " + _bgFormInfo.getName(), com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"export_error") + BgCommCHelper.getMessageStr((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"openedfile")};
                                exportInfoList.add(_exportInfo);
                                continue;
                            }
                        }
                        booksc.write(fileName);
                    } else {
                        if (_bgFormInfo.getBgCslTemplate().getFormType().getValue() == 0 || _bgFormInfo.getBgCslTemplate().getFormType().getValue() == 8) {
                            _kdsBook = (KDSBook)this.exportFixExcelFile(_bgFormInfo, file2003Format);
                        } else if (_bgFormInfo.getBgCslTemplate().getFormType().getValue() == 2) {
                            // empty if block
                        }
                        em = new ExportManager();
                        em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_TRUE, (Object)"true");
                        em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_FALSE, (Object)"true");
                        em.setExporterParmeter(ExporterParameter.EXPORT_FORMAT, (Object)"true");
                        em.setExporterParmeter(ExporterParameter.EXPORT_STYLE, (Object)"true");
                        if (this.rbDataANDExpression.isSelected()) {
                            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
                            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
                            em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"true");
                        } else if (this.rbDataANDExcelExpression.isSelected()) {
                            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
                            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
                            em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
                        } else if (this.rbData.isSelected()) {
                            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"false");
                        }
                        long ct1 = System.currentTimeMillis();
                        this.exportDirectory(filepath, orgDir.get(_bgFormInfo.getOrgUnit().getNumber()));
                        int Excel2003_MaxColCount = 256;
                        KDSSheet srcSheet = null;
                        if (_kdsBook != null) {
                            for (int j = 0; j < _kdsBook.getSheetCount(); ++j) {
                                srcSheet = _kdsBook.getSheet((Object)j);
                                if (srcSheet.getColumnCount() <= 256) continue;
                                isOver = true;
                                break;
                            }
                            if (!isOver) {
                                String fileName = filepath + ("/" + orgDir.get(_bgFormInfo.getOrgUnit().getNumber()) + "/" + this.getFileName((IObjectValue)_bgFormInfo, (OrgUnitInfo)_bgFormInfo.getOrgUnit(), file2003Format)).replaceAll(" ", "");
                                File file = new File(fileName);
                                if (file.exists()) {
                                    if (file.delete()) {
                                        file = new File(fileName);
                                    } else {
                                        _exportInfo = new String[]{_bgFormInfo.getOrgUnit().getName(), _bgFormInfo.getNumber() + " - " + _bgFormInfo.getName(), com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"export_error") + BgCommCHelper.getMessageStr((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"openedfile")};
                                        exportInfoList.add(_exportInfo);
                                        continue;
                                    }
                                }
                                em.exportToExcel(_kdsBook, fileName);
                            }
                        }
                        logger.info((Object)("end exportToExcel : " + (System.currentTimeMillis() - ct1) + "ms"));
                    }
                    _exportInfo = new String[]{_bgFormInfo.getOrgUnit().getName(), _bgFormInfo.getNumber() + " - " + _bgFormInfo.getName(), isOver ? com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGNBUDGETAutoGenerateResource", (String)"110_BgExportHelper") : com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"export_succeed")};
                    exportInfoList.add(_exportInfo);
                    continue;
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                    if (_bgFormInfo == null) continue;
                    _exportInfo = new String[]{_bgFormInfo.getOrgUnit().getName(), _bgFormInfo.getNumber() + " - " + _bgFormInfo.getName(), com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"export_error")};
                    exportInfoList.add(_exportInfo);
                    continue;
                }
                finally {
                    _kdsBook = null;
                }
            }
        } else if (!this.isExportWorkPaperInfo) {
            BgCslFormInfo _bgFormInfo = null;
            BgCslViewListFormExportProvider viewlistExportProcessor = new BgCslViewListFormExportProvider((BgCslFormCollection)bgFormList, this);
            for (int i = 0; i < bgFormList.size(); ++i) {
                _bgFormInfo = ((BgCslFormCollection)bgFormList).get(i);
                boolean isOver = false;
                try {
                    if (this.selectFilterFilter == null || ".xlsx".equals(this.selectFilterFilter)) {
                        if (_bgFormInfo.getBgCslTemplate().getFormType().getValue() == 0 || _bgFormInfo.getBgCslTemplate().getFormType().getValue() == 8) {
                            _book = (Book)this.exportFixExcelFile(_bgFormInfo, file2007Format);
                        } else if (_bgFormInfo.getBgCslTemplate().getFormType().getValue() == 2) {
                            _book = (Book)this.exportViewListExcelFile(_bgFormInfo.getId().toString(), viewlistExportProcessor, file2007Format);
                        }
                        BookDataWrapper bookDataWrapper = new BookDataWrapper(_book);
                        bookDataWrapper.setExportHideCols(true);
                        bookDataWrapper.setExportHideRows(true);
                        if (this.rbDataANDExpression.isSelected()) {
                            bookDataWrapper.setExportFormula(true);
                            bookDataWrapper.setExportCustomerFomulas(true);
                        } else if (this.rbDataANDExcelExpression.isSelected()) {
                            bookDataWrapper.setExportFormula(true);
                            bookDataWrapper.setExportCustomerFomulas(false);
                        } else if (this.rbData.isSelected()) {
                            bookDataWrapper.setExportFormula(false);
                            bookDataWrapper.setExportCustomerFomulas(false);
                        }
                        SXSSFExportWrapper booksc = new SXSSFExportWrapper((AbstractDataWrapper)bookDataWrapper);
                        String fileName = filepath + ("/" + orgDir.get(_bgFormInfo.getOrgUnit().getNumber()) + "/" + this.getFileName((IObjectValue)_bgFormInfo, (OrgUnitInfo)_bgFormInfo.getOrgUnit(), file2007Format)).replaceAll(" ", "");
                        this.makeDir(fileName);
                        File file = new File(fileName);
                        if (file.exists()) {
                            if (file.delete()) {
                                file = new File(fileName);
                            } else {
                                _exportInfo = new String[]{_bgFormInfo.getOrgUnit().getName(), _bgFormInfo.getNumber() + " - " + _bgFormInfo.getName(), com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"export_error") + BgCommCHelper.getMessageStr((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"openedfile")};
                                exportInfoList.add(_exportInfo);
                                continue;
                            }
                        }
                        booksc.write(fileName);
                    } else {
                        if (_bgFormInfo.getBgCslTemplate().getFormType().getValue() == 0 || _bgFormInfo.getBgCslTemplate().getFormType().getValue() == 8) {
                            _kdsBook = (KDSBook)this.exportFixExcelFile(_bgFormInfo, file2003Format);
                        } else if (_bgFormInfo.getBgCslTemplate().getFormType().getValue() == 2) {
                            _kdsBook = (KDSBook)this.exportViewListExcelFile(_bgFormInfo.getId().toString(), viewlistExportProcessor, file2003Format);
                        }
                        em = new ExportManager();
                        em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_TRUE, (Object)"true");
                        em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_FALSE, (Object)"true");
                        em.setExporterParmeter(ExporterParameter.EXPORT_FORMAT, (Object)"true");
                        em.setExporterParmeter(ExporterParameter.EXPORT_STYLE, (Object)"true");
                        if (this.rbDataANDExpression.isSelected()) {
                            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
                            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
                            em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"true");
                        } else if (this.rbDataANDExcelExpression.isSelected()) {
                            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
                            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
                            em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
                        } else if (this.rbData.isSelected()) {
                            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"false");
                        }
                        long ct1 = System.currentTimeMillis();
                        this.exportDirectory(filepath, orgDir.get(_bgFormInfo.getOrgUnit().getNumber()));
                        int Excel2003_MaxColCount = 256;
                        KDSSheet srcSheet = null;
                        if (_kdsBook != null) {
                            for (int j = 0; j < _kdsBook.getSheetCount(); ++j) {
                                srcSheet = _kdsBook.getSheet((Object)j);
                                if (srcSheet.getColumnCount() <= 256) continue;
                                isOver = true;
                                break;
                            }
                            if (!isOver) {
                                String fileName = filepath + ("/" + orgDir.get(_bgFormInfo.getOrgUnit().getNumber()) + "/" + this.getFileName((IObjectValue)_bgFormInfo, (OrgUnitInfo)_bgFormInfo.getOrgUnit(), file2003Format)).replaceAll(" ", "");
                                File file = new File(fileName);
                                if (file.exists()) {
                                    if (file.delete()) {
                                        file = new File(fileName);
                                    } else {
                                        _exportInfo = new String[]{_bgFormInfo.getOrgUnit().getName(), _bgFormInfo.getNumber() + " - " + _bgFormInfo.getName(), com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"export_error") + BgCommCHelper.getMessageStr((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"openedfile")};
                                        exportInfoList.add(_exportInfo);
                                        continue;
                                    }
                                }
                                em.exportToExcel(_kdsBook, fileName);
                            }
                        }
                        logger.info((Object)("end exportToExcel : " + (System.currentTimeMillis() - ct1) + "ms"));
                    }
                    _exportInfo = new String[]{_bgFormInfo.getOrgUnit().getName(), _bgFormInfo.getNumber() + " - " + _bgFormInfo.getName(), isOver ? com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGNBUDGETAutoGenerateResource", (String)"110_BgExportHelper") : com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"export_succeed")};
                    exportInfoList.add(_exportInfo);
                    continue;
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                    if (_bgFormInfo == null) continue;
                    _exportInfo = new String[]{_bgFormInfo.getOrgUnit().getName(), _bgFormInfo.getNumber() + " - " + _bgFormInfo.getName(), com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"export_error")};
                    exportInfoList.add(_exportInfo);
                    continue;
                }
                finally {
                    _kdsBook = null;
                }
            }
        } else if (this.isExportWorkPaperInfo) {
            MbgWorkPaperInfo _mbgWorkPaperInfo = null;
            MbgWorkPaperExportProvider viewlistExportProcessor = new MbgWorkPaperExportProvider((MbgWorkPaperCollection)bgFormList, this);
            for (int i = 0; i < bgFormList.size(); ++i) {
                _mbgWorkPaperInfo = ((MbgWorkPaperCollection)bgFormList).get(i);
                boolean isOver = false;
                try {
                    if (this.selectFilterFilter == null || ".xlsx".equals(this.selectFilterFilter)) {
                        _book = (Book)this.exportViewListExcelFile(_mbgWorkPaperInfo.getId().toString(), viewlistExportProcessor, file2007Format);
                        BookDataWrapper bookDataWrapper = new BookDataWrapper(_book);
                        bookDataWrapper.setExportHideCols(true);
                        bookDataWrapper.setExportHideRows(true);
                        if (this.rbDataANDExpression.isSelected()) {
                            bookDataWrapper.setExportFormula(true);
                            bookDataWrapper.setExportCustomerFomulas(true);
                        } else if (this.rbDataANDExcelExpression.isSelected()) {
                            bookDataWrapper.setExportFormula(true);
                            bookDataWrapper.setExportCustomerFomulas(false);
                        } else if (this.rbData.isSelected()) {
                            bookDataWrapper.setExportFormula(false);
                            bookDataWrapper.setExportCustomerFomulas(false);
                        }
                        SXSSFExportWrapper booksc = new SXSSFExportWrapper((AbstractDataWrapper)bookDataWrapper);
                        String fileName = filepath + ("/" + orgDir.get(_mbgWorkPaperInfo.getOrgUnit().getNumber()) + "/" + this.getFileName((IObjectValue)_mbgWorkPaperInfo, (OrgUnitInfo)_mbgWorkPaperInfo.getOrgUnit(), file2007Format)).replaceAll(" ", "");
                        this.makeDir(fileName);
                        File file = new File(fileName);
                        if (file.exists()) {
                            if (file.delete()) {
                                file = new File(fileName);
                            } else {
                                _exportInfo = new String[]{_mbgWorkPaperInfo.getOrgUnit().getName(), _mbgWorkPaperInfo.getNumber() + " - " + _mbgWorkPaperInfo.getName(), com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"export_error") + BgCommCHelper.getMessageStr((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"openedfile")};
                                exportInfoList.add(_exportInfo);
                                continue;
                            }
                        }
                        booksc.write(fileName);
                    } else {
                        _kdsBook = (KDSBook)this.exportViewListExcelFile(_mbgWorkPaperInfo.getId().toString(), viewlistExportProcessor, file2003Format);
                        em = new ExportManager();
                        em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_TRUE, (Object)"true");
                        em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_FALSE, (Object)"true");
                        em.setExporterParmeter(ExporterParameter.EXPORT_FORMAT, (Object)"true");
                        em.setExporterParmeter(ExporterParameter.EXPORT_STYLE, (Object)"true");
                        if (this.rbDataANDExpression.isSelected()) {
                            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
                            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
                            em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"true");
                        } else if (this.rbDataANDExcelExpression.isSelected()) {
                            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
                            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
                            em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
                        } else if (this.rbData.isSelected()) {
                            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"false");
                        }
                        long ct1 = System.currentTimeMillis();
                        this.exportDirectory(filepath, orgDir.get(_mbgWorkPaperInfo.getOrgUnit().getNumber()));
                        int Excel2003_MaxColCount = 256;
                        KDSSheet srcSheet = null;
                        for (int j = 0; j < _kdsBook.getSheetCount(); ++j) {
                            srcSheet = _kdsBook.getSheet((Object)j);
                            if (srcSheet.getColumnCount() <= 256) continue;
                            isOver = true;
                            break;
                        }
                        if (!isOver) {
                            String fileName = filepath + ("/" + orgDir.get(_mbgWorkPaperInfo.getOrgUnit().getNumber()).replace("\\", "-") + "/" + this.getFileName((IObjectValue)_mbgWorkPaperInfo, (OrgUnitInfo)_mbgWorkPaperInfo.getOrgUnit(), file2003Format)).replaceAll(" ", "");
                            File file = new File(fileName);
                            if (file.exists()) {
                                if (file.delete()) {
                                    file = new File(fileName);
                                } else {
                                    _exportInfo = new String[]{_mbgWorkPaperInfo.getOrgUnit().getName(), _mbgWorkPaperInfo.getNumber() + " - " + _mbgWorkPaperInfo.getName(), com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"export_error") + BgCommCHelper.getMessageStr((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"openedfile")};
                                    exportInfoList.add(_exportInfo);
                                    continue;
                                }
                            }
                            em.exportToExcel(_kdsBook, filepath + ("/" + orgDir.get(_mbgWorkPaperInfo.getOrgUnit().getNumber()).replace("\\", "-") + "/" + this.getFileName((IObjectValue)_mbgWorkPaperInfo, (OrgUnitInfo)_mbgWorkPaperInfo.getOrgUnit(), file2003Format)).replaceAll(" ", ""));
                        }
                        logger.info((Object)("end exportToExcel : " + (System.currentTimeMillis() - ct1) + "ms"));
                    }
                    _exportInfo = new String[]{_mbgWorkPaperInfo.getOrgUnit().getName(), _mbgWorkPaperInfo.getNumber() + " - " + _mbgWorkPaperInfo.getName(), isOver ? com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGNBUDGETAutoGenerateResource", (String)"110_BgExportHelper") : com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"export_succeed")};
                    exportInfoList.add(_exportInfo);
                    continue;
                }
                catch (Exception ex) {
                    logger.error((Object)"", (Throwable)ex);
                    if (_mbgWorkPaperInfo == null) continue;
                    _exportInfo = new String[]{_mbgWorkPaperInfo.getOrgUnit().getName(), _mbgWorkPaperInfo.getNumber() + " - " + _mbgWorkPaperInfo.getName(), com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"export_error")};
                    exportInfoList.add(_exportInfo);
                    continue;
                }
                finally {
                    _kdsBook = null;
                }
            }
        }
        logger.info((Object)("end new BgCslViewListFormExportProcessor : " + (System.currentTimeMillis() - ct) + "ms"));
    }

    protected void makeDir(String fileName) {
        File file = new File(fileName);
        File path = file.getParentFile();
        if (path == null || path.equals(file)) {
            return;
        }
        this.makeDir(path.getAbsolutePath());
        if (!path.exists()) {
            path.mkdir();
        }
    }

    protected Object exportFixExcelFile(BgCslAdjFormInfo _bgFormInfo, String fileFormat) throws Exception {
        Book _book = null;
        HashMap<String, BigDecimal> _muMap = new HashMap<String, BigDecimal>();
        BigDecimal _coefficient = null;
        BigDecimal bigDecimal = _coefficient = _bgFormInfo.getMeasureUnit() != null ? _bgFormInfo.getMeasureUnit().getCoefficient() : null;
        if (_bgFormInfo.getCslFormMeasureUnit() != null) {
            Iterator mes = _bgFormInfo.getCslFormMeasureUnit().iterator();
            while (mes.hasNext()) {
                CoreBaseInfo _muInfo;
                Object next = mes.next();
                if (next instanceof BgCslAdjFormMeasureUnitInfo) {
                    _muInfo = (BgCslAdjFormMeasureUnitInfo)next;
                    _muMap.put(_muInfo.getBgElement().getNumber(), _muInfo.getMeasureUnit().getCoefficient());
                    continue;
                }
                if (!(next instanceof BgCslFormMeasureUnitInfo)) continue;
                _muInfo = (BgCslFormMeasureUnitInfo)next;
                _muMap.put(_muInfo.getBgElement().getNumber(), _muInfo.getMeasureUnit().getCoefficient());
            }
        }
        Map _dataMap = BgCslAdjFormFactory.getRemoteInstance().getBgDataInfo(_bgFormInfo, (IMbgViewBase)BgCslFormHelper.getFormView(null, _bgFormInfo, this.schemeHelper));
        _book = _bgFormInfo.getBook();
        if (_book == null) {
            _book = Book.Manager.getNewBook();
        }
        _book.getProtection().deleteOperations();
        Book book = null;
        book = _book;
        BgNFSHelper.disableCal((Book)book);
        BgNFSHelper.disableUndo((Book)book);
        this.refillFixBook(_book, _dataMap, _bgFormInfo);
        HashMap<String, Object> _tmpMap = new HashMap<String, Object>();
        _tmpMap.put("EXPORT_BOOK", book);
        _tmpMap.put("EXPORT_COEFFICIENT", _coefficient);
        _tmpMap.put("EXPORT_MEASUREUNIT", _muMap);
        _tmpMap.put("EXPORT_BGFORMULA", null);
        _tmpMap.put("EXPORT_DATA", Boolean.TRUE);
        if (BgTemFormTypeEnum.SPECIALFORM.equals((Object)_bgFormInfo.getBgCslTemplate().getFormType()) && !_bgFormInfo.getBgSpecialItems().isEmpty() && !StringUtils.isEmpty((String)_bgFormInfo.getBgSpecialItems().get(0).getDimensionNumber())) {
            _tmpMap.put("bgSpecialItems", (Object)_bgFormInfo.getBgSpecialItems());
        }
        if (fileFormat.equals(file2007Format)) {
            return BgNFCHelper.exportExcel2007(_tmpMap);
        }
        if (fileFormat.equals(file2003Format)) {
            return BgNFCHelper.exportExcel(_tmpMap);
        }
        return BgNFCHelper.exportExcel(_tmpMap);
    }

    protected Object exportFixExcelFile(BgCslFormInfo _bgFormInfo, String fileFormat) throws Exception {
        Book _book = null;
        HashMap<String, BigDecimal> _muMap = new HashMap<String, BigDecimal>();
        BigDecimal _coefficient = null;
        BigDecimal bigDecimal = _coefficient = _bgFormInfo.getMeasureUnit() != null ? _bgFormInfo.getMeasureUnit().getCoefficient() : null;
        if (_bgFormInfo.getCslFormMeasureUnit() != null) {
            BgCslFormMeasureUnitInfo _muInfo = null;
            Iterator mes = _bgFormInfo.getCslFormMeasureUnit().iterator();
            while (mes.hasNext()) {
                _muInfo = (BgCslFormMeasureUnitInfo)mes.next();
                _muMap.put(_muInfo.getBgElement().getNumber(), _muInfo.getMeasureUnit().getCoefficient());
            }
        }
        Map _dataMap = BgCslFormFactory.getRemoteInstance().getBgDataInfo(_bgFormInfo, (IMbgViewBase)BgCslFormHelper.getFormView(null, _bgFormInfo, this.schemeHelper));
        _book = _bgFormInfo.getBook();
        if (_book == null) {
            _book = Book.Manager.getNewBook();
        }
        _book.getProtection().deleteOperations();
        Book book = null;
        book = _book;
        BgNFSHelper.disableCal((Book)book);
        BgNFSHelper.disableUndo((Book)book);
        this.refillFixBook(_book, _dataMap, _bgFormInfo);
        HashMap<String, Object> _tmpMap = new HashMap<String, Object>();
        _tmpMap.put("EXPORT_BOOK", book);
        _tmpMap.put("EXPORT_COEFFICIENT", _coefficient);
        _tmpMap.put("EXPORT_MEASUREUNIT", _muMap);
        _tmpMap.put("EXPORT_BGFORMULA", null);
        _tmpMap.put("EXPORT_DATA", Boolean.TRUE);
        if (BgTemFormTypeEnum.SPECIALFORM.equals((Object)_bgFormInfo.getBgCslTemplate().getFormType())) {
            _tmpMap.put("bgSpecialItems", (Object)_bgFormInfo.getBgSpecialItems());
        }
        if (fileFormat.equals(file2007Format)) {
            return BgNFCHelper.exportExcel2007(_tmpMap);
        }
        if (fileFormat.equals(file2003Format)) {
            return BgNFCHelper.exportExcel(_tmpMap);
        }
        return BgNFCHelper.exportExcel(_tmpMap);
    }

    private void refillFixBook(Book book, Map dataMap, BgCslAdjFormInfo bgFormInfo) throws EASBizException, BOSException {
        Sheet _sheet = null;
        Cell _cell = null;
        String formula = null;
        BgNDataInfo bgData = null;
        for (int s = 0; s < book.getSheetCount(); ++s) {
            _sheet = book.getSheet(s);
            for (int r = 0; r <= _sheet.getMaxRowIndex(); ++r) {
                for (int c = 0; c <= _sheet.getMaxColIndex(); ++c) {
                    _cell = _sheet.getCell(r, c, false);
                    formula = BgNFSHelper.getFormulaOfCell((Cell)_cell);
                    if (StringUtils.isEmpty((String)formula) || (bgData = (BgNDataInfo)dataMap.get(formula + "_" + bgFormInfo.getBgVersion().getNumber())) == null) continue;
                    if (this.cacheHelper.getBudgetScens().contains(bgData.getBgScenario())) {
                        if (bgData.getAdjustValue() != null) {
                            BgNFSHelper.setValue((Cell)_cell, (Object)bgData.getAdjustValue());
                            continue;
                        }
                        BgNFSHelper.setValue((Cell)_cell, (Object)bgData.getBudgetValue());
                        continue;
                    }
                    BgNFSHelper.setValue((Cell)_cell, (Object)bgData.getBizActual());
                }
            }
        }
    }

    private void refillFixBook(Book book, Map dataMap, BgCslFormInfo bgFormInfo) throws EASBizException, BOSException {
        Sheet _sheet = null;
        Cell _cell = null;
        String formula = null;
        BgNDataInfo bgData = null;
        for (int s = 0; s < book.getSheetCount(); ++s) {
            _sheet = book.getSheet(s);
            for (int r = 0; r <= _sheet.getMaxRowIndex(); ++r) {
                for (int c = 0; c <= _sheet.getMaxColIndex(); ++c) {
                    _cell = _sheet.getCell(r, c, false);
                    formula = BgNFSHelper.getFormulaOfCell((Cell)_cell);
                    if (StringUtils.isEmpty((String)formula) || (bgData = (BgNDataInfo)dataMap.get(formula + "_" + bgFormInfo.getBgVersion().getNumber())) == null) continue;
                    if (this.cacheHelper.getBudgetScens().contains(bgData.getBgScenario())) {
                        if (bgData.getAdjustValue() != null) {
                            BgNFSHelper.setValue((Cell)_cell, (Object)bgData.getAdjustValue());
                            continue;
                        }
                        BgNFSHelper.setValue((Cell)_cell, (Object)bgData.getBudgetValue());
                        continue;
                    }
                    BgNFSHelper.setValue((Cell)_cell, (Object)bgData.getBizActual());
                }
            }
        }
    }

    protected Object exportViewListExcelFile(String formId, ViewListProvider viewlistExportProcessor, String fileFormat) throws Exception {
        Book _book = this.getViewlistBook(formId, viewlistExportProcessor);
        MbgViewlistMeasureUnitHelper measureUnitHelper = new MbgViewlistMeasureUnitHelper(viewlistExportProcessor.getAccountDataTypeMap(), viewlistExportProcessor.getTemplateStyle(), BgElementHelper.getElementoObjMap(null));
        HashMap _muMap = new HashMap();
        _book.getProtection().deleteOperations();
        Book book = null;
        book = _book;
        BgNFSHelper.disableCal((Book)book);
        BgNFSHelper.disableUndo((Book)book);
        HashMap<String, Object> _tmpMap = new HashMap<String, Object>();
        _tmpMap.put("EXPORT_BOOK", book);
        _tmpMap.put("EXPORT_MEASUREUNIT", _muMap);
        _tmpMap.put("EXPORT_BGFORMULA", null);
        _tmpMap.put("EXPORT_DATA", Boolean.TRUE);
        _tmpMap.put("MbgViewlistMeasureUnitHelper", measureUnitHelper);
        _tmpMap.put("EXPORT_ROW_MEMBER_UNMERGE", Boolean.TRUE);
        _tmpMap.put("isProcessTitle", Boolean.TRUE);
        if (fileFormat.equals(file2007Format)) {
            return BgNFCHelper.exportExcel2007(_tmpMap);
        }
        if (fileFormat.equals(file2003Format)) {
            return BgNFCHelper.exportExcel(_tmpMap);
        }
        return BgNFCHelper.exportExcel(_tmpMap);
    }

    protected Book getViewlistBook(String formId, ViewListProvider viewlistExportProcessor) {
        Book _book = null;
        _book = !this.isExportWorkPaperInfo ? ((BgCslViewListFormExportProvider)viewlistExportProcessor).getBook(formId) : ((MbgWorkPaperExportProvider)viewlistExportProcessor).getBook(formId);
        return _book;
    }

    protected void exportDirectory(String filepath, String orgPath) {
        if (StringUtils.isEmpty((String)filepath) || orgPath == null) {
            return;
        }
        String[] ps = orgPath.split("/");
        for (int i = 0; i < ps.length; ++i) {
            File _file = new File(filepath = filepath + "/" + ps[i].replaceAll(" ", ""));
            if (_file.exists()) continue;
            _file.mkdir();
        }
    }

    protected String getFileName(IObjectValue _bgFormInfo, OrgUnitInfo orgUnitInfo, String fileFormat) {
        StringBuffer filename = new StringBuffer();
        filename = new StringBuffer();
        if (this.isExportCslAdjFormInfo) {
            filename.append(orgUnitInfo.getName().trim());
            filename.append("_");
            filename.append(((BgCslAdjFormInfo)_bgFormInfo).getBgScheme().getName().trim());
            filename.append("_");
            filename.append(((BgCslAdjFormInfo)_bgFormInfo).getNumber().trim());
            filename.append("_");
            filename.append(((BgCslAdjFormInfo)_bgFormInfo).getBgCslTemplate().getName().trim().replace("\\", "-"));
            filename.append("_");
            filename.append(((BgCslAdjFormInfo)_bgFormInfo).getBgPeriod().getName().trim());
            filename.append("_");
            filename.append(((BgCslAdjFormInfo)_bgFormInfo).getCurrency().getName().trim());
            filename.append("_");
            filename.append(((BgCslAdjFormInfo)_bgFormInfo).getBgVersion().getName().trim());
            filename.append(fileFormat);
        } else if (!this.isExportWorkPaperInfo) {
            filename.append(orgUnitInfo.getName().trim());
            filename.append("_");
            filename.append(((BgCslFormInfo)_bgFormInfo).getBgScheme().getName().trim());
            filename.append("_");
            filename.append(((BgCslFormInfo)_bgFormInfo).getNumber().trim());
            filename.append("_");
            filename.append(((BgCslFormInfo)_bgFormInfo).getBgCslTemplate().getName().trim().replace("\\", "-"));
            filename.append("_");
            filename.append(((BgCslFormInfo)_bgFormInfo).getBgPeriod().getName().trim());
            filename.append("_");
            filename.append(((BgCslFormInfo)_bgFormInfo).getCurrency().getName().trim());
            filename.append("_");
            filename.append(((BgCslFormInfo)_bgFormInfo).getBgVersion().getName().trim());
            filename.append(fileFormat);
        } else {
            filename.append(orgUnitInfo.getName().trim());
            filename.append("_");
            filename.append(((MbgWorkPaperInfo)_bgFormInfo).getBgScheme().getName().trim());
            filename.append("_");
            filename.append(((MbgWorkPaperInfo)_bgFormInfo).getNumber().trim());
            filename.append("_");
            filename.append(((MbgWorkPaperInfo)_bgFormInfo).getBgNWorkTemplate().getName().trim().replace("\\", "-"));
            filename.append("_");
            filename.append(((MbgWorkPaperInfo)_bgFormInfo).getBgPeriod().getName().trim());
            filename.append("_");
            filename.append(((MbgWorkPaperInfo)_bgFormInfo).getCurrency().getName().trim());
            filename.append("_");
            filename.append(((MbgWorkPaperInfo)_bgFormInfo).getBgVersion().getName().trim());
            filename.append(fileFormat);
        }
        return filename.toString();
    }

    protected String getViewPermission() {
        return "csl_mbgform01_list";
    }

    public IBookDimensionParse getBookDimensionParse() {
        return new BookDimensionClientParse();
    }

    public String getOrgPermission() {
        return null;
    }
}

