/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.client.OrgViewUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.client.utils.BgFileUtil;
import com.kingdee.eas.ma.bgcsl.client.AbstractBgCslTemplateExportBaseUI;
import com.kingdee.eas.ma.bgcsl.client.utils.BgCslTemplateToFileHelper;
import com.kingdee.eas.ma.mbg.client.BgExportResultUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.XmlFileFilter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public abstract class BgCslTemplateExportBaseUI
extends AbstractBgCslTemplateExportBaseUI {
    private static final long serialVersionUID = -1971580471566968441L;
    private static final Logger logger = CoreUIObject.getLogger(BgCslTemplateExportBaseUI.class);
    public static final String BASE_DIRTORY = "baseDirtory";
    private Set<String> ids = null;
    private String baseDirtory = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.rbXML.isSelected();
        this.ids = (Set)this.getUIContext().get("IDList");
        this.baseDirtory = (String)this.getUIContext().get(BASE_DIRTORY);
    }

    @Override
    protected void btnSelectPath_actionPerformed(ActionEvent e) throws Exception {
        KDFileChooser fc = new BgFileUtil().getFileChooserForExp((Object)this.getUIContext());
        fc.setFileSelectionMode(1);
        fc.setDialogTitle(BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"export"));
        fc.addChoosableFileFilter((FileFilter)new XmlFileFilter());
        if (fc.showSaveDialog((Component)((Object)this)) == 0) {
            File file = fc.getSelectedFile();
            this.txtFilepath.setText(file.getPath());
        }
    }

    @Override
    protected void btnExport_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                IObjectPK pk = BgCslTemplateExportBaseUI.this.writeLog();
                List reList = BgCslTemplateExportBaseUI.this.exportFile(BgCslTemplateExportBaseUI.this.txtFilepath.getText(), BgCslTemplateExportBaseUI.this.ids);
                new BgFileUtil().storeDefaultPathForEXP((Object)BgCslTemplateExportBaseUI.this.txtFilepath, (Object)BgCslTemplateExportBaseUI.this.getUIContext());
                if (pk != null) {
                    LogUtil.afterLog(null, (IObjectPK)pk);
                }
                return reList;
            }

            public void afterExec(Object result) throws Exception {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"EXAMINE_DATA", result);
                uiContext.put((Object)"UI_TITLE", (Object)BgCslTemplateExportBaseUI.this.exportTitle());
                IUIWindow uiWindow = UIFactory.createUIFactory((String)BgCslTemplateExportBaseUI.this.getModel()).create(BgExportResultUI.class.getName(), (Map)uiContext);
                uiWindow.show();
            }
        });
        dialog.show();
        this.getUIWindow().close();
    }

    protected abstract IObjectPK writeLog();

    protected abstract String exportTitle();

    protected void verify() throws Exception {
        if (StringUtils.isEmpty((String)this.txtFilepath.getText())) {
            this.txtFilepath.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"selectOutFilepath"));
            SysUtil.abort();
        } else {
            File file = new File(this.txtFilepath.getText());
            if (!file.isDirectory()) {
                this.txtFilepath.requestFocus();
                MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"errorFilepath"));
                SysUtil.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List exportFile(String filepath, Set<String> bgTemplateIds) throws Exception {
        Set<String> permOrgSet;
        DefaultKingdeeTreeNode node;
        Map<String, Set<String>> orgMap;
        Map<String, Object> xmlMap;
        Map<String, IObjectValue> infoMap;
        ArrayList _exportInfoList;
        block7: {
            _exportInfoList = new ArrayList();
            if (bgTemplateIds == null || bgTemplateIds.isEmpty()) {
                return _exportInfoList;
            }
            infoMap = this.getInfoMap(this.ids);
            xmlMap = this.getXmlMap(this.ids, infoMap);
            orgMap = this.getOrgMap(this.ids, infoMap);
            node = this.getTreeNode(infoMap);
            permOrgSet = this.getPermissionOrgSet(orgMap);
            if (infoMap != null && !infoMap.isEmpty()) break block7;
            ArrayList arrayList = _exportInfoList;
            return arrayList;
        }
        try {
            this.exportOrgUnitFile(node, _exportInfoList, filepath, infoMap, xmlMap, orgMap, permOrgSet);
        }
        catch (BOSException ex) {
            logger.error((Object)ex);
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return _exportInfoList;
    }

    protected abstract Set<String> getPermissionOrgSet(Map<String, Set<String>> var1) throws BOSException, EASBizException;

    protected abstract DefaultKingdeeTreeNode getTreeNode(Map<String, IObjectValue> var1) throws BOSException;

    protected Map<String, Set<String>> getOrgMap(Set<String> ids, Map<String, IObjectValue> infoMap) throws BOSException {
        HashMap<String, Set<String>> orgMap = new HashMap<String, Set<String>>();
        if (infoMap != null) {
            String orgId = null;
            for (IObjectValue value : infoMap.values()) {
                orgId = this.getOrgId(value);
                if (!orgMap.containsKey(orgId)) {
                    orgMap.put(orgId, new HashSet());
                }
                ((Set)orgMap.get(orgId)).add(((CoreBaseInfo)value).getId().toString());
            }
        }
        return orgMap;
    }

    protected abstract CoreBaseInfo getOrgUnitInfo(IObjectValue var1);

    protected final String getOrgId(IObjectValue value) {
        return this.getOrgUnitInfo(value).getId().toString();
    }

    protected final Set<String> getAllPermission(Map<String, Set<String>> orgMap) {
        return new HashSet<String>(orgMap.keySet());
    }

    protected final DefaultKingdeeTreeNode getDefaultNode(Map<String, IObjectValue> infoMap) {
        if (infoMap == null || infoMap.isEmpty()) {
            return null;
        }
        CoreBaseInfo orgInfo = (CoreBaseInfo)this.getUIContext().get("orgTreeInfo");
        return new DefaultKingdeeTreeNode((Object)orgInfo);
    }

    protected abstract Map<String, Object> getXmlMap(Set<String> var1, Map<String, IObjectValue> var2) throws BOSException;

    protected abstract Map<String, IObjectValue> getInfoMap(Set<String> var1) throws BOSException, Exception;

    protected void exportOrgUnitFile(DefaultKingdeeTreeNode node, List exportInfoList, String filepath, Map<String, IObjectValue> infoMap, Map<String, Object> xmlMap, Map<String, Set<String>> orgMap, Set<String> permOrgSet) throws BOSException {
        if (infoMap == null || infoMap.isEmpty() || node == null || OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node)) {
            return;
        }
        String _tmpOrgUnitId = null;
        String _tmpbgFormId2 = null;
        String orgName = null;
        String _tmpFilepath = null;
        IObjectValue info = null;
        DefaultKingdeeTreeNode _node = null;
        CoreBaseInfo _oui = (CoreBaseInfo)node.getUserObject();
        if (_oui != null) {
            orgName = this.getOrgNameOfTree(_oui);
            _tmpOrgUnitId = this.getOrgIdOfTree(_oui);
            if (orgName == null) {
                return;
            }
            orgName = orgName.replaceAll(" ", "");
            this.exportDirectory(filepath, orgName);
            if (orgMap.containsKey(_tmpOrgUnitId)) {
                if (permOrgSet == null || permOrgSet.contains(_tmpOrgUnitId)) {
                    this.exportXmlFile(orgName, filepath, orgMap.get(_tmpOrgUnitId), exportInfoList, infoMap, xmlMap);
                } else {
                    Set<String> _tmpIds = orgMap.get(_tmpOrgUnitId);
                    for (String _tmpbgFormId2 : _tmpIds) {
                        info = infoMap.get(_tmpbgFormId2);
                        exportInfoList.add(this.buildReport(orgName, this.getNumber(info), this.getName(info), "errorPermission"));
                    }
                }
            }
            _tmpFilepath = filepath + "/" + orgName;
            int in = node.getChildCount();
            for (int i = 0; i < in; ++i) {
                _node = (DefaultKingdeeTreeNode)node.getChildAt(i);
                this.exportOrgUnitFile(_node, exportInfoList, _tmpFilepath, infoMap, xmlMap, orgMap, permOrgSet);
            }
        }
    }

    protected String getOrgIdOfTree(CoreBaseInfo _oui) {
        return _oui.getId().toString();
    }

    protected String getOrgNameOfTree(CoreBaseInfo _oui) {
        return this.getName((IObjectValue)_oui);
    }

    protected void exportDirectory(String filepath, String orgName) {
        if (StringUtils.isEmpty((String)filepath) || orgName == null) {
            return;
        }
        File _file = new File(filepath + "/" + orgName.replaceAll(" ", ""));
        if (!_file.exists()) {
            _file.mkdir();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportXmlFile(String baseDirtory, String filepath, Set<String> bgTemplateIds, List exportInfoList, Map<String, IObjectValue> infoMap, Map<String, Object> xmlMap) {
        if (StringUtils.isEmpty((String)filepath)) {
            return;
        }
        String _bgTempleteId2 = null;
        String filename = null;
        String number = null;
        String name = null;
        IObjectValue info = null;
        Object xmlObject = null;
        Object _book = null;
        for (String _bgTempleteId2 : bgTemplateIds) {
            try {
                info = infoMap.get(_bgTempleteId2);
                xmlObject = xmlMap.get(_bgTempleteId2);
                number = this.getNumber(info);
                name = this.getName(info);
                filename = this.getFileName(baseDirtory, number, name);
                BgNFSHelper.disableCal(_book);
                BgNFSHelper.disableUndo(_book);
                BgCslTemplateToFileHelper.saveDataToFile(info, filepath + ("/" + baseDirtory + "/" + filename + ".data").replaceAll(" ", ""));
                if (xmlObject instanceof Book) {
                    IOHelper.saveToFile((Book)((Book)xmlObject), (String)(filepath + ("/" + baseDirtory + "/" + filename + ".xml").replaceAll(" ", "")));
                } else if (xmlObject instanceof byte[]) {
                    BgCslTemplateToFileHelper.saveDimension((byte[])xmlObject, filepath + ("/" + baseDirtory + "/" + filename + ".xml").replaceAll(" ", ""));
                }
                exportInfoList.add(this.buildReport(baseDirtory, number, name, EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"export_succeed")));
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                if (info == null) continue;
                exportInfoList.add(this.buildReport(baseDirtory, number, name, EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"export_error")));
            }
            finally {
                _book = null;
            }
        }
    }

    protected String[] buildReport(String baseDirtory, String number, String name, String result) {
        String[] r = new String[]{baseDirtory, number + " - " + name, result};
        return r;
    }

    protected String getFileName(String baseDirtory, String number, String name) {
        return baseDirtory.trim() + "_" + name.trim() + "_" + number.trim();
    }

    protected String getNumber(IObjectValue info) {
        return info.getString("number");
    }

    protected String getName(IObjectValue info) {
        return info.getString("name");
    }

    protected String getModel() {
        if (this.getUIWindow() instanceof Frame) {
            return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
        }
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected static IPermission getPermissionInterface() throws Exception {
        return PermissionFactory.getRemoteInstance();
    }

    protected String getMessageStr(String key) {
        return !StringUtils.isEmpty((String)key) ? EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgNFormResource", (String)key) : "";
    }
}

