/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.OrgViewUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.IDataBase;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.client.utils.BgFileUtil;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateException;
import com.kingdee.eas.ma.bgcsl.BgNWorkTemplateFacadeFactory;
import com.kingdee.eas.ma.bgcsl.client.AbstractBgCslTemplateImportBaseUI;
import com.kingdee.eas.ma.bgcsl.client.utils.BgCslTemplateToFileHelper;
import com.kingdee.eas.ma.bgcsl.utils.BgCslSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.BgMemberSelectTypeEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.BgTemplateException;
import com.kingdee.eas.ma.mbg.client.BgNTemplateImportResultUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IMbgSheetBase;
import com.kingdee.eas.ma.mbg.common.IMbgSheetManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.XmlFileFilter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.eas.util.encryptalgorithm.Base64;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public abstract class BgCslTemplateImportBaseUI
extends AbstractBgCslTemplateImportBaseUI {
    private static final long serialVersionUID = 4446055870243182062L;
    private static final Logger logger = CoreUIObject.getLogger(BgCslTemplateImportBaseUI.class);
    private IObjectValue orgInfo = null;
    private BgSchemeDimensionHelper schemeHelper = null;
    private Map<String, Map<String, Boolean>> memberExistInfo = new HashMap<String, Map<String, Boolean>>();

    protected String getMessageStr(String key) {
        return !StringUtils.isEmpty((String)key) ? EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgNFormResource", (String)key) : "";
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.rbXML.isSelected();
        this.orgInfo = (IObjectValue)this.getUIContext().get("orgTreeInfo");
    }

    public IObjectValue getOrgInfo() {
        return this.orgInfo;
    }

    protected BgSchemeInfo getBgScheme() {
        return (BgSchemeInfo)this.getUIContext().get("BGSCHEME_INFO");
    }

    protected BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        if (this.schemeHelper == null) {
            this.schemeHelper = new BgCslSchemeDimensionHelper(this.getBgScheme().getId().toString());
        }
        return this.schemeHelper;
    }

    protected void verify() throws Exception {
        if (StringUtils.isEmpty((String)this.txtFilepath.getText())) {
            this.txtFilepath.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"selectOutFilepath"));
            SysUtil.abort();
        } else {
            File file = new File(this.txtFilepath.getText());
            if (!file.isDirectory()) {
                this.txtFilepath.requestFocus();
                MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"errorFilepath"));
                SysUtil.abort();
            }
        }
    }

    @Override
    protected void btnSelectPath_actionPerformed(ActionEvent e) throws Exception {
        KDFileChooser fc = new BgFileUtil().getFileChooserForImp((Object)this.getUIContext());
        fc.setFileSelectionMode(1);
        fc.setDialogTitle(BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"import"));
        fc.addChoosableFileFilter((FileFilter)new XmlFileFilter());
        if (fc.showSaveDialog((Component)((Object)this)) == 0) {
            File file = fc.getSelectedFile();
            this.txtFilepath.setText(file.getPath());
        }
    }

    @Override
    protected void btnImport_actionPerformed(ActionEvent e) throws Exception {
        super.btnImport_actionPerformed(e);
        this.verify();
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                Map result = null;
                try {
                    result = BgCslTemplateImportBaseUI.this.importFile(BgCslTemplateImportBaseUI.this.txtFilepath.getText());
                    new BgFileUtil().storeDefaultPathForIMP((Object)BgCslTemplateImportBaseUI.this.txtFilepath, (Object)BgCslTemplateImportBaseUI.this.getUIContext());
                }
                catch (Exception ex) {
                    BgCslTemplateImportBaseUI.this.handUIExceptionAndAbort(ex);
                }
                if (result != null && result instanceof Map) {
                    BgCslTemplateImportBaseUI.this.openImportResultViewUI(result);
                }
                return result;
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        dialog.show();
        this.getUIWindow().close();
    }

    protected void openImportResultViewUI(Object obj) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"EXAMINE_DATA", obj);
        uiContext.put((Object)"UI_TITLE", (Object)this.importTitle());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.openImportResultModel()).create(BgNTemplateImportResultUI.class.getName(), (Map)uiContext);
        uiWindow.show();
    }

    protected abstract String importTitle();

    protected String openImportResultModel() {
        if (this.getUIWindow() instanceof Frame) {
            return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
        }
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    public Map importFile(String filepath) throws Exception {
        HashMap<String, Cloneable> resultMap = new HashMap<String, Cloneable>();
        HashMap dataMap = new HashMap();
        ArrayList orgUnitList = new ArrayList();
        HashMap imOrgUnitMap = new HashMap();
        HashMap imOrgFileMap = new HashMap();
        resultMap.put("IMPORT_ORGUNIT_LIST", orgUnitList);
        resultMap.put("IMPORT_ORGUNIT_INFO", imOrgUnitMap);
        resultMap.put("IMPORT_ORGUNIT_FILES", imOrgFileMap);
        DefaultKingdeeTreeNode node = this.getTreeNode();
        Set<String> permOrgSet = this.getPermissionOrgSet();
        this.importOrgUnitFile(node, filepath, resultMap, dataMap, permOrgSet);
        return resultMap;
    }

    protected DefaultKingdeeTreeNode getTreeNode() throws BOSException {
        return new DefaultKingdeeTreeNode((Object)this.orgInfo);
    }

    protected Set<String> getPermissionOrgSet() throws EASBizException, BOSException {
        return null;
    }

    private void importOrgUnitFile(DefaultKingdeeTreeNode node, String filepath, Map resultMap, Map dataMap, Set<String> permOrgSet) throws Exception {
        if (node == null || OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node) || node.getUserObject() == null) {
            return;
        }
        CoreBaseInfo orgInfo = (CoreBaseInfo)node.getUserObject();
        String orgName = this.getOrgNameOfTree(orgInfo);
        if (orgName == null) {
            return;
        }
        orgName = orgName.replaceAll(" ", "");
        File _file = null;
        File _tmpFile2 = null;
        File[] _files = null;
        _file = new File(filepath);
        if (_file.exists() && _file.isDirectory()) {
            for (File _tmpFile2 : _file.listFiles()) {
                if (_tmpFile2 == null || !_tmpFile2.isDirectory() || !_tmpFile2.getName().equalsIgnoreCase(orgName)) continue;
                String _tmpFilepath = filepath + "/" + orgName;
                this.importXMLlFile(orgInfo, _tmpFilepath, resultMap, dataMap);
                for (int i = 0; i < node.getChildCount(); ++i) {
                    DefaultKingdeeTreeNode _node = (DefaultKingdeeTreeNode)node.getChildAt(i);
                    this.importOrgUnitFile(_node, _tmpFilepath, resultMap, dataMap, permOrgSet);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importXMLlFile(CoreBaseInfo orgInfo, String filepath, Map resultMap, Map dataMap) throws BOSException, EASBizException {
        File _file = null;
        File _tmpFile = null;
        File[] _files = null;
        List orgUnitList = (List)resultMap.get("IMPORT_ORGUNIT_LIST");
        Map imOrgUnitMap = (Map)resultMap.get("IMPORT_ORGUNIT_INFO");
        Map imOrgFileMap = (Map)resultMap.get("IMPORT_ORGUNIT_FILES");
        HashMap imFileResultMap = new HashMap();
        ArrayList<String> imFileName = new ArrayList<String>();
        ArrayList<String> imFileResult = new ArrayList<String>();
        imFileResultMap.put("IMPORT_FILES_NAME", imFileName);
        imFileResultMap.put("IMPORT_FILES_RESULT", imFileResult);
        String _orgUnitId = this.getOrgIdOfTree(orgInfo);
        String _succeed = BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"import_succeed");
        orgUnitList.add(_orgUnitId);
        imOrgUnitMap.put(_orgUnitId, this.getOrgNameOfTree(orgInfo));
        imOrgFileMap.put(_orgUnitId, imFileResultMap);
        _file = new File(filepath);
        List list = this.getExistNumbers(this.getBgScheme().getId().toString(), this.getOrgIdOfTree(orgInfo));
        if (_file.exists() && _file.isDirectory() && orgInfo != null) {
            _files = _file.listFiles();
            if (!_file.getName().equals(this.getOrgNameOfTree(orgInfo).replaceAll(" ", ""))) {
                imFileName.add(this.getMessageStr("bgNtemplaetExportOrgs") + _file.getName());
                imFileResult.add(this.getMessageStr("bgNtemplaetExportNotOrgs"));
            }
            IObjectValue infoObject = null;
            Object xmlObject = null;
            BgTemFormTypeEnum formType = null;
            File file = null;
            String checkDimension = null;
            IMbgViewBase view = null;
            int count = _files.length;
            for (int index = 0; index < count; ++index) {
                _tmpFile = _files[index];
                try {
                    if (!this.checkFilenameData(_tmpFile)) continue;
                    infoObject = BgCslTemplateToFileHelper.getDataToFile(_tmpFile.toString());
                    formType = this.getFormType(infoObject);
                    file = this.getFile(_files, _tmpFile.getName());
                    if (file == null) continue;
                    if (!file.getName().substring(file.getName().lastIndexOf(".")).equals(".xml")) {
                        imFileName.add(this.getMessageStr("bgNtemplaetExportWaringFile"));
                        imFileResult.add(this.getMessageStr("bgNtemplaetImportFaild"));
                        break;
                    }
                    if (list.contains(this.getNumber(infoObject))) {
                        imFileName.add(file.getName());
                        imFileResult.add(this.getOrgNameOfTree(orgInfo) + ": " + this.getMessageStr("bgNtemplaetImportTemplateHave"));
                        continue;
                    }
                    xmlObject = BgCslTemplateToFileHelper.loadXmlObject(file, formType);
                    view = this.getViewManager(xmlObject);
                    checkDimension = this.checkDimension(view, this.getSpecialItems(infoObject, xmlObject));
                    if (checkDimension != null) {
                        imFileName.add(file.getName());
                        imFileResult.add(checkDimension);
                        continue;
                    }
                    this.addInfo(infoObject, formType, xmlObject, view, orgInfo);
                    imFileName.add(file.getName());
                    imFileResult.add(_succeed);
                }
                catch (Exception ex) {
                    if (imFileName != null && file != null && imFileResult != null) {
                        imFileName.add(file.getName());
                        imFileResult.add(this.getMessageStr("bgnTemplateImportException") + ex.getMessage());
                    }
                    logger.error((Object)"", (Throwable)ex);
                }
                continue;
            }
            this.batchSave();
        } else {
            imFileName.add(this.getMessageStr("bgNtemplaetExportOrgs") + _file.getName());
            imFileResult.add(this.getMessageStr("bgNtemplateImportNotAddNewPermission"));
        }
    }

    protected abstract void batchSave() throws EASBizException, BOSException;

    protected abstract void addInfo(IObjectValue var1, BgTemFormTypeEnum var2, Object var3, IMbgViewBase var4, CoreBaseInfo var5) throws Exception;

    protected abstract List<BgDimensionInfo> getSpecialItems(IObjectValue var1, Object var2) throws EASBizException, BOSException;

    private IMbgViewBase getViewManager(Object xmlObject) throws BOSException, EASBizException {
        if (xmlObject instanceof IMbgViewBase) {
            return (IMbgViewBase)xmlObject;
        }
        if (xmlObject instanceof Book) {
            Book book = (Book)xmlObject;
            List formulaList = BgNFSHelper.getFormulaListOfBook((Book)book);
            return DimensionFormulaHelper.buildViewMamager(null, (Collection)formulaList, null);
        }
        return null;
    }

    protected abstract BgTemFormTypeEnum getFormType(IObjectValue var1) throws BgCslTemplateException;

    protected Map getBookUserObject(Book book, String key) {
        if (book != null && book.getUserObjectValue(key) instanceof String) {
            return (Map)BgAnalyseHelper.getObject((byte[])Base64.decode((String)((String)book.getUserObjectValue(key))));
        }
        return new HashMap();
    }

    private File getFile(File[] _files, String fileName) {
        for (int i = 0; i < _files.length; ++i) {
            String name;
            if (!_files[i].isFile() || !(name = _files[i].getName().substring(0, _files[i].getName().lastIndexOf("."))).equals(fileName.substring(0, fileName.lastIndexOf("."))) || this.checkFilenameData(_files[i])) continue;
            return _files[i];
        }
        return null;
    }

    private OrgUnitInfo checkHasPermmision(String diretoryName, FullOrgUnitCollection orgCol) {
        FullOrgUnitInfo orgUnitInfo = null;
        for (int i = 0; i < orgCol.size(); ++i) {
            orgUnitInfo = orgCol.get(i);
            if (!diretoryName.equals(orgUnitInfo.getName().trim())) continue;
            return orgUnitInfo;
        }
        return null;
    }

    private boolean checkFilenameData(File file) {
        boolean flage = false;
        if (file == null || StringUtils.isEmpty((String)file.getName()) || file.isDirectory()) {
            return false;
        }
        String _filename = file.getName();
        String postfix = null;
        if (_filename.indexOf(".") != -1) {
            postfix = _filename.substring(_filename.lastIndexOf("."));
        }
        if (postfix != null && postfix.equalsIgnoreCase(".data")) {
            flage = true;
        }
        return flage;
    }

    private String checkDimension(IMbgViewBase view, List<BgDimensionInfo> specialDims) throws EASBizException, BOSException {
        String result;
        IMbgViewManager _view;
        List dimensions = null;
        List schemeDims = this.getSchemeHelper().getAllDim();
        for (int s = 0; s < view.getSheetManagers().size(); ++s) {
            dimensions = ((IMbgSheetBase)view.getSheetManagers().get(0)).getDimensionManager().getDimension();
            HashSet<String> dimNumbers = new HashSet<String>();
            for (int i = 0; i < dimensions.size(); ++i) {
                if (!(dimensions.get(i) instanceof BgDimensionBaseInfo)) continue;
                dimNumbers.add(((BgDimensionBaseInfo)dimensions.get(i)).getNumber());
            }
            if (specialDims != null) {
                for (BgDimensionInfo dim : specialDims) {
                    dimNumbers.add(dim.getNumber());
                }
            }
            if (schemeDims.size() != dimNumbers.size()) {
                return EASResource.getString((String)"com.kingdee.eas.ma.mbg.ViewListTemplateResource", (String)"ViewListImportDimError");
            }
            dimNumbers.removeAll(schemeDims);
            if (dimNumbers.isEmpty()) continue;
            return EASResource.getString((String)"com.kingdee.eas.ma.mbg.ViewListTemplateResource", (String)"ViewListImportDimError");
        }
        HashMap<String, Set<String>> queryMembers = new HashMap<String, Set<String>>();
        if (view instanceof IMbgViewManager) {
            _view = (IMbgViewManager)view;
            BgDimensionInfo dimension = null;
            if (_view.getSheetManagers().size() > 0) {
                for (int d = 0; d < ((IMbgSheetManager)_view.getSheetManagers().get(0)).getDimensionManager().getDimension().size(); ++d) {
                    dimension = (BgDimensionInfo)((IMbgSheetManager)_view.getSheetManagers().get(0)).getDimensionManager().getDimension().get(d);
                    for (int m = 0; m < dimension.getMember().size(); ++m) {
                        if (!queryMembers.containsKey(dimension.getNumber())) {
                            queryMembers.put(dimension.getNumber(), new HashSet());
                        }
                        ((Set)queryMembers.get(dimension.getNumber())).add(((BgDimensionMember)dimension.getMember().get(m)).getNumber());
                    }
                }
            }
        } else if (view instanceof MbgViewListManager) {
            _view = (MbgViewListManager)view;
            for (int s = 0; s < _view.getSheetManagers().size(); ++s) {
                dimensions = ((MbgViewListSheetManager)_view.getSheetManagers().get(s)).getDimensionManager().getAllDimensions();
                ArrayList members = new ArrayList();
                String number = null;
                for (int d = 0; d < dimensions.size(); ++d) {
                    MbgViewListDimensionInfo dimension;
                    if (!(dimensions.get(d) instanceof MbgViewListDimensionInfo) || !BgMemberSelectTypeEnum.Member.equals((Object)(dimension = (MbgViewListDimensionInfo)dimensions.get(d)).getMemberType())) continue;
                    members.clear();
                    members.addAll(dimension.getSelectMembers());
                    members.addAll(dimension.getCanAddMember());
                    for (int m = 0; m < members.size(); ++m) {
                        number = null;
                        if (members.get(m) instanceof BgPeriodInfo) {
                            number = ((BgPeriodInfo)members.get(m)).getNumber();
                        } else if (members.get(m) instanceof BgDimensionMember) {
                            number = ((BgDimensionMember)members.get(m)).getNumber();
                        }
                        if (number == null) continue;
                        if (!queryMembers.containsKey(dimension.getNumber())) {
                            queryMembers.put(dimension.getNumber(), new HashSet());
                        }
                        ((Set)queryMembers.get(dimension.getNumber())).add(number);
                    }
                }
            }
        }
        if ((result = this.checkMembers(queryMembers)) != null) {
            return result;
        }
        if (queryMembers.isEmpty()) {
            return null;
        }
        this.readMembers(queryMembers);
        return this.checkMembers(queryMembers);
    }

    private void readMembers(Map<String, Set<String>> queryMembers) throws BOSException, EASBizException {
        Map result = BgNWorkTemplateFacadeFactory.getRemoteInstance().checkMemberExists(this.schemeHelper.getBgSchemeId(), queryMembers, ((OrgTreeInfo)this.orgInfo).getId().toString());
        String dimNumber2 = null;
        for (String dimNumber2 : result.keySet()) {
            if (!this.memberExistInfo.containsKey(dimNumber2)) {
                this.memberExistInfo.put(dimNumber2, (Map<String, Boolean>)result.get(dimNumber2));
                continue;
            }
            this.memberExistInfo.get(dimNumber2).putAll((Map)result.get(dimNumber2));
        }
    }

    private String checkMembers(Map<String, Set<String>> queryMembers) {
        String dimNumber = null;
        Iterator<String> itDim = queryMembers.keySet().iterator();
        while (itDim.hasNext()) {
            dimNumber = itDim.next();
            if (!this.memberExistInfo.containsKey(dimNumber)) continue;
            Iterator<String> itMember = queryMembers.get(dimNumber).iterator();
            while (itMember.hasNext()) {
                String number = itMember.next();
                if (DimensionConstants.DEF_PERIOD_NUMBER.equals(dimNumber) && BgPeriodNVariableHelper.checkCanConvert((String)number)) {
                    itMember.remove();
                    continue;
                }
                if (!this.memberExistInfo.get(dimNumber).containsKey(number)) continue;
                if (Boolean.TRUE.equals(this.memberExistInfo.get(dimNumber).get(number))) {
                    itMember.remove();
                    continue;
                }
                return EASResource.getString((String)"com.kingdee.eas.ma.mbg.ViewListTemplateResource", (String)"ViewListImportMemberError");
            }
            if (!queryMembers.get(dimNumber).isEmpty()) continue;
            itDim.remove();
        }
        return null;
    }

    protected abstract List getExistNumbers(String var1, String var2) throws EASBizException, BOSException;

    protected String getOrgNameOfTree(CoreBaseInfo orgInfo) {
        return orgInfo.getString("name");
    }

    protected String getOrgIdOfTree(CoreBaseInfo _oui) {
        return _oui.getId().toString();
    }

    protected String getOrgId(IObjectValue orgInfo) {
        return orgInfo.getString("id").toString();
    }

    protected String getNumber(IObjectValue info) {
        return info.getString("number");
    }

    protected DataBaseInfo readDataBase(IDataBase instance, DataBaseInfo dataBaseInfo, NumericExceptionSubItem checkEmptyException) throws BOSException, BgTemplateException {
        if (dataBaseInfo == null) {
            return null;
        }
        DataBaseCollection col = null;
        col = dataBaseInfo instanceof MeasureUnitInfo ? instance.getDataBaseCollection("select id, number, name where id = '" + dataBaseInfo.getId() + "' and isDisabled = 0 ") : instance.getDataBaseCollection("select id, number, name where id = '" + dataBaseInfo.getId() + "' OR number = '" + dataBaseInfo.getNumber() + "'");
        if (col != null && !col.isEmpty()) {
            return col.get(0);
        }
        if (checkEmptyException != null) {
            throw new BgTemplateException(checkEmptyException, new Object[]{dataBaseInfo.getNumber()});
        }
        return null;
    }
}

