/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateException;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateFactory;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateInfo;
import com.kingdee.eas.ma.bgcsl.client.AbstractBgCslTemplateImportUI;
import com.kingdee.eas.ma.bgcsl.utils.BgSpecialCommonHelper;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListXMLParser;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class BgCslTemplateImportUI
extends AbstractBgCslTemplateImportUI {
    private static final long serialVersionUID = 1816229202057188574L;
    private static final Logger logger = CoreUIObject.getLogger(BgCslTemplateImportUI.class);
    private CoreBaseCollection templates = new CoreBaseCollection();

    @Override
    protected List getExistNumbers(String bgSchemeId, String orgId) throws EASBizException, BOSException {
        ArrayList<String> numbers = new ArrayList<String>();
        BgCslTemplateCollection col = BgCslTemplateFactory.getRemoteInstance().getBgCslTemplateCollection("select number where bgScheme.id = '" + bgSchemeId + "' and orgTree.id = '" + orgId + "'");
        if (col != null && !col.isEmpty()) {
            for (int i = 0; i < col.size(); ++i) {
                numbers.add(col.get(i).getNumber());
            }
        }
        return numbers;
    }

    @Override
    protected void addInfo(IObjectValue infoObject, BgTemFormTypeEnum formType, Object xmlObject, IMbgViewBase view, CoreBaseInfo orgUnitInfo) throws Exception {
        BgCslTemplateInfo info = this.getBgCslTemplateInfo(infoObject).deepClone();
        info.setBgScheme(this.getBgScheme());
        info.setOrgTree((OrgTreeInfo)this.getOrgInfo());
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
        if (info.getId() != null) {
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        }
        if (BgTemFormTypeEnum.FIXEDFORM.equals((Object)formType) || BgTemFormTypeEnum.SPECIALFORM.equals((Object)formType)) {
            info.setData(IOHelper.packBook((Book)((Book)xmlObject)));
            new MbgXMLParser();
            info.setDimensionData(MbgXMLParser.unParse((IMbgViewManager)((IMbgViewManager)view)));
        } else if (BgTemFormTypeEnum.VIEWLIST.equals((Object)formType)) {
            info.setDimensionData(new MbgViewListXMLParser().unParse((MbgViewListManager)view));
        } else if (BgTemFormTypeEnum.VIEWLIST.equals((Object)formType)) {
            new MbgXMLParser();
            info.setDimensionData(MbgXMLParser.unParse((IMbgViewManager)((IMbgViewManager)view)));
        }
        this.templates.add((CoreBaseInfo)info);
    }

    @Override
    protected void batchSave() throws EASBizException, BOSException {
        BgCslTemplateFactory.getRemoteInstance().addnewBatchData(this.templates);
    }

    @Override
    protected BgTemFormTypeEnum getFormType(IObjectValue infoObject) throws BgCslTemplateException {
        return this.getBgCslTemplateInfo(infoObject).getFormType();
    }

    @Override
    protected String importTitle() {
        return EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"title_import_bgCslTemplate");
    }

    protected BgCslTemplateInfo getBgCslTemplateInfo(IObjectValue infoObject) throws BgCslTemplateException {
        if (infoObject instanceof BgCslTemplateInfo) {
            return (BgCslTemplateInfo)infoObject;
        }
        throw new BgCslTemplateException(BgCslTemplateException.IMPORTTYPEERROR);
    }

    @Override
    protected List<BgDimensionInfo> getSpecialItems(IObjectValue infoObject, Object xmlObject) throws EASBizException, BOSException {
        return BgSpecialCommonHelper.getBgDimensions(this.getBgCslTemplateInfo(infoObject), this.getSchemeHelper());
    }
}

