/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.ma.bgcsl.BgCslSchemeFacadeFactory;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberInfo;
import com.kingdee.eas.ma.mbg.MemberTypeEnum;
import com.kingdee.eas.ma.mbg.client.ModelDimMemberF7UI;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgMergeSchemeHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class BgMergeScopeSelectF7UI
extends ModelDimMemberF7UI {
    private static final long serialVersionUID = -8598056965185860147L;
    private static final Logger logger = CoreUIObject.getLogger(BgMergeScopeSelectF7UI.class);
    protected static final String resource = "com.kingdee.eas.ma.mbg.DimensionCommonResource";
    protected static final String CSL_RS = "com.kingdee.eas.ma.bgcsl.client.BgCslSchemeResource";

    public void initWorkButton() {
        super.initWorkButton();
        this.btnAddAll.setEnabled(true);
    }

    protected void getMembers() throws Exception {
        String userId = (String)this.getUIContext().get("userId");
        CoreBaseCollection coll = BgMergeSchemeHelper.getMergeScopeList((String)userId);
        for (int i = 0; i < coll.size(); ++i) {
            OrgTreeInfo dbInfo = (OrgTreeInfo)coll.get(i);
            this.leftList.add(dbInfo);
            this.treeItems.put(dbInfo.getId().toString(), dbInfo);
        }
    }

    protected void checkDimMember() {
        DataBaseInfo item = null;
        ArrayList<DataBaseInfo> tmpList = new ArrayList<DataBaseInfo>();
        ArrayList blocks = this.tblLeft.getSelectManager().getBlocks();
        for (int i = 0; i < blocks.size(); ++i) {
            KDTBlock block = this.swapBlock((KDTBlock)blocks.get(i));
            int top = block.getTop();
            int bottom = block.getBottom();
            for (int j = top; j <= bottom; ++j) {
                if (j < 0) continue;
                item = (DataBaseInfo)this.tblLeft.getRow(j).getUserObject();
                tmpList.add(item);
            }
        }
        HashSet<String> existsNum = new HashSet<String>();
        for (BgDimSettingsMemberInfo member : this.rightList) {
            if (member.getMemberID() == null) continue;
            existsNum.add(member.getMemberID().toString());
        }
        HashSet<DataBaseInfo> rmItem = new HashSet<DataBaseInfo>();
        for (DataBaseInfo dbInfo : tmpList) {
            if (dbInfo.getId() == null || !existsNum.contains(dbInfo.getId().toString())) continue;
            rmItem.add(dbInfo);
        }
        tmpList.removeAll(rmItem);
        this.rightList.addAll(this.convertToMemberList(tmpList));
    }

    protected void btnAddAll_actionPerformed(ActionEvent e) throws Exception {
        HashSet<String> existsNum = new HashSet<String>();
        for (BgDimSettingsMemberInfo member : this.rightList) {
            if (member.getMemberID() == null) continue;
            existsNum.add(member.getMemberID().toString());
        }
        ArrayList<DataBaseInfo> tmpList = new ArrayList<DataBaseInfo>(this.tmpLeft);
        HashSet<DataBaseInfo> rmItem = new HashSet<DataBaseInfo>();
        for (DataBaseInfo dbInfo : tmpList) {
            if (dbInfo.getId() == null || !existsNum.contains(dbInfo.getId().toString())) continue;
            rmItem.add(dbInfo);
        }
        tmpList.removeAll(rmItem);
        this.rightList.addAll(this.convertToMemberList(tmpList));
        this.refreshTableRight();
    }

    protected List<BgDimSettingsMemberInfo> convertToMemberList(List<DataBaseInfo> items) {
        ArrayList<BgDimSettingsMemberInfo> memberList = new ArrayList<BgDimSettingsMemberInfo>();
        for (int i = 0; i < items.size(); ++i) {
            OrgTreeInfo item = (OrgTreeInfo)items.get(i);
            BgDimSettingsMemberInfo member = new BgDimSettingsMemberInfo();
            Timestamp startDate = item.getStartDate();
            Timestamp endDate = item.getEndDate();
            member.setAlies(this.generateName(item.getName(), startDate, endDate));
            member.setMemberID(item.getId());
            member.setNumber(item.getNumber());
            member.setName(item.getName());
            if (this.dimNumber.equals(DimensionConstants.DEF_ORGUNIT_NUMBER)) {
                member.setType(MemberTypeEnum.merge);
            }
            memberList.add(member);
        }
        return memberList;
    }

    protected void initTable() throws Exception {
        super.initTable();
        this.tblLeft.getColumn("orgViewType").getStyleAttributes().setHided(false);
        this.tblRight.getColumn("orgViewType").getStyleAttributes().setHided(false);
    }

    public void refreshTableLeft() {
        super.refreshTableLeft();
        int count = this.tblLeft.getRowCount3();
        for (int i = 0; i < count; ++i) {
            OrgTreeInfo item = (OrgTreeInfo)this.tmpLeft.get(i);
            this.tblLeft.getRow(i).getCell("name").setValue((Object)this.generateName(item.getName(), item.getStartDate(), item.getEndDate()));
            this.tblLeft.getRow(i).getCell("orgViewType").setValue((Object)EASResource.getString((String)resource, (String)"mergeScope"));
        }
    }

    public void refreshTableRight() {
        this.tblRight.removeRows();
        this.tmpRight = new ArrayList(this.rightList);
        String queryRight = StringUtils.trim((String)this.txtQuickQueryInputRight.getText());
        if (!StringUtils.isEmpty((String)queryRight) && !queryRight.equals(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"404_NewDimensionMemberF7UI"))) {
            this.tmpRight = this.filterRight(this.rightList, queryRight);
        }
        for (int i = 0; i < this.tmpRight.size(); ++i) {
            BgDimSettingsMemberInfo item = (BgDimSettingsMemberInfo)this.tmpRight.get(i);
            IRow row = this.tblRight.addRow();
            row.setUserObject((Object)item);
            row.getCell("number").setValue((Object)item.getNumber());
            row.getCell("name").setValue((Object)item.getAlies());
            if (this.dimNumber.equals(DimensionConstants.DEF_ORGUNIT_NUMBER)) {
                row.getCell("orgViewType").setValue((Object)item.getType());
            }
            row.getCell("orgViewType").setValue((Object)EASResource.getString((String)resource, (String)"mergeScope"));
        }
    }

    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        this.checkMergeScopeRef();
        super.btnOk_actionPerformed(e);
    }

    protected void checkMergeScopeRef() throws Exception {
        boolean isRef;
        HashSet<String> selectNumber = new HashSet<String>();
        HashSet<String> rmID = new HashSet<String>();
        for (BgDimSettingsMemberInfo member : this.rightList) {
            selectNumber.add(member.getNumber());
        }
        if (this.dimMembers != null) {
            for (BgDimSettingsMemberInfo member : this.dimMembers) {
                if (selectNumber.contains(member.getNumber())) continue;
                rmID.add(member.getMemberID().toString());
            }
        }
        if (rmID.size() > 0 && (isRef = BgCslSchemeFacadeFactory.getRemoteInstance().checkRefBgNWorkTemplateOrBgCslTemplate(this.bgScheme.getId().toString(), rmID))) {
            MsgBox.showWarning((String)EASResource.getString((String)CSL_RS, (String)"canNotRemoveScope"));
            SysUtil.abort();
        }
    }

    protected void tblLeft_tableClicked(KDTMouseEvent e) throws Exception {
        int clickCount;
        if (e.getType() == 1 && e.getClickCount() == 2) {
            this.btnAdd_actionPerformed(new ActionEvent(this.btnAdd, 0, null));
        }
        if (e.getType() == 0 && ((clickCount = e.getClickCount()) == 1 || clickCount == 2)) {
            return;
        }
    }

    protected void afterDataFill() {
    }

    protected void checkContainsCreateOrg() throws Exception {
    }

    protected void checkOrgView() {
    }

    public String generateName(String name, Timestamp startDate, Timestamp endDate) {
        StringBuffer buff = new StringBuffer(name);
        if (startDate != null) {
            buff.append("(").append(this.getDateString(startDate));
        }
        if (endDate != null) {
            buff.append("~").append(this.getDateString(endDate));
        }
        if (startDate != null || endDate != null) {
            buff.append(")");
        }
        return buff.toString();
    }

    private String getDateString(Timestamp ts) {
        if (ts == null) {
            return "";
        }
        DateFormat dtformat = BOSLocaleUtil.getDateFormat();
        return dtformat.format(new Date(ts.getTime()));
    }
}

