/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.bgcsl.BgCslException;
import com.kingdee.eas.ma.bgcsl.BgElimContextHelper;
import com.kingdee.eas.ma.bgcsl.BgNWorkTemplateFactory;
import com.kingdee.eas.ma.bgcsl.IBgNWorkTemplate;
import com.kingdee.eas.ma.bgcsl.client.AbstractBgNWorkTemplateListUI;
import com.kingdee.eas.ma.bgcsl.client.BgNWorkTemplateEditUI;
import com.kingdee.eas.ma.bgcsl.client.BgNWorkTemplateExportUI;
import com.kingdee.eas.ma.bgcsl.client.BgNWorkTemplateImportUI;
import com.kingdee.eas.ma.bgcsl.client.BgNWorkTemplateProcessUI;
import com.kingdee.eas.ma.bgcsl.client.IBgElimContextUI;
import com.kingdee.eas.ma.bgcsl.client.utils.BgCslClientHelper;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Observable;
import org.apache.log4j.Logger;

public class BgNWorkTemplateListUI
extends AbstractBgNWorkTemplateListUI
implements IBgElimContextUI {
    private static final long serialVersionUID = 6344170533354793119L;
    private static final Logger logger = CoreUIObject.getLogger(BgNWorkTemplateListUI.class);
    private static final String RES = "com.kingdee.eas.ma.bgcsl.BgNWorkTemplateResource";
    private final String COl_TEMPLATESTATUS = "templateStatus";
    private String curOpera = OprtState.ADDNEW;

    public void setCurOpera(String curOpera) {
        this.curOpera = curOpera;
    }

    public String getCurOpera() {
        return this.curOpera;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        if (BgElimContextHelper.isInitialized((CoreUIObject)this, this.getUIContext())) {
            super.onLoad();
            BgElimContextHelper.registUIObject(this);
        } else {
            SysUtil.abort();
        }
        this.init();
    }

    protected void init() throws Exception {
        this.initOrgTreeF7();
        this.initPrmptBgScheme();
    }

    private void initOrgTreeF7() throws Exception {
        BgCslClientHelper.initOrgTreeComboBox(this.combOrgTree);
    }

    protected void initPrmptBgScheme() throws Exception {
        BgSchemeInfo bgSchemeInfo = BgElimContextHelper.getBgElimContext().getCurBgScheme();
        if (bgSchemeInfo != null) {
            this.prmptBgScheme.setData((Object)bgSchemeInfo);
        }
        OrgTreeInfo orgTreeInfo = null;
        if (this.getOrgTreeInfo() != null) {
            orgTreeInfo = this.getOrgTreeInfo();
        } else if (BgElimContextHelper.getBgElimContext().getCurOrgBound() != null) {
            orgTreeInfo = BgElimContextHelper.getBgElimContext().getCurOrgBound();
        }
        BgCslClientHelper.setBgSchemeView(this.prmptBgScheme, orgTreeInfo);
    }

    protected BgSchemeInfo getBgSchemeInfo() {
        return this.prmptBgScheme.getData() instanceof BgSchemeInfo ? (BgSchemeInfo)this.prmptBgScheme.getData() : null;
    }

    protected OrgTreeInfo getOrgTreeInfo() {
        return (OrgTreeInfo)this.combOrgTree.getSelectedItem();
    }

    @Override
    protected void combOrgTree_itemStateChanged(ItemEvent e) throws Exception {
        super.combOrgTree_itemStateChanged(e);
        if (e.getStateChange() == 1) {
            return;
        }
        if (this.combOrgTree.getSelectedItem() instanceof OrgTreeInfo) {
            OrgTreeInfo orgTreeInfo = (OrgTreeInfo)this.combOrgTree.getSelectedItem();
            if (!(this.prmptBgScheme.getData() instanceof BgSchemeInfo) || !BgCslClientHelper.getSchemeIdsByOrgTree(orgTreeInfo).contains(((BgSchemeInfo)this.prmptBgScheme.getData()).getId().toString())) {
                this.prmptBgScheme.setDataNoNotify(null);
            }
            this.prmptBgScheme.setEntityViewInfo(null);
            BgCslClientHelper.setBgSchemeView(this.prmptBgScheme, orgTreeInfo);
        }
        this.tblMain.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void prmptBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        super.prmptBgScheme_dataChanged(e);
        BgSchemeInfo oldInfo = (BgSchemeInfo)e.getOldValue();
        BgSchemeInfo newInfo = (BgSchemeInfo)e.getNewValue();
        try {
            if (newInfo == null && e.getOldValue() != null && this.prmptBgScheme.getUserObject() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"isNullBgScheme"));
                this.prmptBgScheme.setDataNoNotify(e.getOldValue());
                SysUtil.abort();
            }
            this.tblMain.refresh();
        }
        finally {
            this.prmptBgScheme.setUserObject(null);
        }
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        FilterInfo filter = viewInfo.getFilter();
        if (filter == null) {
            filter = new FilterInfo();
            viewInfo.setFilter(filter);
        }
        FilterItemInfo itemInfo = null;
        itemInfo = this.getBgSchemeInfo() instanceof BgSchemeInfo ? new FilterItemInfo("bgScheme.id", (Object)this.getBgSchemeInfo().getId().toString(), CompareType.EQUALS) : new FilterItemInfo("bgScheme.id", (Object)BgBaseConstants.noFindStr, CompareType.EQUALS);
        BgCommCHelper.replaceFilterItems((FilterInfo)filter, (FilterItemInfo)itemInfo);
        itemInfo = this.getOrgTreeInfo() instanceof OrgTreeInfo ? new FilterItemInfo("orgTree.id", (Object)this.getOrgTreeInfo().getId().toString(), CompareType.EQUALS) : new FilterItemInfo("orgTree.id", (Object)BgBaseConstants.noFindStr, CompareType.EQUALS);
        BgCommCHelper.replaceFilterItems((FilterInfo)filter, (FilterItemInfo)itemInfo);
        FilterItemInfo item = null;
        item = !this.chkIsContainForbidden.isSelected() ? new FilterItemInfo("templateStatus".toLowerCase(), (Object)Integer.toString(0), CompareType.EQUALS) : new FilterItemInfo("templateStatus".toLowerCase(), (Object)-1, CompareType.NOTEQUALS);
        BgCommCHelper.replaceFilterItems((FilterInfo)viewInfo.getFilter(), (FilterItemInfo)item);
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    private void checkBgSchemeNull() {
        if (this.getBgSchemeInfo() == null || !(this.getBgSchemeInfo() instanceof BgSchemeInfo)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslTemplateResource", (String)"selectBgScheme"));
            SysUtil.abort();
        }
        BgCslClientHelper.checkHasCslScheme((CoreUI)this, this.getBgSchemeInfo().getId().toString(), this.getOrgTreeInfo().getId().toString());
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkBgSchemeNull();
        this.isBgSchemeIsFiling();
        this.setCurOpera(OprtState.ADDNEW);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.isBgSchemeIsFiling();
        super.actionRemove_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.isBgSchemeIsFiling();
        this.setCurOpera(OprtState.EDIT);
        super.actionEdit_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"unionid", (Object)this.getOrgTreeInfo().getId().toString());
        this.prepareUIContext(uiContext, e);
        this.setCurOpera(OprtState.VIEW);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionClone_actionPerformed(ActionEvent e) throws Exception {
        super.actionClone_actionPerformed(e);
        this.isBgSchemeIsFiling();
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        IBgNWorkTemplate iBgTem = BgNWorkTemplateFactory.getRemoteInstance();
        iBgTem.clone((IObjectPK)new ObjectUuidPK(id));
        MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)RES, (String)"copySuccess"));
        this.actionRefresh_actionPerformed(e);
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        this.checkBgSchemeNull();
        this.checkSelected();
        String _bgTemplateId = null;
        String _number = null;
        String _name = null;
        String[] _bgTemplateInfo = null;
        HashMap<String, String[]> _tmpMap = new HashMap<String, String[]>();
        HashSet<String> bgTemplateIds = new HashSet<String>();
        KDTRange range = this.tblMain.getSelectManager().toRange();
        if (range != null) {
            int rowCount = range.size();
            for (int i = 0; i < rowCount; ++i) {
                KDTSelectBlock block = (KDTSelectBlock)range.get(i);
                int rowBegin = block.getBeginRow();
                int rowEnd = block.getEndRow();
                for (int j = rowBegin; j <= rowEnd; ++j) {
                    IRow row = this.tblMain.getRow(j);
                    if (row == null) continue;
                    _bgTemplateId = row.getCell("id").getValue().toString();
                    _number = row.getCell("number").getValue().toString();
                    _name = row.getCell("name").getValue().toString();
                    _bgTemplateInfo = new String[]{_bgTemplateId, _number, _name};
                    _tmpMap.put(_bgTemplateId, _bgTemplateInfo);
                    bgTemplateIds.add(_bgTemplateId);
                }
            }
        }
        if (_tmpMap.isEmpty()) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"IDList", bgTemplateIds);
        uiContext.put((Object)"orgTreeInfo", (Object)this.getOrgTreeInfo());
        uiContext.put((Object)"baseDirtory", (Object)this.getOrgTreeInfo().getName());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgNWorkTemplateExportUI.class.getName(), (Map)uiContext);
        uiWindow.show();
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
        this.checkBgSchemeNull();
        this.isBgSchemeIsFiling();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"BGSCHEME_INFO", (Object)this.getBgSchemeInfo());
        uiContext.put((Object)"orgTreeInfo", (Object)this.getOrgTreeInfo());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgNWorkTemplateImportUI.class.getName(), (Map)uiContext);
        uiWindow.show();
        this.refresh(e);
    }

    @Override
    protected void chkIsContainForbidden_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.refresh();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkBgSchemeNull();
        this.isBgSchemeIsFiling();
        this.checkSelected();
        HashSet ids = new HashSet(this.getSelectedIdValues());
        BgNWorkTemplateFactory.getRemoteInstance().cancel(ids);
        this.refresh(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkBgSchemeNull();
        this.isBgSchemeIsFiling();
        this.checkSelected();
        HashSet ids = new HashSet(this.getSelectedIdValues());
        BgNWorkTemplateFactory.getRemoteInstance().cancelCancel(ids);
        this.refresh(e);
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        KDTSelectBlock sb = null;
        int size = this.tblMain.getSelectManager().size();
        if (size == 0) {
            return;
        }
        int status = 0;
        boolean isCanCancel = false;
        boolean isCanCancelCancel = false;
        block0: for (int i = 0; i < size; ++i) {
            sb = this.tblMain.getSelectManager().get(i);
            int bottom = sb.getBottom();
            for (int j = sb.getTop(); j <= bottom; ++j) {
                if (j < 0) {
                    return;
                }
                status = 0;
                if (this.tblMain.getRow(j).getCell("templateStatus").getValue() != null && this.tblMain.getRow(j).getCell("templateStatus").getValue() instanceof BizEnumValueInfo) {
                    status = ((BizEnumValueInfo)this.tblMain.getRow(j).getCell("templateStatus").getValue()).getInt();
                } else if (this.tblMain.getRow(j).getCell("templateStatus").getValue() != null && this.tblMain.getRow(j).getCell("templateStatus").getValue() instanceof Integer) {
                    status = (Integer)this.tblMain.getRow(j).getCell("templateStatus").getValue();
                }
                if (status == 0 && isCanCancelCancel) {
                    isCanCancel = true;
                    continue block0;
                }
                if (status == 10 && isCanCancel) {
                    isCanCancelCancel = true;
                    continue block0;
                }
                if (status == 10) {
                    isCanCancelCancel = true;
                }
                if (status != 0) continue;
                isCanCancel = true;
            }
        }
        this.btnCancel.setEnabled(isCanCancel);
        this.menuItemCancel.setEnabled(isCanCancel);
        this.btnCancelCancel.setEnabled(isCanCancelCancel);
        this.menuItemCancelCancel.setEnabled(isCanCancelCancel);
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        int _state = 0;
        Object _obj = null;
        int in = e.getLastRow();
        for (int i = e.getFirstRow(); i <= in; ++i) {
            _state = -1;
            _obj = this.tblMain.getRow(i).getCell("templateStatus").getValue();
            if (_obj instanceof BizEnumValueInfo) {
                _state = ((BizEnumValueInfo)_obj).getInt();
            } else if (_obj instanceof Integer) {
                _state = (Integer)_obj;
            }
            if (_state != 10) continue;
            this.tblMain.getRow(i).getStyleAttributes().setBackground(new Color(230, 230, 230));
        }
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        if (this.getBgSchemeInfo() instanceof BgSchemeInfo) {
            uiContext.put((Object)"BGSCHEME_ID", (Object)this.getBgSchemeInfo().getId().toString());
            uiContext.put((Object)"BGSCHEME_INFO", (Object)this.getBgSchemeInfo());
        }
        if (this.getOrgTreeInfo() instanceof OrgTreeInfo) {
            uiContext.put((Object)"ORGTREE_INFO", (Object)this.getOrgTreeInfo());
        }
    }

    protected String getEditUIName() {
        if (OprtState.VIEW.equals(this.getCurOpera())) {
            return BgNWorkTemplateProcessUI.class.getName();
        }
        return BgNWorkTemplateEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgNWorkTemplateFactory.getRemoteInstance();
    }

    @Override
    public void update(Observable o, Object arg) {
        BgElimContextHelper.update(o, (CoreUI)this);
    }

    public boolean destroyWindow() {
        BgElimContextHelper.unRegistUIObject(this);
        return super.destroyWindow();
    }

    protected IObjectPK getOrgPK() {
        IObjectPK pk = this.getOrgGroupPk();
        if (pk == null) {
            pk = super.getOrgPK();
        }
        return pk;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        IObjectPK pk = this.getOrgGroupPk();
        if (pk == null) {
            pk = super.getOrgPK(action);
        }
        return pk;
    }

    protected IObjectPK getOrgGroupPk() {
        ObjectUuidPK pk = null;
        try {
            OrgUnitInfo orgUnitInfo = BgElimContextHelper.getBgElimContext().getCurOrgGroup();
            if (orgUnitInfo != null) {
                pk = new ObjectUuidPK(orgUnitInfo.getId());
            }
        }
        catch (BOSException e) {
            logger.error((Object)"get orgtree error", (Throwable)e);
        }
        return pk;
    }

    private void isBgSchemeIsFiling() throws EASBizException {
        if (this.prmptBgScheme.getData() instanceof BgSchemeInfo && ((BgSchemeInfo)this.prmptBgScheme.getData()).isIsFiling()) {
            throw new BgCslException(BgCslException.CSLSCHEMEFILLED);
        }
    }
}

