/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.IOrgTree;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.MbgViewInfo;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.bgcsl.client.AbstractBgSchemeMergeScopeEditUI;
import com.kingdee.eas.ma.bgcsl.client.utils.BgMergeScopeSelectDialog;
import com.kingdee.eas.ma.bgcsl.utils.BgCslSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.BgDimSettingsCollection;
import com.kingdee.eas.ma.mbg.BgDimSettingsFactory;
import com.kingdee.eas.ma.mbg.BgDimSettingsInfo;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberCollection;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.DimGroupCollection;
import com.kingdee.eas.ma.mbg.MemberTypeEnum;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgMergeSchemeHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.MbgPermissionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgSchemeMergeScopeEditUI
extends AbstractBgSchemeMergeScopeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BgSchemeMergeScopeEditUI.class);
    private static final String RS = "com.kingdee.eas.ma.bgcsl.client.BgCslSchemeResource";
    public static final Color REQUIRED_COLOR = new Color(252, 251, 223);
    private BgSchemeDimensionHelper schemeHelper = null;

    public BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        if (this.schemeHelper == null) {
            this.schemeHelper = new BgCslSchemeDimensionHelper(null, this.editData.getId().toString(), this.editData.getOrgUnit().getId().toString());
        }
        return this.schemeHelper;
    }

    public void onLoad() throws Exception {
        if (this.getUIContext().get("ID") != null) {
            this.prmtBgScheme.setEnabled(false);
        }
        super.onLoad();
        this.setBgSchemeFilter(false, false);
        if (this.getOprtState().equals(OprtState.EDIT) || this.getOprtState().equals(OprtState.VIEW)) {
            this.prmtBgScheme.setDataNoNotify((Object)this.editData);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnDimGroup.setEnabled(true);
        this.btnDimGroup.setIcon(EASResource.getIcon((String)"imgTbtn_pagesetting"));
        this.prmtBgSchemeType.setEnabled(false);
        this.btnUpdateDimName.setVisible(false);
    }

    protected void loadData() throws Exception {
        super.loadData();
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.pkDateFrom.setValue(null);
            this.pkDateTo.setValue(null);
            this.bizOrgUnit.setValue(null);
            this.prmtBgSchemeType.setValue(null);
            this.txtNumber.setEnabled(false);
            this.pkDateFrom.setEnabled(false);
        }
    }

    protected void initOldData(IObjectValue dataObject) {
        DimGroupCollection coll = this.editData.getDimGroup();
        for (int i = 0; i < coll.size(); ++i) {
            coll.get(i).setId(null);
        }
        super.initOldData(dataObject);
    }

    public void setBgSchemeFilter(boolean isOnlyExp, boolean isOnlyFixle) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("number"));
        view.setSorter(sorter);
        filter.getFilterItems().add(new FilterItemInfo("bgSchemeType.schemeType", (Object)69));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)((OrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO)).getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isFiling", (Object)false, CompareType.EQUALS));
        this.prmtBgScheme.setEntityViewInfo(view);
        filter = MbgPermissionHelper.addBgSchemePermission((RptSrcTypeEnum)BgNFCHelper.getSourceType((IUIObject)this), (String)SysContext.getSysContext().getCurrentUserInfo().getId().toString(), (FilterInfo)this.prmtBgScheme.getEntityViewInfo().getFilter());
        this.prmtBgScheme.getEntityViewInfo().setFilter(filter);
    }

    @Override
    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() == null) {
            this.prmtBgScheme.setDataNoNotify(e.getOldValue());
            return;
        }
        this.setOprtState(OprtState.EDIT);
        this.getUIContext().put("ID", ((BgSchemeInfo)e.getNewValue()).getId().toString());
        this.loadData();
        this.initTblDim();
        this.initDimMemberF7();
        this.schemeHelper = null;
        this.initDimMemDefF7();
    }

    public void initTblDim() throws EASBizException, BOSException {
        super.initTblDim();
        this.mltName.setEnabled(false);
        this.prmtBgSchemeType.setEnabled(false);
        this.pkDateTo.setEnabled(false);
        this.btnAddRow.setEnabled(false);
        this.btnRemoveRow.setEnabled(false);
        this.tblDim.getColumn("dimNumber").setRequired(false);
        this.tblDim.getColumn("dimNumber").getStyleAttributes().setLocked(true);
        this.tblDim.getColumn("dimNumber").getStyleAttributes().setLocked(true);
        this.tblDim.getColumn("dimMembers").setRequired(false);
        this.tblDim.getColumn("dimMembers").getStyleAttributes().setLocked(true);
        if (this.tblDim.getRow(0) != null) {
            this.tblDim.getRow(0).getCell("dimMembers").getStyleAttributes().setLocked(false);
            if (this.getOprtState().equals(OprtState.EDIT)) {
                this.tblDim.getRow(0).getCell("dimMembers").getStyleAttributes().setBackground(REQUIRED_COLOR);
            }
        }
        this.tblDim.getColumn("audit").getStyleAttributes().setLocked(true);
        this.tblDim.getColumn("defaultMember").getStyleAttributes().setLocked(true);
    }

    protected boolean checkHasMergeDim(BgSchemeInfo bgScheme) {
        if (bgScheme == null) {
            return false;
        }
        BgDimSettingsCollection coll = bgScheme.getBgDimSettings();
        for (int i = 0; i < coll.size(); ++i) {
            if (!coll.get(i).getDimNumber().equals(DimensionConstants.DEF_CSL_NUMBER)) continue;
            return true;
        }
        return false;
    }

    protected boolean checkIsCslScheme(BgSchemeInfo bgScheme) throws Exception {
        if (bgScheme == null) {
            return false;
        }
        BgDimSettingsCollection coll = BgDimSettingsFactory.getRemoteInstance().getBgDimSettingsCollection("where bgScheme.id = '" + bgScheme.getId().toString() + "' and dimNumber = '" + DimensionConstants.DEF_CSL_NUMBER + "'");
        return coll.size() > 0;
    }

    protected void addMergeDimToTblDim() {
        BgDimSettingsCollection coll = this.editData.getBgDimSettings();
        BgDimSettingsInfo setting = new BgDimSettingsInfo();
        setting.setDimNumber(DimensionConstants.DEF_CSL_NUMBER);
        setting.setDimName(DimensionConstants.DEF_CSL_NAME);
        setting.setSeq(coll.size() + 1);
        setting.setBgScheme(this.editData);
        this.editData.getBgDimSettings().add(setting);
        BgDimSettingsMemberInfo member = new BgDimSettingsMemberInfo();
        MbgViewInfo view = BgMergeSchemeHelper.getDefMergeDimView();
        member.setMemberID(view.getId());
        member.setNumber(view.getNumber());
        member.setName(view.getName());
        member.setType(MemberTypeEnum.view);
        member.setBgDimSettings(setting);
        setting.getMembers().add(member);
    }

    public void initDimMemberF7() {
        BgMergeScopeSelectDialog dialog = new BgMergeScopeSelectDialog((CoreUI)this);
        KDBizPromptBox prmtMembers = new KDBizPromptBox();
        prmtMembers.setDisplayFormat("$number$");
        prmtMembers.setEditable(false);
        prmtMembers.setSelector((KDPromptSelector)dialog);
        dialog.setCurrOrgUnitId((String)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID));
        dialog.setFullOrgUnit(this.getOrgUnitInfo());
        dialog.setF7((Component)prmtMembers);
        dialog.setBgScheme(this.editData);
        dialog.setOprtState(this.getOprtState());
        dialog.setDimNumber(DimensionConstants.DEF_ORGUNIT_NUMBER);
        dialog.setDimName(DimensionConstants.DEF_ORGUNIT_NAME);
        dialog.setUserId(this.getUserPk().toString());
        if (this.tblDim.getRow(0) != null) {
            this.tblDim.getRow(0).getCell("dimMembers").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtMembers));
        }
    }

    protected void tblDim_editStarted(KDTEditEvent e) throws Exception {
    }

    @Override
    public void storeFields() {
        try {
            this.editData.setIsCalcMbgBiz(this.kDIsCslcMbgBiz.isSelected());
            this.storeSettings();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    protected void storeDimGroup() {
    }

    @Override
    public void loadFields() {
        super.loadFields();
        BgMergeSchemeHelper.filterOrgViewByType((BgDimSettingsCollection)this.editData.getBgDimSettings(), (MemberTypeEnum)this.getOrgMemberType());
        this.generateBgMergeDimName(this.editData.getBgDimSettings(), this.getOrgMemberType());
        if (!this.checkHasMergeDim(this.editData)) {
            this.addMergeDimToTblDim();
        }
    }

    private void generateBgMergeDimName(BgDimSettingsCollection bgDimSettings, MemberTypeEnum orgMemberType) {
        HashMap<String, BgDimSettingsMemberInfo> dimSettMap = new HashMap<String, BgDimSettingsMemberInfo>();
        for (int i = 0; i < bgDimSettings.size(); ++i) {
            BgDimSettingsInfo dimSetting = bgDimSettings.get(i);
            if (!DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimSetting.getDimNumber())) continue;
            BgDimSettingsMemberCollection members = dimSetting.getMembers();
            for (int j = 0; j < members.size(); ++j) {
                BgDimSettingsMemberInfo dimMember = members.get(j);
                if (!orgMemberType.equals((Object)dimMember.getType())) continue;
                dimSettMap.put(dimMember.getMemberID().toString(), dimMember);
            }
        }
        if (dimSettMap == null || dimSettMap.size() == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectColl = new SelectorItemCollection();
        selectColl.add(new SelectorItemInfo("id"));
        selectColl.add(new SelectorItemInfo("startDate"));
        selectColl.add(new SelectorItemInfo("endDate"));
        view.setSelector(selectColl);
        FilterInfo filter = new FilterInfo();
        Set keySet = dimSettMap.keySet();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(keySet), CompareType.INCLUDE));
        view.setFilter(filter);
        try {
            IOrgTree remoteInstance = OrgTreeFactory.getRemoteInstance();
            OrgTreeCollection orgTreeColl = remoteInstance.getOrgTreeCollection(view);
            this.generateName(orgTreeColl, dimSettMap);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionDimGroup_actionPerformed(ActionEvent e) throws Exception {
        if (!this.checkIsCslScheme(this.editData)) {
            MsgBox.showWarning((String)EASResource.getString((String)RS, (String)"saveCslScheme"));
            SysUtil.abort();
        }
        if (this.prmtBgScheme.getData() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)RS, (String)"emptyBgScheme"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)BgBaseConstants.BGSCHEME_INFO, (Object)this.editData);
        uiContext.put((Object)BgBaseConstants.ORGUNIT_ID, (Object)this.getOrgUnitInfo().getId().toString());
        uiContext.put((Object)"schemeHelper", (Object)this.getSchemeHelper());
        uiContext.put((Object)"oprtState", (Object)this.getOprtState());
        IUIWindow ui = UIFactory.createUIFactory().create("com.kingdee.eas.ma.bgcsl.client.DimGroupEditUI", (Map)uiContext);
        ui.show();
    }

    protected MemberTypeEnum getOrgMemberType() {
        return MemberTypeEnum.merge;
    }

    protected boolean isFilterMergeDimension() {
        return false;
    }

    protected void verifyOrgViewCount(List<BgDimSettingsMemberInfo> members) {
    }

    protected void checkTemplate(BgDimSettingsCollection settingsColl) throws Exception {
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selector = super.getSelectors();
        selector.add(new SelectorItemInfo("isCalcMbgBiz"));
        selector.add(new SelectorItemInfo("bgDimSettings.*"));
        selector.add(new SelectorItemInfo("bgDimSettings.members.*"));
        return selector;
    }

    public boolean isModify() {
        if (this.prmtBgScheme.getData() == null) {
            return false;
        }
        return super.isModify();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.setBounds(new Rectangle(10, 10, 620, 480));
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.prmtBgScheme.getData() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)RS, (String)"emptyBgScheme"));
            SysUtil.abort();
        }
        super.verifyInput(e);
    }

    protected String getClassAlise() {
        return EASResource.getString((String)RS, (String)"bgCslScheme");
    }

    public void generateName(OrgTreeCollection orgTreeColl, Map<String, BgDimSettingsMemberInfo> dimSettMap) {
        for (int i = 0; i < orgTreeColl.size(); ++i) {
            StringBuffer buff = new StringBuffer();
            String orgId = orgTreeColl.get(i).getId().toString();
            if (!dimSettMap.containsKey(orgId)) continue;
            Timestamp startDate = orgTreeColl.get(i).getStartDate();
            Timestamp endDate = orgTreeColl.get(i).getEndDate();
            BgDimSettingsMemberInfo info = dimSettMap.get(orgId);
            buff.append(dimSettMap.get(orgId).getName());
            if (null != orgId) {
                if (startDate != null) {
                    buff.append("(").append(this.getDateString(startDate));
                }
                if (endDate != null) {
                    buff.append("~").append(this.getDateString(endDate));
                }
                if (startDate != null || endDate != null) {
                    buff.append(")");
                }
            }
            info.setAlies(buff.toString());
        }
    }

    private String getDateString(Timestamp ts) {
        if (ts == null) {
            return "";
        }
        DateFormat dtformat = BOSLocaleUtil.getDateFormat();
        return dtformat.format(new Date(ts.getTime()));
    }
}

