/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgVersionCollection;
import com.kingdee.eas.ma.base.BgVersionFactory;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.client.BgPeriodDialog;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCodeNumberCHelper;
import com.kingdee.eas.ma.base.utils.BgCodeNumberHelper;
import com.kingdee.eas.ma.base.utils.BgNumberHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.bgcsl.BgElimContext;
import com.kingdee.eas.ma.bgcsl.BgEliminationHelper;
import com.kingdee.eas.ma.bgcsl.BgNWorkTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BgNWorkTemplateFactory;
import com.kingdee.eas.ma.bgcsl.BgNWorkTemplateInfo;
import com.kingdee.eas.ma.bgcsl.MbgWorkPaperFacadeFactory;
import com.kingdee.eas.ma.bgcsl.MbgWorkPaperFactory;
import com.kingdee.eas.ma.bgcsl.MbgWorkPaperInfo;
import com.kingdee.eas.ma.bgcsl.MbgWorkPaperStateEnum;
import com.kingdee.eas.ma.bgcsl.client.AbstractMbgWorkPaperEditUI;
import com.kingdee.eas.ma.bgcsl.client.MbgWorkPaperListUI;
import com.kingdee.eas.ma.bgcsl.client.utils.BgCslOrgSelectDialog;
import com.kingdee.eas.ma.bgcsl.utils.BgCslCommonHelper;
import com.kingdee.eas.ma.bgcsl.utils.BgNWorkPaperTemplateObject;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.client.BgNFormListUI;
import com.kingdee.eas.ma.mbg.client.BgTemplateDialog;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectHelper;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import com.kingdee.eas.ma.mbg.common.TemplateStyleInfo;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeUtils;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class MbgWorkPaperEditUI
extends AbstractMbgWorkPaperEditUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(MbgWorkPaperEditUI.class);
    private BgCodeNumberHelper numberCodeHelper = new BgCodeNumberHelper(null, null, "sourceType");
    private BgCodeNumberHelper nameCodeHelper = new BgCodeNumberHelper(null, "name", "sourceType");
    private BgSchemeDimensionHelper schemeHelper = null;
    private boolean hasSubmit = false;

    public BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        if (this.schemeHelper == null) {
            this.schemeHelper = new BgSchemeDimensionHelper(this.getUIContext().get(BgBaseConstants.BGSCHEME_ID).toString());
        }
        return this.schemeHelper;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void applyCodeNumber() {
        MbgWorkPaperInfo info = (MbgWorkPaperInfo)this.getDataObject();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            String orgId = info.getOrgUnit().getId().toString();
            try {
                this.numberCodeHelper.init((IObjectValue)info, orgId);
                this.nameCodeHelper.init((IObjectValue)info, orgId);
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                this.handUIExceptionAndAbort(e);
            }
            if (StringUtils.isEmpty((String)info.getNumber())) {
                this.getNumberByCodingRule((IObjectValue)this.editData, orgId);
            }
        }
    }

    public MbgWorkPaperInfo getEditData() {
        return this.editData;
    }

    public void onLoad() throws Exception {
        this.beforeLoad();
        super.onLoad();
        this.afterLoad();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.prmtOrgUnit.setRequired(true);
        this.prmtBgNWorkTemplate.setEditable(false);
        this.prmtBgPeriod.setEditable(false);
        this.prmtBgVersion.setEditable(false);
        this.menuItemAddNew.setVisible(false);
        this.menuSubmitOption.setVisible(false);
        this.menuItemCopy.setVisible(false);
        if (OprtState.EDIT.equals(this.getOprtState())) {
            this.txtNumber.setEnabled(false);
            this.prmtBgVersion.setEnabled(false);
            this.prmtBgNWorkTemplate.setEnabled(false);
            this.prmtBgPeriod.setEnabled(false);
            this.combCurrency.setEnabled(false);
        }
    }

    private void beforeLoad() throws Exception {
        EntityViewInfo evi = this.prmtBgNWorkTemplate.getEntityViewInfo();
        if (evi == null) {
            this.prmtBgNWorkTemplate.setEntityViewInfo(new EntityViewInfo());
        }
        if (this.prmtBgNWorkTemplate.getEntityViewInfo().getFilter() == null) {
            this.prmtBgNWorkTemplate.getEntityViewInfo().setFilter(new FilterInfo());
        }
        this.prmtBgNWorkTemplate.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)this.getBgSchemeInfo().getId().toString(), CompareType.EQUALS));
        this.prmtBgNWorkTemplate.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("orgTree.id", (Object)((OrgTreeInfo)this.getUIContext().get("orgTreeInfo")).getId().toString(), CompareType.EQUALS));
        this.prmtBgNWorkTemplate.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("templateStatus", (Object)0, CompareType.EQUALS));
        this.prmtBgNWorkTemplate.setEnabledMultiSelection(true);
        BgTemplateDialog templateDialog = new BgTemplateDialog();
        templateDialog.setCsl(true);
        templateDialog.setFilterInfo(this.prmtBgNWorkTemplate.getEntityViewInfo().getFilter());
        this.prmtBgNWorkTemplate.setSelector((KDPromptSelector)templateDialog);
        BgCslOrgSelectDialog dialog = new BgCslOrgSelectDialog();
        dialog.setShowBtn4Order(false);
        OrgTreeInfo orgTreeInfo = (OrgTreeInfo)this.getUIContext().get("orgTreeInfo");
        dialog.setOrgTreeID(orgTreeInfo != null ? orgTreeInfo.getId().toString() : null);
        dialog.setDimension(this.getSchemeHelper().getDimension(DimensionBaseConstants.DEF_ORGUNIT_NUMBER));
        dialog.setBgSchemeId(this.getBgSchemeInfo().getId().toString());
        dialog.setReturnOrgEntity(true);
        OrgUnitInfo group = (OrgUnitInfo)this.getUIContext().get("GROUPORG_ID");
        if (group != null) {
            dialog.setOrgGroupID(group.getId().toString());
        }
        this.prmtOrgUnit.setSelector((KDPromptSelector)dialog);
        this.prmtOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                KDPromptSelector selector = ((KDBizPromptBox)eventObj.getSource()).getSelector();
                if (selector instanceof DataChangeListener) {
                    ((DataChangeListener)selector).dataChanged(eventObj);
                }
            }
        });
    }

    private void afterLoad() throws EASBizException, BOSException {
        this.initCurrencyInfo();
        this.initBgPeriodInfo();
        this.initBgVersionInfo();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            BgSchemeUtils.setDefualtMembers((BgSchemeDimensionHelper)this.getSchemeHelper(), (JComponent)this.prmtBgVersion, (JComponent)this.prmtBgPeriod, (JComponent)this.combCurrency, (boolean)false, (boolean)false);
            KDPromptSelector selector = this.prmtBgPeriod.getSelector();
            if (selector instanceof BgPeriodDialog) {
                BgPeriodDialog dio = (BgPeriodDialog)selector;
                Object[] values = DimensionCommonHelper.getValues((Object)this.prmtBgPeriod.getData());
                if (values instanceof BgPeriodInfo[]) {
                    dio.setBgPeriods((BgPeriodInfo[])values);
                } else if (this.prmtBgPeriod.getData() instanceof BgPeriodInfo) {
                    BgPeriodInfo period = (BgPeriodInfo)this.prmtBgPeriod.getData();
                    BgPeriodInfo[] ps = new BgPeriodInfo[]{period};
                    this.prmtBgPeriod.setData((Object)ps);
                }
            }
        } else {
            this.prmtOrgUnit.setEnabled(false);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (!BgNumberHelper.checkNumber((String)this.txtNumber.getText())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.MbgWorkPaperResource", (String)"specialCharInNumber"));
            SysUtil.abort();
        }
        if ((this.txtNumber.isEnabled() || !this.checkIsMulti() && this.numberCodeHelper.isHasShowCodeNumber()) && StringUtils.isEmpty((String)this.txtNumber.getText())) {
            this.txtNumber.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.MbgWorkPaperResource", (String)"numberCantNull"));
            SysUtil.abort();
        }
        if ((this.txtName.isEnabled() || this.nameCodeHelper.isHasShowCodeNumber()) && StringUtils.isEmpty((String)this.txtName.getText())) {
            this.txtName.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.MbgWorkPaperResource", (String)"nameCantNull"));
            SysUtil.abort();
        }
        if (this.prmtBgNWorkTemplate.getData() == null) {
            this.prmtBgNWorkTemplate.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.MbgWorkPaperResource", (String)"bgNWorkTmCantNull"));
            SysUtil.abort();
        }
        if (this.combCurrency.getSelectedItem() == null) {
            this.combCurrency.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.MbgWorkPaperResource", (String)"currencyCantNull"));
            SysUtil.abort();
        }
        if (this.prmtBgVersion.getData() == null) {
            this.prmtBgVersion.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.MbgWorkPaperResource", (String)"bgVersionCantNull"));
            SysUtil.abort();
        }
        if (this.prmtBgPeriod.getData() == null) {
            this.prmtBgPeriod.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.MbgWorkPaperResource", (String)"bgPeriodCantNull"));
            SysUtil.abort();
        }
        if (DimensionCommonHelper.isEmpty((Object)this.prmtOrgUnit.getData())) {
            this.prmtOrgUnit.requestFocus();
            BgNFCHelper.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.MbgWorkPaperResource", (String)"unitUnionNotNull"));
        }
    }

    protected boolean checkIsMulti() {
        return DimensionCommonHelper.isMulti((Object)this.prmtOrgUnit.getData()) || DimensionCommonHelper.isMulti((Object)this.getTempColl(this.prmtBgNWorkTemplate.getData())) || DimensionCommonHelper.isMulti((Object)this.prmtBgPeriod.getData()) || DimensionCommonHelper.isMulti((Object)this.prmtBgVersion.getData()) || DimensionCommonHelper.isMulti((Object)this.combCurrency.getSelectedItem());
    }

    private Object getTempColl(Object data) {
        Object[] result = null;
        if (data instanceof BgNWorkPaperTemplateObject) {
            BgNWorkPaperTemplateObject info = (BgNWorkPaperTemplateObject)data;
            result = DimensionCommonHelper.getValues((Object)((Object)info.getResult()));
        } else {
            result = DimensionCommonHelper.getValues((Object)data);
        }
        return result;
    }

    protected void checkMultiAddNew() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            if (this.checkIsMulti()) {
                this.txtNumber.setEnabled(false);
                this.txtNumber.setText("");
                this.txtName.setEnabled(false);
                this.txtName.setText("");
            } else {
                this.txtNumber.setEnabled(true);
                this.txtName.setEnabled(true);
                MbgWorkPaperInfo info = this.getEditData();
                if (info != null && info.getOrgUnit() != null) {
                    String orgId = info.getOrgUnit().getId().toString();
                    this.getNumberByCodingRule((IObjectValue)this.editData, orgId);
                }
            }
        }
    }

    protected IObjectValue createNewData() {
        MbgWorkPaperInfo info = new MbgWorkPaperInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setSourceType(RptSrcTypeEnum.PT_BUDGET_REPORT);
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setState(MbgWorkPaperStateEnum.EDIT);
        info.setStartDate(new Date());
        info.setAuditTime(new Timestamp(System.currentTimeMillis()));
        info.setEndDate(info.getStartDate());
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setName(this.txtName.getText());
        info.setNumber(this.txtNumber.getText());
        info.setOrgUnit((FullOrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO));
        info.setCU((CtrlUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_CU));
        info.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        return info;
    }

    protected void initBgVersionInfo() throws EASBizException, BOSException {
        DimensionMemberSelectHelper.addIdFilter((KDBizPromptBox)this.prmtBgVersion, (String)DimensionConstants.DEF_VERSION_NUMBER, (BgSchemeDimensionHelper)this.getSchemeHelper());
    }

    protected void initCurrencyInfo() throws EASBizException, BOSException {
        BgNFCHelper.setCurrency((KDComboBox)this.combCurrency, null, (boolean)true, (Set)this.getSchemeHelper().getMemberSet(DimensionConstants.DEF_CURRENCY_NUMBER, false));
        if (!OprtState.ADDNEW.equals(this.getOprtState()) && this.editData.getCurrency() != null) {
            BgNFCHelper.setSelectObject((KDComboBox)this.combCurrency, (Object)this.editData.getCurrency());
        }
    }

    protected void setDefaultBgVersion() throws EASBizException, BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)this.getSchemeHelper().getMemberSet(DimensionConstants.DEF_VERSION_NUMBER, false), CompareType.INCLUDE));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)"Ve", CompareType.EQUALS));
        BgVersionCollection col = BgVersionFactory.getRemoteInstance().getBgVersionCollection(evi);
        if (col != null && !col.isEmpty()) {
            this.prmtBgVersion.setData((Object)col.get(0));
        } else {
            this.prmtBgVersion.setData(null);
        }
    }

    protected void setCurrencyUnit() throws Exception {
        BgNWorkTemplateInfo bgTemplate = (BgNWorkTemplateInfo)this.prmtBgNWorkTemplate.getValue();
        if (bgTemplate != null) {
            TemplateStyleInfo templateStyleInfo = null;
            if (bgTemplate.getStyleSet() != null && bgTemplate.getStyleSet().getData() != null) {
                templateStyleInfo = MbgXMLParser.parseStyle((byte[])bgTemplate.getStyleSet().getData());
            } else {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("styleSet.id");
                selector.add("styleSet.number");
                selector.add("styleSet.name");
                selector.add("styleSet.data");
                bgTemplate = BgNWorkTemplateFactory.getRemoteInstance().getBgNWorkTemplateInfo((IObjectPK)new ObjectUuidPK(bgTemplate.getId()), selector);
                templateStyleInfo = MbgXMLParser.parseStyle((byte[])bgTemplate.getStyleSet().getData());
            }
            this.txtCurrencyUnit.setText(templateStyleInfo.getCurrencyUnitName());
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MbgWorkPaperFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selector = super.getSelectors();
        selector.add("styleSet.*");
        selector.add("orgTree.id");
        selector.add("orgTree.name");
        selector.add("orgTree.number");
        return selector;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(null);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.storeFields();
            this.doSubmintForAddNew(e);
        } else {
            this.editData.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
            this.editData.setOrgUnit((FullOrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO));
            this.editData.setOrgTree((OrgTreeInfo)this.getUIContext().get("orgTreeInfo"));
            super.actionSubmit_actionPerformed(e);
        }
        this.disposeUIWindow();
        BgNFCHelper.refreshListUI((CoreUI)this);
    }

    private Object saveMbgWorkPapeBook() throws Exception {
        BgElimContext ctx = BgElimContext.getInstance();
        OrgTreeInfo treeInfo = null;
        treeInfo = this.getUIContext().get("orgTreeInfo") != null ? (OrgTreeInfo)this.getUIContext().get("orgTreeInfo") : ctx.getCurOrgBound();
        Object[] orgUnits = BgCslCommonHelper.getValues(this.prmtOrgUnit.getData());
        Object[] templates = BgCslCommonHelper.getValues(this.prmtBgNWorkTemplate.getData());
        Object[] versions = BgCslCommonHelper.getValues(this.prmtBgVersion.getData());
        Object[] periods = BgCslCommonHelper.getValues(this.prmtBgPeriod.getData());
        HashMap<String, List> childMap = new HashMap<String, List>();
        for (int i = 0; i < orgUnits.length; ++i) {
            Object object = orgUnits[i];
            if (!(object instanceof FullOrgUnitInfo)) continue;
            FullOrgUnitInfo org = (FullOrgUnitInfo)object;
            DefaultKingdeeTreeNode rootNode = BgEliminationHelper.getUnionDebtTree((OrgUnitInfo)org, treeInfo, false, false);
            List orgList = this.traceOrgTree(rootNode, null);
            childMap.put(org.getId().toString(), orgList);
        }
        Object result = MbgWorkPaperFacadeFactory.getRemoteInstance().batchAddWorkPaper(this.editData, orgUnits, templates, versions, periods, treeInfo, childMap);
        if (result instanceof MbgWorkPaperInfo) {
            return (MbgWorkPaperInfo)result;
        }
        if (result instanceof Object[]) {
            BgNFCHelper.refreshListUI((CoreUI)this);
            Object[] str = (Object[])result;
            if (str.length >= 2 && !StringUtils.isEmpty((String)((String)str[1]))) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)((String)str[0]), (String)((String)str[1]), (int)1);
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)((String)str[0]));
            }
        }
        return result;
    }

    private List traceOrgTree(DefaultKingdeeTreeNode node, List orgList) {
        if (orgList == null) {
            orgList = new ArrayList<FullOrgUnitInfo>();
        }
        DefaultKingdeeTreeNode sub = null;
        OrgStructureInfo orgStruct = null;
        if (!node.isLeaf()) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                sub = (DefaultKingdeeTreeNode)node.getChildAt(i);
                orgStruct = (OrgStructureInfo)sub.getUserObject();
                orgList.add(orgStruct.getUnit());
            }
        }
        return orgList;
    }

    @Override
    protected void prmtBgNWorkTemplate_dataChanged(DataChangeEvent e) throws Exception {
        BgNWorkTemplateCollection bgNWorkTemplateCollection;
        BgNWorkTemplateInfo info;
        this.checkMultiAddNew();
        super.prmtBgNWorkTemplate_dataChanged(e);
        Object newValue = e.getNewValue();
        if (newValue instanceof BgNWorkTemplateInfo) {
            info = (BgNWorkTemplateInfo)newValue;
            bgNWorkTemplateCollection = new BgNWorkTemplateCollection();
            bgNWorkTemplateCollection.add(info);
            this.prmtBgNWorkTemplate.setDataNoNotify((Object)DimensionCommonHelper.getValues((Object)((Object)bgNWorkTemplateCollection)));
        } else if (newValue instanceof BgNWorkPaperTemplateObject) {
            this.prmtBgNWorkTemplate.setDataNoNotify((Object)DimensionCommonHelper.getValues((Object)((Object)((BgNWorkPaperTemplateObject)newValue).getResult())));
        }
        if (newValue instanceof BgNWorkTemplateInfo) {
            info = (BgNWorkTemplateInfo)newValue;
            bgNWorkTemplateCollection = new BgNWorkTemplateCollection();
            bgNWorkTemplateCollection.add(info);
            Object[] values = DimensionCommonHelper.getValues((Object)((Object)bgNWorkTemplateCollection));
            this.getTmplateArr(values);
        } else if (newValue instanceof BgNWorkPaperTemplateObject) {
            Object[] values = DimensionCommonHelper.getValues((Object)((Object)((BgNWorkPaperTemplateObject)newValue).getResult()));
            this.getTmplateArr(values);
        } else if (newValue instanceof Object[]) {
            Object[] arr = (Object[])newValue;
            this.getTmplateArr(arr);
        }
        this.genarateWorkPaperName();
    }

    private void getTmplateArr(Object[] values) {
        BgNWorkTemplateInfo[] tArrs = new BgNWorkTemplateInfo[values.length];
        for (int i = 0; i < tArrs.length; ++i) {
            if (!(values[i] instanceof BgNWorkTemplateInfo)) continue;
            tArrs[i] = (BgNWorkTemplateInfo)values[i];
        }
        this.prmtBgNWorkTemplate.setDataNoNotify((Object)tArrs);
    }

    protected void initBgPeriodInfo() throws EASBizException, BOSException {
        BgPeriodDialog dialog = new BgPeriodDialog((CoreUIObject)this);
        dialog.setBgPeriodTypeNumbers(this.getSchemeHelper().getMemberSet(DimensionConstants.DEF_PERIOD_NUMBER, true));
        dialog.setBgSchemeID(this.getSchemeHelper().getBgSchemeId());
        BgSchemeInfo bgScheme = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo((IObjectPK)new ObjectStringPK(this.getSchemeHelper().getBgSchemeId()));
        dialog.setBgPeriodBeginDate(bgScheme.getDateFrom());
        dialog.setBgPeriodEndDate(bgScheme.getDateTo());
        dialog.setMultiSelect(true);
        this.prmtBgPeriod.setSelector((KDPromptSelector)dialog);
        this.prmtBgPeriod.addDataChangeListener((DataChangeListener)dialog);
        this.prmtBgPeriod.setEnabledMultiSelection(true);
    }

    protected void loadData() throws Exception {
        super.loadData();
        this.applyCodeNumber();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            if (this.prmtBgNWorkTemplate.getData() instanceof BgNWorkTemplateInfo) {
                this.editData.setBgNWorkTemplate((BgNWorkTemplateInfo)this.prmtBgNWorkTemplate.getData());
            }
            if (this.prmtBgVersion.getData() instanceof BgVersionInfo) {
                this.editData.setBgVersion((BgVersionInfo)this.prmtBgVersion.getData());
            }
            this.editData.setBgScheme(this.getBgSchemeInfo());
            this.editData.setOrgTree((OrgTreeInfo)this.getUIContext().get("orgTreeInfo"));
            if (this.prmtOrgUnit.getData() instanceof FullOrgUnitInfo) {
                this.editData.setOrgUnit((FullOrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO));
            }
            if (this.prmtBgPeriod.getData() instanceof BgPeriodInfo) {
                this.editData.setBgPeriod((BgPeriodInfo)this.prmtBgPeriod.getData());
            }
        }
    }

    protected void getNumberByCodingRule(IObjectValue caller, String orgId) {
        try {
            BgCodeNumberCHelper.getNumberByCodingRule((KDTextField)this.txtNumber, (IObjectValue)caller, (String)orgId, (BgCodeNumberHelper)this.numberCodeHelper);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIException(e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIException(e);
        }
    }

    protected void checkIsOUSealUp() throws Exception {
    }

    public BgSchemeInfo getBgSchemeInfo() {
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.getUIContext().get("BGSCHEME_INFO");
        if (bgSchemeInfo != null) {
            return bgSchemeInfo;
        }
        if (this.editData != null) {
            return this.editData.getBgScheme();
        }
        return null;
    }

    private void getPeriodArr(Object[] arr) {
        BgPeriodInfo[] periods = new BgPeriodInfo[arr.length];
        for (int i = 0; i < periods.length; ++i) {
            if (!(arr[i] instanceof BgPeriodInfo)) continue;
            periods[i] = (BgPeriodInfo)arr[i];
        }
        this.prmtBgPeriod.setDataNoNotify((Object)periods);
    }

    protected void genarateWorkPaperName() {
        if (!this.nameCodeHelper.isHasCodeNumber() && OprtState.ADDNEW.equals(this.getOprtState())) {
            if (this.prmtBgPeriod.getData() instanceof BgPeriodInfo[] && ((BgPeriodInfo[])this.prmtBgPeriod.getData()).length == 1 && this.prmtBgNWorkTemplate.getData() instanceof BgNWorkTemplateInfo[] && ((BgNWorkTemplateInfo[])this.prmtBgNWorkTemplate.getData()).length == 1 && (this.prmtBgVersion.getData() instanceof Object[] && ((Object[])this.prmtBgVersion.getData()).length == 1 || this.prmtBgVersion.getData() instanceof BgVersionInfo)) {
                StringBuffer name = new StringBuffer();
                name.append(((BgPeriodInfo[])this.prmtBgPeriod.getData())[0].getName());
                name.append("-");
                name.append(((BgNWorkTemplateInfo[])this.prmtBgNWorkTemplate.getData())[0].getName());
                name.append("-");
                if (this.prmtBgVersion.getData() instanceof BgVersionInfo[]) {
                    BgVersionInfo[] data = (BgVersionInfo[])this.prmtBgVersion.getData();
                    name.append(data[0].getName());
                } else if (this.prmtBgVersion.getData() instanceof BgVersionInfo) {
                    BgVersionInfo info = (BgVersionInfo)this.prmtBgVersion.getData();
                    name.append(info.getName());
                }
                if (name.length() > this.txtName.getMaxLength()) {
                    this.txtName.setEnabled(true);
                    this.txtName.setText(name.substring(0, this.txtName.getMaxLength()));
                } else {
                    this.txtName.setEnabled(true);
                    this.txtName.setText(name.toString());
                }
            } else {
                this.txtName.setText(null);
                this.txtName.setEnabled(false);
            }
        }
    }

    @Override
    protected void prmtBgPeriod_willShow(SelectorEvent e) throws Exception {
        super.prmtBgPeriod_willShow(e);
        KDPromptSelector selector = this.prmtBgPeriod.getSelector();
        if (selector instanceof BgPeriodDialog) {
            BgPeriodDialog dio = (BgPeriodDialog)selector;
            if (this.prmtBgPeriod.getData() instanceof BgPeriodInfo[]) {
                dio.setBgPeriods((BgPeriodInfo[])this.prmtBgPeriod.getData());
            }
        }
    }

    @Override
    protected void prmtBgPeriod_dataChanged(DataChangeEvent e) throws Exception {
        this.checkMultiAddNew();
        super.prmtBgPeriod_dataChanged(e);
        Object newValue = e.getNewValue();
        if (newValue instanceof BgPeriodInfo) {
            BgPeriodInfo info = (BgPeriodInfo)newValue;
            BgPeriodInfo[] periods = new BgPeriodInfo[]{info};
            this.prmtBgPeriod.setDataNoNotify((Object)periods);
        } else if (newValue instanceof Object[]) {
            Object[] arr = (Object[])newValue;
            if (arr[0] == null) {
                this.prmtBgPeriod.setDataNoNotify(null);
            } else {
                this.getPeriodArr(arr);
            }
        }
        this.genarateWorkPaperName();
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        this.checkMultiAddNew();
        super.prmtOrgUnit_dataChanged(e);
        Object newValue = e.getNewValue();
        if (newValue instanceof FullOrgUnitInfo) {
            FullOrgUnitInfo info = (FullOrgUnitInfo)newValue;
            FullOrgUnitInfo[] infos = new FullOrgUnitInfo[]{info};
            this.prmtOrgUnit.setData((Object)infos);
        }
    }

    @Override
    protected void prmtBgVersion_dataChanged(DataChangeEvent e) throws Exception {
        this.checkMultiAddNew();
        super.prmtBgVersion_dataChanged(e);
        Object newValue = e.getNewValue();
        if (newValue instanceof Object[]) {
            Object[] arr = (Object[])newValue;
            BgVersionInfo[] versions = new BgVersionInfo[arr.length];
            for (int i = 0; i < versions.length; ++i) {
                if (!(arr[i] instanceof BgVersionInfo)) continue;
                versions[i] = (BgVersionInfo)arr[i];
            }
            this.prmtBgVersion.setDataNoNotify((Object)versions);
        } else if (newValue instanceof BgVersionInfo) {
            BgVersionInfo version = (BgVersionInfo)newValue;
            BgVersionInfo[] versions = new BgVersionInfo[]{version};
            this.prmtBgVersion.setDataNoNotify((Object)versions);
        }
        this.genarateWorkPaperName();
    }

    @Override
    protected void prmtBgVersion_willShow(SelectorEvent e) throws Exception {
        super.prmtBgVersion_willShow(e);
        BgNFormListUI.addRollVersionFilter((KDBizPromptBox)this.prmtBgVersion);
    }

    public void onShow() throws Exception {
        super.onShow();
        String title = null;
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            title = EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.MbgWorkPaperResource", (String)"workpaperAddNewTitle");
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            title = EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.MbgWorkPaperResource", (String)"workPaperAttribute");
        }
        super.setUITitle(title);
    }

    public boolean isModify() {
        String curDesc;
        if (this.isHasSubmit()) {
            return false;
        }
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            return super.isModify();
        }
        boolean isChangeNameOrDesc = false;
        String oldName = this.editData.getName();
        String oldDesc = this.editData.getDescription() == null ? "" : this.editData.getDescription();
        String curName = this.txtName.getText();
        String string = curDesc = this.bizLangDescText.getSelectedItem() != null ? this.bizLangDescText.getSelectedItem().toString() : null;
        if (!(curDesc == null || oldName == null || oldName.equals(curName) && curDesc.equals(oldDesc))) {
            return true;
        }
        return isChangeNameOrDesc;
    }

    protected void doSubmintForAddNew(ActionEvent e) throws Exception {
        this.verify(e);
        this.openProgressUI(true);
    }

    protected void openProgressUI(boolean isBatch) throws Exception {
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                Object result = MbgWorkPaperEditUI.this.saveMbgWorkPapeBook();
                return result;
            }

            public void afterExec(Object result) throws Exception {
                MbgWorkPaperEditUI.this.endProgress(result);
            }
        });
        dialog.show();
    }

    public void endProgress(Object result) throws Exception {
        if (result != null) {
            this.setHasSubmit(true);
            BgNFCHelper.refreshListUI((CoreUI)this);
            if (result instanceof MbgWorkPaperInfo && this.getUIContext().get("Owner") instanceof MbgWorkPaperListUI) {
                ((MbgWorkPaperListUI)this.getUIContext().get("Owner")).showEdit((MbgWorkPaperInfo)result);
            }
        }
        this.destroyWindow();
        this.setHasSubmit(false);
    }

    public boolean isHasSubmit() {
        return this.hasSubmit;
    }

    public void setHasSubmit(boolean hasSubmit) {
        this.hasSubmit = hasSubmit;
    }
}

