/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetListener;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.query.EntityExecutorFactory;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.client.utils.BgEntityUtil;
import com.kingdee.eas.ma.base.client.utils.NumberExpandHelper;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.bgcsl.client.BgCslOrgSelectF7UI;
import com.kingdee.eas.ma.mbg.IMBGFormFacade;
import com.kingdee.eas.ma.mbg.MBGFormFacadeFactory;
import com.kingdee.eas.ma.mbg.client.utils.BgViewMemberSelectHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class OrgDimensionMemberF7UI
extends BgCslOrgSelectF7UI {
    private static final Logger logger = CoreUIObject.getLogger(OrgDimensionMemberF7UI.class);
    private static final long serialVersionUID = -7945894668408320930L;
    public static final String MbgWorkPaperResource = "com.kingdee.eas.ma.bgcsl.MbgWorkPaperResource";
    private MbgViewListSheetManager sheetManager = null;

    public String getUITitle() {
        return EASResource.getString((String)MbgWorkPaperResource, (String)"SelectedOrgUnit");
    }

    @Override
    public void doQuery(final String orgTreeId, final String orgGroupId, final KDTable tblLeft, final String quickText) throws BOSException {
        if (orgTreeId == null) {
            return;
        }
        tblLeft.getDataRequestManager().putBindContents("id", "mainQuery", "unit.id");
        tblLeft.getDataRequestManager().putBindContents("number", "mainQuery", "unit.number");
        tblLeft.getDataRequestManager().putBindContents("name", "mainQuery", "unit.name");
        tblLeft.getDataRequestManager().putBindContents("longNumber", "mainQuery", "longNumber");
        tblLeft.getDataRequestManager().putBindContents("level", "mainQuery", "level");
        tblLeft.getDataRequestManager().putBindContents("isLeaf", "mainQuery", "isLeaf");
        tblLeft.getDataRequestManager().setDataRequestMode(1);
        BgViewMemberSelectHelper.removeRequestDataListener((KDTable)tblLeft);
        tblLeft.addRequestRowSetListener(new RequestRowSetListener(){

            public void doRequestRowSet(RequestRowSetEvent e) {
                try {
                    String oql = "select id,longNumber where tree.id = '" + orgTreeId + "' and unit.id = '" + orgGroupId + "'";
                    OrgStructureInfo orgStructureInfo = OrgStructureFactory.getRemoteInstance().getOrgStructureInfo(oql);
                    String longNumber = orgStructureInfo.getLongNumber();
                    String structureId = orgStructureInfo.getId().toString();
                    EntityViewInfo viewInfo = new EntityViewInfo();
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add("id");
                    sic.add("unit.id");
                    sic.add("unit.number");
                    sic.add("unit.name");
                    sic.add("longNumber");
                    sic.add("level");
                    sic.add("isLeaf");
                    viewInfo.getSelector().addObjectCollection((IObjectCollection)sic);
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)("%" + longNumber + "!%"), CompareType.LIKE));
                    filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)structureId, CompareType.EQUALS));
                    String maskString = "#0 and #1";
                    if (!StringUtils.isEmpty((String)quickText)) {
                        filter.getFilterItems().add(new FilterItemInfo("unit.number", (Object)("%" + quickText + "%"), CompareType.LIKE));
                        filter.getFilterItems().add(new FilterItemInfo("unit.name", (Object)("%" + quickText + "%"), CompareType.LIKE));
                        maskString = maskString + "and ( #2 or #3)";
                    }
                    filter.setMaskString(maskString);
                    viewInfo.setFilter(filter);
                    viewInfo.setSorter(new SorterItemCollection());
                    SorterItemInfo sortInfo = new SorterItemInfo("longNumber");
                    sortInfo.setSortType(SortType.ASCEND);
                    viewInfo.getSorter().add(sortInfo);
                    EntityObjectInfo entity = BgEntityUtil.getEntity((BOSObjectType)new OrgStructureInfo().getBOSType());
                    IDataProvider mainExec = EntityExecutorFactory.getRemoteInstance((IMetaDataPK)MetaDataPK.create((String)entity.getFullName()));
                    mainExec.setObjectView(viewInfo);
                    Uuid queryId = mainExec.openQuery();
                    List allIdList = mainExec.getQueryKeys(queryId);
                    mainExec.option().isAutoTranslateEnum = true;
                    mainExec.option().pageCount = tblLeft.getDataRequestManager().getPageRowCount();
                    int start = (Integer)e.getParam1();
                    int length = (Integer)e.getParam2() - start + 1;
                    IRowSet res = mainExec.executeQuery(queryId, start, length);
                    while (res.next()) {
                        String id = res.getString("unit.id");
                        if (OrgDimensionMemberF7UI.this.AddIDSet == null || StringUtils.isEmpty((String)id)) continue;
                        OrgDimensionMemberF7UI.this.AddIDSet.add(id);
                    }
                    e.setRowSet(res);
                }
                catch (Exception e1) {
                    logger.error((Object)e1);
                }
            }
        });
        tblLeft.checkParsed();
        tblLeft.removeRows();
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblRight.getRowCount() <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)MbgWorkPaperResource, (String)"OrgUnitCantNull"));
            return;
        }
        super.btnOk_actionPerformed(e);
    }

    @Override
    protected void btnRemove_actionPerformed(ActionEvent e) throws Exception {
        List rows = BgCommCHelper.getSelectRowIndexes((KDTable)this.tblRight);
        this.remove(rows);
    }

    protected void remove(List rows) throws EASBizException, BOSException {
        int i;
        this.checkCanRemove(rows);
        HashSet<String> removeCompareValue = new HashSet<String>();
        for (i = rows.size() - 1; i >= 0; --i) {
            int rowIndex = (Integer)rows.get(i);
            IRow row = this.tblRight.getRow(rowIndex);
            if (row.getStyleAttributes().isHided() || !this.isCanRemove(row)) continue;
            removeCompareValue.add(NumberExpandHelper.getNumber((IRow)row));
            this.tblRight.removeRow(rowIndex);
        }
        for (i = 0; i < this.tblLeft.getBody().size(); ++i) {
            IRow row = this.tblLeft.getRow(i);
            if (!removeCompareValue.contains(NumberExpandHelper.getNumber((IRow)row))) continue;
            row.getStyleAttributes().setHided(false);
        }
    }

    @Override
    protected void btnRemoveAll_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblRight.getRowCount() <= 0) {
            return;
        }
        ArrayList<Integer> rows = new ArrayList<Integer>();
        for (int i = 0; i < this.tblRight.getRowCount(); ++i) {
            rows.add(new Integer(i));
        }
        this.remove(rows);
    }

    private void checkCanRemove(List rows) throws EASBizException, BOSException {
        String bgFormId = (String)this.getUIContext().get("BGFORM_ID");
        String orgTreeId = (String)this.getUIContext().get("ORGTREE_ID");
        String groupUnitId = (String)this.getUIContext().get("ORGGROUP_ID");
        if (StringUtils.isEmpty((String)bgFormId) || StringUtils.isEmpty((String)orgTreeId) || StringUtils.isEmpty((String)groupUnitId) || rows.isEmpty()) {
            return;
        }
        HashMap<BgDimensionMember, Integer> removeInfo = new HashMap<BgDimensionMember, Integer>();
        for (int i = 0; i < this.tblRight.getRowCount(); ++i) {
            IRow row = this.tblRight.getRow(i);
            if (row.getStyleAttributes().isHided() || !rows.contains(new Integer(i))) continue;
            BgDimensionMember member = this.getMemberOfRow(row);
            removeInfo.put(member, i);
        }
        if (removeInfo.isEmpty()) {
            return;
        }
        List result = this.getMBGFormFacade().getHasDataOrg(bgFormId, orgTreeId, groupUnitId, new HashSet(removeInfo.keySet()), this.sheetManager);
        if (result != null) {
            int total = rows.size();
            int fail = 0;
            String detailFormat = EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionAddNewResource", (String)"removeMemberFail");
            StringBuffer detail = new StringBuffer();
            for (BgDimensionMember member : removeInfo.keySet()) {
                if (!result.contains(member.getAttribute())) continue;
                rows.remove(removeInfo.get(member));
                ++fail;
                if (detail.length() > 0) {
                    detail.append("\r\n");
                }
                detail.append(MessageFormat.format(detailFormat, member.getName()));
            }
            String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionAddNewResource", (String)"removeMemberNoSuccess"), total, fail);
            if (fail > 0) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)detail.toString(), (int)1);
            }
        }
    }

    protected boolean isCanRemove(IRow row) {
        if (row == null) {
            return false;
        }
        return !row.getStyleAttributes().getBackground().equals(BgViewMemberSelectHelper.lockColor);
    }

    public void setCurrentView(MbgViewListRowCol rowCol, MbgViewListSheetManager sheetManager) {
        if (rowCol == null || sheetManager == null) {
            return;
        }
        try {
            this.sheetManager = sheetManager.clone();
            int index = sheetManager.getDimensionManager().getRows().indexOf(rowCol);
            if (index >= 0) {
                rowCol = (MbgViewListRowCol)this.sheetManager.getDimensionManager().getRows().get(index);
                this.sheetManager.getDimensionManager().getRows().clear();
                this.sheetManager.getDimensionManager().getRows().add(rowCol);
            } else {
                index = sheetManager.getDimensionManager().getColumns().indexOf(rowCol);
                this.sheetManager.getDimensionManager().getColumns().clear();
                this.sheetManager.getDimensionManager().getColumns().add(rowCol);
            }
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private IMBGFormFacade getMBGFormFacade() throws BOSException {
        return MBGFormFacadeFactory.getRemoteInstance();
    }
}

