/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client.actions.cslForm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.Excel2007Reader;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.read.POIXlsxReader;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.eas.base.log.client.ExcelFileFilter;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.client.utils.BgFileUtil;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgElementHelper;
import com.kingdee.eas.ma.base.utils.Excel2007FileFilter;
import com.kingdee.eas.ma.bgcsl.client.workPaper.MbgWorkPaperContextManager;
import com.kingdee.eas.ma.bgcsl.client.workPaper.MbgWorkPaperProvider;
import com.kingdee.eas.ma.bgcsl.provider.BgCslViewListFormProvider;
import com.kingdee.eas.ma.mbg.client.BgSpreadCoreViewUI;
import com.kingdee.eas.ma.mbg.client.MBGFormProcessUI;
import com.kingdee.eas.ma.mbg.client.MbgViewListFormProcessUI;
import com.kingdee.eas.ma.mbg.client.action.actions.AbstractAction;
import com.kingdee.eas.ma.mbg.client.template.ViewListBookContextManager;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgViewClientHelper;
import com.kingdee.eas.ma.mbg.client.viewListForm.MBGViewListBaseFormContextManager;
import com.kingdee.eas.ma.mbg.common.IBgNumberCellDisplayHelper;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MBGViewListFormAdjustProvider;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MbgViewlistMeasureUnitHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.MbgViewListDescriptionHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListHelper;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;

public class ActionImport
extends AbstractAction {
    private static final long serialVersionUID = -1852291174579656944L;

    protected boolean hasIcon() {
        return true;
    }

    protected Icon getIcon() {
        return EASResource.getIcon((String)"imgTbtn_input");
    }

    protected boolean hasKeyStroke() {
        return true;
    }

    protected KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke(73, 2);
    }

    protected String getName() {
        return EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.ActionResource", (String)"actionImport");
    }

    public void actionPerformed(ActionEvent e) {
        BgSpreadCoreViewUI processUI = (BgSpreadCoreViewUI)this.uiObj;
        KDFileChooser fileChooser = null;
        BgFileUtil bgFileUtil = new BgFileUtil();
        try {
            fileChooser = bgFileUtil.getFileChooserForImp((Object)processUI);
        }
        catch (BOSException e1) {
            processUI.handUIExceptionAndAbort((Exception)((Object)e1));
        }
        fileChooser.setDialogTitle(BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"fileImport"));
        Excel2007FileFilter filter2007 = new Excel2007FileFilter();
        fileChooser.setFileFilter((FileFilter)new ExcelFileFilter());
        fileChooser.setFileFilter((FileFilter)filter2007);
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileChooser.showOpenDialog((Component)processUI) == 0) {
            File file = fileChooser.getSelectedFile();
            if (file != null && file.isFile()) {
                String fileName = file.getPath();
                String sen = GlobalFunction.getFileExtension((String)fileName);
                KDSBook books = null;
                if (sen.equals("xlsx")) {
                    books = POIXlsxReader.parse((String)fileName);
                    if (books == null) {
                        try {
                            books = new Excel2007Reader().parse(fileName);
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    books = POIXlsReader.parse((String)fileName);
                }
                if (books == null) {
                    MsgBox.showInfo((Component)processUI, (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"openFileError"));
                    return;
                }
                try {
                    boolean isViewListImportCheck = false;
                    try {
                        Method method = processUI.getClass().getMethod("isViewListImportCheck", null);
                        if (method != null) {
                            isViewListImportCheck = (Boolean)method.invoke((Object)processUI, null);
                        }
                    }
                    catch (Exception ex) {
                        processUI.handUIExceptionAndAbort(ex);
                    }
                    if (isViewListImportCheck) {
                        if (processUI.getContextManager() instanceof MBGViewListBaseFormContextManager) {
                            this.checkViewImport(books, ((MBGViewListBaseFormContextManager)processUI.getContextManager()).getSpreadContext().getBook());
                        } else if (processUI.getContextManager() instanceof MbgWorkPaperContextManager) {
                            this.checkViewImport(books, ((MbgWorkPaperContextManager)processUI.getContextManager()).getSpreadContext().getBook());
                        }
                    }
                    this.importBookContent(books, processUI);
                    bgFileUtil.storeDefaultPathForIMP((Object)fileName, (Object)processUI);
                    processUI.updateUI();
                    processUI.setMessageText(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"success"));
                    processUI.showMessage();
                }
                catch (Exception ex) {
                    processUI.handUIExceptionAndAbort(ex);
                }
            } else {
                MsgBox.showWarning((Component)processUI, (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"fileNotExist"));
                return;
            }
        }
    }

    protected void checkViewImport(KDSBook kdsBook, Book book) throws Exception {
        for (int i = 0; i < kdsBook.getSheetCount(); ++i) {
            KDSSheet kdsSheet = kdsBook.getSheet((Object)i);
            Sheet bookSheet = book.getSheet(i);
            if (bookSheet == null) continue;
            this.checkSheet(kdsSheet, bookSheet);
        }
    }

    private void checkSheet(KDSSheet kdsSheet, Sheet bookSheet) throws EASBizException {
        int kdsRowCount = kdsSheet.getRowCount();
        int kdsColCount = kdsSheet.getExpandedColumns() + 1;
        String sheetName = bookSheet.getSheetName();
        KDSCell kdsCell = null;
        Cell bookCell = null;
        for (int row = 0; row < kdsRowCount; ++row) {
            for (int col = 0; col < kdsColCount; ++col) {
                kdsCell = kdsSheet.getCell(row, col, false);
                if (kdsCell == null || (bookCell = bookSheet.getCell(row, col, true)).isLocked()) continue;
                String cellName = bookCell.getName(false, false);
                if (BgNFSHelper.checkHasItemFormula((Cell)bookCell)) {
                    if (kdsCell.getValue() != null && kdsCell.getValue().toString().indexOf("%") != -1) {
                        String replaceValue = kdsCell.getValue().toString().replaceAll("%", "");
                        if (BgNFSHelper.checkIsNumeric((Object)replaceValue)) continue;
                        Object[] sheetcell = new Object[]{sheetName, cellName};
                        throw new EASBizException(new NumericExceptionSubItem("021", BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"388_ActionImport", (Object[])sheetcell)));
                    }
                    if (StringUtils.isEmpty((String)StringUtils.cnulls((Object)kdsCell.getValue())) || BgNFSHelper.checkIsNumeric((Object)kdsCell.getValue())) continue;
                    Object[] sheetcell = new Object[]{sheetName, cellName};
                    throw new EASBizException(new NumericExceptionSubItem("021", BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"388_ActionImport", (Object[])sheetcell)));
                }
                if (MbgViewListDescriptionHelper.checkHashDescriptionFormula((Cell)this.getFirstCell(bookCell)) || ViewListHelper.checkIsEditNoteCell((Cell)this.getFirstCell(bookCell)) || (kdsCell.getValue() == null || StringUtils.isEmpty((String)kdsCell.getValue().toString())) && (bookCell.getValue() == Variant.nullVariant || bookCell.getValue() == null)) continue;
                CellBlock _mergeBlock = bookSheet.getMergeBlock(bookCell);
                if (_mergeBlock != null && Boolean.TRUE.equals(bookSheet.getRange(_mergeBlock).getUserObject("row_member_merge"))) {
                    bookCell = bookSheet.getCell(_mergeBlock.getRow(), _mergeBlock.getCol(), false);
                }
                this.checkImportData(sheetName, kdsCell, bookCell, cellName);
            }
        }
    }

    private void checkImportData(String sheetName, KDSCell kdsCell, Cell bookCell, String cellName) throws EASBizException {
        Object[] sheetcell = new Object[]{sheetName, cellName};
        if (!StringUtils.isEmpty((String)kdsCell.getFormula()) && bookCell.hasFormula() && !kdsCell.getFormula().equals(bookCell.getFormula())) {
            throw new EASBizException(new NumericExceptionSubItem("021", BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"389_ActionImport", (Object[])sheetcell)));
        }
        if (kdsCell.getType() == 0) {
            try {
                new BigDecimal(kdsCell.getValue().toString());
            }
            catch (NumberFormatException e) {
                throw new EASBizException(new NumericExceptionSubItem("021", BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"390_ActionImport", (Object[])sheetcell)));
            }
            try {
                if (bookCell.getValue() != Variant.nullVariant) {
                    new BigDecimal(bookCell.getValue().toString());
                }
            }
            catch (NumberFormatException e) {
                throw new EASBizException(new NumericExceptionSubItem("021", BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"391_ActionImport", (Object[])sheetcell)));
            }
        }
        if ((bookCell = this.getFirstCell(bookCell)) == null || bookCell.getValue() != Variant.nullVariant && !kdsCell.getValue().toString().equals(bookCell.getValue().toString())) {
            throw new EASBizException(new NumericExceptionSubItem("021", BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"392_ActionImport")));
        }
    }

    protected Cell getFirstCell(Cell bookCell) {
        if (bookCell != null && bookCell.getMerge(true) != null) {
            bookCell = bookCell.getSheet().getFirstCell(bookCell.getMerge(true), false);
        }
        return bookCell;
    }

    protected void importBookContent(KDSBook kdsBook, BgSpreadCoreViewUI processUI) throws Exception {
        if (kdsBook == null) {
            MsgBox.showWarning((Component)processUI, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"openFileError"));
            SysUtil.abort();
        }
        ViewListBookContextManager contextManager = (ViewListBookContextManager)processUI.getContextManager();
        Book _book = contextManager.getSpreadContext().getBook();
        HashMap<String, Object> _tmpMap = new HashMap<String, Object>();
        _tmpMap.put("IMPORT_BOOK", _book);
        _tmpMap.put("IMPORT_KDSBOOK", kdsBook);
        _tmpMap.put("MbgViewlistMeasureUnitHelper", this.getViewlistMeasureUnitHelper(contextManager));
        _tmpMap.put("IMPORT_BGFORMULA", ((IBgNumberCellDisplayHelper)processUI).getFormulaMap());
        _tmpMap.put("IMPORT_DATA", this.getImportData(processUI));
        BgNFCHelper.importExcel(_tmpMap);
        if (contextManager.getProvider() instanceof MBGViewListFormAdjustProvider) {
            ((MBGViewListFormAdjustProvider)contextManager.getProvider()).getAdjustHelper().updateChangeValueInfo(_book);
        }
        if (contextManager.getOwnerUI() instanceof MbgViewListFormProcessUI) {
            try {
                ((MbgViewListFormProcessUI)contextManager.getOwnerUI()).actionCalculate_actionPerformed(new ActionEvent(contextManager.getOwnerUI(), 0, MBGFormProcessUI.class.getName() + "$ActionCalculate"));
            }
            catch (Exception e1) {
                contextManager.getOwnerUI().handUIExceptionAndAbort(e1);
            }
        }
        contextManager.getSpreadContext().getSpread().repaint();
    }

    protected Boolean getImportData(BgSpreadCoreViewUI processUI) {
        return Boolean.TRUE;
    }

    protected String getShortDescription() {
        return BgViewClientHelper.getString((String)"ActionImportName");
    }

    protected String getLongDescription() {
        return BgViewClientHelper.getString((String)"ActionImportName");
    }

    private MbgViewlistMeasureUnitHelper getViewlistMeasureUnitHelper(ViewListBookContextManager contextManager) throws BOSException {
        Map elementObjMap = BgElementHelper.getElementoObjMap();
        MbgViewlistMeasureUnitHelper viewlistMeasureHelper = null;
        if (contextManager.getProvider() instanceof MbgWorkPaperProvider) {
            viewlistMeasureHelper = new MbgViewlistMeasureUnitHelper(((MbgWorkPaperProvider)contextManager.getProvider()).getAccountDataTypeMap(), ((MbgWorkPaperProvider)contextManager.getProvider()).getTemplateStyle(), elementObjMap);
        } else if (contextManager.getProvider() instanceof BgCslViewListFormProvider) {
            viewlistMeasureHelper = new MbgViewlistMeasureUnitHelper(((BgCslViewListFormProvider)contextManager.getProvider()).getAccountDataTypeMap(), ((BgCslViewListFormProvider)contextManager.getProvider()).getTemplateStyle(), elementObjMap);
        }
        return viewlistMeasureHelper;
    }
}

