/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client.cslTemplate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.bgcsl.BgCslSpecialItemsCollection;
import com.kingdee.eas.ma.bgcsl.BgCslSpecialItemsFactory;
import com.kingdee.eas.ma.bgcsl.BgCslSpecialItemsInfo;
import com.kingdee.eas.ma.bgcsl.BgCslSpecialRelationGroupCollection;
import com.kingdee.eas.ma.bgcsl.BgCslSpecialRelationGroupFactory;
import com.kingdee.eas.ma.bgcsl.BgCslSpecialRelationGroupInfo;
import com.kingdee.eas.ma.bgcsl.client.BgCslTemplateProcessUI;
import com.kingdee.eas.ma.bgcsl.common.IBgCslSpecialInfo;
import com.kingdee.eas.ma.bgcsl.utils.BgSpecialCommonHelper;
import com.kingdee.eas.ma.mbg.BgDimSettingsCollection;
import com.kingdee.eas.ma.mbg.BgDimSettingsFactory;
import com.kingdee.eas.ma.mbg.BgDimSettingsInfo;
import com.kingdee.eas.ma.mbg.DimRelashipGroupEntryCollection;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupInfo;
import com.kingdee.eas.ma.mbg.client.action.actions.ActionDimensionChange;
import com.kingdee.eas.ma.mbg.client.common.BgDimensionPromptBox;
import com.kingdee.eas.ma.mbg.client.utils.NewDimensionMemberSelectDialog;
import com.kingdee.eas.ma.mbg.common.AbstractBookParseHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.LineFlowLayout;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgNTemplateHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimSettingDisplayInfo;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class BgSpecialBudgetHelper {
    private static Logger logger = Logger.getLogger((String)BgSpecialBudgetHelper.class.getName());
    public static final String COL_DIMENSION = "dimension";
    public static final String COL_MEMBER = "member";
    public static final String COL_DIMRELAGROUP = "dimRelaGroup";
    public static final String COL_HIDE = "hide";
    public static final Color REQUIRED_COLOR = new Color(252, 251, 223);
    public static final String PAGE_PANEL_NAME = "pagePnl";
    public static final String BG_SPECIAL_ITEMS = "bgSpecialItems";
    public static final String DIMENSION_NUMBER = "dimensionNumber";
    public static final String DIMENSION_NAME = "dimensionName";
    public static final String MEMBER_NAME = "memberName";
    public static final String MEMBER_DISP_NAEM = "memberDisplayName";
    public static final String HAS_FILL_SPEC_ITEM = "HAS_FILL_SPEC_ITEM";

    public static void getSpecialItemSelector(SelectorItemCollection sic) {
        sic.add("bgSpecialItems.dimensionNumber");
        sic.add("bgSpecialItems.dimensionName");
        sic.add("bgSpecialItems.memberName");
        sic.add("bgSpecialItems.memberDisplayName");
        sic.add("bgSpecialItems.hide");
    }

    public static BgCslSpecialItemsInfo getBgSpecialItem(IBgCslSpecialInfo bgSpecialInfo) throws BOSException {
        if (bgSpecialInfo == null) {
            return null;
        }
        BgCslSpecialItemsInfo itemsInfo = null;
        if (bgSpecialInfo.getBgSpecialItems() != null && !bgSpecialInfo.getBgSpecialItems().isEmpty()) {
            itemsInfo = bgSpecialInfo.getBgSpecialItems().get(0);
        } else {
            BgCslSpecialItemsCollection colls = BgCslSpecialItemsFactory.getRemoteInstance().getBgCslSpecialItemsCollection("select id, dimensionNumber, dimensionName, memberName, hide where " + bgSpecialInfo.getRefField() + " = '" + bgSpecialInfo.getId().toString() + "'");
            if (colls != null && !colls.isEmpty()) {
                itemsInfo = colls.get(0);
            }
        }
        return itemsInfo;
    }

    public static boolean checkHasBgItemFormula(IBgCslSpecialInfo bgTemplateInfo) {
        Book book = null;
        try {
            book = bgTemplateInfo.getBook();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return BgSpecialBudgetHelper.checkHasBgItemFormula(book);
    }

    public static boolean checkHasBgItemFormula(Book book) {
        boolean isHasFormula = false;
        if (book == null || book.getSheetCount() <= 0) {
            return isHasFormula;
        }
        block0: for (int s = 0; s < book.getSheetCount(); ++s) {
            Sheet sheet = book.getSheet(s);
            int maxRow = sheet.getMaxRowIndex();
            int maxCol = sheet.getMaxColIndex();
            for (int r = 0; r <= maxRow; ++r) {
                Row row = sheet.getRow(r, false);
                if (row == null) continue;
                for (int c = 0; c <= maxCol; ++c) {
                    Cell cell = row.getCell(c, false);
                    if (!BgNFSHelper.checkHasItemFormula((Cell)cell)) continue;
                    isHasFormula = true;
                    break block0;
                }
            }
        }
        return isHasFormula;
    }

    public static BgCslSpecialItemsInfo queryBgSpecialItemByBgTemplate(String bgTemplateId) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)bgTemplateId)) {
            return null;
        }
        return BgCslSpecialItemsFactory.getRemoteInstance().getBgCslSpecialItemsInfo("select id, dimensionNumber, dimensionName, memberName where bgTemplate = '" + bgTemplateId + "'");
    }

    public static void loadDimensionTable(KDTable dimensionTable, BgSchemeDimensionHelper schemeHelper, IBgCslSpecialInfo bgSpecialInfo) throws EASBizException, BOSException {
        if (dimensionTable == null || bgSpecialInfo == null || schemeHelper == null || bgSpecialInfo.getBgSpecialItems().isEmpty()) {
            return;
        }
        BgCslSpecialItemsInfo bgCslSpecialItemsInfo = bgSpecialInfo.getBgSpecialItems().get(0);
        bgCslSpecialItemsInfo = BgCslSpecialRelationGroupFactory.getRemoteInstance().addDimRelaGroupForBgSpecialItems(bgCslSpecialItemsInfo);
        bgSpecialInfo.getBgSpecialItems().clear();
        bgSpecialInfo.getBgSpecialItems().add(bgCslSpecialItemsInfo);
        BgSpecialBudgetHelper.loadDimensionTable(dimensionTable, schemeHelper, bgCslSpecialItemsInfo);
    }

    public static void loadDimensionTable(KDTable dimensionTable, BgSchemeDimensionHelper schemeHelper, BgCslSpecialItemsInfo BgCslSpecialItemsInfo2) throws EASBizException, BOSException {
        if (BgCslSpecialItemsInfo2 == null) {
            return;
        }
        HashMap<String, BgDimSettingsInfo> dimSettingMap = new HashMap<String, BgDimSettingsInfo>();
        BgDimSettingsCollection dimSettingColls = BgDimSettingsFactory.getRemoteInstance().getBgDimSettingsCollection("where bgScheme =  '" + schemeHelper.getBgSchemeId() + "'");
        for (int i = 0; i < dimSettingColls.size(); ++i) {
            dimSettingMap.put(dimSettingColls.get(i).getDimNumber(), dimSettingColls.get(i));
        }
        dimensionTable.setUserObject((Object)BgCslSpecialItemsInfo2);
        String dimensionNumber = BgCslSpecialItemsInfo2.getDimensionNumber();
        String membeName = BgCslSpecialItemsInfo2.getMemberName();
        String hide = BgCslSpecialItemsInfo2.getHide();
        if (StringUtils.isEmpty((String)dimensionNumber)) {
            return;
        }
        Map srcNumAndDimensonMap = schemeHelper.getDimensionBySrcNumber();
        String[] numbers = dimensionNumber.split(DimensionConstants.COMMA_SEPARATOR);
        String[] names = BgSpecialCommonHelper.splitName(membeName, DimensionConstants.TICK_SEPARATOR);
        String[] hides = BgSpecialCommonHelper.splitName(hide, DimensionConstants.COMMA_SEPARATOR);
        if (hides == null) {
            hides = new String[numbers.length];
            for (int i = 0; i < hides.length; ++i) {
                hides[i] = String.valueOf(false);
            }
        }
        IRow row = null;
        BgDimensionInfo bgDimensionInfo = null;
        BgDimSettingsInfo bgDimSettingInfo = null;
        BgDimensionMember bgDimensionMember = null;
        String memberNumber = null;
        String memberName = null;
        String srcNum = null;
        int length = numbers.length;
        for (int index = 0; index < length; ++index) {
            srcNum = numbers[index].split(":")[0];
            memberNumber = numbers[index].split(":")[1];
            memberName = names[index];
            String isHide = hides[index];
            if (!srcNumAndDimensonMap.containsKey(srcNum)) continue;
            bgDimensionInfo = (BgDimensionInfo)srcNumAndDimensonMap.get(srcNum);
            bgDimSettingInfo = (BgDimSettingsInfo)dimSettingMap.get(bgDimensionInfo.getNumber());
            bgDimensionMember = "#".equals(memberNumber) ? null : new BgDimensionMember(bgDimensionInfo.getNumber(), bgDimensionInfo.getRefField(), memberName, memberNumber);
            row = dimensionTable.addRow();
            row.getCell(COL_DIMENSION).setValue((Object)new DimSettingDisplayInfo(bgDimSettingInfo));
            row.getCell(COL_MEMBER).setValue((Object)bgDimensionMember);
            row.getCell(COL_HIDE).setValue((Object)Boolean.valueOf(isHide));
        }
        BgCslSpecialRelationGroupCollection colls = BgCslSpecialItemsInfo2.getDimRelaGroupRef();
        int count = dimensionTable.getRowCount();
        for (int i = 0; i < colls.size(); ++i) {
            DimensionRelationshipGroupInfo group = colls.get(i).getDimRelaGroup();
            DimRelashipGroupEntryCollection entrys = group.getEntries();
            HashSet<String> dimensions = new HashSet<String>();
            for (int j = 0; j < entrys.size(); ++j) {
                dimensions.add(entrys.get(j).getDimNumber());
            }
            for (int index = 0; index < count; ++index) {
                DimSettingDisplayInfo dimSett = (DimSettingDisplayInfo)dimensionTable.getRow(index).getCell(COL_DIMENSION).getValue();
                if (!dimensions.contains(dimSett.getDimSettingInfo().getDimNumber())) continue;
                dimensionTable.getRow(index).getCell(COL_DIMRELAGROUP).setUserObject((Object)colls.get(i));
                dimensionTable.getRow(index).getCell(COL_DIMRELAGROUP).setValue((Object)colls.get(i).getDimRelaGroup());
            }
        }
    }

    public static BgCslSpecialItemsInfo getNewInfo(KDTable dimensionTable, IBgCslSpecialInfo bgSpecialInfo, BgSchemeDimensionHelper schemeHelper, boolean isAddNew) {
        String[] numberAndName = BgSpecialBudgetHelper.getDimNumberAndName(dimensionTable, schemeHelper);
        if (numberAndName == null) {
            return null;
        }
        String dimensionNumber = numberAndName[0];
        String memberName = numberAndName[1];
        String dimensionName = numberAndName[2];
        String memberDisplayName = numberAndName[3];
        String hide = numberAndName[4];
        BgCslSpecialItemsInfo info = new BgCslSpecialItemsInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        bgSpecialInfo.setRefObject(info);
        info.setDimensionNumber(dimensionNumber);
        info.setMemberName(memberName);
        info.setDimensionName(dimensionName);
        info.setMemberDisplayName(memberDisplayName);
        info.setHide(hide);
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
        info.getDimRelaGroupRef().addCollection(BgSpecialBudgetHelper.getDimRelationshipGroup(dimensionTable, info, isAddNew));
        return info;
    }

    public static boolean updateBgSpecialInfo(KDTable dimensionTable, IBgCslSpecialInfo bgSpecialInfo, BgSchemeDimensionHelper schemeHelper) {
        if (dimensionTable == null || bgSpecialInfo == null || schemeHelper == null) {
            return false;
        }
        BgCslSpecialItemsInfo info = bgSpecialInfo.getBgSpecialItems().get(0);
        return BgSpecialBudgetHelper.updateBgSpecialInfo(dimensionTable, info, schemeHelper);
    }

    public static boolean updateBgSpecialInfo(KDTable dimensionTable, BgCslSpecialItemsInfo info, BgSchemeDimensionHelper schemeHelper) {
        return BgSpecialBudgetHelper.updateBgSpecialInfo(dimensionTable, info, schemeHelper, null);
    }

    public static boolean updateBgSpecialInfo(KDTable dimensionTable, BgCslSpecialItemsInfo info, BgSchemeDimensionHelper schemeHelper, Integer memberValueMode) {
        String[] numberAndName = BgSpecialBudgetHelper.getDimNumberAndName(dimensionTable, schemeHelper);
        if (numberAndName == null) {
            return true;
        }
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
        info.copyNewToOld();
        String dimensionNumber = numberAndName[0];
        String memberName = numberAndName[1];
        String dimensionName = numberAndName[2];
        String memberDisplayName = numberAndName[3];
        String hide = numberAndName[4];
        info.setDimensionNumber(dimensionNumber);
        info.setMemberName(memberName);
        info.setDimensionName(dimensionName);
        info.setMemberDisplayName(memberDisplayName);
        info.setHide(hide);
        info.getDimRelaGroupRef().clear();
        info.getDimRelaGroupRef().addCollection(BgSpecialBudgetHelper.getDimRelationshipGroup(dimensionTable, info, false));
        return false;
    }

    public static BgCslSpecialRelationGroupCollection getDimRelationshipGroup(KDTable dimensionTable, BgCslSpecialItemsInfo info, boolean isAddNew) {
        if (dimensionTable == null) {
            return null;
        }
        int count = dimensionTable.getRowCount();
        HashSet<String> existGroup = new HashSet<String>();
        BgCslSpecialRelationGroupCollection coll = new BgCslSpecialRelationGroupCollection();
        for (int i = 0; i < count; ++i) {
            BgCslSpecialRelationGroupInfo dimRelaGroupRef = (BgCslSpecialRelationGroupInfo)dimensionTable.getRow(i).getCell(COL_DIMRELAGROUP).getUserObject();
            DimensionRelationshipGroupInfo group = (DimensionRelationshipGroupInfo)dimensionTable.getRow(i).getCell(COL_DIMRELAGROUP).getValue();
            if (group == null || existGroup.contains(group.getId().toString())) continue;
            existGroup.add(group.getId().toString());
            if (dimRelaGroupRef == null) {
                dimRelaGroupRef = new BgCslSpecialRelationGroupInfo();
            }
            if (isAddNew) {
                dimRelaGroupRef.setId(BOSUuid.create((BOSObjectType)dimRelaGroupRef.getBOSType()));
                dimensionTable.getRow(i).getCell(COL_DIMRELAGROUP).setUserObject((Object)dimRelaGroupRef);
            }
            dimRelaGroupRef.setDimRelaGroup(group);
            dimRelaGroupRef.setBgSpecialItems(info);
            coll.add(dimRelaGroupRef);
        }
        return coll;
    }

    public static String getSpecialItemDimNumber(KDTable dimensionTable, BgSchemeDimensionHelper schemeHelper) {
        String[] numberAndName = BgSpecialBudgetHelper.getDimNumberAndName(dimensionTable, schemeHelper);
        if (numberAndName == null) {
            return null;
        }
        return numberAndName[0];
    }

    private static String[] getDimNumberAndName(KDTable dimensionTable, BgSchemeDimensionHelper schemeHelper) {
        int count = dimensionTable.getRowCount();
        Object[] numberCol = new String[count];
        Object[] nameCol = new String[count];
        Object[] hideCol = new String[count];
        Object dimension = null;
        Object member = null;
        Object isHide = null;
        String srcNumber = null;
        String dimNumber = null;
        String memNumber = null;
        String memName = null;
        StringBuffer dimName = new StringBuffer();
        StringBuffer memDisName = new StringBuffer();
        for (int index = 0; index < count; ++index) {
            IRow row = dimensionTable.getRow(index);
            dimension = row.getCell(COL_DIMENSION).getValue();
            member = row.getCell(COL_MEMBER).getValue();
            isHide = row.getCell(COL_HIDE).getValue();
            if (!(dimension instanceof DimSettingDisplayInfo)) {
                return null;
            }
            dimNumber = ((DimSettingDisplayInfo)dimension).getDimSettingInfo().getDimNumber();
            dimName = dimName.append(((DimSettingDisplayInfo)dimension).getDimSettingInfo().getDimName()).append(",");
            srcNumber = schemeHelper.getSrcNumber(dimNumber);
            memDisName = memDisName.append(((DimSettingDisplayInfo)dimension).getDimSettingInfo().getDimName()).append(":");
            if (member == null) {
                memNumber = "#";
                memName = "#";
            } else if (member instanceof List) {
                if (((List)member).get(0) instanceof BgDimensionMember) {
                    memNumber = ((BgDimensionMember)((List)member).get(0)).getNumber();
                    memName = ((BgDimensionMember)((List)member).get(0)).getName();
                }
            } else if (member instanceof BgDimensionMember) {
                memNumber = ((BgDimensionMember)member).getNumber();
                memName = ((BgDimensionMember)member).getName();
            }
            memDisName = memDisName.append(memName).append(",");
            numberCol[index] = DimensionFormulaHelper.getCombination((String)srcNumber, (String)memNumber);
            nameCol[index] = memName;
            hideCol[index] = String.valueOf(isHide);
        }
        String dimensionNumber = BgSpecialBudgetHelper.arrayToString(numberCol, DimensionConstants.COMMA_SEPARATOR);
        String membersName = BgSpecialBudgetHelper.arrayToString(nameCol, DimensionConstants.TICK_SEPARATOR);
        String hide = BgSpecialBudgetHelper.arrayToString(hideCol, DimensionConstants.COMMA_SEPARATOR);
        String dimensionName = null;
        if (dimName.length() > 0 && dimName.toString().endsWith(",")) {
            dimensionName = dimName.toString().substring(0, dimName.length() - 1).toString();
        }
        String memberDisplayName = null;
        if (memDisName.length() > 0) {
            memberDisplayName = memDisName.toString().endsWith(",") ? memDisName.toString().substring(0, memDisName.length() - 1).toString() : memDisName.toString();
        }
        return new String[]{dimensionNumber, membersName, dimensionName, memberDisplayName, hide};
    }

    public static String arrayToString(Object[] obj, String split) {
        StringBuffer name = new StringBuffer();
        for (int j = 0; j < obj.length; ++j) {
            name.append(obj[j] == null ? "" : obj[j].toString());
            if (j == obj.length - 1) continue;
            name.append(split);
        }
        return name.toString();
    }

    public static Map<String, Set<String>> getFilterMapByUI(BgCslTemplateProcessUI processUI) throws EASBizException, BOSException {
        if (processUI == null || processUI.getBgCslTemplate() == null || processUI.getSchemeHelper() == null) {
            return null;
        }
        return BgSpecialBudgetHelper.getFilterMapByBgTemplate(processUI.getBgCslTemplate(), processUI.getSchemeHelper());
    }

    public static Map<String, Set<String>> getFilterMapByBgTemplate(IBgCslSpecialInfo bgSpecialInfo, BgSchemeDimensionHelper schemeHelper) {
        if (schemeHelper == null) {
            return null;
        }
        List<BgDimensionInfo> bgDimensions = null;
        bgDimensions = schemeHelper == null || bgSpecialInfo == null || bgSpecialInfo.getBgSpecialItems() == null || bgSpecialInfo.getBgSpecialItems().isEmpty() ? new ArrayList<BgDimensionInfo>() : BgSpecialCommonHelper.getBgDimensions(bgSpecialInfo, schemeHelper);
        return BgSpecialBudgetHelper.getFilterMapByDimensions(bgDimensions, schemeHelper);
    }

    public static Map<String, Set<String>> getFilterMapByBgForm(IBgCslSpecialInfo bgSpecialInfo, BgSchemeDimensionHelper schemeHelper) {
        if (schemeHelper == null || bgSpecialInfo == null || bgSpecialInfo.getBgSpecialItems() == null || bgSpecialInfo.getBgSpecialItems().isEmpty()) {
            return null;
        }
        List<BgDimensionInfo> bgDimensions = BgSpecialBudgetHelper.getBgDimensionsByBgForm(bgSpecialInfo, schemeHelper);
        return BgSpecialBudgetHelper.getFilterMapByDimensions(bgDimensions, schemeHelper);
    }

    public static Map<String, Set<String>> getFilterMapByDimensions(List<BgDimensionInfo> bgDimensions, BgSchemeDimensionHelper schemeHelper) {
        if (bgDimensions == null || schemeHelper == null) {
            return null;
        }
        HashMap<String, Object> filterValueMap = null;
        ArrayList<String> specialNumbers = new ArrayList<String>();
        BgDimensionInfo bgDimensionInfo = null;
        List accAndOtherDimNumbers = schemeHelper.getAccAndOtherDim(false);
        if (bgDimensions != null && !bgDimensions.isEmpty()) {
            for (int index = 0; index < bgDimensions.size(); ++index) {
                bgDimensionInfo = bgDimensions.get(index);
                specialNumbers.add(bgDimensionInfo.getNumber());
            }
        }
        if (accAndOtherDimNumbers != null && !accAndOtherDimNumbers.isEmpty()) {
            filterValueMap = new HashMap<String, Object>();
            String number = null;
            for (int index = 0; index < accAndOtherDimNumbers.size(); ++index) {
                number = (String)accAndOtherDimNumbers.get(index);
                if (specialNumbers.contains(number)) continue;
                filterValueMap.put(schemeHelper.getSrcNumber(number), null);
            }
        }
        return filterValueMap;
    }

    public static Component getPageDimensionPanel(SpreadContext sc, CoreUI owerUI, IBgCslSpecialInfo bgSpecialInfo, BgSchemeDimensionHelper schemeHelper, OrgUnitInfo orgUnitInfo) throws Exception {
        KDPanel kdPanel = new KDPanel();
        kdPanel.setLayout((LayoutManager)new BorderLayout());
        kdPanel.add(BgSpecialBudgetHelper.getBgSpecialItemsComponet(owerUI, bgSpecialInfo, schemeHelper, orgUnitInfo), (Object)"North");
        kdPanel.add((Component)sc, (Object)"Center");
        kdPanel.revalidate();
        return kdPanel;
    }

    private static Component getBgSpecialItemsComponet(CoreUI owerUI, IBgCslSpecialInfo bgSpecialInfo, BgSchemeDimensionHelper schemeHelper, OrgUnitInfo orgUnitInfo) throws Exception {
        if (orgUnitInfo == null && bgSpecialInfo.getOrgUnit() != null) {
            orgUnitInfo = bgSpecialInfo.getOrgUnit();
        }
        if (orgUnitInfo == null) {
            return null;
        }
        return BgSpecialBudgetHelper.parseSpecialItemsComponet(owerUI, bgSpecialInfo, schemeHelper, orgUnitInfo.getId().toString());
    }

    public static Component parseSpecialItemsComponet(CoreUI ownerUi, IBgCslSpecialInfo bgSpecialInfo, BgSchemeDimensionHelper schemeHelper, String orgUnitId) throws Exception {
        KDPanel page = new KDPanel();
        page.setName(PAGE_PANEL_NAME);
        page.setLayout((LayoutManager)new LineFlowLayout(0));
        page.setEnabled(true);
        BgSpecialBudgetHelper.parseSpecialItemPanel(page, ownerUi, bgSpecialInfo, schemeHelper, orgUnitId);
        return page;
    }

    private static void parseSpecialItemPanel(KDPanel page, CoreUI ownerUi, IBgCslSpecialInfo bgSpecialInfo, BgSchemeDimensionHelper schemeHelper, String orgUnitId) throws Exception {
        List<BgDimensionInfo> bgDimensions = BgSpecialCommonHelper.getBgDimensions(bgSpecialInfo, schemeHelper);
        BgSpecialBudgetHelper.parseSpecialItemPanel(page, ownerUi, bgDimensions, schemeHelper, orgUnitId);
    }

    public static List<BgDimensionInfo> getBgDimensionsByBgForm(IBgCslSpecialInfo bgSpecialInfo, BgSchemeDimensionHelper schemeHelper) {
        if (bgSpecialInfo.getBgSpecialItems() != null && !bgSpecialInfo.getBgSpecialItems().isEmpty()) {
            BgCslSpecialItemsInfo BgCslSpecialItemsInfo2 = bgSpecialInfo.getBgSpecialItems().get(0);
            return BgSpecialCommonHelper.getBgDimensionsBySpecialItems(BgCslSpecialItemsInfo2, schemeHelper);
        }
        IBgCslSpecialInfo _bgSpecialInfo = null;
        try {
            _bgSpecialInfo = (IBgCslSpecialInfo)((ICoreBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)bgSpecialInfo.getBOSType(), ICoreBase.class)).getValue("select bgSpecialItems.* where id = '" + bgSpecialInfo.getId() + "'");
            if (_bgSpecialInfo != null && !_bgSpecialInfo.getBgSpecialItems().isEmpty()) {
                BgCslSpecialItemsInfo BgCslSpecialItemsInfo3 = _bgSpecialInfo.getBgSpecialItems().get(0);
                bgSpecialInfo.getBgSpecialItems().add(BgCslSpecialItemsInfo3);
                return BgSpecialCommonHelper.getBgDimensionsBySpecialItems(BgCslSpecialItemsInfo3, schemeHelper);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return new ArrayList<BgDimensionInfo>();
    }

    private static void parseSpecialItemPanel(KDPanel page, CoreUI ownerUi, List<BgDimensionInfo> bgDimensions, BgSchemeDimensionHelper schemeHelper, String orgUnitId) throws Exception {
        if (bgDimensions.isEmpty()) {
            return;
        }
        List<KDPanel> subPnl = BgSpecialBudgetHelper.createBgSpecialItemsPnl(ownerUi, orgUnitId, bgDimensions, false, null);
        if (!subPnl.isEmpty()) {
            for (int index = 0; index < subPnl.size(); ++index) {
                page.add((Component)subPnl.get(index));
            }
        }
    }

    private static List<KDPanel> createBgSpecialItemsPnl(CoreUI ownerUI, String orgUnitId, List<? extends BgDimensionInfo> bgDimenions, boolean isF7Enable, String permissionNumber) throws Exception {
        ArrayList<KDPanel> subPnl = new ArrayList<KDPanel>();
        if (bgDimenions != null && bgDimenions.size() > 0) {
            for (int j = 0; j < bgDimenions.size(); ++j) {
                BgDimensionInfo dimensionInfo = bgDimenions.get(j);
                KDPanel pnl = BgSpecialBudgetHelper.createSubPnl(ownerUI, orgUnitId, dimensionInfo, isF7Enable, permissionNumber);
                subPnl.add(pnl);
            }
        }
        return subPnl;
    }

    private static KDPanel createSubPnl(CoreUI ownerUI, String orgUnitId, BgDimensionInfo dimensionInfo, boolean isF7Enable, String permissionNumber) throws Exception {
        if (dimensionInfo == null) {
            return null;
        }
        KDPanel subPnl = new KDPanel();
        subPnl.setName(dimensionInfo.getNumber() + "_PNL");
        subPnl.setVisible(dimensionInfo.isShow());
        subPnl.add((Component)BgSpecialBudgetHelper.createF7Container(ownerUI, orgUnitId, dimensionInfo, isF7Enable, permissionNumber));
        return subPnl;
    }

    private static KDLabelContainer createF7Container(CoreUI ownerUI, String orgUnitId, BgDimensionInfo dimensionInfo, boolean isEnable, String permissionNumber) throws Exception {
        if (dimensionInfo == null) {
            return null;
        }
        KDBizPromptBox f7 = BgSpecialBudgetHelper.getDimensionF7(ownerUI, dimensionInfo, orgUnitId, isEnable);
        KDLabelContainer cont = BgSpecialBudgetHelper.createContainer();
        cont.setBoundLabelText(StringUtils.isEmpty((String)dimensionInfo.getAlias()) ? dimensionInfo.getName() : dimensionInfo.getAlias());
        cont.setBoundEditor((JComponent)f7);
        cont.setName("DimensionF7KDLabelContainer");
        return cont;
    }

    private static KDLabelContainer createContainer() {
        KDLabelContainer cont = new KDLabelContainer();
        cont.setBounds(new Rectangle(240, 19));
        cont.setBoundLabelLength(80);
        cont.setBoundLabelUnderline(true);
        cont.setPreferredSize(new Dimension(240, 19));
        cont.setMinimumSize(new Dimension(240, 19));
        return cont;
    }

    private static KDBizPromptBox getDimensionF7(CoreUI ownerUI, BgDimensionInfo dimensionInfo, String orgUnitId, boolean isEnable) throws Exception {
        if (ownerUI == null || dimensionInfo == null) {
            return null;
        }
        KDBizPromptBox f7 = BgSpecialBudgetHelper.parseDimensionF7(ownerUI, dimensionInfo, orgUnitId, isEnable);
        if (f7 != null) {
            f7.setDisplayFormatter((IFormatter)new AbstractBookParseHelper.DimensionF7Formatter(dimensionInfo.getShowType()));
        }
        return f7;
    }

    private static KDBizPromptBox parseDimensionF7(CoreUI owner, BgDimensionInfo dimensionInfo, String orgUnitId, boolean isEnable) {
        BgDimensionPromptBox prmt = new BgDimensionPromptBox();
        NewDimensionMemberSelectDialog dialog = new NewDimensionMemberSelectDialog((Component)owner, (BgDimensionBaseInfo)dimensionInfo, orgUnitId, false, false);
        HashMap filterValueMap = new HashMap();
        Set<String> numberSet = null;
        BgDimensionMember member = null;
        if (dimensionInfo.getMemberValueType().getValue() != 2 && dimensionInfo.getMember() != null && !dimensionInfo.getMember().isEmpty()) {
            for (int i = 0; i < dimensionInfo.getMember().size(); ++i) {
                member = (BgDimensionMember)dimensionInfo.getMember().get(i);
                String srcNumber = member.getSrcNumber();
                if (!filterValueMap.containsKey(srcNumber)) {
                    numberSet = new HashSet();
                    filterValueMap.put(srcNumber, numberSet);
                } else {
                    numberSet = (Set)filterValueMap.get(srcNumber);
                }
                if (numberSet == null) continue;
                numberSet.add(member.getNumber());
            }
        }
        dialog.setFilterValueMap(filterValueMap);
        dialog.setOnlySelectItem(true);
        prmt.setEditable(false);
        prmt.setCommitFormat("$number$");
        prmt.setEditFormat("$number$");
        prmt.setEnabledMultiSelection(false);
        prmt.setSelector((KDPromptSelector)dialog);
        prmt.addDataChangeListener((DataChangeListener)new ActionDimensionChange((IUIObject)owner));
        prmt.setEnabled(isEnable);
        prmt.setName(dimensionInfo.getNumber());
        if (dimensionInfo.getMember() != null && dimensionInfo.getMember().size() > 0) {
            prmt.setDataNoNotify(dimensionInfo.getMember().get(0));
        } else {
            prmt.setDataNoNotify(null);
        }
        return prmt;
    }

    public static void fillAndbuildFormula(Book book, IBgCslSpecialInfo bgSpecialInfo, BgSchemeDimensionHelper schemeHelper) throws EASBizException, BOSException {
        if (book == null || bgSpecialInfo == null || bgSpecialInfo.getBgSpecialItems().isEmpty() || schemeHelper == null) {
            return;
        }
        if (book.getUserObjectValue(BG_SPECIAL_ITEMS) == null) {
            return;
        }
        BgCslSpecialItemsInfo bgSpecialItem = BgSpecialBudgetHelper.getBgSpecialItem(bgSpecialInfo);
        Sheet sheet = null;
        int sheetCount = book.getSheetCount();
        boolean needReDo = false;
        for (int sheetIndex = 0; sheetIndex < sheetCount; ++sheetIndex) {
            sheet = book.getSheet(sheetIndex);
            BgSpecialBudgetHelper.buildFormula(sheet.getSheetRange(), bgSpecialItem, null, null);
            needReDo = true;
        }
        if (needReDo && bgSpecialInfo.getOrgUnit() != null && schemeHelper != null) {
            BgNTemplateHelper.dealWith((Book)book, (String)bgSpecialInfo.getOrgUnit().getId().toString(), new HashMap(), (boolean)false, (boolean)false, (boolean)false, (boolean)false, null, (BgSchemeDimensionHelper)schemeHelper, (boolean)false, BgSpecialBudgetHelper.getFilterMapByBgForm(bgSpecialInfo, schemeHelper));
        }
        book.removeUserObject(BG_SPECIAL_ITEMS);
    }

    public static void buildFormula(Range range, BgCslSpecialItemsInfo BgCslSpecialItemsInfo2, String bgPeriodNumber, String currency) {
        if (range == null || range.isEmpty()) {
            return;
        }
        CellBlock block = null;
        Sheet sheet = range.getRangeSheets().getSheet(0);
        int rowCount = sheet.getMaxRowIndex();
        int colCount = sheet.getMaxColIndex();
        String formulaString = null;
        String newFormula = null;
        String itemNumber = BgCslSpecialItemsInfo2.getItemNumber();
        String elementNumber = BgCslSpecialItemsInfo2.getElementNumber();
        String scenarioNumber = BgCslSpecialItemsInfo2.getScenarioNumber();
        String[] parameter = null;
        for (int bIndex = 0; bIndex < range.size(); ++bIndex) {
            block = range.getBlock(bIndex);
            for (int rowIndex = block.getRow(); rowIndex <= Math.min(block.getRow2(), rowCount); ++rowIndex) {
                for (int colIndex = block.getCol(); colIndex <= Math.min(block.getCol2(), colCount); ++colIndex) {
                    Cell cell = sheet.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell((Cell)cell) || (parameter = BgNFSHelper.parseFormulaPara(null, (String)(formulaString = BgNFSHelper.getFormulaOfCell((Cell)cell)))) == null) continue;
                    if (parameter.length == 6) {
                        if (!StringUtils.isEmpty((String)itemNumber)) {
                            parameter[0] = BgSpecialBudgetHelper.rebuildItemFormula(itemNumber + "," + parameter[0]);
                        }
                        if (!StringUtils.isEmpty((String)elementNumber) && StringUtils.isEmpty((String)BgNFSHelper.replaceAlter((String)parameter[2]))) {
                            parameter[2] = elementNumber;
                        }
                        if (!StringUtils.isEmpty((String)scenarioNumber) && StringUtils.isEmpty((String)BgNFSHelper.replaceAlter((String)parameter[3]))) {
                            parameter[3] = scenarioNumber;
                        }
                        if (!StringUtils.isEmpty((String)bgPeriodNumber) && StringUtils.isEmpty((String)parameter[1])) {
                            parameter[1] = bgPeriodNumber;
                        }
                        if (!StringUtils.isEmpty((String)currency) && StringUtils.isEmpty((String)parameter[5])) {
                            parameter[5] = currency;
                        }
                        newFormula = new StringBuffer("=BgItem(\"" + StringUtils.cnulls((String)parameter[0]) + "\",\"" + StringUtils.cnulls((String)parameter[1]) + "\",\"" + StringUtils.cnulls((String)parameter[2]) + "\",\"" + StringUtils.cnulls((String)parameter[3]) + "\"," + StringUtils.cnulls((String)parameter[4]) + ",\"" + StringUtils.cnulls((String)parameter[5]) + "\")").toString();
                    } else if (parameter.length == 5) {
                        if (!StringUtils.isEmpty((String)itemNumber)) {
                            parameter[0] = BgSpecialBudgetHelper.rebuildItemFormula(itemNumber + "," + parameter[0]);
                        }
                        if (!StringUtils.isEmpty((String)elementNumber) && StringUtils.isEmpty((String)BgNFSHelper.replaceAlter((String)parameter[2]))) {
                            parameter[2] = elementNumber;
                        }
                        if (!StringUtils.isEmpty((String)scenarioNumber) && StringUtils.isEmpty((String)BgNFSHelper.replaceAlter((String)parameter[3]))) {
                            parameter[3] = scenarioNumber;
                        }
                        if (!StringUtils.isEmpty((String)bgPeriodNumber) && StringUtils.isEmpty((String)parameter[1])) {
                            parameter[1] = bgPeriodNumber;
                        }
                        if (!StringUtils.isEmpty((String)currency) && StringUtils.isEmpty((String)parameter[4])) {
                            parameter[4] = currency;
                        }
                        newFormula = new StringBuffer("=BgItem(\"" + StringUtils.cnulls((String)parameter[0]) + "\",\"" + StringUtils.cnulls((String)parameter[1]) + "\",\"" + StringUtils.cnulls((String)parameter[2]) + "\",\"" + StringUtils.cnulls((String)parameter[3]) + "\",true,\"" + StringUtils.cnulls((String)parameter[4]) + "\")").toString();
                    }
                    BgNFSHelper.setFormulaOfCell((Cell)cell, newFormula);
                }
            }
        }
    }

    private static String rebuildItemFormula(String formula) {
        if (StringUtils.isEmpty((String)formula)) {
            return formula;
        }
        String[] combins = DimensionFormulaHelper.splitCombinations((String)formula);
        HashMap<String, String> srcNumbers = new HashMap<String, String>();
        for (int i = 0; i < combins.length; ++i) {
            srcNumbers.put(DimensionFormulaHelper.getSrcNumber((String)combins[i]), DimensionFormulaHelper.getMemberNumber((String)combins[i]));
        }
        StringBuffer items = new StringBuffer();
        for (String srcNumber : srcNumbers.keySet()) {
            if (items.length() > 0) {
                items.append(",");
            }
            items.append(DimensionFormulaHelper.getCombination((String)srcNumber, (String)((String)srcNumbers.get(srcNumber))));
        }
        return items.toString();
    }

    public static boolean checkIsSpecialBudget(IBgCslSpecialInfo bgSpecialInfo) {
        boolean isSpecialBudget = false;
        if (bgSpecialInfo != null) {
            if (bgSpecialInfo.getBgSpecialItems() != null && !bgSpecialInfo.getBgSpecialItems().isEmpty()) {
                isSpecialBudget = true;
            }
            if (bgSpecialInfo.getFormType().getValue() == 8) {
                isSpecialBudget = true;
            }
        }
        return isSpecialBudget;
    }

    public static Set<String> arrayToSet(String[] arr) {
        if (arr == null || arr.length == 0) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        for (int index = 0; index < arr.length; ++index) {
            set.add(arr[index]);
        }
        return set;
    }

    private static Set<String> getSrcSet(String[] dimNums) {
        if (dimNums == null || dimNums.length == 0) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        for (int index = 0; index < dimNums.length; ++index) {
            if (!dimNums[index].contains(":")) continue;
            set.add(dimNums[index].split(":")[0]);
        }
        return set;
    }

    public static void removeEditHelper(KDTable table) {
        if (table != null) {
            ActionMap am = table.getActionMap();
            am.remove("Cut");
            am.remove("Paste");
            am.remove("Copy");
            am.remove("Delete");
        }
    }

    public static void setNewSpecBook(Book book) {
        book.setUserObject(BG_SPECIAL_ITEMS, (Object)BG_SPECIAL_ITEMS);
    }
}

