/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client.notify;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.uiframe.client.MainStatusBar;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.ma.base.MbgDimFactory;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.MbgMemberCollection;
import com.kingdee.eas.ma.base.MbgMemberFactory;
import com.kingdee.eas.ma.base.MbgMemberInfo;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.bgcsl.BgCslAdjFormInfo;
import com.kingdee.eas.ma.bgcsl.BgCslFormInfo;
import com.kingdee.eas.ma.bgcsl.MbgWorkPaperInfo;
import com.kingdee.eas.ma.bgcsl.utils.BgCslDimensionMemberCheckHelper;
import com.kingdee.eas.ma.bgcsl.utils.MbgWorkPaperMemberCheckHelper;
import com.kingdee.eas.ma.mbg.BgDataStateEnum;
import com.kingdee.eas.ma.mbg.BgDimSettingsCollection;
import com.kingdee.eas.ma.mbg.BgDimSettingsFactory;
import com.kingdee.eas.ma.mbg.BgDimSettingsInfo;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgCslDimConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class CellDoubleClickListener {
    private static final Logger logger = CoreUIObject.getLogger(CellDoubleClickListener.class);
    private Cell _cell = null;
    private DimensionMemberCheckHelper _helper = null;
    private Map _bgdataMap = null;
    private BgCslAdjFormInfo _bgCslAdjFormInfo = null;
    private BgCslFormInfo _bgCslFormInfo = null;
    private MbgWorkPaperInfo _mbgWorkPaperInfo = null;
    private MainStatusBar _statusBar = null;
    private String res = "com.kingdee.eas.ma.bgcsl.BgCslPromtResource";

    public CellDoubleClickListener(MainStatusBar statusBar, Cell cell, DimensionMemberCheckHelper helper, Map bgdataMap) {
        this._statusBar = statusBar;
        this._cell = cell;
        this._helper = helper;
        this._bgdataMap = bgdataMap;
    }

    public CellDoubleClickListener(MainStatusBar statusBar, Cell cell, BgCslAdjFormInfo bgCslAdjFormInfo, DimensionMemberCheckHelper helper, Map bgdataMap) {
        this(statusBar, cell, helper, bgdataMap);
        this._bgCslAdjFormInfo = bgCslAdjFormInfo;
    }

    public CellDoubleClickListener(MainStatusBar statusBar, Cell cell, BgCslFormInfo bgCslFormInfo, DimensionMemberCheckHelper helper, Map bgdataMap) {
        this(statusBar, cell, helper, bgdataMap);
        this._bgCslFormInfo = bgCslFormInfo;
    }

    public CellDoubleClickListener(MainStatusBar statusBar, Cell cell, MbgWorkPaperInfo mbgWorkPaperInfo, DimensionMemberCheckHelper helper, Map bgdataMap) {
        this(statusBar, cell, helper, bgdataMap);
        this._mbgWorkPaperInfo = mbgWorkPaperInfo;
    }

    public void doubleClick() {
        if (this._cell != null && this._cell.isLocked()) {
            String msg = null;
            if (this._helper != null && BgNFSHelper.checkHasFormulaOfCell((Cell)this._cell)) {
                msg = this.checkVersion();
                if (StringUtils.isEmpty((String)msg)) {
                    msg = this.checkCslMerge();
                }
                if (StringUtils.isEmpty((String)msg)) {
                    msg = this.checkDimensionMemberIsDetailOrNot();
                }
                if (StringUtils.isEmpty((String)msg)) {
                    msg = this.checkBgDataState();
                }
                if (StringUtils.isEmpty((String)msg)) {
                    msg = EASResource.getString((String)this.res, (String)"bgLockPromt");
                }
            }
            if (!StringUtils.isEmpty(msg)) {
                this.showPromt(msg);
            }
        }
    }

    public void showPromt(final String msg) {
        final KDLabel barLabel = this._statusBar.getMsgLabel();
        barLabel.setBounds(barLabel.getX(), barLabel.getY(), 650, barLabel.getHeight());
        final Icon icon = EASResource.getIcon((String)"imgState_cue_2");
        final Color bg = new Color(170, 32, 50);
        Color fg = new Color(255, 246, 0);
        barLabel.setForeground(fg);
        if (icon != null) {
            barLabel.setIcon(icon);
        }
        barLabel.setText(msg);
        new Thread(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 10; ++i) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                barLabel.setBackground(bg);
                                barLabel.setIcon(icon);
                                barLabel.setText(msg);
                                barLabel.setOpaque(true);
                                barLabel.repaint();
                            }
                        });
                        Thread.sleep(200L);
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                barLabel.setOpaque(false);
                                barLabel.setIcon(icon);
                                barLabel.setText(msg);
                                barLabel.repaint();
                            }
                        });
                        Thread.sleep(200L);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error((Object)"showPromt: ", (Throwable)e);
                    }
                }
                barLabel.setIcon(null);
                barLabel.setText(null);
                barLabel.repaint();
            }
        }).start();
    }

    private String checkDimensionMemberIsDetailOrNot() {
        String msg = null;
        Map leafMap = this._helper.getLeafMap();
        if (leafMap == null || leafMap.isEmpty()) {
            return msg;
        }
        String formula = BgNFSHelper.getFormulaOfCell((Cell)this._cell);
        String[] formulaParam = BgNFSHelper.parseFormulaPara((String)formula);
        if (!this._helper.check(DimensionConstants.DEF_PERIOD_SRCNUMBER, formulaParam[1])) {
            msg = EASResource.getString((String)this.res, (String)"bgPeriodPromt");
            return msg;
        }
        if (StringUtils.isEmpty(msg)) {
            msg = this.isDetailItem(formulaParam);
        }
        return msg;
    }

    private String checkCslMerge() {
        String msg = null;
        if (this._bgCslAdjFormInfo != null || this._mbgWorkPaperInfo != null) {
            String formula = BgNFSHelper.getFormulaOfCell((Cell)this._cell);
            String[] formulaParam = BgNFSHelper.parseFormulaPara((String)formula);
            String[] itemNumbers = formulaParam[0].split(",");
            msg = this.checkCsl(itemNumbers);
        }
        return msg;
    }

    private String checkVersion() {
        ItemFormula itemFormula;
        String version;
        String msg = null;
        if (!(this._bgCslFormInfo == null && this._mbgWorkPaperInfo == null || StringUtils.isEmpty((String)(version = (itemFormula = BgNFSHelper.getItemFormula((Cell)this._cell)).getExt("Version"))))) {
            if (this._bgCslFormInfo != null && this._bgCslFormInfo.getBizVersion() != null && !version.equals(this._bgCslFormInfo.getBizVersion().getNumber())) {
                msg = EASResource.getString((String)this.res, (String)"bgCslVersionPromt");
                return msg;
            }
            if (this._mbgWorkPaperInfo != null && this._mbgWorkPaperInfo.getBizVersion() != null && !version.equals(this._mbgWorkPaperInfo.getBizVersion().getNumber())) {
                msg = EASResource.getString((String)this.res, (String)"BgWpVersionPromt");
                return msg;
            }
        }
        return msg;
    }

    protected String isDetailItem(String[] formulaParam) {
        String msg = null;
        String[] itemNumbers = formulaParam[0].split(",");
        if (this._helper instanceof BgCslDimensionMemberCheckHelper) {
            msg = ((BgCslDimensionMemberCheckHelper)this._helper).getDimGroupMap().get(itemNumbers[0]) == null ? this.checkNormal(itemNumbers) : this.checkSpecial(itemNumbers);
        } else if (this._helper instanceof MbgWorkPaperMemberCheckHelper) {
            msg = ((MbgWorkPaperMemberCheckHelper)this._helper).getDimGroupMap().get(itemNumbers[0]) == null ? this.checkNormal(itemNumbers) : this.checkSpecial(itemNumbers);
        }
        return msg;
    }

    private String checkSpecial(String[] itemNumbers) {
        String msg = null;
        Map<String, Set<String>> mbgMemberMap = null;
        if (this._helper instanceof MbgWorkPaperMemberCheckHelper) {
            mbgMemberMap = ((MbgWorkPaperMemberCheckHelper)this._helper).getDimGroupMap().get(itemNumbers[0]);
        } else if (this._helper instanceof BgCslDimensionMemberCheckHelper) {
            mbgMemberMap = ((BgCslDimensionMemberCheckHelper)this._helper).getDimGroupMap().get(itemNumbers[0]);
        }
        for (int i = 1; i < itemNumbers.length; ++i) {
            Set<String> mbgMemberSet;
            String srcNumber = DimensionFormulaHelper.getSrcNumber((String)itemNumbers[i]);
            String number = DimensionFormulaHelper.getMemberNumber((String)itemNumbers[i]);
            if (mbgMemberMap == null || (mbgMemberSet = mbgMemberMap.get(srcNumber)) == null || mbgMemberSet.contains(itemNumbers[i])) continue;
            msg = EASResource.getString((String)this.res, (String)"bgSpecialMemberPromt", (Object[])new Object[]{DimensionFormulaHelper.getMemberNumber((String)itemNumbers[0])});
            return msg;
        }
        return msg;
    }

    private String checkCsl(String[] itemNumbers) {
        String msg = null;
        for (int i = 0; i < itemNumbers.length; ++i) {
            if (StringUtils.isEmpty((String)itemNumbers[i])) continue;
            String srcNumber = DimensionFormulaHelper.getSrcNumber((String)itemNumbers[i]);
            String number = DimensionFormulaHelper.getMemberNumber((String)itemNumbers[i]);
            if (!DimensionBaseConstants.DEF_CSL_SRCNUMBER.equals(srcNumber)) continue;
            if (this._bgCslAdjFormInfo != null) {
                if (number.equals("CSL-01")) {
                    String name = BgCslDimConstants.CSL_MERGER_01_NAME;
                    msg = EASResource.getString((String)this.res, (String)"bgCslMergePromt", (Object[])new Object[]{name});
                    return msg;
                }
                if (number.equals("CSL-02")) {
                    String name = BgCslDimConstants.CSL_MERGER_02_NAME;
                    msg = EASResource.getString((String)this.res, (String)"bgCslMergePromt", (Object[])new Object[]{name});
                    return msg;
                }
                if (!number.equals("CSL-03")) continue;
                String name = BgCslDimConstants.CSL_MERGER_03_NAME;
                msg = EASResource.getString((String)this.res, (String)"bgCslMergePromt", (Object[])new Object[]{name});
                return msg;
            }
            if (this._mbgWorkPaperInfo == null) continue;
            if (number.equals("CSL-01")) {
                String name = BgCslDimConstants.CSL_MERGER_01_NAME;
                msg = EASResource.getString((String)this.res, (String)"bgCslMergePromt", (Object[])new Object[]{name});
                return msg;
            }
            if (number.equals("CSL-03")) {
                String name = BgCslDimConstants.CSL_MERGER_03_NAME;
                msg = EASResource.getString((String)this.res, (String)"bgCslMergePromt", (Object[])new Object[]{name});
                return msg;
            }
            if (number.equals("CSL-04")) {
                String name = BgCslDimConstants.CSL_MERGER_04_NAME;
                msg = EASResource.getString((String)this.res, (String)"bgCslMergePromt", (Object[])new Object[]{name});
                return msg;
            }
            if (!number.equals("CSL-08")) continue;
            String name = BgCslDimConstants.CSL_MERGER_08_NAME;
            msg = EASResource.getString((String)this.res, (String)"bgCslMergePromt", (Object[])new Object[]{name});
            return msg;
        }
        return msg;
    }

    private String checkNormal(String[] itemNumbers) {
        String msg = null;
        for (int i = 0; i < itemNumbers.length; ++i) {
            if (StringUtils.isEmpty((String)itemNumbers[i])) continue;
            String srcNumber = DimensionFormulaHelper.getSrcNumber((String)itemNumbers[i]);
            String number = DimensionFormulaHelper.getMemberNumber((String)itemNumbers[i]);
            if (!"Acc".equals(srcNumber)) continue;
            msg = this.checkAccount(srcNumber, number);
        }
        if (msg == null) {
            String accountNumber = null;
            for (int i = 0; i < itemNumbers.length; ++i) {
                if (StringUtils.isEmpty((String)itemNumbers[i])) continue;
                String srcNumber = DimensionFormulaHelper.getSrcNumber((String)itemNumbers[i]);
                String number = DimensionFormulaHelper.getMemberNumber((String)itemNumbers[i]);
                if (!"Acc".equals(srcNumber)) {
                    try {
                        MbgMemberInfo memInfo;
                        MbgDimInfo mbgDimInfo = MbgDimFactory.getRemoteInstance().getMbgDimInfo("select id where srcNumber = '" + srcNumber + "'");
                        MbgMemberCollection memColl = MbgMemberFactory.getRemoteInstance().getMbgMemberCollection("select parent.id where number = '" + number + "' and mbgDim = '" + mbgDimInfo.getId().toString() + "'");
                        if (memColl.size() > 0 && (memInfo = memColl.get(0)).getParent() != null) {
                            msg = EASResource.getString((String)this.res, (String)"bgSpecialMemberPromt", (Object[])new Object[]{accountNumber});
                            return msg;
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)"checkNormal: ", (Throwable)e);
                    }
                    continue;
                }
                accountNumber = number;
            }
        }
        return msg;
    }

    private String checkAccount(String srcNumber, String number) {
        String msg = null;
        if (!this._helper.check(srcNumber, number)) {
            String bgSchemeid = this.getBgSchemeid();
            try {
                BgDimSettingsCollection coll = BgDimSettingsFactory.getRemoteInstance().getBgDimSettingsCollection("where bgScheme = '" + bgSchemeid + "'");
                for (BgDimSettingsInfo bgDimSettingInfo : coll) {
                    String bgDimNumber = bgDimSettingInfo.getDimNumber();
                    String name = bgDimSettingInfo.getDimName();
                    if (!"Acc".equals(srcNumber) || !DimensionBaseConstants.DEF_ACCOUNT_NUMBER.equals(bgDimNumber)) continue;
                    msg = EASResource.getString((String)this.res, (String)"bgAccountPromt");
                    return msg;
                }
            }
            catch (BOSException e) {
                logger.error((Object)"isDetailItem: ", (Throwable)e);
            }
        }
        return msg;
    }

    private String checkBgDataState() {
        String msg = null;
        String _tmpStr = BgNFSHelper.getFormulaOfCell((Cell)this._cell);
        BgNDataInfo _bgData = this.getDimData(_tmpStr);
        if (_bgData != null && 0 != _bgData.getState() && 1 != _bgData.getState()) {
            String name = BgDataStateEnum.getEnum((int)_bgData.getState()).getAlias();
            msg = EASResource.getString((String)this.res, (String)"bgDataState", (Object[])new Object[]{name});
        }
        return msg;
    }

    private BgNDataInfo getDimData(String formulaStr) {
        if (formulaStr == null) {
            return null;
        }
        String versionNumber = this.getBgVersionNumber();
        String tmpKey = DimUtils.getDimDataKey((String)formulaStr, (String)versionNumber);
        BgNDataInfo bgNDataInfo = null;
        int formType = this.getFormType();
        if (this._mbgWorkPaperInfo != null || (this._bgCslAdjFormInfo != null || this._bgCslFormInfo != null) && (4 == formType || 2 == formType)) {
            ItemFormula itemFormula = BgNFSHelper.getItemFormula((Cell)this._cell);
            String cellOrgId = itemFormula.getExt("ORGUNITID");
            bgNDataInfo = (BgNDataInfo)((Map)this._bgdataMap.get(cellOrgId)).get(tmpKey);
        } else {
            bgNDataInfo = (BgNDataInfo)this._bgdataMap.get(tmpKey);
        }
        return bgNDataInfo;
    }

    private int getFormType() {
        int formType = -1;
        if (this._bgCslAdjFormInfo != null) {
            formType = this._bgCslAdjFormInfo.getBgCslTemplate().getFormType().getValue();
        } else if (this._bgCslFormInfo != null) {
            formType = this._bgCslFormInfo.getBgCslTemplate().getFormType().getValue();
        }
        return formType;
    }

    private String getBgVersionNumber() {
        String bgVersionNumber = null;
        if (this._bgCslAdjFormInfo != null) {
            bgVersionNumber = this._bgCslAdjFormInfo.getBgVersion().getNumber();
        } else if (this._bgCslFormInfo != null) {
            bgVersionNumber = this._bgCslFormInfo.getBgVersion().getNumber();
        } else if (this._mbgWorkPaperInfo != null) {
            bgVersionNumber = this._mbgWorkPaperInfo.getBgVersion().getNumber();
        }
        return bgVersionNumber;
    }

    private String getBgSchemeid() {
        String bgSchemeid = null;
        if (this._bgCslAdjFormInfo != null) {
            bgSchemeid = this._bgCslAdjFormInfo.getBgScheme().getId().toString();
        } else if (this._bgCslFormInfo != null) {
            bgSchemeid = this._bgCslFormInfo.getBgScheme().getId().toString();
        } else if (this._mbgWorkPaperInfo != null) {
            bgSchemeid = this._mbgWorkPaperInfo.getBgScheme().getId().toString();
        }
        return bgSchemeid;
    }
}

