/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgUserOperationCollection;
import com.kingdee.eas.ma.base.BgUserOperationFactory;
import com.kingdee.eas.ma.base.BgUserOperationInfo;
import com.kingdee.eas.ma.base.MbgMemberInfo;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.base.utils.BgCommNHelper;
import com.kingdee.eas.ma.bgcsl.BgCslException;
import com.kingdee.eas.ma.bgcsl.BgElimContextHelper;
import com.kingdee.eas.ma.bgcsl.BgEliminationHelper;
import com.kingdee.eas.ma.bgcsl.IBgElimContext;
import com.kingdee.eas.ma.bgcsl.client.BgCslAdjFormProcessUI;
import com.kingdee.eas.ma.bgcsl.client.BgCslAuditSpecialProcessUI;
import com.kingdee.eas.ma.bgcsl.client.BgCslFormAuditProcessUI;
import com.kingdee.eas.ma.bgcsl.client.BgCslFormProcessUI;
import com.kingdee.eas.ma.bgcsl.client.BgCslFormSpecialProcessUi;
import com.kingdee.eas.ma.bgcsl.client.BgCslViewListAuditProcessUI;
import com.kingdee.eas.ma.bgcsl.client.BgCslViewListFormProcessUI;
import com.kingdee.eas.ma.bgcsl.client.MbgWorkPaperProcessUI;
import com.kingdee.eas.ma.bgcsl.client.UnionCombinDataF7;
import com.kingdee.eas.ma.bgcsl.client.cslForm.BgCslViewListFormContextManager;
import com.kingdee.eas.ma.bgcsl.common.BgCslElimHelper;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberCollection;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberFactory;
import com.kingdee.eas.ma.mbg.BgFacadeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeCollection;
import com.kingdee.eas.ma.mbg.BgSchemeException;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.DimensionMemberValueModeEnum;
import com.kingdee.eas.ma.mbg.client.MbgViewListFormProcessUI;
import com.kingdee.eas.ma.mbg.client.common.ICalculate;
import com.kingdee.eas.ma.mbg.client.utils.MBGViewListFormClientHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.eas.ma.mbg.utils.BgCslDimConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.MbgPermissionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BgCslClientHelper {
    private static final Logger logger = CoreUIObject.getLogger(BgCslClientHelper.class);
    public static final String CSLEXAMINERESOURCE = "com.kingdee.eas.ma.bgcsl.client.BgExamineResource";
    public static final String ORG_TREE = "orgTree";
    public static final String F7_COMPANY = "f7Company";
    public static final String BG_SCHEME = "bgScheme";
    public static final String ORG_TREE_NODE = "ORG_TREE_NODE";

    public static void setBgSchemeView(KDBizPromptBox prmtBgScheme, OrgTreeInfo orgTree) throws BOSException, EASBizException {
        EntityViewInfo view = BgCslClientHelper.getBgSchemeView(orgTree);
        prmtBgScheme.setEntityViewInfo(view);
        prmtBgScheme.getQueryAgent().resetRuntimeEntityView();
        BgSchemeCollection col = BgSchemeFactory.getRemoteInstance().getBgSchemeCollection(view);
        if (col == null) {
            prmtBgScheme.setDataNoNotify(null);
        } else if (col.size() == 1) {
            prmtBgScheme.setDataNoNotify((Object)col.get(0));
        } else if (prmtBgScheme.getData() instanceof BgSchemeInfo) {
            boolean isClear = true;
            BgSchemeInfo old = (BgSchemeInfo)prmtBgScheme.getData();
            for (int i = 0; i < col.size(); ++i) {
                if (!old.getId().equals((Object)col.get(i).getId())) continue;
                isClear = false;
                break;
            }
            if (isClear) {
                prmtBgScheme.setDataNoNotify(null);
            }
        }
    }

    public static Set getSchemeIdsByOrgTree(OrgTreeInfo orgTree) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String bgSchemeId = null;
        HashSet<String> set = new HashSet<String>();
        if (orgTree != null && orgTree.getId() != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("memberId");
            sic.add("bgDimSettings.bgScheme.id");
            view.setSelector(sic);
            filter.getFilterItems().add(new FilterItemInfo("memberId", (Object)orgTree.getId().toString(), CompareType.EQUALS));
            filter = MbgPermissionHelper.addBgSchemePermission(null, null, (String)SysContext.getSysContext().getCurrentUserInfo().getId().toString(), (FilterInfo)filter, (String)"bgDimSettings.bgScheme.id");
            view.setFilter(filter);
            BgDimSettingsMemberCollection col = BgDimSettingsMemberFactory.getRemoteInstance().getBgDimSettingsMemberCollection(view);
            if (col != null && !col.isEmpty()) {
                for (int i = 0; i < col.size(); ++i) {
                    bgSchemeId = col.get(i).getBgDimSettings().getBgScheme().getId().toString();
                    set.add(bgSchemeId);
                }
            }
        }
        return set;
    }

    public static EntityViewInfo getBgSchemeView(OrgTreeInfo orgTree) throws BOSException, EASBizException {
        Set set = BgCslClientHelper.getSchemeIdsByOrgTree(orgTree);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (!set.isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)BgBaseConstants.nullID, CompareType.EQUALS));
        }
        view.setFilter(filter);
        return view;
    }

    public static void setBgCslTemplateView(KDBizPromptBox prmtBgTemplate, BgSchemeInfo bgSchemeInfo, OrgTreeInfo orgTree) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (bgSchemeInfo != null && bgSchemeInfo.getId() != null && orgTree != null && orgTree.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeInfo.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("orgTree.id", (Object)orgTree.getId().toString(), CompareType.EQUALS));
            view.setFilter(filter);
            prmtBgTemplate.setEntityViewInfo(view);
        }
    }

    public static void setWorkTemplateView(KDBizPromptBox prmtWorkTemplate, BgSchemeInfo bgSchemeInfo, OrgTreeInfo orgTree) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (bgSchemeInfo != null && bgSchemeInfo.getId() != null && orgTree != null && orgTree.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeInfo.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("orgTree.id", (Object)orgTree.getId().toString(), CompareType.EQUALS));
            view.setFilter(filter);
            prmtWorkTemplate.setEntityViewInfo(view);
            prmtWorkTemplate.getQueryAgent().resetRuntimeEntityView();
        }
    }

    public static boolean initOrgTreeComboBox(KDComboBox combOrgTree) throws Exception {
        boolean isDiff = false;
        OrgTreeInfo curOrgTreeInfo = BgElimContextHelper.getBgElimContext().getCurOrgBound();
        OrgTreeCollection ocn = BgEliminationHelper.getOrgTreeCollection();
        combOrgTree.removeAllItems();
        if (ocn != null && !ocn.isEmpty()) {
            combOrgTree.addItems(ocn.toArray());
            int curIndex = 0;
            if (curOrgTreeInfo != null) {
                for (int index = 0; index < ocn.size(); ++index) {
                    if (!curOrgTreeInfo.getId().equals((Object)ocn.get(index).getId())) continue;
                    if (curIndex == index) {
                        isDiff = true;
                    }
                    curIndex = index;
                    break;
                }
            }
            combOrgTree.setSelectedIndex(curIndex);
        }
        return isDiff;
    }

    public static void refreshCompany(CoreUIObject owner, KDBizPromptBox F7Company, OrgTreeInfo orgTreeInfo) {
        if (orgTreeInfo != null) {
            F7Company.setValue(null);
            UnionCombinDataF7 oldf7 = null;
            if (F7Company.getSelector() instanceof UnionCombinDataF7) {
                oldf7 = (UnionCombinDataF7)F7Company.getSelector();
            }
            UnionCombinDataF7 f7 = new UnionCombinDataF7((IUIObject)owner, 2);
            if (oldf7 == null) {
                oldf7 = f7;
            }
            if (oldf7 == null || !orgTreeInfo.getId().toString().equals(oldf7.getTreeID())) {
                f7.setTreeID(orgTreeInfo.getId().toString());
            } else {
                f7 = oldf7;
            }
            HashMap map = null;
            try {
                map = (HashMap)PermissionFactory.getRemoteInstance().getUnionUnits(BgEliminationHelper.getPK((IObjectValue)SysContext.getSysContext().getCurrentUserInfo()), BgEliminationHelper.getPK((IObjectValue)orgTreeInfo));
            }
            catch (EASBizException e) {
                owner.handUIException((Throwable)e);
            }
            catch (BOSException e) {
                owner.handUIException((Throwable)e);
            }
            F7Company.setSelector((KDPromptSelector)f7);
            F7Company.setEnabled(true);
        } else {
            F7Company.setValue(null);
            F7Company.setEnabled(false);
        }
    }

    private static String getUserId() {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        return userInfo == null ? "" : userInfo.getId().toString();
    }

    public static Map<String, Object> getBgElimOperationMap() throws BOSException, EASBizException {
        Map<String, Object> bgElimOperationMap = new HashMap<String, Object>();
        Map dataMap = null;
        BgUserOperationInfo info = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("user.id", (Object)BgCslClientHelper.getUserId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)1, CompareType.EQUALS));
        BgUserOperationCollection col = BgUserOperationFactory.getRemoteInstance().getBgUserOperationCollection(view);
        if (col != null && !col.isEmpty()) {
            info = col.get(0);
            dataMap = (Map)BgAnalyseHelper.getObject((byte[])info.getData());
            bgElimOperationMap = BgUserOperationFactory.getRemoteInstance().getEliminationInfo(dataMap);
        }
        return bgElimOperationMap;
    }

    public static String getBgCslFormProcessUIName(int formType) {
        switch (formType) {
            case 0: {
                return BgCslFormProcessUI.class.getName();
            }
            case 2: {
                return BgCslViewListFormProcessUI.class.getName();
            }
            case 8: {
                return BgCslFormSpecialProcessUi.class.getName();
            }
        }
        return null;
    }

    public static String getBgCslAuditProcessUIName(int formType) {
        switch (formType) {
            case 0: {
                return BgCslFormAuditProcessUI.class.getName();
            }
            case 2: {
                return BgCslViewListAuditProcessUI.class.getName();
            }
            case 8: {
                return BgCslAuditSpecialProcessUI.class.getName();
            }
        }
        return null;
    }

    public static void reloadBook(BgCslViewListFormContextManager contextManager, boolean isOnlyLoadBook) throws Exception {
        Book book = null;
        int sheetIndex = contextManager.getSpreadContext().getBook().getActiveSheetIndex();
        if (isOnlyLoadBook) {
            book = contextManager.getProvider().loadBook();
        } else {
            contextManager.getProvider().resetBookParserHelper();
            book = (Book)contextManager.getProvider().load();
        }
        contextManager.getSpreadContext().setBook(book);
        contextManager.registerFormulaToBook();
        contextManager.getProvider().fillData(contextManager.getSpreadContext().getBook());
        MBGViewListFormClientHelper.checkItemDimeinsionEmpty((CoreUIObject)contextManager.getOwnerUI(), (MbgViewListDimensionManager)contextManager.getProvider().getBgDimensionManager());
        contextManager.getSpreadContext().getBook().getUndoManager().discardAllEdits();
        contextManager.enableCal();
        contextManager.getSpreadContext().repaint();
        if (contextManager.getOwnerUI() instanceof ICalculate) {
            try {
                contextManager.getOwnerUI().actionCalculate_actionPerformed(new ActionEvent(contextManager.getOwnerUI(), 0, MbgViewListFormProcessUI.class.getName() + "$ActionCalculate"));
            }
            catch (Exception e1) {
                contextManager.getOwnerUI().handUIExceptionAndAbort(e1);
            }
        }
        book.setActiveSheet(sheetIndex);
    }

    public static void setCurBgScheme(KDBizPromptBox prmtBgScheme, IBgElimContext bgElimContext) throws EASBizException, BOSException {
        if (bgElimContext.getCurBgScheme() != null) {
            FilterInfo filter = (FilterInfo)prmtBgScheme.getEntityViewInfo().getFilter().clone();
            SorterItemCollection sortColls = new SorterItemCollection();
            SorterItemInfo sortInfo = new SorterItemInfo("number");
            sortInfo.setSortType(SortType.ASCEND);
            sortColls.add(sortInfo);
            prmtBgScheme.getEntityViewInfo().setSorter(sortColls);
            BgCommHelper.addFilterItem((FilterInfo)filter, (FilterItemInfo)new FilterItemInfo("id", (Object)bgElimContext.getCurBgScheme().getId().toString()));
            if (BgSchemeFactory.getRemoteInstance().exists(filter)) {
                prmtBgScheme.setData((Object)bgElimContext.getCurBgScheme());
            }
        }
    }

    public static LongTimeDialog LongTimeDialogFactory(Component c) {
        Window win;
        LongTimeDialog dialog = null;
        if (c.getParent() == null) {
            c = (Component)((CoreUI)c).getUIContext().get("Owner");
        }
        if ((win = SwingUtilities.getWindowAncestor(c)) instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        return dialog;
    }

    public static void checkFilled(String bgSchemeId) throws EASBizException, BOSException {
        if (!StringUtils.isEmpty((String)bgSchemeId)) {
            try {
                BgSchemeFactory.getRemoteInstance().checkFilling(bgSchemeId);
            }
            catch (BgSchemeException e) {
                if (BgSchemeException.BGSCHEMEFILLED.getCode().equals(e.getSubCode())) {
                    throw new BgCslException(BgCslException.CSLSCHEMEFILLED);
                }
                throw e;
            }
        }
    }

    public static void checkHasCslScheme(CoreUI ownerUi, String bgSchemeId, String orgTreeId) {
        try {
            if (!BgDimSettingsMemberFactory.getRemoteInstance().exists("where memberId = '" + orgTreeId + "' and bgDimSettings.bgScheme.id = '" + bgSchemeId + "'")) {
                MsgBox.showInfo((Component)ownerUi, (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslElimResource", (String)"bgCslSchemeIsNull"));
                SysUtil.abort();
            }
        }
        catch (EASBizException e) {
            ownerUi.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (BOSException e) {
            ownerUi.handUIExceptionAndAbort((Exception)((Object)e));
        }
    }

    public static Map<String, MbgMemberInfo> getFirstLevelMembers(BgSchemeDimensionHelper schemeHelper) throws BOSException, EASBizException {
        return BgCslElimHelper.getFirstLevelMembers(null, schemeHelper);
    }

    public static MbgViewListManager getDefaultViewManagerImpl(List<BgDimensionInfo> dimensions, Map<String, MbgMemberInfo> memberMap) throws BOSException {
        MbgViewListManager view = new MbgViewListManager();
        MbgViewListSheetManager sheet = BgCslClientHelper.getDefaultSheetManagerImpl(view, dimensions, memberMap);
        view.getSheetManagers().add(sheet);
        return view;
    }

    public static MbgViewListSheetManager getDefaultSheetManagerImpl(MbgViewListManager view, List<BgDimensionInfo> dimensions, Map<String, MbgMemberInfo> memberMap) throws BOSException {
        MbgViewListSheetManager sheet = new MbgViewListSheetManager(view, view.getSheetManagers().size(), "Sheet" + (view.getSheetSequence() + 1));
        if (dimensions != null) {
            MbgViewListDimensionInfo viewListDim = null;
            for (int i = 0; i < dimensions.size(); ++i) {
                viewListDim = new MbgViewListDimensionInfo(sheet.getDimensionManager());
                dimensions.get(i).cloneValue((BgDimensionBaseInfo)viewListDim);
                if (DimensionConstants.DEF_ACCOUNT_NUMBER.equals(viewListDim.getNumber())) {
                    viewListDim.setLayout("row");
                } else if (DimensionConstants.DEF_PERIOD_NUMBER.equals(viewListDim.getNumber())) {
                    viewListDim.setLayout("col");
                } else {
                    viewListDim.setLayout("page");
                }
                if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(viewListDim.getNumber())) {
                    viewListDim.setMemberValueType(DimensionMemberValueModeEnum.Null);
                } else {
                    viewListDim.setMemberValueType(DimensionMemberValueModeEnum.SelectMember);
                }
                if (DimensionConstants.DEF_CSL_NUMBER.equals(viewListDim.getNumber())) {
                    MbgViewListDimensionMember dimMember = new MbgViewListDimensionMember(DimensionConstants.DEF_CSL_NUMBER, "roMAAAAtRdvy1qMX", BgCslDimConstants.CSL_MERGER_08_NAME, "CSL-08");
                    viewListDim.getSelectMembers().add(dimMember);
                } else if (memberMap.containsKey(viewListDim.getNumber())) {
                    MbgMemberInfo member = memberMap.get(viewListDim.getNumber());
                    MbgViewListDimensionMember dimMember = new MbgViewListDimensionMember(viewListDim.getNumber(), member.getId().toString(), member.getName(), member.getNumber());
                    viewListDim.getSelectMembers().add(dimMember);
                }
                sheet.getDimensionManager().addDimensionInfo((BgDimensionBaseInfo)viewListDim);
            }
            BgCslClientHelper.addDefaultRows(sheet);
            BgCslClientHelper.addDefaultCols(sheet);
        }
        return sheet;
    }

    private static void addDefaultCols(MbgViewListSheetManager sheet) {
        HashMap<String, MbgViewListDimensionInfo> dimensionMap = new HashMap<String, MbgViewListDimensionInfo>();
        List dimensions = sheet.getDimensionManager().getDimension();
        for (int i = 0; i < dimensions.size(); ++i) {
            dimensionMap.put(((MbgViewListDimensionInfo)dimensions.get(i)).getNumber(), (MbgViewListDimensionInfo)dimensions.get(i));
        }
        MbgViewListDimensionInfo bgPeriodDim = new MbgViewListDimensionInfo(sheet.getDimensionManager());
        ((MbgViewListDimensionInfo)dimensionMap.get(DimensionConstants.DEF_PERIOD_NUMBER)).cloneValue((BgDimensionBaseInfo)bgPeriodDim);
        bgPeriodDim.setLayout("col");
        bgPeriodDim.setMemberValueType(DimensionMemberValueModeEnum.SelectMember);
        MbgViewListRowCol rowCol = new MbgViewListRowCol();
        rowCol.getDimensions().add(bgPeriodDim);
        sheet.getDimensionManager().getColumns().add(rowCol);
    }

    private static void addDefaultRows(MbgViewListSheetManager sheet) {
        HashMap<String, MbgViewListDimensionInfo> dimensionMap = new HashMap<String, MbgViewListDimensionInfo>();
        List dimensions = sheet.getDimensionManager().getDimension();
        for (int i = 0; i < dimensions.size(); ++i) {
            dimensionMap.put(((MbgViewListDimensionInfo)dimensions.get(i)).getNumber(), (MbgViewListDimensionInfo)dimensions.get(i));
        }
        MbgViewListDimensionInfo bgAccountDim = new MbgViewListDimensionInfo(sheet.getDimensionManager());
        ((MbgViewListDimensionInfo)dimensionMap.get(DimensionConstants.DEF_ACCOUNT_NUMBER)).cloneValue((BgDimensionBaseInfo)bgAccountDim);
        bgAccountDim.setLayout("row");
        bgAccountDim.setMemberValueType(DimensionMemberValueModeEnum.SelectMember);
        MbgViewListRowCol rowCol = new MbgViewListRowCol();
        rowCol.getDimensions().add(bgAccountDim);
        sheet.getDimensionManager().getRows().add(rowCol);
    }

    public static SelectorItemCollection getCslAdjTemplateSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("formType"));
        sic.add(new SelectorItemInfo("bgType.*"));
        sic.add(new SelectorItemInfo("bgScheme.*"));
        sic.add(new SelectorItemInfo("orgTree.*"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        sic.add(new SelectorItemInfo("sheetParam.*"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.bgElement.id"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.*"));
        sic.add(new SelectorItemInfo("defaultMeasureUnit.*"));
        sic.add(new SelectorItemInfo("bgSpecialItems.*"));
        return sic;
    }

    public static String getProcessUI(String id, int formType) {
        String bosType = BOSUuid.getBOSObjectType((String)id, (boolean)false).toString();
        if ("655ADD42".equals(bosType)) {
            return BgCslClientHelper.getBgCslFormProcessUIName(formType);
        }
        if ("AD34C4CD".equals(bosType)) {
            return BgCslAdjFormProcessUI.class.getName();
        }
        if ("9E7BD5E2".equals(bosType)) {
            return MbgWorkPaperProcessUI.class.getName();
        }
        return null;
    }

    public static Map<String, Set<String>> addClsFilter(Map<String, Set<String>> filterMap, Set<String> canAddNumbers) {
        if (filterMap == null) {
            filterMap = new HashMap<String, Set<String>>();
        }
        if (!filterMap.containsKey(DimensionConstants.DEF_CSL_SRCNUMBER)) {
            filterMap.put(DimensionConstants.DEF_CSL_SRCNUMBER, new HashSet<String>(canAddNumbers));
        } else {
            Set<String> filterSet = filterMap.get(DimensionConstants.DEF_CSL_SRCNUMBER);
            if (filterSet == null) {
                filterSet = new HashSet<String>();
                filterMap.put(DimensionConstants.DEF_CSL_SRCNUMBER, filterSet);
            }
            if (filterSet.isEmpty()) {
                filterSet.addAll(canAddNumbers);
            } else {
                filterSet.retainAll(canAddNumbers);
            }
        }
        return filterMap;
    }

    public static Map<String, Set<String>> addClsAdjFilter(Map<String, Set<String>> filterMap) {
        return BgCslClientHelper.addClsFilter(filterMap, BgCslDimConstants.canEditCslAjdNumberSet);
    }

    public static Set<String> getOrgIds(String userId, String orgTreeId) {
        CoreBaseCollection colls = BgCslClientHelper.getOrgs(userId, orgTreeId);
        HashSet<String> ids = new HashSet<String>();
        if (colls != null && !colls.isEmpty()) {
            for (int i = 0; i < colls.size(); ++i) {
                ids.add(colls.get(i).getId().toString());
            }
        }
        return ids;
    }

    public static CoreBaseCollection getOrgs(String userId, String orgTreeId) {
        CoreBaseCollection coll = new CoreBaseCollection();
        try {
            StringBuffer sqlBuf = new StringBuffer();
            sqlBuf.append("SELECT unit.FID, unit.FNUMBER, unit.FNAME_L2  FROM T_PM_USER u ").append(" join " + BgCommNHelper.getOrgRangeTable(null) + " range on range.FUSERID = u.FID ").append(" join T_ORG_Structure structure on structure.FUNITID = range.FORGID ").append(" join T_ORG_TREE tree on tree.FID = structure.FTREEID ").append(" join T_ORG_BaseUnit unit on unit.FID = range.FORGID  ").append(" where u.FID = '").append(userId).append("' ").append(" and tree.FISFORBUDGET = 1 ").append(" and unit.FISUNION = 1 ").append(" and tree.FSTARTDATE  is not null ").append(" and tree.FID = '" + orgTreeId + "'");
            ISQLExecutor executor = SQLExecutorFactory.getRemoteInstance((String)sqlBuf.toString());
            IRowSet rowSet = executor.executeSQL();
            OrgUnitInfo orgInfo = null;
            while (rowSet.next()) {
                String id = rowSet.getString("FID");
                String number = rowSet.getString("FNUMBER");
                String name = rowSet.getString("FNAME_L2");
                orgInfo = new OrgUnitInfo();
                orgInfo.setId(BOSUuid.read((String)id));
                orgInfo.setNumber(number);
                orgInfo.setName(name);
                coll.add((CoreBaseInfo)orgInfo);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return coll;
    }

    public static IMetaDataPK getActionPK(ItemAction action) {
        assert (action != null);
        String actionName = action.getActionName();
        if (StringUtils.isEmpty((String)actionName) && (actionName = action.getClass().getName()).indexOf("$") >= 0) {
            actionName = actionName.substring(actionName.indexOf("$") + 1);
        }
        return new MetaDataPK(actionName);
    }

    public static IObjectPK getOrgPk(String userId, String orgTreeId, IMetaDataPK uiPK, ItemAction action) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)userId) || StringUtils.isEmpty((String)orgTreeId) || action == null) {
            return null;
        }
        IMetaDataPK actionPK = BgCslClientHelper.getActionPK(action);
        String permItemName = BgFacadeFactory.getRemoteInstance().getPermission(uiPK, actionPK);
        Set<String> orgIds = PermissionFactory.getRemoteInstance().getAuthorizedOrgIds((IObjectPK)new ObjectUuidPK(userId), OrgType.UnionDebt, (IObjectPK)new ObjectUuidPK(orgTreeId), permItemName);
        if (orgIds != null && !orgIds.isEmpty()) {
            for (String orgID : orgIds) {
                if (!FullOrgUnitFactory.getRemoteInstance().getOrgUnitInfo("select id, isUnion where id = '" + orgID + "'").isIsUnion()) continue;
                return new ObjectUuidPK(orgID);
            }
        } else {
            Iterator<String> ite;
            orgIds = BgCslClientHelper.getOrgIds(userId, orgTreeId);
            if (orgIds != null && !orgIds.isEmpty() && (ite = orgIds.iterator()).hasNext()) {
                return new ObjectUuidPK(ite.next());
            }
        }
        return null;
    }

    public static IObjectPK getOrgPk(String orgTreeId, IMetaDataPK uiPK, ItemAction action) throws EASBizException, BOSException {
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        return BgCslClientHelper.getOrgPk(userId, orgTreeId, uiPK, action);
    }
}

