/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.digitalstyle.Formats;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fi.newrpt.client.designer.IDisplayValueProvider;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.utils.BgElementHelper;
import com.kingdee.eas.ma.bgcsl.client.utils.IBgCslDisplayHelper;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgCslDisplayValueProvider
implements IDisplayValueProvider {
    private static final Logger logger = Logger.getLogger(BgCslDisplayValueProvider.class);
    protected IBgCslDisplayHelper ownerUI = null;
    private Map measureUnitMap = null;
    private Map currencyMap = null;
    private Map formulaMap = null;
    private BigDecimal coefficient = null;
    private int precision = -1;
    private int displayMode = 0;
    private Map<String, BgElementInfo> elementObjMap = null;

    public int getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(int displayMode) {
        this.displayMode = displayMode;
    }

    private BgCslDisplayValueProvider() {
    }

    public BgCslDisplayValueProvider(IBgCslDisplayHelper ownerUI) {
        this.ownerUI = ownerUI;
    }

    public IBgCslDisplayHelper getOwnerUI() {
        return this.ownerUI;
    }

    public BigDecimal getCoefficient() {
        if (this.coefficient != null) {
            return this.coefficient;
        }
        this.coefficient = this.getOwnerUI() != null && this.getOwnerUI().getMeasureUnit() != null ? this.getOwnerUI().getMeasureUnit().getCoefficient() : BgNConstants.ONE;
        return this.coefficient;
    }

    public int getPrecision() {
        if (this.precision != -1) {
            return this.precision;
        }
        this.precision = this.getOwnerUI() != null && this.getOwnerUI().getCurrency() != null ? this.getOwnerUI().getCurrency().getPrecision() : 3;
        return this.precision;
    }

    public Map getMeasureUnitMap() {
        if (this.measureUnitMap != null) {
            return this.measureUnitMap;
        }
        if (this.getOwnerUI() != null) {
            this.measureUnitMap = this.getOwnerUI().getMeasureUnitMap();
        }
        if (this.measureUnitMap == null) {
            this.measureUnitMap = new HashMap();
        }
        return this.measureUnitMap;
    }

    public Map getCurrencyMap() {
        if (this.currencyMap != null) {
            return this.currencyMap;
        }
        if (this.getOwnerUI() != null) {
            this.currencyMap = this.getOwnerUI().getCurrencyMap();
        }
        if (this.currencyMap == null) {
            this.currencyMap = new HashMap();
        }
        return this.currencyMap;
    }

    public Map getFormulaMap() {
        return this.getOwnerUI().getFormulaMap();
    }

    public Map<String, BgElementInfo> getElementObjMap() {
        if (this.elementObjMap == null) {
            try {
                this.elementObjMap = BgElementHelper.getElementoObjMap();
            }
            catch (BOSException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
        }
        return this.elementObjMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getDisplayValue(Cell cell, int viewMode) {
        if (cell == null) return null;
        String _text = cell.getText();
        Object obj = cell.getValue().getValue();
        if (viewMode == 0) {
            if (BgNFSHelper.checkIsEmptyValue((Cell)cell)) return null;
            if (cell.getValue().getValue() instanceof GregorianCalendar) {
                return cell.getText();
            }
            if (BgNFSHelper.getCellData((Cell)cell, (String)"bgFillType") != null && BgNFSHelper.checkHasTextOfCell((Cell)cell)) {
                return cell.getText();
            }
            if (StringUtils.isEmpty((String)_text)) return null;
            if ("#DIV/0!".equals(_text) || _text.indexOf("#BAD FUNCTION") >= 0) {
                Object obj1 = cell.getSheet().getBook().getUserObjectValue("ERRORHANDLER");
                if (!(obj1 instanceof ReportCalculateErrorProvider)) return _text;
                ReportCalculateErrorProvider rcep = (ReportCalculateErrorProvider)obj1;
                if ("#DIV/0!".equals(_text)) {
                    return rcep.getZeroDivDisplayAs();
                }
                if (_text.indexOf("#BAD FUNCTION") < 0) return _text;
                return rcep.getExceptionReplacer();
            }
            if (BgNFSHelper.checkHasPercentage((Cell)cell)) {
                return cell.getText();
            }
            if (BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) {
                String _formulaStr = BgNFSHelper.getFormulaOfCell((Cell)cell);
                if (!this.getMeasureUnitMap().isEmpty()) return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, true);
                return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, false);
            }
            if (BgNFSHelper.checkHasGatFormulaOfCell((Cell)cell)) {
                String _formulaStr = BgNFSHelper.getGatFormulaOfCell((Cell)cell);
                if (!this.getMeasureUnitMap().isEmpty()) return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, true);
                return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, false);
            }
            if (StringUtils.isEmpty((String)BgNFSHelper.getExpression((Cell)cell)) || BgNFSHelper.getExpression((Cell)cell).toUpperCase().indexOf("MBGRPTDATE") <= 0 && BgNFSHelper.getExpression((Cell)cell).toUpperCase().indexOf("MBGCREATEDATE") <= 0 && BgNFSHelper.getExpression((Cell)cell).toUpperCase().indexOf("RPTDATE") <= 0) return this.getDefMeasureUnitDisplayValue(cell, obj);
            if (obj instanceof String) {
                return _text;
            }
            if (!(obj instanceof BigDecimal)) return null;
            return this.getDefMeasureUnitDisplayValue(cell, obj);
        }
        if (viewMode == 1) {
            if (cell.hasFormula()) {
                return cell.getFormula();
            }
            if (BgNFSHelper.checkIsEmptyValue((Cell)cell) || StringUtils.isEmpty((String)_text)) return null;
            if (!BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) return this.getDefMeasureUnitDisplayValue(cell, obj);
            String _formulaStr = BgNFSHelper.getFormulaOfCell((Cell)cell);
            if (!this.getMeasureUnitMap().isEmpty()) return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, true);
            return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, false);
        }
        if (viewMode != 10) return null;
        if (BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) {
            return BgNFSHelper.getDisplayFormula((String)BgNFSHelper.getFormulaOfCell((Cell)cell), (Map)this.getOwnerUI().getFormulaMap());
        }
        if (BgNFSHelper.checkIsEmptyValue((Cell)cell)) return null;
        return this.getDefMeasureUnitDisplayValue(cell, obj);
    }

    public Object getMeasureUnitDisplayValue(Cell cell, String formulaStr, Object obj, boolean useMeasureUnit) {
        String _formulaStr = null;
        String[] _parameter = null;
        BigDecimal _coefficient = this.getCoefficient();
        int _precision = this.getPrecision();
        CurrencyInfo _currencyInfo = null;
        String cellStyle = cell.getDisplayStyle().getNumberFormat();
        _formulaStr = formulaStr;
        _parameter = BgNFSHelper.parseFormulaPara((Map)this.getFormulaMap(), (String)_formulaStr);
        if (_parameter != null) {
            if (_parameter.length == 6) {
                if (useMeasureUnit && !StringUtils.isEmpty((String)_parameter[2]) && this.getMeasureUnitMap().containsKey(_parameter[2])) {
                    _coefficient = (BigDecimal)this.getMeasureUnitMap().get(_parameter[2]);
                }
                if (!StringUtils.isEmpty((String)_parameter[5]) && this.getCurrencyMap().containsKey(_parameter[5])) {
                    _currencyInfo = (CurrencyInfo)this.getCurrencyMap().get(_parameter[5]);
                    _precision = _currencyInfo.getPrecision();
                }
            } else if (_parameter.length == 4) {
                if (useMeasureUnit && !StringUtils.isEmpty((String)_parameter[2]) && this.getMeasureUnitMap().containsKey(_parameter[2])) {
                    _coefficient = (BigDecimal)this.getMeasureUnitMap().get(_parameter[2]);
                }
                if (!StringUtils.isEmpty((String)_parameter[4]) && this.getCurrencyMap().containsKey(_parameter[4])) {
                    _currencyInfo = (CurrencyInfo)this.getCurrencyMap().get(_parameter[4]);
                    _precision = _currencyInfo.getPrecision();
                }
            }
        }
        return this.getDisplayValue(cellStyle, obj, _coefficient, _precision);
    }

    public Object getMeasureUnitDisplayValue(ICell cell, String formulaStr, Object obj, boolean useMeasureUnit) {
        return this.getMeasureUnitDisplayValue(cell, formulaStr, obj, useMeasureUnit, null);
    }

    public Object getMeasureUnitDisplayValue(ICell cell, String formulaStr, Object obj, boolean useMeasureUnit, String bgAccountNumber) {
        String _formulaStr = null;
        String[] _parameter = null;
        BigDecimal _coefficient = this.getCoefficient();
        int _precision = this.getPrecision();
        CurrencyInfo _currencyInfo = null;
        _formulaStr = formulaStr;
        _parameter = BgNFSHelper.parseFormulaPara((Map)this.getFormulaMap(), (String)_formulaStr);
        if (_parameter != null) {
            if (_parameter.length == 6) {
                BgElementInfo eleInfo;
                if (useMeasureUnit && !StringUtils.isEmpty((String)_parameter[2]) && this.getMeasureUnitMap().containsKey(_parameter[2])) {
                    _coefficient = (BigDecimal)this.getMeasureUnitMap().get(_parameter[2]);
                }
                if (!StringUtils.isEmpty((String)_parameter[2]) && this.getElementObjMap().containsKey(_parameter[2]) && (eleInfo = this.getElementObjMap().get(_parameter[2])).getDataType().getValue() == 3) {
                    _coefficient = BgNConstants.ONE;
                }
                if (!StringUtils.isEmpty((String)_parameter[5]) && this.getCurrencyMap().containsKey(_parameter[5])) {
                    _currencyInfo = (CurrencyInfo)this.getCurrencyMap().get(_parameter[5]);
                    _precision = _currencyInfo.getPrecision();
                }
            } else if (_parameter.length == 4) {
                if (useMeasureUnit && !StringUtils.isEmpty((String)_parameter[2]) && this.getMeasureUnitMap().containsKey(_parameter[2])) {
                    _coefficient = (BigDecimal)this.getMeasureUnitMap().get(_parameter[2]);
                }
                if (!StringUtils.isEmpty((String)_parameter[4]) && this.getCurrencyMap().containsKey(_parameter[4])) {
                    _currencyInfo = (CurrencyInfo)this.getCurrencyMap().get(_parameter[4]);
                    _precision = _currencyInfo.getPrecision();
                }
            }
        }
        return this.getDisplayValue(obj, _coefficient, _precision);
    }

    protected Object getDefMeasureUnitDisplayValue(Cell cell, Object obj) {
        String showStr;
        if (!BgNFSHelper.checkHasNumbericOfCell((Cell)cell) || !BgNFSHelper.checkIsNumericOfCell((Cell)cell)) {
            return cell.getText();
        }
        if ("0".equals(obj.toString()) && (showStr = BgNFSHelper.checkShowStrByNumberic((Cell)cell)) != null) {
            return showStr;
        }
        String cellStyle = cell.getDisplayStyle().getNumberFormat();
        String _text = null;
        int _precision = this.getPrecision();
        try {
            _precision = BgNFSHelper.getDigitOfNumber((Cell)cell, (int)_precision);
            _text = this.getDisplayValue(cellStyle, obj, this.getCoefficient(), _precision);
        }
        catch (Exception ex) {
            _text = obj.toString();
        }
        return _text;
    }

    protected String getDisplayValue(Object obj, BigDecimal coefficient, int precision) {
        String _text = null;
        BigDecimal _value = null;
        DecimalFormat _decFormat = null;
        try {
            _value = BgNationalFormatUIUtil.parseToBigDecimal((Object)obj).divide(coefficient, 8, 4);
            _decFormat = BgNationalFormatUIUtil.getDecimalFormat((int)precision);
            _text = _decFormat.format(_value.doubleValue());
        }
        catch (Exception ex) {
            _text = obj.toString();
        }
        return this.dealUnitWithDispalyMode(_text);
    }

    protected String getDisplayValue(String cellStyle, Object obj, BigDecimal coefficient, int precision) {
        String _text = null;
        BigDecimal _value = null;
        DecimalFormat _decFormat = null;
        Object nf = null;
        try {
            String coefficientStyle = "0\".\"0";
            boolean flag = cellStyle != null && cellStyle.contains(coefficientStyle);
            _value = !flag ? this.dealValueWithDispalyMode(obj, coefficient, precision) : new BigDecimal(obj.toString());
            if (cellStyle != null) {
                try {
                    _text = Formats.getFormat((String)cellStyle).format(new Variant((Object)_value)).toString();
                }
                catch (Exception e) {
                    _decFormat = BgNationalFormatUIUtil.getDecimalFormat((int)precision);
                    _text = _decFormat.format(_value.doubleValue());
                }
            } else {
                _decFormat = precision != 0 ? new DecimalFormat("#,##0." + BgNFSHelper.getNumberFormat((String)"0", (int)precision)) : new DecimalFormat("#,##0");
                _text = _decFormat.format(_value.doubleValue());
            }
        }
        catch (Exception ex) {
            _text = obj.toString();
        }
        _text = this.dealUnitWithDispalyMode(_text);
        return _text;
    }

    protected BigDecimal dealValueWithDispalyMode(Object obj, BigDecimal coefficient, int precision) {
        BigDecimal _value = null;
        switch (this.displayMode) {
            case 1: 
            case 2: {
                _value = new BigDecimal(obj.toString().trim().replaceAll(",", "")).divide(new BigDecimal(1000), precision, 4);
                break;
            }
            case 3: 
            case 4: {
                _value = new BigDecimal(obj.toString().trim().replaceAll(",", "")).divide(new BigDecimal(10000), precision, 4);
                break;
            }
            default: {
                _value = new BigDecimal(obj.toString().trim().replaceAll(",", "")).divide(coefficient, precision, 4);
            }
        }
        return _value;
    }

    protected String dealUnitWithDispalyMode(String _text) {
        String text = null;
        switch (this.displayMode) {
            case 1: {
                String thousand = EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"thousand");
                if (_text.contains(thousand)) break;
                text = _text + "(" + EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"thousand") + ")";
                break;
            }
            case 3: {
                String tenThousand = EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"tenThousand");
                if (_text.contains(tenThousand)) break;
                text = _text + "(" + EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"tenThousand") + ")";
                break;
            }
            default: {
                text = _text;
            }
        }
        return text;
    }
}

