/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client.utils;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import java.util.Iterator;

public class BgCslElimClientHelper {
    public static void removeSorters(EntityViewInfo viewInfo) {
        Iterator iter = viewInfo.getSorter().iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    public static void doAfterFillData(KDTable tblMain, KDTDataRequestEvent e) {
        if (e == null || tblMain.getColumn("bgPeriod.number") == null || !tblMain.getColumn("bgPeriod.number").getStyleAttributes().isHided()) {
            return;
        }
        IRow row = null;
        String pnumber = null;
        String pname = null;
        int in = e.getLastRow();
        for (int i = e.getFirstRow(); i <= in; ++i) {
            row = tblMain.getRow(i);
            pname = (String)row.getCell("bgPeriod.name").getValue();
            pnumber = (String)row.getCell("bgPeriod.number").getValue();
            if (pnumber != null) {
                String prefix = pnumber.substring(0, 4);
                pname = pname + "(" + prefix + ")";
                row.getCell("bgPeriod.number").setValue(null);
                row.getCell("bgPeriod.name").setValue((Object)pname);
            }
            if (row.getCell("entries.indexMemberName") != null && row.getCell("entries.indexMemberName").getValue() != null && row.getCell("entries.indexMemberNumber") != null && row.getCell("entries.indexMemberNumber").getValue() != null) {
                String accountName = (String)row.getCell("entries.indexMemberName").getValue();
                String accountNumber = (String)row.getCell("entries.indexMemberNumber").getValue();
                if (accountNumber.indexOf("Acc:") >= 0) {
                    accountNumber = accountNumber.substring(4, accountNumber.length());
                    row.getCell("entries.indexMemberNumber").setValue(null);
                    row.getCell("entries.indexMemberName").setValue((Object)(accountNumber + "(" + accountName + ")"));
                }
            }
            if (row.getCell("currency.precision") == null) continue;
            int precision = (Integer)row.getCell("currency.precision").getValue();
            BgCslElimClientHelper.doFormatShowByPrecision(row, precision);
        }
    }

    private static void doFormatShowByPrecision(IRow row, int precision) {
        row.getCell("entries.creditAmount").getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getFormatStringForTable((int)precision));
        row.getCell("entries.debitAmount").getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getFormatStringForTable((int)precision));
    }
}

