/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client.utils;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.client.utils.BgNTemplateToHelperFile;
import com.kingdee.eas.ma.mbg.common.MbgViewListXMLParser;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class BgCslTemplateToFileHelper {
    public static final String ENCODING = "UTF-8";
    public static final String DATA_FILE_TYPE = ".data";
    public static final String XML_FILE_TYPE = ".xml";

    public static boolean saveDataToFile(IObjectValue bgTemplateInfo, String fileName) throws IOException {
        File f = new File(fileName);
        if (f.exists()) {
            f.delete();
            f.createNewFile();
        }
        FileOutputStream outPutStream = new FileOutputStream(f);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outPutStream);
        objectOutputStream.writeObject(bgTemplateInfo);
        outPutStream.close();
        objectOutputStream.close();
        BgNTemplateToHelperFile.setFileHidden((File)f);
        return false;
    }

    public static IObjectValue getDataToFile(String fileName) throws IOException, ClassNotFoundException {
        IObjectValue bgTemplateInfo = null;
        FileInputStream freader = new FileInputStream(fileName);
        ObjectInputStream objectInputStream = new ObjectInputStream(freader);
        bgTemplateInfo = (IObjectValue)objectInputStream.readObject();
        objectInputStream.close();
        return bgTemplateInfo;
    }

    public static void saveDimension(byte[] dimensions, String fileName) throws DocumentException, IOException {
        SAXReader reader = new SAXReader();
        Document document = reader.read((InputStream)new ByteArrayInputStream(dimensions));
        FileOutputStream fos = new FileOutputStream(new File(fileName));
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding(ENCODING);
        XMLWriter writer = null;
        writer = new XMLWriter((OutputStream)fos, format);
        writer.write(document);
        writer.close();
        fos.close();
    }

    public static Object loadXmlObject(File file, BgTemFormTypeEnum formType) throws Exception {
        if (BgTemFormTypeEnum.FIXEDFORM.equals((Object)formType) || BgTemFormTypeEnum.SPECIALFORM.equals((Object)formType)) {
            return IOHelper.loadFile((String)file.getAbsolutePath());
        }
        SAXReader reader = new SAXReader();
        FileInputStream fis = new FileInputStream(file);
        Document document = reader.read((InputStream)fis);
        OutputFormat format = OutputFormat.createPrettyPrint();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        format.setEncoding(ENCODING);
        XMLWriter writer = null;
        writer = new XMLWriter((OutputStream)bos, format);
        writer.write(document);
        writer.close();
        fis.close();
        bos.close();
        byte[] datas = bos.toByteArray();
        if (datas == null) {
            return null;
        }
        if (BgTemFormTypeEnum.VIEWFORM.equals((Object)datas)) {
            return new MbgXMLParser().parse(datas);
        }
        return new MbgViewListXMLParser().parse(datas);
    }
}

