/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.excel;

import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.eas.ma.bgcsl.excel.ExcelClientHelper;
import com.kingdee.eas.ma.bgcsl.excel.ExcelServerManager;
import com.kingdee.eas.ma.bgcsl.excel.handler.ExcelHandlerServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ExcelClient
implements Runnable {
    private static final Logger logger = Logger.getLogger(ExcelClient.class);
    private static String encoding = "UTF-8";
    private static ServerSocket ss = null;

    public ExcelClient() throws IOException {
        if (ss == null) {
            ss = ExcelServerManager.getServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Socket s = null;
        InputStream is = null;
        OutputStream os = null;
        OutputStreamWriter osw = null;
        RequestInfo requestInfo = null;
        try {
            boolean flag = true;
            while (flag) {
                s = ss.accept();
                is = s.getInputStream();
                os = s.getOutputStream();
                osw = new OutputStreamWriter(os, encoding);
                requestInfo = this.readRequestInfo(is);
                String method = requestInfo.getMethod();
                String sessionId = requestInfo.getSessionId();
                if ("initSheet".equals(method)) {
                    ExcelServerManager.addExcelClient(sessionId);
                    if (!ExcelServerManager.getExcelClientPool().contains(sessionId)) {
                        logger.info((Object)("[\u6253\u5f00Excel\u5ba2\u6237\u7aef \u2014\u2014sessionId:" + sessionId + "]"));
                    }
                }
                Object result = "";
                if (ExcelServerManager.getExcelClientPool().contains(sessionId)) {
                    logger.info((Object)("[\u5f00\u59cb\u8fde\u63a5\u4f1a\u8bdd \u2014\u2014sessionId:" + sessionId + "] method:" + method));
                    long ct1 = System.currentTimeMillis();
                    result = this.callBusinessMethod(requestInfo);
                    logger.info((Object)("*****************callBusinessMethod method: " + method + "  use: " + (System.currentTimeMillis() - ct1) + "ms"));
                    logger.info((Object)("[\u7ed3\u675f\u8fde\u63a5\u4f1a\u8bdd \u2014\u2014sessionId:" + sessionId + "] method:" + method));
                }
                osw.write(result.toString());
                osw.flush();
                osw.close();
                os.close();
                is.close();
                s.close();
                if (!"clearSession".equals(method)) continue;
                ExcelServerManager.removeExcelClient(sessionId);
                logger.info((Object)("[\u5173\u95edExcel\u5ba2\u6237\u7aef \u2014\u2014sessionId:" + sessionId + "]"));
            }
            ExcelClientHelper.setStarted(false);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (osw != null) {
                    osw.close();
                }
                if (os != null) {
                    os.close();
                }
                if (is != null) {
                    is.close();
                }
                if (s != null) {
                    s.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            ExcelClientHelper.setStarted(false);
        }
    }

    private Object callBusinessMethod(RequestInfo requestInfo) {
        StringBuffer result = new StringBuffer();
        if (requestInfo == null) {
            return null;
        }
        String method = requestInfo.getMethod();
        String params = requestInfo.getParams();
        try {
            Class<ExcelHandlerServer> clzz = ExcelHandlerServer.class;
            Object instant = clzz.newInstance();
            Method m = clzz.getDeclaredMethod(method, String.class);
            result.append(m.invoke(instant, params));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            result.append(e);
        }
        return result;
    }

    private RequestInfo readRequestInfo(InputStream is) throws Exception {
        RequestInfo info = new RequestInfo();
        String line = "";
        int lineNumber = 0;
        String url = "";
        String methodType = "";
        String method = "";
        int contentLength = 0;
        String data = "";
        String sessionId = "";
        do {
            line = ExcelClient.readLine(is, 0);
            if (lineNumber == 0) {
                methodType = line.startsWith("POST") ? "POST" : "GET";
            }
            if (line.startsWith("Content-Length")) {
                contentLength = Integer.parseInt(line.split(":")[1].trim());
            }
            if (line.startsWith("POST")) {
                url = line.split(" ")[1];
                method = url.substring(url.indexOf("=") + 1, url.length());
            }
            if (line.startsWith("sessionid") || line.startsWith("sessionId")) {
                sessionId = line.split(":")[1].trim();
            }
            ++lineNumber;
        } while (!line.equals("\r\n"));
        if ("POST".equals(methodType) && contentLength > 0) {
            data = ExcelClient.readLine(is, contentLength);
        }
        info.setContentLength(contentLength);
        info.setMethod(method);
        info.setParams(this.getParamsFromData(data));
        info.setMethodType(methodType);
        info.setUrl(url);
        info.setData(data);
        info.setSessionId(sessionId);
        return info;
    }

    private String getParamsFromData(String data) {
        if (StringUtils.isEmpty((String)data)) {
            return "";
        }
        return data;
    }

    private static String readLine(InputStream is, int contentLenght) throws IOException {
        byte readByte;
        ArrayList<Byte> lineByteList = new ArrayList<Byte>();
        int total = 0;
        if (contentLenght != 0) {
            do {
                readByte = (byte)is.read();
                lineByteList.add(readByte);
            } while (++total < contentLenght);
        } else {
            do {
                readByte = (byte)is.read();
                lineByteList.add(readByte);
            } while (readByte != 10);
        }
        byte[] tmpByteArr = new byte[lineByteList.size()];
        for (int i = 0; i < lineByteList.size(); ++i) {
            tmpByteArr[i] = (Byte)lineByteList.get(i);
        }
        lineByteList.clear();
        return new String(tmpByteArr, encoding);
    }

    public static void main(String[] args) throws Exception {
    }

    class RequestInfo {
        private String methodType;
        private String url;
        private String data;
        private int contentLength;
        private String method;
        private String params;
        private String sessionId;

        RequestInfo() {
        }

        public String getMethodType() {
            return this.methodType;
        }

        public void setMethodType(String methodType) {
            this.methodType = methodType;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }

        public int getContentLength() {
            return this.contentLength;
        }

        public void setContentLength(int contentLength) {
            this.contentLength = contentLength;
        }

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public String getParams() {
            return this.params;
        }

        public void setParams(String params) {
            this.params = params;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }
    }
}

