/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.excel.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.bgcsl.BgCslAdjFormFactory;
import com.kingdee.eas.ma.bgcsl.BgCslAdjFormInfo;
import com.kingdee.eas.ma.bgcsl.common.BgCslFormHelper;
import com.kingdee.eas.ma.bgcsl.excel.budget.BgExcelHelper;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.utils.BgCommentCommonHelper;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgNPeriodNameHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import java.util.Map;
import org.apache.log4j.Logger;

public class CslAdjHelper {
    public static ReportBaseInfo getReportInfoById(String reportId) throws Exception {
        BgCslAdjFormInfo reportInfo = null;
        if (BOSUuid.read((String)reportId).getType().equals((Object)new BgCslAdjFormInfo().getBOSType())) {
            reportInfo = BgCslAdjFormFactory.getRemoteInstance().getBgCslAdjFormInfo((IObjectPK)new ObjectStringPK(reportId), CslAdjHelper.getSelector());
            Book book = reportInfo.getBook();
            Map dataMap = BgCslAdjFormFactory.getRemoteInstance().getBgDataInfo(reportInfo, (IMbgViewBase)CslAdjHelper.getFormView(reportInfo));
            CslAdjHelper.reFillValue(reportInfo, book, dataMap);
            reportInfo.setBook(book);
        }
        return reportInfo;
    }

    public static SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("state");
        sic.add("data");
        sic.add("dimensionData");
        sic.add("sourceType");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.number");
        sic.add("bgPeriod.name");
        sic.add("bgPeriod.periodType");
        sic.add("bgVersion.id");
        sic.add("bgVersion.number");
        sic.add("bgVersion.name");
        sic.add("bgVersion.versionId");
        sic.add("bgScheme.id");
        sic.add("bgScheme.number");
        sic.add("bgScheme.name");
        sic.add("bgScheme.dateFrom");
        sic.add("bgScheme.dateTo");
        sic.add("bgScheme.orgUnit.id");
        sic.add("bgScheme.orgUnit.number");
        sic.add("bgScheme.orgUnit.name");
        sic.add("bgCslTemplate.id");
        sic.add("bgCslTemplate.number");
        sic.add("bgCslTemplate.name");
        sic.add("bgCslTemplate.formType");
        sic.add("orgTree.id");
        sic.add("orgUnit.id");
        sic.add("orgUnit.number");
        sic.add("orgUnit.name");
        sic.add("currency.id");
        sic.add("currency.number");
        sic.add("currency.precision");
        sic.add("currency.name");
        return sic;
    }

    public static Book getBook(ReportBaseInfo reportInfo, CoreUI ownerUI) throws Exception {
        Book book = null;
        if (reportInfo instanceof BgCslAdjFormInfo) {
            BgCslAdjFormInfo adjFormInfo = (BgCslAdjFormInfo)reportInfo;
            book = CslAdjHelper.getBgCslAdjForm(adjFormInfo);
        }
        return book;
    }

    private static Book getBgCslAdjForm(BgCslAdjFormInfo bgFormInfo) throws Exception {
        Book book = bgFormInfo.getBook();
        if (bgFormInfo.getBgScheme() != null) {
            Map dataMap = BgCslAdjFormFactory.getRemoteInstance().getBgDataInfo(bgFormInfo, (IMbgViewBase)CslAdjHelper.getFormView(bgFormInfo));
            CslAdjHelper.reFillValue(bgFormInfo, book, dataMap);
        }
        return book;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reFillValue(BgCslAdjFormInfo bgFormInfo, Book book, Map dataMap) throws EASBizException, BOSException {
        BgNFSHelper.disableUndo((Book)book);
        BgNFSHelper.disableCal((Book)book);
        if (dataMap != null && dataMap.containsKey(bgFormInfo.getOrgUnit().getId().toString())) {
            dataMap = (Map)dataMap.get(bgFormInfo.getOrgUnit().getId().toString());
        }
        try {
            for (int s = 0; s < book.getSheetCount(); ++s) {
                Sheet sheet = book.getSheet(s);
                for (int r = 0; r <= sheet.getMaxRowIndex(); ++r) {
                    for (int c = 0; c <= sheet.getMaxColIndex(); ++c) {
                        Cell cell = sheet.getCell(r, c, true);
                        if (BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) {
                            String _tmpStr = BgNFSHelper.getFormulaOfCell((Cell)cell);
                            BgNDataInfo _bgData = CslAdjHelper.getDimData(bgFormInfo, dataMap, _tmpStr);
                            if (_bgData != null) {
                                if (_bgData.getBizActual() != BgNConstants.ZERO) {
                                    BgNFSHelper.setValue((Cell)cell, (Object)_bgData.getBizActual());
                                    continue;
                                }
                                BgNFSHelper.setValue((Cell)cell, (Object)_bgData.getBudgetValue());
                                continue;
                            }
                            BgNFSHelper.setValue((Cell)cell, null);
                            continue;
                        }
                        if (cell == null || !BgExcelHelper.checkCellText(cell).booleanValue()) continue;
                        BgExcelHelper.setCellTextFormat(cell);
                    }
                }
            }
        }
        finally {
            BgNFSHelper.enableCal((Book)book);
            BgNFSHelper.enableUndo((Book)book);
        }
        try {
            if (bgFormInfo.getBgScheme() != null) {
                BgCommentCommonHelper.fillBgComments(null, (Book)book, (IDimDataQuery)bgFormInfo, (String)CslAdjHelper.getBgSchemeDimensionHelper(bgFormInfo).getBgOrgViewId().toString(), (IMbgViewBase)CslAdjHelper.getFormView(bgFormInfo));
            }
        }
        catch (Exception e) {
            Logger.getLogger(CslAdjHelper.class).error((Object)"", (Throwable)e);
        }
    }

    private static BgNDataInfo getDimData(BgCslAdjFormInfo bgFormInfo, Map dataMap, String formulaStr) {
        String key = formulaStr + "_" + bgFormInfo.getBgVersion().getNumber();
        if (dataMap.containsKey(key)) {
            return (BgNDataInfo)dataMap.get(key);
        }
        return null;
    }

    private static IMbgViewManager getFormView(BgCslAdjFormInfo bgFormInfo) throws Exception {
        if (bgFormInfo.getBgScheme() == null) {
            return null;
        }
        BgSchemeDimensionHelper schemeHelper = CslAdjHelper.getBgSchemeDimensionHelper(bgFormInfo);
        return BgCslFormHelper.getFormView(null, bgFormInfo, schemeHelper);
    }

    private static BgSchemeDimensionHelper getBgSchemeDimensionHelper(BgCslAdjFormInfo bgFormInfo) throws EASBizException, BOSException {
        if (bgFormInfo.getBgScheme() == null) {
            return null;
        }
        return new BgSchemeDimensionHelper(bgFormInfo.getBgScheme().getId().toString());
    }

    public static void convertPeriod(BgCslAdjFormInfo info, Book book) throws Exception {
        if (book == null || info == null || info.getBgPeriod() == null || info.getBgPeriod().getNumber() == null || info.getBgPeriod().getPeriodType() == null) {
            return;
        }
        BgNPeriodNameHelper bgNPeriodNameHelper = new BgNPeriodNameHelper();
        bgNPeriodNameHelper.setBgFormPeriodNumber(info.getBgPeriod().getNumber());
        bgNPeriodNameHelper.setBgFormPeriodType(info.getBgPeriod().getPeriodType().getValue());
        Sheet sheet = null;
        Cell cell = null;
        int rowCount = 0;
        int colCount = 0;
        int rowIndex = 0;
        int colIndex = 0;
        int sheetSize = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            sheet = book.getSheet(sheetIndex);
            rowCount = sheet.getMaxRowIndex();
            colCount = sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    cell = sheet.getCell(rowIndex, colIndex, false);
                    if (cell == null) continue;
                    bgNPeriodNameHelper.addCell(cell);
                }
            }
        }
        bgNPeriodNameHelper.end();
    }

    public static void convertPeriod(BgCslAdjFormInfo info, Sheet sheet) throws Exception {
        if (sheet == null || info == null || info.getBgPeriod() == null || info.getBgPeriod().getNumber() == null || info.getBgPeriod().getPeriodType() == null) {
            return;
        }
        BgNPeriodNameHelper bgNPeriodNameHelper = new BgNPeriodNameHelper();
        bgNPeriodNameHelper.setBgFormPeriodNumber(info.getBgPeriod().getNumber());
        bgNPeriodNameHelper.setBgFormPeriodType(info.getBgPeriod().getPeriodType().getValue());
        Cell cell = null;
        int rowCount = 0;
        int colCount = 0;
        int rowIndex = 0;
        int colIndex = 0;
        rowCount = sheet.getMaxRowIndex();
        colCount = sheet.getMaxColIndex();
        for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
            for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                cell = sheet.getCell(rowIndex, colIndex, false);
                if (cell == null) continue;
                bgNPeriodNameHelper.addCell(cell);
            }
        }
        bgNPeriodNameHelper.end();
    }
}

