/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.excel.handler;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Password;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.ma.bgcsl.excel.ExcelConstants;
import com.kingdee.eas.ma.bgcsl.excel.excel.BookInfo;
import com.kingdee.eas.ma.bgcsl.excel.excel.SheetInfo;
import com.kingdee.eas.ma.bgcsl.excel.handler.IExcelHandler;
import com.kingdee.eas.ma.bgcsl.excel.json.JSONUtils;
import com.kingdee.eas.ma.bgcsl.excel.utils.ExcelUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ExcelHandlerServer
implements IExcelHandler {
    private static final Logger logger = Logger.getLogger(ExcelHandlerServer.class);
    private static final String SUCCESS = "SUCCESS";
    private static final String FAIL = "FAIL";

    @Override
    public String clearSession(String json) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                String tempDir;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                File f = null;
                f = new File(ExcelConstants.EXCEL_EXPORT_PATH);
                if (f.isDirectory()) {
                    File[] fs;
                    for (File temp : fs = f.listFiles()) {
                        if (!temp.isFile()) continue;
                        try {
                            temp.delete();
                            logger.info((Object)("[\u5220\u9664Excel\u4e34\u65f6\u6587\u4ef6\u6210\u529f]\uff1a" + temp.getName()));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if ((f = new File(tempDir = System.getProperty("java.io.tmpdir"))).isDirectory()) {
                    File[] fs;
                    for (File temp : fs = f.listFiles()) {
                        String tempName;
                        if (!temp.isFile() || !(tempName = temp.getName()).startsWith("tmp") || !tempName.endsWith(".xlsx") && !tempName.endsWith(".xml")) continue;
                        temp.delete();
                    }
                }
            }
        };
        new Thread(r).start();
        return EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"endSession");
    }

    public String addAttachment(String json) {
        AttachmentClientManager manager = new AttachmentClientManager();
        String boID = "";
        File file = new File("");
        try {
            manager.addNewAttachment(boID, file);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return "";
    }

    @Override
    public String initBookProperty(String json) {
        return EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"initBook");
    }

    public String test(String json) {
        return EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"testSuccess");
    }

    public String addnewRpt(String json) {
        return EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"addSuccess");
    }

    @Override
    public String saveRpt(String json) {
        if (json == null) {
            return null;
        }
        logger.error((Object)("saveRpt json:" + json));
        ExcelUtil.SaveRptResult resultInfo = null;
        try {
            resultInfo = new ExcelUtil().saveRpt(json);
            return JSONUtils.convertObjectToJson(resultInfo);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            if (resultInfo != null) {
                resultInfo.setResult(FAIL);
                resultInfo.setMsg(ExcelConstants.MSG_SAVE_FAIL);
            }
            return JSONUtils.convertObjectToJson(resultInfo);
        }
    }

    private void refreshSheet(Book rptBook, BookInfo clientBook) {
        int i;
        ArrayList<String> idList = new ArrayList<String>();
        for (int i2 = 0; i2 < clientBook.getSheets().length; ++i2) {
            String sheetId = clientBook.getSheets()[i2].getId();
            String sheetName = clientBook.getSheets()[i2].getSheetName();
            if (StringUtils.isEmpty((String)sheetId)) {
                rptBook.insertSheet(i2, new Sheet(rptBook, sheetName));
                sheetId = sheetName;
            } else {
                Sheet sheet = rptBook.getSheetByID(sheetId);
                sheet.setName(sheetName);
            }
            idList.add(sheetId);
        }
        ArrayList<String> removeList = new ArrayList<String>();
        String tempId = "";
        int j = rptBook.getSheetCount();
        for (i = 0; i < j; ++i) {
            tempId = rptBook.getSheet(i).getID();
            if (idList.contains(tempId)) continue;
            removeList.add(tempId);
        }
        for (i = 0; i < removeList.size(); ++i) {
            rptBook.removeSheet(rptBook.getSheetByID((String)removeList.get(i)));
        }
    }

    @Override
    public String initSheet(String json) {
        String result = "";
        try {
            return JSONUtils.convertObjectToJson(new ExcelUtil().initSheet(json));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return result;
        }
    }

    public String calcCurSheet(String json) {
        String result = "";
        try {
            if (json != null) {
                SheetInfo resultSheet = new ExcelUtil().calcSheet(json, false);
                result = JSONUtils.convertObjectToJson(resultSheet);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            result = "{\"errorMsg\":\"" + e.getMessage() + "\"}";
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(Integer.toBinaryString(-4098));
    }

    @Override
    public String getMD5String(String password) {
        Password pw = new Password();
        pw.setPassword(password);
        return pw.getEncryptedPassword();
    }

    public String dataCheckAll(String json) {
        if (json == null) {
            return null;
        }
        String result = null;
        try {
            result = new ExcelUtil().checkAll(json);
            result = StringUtils.isEmpty((String)result) ? "{'result':'SUCCESS','msg':'" + RptUtil.getResourceSince51((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"380_CslRptUIUtil") + "'}" : "{'result':'FAIL','msg':'" + result + "'}";
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            result = "{'result':'FAIL','msg':'" + e.getMessage() + "'}";
        }
        return result;
    }
}

