/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.excel.utils;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.ComThread;
import com.jacob.com.Dispatch;
import com.jacob.com.Variant;
import com.kingdee.eas.ma.bgcsl.excel.utils.ExcelUtil;
import java.io.File;
import java.util.Map;
import org.apache.log4j.Logger;

public class ExcelJacobUtil {
    private static final Logger logger = Logger.getLogger(ExcelJacobUtil.class);

    public static void main(String[] args) throws Exception {
        System.out.println(System.getProperty("user.name"));
    }

    public static boolean openExcel(String fileName, Map<String, String> props) {
        String easHome = System.getProperty("EAS_HOME");
        String filePath = easHome + File.separatorChar + "client" + File.separatorChar + "deploy" + File.separatorChar + "client";
        if (ExcelJacobUtil.shouldLoad32Bit()) {
            System.setProperty("jacob.dll.path", filePath + File.separatorChar + "win32" + File.separatorChar + "jacob.dll");
        } else {
            System.setProperty("jacob.dll.path", filePath + File.separatorChar + "win64" + File.separatorChar + "jacob.dll");
        }
        return ExcelJacobUtil.open(fileName, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean open(String fileName, Map<String, String> props) {
        ComThread.InitSTA();
        ActiveXComponent excel = null;
        try {
            excel = new ActiveXComponent("Excel.Application");
            excel.setProperty("Visible", new Variant(true));
            Dispatch workbooks = excel.getProperty("Workbooks").toDispatch();
            Dispatch workbook = Dispatch.call((Dispatch)workbooks, (String)"Open", (Object[])new Object[]{fileName}).toDispatch();
            Dispatch custDocprops = Dispatch.get((Dispatch)workbook, (String)"CustomDocumentProperties").toDispatch();
            for (String name : props.keySet()) {
                String value = props.get(name);
                Dispatch.call((Dispatch)custDocprops, (String)"Add", (Object[])new Object[]{name, new Variant(false), new Variant(4), value});
            }
            Dispatch.call((Dispatch)workbooks, (String)"Open", (Object[])new Object[]{ExcelUtil.getExcelDir() + "\\EAS_AddIn.xlam"}).toDispatch();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            excel.invoke("Quit", new Variant[0]);
            boolean bl = false;
            return bl;
        }
        finally {
            ComThread.Release();
        }
    }

    private void openExcelByJava(String canPathName) throws Exception {
    }

    public static boolean shouldLoad32Bit() {
        String bits = System.getProperty("sun.arch.data.model", "?");
        if (bits.equals("32")) {
            return true;
        }
        if (bits.equals("64")) {
            return false;
        }
        String arch = System.getProperty("java.vm.name", "?");
        return arch.toLowerCase().indexOf("64-bit") < 0;
    }
}

