/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.excel.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.io.table.KdfToBook;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupFactory;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroup;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.MaintainYearInitDataFacadeFactory;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.ReportCalculateContext;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class RptCalculate {
    protected static final Logger logger = Logger.getLogger(RptCalculate.class);
    private OrgUnitInfo company = null;

    public RptCalculate(ReportBaseInfo rptInfo) {
        this.company = rptInfo.getCompany();
    }

    public Book interOrExchFillCompanyAndCalc(ReportBaseInfo reportInfo, boolean isCslrpt, boolean isFill) throws Exception {
        Book book = this.prepareCalculate(reportInfo, isCslrpt);
        boolean isAutoCalculate = book.isAutoCalculate();
        book.getUndoManager().enable(false);
        book.setAutoCalculate(false);
        String currCompanyId = reportInfo.getCompany().getId().toString();
        Sheet sheet = null;
        if (isFill) {
            logger.info((Object)("start fill company:" + reportInfo.getId()));
            for (int i = 0; i < book.getSheetCount(); ++i) {
                sheet = book.getSheet(i);
                this.autoFillCompany(book, sheet, currCompanyId);
            }
        }
        if (book.getUndoManager().isEnable()) {
            book.getUndoManager().enable(false);
        }
        logger.info((Object)"start report Calculate!");
        book = this.calcCslrptOrRpt(reportInfo, isCslrpt, book);
        book.setAutoCalculate(isAutoCalculate);
        book.getUndoManager().enable(true);
        return book;
    }

    private Book calcCslrptOrRpt(ReportBaseInfo reportInfo, boolean isCslrpt, Book book) throws Exception {
        if (isCslrpt && (reportInfo.getSourceType() == RptSrcTypeEnum.NORMAL || reportInfo.getSourceType() == RptSrcTypeEnum.DYNAMICNORMALREPORT || reportInfo.getSourceType() == RptSrcTypeEnum.COMMITREPORT) && ((CslReportInfo)reportInfo).getAdjustStatus().getValue() != 1) {
            this.fillYearInitData(reportInfo.getId().toString(), book);
        }
        this.calcBook(book, reportInfo);
        return book;
    }

    public Book prepareCalculate(ReportBaseInfo reportInfo, boolean isCslrpt) throws Exception {
        Book book = null;
        book = isCslrpt ? this.prepareCalculate((CslReportInfo)reportInfo) : this.prepareCalculate((IObjectValue)reportInfo, null, reportInfo.getBook(), null);
        return book;
    }

    private void updateCslRptOrRpt(ReportBaseInfo reportInfo, boolean isCslrpt) throws BOSException, EASBizException {
        if (isCslrpt) {
            CslReportFactory.getRemoteInstance().update((IObjectPK)new ObjectUuidPK(reportInfo.getId()), (CoreBaseInfo)reportInfo);
        } else {
            ReportFactory.getRemoteInstance().update((IObjectPK)new ObjectUuidPK(reportInfo.getId()), (CoreBaseInfo)reportInfo);
        }
    }

    private Book prepareCalculate(IObjectValue reportInfo, KDF kdf, Book book, int[] index) throws Exception {
        if (book == null) {
            book = Book.Manager.getNewBook(null, (int)0);
        }
        BookProperties p = BookProperties.loadFromBook((Book)book);
        ReportCalculateContext calcContext = new ReportCalculateContext(null);
        if (reportInfo instanceof ReportInfo) {
            ReportInfo report = (ReportInfo)reportInfo;
            if (report.getPeriodType() == null) {
                report.setPeriodType(RptPeriodTypeEnum.MONTHLY);
            }
            ReportCalculateErrorProvider errorhandler = null;
            errorhandler = (ReportCalculateErrorProvider)reportInfo.get("RPT_ERRORHANDLER");
            if (errorhandler != null) {
                calcContext.setErrorProvider((IErrorProvider)errorhandler);
            } else {
                calcContext.setErrorProvider((IErrorProvider)p.getErrorProvider());
            }
            BookProperties bookProperties = BookProperties.loadFromBook((Book)book);
            calcContext.setReportVariables(bookProperties.getVariables());
            calcContext.setReportAdapter((IReportPropertyAdapter)new RptReportPropertyAdapter(report));
        }
        FormulaDefinition.registerFormulaToBook((Book)book, (ICalculateContextProvider)calcContext);
        book.getUndoManager().enable(false);
        book.setCalculate(false);
        int ii = 0;
        if (kdf != null) {
            int size = kdf.getAllTable().size();
            this.getBookFromKDF(kdf, book);
            if (index != null) {
                for (ii = 0; ii < size; ++ii) {
                    if (index[ii] >= 0) continue;
                }
            }
        } else {
            List tbls = (List)reportInfo.get("FORMULA_DATA");
            if (tbls != null) {
                List sheetKeys = (List)reportInfo.get("keys");
                List names = (List)tbls.remove(0);
                int size = tbls.size();
                for (ii = 0; kdf == null && ii < size; ++ii) {
                    List tbl;
                    Sheet sheet = book.getSheet((String)names.get(ii));
                    if (sheet == null) {
                        sheet = new Sheet(book, (String)names.get(ii));
                        book.insertSheet(ii, sheet);
                    }
                    if (sheetKeys != null) {
                        sheet.setUserObject("keys", sheetKeys.get(ii));
                    }
                    if (index != null && index[ii] < 0) {
                        sheet.setEnableCalculation(false);
                    }
                    if ((tbl = (List)tbls.get(ii)) == null) continue;
                    for (int j = 0; j < tbl.size(); ++j) {
                        List row = (List)tbl.get(j);
                        Row row2 = sheet.getRow(j, true);
                        if (row == null) continue;
                        for (int k = 0; k < row.size(); ++k) {
                            Cell cell = row2.getCell(k, true);
                            Object obj = row.get(k);
                            if (obj instanceof String) {
                                String s = (String)obj;
                                if (StringUtils.isEmpty((String)s)) continue;
                                cell.setFormula(s);
                                continue;
                            }
                            cell.setValue(new Variant(obj));
                        }
                    }
                }
            }
        }
        book.getUndoManager().enable(false);
        return book;
    }

    private void getBookFromKDF(KDF kdf, Book book) {
        int ii = 0;
        Iterator iter = kdf.getAllTable().iterator();
        int size = kdf.getAllTable().size();
        KDTable[] tbls = new KDTable[size];
        while (iter.hasNext()) {
            KDTable table = (KDTable)iter.next();
            table.getScriptManager().setAutoRun(false);
            table.setFormulaMode(1);
            tbls[ii] = table;
            ++ii;
        }
        new KdfToBook().getBook(book, tbls);
    }

    public OrgUnitInfo getCurrentCU(OrgUnitInfo company) {
        if (company.isIsCU()) {
            return company;
        }
        return company.getCU();
    }

    private void autoFillCompany(Book book, Sheet sheet, String currCompanyId) throws Exception {
        boolean isInterExch = this.isInterOrExchSheet(book, sheet);
        if (!isInterExch) {
            return;
        }
    }

    private void setFilterByNumber(IQueryExecutor exec, String number, String groups) throws Exception {
        EntityViewInfo viewInfo = exec.getObjectView();
        FilterInfo filter = this.getAssistantSubTypeFilterByNumber(number, groups);
        if (viewInfo.getFilter() == null) {
            viewInfo.setFilter(new FilterInfo());
        }
        viewInfo.getFilter().mergeFilter(filter, "AND");
    }

    private FilterInfo getAssistantSubTypeFilterByNumber(String number, String groups) throws Exception {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        if (groups.equals("all")) {
            return filter;
        }
        AcctountAsstItemParser.AccountAsstItem item = TableToolkit.parseAcctItem((String)("1002|001|" + groups + "#"));
        if (item == null) {
            return filter;
        }
        AcctountAsstItemParser.Group[] group = item.asstItems[0].group;
        String mask = null;
        int maskIndex = 0;
        for (int i = 0; group != null && i < group.length; ++i) {
            String endLongNumber;
            String startLongNumber;
            String std = group[i].standardNumber;
            mask = i == 0 ? "(#" + maskIndex++ : mask + " or (#" + maskIndex++;
            if (number.equals("00001")) {
                fic.add(new FilterItemInfo("customerGroupDetails.CustomerGroupStandard.number", (Object)std));
                if (!StringUtils.isEmpty((String)group[i].startNumber) && !StringUtils.isEmpty((String)group[i].endNumber)) {
                    if (group[i].startNumber.equals(group[i].endNumber)) {
                        TreeBaseInfo customerGroup = this.getTreeBaseNodeByNumber(group[i].startNumber, "T_BD_Customer");
                        if (customerGroup != null && !StringUtils.isEmpty((String)customerGroup.getLongNumber())) {
                            fic.add(new FilterItemInfo("customerGroupDetails.customerGroup.longNumber", (Object)customerGroup.getLongNumber()));
                            fic.add(new FilterItemInfo("customerGroupDetails.customerGroup.longNumber", (Object)(customerGroup.getLongNumber() + "!%"), CompareType.LIKE));
                            mask = mask + " and (#" + maskIndex++ + " or #" + maskIndex++ + ")";
                        } else {
                            fic.add(new FilterItemInfo("customerGroupDetails.customerGroup.number", (Object)group[i].startNumber));
                            mask = mask + " and #" + maskIndex++;
                        }
                    } else {
                        TreeBaseInfo customerGroupStart = this.getTreeBaseNodeByNumber(group[i].startNumber, "T_BD_Customer");
                        TreeBaseInfo customerGroupEnd = this.getTreeBaseNodeByNumber(group[i].endNumber, "T_BD_Customer");
                        if (customerGroupStart != null && customerGroupEnd != null && !StringUtils.isEmpty((String)customerGroupStart.getLongNumber()) && !StringUtils.isEmpty((String)customerGroupEnd.getLongNumber())) {
                            startLongNumber = customerGroupStart.getLongNumber();
                            endLongNumber = customerGroupEnd.getLongNumber();
                            fic.add(new FilterItemInfo("customerGroupDetails.customerGroup.longNumber", (Object)startLongNumber, CompareType.GREATER_EQUALS));
                            fic.add(new FilterItemInfo("customerGroupDetails.customerGroup.longNumber", (Object)endLongNumber, CompareType.LESS_EQUALS));
                            fic.add(new FilterItemInfo("customerGroupDetails.customerGroup.longNumber", (Object)(endLongNumber + "!%"), CompareType.LIKE));
                            mask = mask + " and (#" + maskIndex++ + " and #" + maskIndex++ + " or #" + maskIndex++ + ")";
                        } else {
                            fic.add(new FilterItemInfo("customerGroupDetails.customerGroup.number", (Object)group[i].startNumber));
                            fic.add(new FilterItemInfo("customerGroupDetails.customerGroup.number", (Object)group[i].endNumber));
                            mask = mask + " and (#" + maskIndex++ + " and #" + maskIndex++ + ")";
                        }
                    }
                }
            } else if (number.equals("00002")) {
                fic.add(new FilterItemInfo("supplierGroupDetails.SupplierGroupStandard.number", (Object)std));
                if (!StringUtils.isEmpty((String)group[i].startNumber) && !StringUtils.isEmpty((String)group[i].endNumber)) {
                    if (group[i].startNumber.equals(group[i].endNumber)) {
                        TreeBaseInfo supplierGroup = this.getTreeBaseNodeByNumber(group[i].startNumber, "T_BD_Supplier");
                        if (supplierGroup != null && !StringUtils.isEmpty((String)supplierGroup.getLongNumber())) {
                            fic.add(new FilterItemInfo("supplierGroupDetails.supplierGroup.longNumber", (Object)supplierGroup.getLongNumber()));
                            fic.add(new FilterItemInfo("supplierGroupDetails.supplierGroup.longNumber", (Object)(supplierGroup.getLongNumber() + "!%"), CompareType.LIKE));
                            mask = mask + " and (#" + maskIndex++ + " or #" + maskIndex++ + ")";
                        } else {
                            fic.add(new FilterItemInfo("supplierGroupDetails.supplierGroup.number", (Object)group[i].startNumber));
                            mask = mask + " and #" + maskIndex++;
                        }
                    } else {
                        TreeBaseInfo supplierGroupStart = this.getTreeBaseNodeByNumber(group[i].startNumber, "T_BD_Supplier");
                        TreeBaseInfo supplierGroupEnd = this.getTreeBaseNodeByNumber(group[i].endNumber, "T_BD_Supplier");
                        if (supplierGroupStart != null && supplierGroupEnd != null && !StringUtils.isEmpty((String)supplierGroupStart.getLongNumber()) && !StringUtils.isEmpty((String)supplierGroupEnd.getLongNumber())) {
                            startLongNumber = supplierGroupStart.getLongNumber();
                            endLongNumber = supplierGroupEnd.getLongNumber();
                            fic.add(new FilterItemInfo("supplierGroupDetails.supplierGroup.longNumber", (Object)startLongNumber, CompareType.GREATER_EQUALS));
                            fic.add(new FilterItemInfo("supplierGroupDetails.supplierGroup.longNumber", (Object)endLongNumber, CompareType.LESS_EQUALS));
                            fic.add(new FilterItemInfo("supplierGroupDetails.supplierGroup.longNumber", (Object)(endLongNumber + "!%"), CompareType.LIKE));
                            mask = mask + " and (#" + maskIndex++ + " and #" + maskIndex++ + " or #" + maskIndex++ + ")";
                        } else {
                            fic.add(new FilterItemInfo("supplierGroupDetails.supplierGroup.number", (Object)group[i].startNumber, CompareType.GREATER_EQUALS));
                            fic.add(new FilterItemInfo("supplierGroupDetails.supplierGroup.number", (Object)group[i].endNumber, CompareType.LESS_EQUALS));
                            mask = mask + " and (#" + maskIndex++ + " and #" + maskIndex++ + ")";
                        }
                    }
                }
            } else if (number.equals("00006")) {
                fic.add(new FilterItemInfo("materialGroupDetails.MaterialGroupStandard.number", (Object)std));
                if (!StringUtils.isEmpty((String)group[i].startNumber) && !StringUtils.isEmpty((String)group[i].endNumber)) {
                    if (group[i].startNumber.equals(group[i].endNumber)) {
                        TreeBaseInfo materialGroup = this.getTreeBaseNodeByNumber(group[i].startNumber, "T_BD_Material");
                        if (materialGroup != null && !StringUtils.isEmpty((String)materialGroup.getLongNumber())) {
                            fic.add(new FilterItemInfo("materialGroupDetails.materialGroup.longNumber", (Object)materialGroup.getLongNumber()));
                            fic.add(new FilterItemInfo("materialGroupDetails.materialGroup.longNumber", (Object)(materialGroup.getLongNumber() + "!%"), CompareType.LIKE));
                            mask = mask + " and (#" + maskIndex++ + " or #" + maskIndex++ + ")";
                        } else {
                            fic.add(new FilterItemInfo("materialGroupDetails.materialGroup.number", (Object)group[i].startNumber));
                            mask = mask + " and #" + maskIndex++;
                        }
                    } else {
                        TreeBaseInfo materialGroupStart = this.getTreeBaseNodeByNumber(group[i].startNumber, "T_BD_Material");
                        TreeBaseInfo materialGroupEnd = this.getTreeBaseNodeByNumber(group[i].endNumber, "T_BD_Material");
                        if (materialGroupStart != null && materialGroupEnd != null && !StringUtils.isEmpty((String)materialGroupStart.getLongNumber()) && !StringUtils.isEmpty((String)materialGroupEnd.getLongNumber())) {
                            startLongNumber = materialGroupStart.getLongNumber();
                            endLongNumber = materialGroupEnd.getLongNumber();
                            fic.add(new FilterItemInfo("materialGroupDetails.materialGroup.longNumber", (Object)startLongNumber, CompareType.GREATER_EQUALS));
                            fic.add(new FilterItemInfo("materialGroupDetails.materialGroup.longNumber", (Object)endLongNumber, CompareType.LESS_EQUALS));
                            fic.add(new FilterItemInfo("materialGroupDetails.materialGroup.longNumber", (Object)(endLongNumber + "!%"), CompareType.LIKE));
                            mask = mask + " and (#" + maskIndex++ + " and #" + maskIndex++ + " or #" + maskIndex++ + ")";
                        } else {
                            fic.add(new FilterItemInfo("materialGroupDetails.materialGroup.number", (Object)group[i].startNumber, CompareType.GREATER_EQUALS));
                            fic.add(new FilterItemInfo("materialGroupDetails.materialGroup.number", (Object)group[i].endNumber, CompareType.LESS_EQUALS));
                            mask = mask + " and (#" + maskIndex++ + " and #" + maskIndex++ + ")";
                        }
                    }
                }
            }
            mask = mask + ")";
        }
        filter.setMaskString(mask);
        return filter;
    }

    protected TreeBaseInfo getTreeBaseNodeByNumber(String number, String groupTableName) throws Exception {
        ICSSPGroup treeBase = null;
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        String string = "Select Number, LongNumber, Name Where number = '" + number + "' ";
        if (groupTableName.equalsIgnoreCase("T_BD_Customer")) {
            treeBase = CSSPGroupFactory.getRemoteInstance();
            string = string + " AND (groupStandard.type=1 or groupStandard.type=0)";
        } else if (groupTableName.equalsIgnoreCase("T_BD_Supplier")) {
            treeBase = CSSPGroupFactory.getRemoteInstance();
            string = string + " AND (groupStandard.type=2 or groupStandard.type=0)";
        } else if (groupTableName.equalsIgnoreCase("T_BD_Material")) {
            treeBase = MaterialGroupFactory.getRemoteInstance();
        } else {
            throw new Exception("No supported group.");
        }
        CoreBaseCollection colls = treeBase.getCollection(string);
        if (colls == null || colls.size() < 1) {
            return null;
        }
        return (TreeBaseInfo)colls.get(0);
    }

    public boolean cslRptCalculate(CslReportInfo cslReportInfo) throws Exception {
        ICslReport iReport = CslReportFactory.getRemoteInstance();
        Book book = this.prepareCalculate(cslReportInfo);
        if ((cslReportInfo.getSourceType() == RptSrcTypeEnum.NORMAL || cslReportInfo.getSourceType() == RptSrcTypeEnum.DYNAMICNORMALREPORT || cslReportInfo.getSourceType() == RptSrcTypeEnum.COMMITREPORT) && cslReportInfo.getAdjustStatus().getValue() != 1) {
            this.fillYearInitData(cslReportInfo.getId().toString(), book);
        }
        this.calcBook(book, (ReportBaseInfo)cslReportInfo);
        cslReportInfo.setBook(book);
        iReport.submit((CoreBaseInfo)cslReportInfo);
        return true;
    }

    protected void calcBook(Book book, ReportBaseInfo reportInfo) {
        book.calc();
    }

    private Book prepareCalculate(CslReportInfo reportInfo) throws Exception {
        Book book = null;
        book = reportInfo.getData() != null ? reportInfo.getBook() : Book.Manager.getNewBook((String)"Sheet1", (int)1);
        book.setCalculate(false);
        return book;
    }

    private void fillYearInitData(String reportId, Book book) throws Exception {
        List valueList = MaintainYearInitDataFacadeFactory.getRemoteInstance().getCellValueFromYearInitDataByReportID(reportId);
        if (valueList != null) {
            Iterator valueIt = valueList.iterator();
            HashMap valueMap = null;
            BigDecimal zero = new BigDecimal("0");
            while (valueIt.hasNext()) {
                Cell cell;
                String formula;
                valueMap = (HashMap)valueIt.next();
                BigDecimal value = null;
                int dc = (Integer)valueMap.get("RptItemDC");
                if (valueMap.get("Debit") != null && ((BigDecimal)valueMap.get("Debit")).compareTo(zero) != 0) {
                    value = ((BigDecimal)valueMap.get("Debit")).multiply(new BigDecimal(dc == 1 ? "1" : "-1"));
                }
                if (valueMap.get("Credit") != null && ((BigDecimal)valueMap.get("Credit")).compareTo(zero) != 0) {
                    value = ((BigDecimal)valueMap.get("Credit")).multiply(new BigDecimal(dc == 1 ? "-1" : "1"));
                }
                if (value == null || !StringUtils.isEmpty((String)(formula = (cell = book.getSheetByID((String)valueMap.get("RptItemSheetID")).getCell(((Integer)valueMap.get("RptItemPosY")).intValue(), ((Integer)valueMap.get("RptItemPosX")).intValue(), true)).getFormula())) && (formula.length() <= 0 || formula.charAt(0) == '=')) continue;
                int currencyScale = (Integer)valueMap.get("CurrencyPrecision");
                value = value.setScale(currencyScale, 4);
                cell.setValue(new Variant((Object)value));
            }
        }
    }

    public int getReportClass(Book book, Sheet sheet) throws Exception {
        ReportVariables v = ReportVariables.loadFromBook((Book)book);
        if (v == null) {
            v = new ReportVariables();
            v.storeToBook(book);
        }
        int reportClass = v.getIntValue("SheetClass", sheet.getSheetName(), 1);
        return reportClass;
    }

    protected boolean isInterOrExchSheet(Book book, Sheet sheet) throws Exception {
        int reportClass = this.getReportClass(book, sheet);
        boolean isInter = reportClass == 10;
        boolean isExch = reportClass == 20;
        return isInter || isExch;
    }

    protected BookProperties getBookProperties(Book book) {
        BookProperties p = BookProperties.loadFromBook((Book)book);
        if (p == null) {
            p = new BookProperties();
            p.restoreToBook(book);
        }
        return p;
    }
}

