/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.provider;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.ctrl.common.util.ObjectUtil;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.message.client.MessageCenterUI;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.BgAccountCollection;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgScenarioType;
import com.kingdee.eas.ma.base.IBgAccount;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.bgcsl.BgCslFormCollection;
import com.kingdee.eas.ma.bgcsl.BgCslFormFactory;
import com.kingdee.eas.ma.bgcsl.BgCslFormInfo;
import com.kingdee.eas.ma.bgcsl.BgCslFormStateEnum;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateInfo;
import com.kingdee.eas.ma.bgcsl.BgCslViewListFormFacadeFactory;
import com.kingdee.eas.ma.bgcsl.IBgCslForm;
import com.kingdee.eas.ma.bgcsl.IBgCslViewListFormFacade;
import com.kingdee.eas.ma.bgcsl.common.BgCslFormHelper;
import com.kingdee.eas.ma.bgcsl.utils.BgCslDimensionCacheHelper;
import com.kingdee.eas.ma.bgcsl.utils.BgCslDimensionMemberCheckFactory;
import com.kingdee.eas.ma.bgcsl.utils.BgCslFormBudgetDataQueryHelper;
import com.kingdee.eas.ma.bgcsl.utils.BgCslFormPropertyAdapter;
import com.kingdee.eas.ma.bgcsl.utils.BgCslSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.BgExpressionFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFormTitleEnum;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.IBgExpressionFacade;
import com.kingdee.eas.ma.mbg.IMbgViewListDesCell;
import com.kingdee.eas.ma.mbg.IMbgViewListEditNote;
import com.kingdee.eas.ma.mbg.MbgViewListDesCellCollection;
import com.kingdee.eas.ma.mbg.MbgViewListDesCellFactory;
import com.kingdee.eas.ma.mbg.MbgViewListDesCellInfo;
import com.kingdee.eas.ma.mbg.MbgViewListEditNoteCollection;
import com.kingdee.eas.ma.mbg.MbgViewListEditNoteFactory;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgDimensionParseCommonHelper;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.BgSheetRange;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IMbgSheetBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.MBGLayoutConstants;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.common.MbgViewListCalcutor;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListXMLParser;
import com.kingdee.eas.ma.mbg.common.TemplateStyleInfo;
import com.kingdee.eas.ma.mbg.common.ViewListBookParseHelper;
import com.kingdee.eas.ma.mbg.designer.ICheckCanSave;
import com.kingdee.eas.ma.mbg.designer.IProvider;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.provider.ViewListProvider;
import com.kingdee.eas.ma.mbg.provider.viewListForm.IViewListCombinRender;
import com.kingdee.eas.ma.mbg.utils.BgCommentCommonHelper;
import com.kingdee.eas.ma.mbg.utils.BgFormHelper;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNExpressionHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckFactory;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckHelper;
import com.kingdee.eas.ma.mbg.utils.MBGViewListFormCommonHelper;
import com.kingdee.eas.ma.mbg.utils.MbgBudgetDataQueryHelper;
import com.kingdee.eas.ma.mbg.utils.MbgViewListDescriptionHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListHelper;
import com.kingdee.eas.ma.mbg.utils.ViewlistCombinHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgCslViewListFormProvider
extends ViewListProvider
implements IViewListCombinRender,
ICheckCanSave {
    private static final Logger logger = Logger.getLogger((String)BgCslViewListFormProvider.class.getName());
    private Map<String, Integer> accountDataTypeMap = new HashMap<String, Integer>();
    MbgViewListManager oldMbgViewListManager = null;
    private Map<String, MbgViewListManager> mutiOrgOnRowColViewManagers = new HashMap<String, MbgViewListManager>();
    private BgCslFormBudgetDataQueryHelper queryDataHelper = null;
    protected Map<String, Map<String, BgNViewDataInfo>> bgDataMap = new HashMap<String, Map<String, BgNViewDataInfo>>();
    public Map<String, BgCslFormInfo> orgIdBgForm = new HashMap<String, BgCslFormInfo>();
    private Map<Integer, String> editNotes = new HashMap<Integer, String>();
    public Map<String, BgCslFormStateEnum> orgIdFormState = new HashMap<String, BgCslFormStateEnum>();
    private Map<String, Boolean> orgFormInPorInst = new HashMap<String, Boolean>();

    public Map<String, MbgViewListManager> getMutiOrgOnRowColViewManagers() {
        return this.mutiOrgOnRowColViewManagers;
    }

    public void setMutiOrgOnRowColViewManagers(Map<String, MbgViewListManager> mutiOrgOnRowColViewManagers) {
        this.mutiOrgOnRowColViewManagers = mutiOrgOnRowColViewManagers;
    }

    public MbgBudgetDataQueryHelper getQueryDataHelper() {
        if (this.queryDataHelper == null) {
            this.queryDataHelper = new BgCslFormBudgetDataQueryHelper((Component)this.getOwner(), this.getCtx());
        }
        return this.queryDataHelper;
    }

    public final Object load() throws Exception {
        this.initAccountDataTypeMap();
        this.initTemplateStyle();
        this.loadMbgViewManager();
        this.setOldMbgViewListManager((MbgViewListManager)this.curMbgViewManager);
        this.addOtherOrgViewData(this.getOrgUnitInfo(), (MbgViewListManager)this.getCurMbgViewManager());
        this.loadMultiOrg();
        Map<String, List<IBgDimensionManagerBase>> initDimensionManagers = this.getInitDimensionManagers();
        this.getQueryDataHelper().startQueryData(this.getQueryDataInfo(), initDimensionManagers, this.getDataType(), this.getBgOrgViewId());
        this.getBookParseHelper().refreshCurMbgViewManager(this.getOrgUnitInfo(), this.getCurMbgViewManager());
        this.getOrgIdFormStateMap();
        Book book = this.loadBook();
        book.setActiveSheet(0);
        this.setCurMbgSheetManager((IMbgSheetBase)((MbgViewListManager)this.curMbgViewManager).getSheetManagers().get(book.getActiveSheetIndex()));
        BgCommentCommonHelper.setCommentProtection((Book)book);
        return book;
    }

    protected DimensionMemberCheckFactory createCheckFactory() throws EASBizException, BOSException {
        BgCslDimensionMemberCheckFactory checkFactory = null;
        try {
            checkFactory = new BgCslDimensionMemberCheckFactory(this.getCtx(), null, this.getSchemeHelper());
            checkFactory.setCacheHelper(new BgCslDimensionCacheHelper(this.getCtx()));
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            SysUtil.abort();
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            SysUtil.abort();
        }
        return checkFactory;
    }

    public final Book loadBook() throws Exception {
        return this.getBookParseHelper().getBook(this.getOwner(), (IProvider)this, this.getCheckFactory(), this.getOrgPermission());
    }

    protected String getSheetTitle() {
        if (this.getTemplateStyle() != null && this.getTemplateStyle().getBgFormTitle().equals((Object)BgFormTitleEnum.templateNameNew)) {
            return this.getBgCslForm().getBgCslTemplate().getName();
        }
        return this.getBgCslForm().getName();
    }

    public ViewListBookParseHelper getBookParseHelper() {
        ViewListBookParseHelper bookParseHelper = super.getBookParseHelper();
        bookParseHelper.setViewF7Enable(true);
        bookParseHelper.setPageF7Enable(true);
        bookParseHelper.setOrgF7Enable(true);
        bookParseHelper.setParseForm(true);
        bookParseHelper.setAccountMap(this.getAccountDataTypeMap());
        bookParseHelper.setReadonly(false);
        bookParseHelper.setShowDefaultMember(true);
        bookParseHelper.setUnionGroupId(this.getOrgUnitId());
        return bookParseHelper;
    }

    protected int getDataType() {
        return 64;
    }

    protected Map<String, List<IBgDimensionManagerBase>> getInitDimensionManagers() {
        HashMap<String, List<IBgDimensionManagerBase>> dimensionManagers = new HashMap<String, List<IBgDimensionManagerBase>>();
        String currOrgNumber = this.getOrgUnitInfo().getNumber();
        HashSet<String> orgNums = new HashSet<String>();
        for (int sheetIndex = 0; sheetIndex < ((MbgViewListManager)this.curMbgViewManager).getSheetManagers().size(); ++sheetIndex) {
            orgNums.clear();
            boolean isorgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView((IBgDimensionManagerBase)((MbgViewListSheetManager)((MbgViewListManager)this.getCurMbgViewManager()).getSheetManagers().get(sheetIndex)).getDimensionManager());
            String curOrgNumForDimensionData = this.getOrgNumsForCurSheet(sheetIndex, orgNums);
            if (!isorgOnPageOrView && orgNums.size() > 1) {
                this.processOrgNumsOnRowCol(sheetIndex, dimensionManagers, orgNums, curOrgNumForDimensionData);
                continue;
            }
            this.getInitOrgNums(orgNums, sheetIndex);
            if (orgNums.size() <= 0) continue;
            MbgViewListDimensionManager dimensionManager = null;
            for (String orgNum : orgNums) {
                if (!this.orgUnitMap.containsKey(orgNum)) continue;
                if (!dimensionManagers.containsKey(((FullOrgUnitInfo)this.orgUnitMap.get(orgNum)).getId().toString())) {
                    dimensionManagers.put(((FullOrgUnitInfo)this.orgUnitMap.get(orgNum)).getId().toString(), new ArrayList());
                }
                if (!this.getBgViewManagerForMulOrg().containsKey(orgNum)) continue;
                dimensionManager = ((MbgViewListSheetManager)((MbgViewListManager)this.getBgViewManagerForMulOrg().get(orgNum)).getSheetManagers().get(sheetIndex)).getDimensionManager().deepclone();
                ArrayList pageViewDims = new ArrayList();
                pageViewDims.addAll(((MbgViewListSheetManager)((MbgViewListManager)this.curMbgViewManager).getSheetManagers().get(sheetIndex)).getDimensionManager().getPageDisplayDimension());
                pageViewDims.addAll(((MbgViewListSheetManager)((MbgViewListManager)this.curMbgViewManager).getSheetManagers().get(sheetIndex)).getDimensionManager().getViewDisplayDimension());
                if (!pageViewDims.isEmpty()) {
                    List dimensions = MBgTemplateHelper.getDimensions((IBgDimensionManagerBase)dimensionManager, (List)MBgTemplateHelper.getDimensionsNum(pageViewDims));
                    for (int dimensionIndex = 0; dimensionIndex < dimensions.size(); ++dimensionIndex) {
                        BgDimensionBaseInfo dim = (BgDimensionBaseInfo)dimensions.get(dimensionIndex);
                        if (dim.getMember().isEmpty()) continue;
                        Object member = dim.getMember().get(0);
                        String currNumber = null;
                        if (dim.getNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER)) {
                            currNumber = currOrgNumber;
                        } else if (dim.getNumber().equals(DimensionConstants.DEF_SCENARIO_NUMBER)) {
                            BgDimensionMember defScen = BgDimensionParseCommonHelper.getDefaultMember((IUIObject)this.getOwner(), (BgDimensionBaseInfo)dim, (BgScenarioType)this.getEditScenType(), (DimensionCacheHelper)this.getCheckFactory().getCacheHelper());
                            if (defScen != null) {
                                currNumber = defScen.getNumber();
                            }
                        } else if (dim.getNumber().equals(DimensionConstants.DEF_VERSION_NUMBER)) {
                            currNumber = this.getBgCslForm().getBgVersion().getNumber();
                        }
                        if (currNumber != null) {
                            for (int m = 0; m < dim.getMember().size(); ++m) {
                                if (!currNumber.equals(((BgDimensionMember)dim.getMember().get(m)).getNumber())) continue;
                                member = dim.getMember().get(m);
                                break;
                            }
                        }
                        dim.getMember().clear();
                        dim.getMember().add(member);
                    }
                }
                ((List)dimensionManagers.get(((FullOrgUnitInfo)this.orgUnitMap.get(orgNum)).getId().toString())).add(dimensionManager);
            }
        }
        return dimensionManagers;
    }

    protected void collectDimesionManagersForQuery(int sheetIndex, Map<String, List<IBgDimensionManagerBase>> dimensionManagers) {
        if (sheetIndex == -1) {
            return;
        }
        boolean isorgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView((IBgDimensionManagerBase)((MbgViewListSheetManager)((MbgViewListManager)this.getCurMbgViewManager()).getSheetManagers().get(sheetIndex)).getDimensionManager());
        HashSet<String> orgNums = new HashSet<String>();
        String curOrgNumForDimensionData = this.getOrgNumsForCurSheet(sheetIndex, orgNums);
        if (!isorgOnPageOrView && orgNums.size() > 1) {
            this.processOrgNumsOnRowCol(sheetIndex, dimensionManagers, orgNums, curOrgNumForDimensionData);
        } else if (orgNums.size() > 0) {
            MbgViewListDimensionManager dimensionManager = null;
            for (String orgNum : orgNums) {
                if (!this.orgUnitMap.containsKey(orgNum)) continue;
                if (!dimensionManagers.containsKey(((FullOrgUnitInfo)this.orgUnitMap.get(orgNum)).getId().toString())) {
                    dimensionManagers.put(((FullOrgUnitInfo)this.orgUnitMap.get(orgNum)).getId().toString(), new ArrayList());
                }
                if (!this.getBgViewManagerForMulOrg().containsKey(orgNum)) continue;
                MbgViewListDimensionManager oldDimensionManager = ((MbgViewListSheetManager)((MbgViewListManager)this.getBgViewManagerForMulOrg().get(orgNum)).getSheetManagers().get(sheetIndex)).getDimensionManager();
                dimensionManager = oldDimensionManager.deepclone();
                this.dealPageMembers(this.getViewF7List(sheetIndex), this.getPageF7List(sheetIndex), (IBgDimensionManagerBase)dimensionManager, (IBgDimensionManagerBase)((MbgViewListSheetManager)((MbgViewListManager)this.getCurMbgViewManager()).getSheetManagers().get(sheetIndex)).getDimensionManager(), this.getOrgUnitInfo().getNumber());
                dimensionManager = dimensionManager.deepclone();
                this.synHideDimension((MbgViewListSheetManager)((MbgViewListManager)this.getCurMbgViewManager()).getSheetManagers().get(sheetIndex), (IBgDimensionManagerBase)dimensionManager);
                dimensionManagers.get(((FullOrgUnitInfo)this.orgUnitMap.get(orgNum)).getId().toString()).add((IBgDimensionManagerBase)dimensionManager);
            }
        }
    }

    private void processOrgNumsOnRowCol(int sheetIndex, Map<String, List<IBgDimensionManagerBase>> dimensionManagers, Set<String> orgNums, String curOrgNumForDimensionData) {
        boolean isOrgOnRow = MBGViewListFormCommonHelper.isOrgOnRow((MbgViewListDimensionManager)((MbgViewListSheetManager)((MbgViewListManager)this.getCurMbgViewManager()).getSheetManagers().get(sheetIndex)).getDimensionManager());
        MbgViewListDimensionManager dimensionManager = null;
        if (this.getBgViewManagerForMulOrg().containsKey(curOrgNumForDimensionData)) {
            MbgViewListDimensionManager oldDimensionManager = ((MbgViewListSheetManager)((MbgViewListManager)this.getBgViewManagerForMulOrg().get(curOrgNumForDimensionData)).getSheetManagers().get(sheetIndex)).getDimensionManager();
            Map<String, String> orgNumAndIdMap = this.getOrgNumAndIdMap(oldDimensionManager.getAllDimensions());
            Map orgAndRowCols = null;
            boolean isRowColShowbyTemp = true;
            isRowColShowbyTemp = this.getCurMbgSheetManager() != null ? ((MbgViewListSheetManager)this.getCurMbgSheetManager()).isRowColShowbyTemp() : oldDimensionManager.getSheet().isRowColShowbyTemp();
            orgAndRowCols = isRowColShowbyTemp ? MBGViewListFormCommonHelper.getViewListObjectsByTemp((MbgViewListDimensionManager)oldDimensionManager, (Boolean)isOrgOnRow, (String)this.getOrgUnitInfo().getNumber()) : MBGViewListFormCommonHelper.getViewListObjectsByOrg((MbgViewListDimensionManager)oldDimensionManager, (Boolean)isOrgOnRow);
            Iterator<String> orgIte = orgNums.iterator();
            while (orgIte.hasNext()) {
                int x;
                int indx;
                ArrayList rows;
                ArrayList initRows;
                dimensionManager = oldDimensionManager.deepclone();
                String viewOrgNum = orgIte.next();
                if (orgAndRowCols == null || !orgAndRowCols.containsKey(viewOrgNum)) continue;
                if (isOrgOnRow) {
                    dimensionManager.getRows().clear();
                    dimensionManager.getRows().addAll((Collection)orgAndRowCols.get(viewOrgNum));
                    if (!viewOrgNum.equals(curOrgNumForDimensionData) && this.getBgViewManagerForMulOrg().containsKey(viewOrgNum)) {
                        if (isRowColShowbyTemp) {
                            initRows = (ArrayList)((MbgViewListSheetManager)((MbgViewListManager)this.getBgViewManagerForMulOrg().get(viewOrgNum)).getSheetManagers().get(sheetIndex)).getDimensionManager().getRows();
                            rows = (ArrayList)orgAndRowCols.get(viewOrgNum);
                            indx = -1;
                            for (x = 0; x < initRows.size(); ++x) {
                                if (!(initRows.get(x) instanceof MbgViewListRowCol) || rows.size() <= ++indx || !(rows.get(indx) instanceof MbgViewListRowCol)) continue;
                                initRows.remove(x);
                                initRows.add(x, rows.get(indx));
                            }
                        } else {
                            ((MbgViewListSheetManager)((MbgViewListManager)this.getBgViewManagerForMulOrg().get(viewOrgNum)).getSheetManagers().get(sheetIndex)).getDimensionManager().getRows().clear();
                            ((MbgViewListSheetManager)((MbgViewListManager)this.getBgViewManagerForMulOrg().get(viewOrgNum)).getSheetManagers().get(sheetIndex)).getDimensionManager().getRows().addAll((Collection)orgAndRowCols.get(viewOrgNum));
                        }
                    }
                } else {
                    dimensionManager.getColumns().clear();
                    dimensionManager.getColumns().addAll((Collection)orgAndRowCols.get(viewOrgNum));
                    if (!viewOrgNum.equals(curOrgNumForDimensionData) && this.getBgViewManagerForMulOrg().containsKey(viewOrgNum)) {
                        if (isRowColShowbyTemp) {
                            initRows = (ArrayList)((MbgViewListSheetManager)((MbgViewListManager)this.getBgViewManagerForMulOrg().get(viewOrgNum)).getSheetManagers().get(sheetIndex)).getDimensionManager().getColumns();
                            rows = (ArrayList)orgAndRowCols.get(viewOrgNum);
                            indx = -1;
                            for (x = 0; x < initRows.size(); ++x) {
                                if (!(initRows.get(x) instanceof MbgViewListRowCol) || rows.size() <= ++indx || !(rows.get(indx) instanceof MbgViewListRowCol)) continue;
                                initRows.remove(x);
                                initRows.add(x, rows.get(indx));
                            }
                        } else {
                            ((MbgViewListSheetManager)((MbgViewListManager)this.getBgViewManagerForMulOrg().get(viewOrgNum)).getSheetManagers().get(sheetIndex)).getDimensionManager().getColumns().clear();
                            ((MbgViewListSheetManager)((MbgViewListManager)this.getBgViewManagerForMulOrg().get(viewOrgNum)).getSheetManagers().get(sheetIndex)).getDimensionManager().getColumns().addAll((Collection)orgAndRowCols.get(viewOrgNum));
                        }
                    }
                }
                this.dealPageMembers(this.getViewF7List(sheetIndex), this.getPageF7List(sheetIndex), (IBgDimensionManagerBase)dimensionManager, (IBgDimensionManagerBase)((MbgViewListSheetManager)((MbgViewListManager)this.getCurMbgViewManager()).getSheetManagers().get(sheetIndex)).getDimensionManager(), this.getOrgUnitInfo().getNumber());
                dimensionManager = dimensionManager.deepclone();
                this.synHideDimension((MbgViewListSheetManager)((MbgViewListManager)this.getCurMbgViewManager()).getSheetManagers().get(sheetIndex), (IBgDimensionManagerBase)dimensionManager);
                if (!orgNumAndIdMap.containsKey(viewOrgNum)) continue;
                MbgViewListManager newViewManager = null;
                if (!dimensionManagers.containsKey(orgNumAndIdMap.get(viewOrgNum))) {
                    dimensionManagers.put(orgNumAndIdMap.get(viewOrgNum), new ArrayList());
                    newViewManager = DimensionCommonHelper.cloneViewManager((MbgViewListManager)((MbgViewListManager)this.getCurMbgViewManager()));
                    this.mutiOrgOnRowColViewManagers.put(orgNumAndIdMap.get(viewOrgNum), newViewManager);
                }
                dimensionManagers.get(orgNumAndIdMap.get(viewOrgNum)).add((IBgDimensionManagerBase)dimensionManager);
                if (newViewManager == null) continue;
                ((MbgViewListSheetManager)this.mutiOrgOnRowColViewManagers.get(orgNumAndIdMap.get(viewOrgNum)).getSheetManagers().get(sheetIndex)).setDimensionManager(dimensionManager);
            }
        }
    }

    private Map<String, String> getOrgNumAndIdMap(List<MbgViewListDimensionInfo> dimensions) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        BgDimensionMember member = null;
        for (int i = 0; i < dimensions.size(); ++i) {
            if (!MBGLayoutConstants.BG_ORGANIZATION.equals(dimensions.get(i).getNumber())) continue;
            for (int j = 0; j < dimensions.get(i).getMember().size(); ++j) {
                member = (BgDimensionMember)dimensions.get(i).getMember().get(j);
                if (member.getAttribute().startsWith("F")) continue;
                returnMap.put(member.getNumber(), member.getAttribute());
            }
        }
        return returnMap;
    }

    private void synHideDimension(MbgViewListSheetManager sheetManager, IBgDimensionManagerBase dimensionManager) {
        if (sheetManager == null || dimensionManager == null || sheetManager.getDimensionManager() == null || sheetManager.getDimensionManager().getHideDisplayDimension() == null) {
            return;
        }
        HashMap<String, BgDimensionBaseInfo> baseHide = new HashMap<String, BgDimensionBaseInfo>();
        for (int d = 0; d < sheetManager.getDimensionManager().getHideDisplayDimension().size(); ++d) {
            BgDimensionBaseInfo bgDimension = (BgDimensionBaseInfo)sheetManager.getDimensionManager().getHideDisplayDimension().get(d);
            baseHide.put(bgDimension.getNumber(), bgDimension);
        }
        this.moveToHide(dimensionManager.getPageDimension(), dimensionManager.getHideDisplayDimension(), baseHide);
        this.moveToHide(dimensionManager.getViewDimension(), dimensionManager.getHideDisplayDimension(), baseHide);
        this.moveToHide(dimensionManager.getRowDimension(), dimensionManager.getHideDisplayDimension(), baseHide);
        this.moveToHide(dimensionManager.getColDimension(), dimensionManager.getHideDisplayDimension(), baseHide);
        this.moveToNoHide(dimensionManager, baseHide);
    }

    private void moveToNoHide(IBgDimensionManagerBase dimensionManager, Map<String, BgDimensionBaseInfo> baseHide) {
        if (dimensionManager == null || dimensionManager.getHideDisplayDimension() == null) {
            return;
        }
        Iterator it = dimensionManager.getHideDisplayDimension().iterator();
        while (it.hasNext()) {
            BgDimensionBaseInfo bgDimension = (BgDimensionBaseInfo)it.next();
            if (baseHide.containsKey(bgDimension.getNumber())) continue;
            dimensionManager.getRowDisplayDimension().add(bgDimension);
            it.remove();
        }
    }

    private void moveToHide(List displayDimens, List hideDimensions, Map<String, BgDimensionBaseInfo> baseHide) {
        if (displayDimens == null || hideDimensions == null) {
            return;
        }
        Iterator it = displayDimens.iterator();
        while (it.hasNext()) {
            BgDimensionBaseInfo bgDimension = (BgDimensionBaseInfo)it.next();
            if (!baseHide.containsKey(bgDimension.getNumber()) || hideDimensions.contains(bgDimension)) continue;
            hideDimensions.add(bgDimension);
            it.remove();
        }
    }

    public void getInitOrgNums(Set<String> orgNums, int sheetIndex) {
        MbgViewListDimensionManager dimManager = ((MbgViewListSheetManager)((MbgViewListManager)this.curMbgViewManager).getSheetManagers().get(sheetIndex)).getDimensionManager();
        boolean isorgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView((IBgDimensionManagerBase)dimManager);
        if (isorgOnPageOrView) {
            orgNums.add(this.getOrgUnitInfo().getNumber());
        } else {
            int i;
            ArrayList dimens = new ArrayList();
            List rowCols = ((MbgViewListSheetManager)((MbgViewListManager)this.getCurMbgViewManager()).getSheetManagers().get(sheetIndex)).getDimensionManager().getRowCols();
            for (i = 0; i < rowCols.size(); ++i) {
                if (!(rowCols.get(i) instanceof MbgViewListRowCol)) continue;
                dimens.addAll(((MbgViewListRowCol)rowCols.get(i)).getDimensions());
            }
            for (i = 0; i < dimens.size(); ++i) {
                if (!(dimens.get(i) instanceof BgDimensionBaseInfo) || !((BgDimensionBaseInfo)dimens.get(i)).getNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER)) continue;
                for (int m = 0; m < ((BgDimensionBaseInfo)dimens.get(i)).getMember().size(); ++m) {
                    orgNums.add(((BgDimensionMember)((BgDimensionBaseInfo)dimens.get(i)).getMember().get(m)).getNumber());
                }
                break;
            }
        }
    }

    public void dealPageMembers(List<KDPromptBox> viewF7List, List<KDPromptBox> pageF7List, IBgDimensionManagerBase dimensionManager, IBgDimensionManagerBase dimensionManagerForStyle, String currOrgNumber) {
        List members;
        List dimensions;
        if (dimensionManager == null) {
            return;
        }
        ArrayList pageViewDimens = new ArrayList();
        ArrayList pageViewMembers = new ArrayList();
        if (viewF7List != null && !viewF7List.isEmpty()) {
            dimensions = MBgTemplateHelper.getDimensions((IBgDimensionManagerBase)dimensionManager, (List)MBgTemplateHelper.getDimensionsNum((List)dimensionManagerForStyle.getViewDisplayDimension()));
            members = BgViewHelper.getCurrPageMember(viewF7List, (List)dimensions);
            pageViewDimens.addAll(dimensions);
            pageViewMembers.addAll(members);
        }
        if (pageF7List != null && !pageF7List.isEmpty()) {
            dimensions = MBgTemplateHelper.getDimensions((IBgDimensionManagerBase)dimensionManager, (List)MBgTemplateHelper.getDimensionsNum((List)dimensionManagerForStyle.getPageDisplayDimension()));
            members = BgViewHelper.getCurrPageMember(pageF7List, (List)dimensions);
            pageViewDimens.addAll(dimensions);
            pageViewMembers.addAll(members);
        }
        for (int dimensionIndex = 0; dimensionIndex < pageViewDimens.size(); ++dimensionIndex) {
            int m;
            BgDimensionBaseInfo dim = (BgDimensionBaseInfo)pageViewDimens.get(dimensionIndex);
            BgDimensionMember member = null;
            for (m = 0; m < pageViewMembers.size(); ++m) {
                if (((BgDimensionMember)pageViewMembers.get(m)).getType() == null || !((BgDimensionMember)pageViewMembers.get(m)).getType().equals(dim.getNumber())) continue;
                member = (BgDimensionMember)pageViewMembers.get(m);
                break;
            }
            if (member == null && !dim.getMember().isEmpty()) {
                member = (BgDimensionMember)dim.getMember().get(0);
                if (dim.getNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER)) {
                    for (m = 0; m < dim.getMember().size(); ++m) {
                        if (!currOrgNumber.equals(((BgDimensionMember)dim.getMember().get(m)).getNumber())) continue;
                        member = (BgDimensionMember)dim.getMember().get(m);
                        break;
                    }
                }
                dim.getMember().clear();
                dim.getMember().add(member);
            }
            dim.getMember().clear();
            if (member == null) continue;
            dim.getMember().add(member);
        }
    }

    protected void loadMultiOrg() throws Exception {
        HashSet<String> orgNums = new HashSet<String>();
        this.getOrgNumsForCurViewManager((MbgViewListManager)this.curMbgViewManager, orgNums);
        if (orgNums != null && orgNums.size() > 1) {
            this.queryMultiOrgViewManagers(orgNums);
        }
    }

    private void queryMultiOrgViewManagers(Set<String> orgNums) throws EASBizException, BOSException {
        BgViewManagerForMultiOrgSwingWorker worker = new BgViewManagerForMultiOrgSwingWorker(orgNums);
        worker.start();
    }

    protected void addBgViewManagerForMultiOrg(Set<String> orgNums) throws Exception {
        Map res;
        HashSet<String> notExitOrgNum = new HashSet<String>();
        if (orgNums != null && !orgNums.isEmpty()) {
            String orgNum2 = null;
            for (String orgNum2 : orgNums) {
                if (this.getBgViewManagerForMulOrg().containsKey(orgNum2)) continue;
                notExitOrgNum.add(orgNum2);
            }
        }
        if (notExitOrgNum.size() > 0 && (res = this.loadMbgViewManagers(notExitOrgNum)) != null && !res.isEmpty()) {
            for (String key : res.keySet()) {
                if (!(key instanceof FullOrgUnitInfo) || !(res.get(key) instanceof MbgViewListManager)) continue;
                this.addOtherOrgViewData((FullOrgUnitInfo)key, (MbgViewListManager)res.get(key));
            }
        }
    }

    protected Map loadMbgViewManagers(Set<String> notExitOrgNum) throws EASBizException, BOSException {
        return this.getMbgViewListFacade().getViewListManagers(((BgCslFormInfo)this.getEditValue()).getId().toString(), this.getOrgViewId(), notExitOrgNum, this.getOrgPermission(), this.getInitOrgId(), false);
    }

    protected String getInitOrgId() {
        return this.getBgCslForm().getOrgUnit().getId().toString();
    }

    protected void getOrgNumsForCurViewManager(MbgViewListManager viewManager, Set<String> orgNums) {
        if (viewManager == null || orgNums == null) {
            return;
        }
        for (int sheetIndex = 0; sheetIndex < viewManager.getSheetManagers().size(); ++sheetIndex) {
            boolean isorgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView((IBgDimensionManagerBase)((MbgViewListSheetManager)viewManager.getSheetManagers().get(sheetIndex)).getDimensionManager());
            if (isorgOnPageOrView) continue;
            ArrayList<BgDimensionBaseInfo> dimensions = new ArrayList<BgDimensionBaseInfo>();
            List rowCols = ((MbgViewListSheetManager)((MbgViewListManager)this.getCurMbgViewManager()).getSheetManagers().get(sheetIndex)).getDimensionManager().getRowCols();
            for (int i = 0; i < rowCols.size(); ++i) {
                if (!(rowCols.get(i) instanceof MbgViewListRowCol)) continue;
                dimensions.addAll(((MbgViewListRowCol)rowCols.get(i)).getDimensions());
            }
            this.getOrgMembers(orgNums, dimensions);
            break;
        }
    }

    private void getOrgMembers(Set<String> orgNums, List<BgDimensionBaseInfo> dimensions) {
        for (int i = 0; i < dimensions.size(); ++i) {
            if (!MBGLayoutConstants.BG_ORGANIZATION.equals(dimensions.get(i).getNumber())) continue;
            for (int j = 0; j < dimensions.get(i).getMember().size(); ++j) {
                orgNums.add(((BgDimensionMember)dimensions.get(i).getMember().get(j)).getNumber());
            }
        }
    }

    protected void loadMbgViewManager() throws Exception {
        Object dataBytes = null;
        BgCslFormInfo bgFormInfo = this.getBgCslForm();
        if (bgFormInfo != null) {
            Map multiFormulas;
            this.setOrgUnitInfo(bgFormInfo.getOrgUnit());
            if (null != this.getCurMbgViewManager()) {
                MBGViewListFormCommonHelper.initCanEditOtherBgForm((Context)this.getCtx(), (MbgViewListManager)((MbgViewListManager)this.getCurMbgViewManager()));
            }
            this.curMbgViewManager = this.getParser().parse(bgFormInfo.getDimensionData());
            Map vilewListData = this.getMbgViewListFacade().loadViewManagersForProvider(bgFormInfo, this.getTemplateStyle(), this.getOrgViewId(), (MbgViewListManager)this.getCurMbgViewManager(), this.getReportAdapter());
            this.setEditOrgUnit((String)vilewListData.get("edit.orgunit"));
            this.setEditPeriod((String)vilewListData.get("edit.period"));
            this.setPropMaps((Map)vilewListData.get("dimension.property"));
            this.curMbgViewManager = (MbgViewListManager)vilewListData.get("dimensino.member");
            Map multiMap = (Map)vilewListData.get("MULTI_ORG_VIEW_MANAGER");
            if (multiMap != null && !multiMap.isEmpty()) {
                for (Object key : multiMap.keySet()) {
                    if (!(key instanceof FullOrgUnitInfo) || !(multiMap.get(key) instanceof MbgViewListManager)) continue;
                    this.addOtherOrgViewData((FullOrgUnitInfo)key, (MbgViewListManager)multiMap.get(key));
                }
            }
            if (vilewListData.containsKey("MULTI_ORG_VIEW_MANAGER_FORMULAS") && !(multiFormulas = (Map)vilewListData.get("MULTI_ORG_VIEW_MANAGER_FORMULAS")).isEmpty()) {
                this.setMultiOrgFormulasMap(multiFormulas);
            }
            if (vilewListData.containsKey("MULTI_ORG_BGFORM")) {
                this.orgIdBgForm = (Map)vilewListData.get("MULTI_ORG_BGFORM");
            }
            this.dealMultiCurView();
            this.clearCache();
        }
    }

    protected final IReportPropertyAdapter getReportAdapter() {
        BgCslFormPropertyAdapter adapter = new BgCslFormPropertyAdapter();
        adapter.setOrgTreeNumber(this.getBgCslForm().getOrgTree().getNumber());
        adapter.initReportProperties((IObjectValue)this.getBgCslForm(), null);
        adapter.setOrgUnit(this.getOrgUnitInfo());
        return adapter;
    }

    public IBgCslViewListFormFacade getMbgViewListFacade() throws BOSException {
        IBgCslViewListFormFacade iBgCslViewListFormFacade = null;
        iBgCslViewListFormFacade = this.getCtx() == null ? BgCslViewListFormFacadeFactory.getRemoteInstance() : BgCslViewListFormFacadeFactory.getLocalInstance(this.getCtx());
        return iBgCslViewListFormFacade;
    }

    protected void initTemplateStyle() throws Exception {
        BgCslTemplateInfo bgTemplate;
        if (this.getBgCslForm().getBgCslTemplate() != null && (bgTemplate = this.getBgCslForm().getBgCslTemplate()).getStyleSet() != null && bgTemplate.getStyleSet().getData() != null) {
            this.getParser();
            TemplateStyleInfo templateStyleInfo = MbgViewListXMLParser.parseStyle((byte[])bgTemplate.getStyleSet().getData());
            this.setTemplateStyle(templateStyleInfo);
        }
    }

    public void reloadBook(Book book) throws Exception {
        this.refreshSheet(book, book.getSheet(0));
    }

    public void refreshSheet(Book book, Sheet sheet) throws Exception {
        if (this.curMbgViewManager == null || sheet == null) {
            return;
        }
        BgNFSHelper.disableCal((Book)book);
        BgNFSHelper.disableUndo((Book)book);
        HashSet<String> orgNums = new HashSet<String>();
        String curOrgNumForDimensionData = this.getOrgNumsForCurSheet(sheet.getSheetIndex(), orgNums);
        if (orgNums.isEmpty()) {
            orgNums.add(this.getOrgUnitInfo().getNumber());
        }
        this.addBgViewManagerForMultiOrg(orgNums);
        HashMap bgSheetManagerForMulOrg = new HashMap();
        for (String orgNum : orgNums) {
            bgSheetManagerForMulOrg.put(orgNum, ((MbgViewListManager)this.getBgViewManagerForMulOrg().get(orgNum)).getSheetManagers().get(sheet.getSheetIndex()));
        }
        if (bgSheetManagerForMulOrg.size() == 0) {
            return;
        }
        if (!bgSheetManagerForMulOrg.containsKey(curOrgNumForDimensionData)) {
            bgSheetManagerForMulOrg.put(curOrgNumForDimensionData, ((MbgViewListManager)this.getBgViewManagerForMulOrg().get(curOrgNumForDimensionData)).getSheetManagers().get(sheet.getSheetIndex()));
        }
        Map<String, Map<String, BgNViewDataInfo>> tmpData = this.divideSheetDataFromDataCache(sheet);
        this.getBookParseHelper().createPageView(this.getOwner(), curOrgNumForDimensionData, bgSheetManagerForMulOrg, sheet, this.getCheckFactory(), this.getOrgPermission());
        this.initQueryData(sheet);
        this.getOrgIdFormStateMap();
        this.getBookParseHelper().getSheet(this.getOwner(), (IProvider)this, curOrgNumForDimensionData, bgSheetManagerForMulOrg, sheet, this.getCheckFactory(), this.getOrgPermission());
        this.fillData(sheet, tmpData);
        BgNFSHelper.enableUndo((Book)book);
        this.filterDesc(book, sheet);
    }

    protected Map<String, Map<String, BgNViewDataInfo>> divideSheetDataFromDataCache(Sheet sheet) throws Exception {
        if (sheet == null) {
            return null;
        }
        HashMap<String, Map<String, BgNViewDataInfo>> tmpData = new HashMap<String, Map<String, BgNViewDataInfo>>();
        Cell cell = null;
        ItemFormula formula = null;
        String cellOrgId = null;
        String version = null;
        BgNViewDataInfo dataValue = null;
        this.collectDimesionManagersForQuery(sheet.getSheetIndex(), new HashMap<String, List<IBgDimensionManagerBase>>());
        this.store(sheet);
        for (int rowIndex = 0; rowIndex <= sheet.getMaxRowIndex(); ++rowIndex) {
            for (int colIndex = 0; colIndex <= sheet.getMaxColIndex(); ++colIndex) {
                cell = sheet.getCell(rowIndex, colIndex, false);
                formula = BgNFSHelper.getItemFormula((Cell)cell);
                if (formula == null) continue;
                version = formula.getExt("Version");
                cellOrgId = formula.getExt("ORGUNITID");
                dataValue = this.getData(this.getBgDataMap(), cellOrgId, formula.getFormula(), version, false);
                if (dataValue == null) continue;
                this.removeFromMap(cellOrgId, formula.getFormula(), version, this.getBgDataMap());
                if (!this.isModify(dataValue)) continue;
                this.addToMap(cellOrgId, formula.getFormula(), version, dataValue, tmpData);
            }
        }
        return tmpData;
    }

    public void removeFromMap(String orgId, String formula, String version, Map<String, Map<String, BgNViewDataInfo>> dataMap) {
        if (StringUtils.isEmpty((String)orgId) || StringUtils.isEmpty((String)formula) || dataMap == null) {
            return;
        }
        if (dataMap.containsKey(orgId)) {
            dataMap.get(orgId).remove(formula + "_" + version);
        }
    }

    protected boolean isModify(BgNViewDataInfo data) throws EASBizException, BOSException {
        if (data != null) {
            DimensionCacheHelper cachehelper = this.getCheckFactory().getCacheHelper();
            if (cachehelper.getBudgetScens().contains(data.getBgScenario())) {
                if (data.getBudgetValueNoDef() == null) {
                    return data.getOldValue() != null;
                }
                if (data.getOldValue() == null) {
                    return data.getBudgetValueNoDef() != null;
                }
                return data.getOldValue().compareTo(data.getBudgetValueNoDef()) != 0;
            }
            if (data.getBizActualNoDef() == null) {
                return data.getOldValue() != null;
            }
            if (data.getOldValue() == null) {
                return data.getBizActualNoDef() != null;
            }
            return data.getOldValue().compareTo(data.getBizActual()) != 0;
        }
        return false;
    }

    public boolean isCheckFull() {
        return true;
    }

    public void store(Book book) throws Exception {
        for (int s = 0; s < book.getSheetCount(); ++s) {
            this.storeCombin(book.getSheet(s));
            this.store(book.getSheet(s));
        }
    }

    public void beforeSaveCheck(Book _book) throws Exception {
        Sheet _sheet = null;
        Cell _cell = null;
        boolean hasBgFormula = false;
        int rowCount = 0;
        int colCount = 0;
        int rowIndex = 0;
        int colIndex = 0;
        Object _obj = null;
        BigDecimal _value = null;
        int sheetSize = _book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            _sheet = _book.getSheet(sheetIndex);
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    hasBgFormula = BgNFSHelper.checkHasFormulaOfCell((Cell)_cell);
                    if (!hasBgFormula || BgNFSHelper.checkIsEmptyValue((Cell)_cell)) continue;
                    _obj = BgNFSHelper.getValue((Cell)_cell);
                    if (_obj != null) {
                        if (_obj instanceof BigDecimal) {
                            _value = (BigDecimal)_obj;
                        } else {
                            try {
                                _value = new BigDecimal(_obj.toString().trim().replaceAll(",", ""));
                            }
                            catch (Exception ex) {
                                _value = BgNConstants.ZERO;
                            }
                        }
                    } else {
                        _value = BgNConstants.ZERO;
                    }
                    if (!MBGViewListFormCommonHelper.checkCanSave((Cell)_cell, (IProvider)this, (BgScenarioType)this.getEditScenType())) continue;
                    MBGViewListFormCommonHelper.checkFormulaValue((BigDecimal)_value, (int)rowIndex, (int)colIndex);
                }
            }
        }
    }

    public void storeCombin(Sheet sheet) {
        super.storeCombin(sheet);
    }

    public void store(Sheet sheet) throws Exception {
        if (sheet == null) {
            return;
        }
        MbgViewListDesCellCollection desCellCol = this.getBgDescriptionColls(sheet.getSheetIndex());
        desCellCol.clear();
        int maxRow = sheet.getMaxRowIndex();
        int maxCol = sheet.getMaxColIndex();
        for (int r = 0; r <= maxRow; ++r) {
            for (int c = 0; c <= maxCol; ++c) {
                Cell cell = sheet.getCell(r, c, false);
                ItemFormula formula = BgNFSHelper.getItemFormula((Cell)cell);
                if (formula != null) {
                    BgNViewDataInfo data;
                    BigDecimal value;
                    String version = formula.getExt("Version");
                    if (this.checkVersion(version)) continue;
                    String orgId = formula.getExt("ORGUNITID");
                    if (this.getMultiOrgFormulasMap() != null) {
                        if (!this.getMultiOrgFormulasMap().containsKey(orgId)) {
                            this.getMultiOrgFormulasMap().put(orgId, new HashSet());
                        }
                        ((Set)this.getMultiOrgFormulasMap().get(orgId)).add(formula.getFormula());
                    }
                    if ((value = BgViewHelper.getNumeric((Cell)cell, null)) != null) {
                        data = this.getData(this.getBgDataMap(), orgId, formula.getFormula(), version, true);
                        if (this.checkUpdataValueByTime(cell, data).booleanValue()) {
                            this.storeDataValue(value, data);
                        }
                    } else {
                        data = this.getData(this.getBgDataMap(), orgId, formula.getFormula(), version, false);
                        if (data != null && this.checkUpdataValueByTime(cell, data).booleanValue()) {
                            this.storeDataValue(value, data);
                        }
                    }
                    if (data != null) {
                        data.setCanSave(this.isCanEditBgData(cell, formula.getFormula(), data, orgId, (IMbgViewBase)this.getBgViewManagerForMulOrg().get(formula.getExt("ORGUNIT")), sheet.getSheetIndex(), version));
                    }
                }
                this.storeDesCellValue(cell, desCellCol, false);
                this.storeEditNote(cell);
            }
        }
    }

    private void storeEditNote(Cell cell) throws Exception {
        if (ViewListHelper.checkIsEditNoteCell((Cell)cell)) {
            String value = null;
            if (cell != null && BgNFSHelper.getValue((Cell)cell) != null && (value = String.valueOf(BgNFSHelper.getValue((Cell)cell))).length() > 1999) {
                int isComfirm = MsgBox.showConfirm2((Component)this.getOwner(), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgNFormResource", (String)"editNoteLong"));
                if (MsgBox.isYes((int)isComfirm)) {
                    value = value.substring(0, 2000);
                    BgNFSHelper.setValue((Cell)cell, (Object)value);
                } else {
                    SysUtil.abort();
                }
            }
            if (value == null) {
                this.getEditNotes().remove(cell.getSheet().getSheetIndex());
            } else {
                this.getEditNotes().put(cell.getSheet().getSheetIndex(), value);
            }
        }
    }

    protected boolean isHasDefaultDesc() {
        return true;
    }

    protected BgPeriodInfo getBgPeriod() {
        return this.getBgCslForm().getBgPeriod();
    }

    protected BOSUuid getBgTemplateId() {
        return this.getBgCslForm().getBgCslTemplate().getId();
    }

    protected BOSUuid getBgPeriodId() {
        return this.getBgCslForm().getBgPeriod().getId();
    }

    protected BOSUuid getBgVersionId() {
        return this.getBgCslForm().getBgVersion().getId();
    }

    protected BOSUuid getCurrencyId() {
        return this.getBgCslForm().getCurrency().getId();
    }

    protected void storeDataValue(BigDecimal value, BgNViewDataInfo data) throws EASBizException, BOSException {
        DimensionCacheHelper cachehelper = this.getCheckFactory().getCacheHelper();
        if (cachehelper.getBudgetScens().contains(data.getBgScenario())) {
            data.setBudgetValue(value);
        } else {
            data.setBizActual(value);
        }
    }

    protected Boolean checkUpdataValueByTime(Cell cell, BgNViewDataInfo data) {
        return BgNFSHelper.checkUpdataValueByTime((Cell)cell, (BgNDataInfo)data);
    }

    protected boolean checkVersion(String versionNum) {
        return versionNum == null || this.getBgCslForm() == null || !versionNum.equals(this.getBgCslForm().getBgVersion().getNumber());
    }

    public String getOrgNumsForCurSheet(int sheetIndex, Set<String> orgNums) {
        String curOrgNumForDimensionData = null;
        if (this.getCurMbgViewManager() == null || ((MbgViewListManager)this.getCurMbgViewManager()).getSheetManagers().size() <= sheetIndex) {
            return null;
        }
        boolean isorgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView((IBgDimensionManagerBase)((MbgViewListSheetManager)((MbgViewListManager)this.getCurMbgViewManager()).getSheetManagers().get(sheetIndex)).getDimensionManager());
        if (isorgOnPageOrView) {
            List pageF7List;
            List viewF7List = this.getViewF7List(sheetIndex);
            Object data = null;
            if (viewF7List != null) {
                for (int i = 0; i < viewF7List.size(); ++i) {
                    if (!MBGLayoutConstants.BG_ORGANIZATION.equalsIgnoreCase(((KDPromptBox)viewF7List.get(i)).getName())) continue;
                    data = ((KDPromptBox)viewF7List.get(i)).getData();
                    if (data instanceof OrgUnitInfo) {
                        orgNums.add(((OrgUnitInfo)data).getNumber());
                        curOrgNumForDimensionData = ((OrgUnitInfo)data).getNumber();
                        continue;
                    }
                    if (!(data instanceof BgOrgUnitInfo)) continue;
                    orgNums.add(((BgOrgUnitInfo)data).getNumber());
                    curOrgNumForDimensionData = ((BgOrgUnitInfo)data).getNumber();
                }
            }
            if ((pageF7List = this.getPageF7List(sheetIndex)) != null) {
                for (int i = 0; i < pageF7List.size(); ++i) {
                    if (!MBGLayoutConstants.BG_ORGANIZATION.equalsIgnoreCase(((KDPromptBox)pageF7List.get(i)).getName())) continue;
                    data = ((KDPromptBox)pageF7List.get(i)).getData();
                    if (data instanceof OrgUnitInfo) {
                        orgNums.add(((OrgUnitInfo)data).getNumber());
                        curOrgNumForDimensionData = ((OrgUnitInfo)data).getNumber();
                        continue;
                    }
                    if (!(data instanceof BgOrgUnitInfo)) continue;
                    orgNums.add(((BgOrgUnitInfo)data).getNumber());
                    curOrgNumForDimensionData = ((BgOrgUnitInfo)data).getNumber();
                }
            }
        } else {
            ArrayList<BgDimensionBaseInfo> dimensions = new ArrayList<BgDimensionBaseInfo>();
            List rowCols = ((MbgViewListSheetManager)((MbgViewListManager)this.getCurMbgViewManager()).getSheetManagers().get(sheetIndex)).getDimensionManager().getRowCols();
            for (int i = 0; i < rowCols.size(); ++i) {
                if (!(rowCols.get(i) instanceof MbgViewListRowCol)) continue;
                dimensions.addAll(((MbgViewListRowCol)rowCols.get(i)).getDimensions());
            }
            this.getOrgMembers(orgNums, dimensions);
            curOrgNumForDimensionData = this.getOrgUnitInfo().getNumber();
        }
        if (StringUtils.isEmpty(curOrgNumForDimensionData)) {
            curOrgNumForDimensionData = this.getOrgUnitInfo().getNumber();
        }
        return curOrgNumForDimensionData;
    }

    public FullOrgUnitInfo getOrgUnitForCurSheet(int sheetIndex) {
        String orgNum = this.getOrgNumsForCurSheet(sheetIndex, new HashSet<String>());
        if (this.orgUnitMap != null) {
            return (FullOrgUnitInfo)this.orgUnitMap.get(orgNum);
        }
        return null;
    }

    public BgSchemeInfo getBgSchemeInfo() {
        return this.getBgCslForm().getBgScheme();
    }

    public ICoreBase getBizInterface() throws Exception {
        IBgCslForm iCoreBase = null;
        iCoreBase = this.getCtx() == null ? BgCslFormFactory.getRemoteInstance() : BgCslFormFactory.getLocalInstance(this.getCtx());
        return iCoreBase;
    }

    public void store(Object obj) throws Exception {
    }

    public void fillData(Book book) throws Exception {
        if (book != null) {
            Boolean isBookHasFormula = BgNFSHelper.checkBookHasFormula((Book)book);
            Map<String, Map<String, BgNViewDataInfo>> dataMap = isBookHasFormula != false ? this.getDimData(book, false) : null;
            for (int s = 0; s < book.getSheetCount(); ++s) {
                this.fillBgDataValue(book.getSheet(s), dataMap, null, this.queryDescMap(book.getSheet(s)), this.queryEditNote(s));
            }
            if (isBookHasFormula.booleanValue()) {
                BgCommentCommonHelper.fillBgComments((Context)this.getCtx(), (Book)book, (IDimDataQuery)this.getBgCslForm(), (String)this.getOrgViewId(), (IMbgViewBase)this.getCurMbgViewManager());
            }
        }
        BgNFSHelper.enableUndo((Book)book);
    }

    public void fillData(Sheet sheet, Map<String, Map<String, BgNViewDataInfo>> tmpData) throws Exception {
        HashMap<String, List<IBgDimensionManagerBase>> dimensionManagers = new HashMap<String, List<IBgDimensionManagerBase>>();
        this.collectDimesionManagersForQuery(sheet.getSheetIndex(), dimensionManagers);
        sheet.setUserObject("dimensionManagers", dimensionManagers);
        Map<String, Map<String, BgNViewDataInfo>> dataMap = this.queryData(dimensionManagers);
        this.fillBgDataValue(sheet, dataMap, tmpData, this.queryDescMap(sheet), this.queryEditNote(sheet.getSheetIndex()));
        BgCommentCommonHelper.fillBgComments((Context)this.getCtx(), (Book)sheet.getBook(), (IDimDataQuery)this.getBgCslForm(), (String)this.getOrgViewId(), (IMbgViewBase)this.getCurMbgViewManager());
        this.dealCalculateColFormula(sheet);
    }

    protected void fillBgDataValue(Sheet sheet, Map<String, Map<String, BgNViewDataInfo>> dataMap, Map<String, Map<String, BgNViewDataInfo>> tmpDataMap, Map<String, Map<String, Map<String, MbgViewListDesCellInfo>>> descMap, String editNote) throws Exception {
        long ct = System.currentTimeMillis();
        logger.info((Object)("start fillBgDataValue:" + ct));
        if (sheet == null) {
            return;
        }
        Cell cell = null;
        ItemFormula formula = null;
        String cellOrgId = null;
        BgNViewDataInfo dataValue = null;
        BgSheetRange lockRange = new BgSheetRange(sheet);
        BgSheetRange lockAndBlackColorRange = new BgSheetRange(sheet);
        BgSheetRange unLockRange = new BgSheetRange(sheet);
        BgNFSHelper.disableUndo((Book)sheet.getBook());
        BgNFSHelper.disableCal((Book)sheet.getBook());
        boolean isorgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView((IBgDimensionManagerBase)((MbgViewListSheetManager)((MbgViewListManager)this.getCurMbgViewManager()).getSheetManagers().get(sheet.getSheetIndex())).getDimensionManager());
        HashSet<String> orgNums = new HashSet<String>();
        String curOrgNumForDimensionData = this.getOrgNumsForCurSheet(sheet.getSheetIndex(), orgNums);
        String selFormulaStr = null;
        int selRowIndex = 0;
        int selColIndex = 0;
        if (this.getOwner() != null && this.getOwner().getUIContext() != null) {
            selFormulaStr = (String)this.getOwner().getUIContext().get("FORMULA");
        }
        for (int rowIndex = 0; rowIndex <= sheet.getMaxRowIndex(); ++rowIndex) {
            for (int colIndex = 0; colIndex <= sheet.getMaxColIndex(); ++colIndex) {
                cell = sheet.getCell(rowIndex, colIndex, false);
                formula = BgNFSHelper.getItemFormula((Cell)cell);
                if (formula != null) {
                    Boolean isCanEditBgData;
                    String version = formula.getExt("Version");
                    cellOrgId = formula.getExt("ORGUNITID");
                    dataValue = this.getData(tmpDataMap, cellOrgId, formula.getFormula(), version, false);
                    if (dataValue == null) {
                        dataValue = this.getData(dataMap, cellOrgId, formula.getFormula(), version, false);
                    }
                    if (dataValue != null) {
                        this.setDataValueToCell(cell, dataValue);
                        this.addToMap(cellOrgId, formula.getFormula(), version, dataValue, this.getBgDataMap());
                    } else {
                        this.setDataValueToCell(cell, null);
                    }
                    MbgViewListManager viewManager = (MbgViewListManager)this.getBgViewManagerForMulOrg().get(formula.getExt("ORGUNIT"));
                    if (viewManager == null && !isorgOnPageOrView && curOrgNumForDimensionData != null) {
                        viewManager = (MbgViewListManager)this.getBgViewManagerForMulOrg().get(curOrgNumForDimensionData);
                    }
                    if (!(isCanEditBgData = Boolean.valueOf(this.isCanEditBgData(cell, formula.getFormula(), dataValue, cellOrgId, (IMbgViewBase)viewManager, sheet.getSheetIndex(), version))).booleanValue()) {
                        if (!cell.isLocked()) {
                            if (cell.getStyle().getBackground() == null || BgNConstants.BASE_COLOR.equals(cell.getStyle().getBackground()) || cell.getStyle().getBackground().getRGB() == -1) {
                                lockAndBlackColorRange.addCell(rowIndex, colIndex);
                            } else {
                                lockRange.addCell(rowIndex, colIndex);
                            }
                        }
                    } else if (ViewlistCombinHelper.checkRowIsCombin((Cell)cell).booleanValue() && !ViewlistCombinHelper.checkCombinRowFullofMembers((Row)cell.getRowObject(), (Boolean)false)) {
                        lockRange.addCell(rowIndex, colIndex);
                    } else if (MBGViewListFormCommonHelper.isCellReadonly((Cell)cell, (MbgViewListManager)((MbgViewListManager)this.getCurMbgViewManager()), (boolean)false)) {
                        lockRange.addCell(rowIndex, colIndex);
                    } else if (cell.isLocked()) {
                        unLockRange.addCell(rowIndex, colIndex);
                    }
                    if (selFormulaStr != null && formula.getFormula().equals(selFormulaStr)) {
                        selRowIndex = rowIndex;
                        selColIndex = colIndex;
                    }
                }
                this.fillDescriptions(cell, descMap);
                this.fillEditNote(cell, editNote);
            }
        }
        this.dealCalculateColFormula(sheet);
        this.setLocked(lockAndBlackColorRange);
        BgViewHelper.setLocked((boolean)true, (Range)lockRange.getRange());
        BgViewHelper.setLocked((boolean)false, (Range)unLockRange.getRange());
        BgNFSHelper.enableUndo((Book)sheet.getBook());
        if (selFormulaStr != null && selRowIndex > 0 && selColIndex > 0) {
            sheet.getRange(selRowIndex, selColIndex).select();
            BgNFSHelper.setBackGroup((Cell)sheet.getCell(selRowIndex, selColIndex, false), (Color)Color.RED);
        }
        logger.info((Object)("fillBgDataValue: " + (System.currentTimeMillis() - ct) + "ms"));
    }

    protected void setLocked(BgSheetRange lockRange) {
        BgViewHelper.setLockedAndBackgroud((boolean)true, (Range)lockRange.getRange());
    }

    protected final void dealCalculateColFormula(Sheet sheet) throws Exception {
        if (sheet != null) {
            this.dealCalculateColFormula(sheet, sheet.getSheetRange());
        }
    }

    public final void dealCalculateColFormula(Sheet sheet, Range range) throws Exception {
        long ct = System.currentTimeMillis();
        if (sheet == null || range == null || range.isEmpty()) {
            return;
        }
        if (this.getCalcRowSet() != null) {
            this.getCalcRowSet().clear();
        }
        Column column = null;
        Object bgCalcuteColumn = null;
        Row row = null;
        ArrayList<BgDimensionMember> _allMembers = null;
        Object _members = null;
        Cell cell = null;
        List viewMembers = BgViewHelper.getCurrPageMember((List)this.getViewF7List(sheet.getSheetIndex()), (List)this.getDimensionDataForCurSheet(sheet.getSheetIndex()).getDimensionManager().getViewDimension());
        List pageMembers = BgViewHelper.getCurrPageMember((List)this.getPageF7List(sheet.getSheetIndex()), (List)this.getDimensionDataForCurSheet(sheet.getSheetIndex()).getDimensionManager().getPageDimension());
        String orgNumber = null;
        MbgViewListCalcutor _calc = null;
        Object _rowobj = null;
        boolean isRow = false;
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        List<BgDimensionMember> memberList = null;
        List dimension = ((MbgViewListSheetManager)this.getCurMbgSheetManager()).getDimensionManager().getAllDimensions();
        Object bgDimensionMember = null;
        int startRowIndex = 0;
        int maxRowIndex = sheet.getMaxRowIndex();
        if (range.getBounds() != null && range.getBounds().getRow() > 0 && range.getBounds().getRow2() < maxRowIndex) {
            startRowIndex = range.getBounds().getRow();
            maxRowIndex = range.getBounds().getRow2();
        }
        for (int colIndex = 0; colIndex <= sheet.getMaxColIndex(); ++colIndex) {
            column = sheet.getColumn(colIndex, false);
            for (int rowIndex = startRowIndex; rowIndex <= maxRowIndex; ++rowIndex) {
                String obj;
                row = sheet.getRow(rowIndex, false);
                cell = sheet.getCell(rowIndex, colIndex, false);
                if (BgNFSHelper.getExpression((Cell)cell) == null) continue;
                String function = (String)BgNFSHelper.getCellData((Cell)cell, (String)"initExpression");
                if (function == null) {
                    function = BgNFSHelper.getExpression((Cell)cell);
                }
                Expression parse = ExcelFormulaPaserHelper.parse((String)function);
                _allMembers = new ArrayList<BgDimensionMember>();
                if (viewMembers != null) {
                    _allMembers.addAll(viewMembers);
                }
                if (pageMembers != null) {
                    _allMembers.addAll(pageMembers);
                }
                boolean isCalculateFirstByRow = true;
                if (cell != null && BgNFSHelper.getCellExtData((Cell)cell, (String)"isCalculateFirstByRow") instanceof Boolean) {
                    isCalculateFirstByRow = (Boolean)BgNFSHelper.getCellExtData((Cell)cell, (String)"isCalculateFirstByRow");
                }
                boolean calcRow = true;
                if (ViewListHelper.getDimension((Row)row) instanceof MbgViewListCalcutor && ViewListHelper.getDimension((Row)row) instanceof MbgViewListCalcutor) {
                    calcRow = isCalculateFirstByRow;
                } else if ((!(ViewListHelper.getDimension((Row)row) instanceof MbgViewListCalcutor) || ViewListHelper.getDimension((Row)row) instanceof MbgViewListCalcutor) && !(ViewListHelper.getDimension((Row)row) instanceof MbgViewListCalcutor) && ViewListHelper.getDimension((Row)row) instanceof MbgViewListCalcutor) {
                    calcRow = false;
                }
                if (ViewListHelper.getDimension((Row)row) instanceof MbgViewListCalcutor && calcRow) {
                    memberList = Arrays.asList(ViewListHelper.getDimensionMember((Column)column));
                    _allMembers.addAll(memberList);
                    boolean isHasAcctAndRight = BgNExpressionHelper.checkExpressionAcct((Expression)parse, _allMembers);
                    if (isHasAcctAndRight) {
                        this.parseMember(_allMembers, dimension);
                    }
                    _calc = (MbgViewListCalcutor)ViewListHelper.getDimension((Row)row);
                    isRow = true;
                    if (!this.getCalcRowSet().contains(row)) {
                        this.getCalcRowSet().add(row);
                    }
                } else if (ViewListHelper.getDimension((Column)column) instanceof MbgViewListCalcutor) {
                    memberList = ViewListHelper.getDimensionMember((Row)row) != null ? Arrays.asList(ViewListHelper.getDimensionMember((Row)row)) : new ArrayList<BgDimensionMember>();
                    _allMembers.addAll(memberList);
                    boolean isHasAcctAndRight = BgNExpressionHelper.checkExpressionAcct((Expression)parse, _allMembers);
                    if (isHasAcctAndRight) {
                        this.parseMember(_allMembers, dimension);
                    }
                    _calc = (MbgViewListCalcutor)ViewListHelper.getDimension((Column)column);
                    isRow = false;
                }
                Iterator iter = _allMembers.iterator();
                while (iter.hasNext()) {
                    BgDimensionMember next = (BgDimensionMember)iter.next();
                    if (!DimensionBaseConstants.DEF_CSL_Consolidation.equals(next.getType())) continue;
                    iter.remove();
                }
                String itemCombine = this.getItemCombine(_allMembers);
                long cc = System.currentTimeMillis();
                orgNumber = this.getOrgNumber(_allMembers);
                if (_calc != null && orgNumber == null && !((MbgViewListSheetManager)this.getCurMbgSheetManager()).isRowColShowbyTemp()) {
                    BgDimensionMember orgMem;
                    MbgViewListRowCol cRow;
                    if (isRow) {
                        int cr;
                        for (cr = rowIndex - 1; cr >= 0; --cr) {
                            if (!(ViewListHelper.getDimension((Row)sheet.getRow(cr, false)) instanceof MbgViewListRowCol) || (cRow = (MbgViewListRowCol)ViewListHelper.getDimension((Row)sheet.getRow(cr, false))) == null || _calc == null) continue;
                            if (cRow.getInitIndex() >= _calc.getInitIndex()) break;
                            BgDimensionMember[] dimensionMember = ViewListHelper.getDimensionMember((Row)sheet.getRow(cr, false));
                            BgDimensionMember orgMem2 = null;
                            if (null != dimensionMember) {
                                orgMem2 = this.getOrgBgDimensionMember(Arrays.asList(dimensionMember));
                            }
                            if (orgMem2 != null) {
                                _allMembers.add(orgMem2);
                                orgNumber = orgMem2.getNumber();
                                break;
                            }
                            orgNumber = "";
                            break;
                        }
                        if (orgNumber == null) {
                            for (cr = rowIndex + 1; cr <= sheet.getMaxRowIndex(); ++cr) {
                                if (!(ViewListHelper.getDimension((Row)sheet.getRow(cr, false)) instanceof MbgViewListRowCol) || (cRow = (MbgViewListRowCol)ViewListHelper.getDimension((Row)sheet.getRow(cr, false))) == null || _calc == null) continue;
                                if (cRow.getInitIndex() <= _calc.getInitIndex()) break;
                                orgMem = this.getOrgBgDimensionMember(Arrays.asList(ViewListHelper.getDimensionMember((Row)sheet.getRow(cr, false))));
                                if (orgMem != null) {
                                    _allMembers.add(orgMem);
                                    orgNumber = orgMem.getNumber();
                                } else {
                                    orgNumber = "";
                                }
                                break;
                            }
                        }
                    } else {
                        int cr;
                        for (cr = colIndex - 1; cr >= 0; --cr) {
                            if (!(ViewListHelper.getDimension((Column)sheet.getColumn(cr, false)) instanceof MbgViewListRowCol) || (cRow = (MbgViewListRowCol)ViewListHelper.getDimension((Column)sheet.getColumn(cr, false))) == null || _calc == null) continue;
                            if (cRow.getInitIndex() >= _calc.getInitIndex()) break;
                            orgMem = this.getOrgBgDimensionMember(Arrays.asList(ViewListHelper.getDimensionMember((Column)sheet.getColumn(cr, false))));
                            if (orgMem != null) {
                                _allMembers.add(orgMem);
                                orgNumber = orgMem.getNumber();
                                break;
                            }
                            orgNumber = "";
                            break;
                        }
                        if (orgNumber == null) {
                            for (cr = colIndex + 1; cr <= sheet.getMaxColIndex(); ++cr) {
                                if (!(ViewListHelper.getDimension((Column)sheet.getColumn(cr, false)) instanceof MbgViewListRowCol) || (cRow = (MbgViewListRowCol)ViewListHelper.getDimension((Column)sheet.getColumn(cr, false))) == null || _calc == null) continue;
                                if (cRow.getInitIndex() <= _calc.getInitIndex()) break;
                                orgMem = this.getOrgBgDimensionMember(Arrays.asList(ViewListHelper.getDimensionMember((Column)sheet.getColumn(cr, false))));
                                if (orgMem != null) {
                                    _allMembers.add(orgMem);
                                    orgNumber = orgMem.getNumber();
                                } else {
                                    orgNumber = "";
                                }
                                break;
                            }
                        }
                    }
                }
                if (StringUtils.isEmpty((String)orgNumber) && this.getOrgUnitInfo() != null) {
                    orgNumber = this.getOrgUnitInfo().getNumber();
                }
                parameters.add(new Object[]{cell.getRow(), cell.getCol(), function, null, orgNumber, itemCombine, _allMembers, null, null});
                if (!(parse instanceof FunctionExpr)) continue;
                String funcionName = ((FunctionExpr)parse).funcionName;
                if (cell == null || !(parse instanceof FunctionExpr) || !"RPTDATE".equalsIgnoreCase(funcionName) && !"MbgRptDate".equalsIgnoreCase(funcionName) && !"MbgCreateDate".equalsIgnoreCase(funcionName) && !"MbgGetOrgNum".equalsIgnoreCase(funcionName) || (obj = cell.getStyle().getNumberFormat()) != null && "@".equals(obj)) continue;
                BgNFSHelper.setNumberFormat((Cell)cell, (String)"@");
            }
        }
        if (parameters.isEmpty()) {
            return;
        }
        Map resultExpress = this.getExpressionInterface().getExpressionMap(parameters, this.getCurMbgSheetManager(), this.model, false);
        Cell itemCell = null;
        String _expression = null;
        String[] splitRowCol = null;
        for (String item : resultExpress.keySet()) {
            splitRowCol = item.split(BgBaseConstants.SEP_FOUR_STR);
            itemCell = sheet.getCell(Integer.valueOf(splitRowCol[0]).intValue(), Integer.valueOf(splitRowCol[1]).intValue(), false);
            _expression = (String)resultExpress.get(item);
            if (_expression == null || _expression.indexOf(DimensionConstants.DEF_INDEX_SRCNUMBER + ":") < 0 && _expression.toUpperCase().indexOf("MbgAggregate".toUpperCase()) < 0 && _expression.toUpperCase().indexOf("Mbgadjust".toUpperCase()) < 0 && _expression.toUpperCase().indexOf("MbgAdjustDate".toUpperCase()) < 0 && _expression.toUpperCase().indexOf("MbgActualDay".toUpperCase()) < 0 && _expression.toUpperCase().indexOf("MbgBgAvlBal".toUpperCase()) < 0 && _expression.toUpperCase().indexOf("MbgRefBgTem".toUpperCase()) < 0 && _expression.toUpperCase().indexOf("MbgRefBgForm".toUpperCase()) < 0 && _expression.toUpperCase().indexOf("ACCT".toUpperCase()) < 0 && _expression.toUpperCase().indexOf("ElimData".toUpperCase()) < 0 && _expression.toUpperCase().indexOf("MbgCorUnit".toUpperCase()) < 0 && _expression.toUpperCase().indexOf("MbgCsl".toUpperCase()) < 0) continue;
            itemCell.setFormula(_expression);
            itemCell.setValue(itemCell.getValue());
        }
        logger.info((Object)("dealCalculateColFormula:" + (System.currentTimeMillis() - ct) + "(ms)"));
    }

    private BgDimensionMember getOrgBgDimensionMember(List<BgDimensionMember> _allMembers) {
        if (_allMembers != null && !_allMembers.isEmpty()) {
            for (int i = 0; i < _allMembers.size(); ++i) {
                if (!DimensionConstants.DEF_ORGUNIT_NUMBER.equals(_allMembers.get(i).getType())) continue;
                return _allMembers.get(i);
            }
        }
        return null;
    }

    public MbgViewListSheetManager getDimensionDataForCurSheet(int sheetIndex) throws Exception {
        String orgNum = this.getOrgNumsForCurSheet(sheetIndex, new HashSet<String>());
        MbgViewListManager viewListManager = (MbgViewListManager)this.getBgViewManagerForMulOrg().get(orgNum);
        if (viewListManager == null) {
            HashSet<String> orgNumsSet = new HashSet<String>();
            orgNumsSet.add(orgNum);
            this.addBgViewManagerForMultiOrg(orgNumsSet);
        }
        if ((viewListManager = (MbgViewListManager)this.getBgViewManagerForMulOrg().get(orgNum)) == null) {
            return null;
        }
        return (MbgViewListSheetManager)viewListManager.getSheetManagers().get(sheetIndex);
    }

    protected void fillEditNote(Cell cell, String editNote) {
        if (ViewListHelper.checkIsEditNoteCell((Cell)cell)) {
            BgNFSHelper.setValue((Cell)cell, (Object)editNote);
            BgNFSHelper.setUserObject((Cell)cell, (String)"oldValue", (String)editNote);
        }
    }

    public boolean isCanEditBgData(Cell cell, String formula, BgNViewDataInfo bgData, String orgUnitId, IMbgViewBase view, int sheetIndex, String version) throws EASBizException, BOSException {
        DimensionMemberCheckFactory factory;
        DimensionMemberCheckHelper helper;
        if (version == null || this.getBgCslForm() == null || this.getBgCslForm().getBgVersion() == null || !version.equals(this.getBgCslForm().getBgVersion().getNumber())) {
            return false;
        }
        boolean isInWfEdit = false;
        Object obj = null;
        if (this.getOwner() != null) {
            obj = this.getOwner().getUIContext().get("Owner");
        }
        if (OprtState.EDIT.equals(this.getOwner().getOprtState()) && obj != null && obj instanceof MessageCenterUI) {
            isInWfEdit = true;
        }
        boolean check = (helper = (factory = this.getCheckFactory()).getHelper(this.getBgCslForm().getBgScheme().getOrgUnit().getId().toString(), view)).canSave(formula, helper.getEditScen((IMbgViewBase)((MbgViewListManager)view), sheetIndex, this.getEditScenType()), version) || helper.canSave(formula, helper.getEditScen((IMbgViewBase)((MbgViewListManager)view), sheetIndex, this.getEditActaulScenType()), version);
        boolean dataCanEdit = check && (bgData == null || 1 == bgData.getState() || 0 == bgData.getState() || isInWfEdit && 3 == bgData.getState());
        return dataCanEdit && this.isCanEditByOtherForm(orgUnitId) && this.isContainsFormula(formula, orgUnitId) && this.isCanEditByFormState(orgUnitId);
    }

    protected boolean isCanEditByOtherForm(String orgId) {
        if (StringUtils.isEmpty((String)orgId)) {
            return true;
        }
        if (!((MbgViewListSheetManager)this.getCurMbgSheetManager()).isCanEditOtherAddedBgForm().booleanValue()) {
            String currentOrgId = this.getBgCslForm().getOrgUnit().getId().toString();
            return currentOrgId.equals(orgId);
        }
        return true;
    }

    public boolean isCanEditByFormState(String orgId) {
        if (orgId == null) {
            return true;
        }
        if ((BgCslFormStateEnum.APPROVING.equals((Object)this.orgIdFormState.get(orgId)) || BgCslFormStateEnum.REFERRING.equals((Object)this.orgIdFormState.get(orgId))) && !this.checkInProInst(orgId)) {
            return true;
        }
        return this.orgIdFormState.get(orgId) == null || BgCslFormStateEnum.EDIT.equals((Object)this.orgIdFormState.get(orgId));
    }

    protected boolean checkInProInst(String orgId) {
        if (this.orgFormInPorInst.containsKey(orgId)) {
            return this.orgFormInPorInst.get(orgId);
        }
        try {
            if (this.orgIdBgForm.get(orgId) != null) {
                boolean isInPorInst = BgFormHelper.checkInProInst((Context)this.getCtx(), (String)this.orgIdBgForm.get(orgId).getId().toString());
                this.orgFormInPorInst.put(orgId, isInPorInst);
                return isInPorInst;
            }
            if (this.getBgCslForm() != null && this.getBgCslForm().getId() != null && this.getBgCslForm().getOrgUnit() != null) {
                String cuOrgId = this.getBgCslForm().getOrgUnit().getId().toString();
                if (this.orgFormInPorInst.get(cuOrgId) != null) {
                    return this.orgFormInPorInst.get(cuOrgId);
                }
                boolean isInPorInst = BgFormHelper.checkInProInst((Context)this.getCtx(), (String)this.getBgCslForm().getId().toString());
                this.orgFormInPorInst.put(orgId, isInPorInst);
                return isInPorInst;
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            return false;
        }
        return false;
    }

    protected void getOrgIdFormStateMap() throws EASBizException, BOSException {
        Set<String> orgIdSetByCurManager = this.getOrgIdSetByCurManager();
        BgCslFormInfo bgFormInfo = this.getBgCslForm();
        if (bgFormInfo != null && bgFormInfo.getId() != null && orgIdSetByCurManager != null && !orgIdSetByCurManager.isEmpty()) {
            if (bgFormInfo.getBgScheme() == null || bgFormInfo.getOrgTree() == null || bgFormInfo.getBgCslTemplate() == null || bgFormInfo.getBgPeriod() == null || bgFormInfo.getBgVersion() == null || bgFormInfo.getCurrency() != null) {
                // empty if block
            }
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("id");
            evi.getSelector().add("number");
            evi.getSelector().add("name");
            evi.getSelector().add("orgunit.id");
            evi.getSelector().add("orgunit.name");
            evi.getSelector().add("state");
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgFormInfo.getBgScheme().getId().toString(), CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("orgTree.id", (Object)bgFormInfo.getOrgTree().getId().toString(), CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("BgCslTemplate.id", (Object)bgFormInfo.getBgCslTemplate().getId().toString(), CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("BgPeriod.id", (Object)bgFormInfo.getBgPeriod().getId().toString(), CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("BgVersion.id", (Object)bgFormInfo.getBgVersion().getId().toString(), CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("Currency.id", (Object)bgFormInfo.getCurrency().getId().toString(), CompareType.EQUALS));
            IBgCslForm iBgCslForm = null;
            iBgCslForm = this.getCtx() == null ? BgCslFormFactory.getRemoteInstance() : BgCslFormFactory.getLocalInstance(this.getCtx());
            BgCslFormCollection colls = iBgCslForm.getBgCslFormCollection(evi);
            if (colls != null && !colls.isEmpty()) {
                for (int i = 0; i < colls.size(); ++i) {
                    this.orgIdFormState.put(colls.get(i).getOrgUnit().getId().toString(), colls.get(i).getState());
                }
            }
        }
    }

    protected Set<String> getOrgIdSetByCurManager() {
        HashSet<String> orgIdSet = new HashSet<String>();
        if (this.getCurMbgViewManager() != null) {
            MbgViewListSheetManager sheetManger = null;
            Map<String, String> orgIdAndNumMap = null;
            for (int sheetIndex = 0; sheetIndex < ((MbgViewListManager)this.getCurMbgViewManager()).getSheetManagers().size(); ++sheetIndex) {
                sheetManger = (MbgViewListSheetManager)((MbgViewListManager)this.getCurMbgViewManager()).getSheetManagers().get(sheetIndex);
                orgIdAndNumMap = this.getOrgIdAndNumMap(sheetManger.getDimensionManager().getAllDimensions());
                orgIdSet.addAll(orgIdAndNumMap.keySet());
            }
        }
        return orgIdSet;
    }

    public Map<String, String> getOrgIdAndNumMap(List<MbgViewListDimensionInfo> dimensions) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        BgDimensionMember member = null;
        for (int i = 0; i < dimensions.size(); ++i) {
            if (!MBGLayoutConstants.BG_ORGANIZATION.equals(dimensions.get(i).getNumber())) continue;
            for (int j = 0; j < dimensions.get(i).getMember().size(); ++j) {
                member = (BgDimensionMember)dimensions.get(i).getMember().get(j);
                try {
                    if (this.getSchemeHelper().getRefDims().contains(member.getAttribute())) continue;
                    returnMap.put(member.getAttribute(), member.getNumber());
                    continue;
                }
                catch (EASBizException e) {
                    logger.error((Object)"", (Throwable)e);
                    SysUtil.abort();
                    continue;
                }
                catch (BOSException e) {
                    logger.error((Object)"", (Throwable)e);
                    SysUtil.abort();
                }
            }
        }
        return returnMap;
    }

    protected boolean isContainsFormula(String formula, String orgUnitId) {
        String curOrgId = this.getBgCslForm().getOrgUnit().getId().toString();
        if (StringUtils.isEmpty((String)orgUnitId) || curOrgId.equals(orgUnitId) || StringUtils.isEmpty((String)formula)) {
            return true;
        }
        return this.getMultiOrgFormulasMap() == null || this.getMultiOrgFormulasMap().isEmpty() || !this.getMultiOrgFormulasMap().containsKey(orgUnitId) || ((Set)this.getMultiOrgFormulasMap().get(orgUnitId)).isEmpty() || ((Set)this.getMultiOrgFormulasMap().get(orgUnitId)).contains(formula);
    }

    public void addToMap(String orgId, String formula, String version, BgNViewDataInfo dataInfo, Map<String, Map<String, BgNViewDataInfo>> dataMap) {
        if (StringUtils.isEmpty((String)orgId) || StringUtils.isEmpty((String)formula) || dataInfo == null || dataMap == null) {
            return;
        }
        if (!dataMap.containsKey(orgId)) {
            dataMap.put(orgId, new HashMap());
        }
        dataMap.get(orgId).put(formula + "_" + version, dataInfo);
    }

    protected void setDataValueToCell(Cell cell, BgNViewDataInfo dataValue) {
        DimensionCacheHelper cachehelper = this.getCheckFactory().getCacheHelper();
        MBGViewListFormCommonHelper.setDataValueToCell((Cell)cell, (BgNViewDataInfo)dataValue, (DimensionCacheHelper)cachehelper, (int)this.getDataType());
    }

    protected BgNViewDataInfo getData(Map bgDataMap, String orgId, String formula, String versionNumber, boolean isCreate) {
        return MBGViewListFormCommonHelper.getData((Map)bgDataMap, (String)orgId, (String)formula, (String)versionNumber, (boolean)isCreate);
    }

    protected String queryEditNote(int sheetIndex) throws BOSException {
        String editNote = null;
        MbgViewListEditNoteCollection colls = null;
        IMbgViewListEditNote iMbgViewListEditNote = null;
        iMbgViewListEditNote = this.getCtx() == null ? MbgViewListEditNoteFactory.getRemoteInstance() : MbgViewListEditNoteFactory.getLocalInstance((Context)this.getCtx());
        if (this.getOwner() != null && this.getOwner().getOprtState() != null && this.getOwner().getOprtState().equals(OprtState.ADDNEW)) {
            colls = iMbgViewListEditNote.getMbgViewListEditNoteCollection("select value where bgTemplateId = '" + this.getBgCslForm().getBgCslTemplate().getId().toString() + "' and sheetIndex = " + sheetIndex);
            if (colls != null && !colls.isEmpty()) {
                editNote = colls.get(0).getValue();
            }
        } else {
            colls = iMbgViewListEditNote.getMbgViewListEditNoteCollection("select value where bgFormId = '" + this.getBgCslForm().getId().toString() + "' and sheetIndex = " + sheetIndex);
            if (colls != null && !colls.isEmpty()) {
                editNote = colls.get(0).getValue();
            }
        }
        return editNote;
    }

    public Map<String, Map<String, Map<String, MbgViewListDesCellInfo>>> queryDescMap(Sheet sheet) throws Exception {
        HashMap<String, Map<String, Map<String, MbgViewListDesCellInfo>>> desMap = new HashMap<String, Map<String, Map<String, MbgViewListDesCellInfo>>>();
        String bgSchemeId = this.getBgSchemeId();
        String bgTemplateId = this.getBgCslForm().getBgCslTemplate().getId().toString();
        String versionId = this.getBgCslForm().getBgVersion().getId().toString();
        String bgPeriodId = this.getBgCslForm().getBgPeriod().getId().toString();
        String currencyId = this.getBgCslForm().getCurrency().getId().toString();
        Object actualPeriodId = null;
        Map queryMap = MbgViewListDescriptionHelper.getQueryMap((Sheet)sheet);
        HashSet orgids = new HashSet();
        orgids.addAll(queryMap.keySet());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("bgSchemeId", (Object)bgSchemeId, CompareType.EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("bgTemplateId", (Object)bgTemplateId, CompareType.EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("versionId", (Object)versionId, CompareType.EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("bgPeriodId", (Object)bgPeriodId, CompareType.EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("actualPeriodId", actualPeriodId, CompareType.EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("currencyId", (Object)currencyId, CompareType.EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("sheetIndex", (Object)sheet.getSheetIndex(), CompareType.EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("orgUnitId", orgids, CompareType.INCLUDE));
        IMbgViewListDesCell iMbgViewListDesCell = null;
        iMbgViewListDesCell = this.getCtx() == null ? MbgViewListDesCellFactory.getRemoteInstance() : MbgViewListDesCellFactory.getLocalInstance((Context)this.getCtx());
        MbgViewListDesCellCollection colls = iMbgViewListDesCell.getMbgViewListDesCellCollection(view);
        if (colls != null && !colls.isEmpty()) {
            MbgViewListDesCellInfo info = null;
            for (int index = 0; index < colls.size(); ++index) {
                info = colls.get(index);
                String orgId = info.getOrgUnitId().toString();
                String rowColIndex = String.valueOf(info.getRowIndex()) + ":" + String.valueOf(info.getColIndex());
                String memberNumber = info.getMemberNumber();
                rowColIndex = rowColIndex + "@" + memberNumber;
                if (!desMap.containsKey(orgId)) {
                    desMap.put(orgId, new HashMap());
                }
                if (!BgViewHelper.getSubMap((Map)((Map)desMap.get(orgId)), (String)rowColIndex, (boolean)true).containsKey(rowColIndex)) {
                    ((Map)desMap.get(orgId)).put(rowColIndex, new HashMap());
                }
                if (((Map)((Map)desMap.get(orgId)).get(rowColIndex)).containsKey(memberNumber)) continue;
                ((Map)((Map)desMap.get(orgId)).get(rowColIndex)).put(memberNumber, info);
            }
        }
        return desMap;
    }

    private void fillDataClear(Book book) {
        this.getBgDataMap().clear();
        BgNFSHelper.disableCal((Book)book);
        BgNFSHelper.disableUndo((Book)book);
    }

    public Map<String, Map<String, BgNViewDataInfo>> getDimData(Book book, boolean isSynch) throws Exception {
        this.fillDataClear(book);
        Map<String, Map<String, BgNViewDataInfo>> dataMap = null;
        if (book != null) {
            Map<String, List<IBgDimensionManagerBase>> dimensionManager = this.getDimensionManagerForQuery(book);
            dataMap = this.queryData(dimensionManager, isSynch);
        }
        return dataMap;
    }

    public Map<String, Map<String, BgNViewDataInfo>> queryData(Map<String, List<IBgDimensionManagerBase>> dimensionManagers) throws BOSException, EASBizException {
        return this.queryDimData(dimensionManagers, false);
    }

    protected Map<String, Map<String, BgNViewDataInfo>> queryData(Map<String, List<IBgDimensionManagerBase>> dimensionManagers, boolean isSynch) throws BOSException, EASBizException {
        return this.queryDimData(dimensionManagers, isSynch);
    }

    private Map<String, Map<String, BgNViewDataInfo>> queryDimData(Map<String, List<IBgDimensionManagerBase>> dimensionManagers, boolean isSynch) throws BOSException, EASBizException {
        return this.getQueryDataHelper().queryData(this.getQueryDataInfo(), dimensionManagers, this.getDataType(), isSynch, this.getBgOrgViewId());
    }

    private Map<String, List<IBgDimensionManagerBase>> getDimensionManagerForQuery(Book book) throws EASBizException, BOSException {
        if (book == null) {
            return null;
        }
        HashMap<String, List<IBgDimensionManagerBase>> dimensionManager = new HashMap<String, List<IBgDimensionManagerBase>>();
        for (int sheetIndex = 0; sheetIndex < book.getSheetCount(); ++sheetIndex) {
            this.collectDimesionManagersForQuery(sheetIndex, dimensionManager);
        }
        this.initMutiOrgMemberCheckHelper();
        return dimensionManager;
    }

    private void initMutiOrgMemberCheckHelper() throws EASBizException, BOSException {
        if (!this.getMutiOrgOnRowColViewManagers().isEmpty()) {
            DimensionMemberCheckFactory factory = this.getCheckFactory();
            IBgCslForm iBgCslForm = null;
            iBgCslForm = this.getCtx() == null ? BgCslFormFactory.getRemoteInstance() : BgCslFormFactory.getLocalInstance(this.getCtx());
            Map checkHelpers = iBgCslForm.initMutiOrgMemberCheckHelper(this.getMutiOrgOnRowColViewManagers(), this.getSchemeHelper(), this.getCtx() == null);
            if (checkHelpers != null && !checkHelpers.isEmpty()) {
                factory.clear();
                factory.getCheckHelpers().putAll(checkHelpers);
                DimensionCacheHelper cacheHelper = factory.getCacheHelper();
                if (this.getCtx() == null) {
                    cacheHelper.clearCtx();
                }
            }
        }
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = BgCslFormHelper.getSelector();
        sic.add("orgTree.number");
        return sic;
    }

    protected BgSchemeDimensionHelper createSchemeHelper() throws EASBizException, BOSException {
        BgCslSchemeDimensionHelper schemeHelper = null;
        schemeHelper = this.getBgCslForm() != null && this.getBgCslForm().getOrgTree() != null ? new BgCslSchemeDimensionHelper(this.getCtx(), this.getBgSchemeId(), this.getBgCslForm().getOrgTree()) : new BgCslSchemeDimensionHelper(this.getCtx(), this.getBgSchemeId());
        return schemeHelper;
    }

    protected IObjectValue getQueryDataInfo() {
        return this.getBgCslForm();
    }

    protected BgScenarioType getEditScenType() {
        return BgScenarioType.BudgetData;
    }

    protected BgScenarioType getEditActaulScenType() {
        return BgScenarioType.ActualData;
    }

    protected String getVersionNumber() {
        if (this.getBgCslForm() != null && this.getBgCslForm().getBgVersion() != null) {
            return this.getBgCslForm().getBgVersion().getNumber();
        }
        return null;
    }

    protected void initQueryData(Sheet sheet) throws Exception {
    }

    public MbgViewListManager getOldMbgViewListManager() {
        return this.oldMbgViewListManager;
    }

    public void setOldMbgViewListManager(MbgViewListManager oldMbgViewListManager) {
        this.oldMbgViewListManager = DimensionCommonHelper.cloneViewManager((MbgViewListManager)oldMbgViewListManager);
    }

    public BgCslFormInfo getBgCslForm() {
        return (BgCslFormInfo)this.getEditValue();
    }

    public Map<String, Integer> getAccountDataTypeMap() {
        return this.accountDataTypeMap;
    }

    public Map<String, Integer> getMeasureUnitMap() {
        HashMap<String, Integer> measureUnitMap = new HashMap<String, Integer>();
        measureUnitMap.put("currency", MBGViewListFormCommonHelper.transMeasureUnit((int)this.getTemplateStyle().getCurrencyMeasureUnit()));
        measureUnitMap.put("noCurrency", MBGViewListFormCommonHelper.transMeasureUnit((int)this.getTemplateStyle().getNoCurrencyMeasureUnit()));
        measureUnitMap.put("rate", MBGViewListFormCommonHelper.transMeasureUnit((int)this.getTemplateStyle().getRateMeasureUnit()));
        return measureUnitMap;
    }

    public void resetAccountDataTypeMap() {
        this.accountDataTypeMap.clear();
        this.initAccountDataTypeMap();
    }

    public Map<String, Map<String, BgNViewDataInfo>> getBgDataMap() {
        return this.bgDataMap;
    }

    public Map<Integer, String> getEditNotes() {
        return this.editNotes;
    }

    protected void initAccountDataTypeMap() {
        if (this.accountDataTypeMap.isEmpty()) {
            try {
                String viewId = this.getSchemeHelper().getDimension(DimensionConstants.DEF_ACCOUNT_NUMBER).getViewId();
                if (viewId != null) {
                    IBgAccount iBgAccount = null;
                    iBgAccount = this.getCtx() == null ? BgAccountFactory.getRemoteInstance() : BgAccountFactory.getLocalInstance((Context)this.getCtx());
                    BgAccountCollection colls = iBgAccount.getBgAccountCollection("select number, bgAccountDataType where bgAccountView = '" + viewId + "'");
                    if (colls != null && !colls.isEmpty()) {
                        BgAccountInfo account = null;
                        int size = colls.size();
                        for (int index = 0; index < size; ++index) {
                            account = colls.get(index);
                            this.accountDataTypeMap.put(account.getNumber(), account.getBgAccountDataType().getValue());
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
    }

    public boolean isModifyData(Sheet sheet) throws EASBizException, BOSException {
        boolean isModify = false;
        if (sheet == null) {
            return isModify;
        }
        Cell cell = null;
        ItemFormula formula = null;
        String cellOrgId = null;
        String cellOrgNum = null;
        BgNViewDataInfo dataValue = null;
        int maxRow = sheet.getMaxRowIndex();
        int maxCol = sheet.getMaxColIndex();
        MbgViewListManager view = null;
        for (int rowIndex = 0; rowIndex <= maxRow; ++rowIndex) {
            Row row = sheet.getRow(rowIndex, false);
            if (row == null) continue;
            for (int colIndex = 0; colIndex <= maxCol; ++colIndex) {
                cell = row.getCell(colIndex, false);
                if (this.isModifyNote(cell)) {
                    return true;
                }
                formula = BgNFSHelper.getItemFormula((Cell)cell);
                if (formula == null) continue;
                String version = formula.getExt("Version");
                cellOrgId = formula.getExt("ORGUNITID");
                cellOrgNum = formula.getExt("ORGUNIT");
                dataValue = this.getData(this.getBgDataMap(), cellOrgId, formula.getFormula(), version, false);
                view = (MbgViewListManager)this.getBgViewManagerForMulOrg().get(cellOrgNum);
                if (!(dataValue instanceof BgNViewDataInfo) || !this.isCanEditBgData(cell, formula.getFormula(), dataValue, cellOrgId, (IMbgViewBase)view, sheet.getSheetIndex(), version) || !(isModify = this.isModify(dataValue))) continue;
                return isModify;
            }
        }
        return isModify;
    }

    protected boolean isModifyNote(Cell cell) {
        return ViewListHelper.checkIsEditNoteCell((Cell)cell) && !ObjectUtil.equals((Object)BgNFSHelper.getValue((Cell)cell), (Object)BgNFSHelper.getUserObject((Cell)cell, (String)"oldValue"));
    }

    private void parseMember(List<BgDimensionMember> _allMembers, List<MbgViewListDimensionInfo> dimension) {
        Set<String> dimNumberSet;
        MbgViewListDimensionMember bgDimensionMember;
        String acctNumber = this.getAcctNumber(_allMembers);
        if (StringUtils.isEmpty((String)acctNumber) && this.getCurMbgSheetManager() != null && ((MbgViewListSheetManager)this.getCurMbgSheetManager()).getDimensionManager() != null && dimension != null && !dimension.isEmpty()) {
            MbgViewListDimensionInfo bgDimensionInfo = null;
            String number = null;
            List memberItemList = null;
            for (int i = 0; i < dimension.size(); ++i) {
                bgDimensionInfo = dimension.get(i);
                number = bgDimensionInfo.getNumber();
                if (!DimensionBaseConstants.DEF_ACCOUNT_NUMBER.equals(number)) continue;
                memberItemList = bgDimensionInfo.getSelectMembers();
                for (int j = 0; j < memberItemList.size(); ++j) {
                    bgDimensionMember = MbgViewListDimensionMember.getInstance((BgDimensionMember)((BgDimensionMember)memberItemList.get(j)));
                    _allMembers.add((BgDimensionMember)bgDimensionMember);
                }
            }
        }
        if (((dimNumberSet = this.getDimNumber(_allMembers)) == null || dimNumberSet.isEmpty()) && dimension != null && !dimension.isEmpty()) {
            MbgViewListDimensionInfo bgDimensionInfo = null;
            String number = null;
            List memberItemList = null;
            for (int i = 0; i < dimension.size(); ++i) {
                bgDimensionInfo = dimension.get(i);
                number = bgDimensionInfo.getNumber();
                if (DimensionBaseConstants.necessary.contains(number)) continue;
                memberItemList = bgDimensionInfo.getSelectMembers();
                for (int j = 0; j < memberItemList.size(); ++j) {
                    bgDimensionMember = MbgViewListDimensionMember.getInstance((BgDimensionMember)((BgDimensionMember)memberItemList.get(j)));
                    _allMembers.add((BgDimensionMember)bgDimensionMember);
                }
            }
        }
    }

    private String getOrgNumber(BgDimensionMember[] _allMembers) {
        if (_allMembers == null || _allMembers.length == 0) {
            return null;
        }
        return this.getOrgNumber(Arrays.asList(_allMembers));
    }

    private String getOrgNumber(List<BgDimensionMember> _allMembers) {
        if (_allMembers != null && !_allMembers.isEmpty()) {
            for (int i = 0; i < _allMembers.size(); ++i) {
                if (!DimensionConstants.DEF_ORGUNIT_NUMBER.equals(_allMembers.get(i).getType())) continue;
                return _allMembers.get(i).getNumber();
            }
        }
        return null;
    }

    private Set<String> getDimNumber(List<BgDimensionMember> _allMembers) {
        if (_allMembers != null && !_allMembers.isEmpty()) {
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < _allMembers.size(); ++i) {
                if (DimensionConstants.necessary.contains(_allMembers.get(i).getType())) continue;
                set.add(_allMembers.get(i).getNumber());
            }
            return set;
        }
        return null;
    }

    private String getAcctNumber(List<BgDimensionMember> _allMembers) {
        if (_allMembers != null && !_allMembers.isEmpty()) {
            for (int i = 0; i < _allMembers.size(); ++i) {
                if (!DimensionConstants.DEF_ACCOUNT_NUMBER.equals(_allMembers.get(i).getType())) continue;
                return _allMembers.get(i).getNumber();
            }
        }
        return null;
    }

    private IBgExpressionFacade getExpressionInterface() throws BOSException {
        if (this.getCtx() == null) {
            return BgExpressionFacadeFactory.getRemoteInstance();
        }
        return BgExpressionFacadeFactory.getLocalInstance((Context)this.getCtx());
    }

    public void clearCache() {
        this.orgFormInPorInst.clear();
        this.orgIdFormState.clear();
    }

    private class BgViewManagerForMultiOrgSwingWorker
    extends SwingWorker {
        private Set<String> orgNums = null;

        public BgViewManagerForMultiOrgSwingWorker(Set<String> orgNums) {
            this.orgNums = orgNums;
        }

        public Object construct() {
            try {
                long ct = System.currentTimeMillis();
                logger.info((Object)("start BgViewManagerForMultiOrgSwingWorker construct: " + ct));
                BgCslViewListFormProvider.this.addBgViewManagerForMultiOrg(this.orgNums);
                logger.info((Object)("end BgViewManagerForMultiOrgSwingWorker construct: " + (System.currentTimeMillis() - ct) + "ms"));
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
            return null;
        }
    }
}

