/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.utils;

import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodEnum;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.bgcsl.BgCslAdjFormInfo;
import com.kingdee.eas.ma.bgcsl.BgCslAdjTemplateInfo;
import com.kingdee.eas.ma.bgcsl.BgCslFormInfo;
import com.kingdee.eas.ma.bgcsl.BgCslFormStateEnum;
import com.kingdee.eas.ma.bgcsl.BgCslSpecialItemsInfo;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateInfo;
import com.kingdee.eas.ma.bgcsl.BgNWorkTemplateInfo;
import com.kingdee.eas.ma.bgcsl.MbgWorkPaperInfo;
import com.kingdee.eas.ma.bgcsl.MbgWorkPaperStateEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.BgTypeInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class MbgCslDataHelper {
    private static final Logger logger = Logger.getLogger((String)MbgCslDataHelper.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BgCslFormInfo getBgCslFormInfo(Context ctx, String billId) throws Exception {
        BgCslFormInfo cslFormInfo = null;
        if (ctx == null || StringUtils.isEmpty((String)billId)) {
            return cslFormInfo;
        }
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            cslFormInfo = MbgCslDataHelper.getBgCslFormInfo(ctx, conn, billId);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return cslFormInfo;
    }

    public static BgCslFormInfo getBgCslFormInfo(Context ctx, Connection conn, String billId) throws Exception {
        BgCslFormInfo cslFormInfo = null;
        if (conn == null || ctx == null || StringUtils.isEmpty((String)billId)) {
            return cslFormInfo;
        }
        ArrayList<String> billIds = new ArrayList<String>();
        billIds.add(billId);
        List<BgCslFormInfo> models = MbgCslDataHelper.getBgCslFormInfo(ctx, conn, billIds);
        if (models != null && !models.isEmpty()) {
            cslFormInfo = models.get(0);
        }
        return cslFormInfo;
    }

    public static BgCslAdjFormInfo getBgCslAdjFormInfo(Context ctx, Connection conn, String billId) throws Exception {
        BgCslAdjFormInfo cslFormInfo = null;
        if (conn == null || ctx == null || StringUtils.isEmpty((String)billId)) {
            return cslFormInfo;
        }
        ArrayList<String> billIds = new ArrayList<String>();
        billIds.add(billId);
        List<BgCslAdjFormInfo> models = MbgCslDataHelper.getBgCslAdjFormInfo(ctx, conn, billIds);
        if (models != null && !models.isEmpty()) {
            cslFormInfo = models.get(0);
        }
        return cslFormInfo;
    }

    public static List<BgCslAdjFormInfo> getBgCslAdjFormInfo(Context ctx, Connection conn, List<String> billIds) throws Exception {
        return MbgCslDataHelper.getBgCslAdjFormInfo(ctx, conn, billIds, false);
    }

    public static List<BgCslFormInfo> getBgCslFormInfo(Context ctx, Connection conn, List<String> billIds) throws Exception {
        return MbgCslDataHelper.getBgCslFormInfo(ctx, conn, billIds, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<BgCslFormInfo> getBgCslFormInfo(Context ctx, Connection conn, List<String> billIds, boolean hasData) throws Exception {
        ArrayList<BgCslFormInfo> cslForms = new ArrayList<BgCslFormInfo>();
        if (conn == null) return cslForms;
        if (ctx == null) return cslForms;
        if (billIds == null) return cslForms;
        if (billIds.isEmpty()) {
            return cslForms;
        }
        String tmpTable = null;
        String tmpStr = null;
        String sql = null;
        String billId = null;
        BgCslFormInfo cslForm = null;
        TempTablePool pool = null;
        IRowSet rst = null;
        try {
            if (billIds.size() > 1) {
                pool = TempTablePool.getInstance((Context)ctx);
                tmpTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                if (tmpTable != null) {
                    BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTable + " (FID) values (?)"), billIds);
                }
            } else if (billIds.size() == 1) {
                billId = billIds.get(0);
            }
            sql = "select t.FID, t.FNumber, t.FName, t.FControlUnitID, t.FOrgTreeId, tu.FNumber AS FTreeNumber, tu.FName_" + ctx.getLocale() + " AS FTreeName, t.FOrgUnitId, u.FNumber AS FUnitNumber, u.FLongNumber AS FUnitLongNumber, u.FName_" + ctx.getLocale() + " AS FUnitName, t.FCompanyID, t.FBgSchemeId, t.FBgCslTemplateID, te.FNumber AS FTENumber,te.FName AS FTEName, te.FFormType, te.FIsOnlyDeal,t.FBgPeriodID, p.FNumber AS FPNumber, p.FName_" + ctx.getLocale() + " AS FPName, p.FPeriodType, p.FYear, t.FCurrencyID, c.FNumber AS FCNumber, c.FName_" + ctx.getLocale() + " AS FCName, t.FMeasureUnitID, t.FBgVersionID, t.FState, v.FNumber AS FVNumber, v.FName_" + ctx.getLocale() + " AS FVName, v.FVersionId, si.FDimensionNumber, si.FDimensionName, si.FMemberName, si.FMemberDisplayName " + (hasData ? ", t.FData " : ", ") + "tt.FID AS FTTID, tt.FNumber AS FTTNumber, tt.FName_" + ctx.getLocale() + " AS FTTName from T_MBG_BgCslForm t left join T_MBG_BgScheme s on t.FBgSchemeId = s.FID left join T_MBG_BgCslTemplate te on t.FBgCslTemplateID = te.FID left join T_MBG_BgType tt on tt.FID = te.FBgTypeID left join T_ORG_Tree tu on t.FOrgTreeId = tu.FID left join T_ORG_BaseUnit u on t.FOrgUnitId = u.FID left join T_MBG_BgPeriod p on t.FBgPeriodID = p.FID left join T_MBG_BgVersion v on t.FBgVersionID = v.FID left join T_BD_Currency c on t.FCurrencyID = c.FID left join T_MBG_BgCslSpecialitems si on t.FID = si.FBgFormId ";
            sql = tmpTable != null ? sql + " where exists (select FID from " + tmpTable + " where FID = t.FID)" : sql + " where t.FID = ?";
            IRowSet iRowSet = rst = tmpTable != null ? BgDBUtils.executeQuery((Connection)conn, (String)sql) : BgDBUtils.executeQuery((Connection)conn, (String)sql, (Object[])new Object[]{billId});
            while (rst.next()) {
                cslForm = new BgCslFormInfo();
                cslForm.setId(BOSUuid.read((String)rst.getString("FID")));
                cslForm.setNumber(rst.getString("FNumber"));
                cslForm.setName(rst.getString("FName"));
                cslForm.setState(BgCslFormStateEnum.getEnum(rst.getInt("FState")));
                tmpStr = rst.getString("FControlUnitID");
                if (!StringUtils.isEmpty((String)tmpStr)) {
                    cslForm.setCU(new CtrlUnitInfo());
                    cslForm.getCU().setId(BOSUuid.read((String)tmpStr));
                }
                if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FOrgTreeId")))) {
                    cslForm.setOrgTree(new OrgTreeInfo());
                    cslForm.getOrgTree().setId(BOSUuid.read((String)tmpStr));
                    cslForm.getOrgTree().setNumber(rst.getString("FTreeNumber"));
                    cslForm.getOrgTree().setName(rst.getString("FTreeName"));
                }
                if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FOrgUnitID")))) {
                    cslForm.setOrgUnit(new FullOrgUnitInfo());
                    cslForm.getOrgUnit().setId(BOSUuid.read((String)tmpStr));
                    cslForm.getOrgUnit().setNumber(rst.getString("FUnitNumber"));
                    cslForm.getOrgUnit().setLongNumber(rst.getString("FUnitLongNumber"));
                    cslForm.getOrgUnit().setName(rst.getString("FUnitName"));
                }
                if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FCompanyID")))) {
                    cslForm.setCompany(new CompanyOrgUnitInfo());
                    cslForm.getCompany().setId(BOSUuid.read((String)tmpStr));
                }
                if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FBgSchemeID")))) {
                    cslForm.setBgScheme(new BgSchemeInfo());
                    cslForm.getBgScheme().setId(BOSUuid.read((String)tmpStr));
                }
                if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FBgCslTemplateID")))) {
                    cslForm.setBgCslTemplate(new BgCslTemplateInfo());
                    cslForm.getBgCslTemplate().setId(BOSUuid.read((String)tmpStr));
                    cslForm.getBgCslTemplate().setName(rst.getString("FTEName"));
                    cslForm.getBgCslTemplate().setNumber(rst.getString("FTENumber"));
                    cslForm.getBgCslTemplate().setFormType(BgTemFormTypeEnum.getEnum((int)rst.getInt("FFormType")));
                    cslForm.getBgCslTemplate().setOnlyDealBgForm(rst.getBoolean("FIsOnlyDeal"));
                    tmpStr = rst.getString("FTTID");
                    if (!StringUtils.isEmpty((String)tmpStr)) {
                        cslForm.getBgCslTemplate().setBgType(new BgTypeInfo());
                        cslForm.getBgCslTemplate().getBgType().setId(BOSUuid.read((String)rst.getString("FTTID")));
                        cslForm.getBgCslTemplate().getBgType().setNumber(rst.getString("FTTNumber"));
                        cslForm.getBgCslTemplate().getBgType().setName(rst.getString("FTTName"));
                    }
                }
                if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FBgPeriodID")))) {
                    cslForm.setBgPeriod(new BgPeriodInfo());
                    cslForm.getBgPeriod().setId(BOSUuid.read((String)tmpStr));
                    cslForm.getBgPeriod().setNumber(rst.getString("FPNumber"));
                    cslForm.getBgPeriod().setName(rst.getString("FPName"));
                    cslForm.getBgPeriod().setPeriodType(BgPeriodEnum.getEnum((int)rst.getInt("FPeriodType")));
                    cslForm.getBgPeriod().setYear(rst.getInt("FYear"));
                }
                if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FCurrencyID")))) {
                    cslForm.setCurrency(new CurrencyInfo());
                    cslForm.getCurrency().setId(BOSUuid.read((String)tmpStr));
                    cslForm.getCurrency().setNumber(rst.getString("FCNumber"));
                    cslForm.getCurrency().setName(rst.getString("FCName"));
                }
                if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FMeasureUnitID")))) {
                    cslForm.setMeasureUnit(new MeasureUnitInfo());
                    cslForm.getMeasureUnit().setId(BOSUuid.read((String)tmpStr));
                }
                if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FBgVersionID")))) {
                    cslForm.setBgVersion(new BgVersionInfo());
                    cslForm.getBgVersion().setId(BOSUuid.read((String)tmpStr));
                    cslForm.getBgVersion().setNumber(rst.getString("FVNumber"));
                    cslForm.getBgVersion().setName(rst.getString("FVName"));
                    cslForm.getBgVersion().setVersionId(rst.getInt("FVersionId"));
                }
                if ((tmpStr = rst.getString("FDimensionNumber")) != null) {
                    BgCslSpecialItemsInfo specialItem = new BgCslSpecialItemsInfo();
                    specialItem.setDimensionNumber(tmpStr);
                    specialItem.setDimensionName(rst.getString("FDimensionName"));
                    specialItem.setMemberName(rst.getString("FMemberName"));
                    specialItem.setMemberDisplayName(rst.getString("FMemberDisplayName"));
                    cslForm.getBgSpecialItems().add(specialItem);
                }
                if (hasData) {
                    cslForm.setData(BgDBUtils.getBytes((ResultSet)rst, (String)"FData"));
                }
                cslForms.add(cslForm);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (Exception ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                if (pool == null) throw throwable;
                if (tmpTable == null) throw throwable;
                pool.releaseTable(tmpTable);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        if (pool == null) return cslForms;
        if (tmpTable == null) return cslForms;
        pool.releaseTable(tmpTable);
        return cslForms;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<BgCslAdjFormInfo> getBgCslAdjFormInfo(Context ctx, Connection conn, List<String> billIds, boolean hasData) throws Exception {
        ArrayList<BgCslAdjFormInfo> cslForms = new ArrayList<BgCslAdjFormInfo>();
        if (conn == null) return cslForms;
        if (ctx == null) return cslForms;
        if (billIds == null) return cslForms;
        if (billIds.isEmpty()) {
            return cslForms;
        }
        String tmpTable = null;
        String tmpStr = null;
        String sql = null;
        String billId = null;
        BgCslAdjFormInfo cslForm = null;
        TempTablePool pool = null;
        IRowSet rst = null;
        try {
            if (billIds.size() > 1) {
                pool = TempTablePool.getInstance((Context)ctx);
                tmpTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                if (tmpTable != null) {
                    BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTable + " (FID) values (?)"), billIds);
                }
            } else if (billIds.size() == 1) {
                billId = billIds.get(0);
            }
            sql = "select t.FID, t.FNumber, t.FName, t.FControlUnitID, t.FOrgTreeId, tu.FNumber AS FTreeNumber, tu.FName_" + ctx.getLocale() + " AS FTreeName, t.FOrgUnitId, u.FNumber AS FUnitNumber, u.FLongNumber AS FUnitLongNumber, u.FName_" + ctx.getLocale() + " AS FUnitName, t.FCompanyID, t.FBgSchemeId, t.FBgCslTemplateID, te.FNumber AS FTENumber, te.FFormType,te.FIsOnlyDeal, t.FBgPeriodID, p.FNumber AS FPNumber, p.FName_" + ctx.getLocale() + " AS FPName, p.FPeriodType, p.FYear, t.FCurrencyID, c.FNumber AS FCNumber, c.FName_" + ctx.getLocale() + " AS FCName, t.FMeasureUnitID, t.FBgVersionID, t.FState, v.FNumber AS FVNumber, v.FName_" + ctx.getLocale() + " AS FVName, v.FVersionId, si.FDimensionNumber, si.FDimensionName, si.FMemberName, si.FMemberDisplayName " + (hasData ? ", t.FData " : "") + "from T_MBG_BgCslAdjForm t left join T_MBG_BgScheme s on t.FBgSchemeId = s.FID left join T_MBG_BgCslAdjTemplate te on t.FBgCslTemplateID = te.FID left join T_ORG_Tree tu on t.FOrgTreeId = tu.FID left join T_ORG_BaseUnit u on t.FOrgUnitId = u.FID left join T_MBG_BgPeriod p on t.FBgPeriodID = p.FID left join T_MBG_BgVersion v on t.FBgVersionID = v.FID left join T_BD_Currency c on t.FCurrencyID = c.FID left join T_MBG_BgCslSpecialitems si on t.FID = si.FBgAdjFormID ";
            sql = tmpTable != null ? sql + " where exists (select FID from " + tmpTable + " where FID = t.FID)" : sql + " where t.FID = ?";
            IRowSet iRowSet = rst = tmpTable != null ? BgDBUtils.executeQuery((Connection)conn, (String)sql) : BgDBUtils.executeQuery((Connection)conn, (String)sql, (Object[])new Object[]{billId});
            while (rst.next()) {
                cslForm = new BgCslAdjFormInfo();
                cslForm.setId(BOSUuid.read((String)rst.getString("FID")));
                cslForm.setNumber(rst.getString("FNumber"));
                cslForm.setName(rst.getString("FName"));
                cslForm.setState(BgCslFormStateEnum.getEnum(rst.getInt("FState")));
                tmpStr = rst.getString("FControlUnitID");
                if (!StringUtils.isEmpty((String)tmpStr)) {
                    cslForm.setCU(new CtrlUnitInfo());
                    cslForm.getCU().setId(BOSUuid.read((String)tmpStr));
                }
                if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FOrgTreeId")))) {
                    cslForm.setOrgTree(new OrgTreeInfo());
                    cslForm.getOrgTree().setId(BOSUuid.read((String)tmpStr));
                    cslForm.getOrgTree().setNumber(rst.getString("FTreeNumber"));
                    cslForm.getOrgTree().setName(rst.getString("FTreeName"));
                }
                if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FOrgUnitID")))) {
                    cslForm.setOrgUnit(new FullOrgUnitInfo());
                    cslForm.getOrgUnit().setId(BOSUuid.read((String)tmpStr));
                    cslForm.getOrgUnit().setNumber(rst.getString("FUnitNumber"));
                    cslForm.getOrgUnit().setLongNumber(rst.getString("FUnitLongNumber"));
                    cslForm.getOrgUnit().setName(rst.getString("FUnitName"));
                }
                if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FCompanyID")))) {
                    cslForm.setCompany(new CompanyOrgUnitInfo());
                    cslForm.getCompany().setId(BOSUuid.read((String)tmpStr));
                }
                if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FBgSchemeID")))) {
                    cslForm.setBgScheme(new BgSchemeInfo());
                    cslForm.getBgScheme().setId(BOSUuid.read((String)tmpStr));
                }
                if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FBgCslTemplateID")))) {
                    cslForm.setBgCslTemplate(new BgCslAdjTemplateInfo());
                    cslForm.getBgCslTemplate().setId(BOSUuid.read((String)tmpStr));
                    cslForm.getBgCslTemplate().setNumber(rst.getString("FTENumber"));
                    cslForm.getBgCslTemplate().setFormType(BgTemFormTypeEnum.getEnum((int)rst.getInt("FFormType")));
                    cslForm.getBgCslTemplate().setOnlyDealBgForm(rst.getBoolean("FIsOnlyDeal"));
                }
                if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FBgPeriodID")))) {
                    cslForm.setBgPeriod(new BgPeriodInfo());
                    cslForm.getBgPeriod().setId(BOSUuid.read((String)tmpStr));
                    cslForm.getBgPeriod().setNumber(rst.getString("FPNumber"));
                    cslForm.getBgPeriod().setName(rst.getString("FPName"));
                    cslForm.getBgPeriod().setPeriodType(BgPeriodEnum.getEnum((int)rst.getInt("FPeriodType")));
                    cslForm.getBgPeriod().setYear(rst.getInt("FYear"));
                }
                if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FCurrencyID")))) {
                    cslForm.setCurrency(new CurrencyInfo());
                    cslForm.getCurrency().setId(BOSUuid.read((String)tmpStr));
                    cslForm.getCurrency().setNumber(rst.getString("FCNumber"));
                    cslForm.getCurrency().setName(rst.getString("FCName"));
                }
                if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FMeasureUnitID")))) {
                    cslForm.setMeasureUnit(new MeasureUnitInfo());
                    cslForm.getMeasureUnit().setId(BOSUuid.read((String)tmpStr));
                }
                if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FBgVersionID")))) {
                    cslForm.setBgVersion(new BgVersionInfo());
                    cslForm.getBgVersion().setId(BOSUuid.read((String)tmpStr));
                    cslForm.getBgVersion().setNumber(rst.getString("FVNumber"));
                    cslForm.getBgVersion().setName(rst.getString("FVName"));
                    cslForm.getBgVersion().setVersionId(rst.getInt("FVersionId"));
                }
                if ((tmpStr = rst.getString("FDimensionNumber")) != null) {
                    BgCslSpecialItemsInfo specialItem = new BgCslSpecialItemsInfo();
                    specialItem.setDimensionNumber(tmpStr);
                    specialItem.setDimensionName(rst.getString("FDimensionName"));
                    specialItem.setMemberName(rst.getString("FMemberName"));
                    specialItem.setMemberDisplayName(rst.getString("FMemberDisplayName"));
                    cslForm.getBgSpecialItems().add(specialItem);
                }
                if (hasData) {
                    cslForm.setData(BgDBUtils.getBytes((ResultSet)rst, (String)"FData"));
                }
                cslForms.add(cslForm);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (Exception ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                if (pool == null) throw throwable;
                if (tmpTable == null) throw throwable;
                pool.releaseTable(tmpTable);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        if (pool == null) return cslForms;
        if (tmpTable == null) return cslForms;
        pool.releaseTable(tmpTable);
        return cslForms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MbgWorkPaperInfo getMBgWorkPaperInfo(Context ctx, String billId) throws Exception {
        MbgWorkPaperInfo workPaper = null;
        if (ctx == null || StringUtils.isEmpty((String)billId)) {
            return workPaper;
        }
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            workPaper = MbgCslDataHelper.getMBgWorkPaperInfo(ctx, conn, billId);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return workPaper;
    }

    public static MbgWorkPaperInfo getMBgWorkPaperInfo(Context ctx, Connection conn, String billId) throws Exception {
        MbgWorkPaperInfo workPaper = null;
        if (conn == null || ctx == null || StringUtils.isEmpty((String)billId)) {
            return workPaper;
        }
        ArrayList<String> billIds = new ArrayList<String>();
        billIds.add(billId);
        List<MbgWorkPaperInfo> models = MbgCslDataHelper.getMBgWorkPaperInfo(ctx, conn, billIds);
        if (models != null && !models.isEmpty()) {
            workPaper = models.get(0);
        }
        return workPaper;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<MbgWorkPaperInfo> getMBgWorkPaperInfo(Context ctx, Connection conn, List<String> billIds) throws Exception {
        ArrayList<MbgWorkPaperInfo> workPapers = new ArrayList<MbgWorkPaperInfo>();
        if (conn == null) return workPapers;
        if (ctx == null) return workPapers;
        if (billIds == null) return workPapers;
        if (billIds.isEmpty()) {
            return workPapers;
        }
        String tmpTable = null;
        String tmpStr = null;
        String billId = null;
        String sql = null;
        MbgWorkPaperInfo workPaper = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        IRowSet rst = null;
        try {
            if (billIds.size() > 1) {
                pool = TempTablePool.getInstance((Context)ctx);
                tmpTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                if (tmpTable != null) {
                    BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTable + " (FID) values (?)"), billIds);
                }
            } else if (billIds.size() == 1) {
                billId = billIds.get(0);
            }
            sql = "select t.FID, t.FNumber, t.FName, t.FControlUnitID, t.FOrgTreeId, tu.FNumber AS FTreeNumber, tu.FName_" + ctx.getLocale() + " AS FTreeName, t.FOrgUnitId, u.FNumber AS FUnitNumber, u.FLongNumber AS FUnitLongNumber, u.FName_" + ctx.getLocale() + " AS FUnitName, t.FCompanyID, t.FBgSchemeId, s.FOrgUnitId AS FSOrgUnitId, s.FNumber AS FSNumber,  t.FWorkTemplateID, te.FNumber AS FTENumber, t.FBgPeriodID, p.FNumber AS FPNumber, p.FName_" + ctx.getLocale() + " AS FPName, p.FPeriodType, p.FYear, t.FCurrencyID, c.FNumber AS FCNumber, c.FName_" + ctx.getLocale() + " AS FCName, t.FVersionId, v.FNumber AS FVNumber, v.FName_" + ctx.getLocale() + " AS FVName, v.FVersionId AS FVVersionId, t.FState from T_MBG_MbgWorkPaper t left join T_MBG_BgScheme s on t.FBgSchemeId = s.FID left join T_MBG_BgNWorkTemplate te on t.FWorkTemplateID = te.FID left join T_ORG_Tree tu on t.FOrgTreeId = tu.FID left join T_ORG_BaseUnit u on t.FOrgUnitId = u.FID left join T_MBG_BgPeriod p on t.FBgPeriodID = p.FID left join T_MBG_BgVersion v on t.FVersionId = v.FID left join T_BD_Currency c on t.FCurrencyID = c.FID ";
            sql = tmpTable != null ? sql + " where exists (select FID from " + tmpTable + " where FID = t.FID)" : sql + " where t.FID = ?";
            IRowSet iRowSet = rst = tmpTable != null ? BgDBUtils.executeQuery((Connection)conn, (String)sql) : BgDBUtils.executeQuery((Connection)conn, (String)sql, (Object[])new Object[]{billId});
            while (rst.next()) {
                workPaper = new MbgWorkPaperInfo();
                workPaper.setId(BOSUuid.read((String)rst.getString("FID")));
                workPaper.setNumber(rst.getString("FNumber"));
                workPaper.setName(rst.getString("FName"));
                workPaper.setState(MbgWorkPaperStateEnum.getEnum(rst.getInt("FState")));
                tmpStr = rst.getString("FControlUnitID");
                if (!StringUtils.isEmpty((String)tmpStr)) {
                    workPaper.setCU(new CtrlUnitInfo());
                    workPaper.getCU().setId(BOSUuid.read((String)tmpStr));
                }
                if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FOrgTreeId")))) {
                    workPaper.setOrgTree(new OrgTreeInfo());
                    workPaper.getOrgTree().setId(BOSUuid.read((String)tmpStr));
                    workPaper.getOrgTree().setNumber(rst.getString("FTreeNumber"));
                    workPaper.getOrgTree().setName(rst.getString("FTreeName"));
                }
                if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FOrgUnitID")))) {
                    workPaper.setOrgUnit(new FullOrgUnitInfo());
                    workPaper.getOrgUnit().setId(BOSUuid.read((String)tmpStr));
                    workPaper.getOrgUnit().setNumber(rst.getString("FUnitNumber"));
                    workPaper.getOrgUnit().setLongNumber(rst.getString("FUnitLongNumber"));
                    workPaper.getOrgUnit().setName(rst.getString("FUnitName"));
                }
                if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FCompanyID")))) {
                    workPaper.setCompany(new CompanyOrgUnitInfo());
                    workPaper.getCompany().setId(BOSUuid.read((String)tmpStr));
                }
                if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FBgSchemeID")))) {
                    workPaper.setBgScheme(new BgSchemeInfo());
                    workPaper.getBgScheme().setId(BOSUuid.read((String)tmpStr));
                    workPaper.getBgScheme().setNumber(rst.getString("FSNumber"));
                    tmpStr = rst.getString("FSOrgUnitId");
                    if (!StringUtils.isEmpty((String)tmpStr)) {
                        workPaper.getBgScheme().setOrgUnit(new FullOrgUnitInfo());
                        workPaper.getBgScheme().getOrgUnit().setId(BOSUuid.read((String)tmpStr));
                    }
                }
                if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FWorkTemplateID")))) {
                    workPaper.setBgNWorkTemplate(new BgNWorkTemplateInfo());
                    workPaper.getBgNWorkTemplate().setId(BOSUuid.read((String)tmpStr));
                    workPaper.getBgNWorkTemplate().setNumber(rst.getString("FTENumber"));
                }
                if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FBgPeriodID")))) {
                    workPaper.setBgPeriod(new BgPeriodInfo());
                    workPaper.getBgPeriod().setId(BOSUuid.read((String)tmpStr));
                    workPaper.getBgPeriod().setNumber(rst.getString("FPNumber"));
                    workPaper.getBgPeriod().setName(rst.getString("FPName"));
                    workPaper.getBgPeriod().setPeriodType(BgPeriodEnum.getEnum((int)rst.getInt("FPeriodType")));
                    workPaper.getBgPeriod().setYear(rst.getInt("FYear"));
                }
                if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FCurrencyID")))) {
                    workPaper.setCurrency(new CurrencyInfo());
                    workPaper.getCurrency().setId(BOSUuid.read((String)tmpStr));
                    workPaper.getCurrency().setNumber(rst.getString("FCNumber"));
                    workPaper.getCurrency().setName(rst.getString("FCName"));
                }
                if (!StringUtils.isEmpty((String)(tmpStr = rst.getString("FVersionId")))) {
                    workPaper.setBgVersion(new BgVersionInfo());
                    workPaper.getBgVersion().setId(BOSUuid.read((String)tmpStr));
                    workPaper.getBgVersion().setNumber(rst.getString("FVNumber"));
                    workPaper.getBgVersion().setName(rst.getString("FVName"));
                    workPaper.getBgVersion().setVersionId(rst.getInt("FVVersionId"));
                }
                workPapers.add(workPaper);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (Exception ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                if (pool == null) throw throwable;
                if (tmpTable == null) throw throwable;
                pool.releaseTable(tmpTable);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        if (pool == null) return workPapers;
        if (tmpTable == null) return workPapers;
        pool.releaseTable(tmpTable);
        return workPapers;
    }
}

