/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.bgcsl.MbgWorkPaperInfo;
import com.kingdee.eas.ma.bgcsl.app.data.MbgCsl04DataFacade;
import com.kingdee.eas.ma.bgcsl.common.UnionDataClearUtils;
import com.kingdee.eas.ma.bgcsl.utils.MbgCslDataHelper;
import com.kingdee.eas.ma.bgcsl.utils.data.UnionDataUtils;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.app.data.IMbgBizFacade;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.dimension.IDimension;
import com.kingdee.eas.ma.mbg.cube.member.IMember;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class MbgWorkPaperServerThread {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.bgcsl.utils.MbgWorkPaperServerThread");
    private Context ctx = null;
    private BOSUuid bgSchemeId = null;
    private BOSUuid unionId = null;
    private BOSUuid billId = null;
    private List<BOSUuid> orgUnitIds = null;
    private List<List<IDimension>> mbgDims = null;
    private Map<String, Set<String>> formulaMap = null;
    private MbgWorkPaperInfo workPaperInfo = null;
    private int versionId;
    private BgSchemeInfo schemeInfo = null;
    private String cubeName = null;
    private String cubeEntry = null;
    private UnionDataUtils utils = UnionDataUtils.getIntance();
    private UserInfo user = null;
    private List<BOSUuid> ccOrgUnitIds = null;
    private int availableProcessors = Runtime.getRuntime().availableProcessors();
    private int MBGCSL_DEFAULT_POOLSIZE = this.availableProcessors / 2 + 1;

    public MbgWorkPaperServerThread(Context ctx, BOSUuid bgSchemeId, BOSUuid unionId, BOSUuid billId, List<BOSUuid> orgUnitIds, List<List<IDimension>> mbgDims, Map<String, Set<String>> formulaMap) {
        this.ctx = ctx;
        this.bgSchemeId = bgSchemeId;
        this.unionId = unionId;
        this.billId = billId;
        this.orgUnitIds = orgUnitIds;
        this.mbgDims = mbgDims;
        this.formulaMap = formulaMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map<String, IBgNData>> fetchSingleValueByMultiThread(UnionDataClearUtils clearUtils) throws EASBizException, BOSException {
        HashMap<String, Map<String, IBgNData>> indvData = new HashMap<String, Map<String, IBgNData>>();
        if (this.ctx == null || this.bgSchemeId == null || this.unionId == null || this.billId == null || this.orgUnitIds == null || this.orgUnitIds.isEmpty() || this.mbgDims == null || this.mbgDims.isEmpty()) {
            return indvData;
        }
        BOSUuid orgUnitId = null;
        HashMap<String, Map<String, IBgNData>> tmpIndiData = new HashMap<String, Map<String, IBgNData>>();
        HashMap tmpCSLData = new HashMap();
        TempTablePool pool = null;
        Connection conn = null;
        try {
            int i;
            conn = BgDBUtils.getConnection((Context)this.ctx);
            pool = TempTablePool.getInstance((Context)this.ctx);
            this.beforeFetchData(conn);
            int optimalPoolSize = this.getOptimalPoolSize(conn);
            ExecutorService threadPool = Executors.newFixedThreadPool(optimalPoolSize);
            ArrayList<Future<Map<String, Map<String, IBgNData>>>> indiResult = new ArrayList<Future<Map<String, Map<String, IBgNData>>>>();
            boolean isCalcMbgBiz = this.schemeInfo != null ? this.schemeInfo.isIsCalcMbgBiz() : false;
            for (i = 0; i < this.ccOrgUnitIds.size(); ++i) {
                BOSUuid[] bOSUuidArray;
                orgUnitId = this.ccOrgUnitIds.get(i);
                if (isCalcMbgBiz) {
                    bOSUuidArray = null;
                } else {
                    BOSUuid[] bOSUuidArray2 = new BOSUuid[1];
                    bOSUuidArray = bOSUuidArray2;
                    bOSUuidArray2[0] = this.workPaperInfo.getBgNWorkTemplate().getId();
                }
                CostCenterIndiviDataProvider curBgDataMapCall = new CostCenterIndiviDataProvider(conn, this.workPaperInfo, this.bgSchemeId, orgUnitId, bOSUuidArray, this.deepCloneMbgDims(this.mbgDims), clearUtils);
                Future<Map<String, Map<String, IBgNData>>> curBgDataMap = threadPool.submit(curBgDataMapCall);
                indiResult.add(curBgDataMap);
            }
            if (this.ccOrgUnitIds.size() != this.orgUnitIds.size()) {
                CslDataProvider curCslDataProvider = new CslDataProvider(conn, pool, clearUtils);
                Future<Map<String, Map<String, IBgNData>>> cslData = threadPool.submit(curCslDataProvider);
                indiResult.add(cslData);
            }
            threadPool.shutdown();
            int in = indiResult.size();
            for (i = 0; i < in; ++i) {
                if (i < this.ccOrgUnitIds.size()) {
                    try {
                        if (!(((Future)indiResult.get(i)).get() instanceof Map)) continue;
                        tmpIndiData.putAll((Map)((Future)indiResult.get(i)).get());
                    }
                    catch (Exception e) {
                        logger.error((Object)"loadDivData Error:", (Throwable)e);
                    }
                    continue;
                }
                try {
                    tmpCSLData.putAll((Map)((Future)indiResult.get(i)).get());
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)"loadCslData Error:", (Throwable)e);
                }
            }
            if (!tmpIndiData.isEmpty()) {
                ArrayList<IMbgBizFacade> facades = new ArrayList<IMbgBizFacade>();
                facades.add((IMbgBizFacade)new MbgCsl04DataFacade());
                CostCenterIndiDataSaveThread saveIndThread = new CostCenterIndiDataSaveThread(tmpIndiData, facades, this.formulaMap);
                Thread saveThread = new Thread(saveIndThread);
                saveThread.start();
            }
            indvData.putAll(tmpIndiData);
            indvData.putAll(tmpCSLData);
        }
        catch (Exception ex) {
            logger.error((Object)"loadIndvData Error:", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return indvData;
    }

    private List<List<IDimension>> deepCloneMbgDims(List<List<IDimension>> mbgDims) {
        ArrayList<List<IDimension>> cloneDims = new ArrayList<List<IDimension>>();
        if (mbgDims == null || mbgDims.isEmpty()) {
            return cloneDims;
        }
        List<IDimension> dimList = null;
        ArrayList<IDimension> dimCloneList = null;
        IDimension dimension = null;
        for (int i = 0; i < mbgDims.size(); ++i) {
            dimList = mbgDims.get(i);
            dimCloneList = new ArrayList<IDimension>();
            for (int j = 0; j < dimList.size(); ++j) {
                dimension = dimList.get(j);
                dimCloneList.add(dimension.clone());
            }
            cloneDims.add(dimCloneList);
        }
        return cloneDims;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getOptimalPoolSize(Connection conn) {
        int poolSize = this.MBGCSL_DEFAULT_POOLSIZE;
        IRowSet rst = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT FVALUE FROM T_MBg_PARAM where FNUMBER = ?");
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{"CSL_POOL_SIZE"});
            if (rst.next()) {
                poolSize = Integer.parseInt(rst.getString("FVALUE"));
            }
            SQLUtils.cleanup((ResultSet)rst);
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rst);
        }
        return poolSize;
    }

    private void beforeFetchData(Connection conn) throws Exception {
        this.ccOrgUnitIds = this.checkOrgUnitIds(this.ctx, this.orgUnitIds);
        this.schemeInfo = MbgDataHelper.getBgSchemeInfo((Connection)conn, (Locale)this.ctx.getLocale(), (BOSUuid)this.bgSchemeId);
        this.cubeName = BgCubeUtils.getCFSCubeName((String)this.schemeInfo.getRefCube());
        this.cubeEntry = BgCubeUtils.getCFSEntryCubeName((String)this.schemeInfo.getRefCube());
        this.workPaperInfo = MbgCslDataHelper.getMBgWorkPaperInfo(this.ctx, conn, this.billId.toString());
        this.versionId = this.workPaperInfo.getBgVersion().getVersionId();
        this.user = ContextUtil.getCurrentUserInfo((Context)this.ctx);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<BOSUuid> checkOrgUnitIds(Context ctx, List orgUnitIds) throws BOSException, EASBizException {
        ArrayList<BOSUuid> _orgUnitIds = new ArrayList<BOSUuid>();
        if (ctx == null) return _orgUnitIds;
        if (orgUnitIds == null) return _orgUnitIds;
        if (orgUnitIds.isEmpty()) {
            return _orgUnitIds;
        }
        IRowSet rst = null;
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)("select FID from T_ORG_CostCenter where FID IN " + this.getAppendStrByColls(orgUnitIds)));
            while (rst.next()) {
                _orgUnitIds.add(BOSUuid.read((String)rst.getString("FID")));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (SQLDataException ex2) {
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return _orgUnitIds;
    }

    private String getAppendStrByColls(Collection<BOSUuid> userGroupIds) {
        if (userGroupIds == null || userGroupIds.isEmpty()) {
            return null;
        }
        StringBuffer selectGroupStr = new StringBuffer();
        selectGroupStr.append("(");
        Iterator<BOSUuid> it = userGroupIds.iterator();
        while (it.hasNext()) {
            selectGroupStr.append("'").append(it.next()).append("',");
        }
        selectGroupStr.delete(selectGroupStr.length() - 1, selectGroupStr.length()).append(")");
        return selectGroupStr.toString();
    }

    private class CostCenterIndiDataSaveThread
    implements Runnable {
        private List<IMbgBizFacade> facades = null;
        private Map<String, Map<String, IBgNData>> indiDataMap = null;
        private Map<String, Set<String>> formulaMap = null;

        public CostCenterIndiDataSaveThread(Map<String, Map<String, IBgNData>> indiDataMap, List<IMbgBizFacade> facades, Map<String, Set<String>> formulaMap) {
            this.facades = facades;
            this.indiDataMap = indiDataMap;
            this.formulaMap = formulaMap;
        }

        @Override
        public void run() {
            try {
                MbgWorkPaperServerThread.this.utils.saveIndvData(MbgWorkPaperServerThread.this.ctx, MbgWorkPaperServerThread.this.billId, MbgWorkPaperServerThread.this.bgSchemeId, MbgWorkPaperServerThread.this.unionId, MbgWorkPaperServerThread.this.user.getId(), this.indiDataMap, this.facades, this.formulaMap);
            }
            catch (Exception e) {
                logger.error((Object)"save indidata error");
            }
        }
    }

    private class CslDataProvider
    implements Callable<Map<String, Map<String, IBgNData>>> {
        private TempTablePool pool = null;
        private Connection conn = null;
        private UnionDataClearUtils clearUtils = null;

        public CslDataProvider(Connection conn, TempTablePool pool, UnionDataClearUtils clearUtils) {
            this.conn = conn;
            this.pool = pool;
            this.clearUtils = clearUtils;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, Map<String, IBgNData>> call() throws Exception {
            HashMap<String, Map<String, IBgNData>> cslDataMap = new HashMap<String, Map<String, IBgNData>>();
            HashSet<String> bgPeriodNums = new HashSet<String>();
            bgPeriodNums.add(MbgWorkPaperServerThread.this.workPaperInfo.getBgPeriod().getNumber());
            HashSet<String> versionNums = new HashSet<String>();
            versionNums.add(MbgWorkPaperServerThread.this.workPaperInfo.getBgVersion().getNumber());
            Set<String> bgIndexSet = this.getBgIndexSet();
            String tmpTable = null;
            ArrayList<BOSUuid> filterUnitIds = new ArrayList<BOSUuid>();
            BOSUuid orgUnitId = null;
            Map mbgDimMap = DimUtils.getDimNumMap((Connection)this.conn, (Locale)MbgWorkPaperServerThread.this.ctx.getLocale());
            try {
                Map<String, Map<String, IBgNData>> cslIndvData;
                tmpTable = this.pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FNumber NVARCHAR(84))");
                BgDBUtils.insertKey((Connection)this.conn, (String)("Insert Into " + tmpTable + " (FNumber) values (?)"), bgIndexSet);
                MbgWorkPaperServerThread.this.orgUnitIds.removeAll(MbgWorkPaperServerThread.this.ccOrgUnitIds);
                int in = MbgWorkPaperServerThread.this.orgUnitIds.size();
                for (int i = 0; i < in; ++i) {
                    orgUnitId = (BOSUuid)MbgWorkPaperServerThread.this.orgUnitIds.get(i);
                    if (this.clearUtils != null) {
                        this.clearUtils.clearUnionData(this.conn, MbgWorkPaperServerThread.this.cubeName, MbgWorkPaperServerThread.this.cubeEntry, MbgWorkPaperServerThread.this.unionId.toString(), orgUnitId.toString());
                    }
                    if (!MbgWorkPaperServerThread.this.utils.checkHasCslData(this.conn, orgUnitId, MbgWorkPaperServerThread.this.schemeInfo, tmpTable)) continue;
                    MbgWorkPaperServerThread.this.utils.builderCsl01from08(MbgWorkPaperServerThread.this.ctx, this.pool, orgUnitId, MbgWorkPaperServerThread.this.workPaperInfo, MbgWorkPaperServerThread.this.schemeInfo, mbgDimMap);
                    filterUnitIds.add(orgUnitId);
                }
                if (!filterUnitIds.isEmpty() && (cslIndvData = MbgWorkPaperServerThread.this.utils.loadCslIndvData(MbgWorkPaperServerThread.this.ctx, MbgWorkPaperServerThread.this.bgSchemeId, MbgWorkPaperServerThread.this.unionId, filterUnitIds, MbgWorkPaperServerThread.this.deepCloneMbgDims(MbgWorkPaperServerThread.this.mbgDims), true)) != null && !cslIndvData.isEmpty()) {
                    cslDataMap.putAll(cslIndvData);
                }
            }
            finally {
                if (this.pool != null && tmpTable != null) {
                    this.pool.releaseTable(tmpTable);
                }
            }
            return cslDataMap;
        }

        private Set<String> getBgIndexSet() {
            HashSet<String> bgIndexSet = new HashSet<String>();
            if (MbgWorkPaperServerThread.this.orgUnitIds.size() != MbgWorkPaperServerThread.this.ccOrgUnitIds.size()) {
                IDimension dimension = null;
                IMember member = null;
                List dims = null;
                int in = MbgWorkPaperServerThread.this.mbgDims.size();
                for (int i = 0; i < in; ++i) {
                    dims = (List)MbgWorkPaperServerThread.this.mbgDims.get(i);
                    int jn = dims.size();
                    for (int j = 0; j < jn; ++j) {
                        dimension = (IDimension)dims.get(j);
                        if (!DimensionBaseConstants.DEF_INDEX_NUMBER.equals(dimension.getNumber())) continue;
                        int xn = dimension.getMembers().size();
                        for (int x = 0; x < xn; ++x) {
                            member = (IMember)dimension.getMembers().get(x);
                            bgIndexSet.add(member.getDimNumber());
                        }
                    }
                }
            }
            return bgIndexSet;
        }
    }

    private class CostCenterIndiviDataProvider
    implements Callable<Map<String, Map<String, IBgNData>>> {
        private Connection conn = null;
        private BOSUuid bgSchemeId = null;
        private BOSUuid orgUnitId = null;
        private BOSUuid[] bgTemplateIds = null;
        private List<List<IDimension>> mbgDims = null;
        private UnionDataClearUtils clearUtils = null;

        public CostCenterIndiviDataProvider(Connection conn, IDimDataQuery dimDataQuery, BOSUuid bgSchemeId, BOSUuid orgUnitId, BOSUuid[] bgTemplateIds, List<List<IDimension>> mbgDims, UnionDataClearUtils clearUtils) {
            this.conn = conn;
            this.bgSchemeId = bgSchemeId;
            this.orgUnitId = orgUnitId;
            this.bgTemplateIds = bgTemplateIds;
            this.mbgDims = mbgDims;
            this.clearUtils = clearUtils;
        }

        @Override
        public Map<String, Map<String, IBgNData>> call() throws Exception {
            if (this.clearUtils != null) {
                this.clearUtils.clearUnionData(this.conn, MbgWorkPaperServerThread.this.cubeName, MbgWorkPaperServerThread.this.cubeEntry, MbgWorkPaperServerThread.this.unionId.toString(), this.orgUnitId.toString());
            }
            Map<String, Map<String, IBgNData>> tmpData = MbgWorkPaperServerThread.this.utils.loadIndvData(MbgWorkPaperServerThread.this.ctx, MbgWorkPaperServerThread.this.workPaperInfo, this.bgSchemeId, this.orgUnitId, this.bgTemplateIds, this.mbgDims, true);
            return tmpData;
        }
    }
}

