/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.utils.data;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgScenarioCollection;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgVersionCollection;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.base.utils.BgVersionHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.base.utils.MbgVirtualView;
import com.kingdee.eas.ma.bgcsl.BgCslAdjFormInfo;
import com.kingdee.eas.ma.bgcsl.BgCslFormInfo;
import com.kingdee.eas.ma.bgcsl.MbgWorkPaperInfo;
import com.kingdee.eas.ma.mbg.BgDimensionFacadeFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.app.data.IMbgBizFacade;
import com.kingdee.eas.ma.mbg.app.data.IMbgDataFacade;
import com.kingdee.eas.ma.mbg.app.data.MbgDataFacade;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.common.IMbgSheetBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.dimension.Dimension;
import com.kingdee.eas.ma.mbg.cube.dimension.IDimension;
import com.kingdee.eas.ma.mbg.cube.member.IMember;
import com.kingdee.eas.ma.mbg.cube.member.Member;
import com.kingdee.eas.ma.mbg.cube.query.QueryData;
import com.kingdee.eas.ma.mbg.cube.utils.MbgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionBase;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.impl.DimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.dimension.vo.DimensionObject;
import com.kingdee.eas.ma.mbg.dimension.vo.MemberObject;
import com.kingdee.eas.ma.mbg.utils.BgCslDimConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class UnionDataUtils {
    private static final Logger logger = Logger.getLogger(UnionDataUtils.class);
    private Map<String, Set<String>> closureMap = null;
    public static final String CSL_BOSTYPE = "2004E3FC";

    public static UnionDataUtils getIntance() {
        return new UnionDataUtils();
    }

    public Map<String, Set<String>> getClosureMap() {
        return this.closureMap;
    }

    public void setClosureMap(Map<String, Set<String>> closureMap) {
        this.closureMap = closureMap;
    }

    public Map<String, Map<String, IBgNData>> loadIndvData(Context ctx, IDimDataQuery dimDataQuery, BOSUuid bgSchemeId, BOSUuid orgUnitId, BOSUuid[] bgTemplateIds, List<List<IDimension>> mbgDims, boolean isIgnoreActualState) throws Exception {
        BgVersionCollection _bgVerColls;
        Map<String, Map<String, Object>> orgMbgDataMap = new HashMap<String, Map<String, IBgNData>>();
        if (ctx == null || dimDataQuery == null || bgSchemeId == null || mbgDims == null || mbgDims.isEmpty()) {
            return orgMbgDataMap;
        }
        DimensionParameter parameter = new DimensionParameter();
        parameter.setBgSchemeId(bgSchemeId);
        parameter.setOrgUnitId(orgUnitId);
        parameter.setValueType(1);
        parameter.setBgTemplateId(bgTemplateIds);
        parameter.setIgnoreActualState(isIgnoreActualState);
        BgSchemeInfo schemeInfo = MbgDataHelper.getBgSchemeInfo((Context)ctx, (BOSUuid)bgSchemeId);
        parameter.getDataManager().setBgScheme(schemeInfo);
        Set actScenarios = BgScenarioHelper.getAcScenarioNumbers((Context)ctx);
        boolean hasBudget = false;
        boolean hasAct = false;
        for (List<IDimension> subList : mbgDims) {
            for (IDimension dim : subList) {
                if (!DimensionConstants.DEF_SCENARIO_NUMBER.equals(dim.getNumber())) continue;
                for (IMember member : dim.getMembers()) {
                    if (actScenarios.contains(member.getNumber())) {
                        hasAct = true;
                        continue;
                    }
                    hasBudget = true;
                }
            }
        }
        if (!schemeInfo.isIsCalcMbgBiz() && !this.checkBgOrgUnitHasData(ctx, orgUnitId, schemeInfo, hasBudget, hasAct)) {
            return orgMbgDataMap;
        }
        OrgUnitInfo orgUnit = MbgDataHelper.getOrgUnitInfo((Context)ctx, (BOSUuid)orgUnitId);
        parameter.getDataManager().setOrgUnit(orgUnit);
        parameter.setBgOrgViewId(schemeInfo.getEditOrgViewId());
        BgOrgUnitInfo bgOrgUnit = MbgDataHelper.getBgOrgUnitInfo((Context)ctx, (BOSUuid)parameter.getBgOrgViewId(), (BOSUuid)orgUnit.getId());
        parameter.getDataManager().setBgOrgUnit(bgOrgUnit);
        HashMap<String, String> scInnNumMap = new HashMap<String, String>();
        HashMap<String, String> scNumInnMap = new HashMap<String, String>();
        HashMap<String, String> verInnNumMap = new HashMap<String, String>();
        HashMap<String, String> verNumInnMap = new HashMap<String, String>();
        HashMap<String, BgScenarioInfo> scenaioMap = new HashMap<String, BgScenarioInfo>();
        HashMap<String, BgVersionInfo> versionMap = new HashMap<String, BgVersionInfo>();
        BgScenarioInfo _scenario = null;
        BgVersionInfo _version = null;
        BgScenarioCollection _bgScenColls = BgScenarioHelper.getScenarioColls((Context)ctx);
        if (_bgScenColls != null) {
            int in = _bgScenColls.size();
            for (int i = 0; i < in; ++i) {
                _scenario = _bgScenColls.get(i);
                scInnNumMap.put(String.valueOf(_scenario.getScenarioId()), _scenario.getNumber());
                scNumInnMap.put(_scenario.getNumber(), String.valueOf(_scenario.getScenarioId()));
                scenaioMap.put(_scenario.getNumber(), _scenario);
            }
        }
        if ((_bgVerColls = BgVersionHelper.getVersionColls((Context)ctx)) != null) {
            int in = _bgVerColls.size();
            for (int i = 0; i < in; ++i) {
                _version = _bgVerColls.get(i);
                verInnNumMap.put(String.valueOf(_version.getVersionId()), _version.getNumber());
                verNumInnMap.put(_version.getNumber(), String.valueOf(_version.getVersionId()));
                versionMap.put(_version.getNumber(), _version);
            }
        }
        parameter.getDataManager().setDimDataQuery(dimDataQuery);
        parameter.getDataManager().getBgScenarioMap().putAll(scenaioMap);
        parameter.getDataManager().getBgVersionMap().putAll(versionMap);
        parameter.getDataManager().getInnNumMap().put(DimensionConstants.DEF_SCENARIO_FIELD, scInnNumMap);
        parameter.getDataManager().getNumInnMap().put(DimensionConstants.DEF_SCENARIO_FIELD, scNumInnMap);
        parameter.getDataManager().getInnNumMap().put(DimensionConstants.DEF_VERSION_FIELD, verInnNumMap);
        parameter.getDataManager().getNumInnMap().put(DimensionConstants.DEF_VERSION_FIELD, verNumInnMap);
        if (dimDataQuery.getBizPeriod() != null) {
            parameter.addPeriodStandardNumber(dimDataQuery.getBizPeriod().getNumber());
        }
        if (!schemeInfo.isIsCalcMbgBiz()) {
            parameter.getDataManager().getCustomState().add(13);
        }
        IDimension dimension = null;
        com.kingdee.eas.ma.mbg.dimension.face.IDimension mbgDim = null;
        List<IDimension> dims = null;
        QueryData queryData = null;
        int in = mbgDims.size();
        for (int i = 0; i < in; ++i) {
            int j;
            int jn;
            dims = mbgDims.get(i);
            if (i == 0) {
                jn = dims.size();
                for (j = 0; j < jn; ++j) {
                    dimension = dims.get(j);
                    mbgDim = dimension.toMbgDim();
                    if (DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals(mbgDim.getNumber())) continue;
                    DimUtils.queryItemLongNumber((Context)ctx, (IDimensionParameter)parameter, (IDimensionBase)mbgDim);
                    DimUtils.transScenarioNumber((Context)ctx, (com.kingdee.eas.ma.mbg.dimension.face.IDimension)mbgDim);
                    DimUtils.transVersionNumber((Context)ctx, (com.kingdee.eas.ma.mbg.dimension.face.IDimension)mbgDim);
                    DimUtils.transMdxMemberNumber((Context)ctx, (IDimensionParameter)parameter, (com.kingdee.eas.ma.mbg.dimension.face.IDimension)mbgDim);
                    if (DimUtils.checkBaseDimensionByField((String)mbgDim.getField())) {
                        parameter.getColDims().add(mbgDim);
                    } else {
                        parameter.getRowDims().add(mbgDim);
                    }
                    parameter.getDimensionMap().put(mbgDim.getNumber(), mbgDim);
                }
                continue;
            }
            queryData = new QueryData();
            jn = dims.size();
            for (j = 0; j < jn; ++j) {
                dimension = dims.get(j);
                if (DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals(dimension.getNumber())) continue;
                queryData.getMbgDimMap().put(dimension.getField(), dimension);
                MbgCubeUtils.queryItemLongNumber((Context)ctx, (IDimensionParameter)parameter, (IDimension)dimension);
                MbgCubeUtils.transScenarioNumber((Context)ctx, scenaioMap, (IDimension)dimension);
                MbgCubeUtils.transVersionNumber((Context)ctx, versionMap, (IDimension)dimension);
                MbgCubeUtils.transBgPeriodMember((Context)ctx, (IDimensionParameter)parameter, (IDimension)dimension, (boolean)false);
            }
            parameter.getQuerys().add(queryData);
        }
        orgMbgDataMap = (Map)BgDimensionFacadeFactory.getLocalInstance((Context)ctx).dimensionQuery((IDimensionParameter)parameter);
        HashMap<String, String> dimsMap = new HashMap<String, String>();
        this.transMbgData(orgMbgDataMap, (IDimensionParameter)parameter, dimsMap);
        return orgMbgDataMap;
    }

    private void transMbgData(Map mbgDataMap, IDimensionParameter parameter, Map<String, String> dimsMap) {
        if (mbgDataMap == null || mbgDataMap.isEmpty()) {
            return;
        }
        HashMap clone = new HashMap(mbgDataMap);
        Map.Entry entry2 = null;
        IBgNData bgData = null;
        for (Map.Entry entry2 : clone.entrySet()) {
            if (entry2.getValue() instanceof Map) {
                this.transMbgData((Map)entry2.getValue(), parameter, dimsMap);
                continue;
            }
            if (!(entry2.getValue() instanceof IBgNData)) continue;
            mbgDataMap.remove(entry2.getKey());
            bgData = (IBgNData)entry2.getValue();
            this.transMbgData(parameter, bgData, dimsMap);
            mbgDataMap.put(DimUtils.getDimDataKey((IBgNData)bgData), bgData);
        }
    }

    public Map<String, Map<String, IBgNData>> loadCslIndvData(Context ctx, BOSUuid bgSchemeId, BOSUuid unionId, List<BOSUuid> orgUnitIds, List<List<IDimension>> mbgDims, boolean isIgnoreActualState) throws Exception {
        BgVersionCollection _bgVerColls;
        Map<String, Map<String, Object>> orgMbgDataMap = new HashMap<String, Map<String, IBgNData>>();
        if (ctx == null || bgSchemeId == null || mbgDims == null || mbgDims.isEmpty()) {
            return orgMbgDataMap;
        }
        HashMap<String, String> orgUnitNumMap = new HashMap<String, String>();
        List orgUnits = MbgDataHelper.getBaseOrgUnitsByUuid((Context)ctx, orgUnitIds);
        for (OrgUnitInfo _unit : orgUnits) {
            orgUnitNumMap.put(_unit.getNumber(), _unit.getId().toString());
        }
        DimensionParameter parameter = new DimensionParameter();
        parameter.setBgSchemeId(bgSchemeId);
        parameter.setUnionId(unionId);
        parameter.setIgnoreActualState(isIgnoreActualState);
        if (orgUnitIds != null && orgUnitIds.size() == 1) {
            parameter.setOrgUnitId(orgUnitIds.get(0));
            parameter.getDataManager().setOrgUnit(MbgDataHelper.getBaseOrgUnitInfo((Context)ctx, (BOSUuid)parameter.getOrgUnitId()));
        } else if (orgUnitIds != null) {
            HashSet<String> orgIds = new HashSet<String>();
            for (BOSUuid orgId : orgUnitIds) {
                orgIds.add(orgId.toString());
            }
            parameter.setQeryOrgIds(orgIds);
        }
        parameter.setBgTemplateId(new BOSUuid[]{BOSUuid.read((String)"bgMAAAAKIcA7rHKd")});
        parameter.setValueType(64);
        BgSchemeInfo schemeInfo = MbgDataHelper.getBgSchemeInfo((Context)ctx, (BOSUuid)bgSchemeId);
        parameter.getDataManager().setBgScheme(schemeInfo);
        parameter.setBgOrgViewId(schemeInfo.getEditOrgViewId());
        HashMap<String, String> scInnNumMap = new HashMap<String, String>();
        HashMap<String, String> scNumInnMap = new HashMap<String, String>();
        HashMap<String, String> verInnNumMap = new HashMap<String, String>();
        HashMap<String, String> verNumInnMap = new HashMap<String, String>();
        HashMap<String, BgScenarioInfo> scenaioMap = new HashMap<String, BgScenarioInfo>();
        HashMap<String, BgVersionInfo> versionMap = new HashMap<String, BgVersionInfo>();
        BgScenarioInfo _scenario = null;
        BgVersionInfo _version = null;
        BgScenarioCollection _bgScenColls = BgScenarioHelper.getScenarioColls((Context)ctx);
        if (_bgScenColls != null) {
            int in = _bgScenColls.size();
            for (int i = 0; i < in; ++i) {
                _scenario = _bgScenColls.get(i);
                scInnNumMap.put(String.valueOf(_scenario.getScenarioId()), _scenario.getNumber());
                scNumInnMap.put(_scenario.getNumber(), String.valueOf(_scenario.getScenarioId()));
                scenaioMap.put(_scenario.getNumber(), _scenario);
            }
        }
        if ((_bgVerColls = BgVersionHelper.getVersionColls((Context)ctx)) != null) {
            int in = _bgVerColls.size();
            for (int i = 0; i < in; ++i) {
                _version = _bgVerColls.get(i);
                verInnNumMap.put(String.valueOf(_version.getVersionId()), _version.getNumber());
                verNumInnMap.put(_version.getNumber(), String.valueOf(_version.getVersionId()));
                versionMap.put(_version.getNumber(), _version);
            }
        }
        parameter.getDataManager().getBgScenarioMap().putAll(scenaioMap);
        parameter.getDataManager().getBgVersionMap().putAll(versionMap);
        parameter.getDataManager().getInnNumMap().put(DimensionConstants.DEF_SCENARIO_FIELD, scInnNumMap);
        parameter.getDataManager().getNumInnMap().put(DimensionConstants.DEF_SCENARIO_FIELD, scNumInnMap);
        parameter.getDataManager().getInnNumMap().put(DimensionConstants.DEF_VERSION_FIELD, verInnNumMap);
        parameter.getDataManager().getNumInnMap().put(DimensionConstants.DEF_VERSION_FIELD, verNumInnMap);
        DimensionObject cslDim = new DimensionObject();
        cslDim.setNumber(DimensionBaseConstants.DEF_CSL_NUMBER);
        cslDim.setSrcNumber(DimensionBaseConstants.DEF_CSL_SRCNUMBER);
        cslDim.setField(DimensionBaseConstants.DEF_CSL_FIELD);
        MemberObject member = new MemberObject();
        member.setNumber("CSL-01");
        member.setSrcNumber(DimensionBaseConstants.DEF_CSL_SRCNUMBER);
        cslDim.getDimensionMember().add(member);
        Dimension cslMbgDim = new Dimension();
        cslMbgDim.setNumber(DimensionBaseConstants.DEF_CSL_NUMBER);
        cslMbgDim.setSrcNumber(DimensionBaseConstants.DEF_CSL_SRCNUMBER);
        cslMbgDim.setField(DimensionBaseConstants.DEF_CSL_FIELD);
        Member mbgMember = new Member();
        mbgMember.setNumber("CSL-01");
        mbgMember.setSrcNumber(DimensionBaseConstants.DEF_CSL_SRCNUMBER);
        cslMbgDim.getMembers().add(mbgMember);
        ArrayList<Object> remove = new ArrayList<Object>();
        IDimension dimension = null;
        com.kingdee.eas.ma.mbg.dimension.face.IDimension mbgDim = null;
        List<IDimension> dims = null;
        QueryData queryData = null;
        int in = mbgDims.size();
        for (int i = 0; i < in; ++i) {
            int x;
            int xn;
            int j;
            int jn;
            dims = mbgDims.get(i);
            if (i == 0) {
                jn = dims.size();
                for (j = 0; j < jn; ++j) {
                    dimension = dims.get(j);
                    mbgDim = dimension.toMbgDim();
                    if (DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals(mbgDim.getNumber())) {
                        xn = mbgDim.getDimensionMember().size();
                        for (x = 0; x < xn; ++x) {
                            member = (com.kingdee.eas.ma.mbg.dimension.face.IMember)mbgDim.getDimensionMember().get(x);
                            if (orgUnitNumMap.containsKey(member.getNumber())) continue;
                            remove.add(member);
                        }
                        if (!remove.isEmpty()) {
                            mbgDim.getDimensionMember().removeAll(remove);
                        }
                    }
                    DimUtils.queryItemLongNumber((Context)ctx, (IDimensionParameter)parameter, (IDimensionBase)mbgDim);
                    DimUtils.transScenarioNumber((Context)ctx, (com.kingdee.eas.ma.mbg.dimension.face.IDimension)mbgDim);
                    DimUtils.transVersionNumber((Context)ctx, (com.kingdee.eas.ma.mbg.dimension.face.IDimension)mbgDim);
                    DimUtils.transMdxMemberNumber((Context)ctx, (IDimensionParameter)parameter, (com.kingdee.eas.ma.mbg.dimension.face.IDimension)mbgDim);
                    if (DimUtils.checkBaseDimensionByField((String)mbgDim.getField())) {
                        parameter.getColDims().add(mbgDim);
                    } else {
                        parameter.getRowDims().add(mbgDim);
                    }
                    parameter.getDimensionMap().put(mbgDim.getNumber(), mbgDim);
                }
                parameter.getColDims().add(cslDim);
                parameter.getDimensionMap().put(cslDim.getNumber(), cslDim);
                continue;
            }
            queryData = new QueryData();
            jn = dims.size();
            for (j = 0; j < jn; ++j) {
                dimension = dims.get(j);
                if (DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals(dimension.getNumber())) {
                    remove.clear();
                    xn = dimension.getMembers().size();
                    for (x = 0; x < xn; ++x) {
                        mbgMember = (IMember)dimension.getMembers().get(x);
                        if (orgUnitNumMap.containsKey(mbgMember.getNumber())) continue;
                        remove.add(mbgMember);
                    }
                    if (!remove.isEmpty()) {
                        dimension.getMembers().removeAll(remove);
                    }
                }
                queryData.getMbgDimMap().put(dimension.getField(), dimension);
                MbgCubeUtils.queryItemLongNumber((Context)ctx, (IDimensionParameter)parameter, (IDimension)dimension);
                MbgCubeUtils.transScenarioNumber((Context)ctx, scenaioMap, (IDimension)dimension);
                MbgCubeUtils.transVersionNumber((Context)ctx, versionMap, (IDimension)dimension);
                MbgCubeUtils.transBgPeriodMember((Context)ctx, (IDimensionParameter)parameter, (IDimension)dimension, (boolean)false);
            }
            queryData.getMbgDimMap().put(cslMbgDim.getField(), cslMbgDim);
            parameter.getQuerys().add(queryData);
        }
        orgMbgDataMap = (Map)BgDimensionFacadeFactory.getLocalInstance((Context)ctx).dimensionQuery((IDimensionParameter)parameter);
        return orgMbgDataMap;
    }

    public boolean checkBgOrgUnitHasData(Context ctx, BOSUuid orgUnitId, BgSchemeInfo schemeInfo, boolean hasBudget, boolean hasAct) throws BOSException, EASBizException {
        boolean re = false;
        if (ctx == null || orgUnitId == null || schemeInfo == null) {
            return re;
        }
        Connection conn = null;
        IRowSet rst = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            String mbgSnapVar = MbgVirtualView.getMbgOrgUnitSnap((Connection)conn, (BOSUuid)schemeInfo.getEditOrgViewId());
            String mbgOrgClosure = MbgVirtualView.getBgOrgClosureTable((String)mbgSnapVar);
            if (hasBudget) {
                rst = BgDBUtils.executeQuery((Connection)conn, (String)("select top 1 FOrgUnitId from " + schemeInfo.getRefCube() + " where FOrgUnitId In (select t.FChildID from " + mbgOrgClosure + " t where t.FID = ?) and FState = ?"), (Object[])new Object[]{orgUnitId.toString(), 13});
                if (rst.next()) {
                    boolean bl = true;
                    SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
                    return bl;
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            if (hasAct && (rst = BgDBUtils.executeQuery((Connection)conn, (String)("select top 1 FOrgUnitId from " + schemeInfo.getRefCube() + " where FOrgUnitId In (select t.FChildID from " + mbgOrgClosure + " t where t.FID = ?) and FScenario IN(Select FScenarioId FROM T_MBG_BgScenario Where FType = ?)"), (Object[])new Object[]{orgUnitId.toString(), 1})).next()) {
                re = true;
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, null, (Connection)conn);
        }
        return re;
    }

    public boolean checkHasCslData(Connection conn, BOSUuid orgUnitId, BgSchemeInfo schemeInfo, String bgIndexTmpTable) throws BOSException, EASBizException {
        boolean re = false;
        if (conn == null || orgUnitId == null || schemeInfo == null || bgIndexTmpTable == null) {
            return re;
        }
        IRowSet rst = null;
        String cubeName = BgCubeUtils.getCFSCubeName((String)schemeInfo.getRefCube());
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)("select top 1 FOrgUnitId from " + cubeName + " where FOrgUnitId = ? and F100 = ?  and exists (select FNumber from " + bgIndexTmpTable + " where FNumber = " + cubeName + ".F2) and FState = ?"), (Object[])new Object[]{orgUnitId.toString(), BgCslDimConstants.csl08, 13});
            if (rst.next()) {
                re = true;
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return re;
    }

    public Map<String, IBgNData> builderTotalValue(Map<String, Map<String, IBgNData>> indvDatas, Map<String, Map<String, BgNViewDataInfo>> unionDatas) {
        HashMap<String, IBgNData> totalMap = new HashMap<String, IBgNData>();
        if ((indvDatas == null || indvDatas.isEmpty()) && (unionDatas == null || unionDatas.isEmpty())) {
            return totalMap;
        }
        String dimKey = null;
        IBgNData mbgData = null;
        BgNDataInfo tmpData = null;
        if (indvDatas != null) {
            Map<String, IBgNData> indvDataMap22 = null;
            Object var8_8 = null;
            for (Map<String, IBgNData> indvDataMap22 : indvDatas.values()) {
                for (Map.Entry<String, IBgNData> entry : indvDataMap22.entrySet()) {
                    dimKey = entry.getKey();
                    mbgData = entry.getValue();
                    if (totalMap.containsKey(dimKey)) {
                        tmpData = (IBgNData)totalMap.get(dimKey);
                    } else {
                        tmpData = new BgNDataInfo();
                        tmpData.setFormula(mbgData.getFormula());
                        tmpData.setBgVersion(mbgData.getBgVersion());
                        if (mbgData != null && mbgData.getBudgetValueNoDef() != null) {
                            tmpData.setBudgetValue(BigDecimal.ZERO);
                        } else if (mbgData != null && mbgData.getBizActualNoDef() != null) {
                            tmpData.setBizActual(BigDecimal.ZERO);
                        }
                        totalMap.put(dimKey, (IBgNData)tmpData);
                    }
                    if (mbgData != null && mbgData.getBudgetValueNoDef() != null) {
                        tmpData.setBudgetValue(tmpData.getBudgetValue().add(mbgData.getBudgetValueNoDef()));
                    }
                    if (mbgData == null || mbgData.getBizActualNoDef() == null) continue;
                    tmpData.setBizActual(tmpData.getBizActual().add(mbgData.getBizActualNoDef()));
                }
            }
        }
        if (unionDatas != null) {
            Map<String, BgNViewDataInfo> unionMap = null;
            Object var8_11 = null;
            Map.Entry<String, BgNViewDataInfo> iEntry22 = null;
            String orgUnitId = null;
            for (Map.Entry<String, Map<String, BgNViewDataInfo>> entry : unionDatas.entrySet()) {
                orgUnitId = entry.getKey();
                if (indvDatas != null && indvDatas.containsKey(orgUnitId)) continue;
                unionMap = entry.getValue();
                for (Map.Entry<String, BgNViewDataInfo> iEntry22 : unionMap.entrySet()) {
                    dimKey = iEntry22.getKey();
                    mbgData = (IBgNData)iEntry22.getValue();
                    if (totalMap.containsKey(dimKey)) {
                        tmpData = (IBgNData)totalMap.get(dimKey);
                    } else {
                        tmpData = new BgNDataInfo();
                        tmpData.setFormula(mbgData.getFormula());
                        tmpData.setBgVersion(mbgData.getBgVersion());
                        tmpData.setBudgetValue(BigDecimal.ZERO);
                        totalMap.put(dimKey, (IBgNData)tmpData);
                    }
                    if (mbgData != null && mbgData.getBudgetValueNoDef() != null) {
                        tmpData.setBudgetValue(tmpData.getBudgetValue().add(mbgData.getBudgetValueNoDef()));
                    }
                    if (mbgData == null || mbgData.getBizActualNoDef() == null) continue;
                    tmpData.setBizActual(tmpData.getBizActual().add(mbgData.getBizActualNoDef()));
                }
            }
        }
        return totalMap;
    }

    private Map<String, String> queryOrgUnitId(Context ctx, Map<String, Map<String, IBgNData>> orgDataMap) throws Exception {
        HashMap<String, String> orgUnitNumMap = new HashMap<String, String>();
        OrgUnitInfo orgUnit2 = null;
        Map orgUnitMap = MbgDataHelper.getOrgUnitByNumber((Context)ctx, orgDataMap.keySet());
        for (OrgUnitInfo orgUnit2 : orgUnitMap.values()) {
            orgUnitNumMap.put(orgUnit2.getNumber(), orgUnit2.getId().toString());
        }
        return orgUnitNumMap;
    }

    private void transMbgData(IDimensionParameter parameter, IBgNData bgData, Map<String, String> dimsMap) {
        if (parameter == null || bgData == null || dimsMap == null) {
            return;
        }
        String[] params = BgNFSHelper.parseFormulaPara((String)bgData.getFormula());
        String[] tmpStrs = params[0].split(",");
        dimsMap.clear();
        dimsMap.put(DimensionBaseConstants.DEF_CSL_FIELD, DimensionBaseConstants.DEF_CSL_SRCNUMBER + ":" + "CSL-01");
        int in = tmpStrs.length;
        for (int i = 0; i < in; ++i) {
            dimsMap.put((String)parameter.getDataManager().getSrcFieldMap().get(DimUtils.getSrcNumber((String)tmpStrs[i])), tmpStrs[i]);
        }
        params[0] = DimUtils.getDimNumber(dimsMap);
        bgData.setFormula(BgNFSHelper.getFormulaFromParam((String[])params));
    }

    public void saveIndvData(Context ctx, BOSUuid billId, BOSUuid bgSchemeId, BOSUuid unionId, BOSUuid userId, Map<String, Map<String, IBgNData>> indvDatas, Map<String, Set<String>> formulaMap) throws Exception {
        this.saveIndvData(ctx, billId, bgSchemeId, unionId, userId, indvDatas, null, formulaMap);
    }

    public void saveIndvData(Context ctx, BOSUuid billId, BOSUuid bgSchemeId, BOSUuid unionId, BOSUuid userId, Map<String, Map<String, IBgNData>> indvDatas, List<IMbgBizFacade> bizFacades, Map<String, Set<String>> formulaMap) throws Exception {
        if (ctx == null || bgSchemeId == null || unionId == null || indvDatas == null || indvDatas.isEmpty()) {
            return;
        }
        Map.Entry<String, Map<String, IBgNData>> entry2 = null;
        Map.Entry<String, IBgNData> eData2 = null;
        Map<String, IBgNData> indvData = null;
        String orgUnitId = null;
        IBgNData bgData = null;
        String _bgSchemeId = bgSchemeId.toString();
        String _unionId = unionId.toString();
        String _userId = userId.toString();
        String _billId = billId.toString();
        String dimKey = null;
        String[] tmpStrs = null;
        String adjBosType = new BgCslAdjFormInfo().getBOSType().toString();
        int dataType = DimensionConstants.CFS_DATA_TYPE;
        if (adjBosType.equals(billId.getType().toString())) {
            dataType = DimensionConstants.CFS_ADJUST_DATA_TYPE;
        }
        IMbgDataFacade facade = MbgDataFacade.getInstance((Context)ctx, (String)_userId, (String)_bgSchemeId, (int)dataType);
        facade.setBillId(_billId);
        facade.setUnionId(_unionId);
        if (bizFacades != null) {
            facade.registerFacades(bizFacades);
        }
        for (Map.Entry<String, Map<String, IBgNData>> entry2 : indvDatas.entrySet()) {
            orgUnitId = entry2.getKey();
            indvData = entry2.getValue();
            for (Map.Entry<String, IBgNData> eData2 : indvData.entrySet()) {
                dimKey = eData2.getKey();
                bgData = eData2.getValue();
                if (!this.checkSave(formulaMap, orgUnitId, dimKey)) continue;
                if (bgData != null) {
                    facade.addMbgData(orgUnitId, bgData.getFormula(), bgData.getBgVersion(), bgData.getBudgetValueNoDef() != null ? bgData.getBudgetValueNoDef() : bgData.getBizActualNoDef(), bgData.getBgDataSource());
                    continue;
                }
                tmpStrs = dimKey.split("_");
                if (tmpStrs == null || tmpStrs.length != 2) continue;
                facade.addMbgData(orgUnitId, tmpStrs[0], tmpStrs[1], null, 0);
            }
        }
        facade.submit();
    }

    protected boolean checkSave(Map<String, Set<String>> formulaMap, String orgUnitId, String dimKey) {
        return formulaMap == null || formulaMap.isEmpty() || StringUtils.isEmpty((String)orgUnitId) || StringUtils.isEmpty((String)dimKey) || dimKey.indexOf(BgCslDimConstants.csl01) < 0 || formulaMap.containsKey(orgUnitId) && (!formulaMap.containsKey(orgUnitId) || formulaMap.get(orgUnitId).contains(dimKey));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void builderCsl01from08(Context ctx, TempTablePool pool, BOSUuid orgUnitId, MbgWorkPaperInfo workPaper, BgSchemeInfo schemeInfo, Map<String, MbgDimInfo> mbgDimMap) throws Exception {
        Connection conn;
        block11: {
            if (ctx == null) return;
            if (orgUnitId == null) return;
            if (workPaper == null) return;
            if (schemeInfo == null) return;
            if (mbgDimMap == null) {
                return;
            }
            if (pool == null) {
                pool = TempTablePool.getInstance((Context)ctx);
            }
            String billId = workPaper.getId().toString();
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            String cubeName = BgCubeUtils.getCFSCubeName((String)schemeInfo.getRefCube());
            String cubeEntry = BgCubeUtils.getCFSEntryCubeName((String)schemeInfo.getRefCube());
            String unionId = workPaper.getOrgTree().getId().toString();
            String _orgUnitId = orgUnitId.toString();
            int versionId = workPaper.getBgVersion().getVersionId();
            String tmpTable = null;
            StringBuffer sql = new StringBuffer();
            StringBuffer fields = new StringBuffer();
            sql.append("Create Table TEML_KSQL_0 (FID VARCHAR(44), FOrgUnitID VARCHAR(44), FFormula NVARCHAR(300), FValue NUMERIC(21,8) DEFAULT 0 NOT NULL, F2 NVARCHAR(84), ");
            TreeSet<String> extFieldSet = new TreeSet<String>(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    String str1 = o1.substring(1);
                    String str2 = o2.substring(1);
                    return Integer.valueOf(str1).compareTo(Integer.valueOf(str2));
                }
            });
            Set extDimNum = schemeInfo.getExtDimNums(DimensionConstants.CFS_DATA_TYPE);
            for (String dimNum : extDimNum) {
                extFieldSet.add(mbgDimMap.get(dimNum).getRefField());
            }
            for (String field : extFieldSet) {
                sql.append(field + " NVARCHAR(84), ");
                fields.append(field + ", ");
            }
            sql.append("FBgItemCombination NVARCHAR(300), FBgPeriodID VARCHAR(44), FBgElementID VARCHAR(44), FCurrencyID VARCHAR(44), FScenario INT DEFAULT 0, FVersion INT DEFAULT 0)");
            conn = null;
            try {
                conn = BgDBUtils.getConnection((Context)ctx);
                tmpTable = pool.createTempTable(sql.toString());
                pool.createIndex(tmpTable, "FOrgUnitID, FFormula, FVersion", true, false);
                sql.setLength(0);
                sql.append("Insert Into " + tmpTable + "(FID, FOrgUnitID, FFormula, FValue, F2, ").append(fields).append("FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion) select newbosid('3BA4D30D'), FOrgUnitID, FFormula, FValue, F2, ").append(fields).append("FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion from " + cubeName + " where FUnionId = ? and FOrgUnitID = ? and exists (select FDataId from " + cubeEntry + " where FFormID = ? and FDataId = " + cubeName + ".FID) and F100 = ? and FVersion = ? and FState = ?");
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{unionId, _orgUnitId, billId, BgCslDimConstants.csl08, versionId, 13});
                this.queryCsl08(ctx, conn, pool, orgUnitId, tmpTable, fields, workPaper, schemeInfo);
                BgDBUtils.executeUpdate((Connection)conn, (String)("update " + tmpTable + " set FFormula = REPLACE(FFormula, '" + BgCslDimConstants.csl08 + "', '" + BgCslDimConstants.csl01 + "'), FBgItemCombination = REPLACE(FBgItemCombination, '" + BgCslDimConstants.csl08 + "', '" + BgCslDimConstants.csl01 + "'), F100 = ?"), (Object[])new Object[]{BgCslDimConstants.csl01});
                BgDBUtils.executeUpdate((Connection)conn, (String)("update " + tmpTable + " set FID = (select FID from " + cubeName + " where FUnionID = ? and FOrgUnitID = " + tmpTable + ".FOrgUnitID  and FFormula = " + tmpTable + ".FFormula and FVersion = " + tmpTable + ".FVersion) where exists (select FId from " + cubeName + " where FUnionID = ? and FOrgUnitID = " + tmpTable + ".FOrgUnitID  and FFormula = " + tmpTable + ".FFormula and FVersion = " + tmpTable + ".FVersion)"), (Object[])new Object[]{unionId, unionId});
                sql.setLength(0);
                sql.append("update " + cubeName + " set FValue = 0 where FUnionID = ? and FOrgUnitId = ? and exists (select FDataID from " + cubeEntry + " where FDataID = " + cubeName + ".FID and FFormId = ?) and F100 = ?");
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{unionId, _orgUnitId, billId, BgCslDimConstants.csl01});
                sql.setLength(0);
                sql.append("Insert Into " + cubeName + " (FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FUnionID, FOrgUnitID, FFormula, FValue, FTmpValue, F2, ").append(fields).append("FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState, FIsUpdate) ").append("select FID, '" + userId + "', NOW(), '" + userId + "', NOW(), '" + unionId + "', FOrgUnitID, FFormula, FValue, FValue, F2, " + fields + "FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, " + 9 + ", 1 from " + tmpTable + " where not exists (select FID from " + cubeName + " where FUnionID = ? and FOrgUnitID = " + tmpTable + ".FOrgUnitID and FFormula = " + tmpTable + ".FFormula and FVersion = " + tmpTable + ".FVersion)");
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{unionId});
                sql.setLength(0);
                sql.append("Insert Into " + cubeEntry + " (FDataId, FFormID) select FID, '" + billId + "' from " + tmpTable + " where not exists (select FDataId from " + cubeEntry + " where FDataId = " + tmpTable + ".FID)");
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString());
                sql.setLength(0);
                sql.append("update " + cubeName + " set FValue = (select FValue from " + tmpTable + " where FID = " + cubeName + ".FID) where FUnionID = ? and exists (select FID from " + tmpTable + " where FID = " + cubeName + ".FID)");
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{unionId});
                if (tmpTable == null) break block11;
            }
            catch (SQLDataException ex) {
                try {
                    throw new BOSException((Throwable)ex);
                    catch (SQLException ex2) {
                        logger.error((Object)"cslForm audit sql error:", (Throwable)ex2);
                        throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                    }
                    catch (Exception ex3) {
                        throw ex3;
                    }
                }
                catch (Throwable throwable) {
                    if (tmpTable != null) {
                        pool.releaseTable(tmpTable);
                    }
                    SQLUtils.cleanup((Connection)conn);
                    throw throwable;
                }
            }
            pool.releaseTable(tmpTable);
        }
        SQLUtils.cleanup((Connection)conn);
    }

    private void queryCsl08(Context ctx, Connection conn, TempTablePool pool, BOSUuid orgUnitId, String tmpTable, StringBuffer fields, MbgWorkPaperInfo workPaper, BgSchemeInfo schemeInfo) throws Exception {
        if (ctx == null || pool == null || tmpTable == null || workPaper == null || schemeInfo == null) {
            return;
        }
        IBgDimensionManagerBase manager = null;
        BgDimensionBaseInfo dimInfo = null;
        BgDimensionMember member = null;
        HashMap<String, Set<String>> mbgDimMap = new HashMap<String, Set<String>>();
        Set<String> memberSet = null;
        IMbgViewBase view = null;
        String tmpIndex = null;
        String tmpPeriod = null;
        String tmpElement = null;
        String tmpCurrency = null;
        String tmpScenario = null;
        String field = null;
        String tmpCsl = null;
        ArrayList<String> tmpTables = new ArrayList<String>();
        ArrayList tmpList = new ArrayList();
        String unionId = workPaper.getOrgTree().getId().toString();
        String _orgUnitId = orgUnitId.toString();
        int versionId = workPaper.getBgVersion().getVersionId();
        String cubeName = BgCubeUtils.getCFSCubeName((String)schemeInfo.getRefCube());
        try {
            view = workPaper.getView(ctx, schemeInfo);
            if (view != null && view.getSheetManagers() != null) {
                int in = view.getSheetManagers().size();
                for (int i = 0; i < in; ++i) {
                    manager = ((IMbgSheetBase)view.getSheetManagers().get(i)).getDimensionManager();
                    if (manager == null) continue;
                    if (manager instanceof MbgViewListDimensionManager) {
                        DimUtils.transMbgDimMember((MbgViewListDimensionManager)((MbgViewListDimensionManager)manager));
                    }
                    for (int j = 0; j < manager.getDimension().size(); ++j) {
                        int x;
                        int xn;
                        if (!(manager.getDimension().get(j) instanceof BgDimensionBaseInfo)) continue;
                        dimInfo = (BgDimensionBaseInfo)manager.getDimension().get(j);
                        field = DimUtils.getDimensionField((BgDimensionBaseInfo)dimInfo);
                        if (mbgDimMap.containsKey(field)) {
                            memberSet = (Set)mbgDimMap.get(field);
                        } else {
                            memberSet = new HashSet();
                            mbgDimMap.put(field, memberSet);
                        }
                        List memList = dimInfo.getMember();
                        if (memList == null || memList.isEmpty()) continue;
                        if (DimUtils.checkBaseDimension((BgDimensionBaseInfo)dimInfo)) {
                            xn = memList.size();
                            for (x = 0; x < xn; ++x) {
                                member = (BgDimensionMember)memList.get(x);
                                memberSet.add(member.getNumber());
                            }
                            continue;
                        }
                        xn = memList.size();
                        for (x = 0; x < xn; ++x) {
                            member = (BgDimensionMember)memList.get(x);
                            memberSet.add(DimUtils.getDimNumber((String)member.getSrcNumber(), (String)member.getNumber()));
                        }
                    }
                }
                if (mbgDimMap.containsKey(DimensionConstants.DEF_PERIOD_FIELD)) {
                    memberSet = (Set)mbgDimMap.get(DimensionConstants.DEF_PERIOD_FIELD);
                } else {
                    memberSet = new HashSet();
                    mbgDimMap.put(DimensionConstants.DEF_PERIOD_FIELD, memberSet);
                }
                if (memberSet.isEmpty()) {
                    memberSet.add(workPaper.getBgPeriod().getNumber());
                }
                if (mbgDimMap.containsKey(DimensionConstants.DEF_CURRENCY_FIELD)) {
                    memberSet = (Set)mbgDimMap.get(DimensionConstants.DEF_CURRENCY_FIELD);
                } else {
                    memberSet = new HashSet();
                    mbgDimMap.put(DimensionConstants.DEF_CURRENCY_FIELD, memberSet);
                }
                if (memberSet.isEmpty()) {
                    memberSet.add(workPaper.getCurrency().getNumber());
                }
            }
            if (!(mbgDimMap.containsKey(DimensionBaseConstants.DEF_BGINDEX_FIELD) && mbgDimMap.containsKey(DimensionBaseConstants.DEF_PERIOD_FIELD) && mbgDimMap.containsKey(DimensionBaseConstants.DEF_ELEMENT_FIELD) && mbgDimMap.containsKey(DimensionBaseConstants.DEF_CURRENCY_FIELD) && mbgDimMap.containsKey(DimensionBaseConstants.DEF_SCENARIO_FIELD) && mbgDimMap.containsKey(DimensionBaseConstants.DEF_CSL_FIELD))) {
                return;
            }
            tmpIndex = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FNumber NVARCHAR(84))");
            tmpTables.add(tmpIndex);
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpIndex + " (FNumber) values (?)"), (Collection)((Collection)mbgDimMap.get(DimensionBaseConstants.DEF_BGINDEX_FIELD)));
            tmpCsl = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FNumber NVARCHAR(84))");
            tmpTables.add(tmpCsl);
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpCsl + " (FNumber) values (?)"), (Collection)((Collection)mbgDimMap.get(DimensionBaseConstants.DEF_CSL_FIELD)));
            tmpPeriod = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            tmpTables.add(tmpPeriod);
            tmpList.clear();
            tmpList.addAll((Collection)mbgDimMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD));
            BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpPeriod + " (FID) select FID from T_MBG_BgPeriod where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
            tmpElement = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            tmpTables.add(tmpElement);
            tmpList.clear();
            tmpList.addAll((Collection)mbgDimMap.get(DimensionBaseConstants.DEF_ELEMENT_FIELD));
            BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpElement + " (FID) select FID from T_MBG_BgElement where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
            tmpCurrency = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            tmpTables.add(tmpCurrency);
            tmpList.clear();
            tmpList.addAll((Collection)mbgDimMap.get(DimensionBaseConstants.DEF_CURRENCY_FIELD));
            BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpCurrency + " (FID) select FID from T_BD_Currency where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
            tmpScenario = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID INT DEFAULT 0)");
            tmpTables.add(tmpScenario);
            tmpList.clear();
            tmpList.addAll((Collection)mbgDimMap.get(DimensionBaseConstants.DEF_SCENARIO_FIELD));
            BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpScenario + " (FID) select FScenarioId from T_MBG_BgScenario where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
            StringBuffer sql = new StringBuffer();
            sql.append("Insert Into " + tmpTable + "(FID, FOrgUnitID, FFormula, FValue, F2, ").append(fields).append("FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion) select newbosid('3BA4D30D'), FOrgUnitID, FFormula, FValue, F2, ").append(fields).append("FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion from " + cubeName + " where FUnionId = ? and FOrgUnitId = ? and F100 = ?  and exists (select FNumber from " + tmpIndex + " where FNumber = " + cubeName + ".F2)  and exists (select FID from " + tmpPeriod + " where FID = " + cubeName + ".FBgPeriodID)  and exists (select FID from " + tmpElement + " where FID = " + cubeName + ".FBgElementID)  and exists (select FID from " + tmpCurrency + " where FID = " + cubeName + ".FCurrencyID)  and exists (select FID from " + tmpScenario + " where FID = " + cubeName + ".FScenario)   and FVersion = ? and FState = ? and not exists (select FID from " + tmpTable + " where FOrgUnitID = " + cubeName + ".FOrgUnitID and FFormula = " + cubeName + ".FFormula and FVersion = " + cubeName + ".FVersion)");
            BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{unionId, _orgUnitId, BgCslDimConstants.csl08, versionId, 13});
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            for (String tmpStr : tmpTables) {
                pool.releaseTable(tmpStr);
            }
        }
    }

    public void clearCsl01(Context ctx, TempTablePool pool, BgCslFormInfo cslForm, BgSchemeInfo schemeInfo) throws Exception {
        if (ctx == null || cslForm == null || schemeInfo == null) {
            return;
        }
        if (pool == null) {
            pool = TempTablePool.getInstance((Context)ctx);
        }
        String unionId = cslForm.getOrgTree().getId().toString();
        String orgUnitId = cslForm.getOrgUnit().getId().toString();
        int versionId = cslForm.getBgVersion().getVersionId();
        String cubeName = BgCubeUtils.getCFSCubeName((String)schemeInfo.getRefCube());
        String cubeEntry = BgCubeUtils.getCFSEntryCubeName((String)schemeInfo.getRefCube());
        IMbgViewBase view = null;
        IBgDimensionManagerBase manager = null;
        BgDimensionBaseInfo dimInfo = null;
        BgDimensionMember member = null;
        String tmpTable = null;
        String tmpIndex = null;
        String tmpPeriod = null;
        String tmpElement = null;
        String tmpCurrency = null;
        String tmpScenario = null;
        String field = null;
        HashMap<String, Set<String>> mbgDimMap = new HashMap<String, Set<String>>();
        Set<String> memberSet = null;
        ArrayList<String> tmpTables = new ArrayList<String>();
        ArrayList tmpList = new ArrayList();
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            tmpTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            view = cslForm.getView(ctx, schemeInfo);
            if (view != null && view.getSheetManagers() != null) {
                int in = view.getSheetManagers().size();
                for (int i = 0; i < in; ++i) {
                    manager = ((IMbgSheetBase)view.getSheetManagers().get(i)).getDimensionManager();
                    if (manager == null) continue;
                    if (manager instanceof MbgViewListDimensionManager) {
                        DimUtils.transMbgDimMember((MbgViewListDimensionManager)((MbgViewListDimensionManager)manager));
                    }
                    for (int j = 0; j < manager.getDimension().size(); ++j) {
                        int x;
                        int xn;
                        if (!(manager.getDimension().get(j) instanceof BgDimensionBaseInfo)) continue;
                        dimInfo = (BgDimensionBaseInfo)manager.getDimension().get(j);
                        field = DimUtils.getDimensionField((BgDimensionBaseInfo)dimInfo);
                        if (mbgDimMap.containsKey(field)) {
                            memberSet = (Set)mbgDimMap.get(field);
                        } else {
                            memberSet = new HashSet();
                            mbgDimMap.put(field, memberSet);
                        }
                        List memList = dimInfo.getMember();
                        if (memList == null || memList.isEmpty()) continue;
                        if (DimUtils.checkBaseDimension((BgDimensionBaseInfo)dimInfo)) {
                            xn = memList.size();
                            for (x = 0; x < xn; ++x) {
                                member = (BgDimensionMember)memList.get(x);
                                memberSet.add(member.getNumber());
                            }
                            continue;
                        }
                        xn = memList.size();
                        for (x = 0; x < xn; ++x) {
                            member = (BgDimensionMember)memList.get(x);
                            memberSet.add(DimUtils.getDimNumber((String)member.getSrcNumber(), (String)member.getNumber()));
                        }
                    }
                }
                if (mbgDimMap.containsKey(DimensionConstants.DEF_PERIOD_FIELD)) {
                    memberSet = (Set)mbgDimMap.get(DimensionConstants.DEF_PERIOD_FIELD);
                } else {
                    memberSet = new HashSet();
                    mbgDimMap.put(DimensionConstants.DEF_PERIOD_FIELD, memberSet);
                }
                if (memberSet.isEmpty()) {
                    memberSet.add(cslForm.getBgPeriod().getNumber());
                }
                if (mbgDimMap.containsKey(DimensionConstants.DEF_CURRENCY_FIELD)) {
                    memberSet = (Set)mbgDimMap.get(DimensionConstants.DEF_CURRENCY_FIELD);
                } else {
                    memberSet = new HashSet();
                    mbgDimMap.put(DimensionConstants.DEF_CURRENCY_FIELD, memberSet);
                }
                if (memberSet.isEmpty()) {
                    memberSet.add(cslForm.getCurrency().getNumber());
                }
            }
            if (!(mbgDimMap.containsKey(DimensionBaseConstants.DEF_BGINDEX_FIELD) && mbgDimMap.containsKey(DimensionBaseConstants.DEF_PERIOD_FIELD) && mbgDimMap.containsKey(DimensionBaseConstants.DEF_ELEMENT_FIELD) && mbgDimMap.containsKey(DimensionBaseConstants.DEF_CURRENCY_FIELD) && mbgDimMap.containsKey(DimensionBaseConstants.DEF_SCENARIO_FIELD) && mbgDimMap.containsKey(DimensionBaseConstants.DEF_CSL_FIELD))) {
                return;
            }
            tmpIndex = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FNumber NVARCHAR(84))");
            tmpTables.add(tmpIndex);
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpIndex + " (FNumber) values (?)"), (Collection)((Collection)mbgDimMap.get(DimensionBaseConstants.DEF_BGINDEX_FIELD)));
            tmpPeriod = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            tmpTables.add(tmpPeriod);
            tmpList.clear();
            if (this.getClosureMap() != null) {
                Set periodNumberSet = (Set)mbgDimMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD);
                for (String periodNumber : periodNumberSet) {
                    if (this.getClosureMap().get(periodNumber) == null) continue;
                    tmpList.addAll(this.getClosureMap().get(periodNumber));
                }
            } else {
                tmpList.addAll((Collection)mbgDimMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD));
            }
            BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpPeriod + " (FID) select FID from T_MBG_BgPeriod where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
            tmpElement = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            tmpTables.add(tmpElement);
            tmpList.clear();
            tmpList.addAll((Collection)mbgDimMap.get(DimensionBaseConstants.DEF_ELEMENT_FIELD));
            BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpElement + " (FID) select FID from T_MBG_BgElement where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
            tmpCurrency = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            tmpTables.add(tmpCurrency);
            tmpList.clear();
            tmpList.addAll((Collection)mbgDimMap.get(DimensionBaseConstants.DEF_CURRENCY_FIELD));
            BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpCurrency + " (FID) select FID from T_BD_Currency where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
            tmpScenario = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID INT DEFAULT 0)");
            tmpTables.add(tmpScenario);
            tmpList.clear();
            tmpList.addAll((Collection)mbgDimMap.get(DimensionBaseConstants.DEF_SCENARIO_FIELD));
            BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpScenario + " (FID) select FScenarioId from T_MBG_BgScenario where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
            StringBuffer sql = new StringBuffer();
            if (cslForm.isOnlyDealCurBgForm()) {
                sql.append("Insert Into " + tmpTable + "(FID) select FID from " + cubeName + " where FUnionId = ? and FOrgUnitId = ? and F100 = ?  and exists (select FDataId from " + cubeEntry + " where FFormID = ? and FDataId = " + cubeName + ".FID)  and FVersion = ?");
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{unionId, orgUnitId, BgCslDimConstants.csl01, cslForm.getId().toString(), versionId});
            } else {
                sql.append("Insert Into " + tmpTable + "(FID) select FID from " + cubeName + " where FUnionId = ? and FOrgUnitId = ? and F100 = ?  and exists (select FNumber from " + tmpIndex + " where FNumber = " + cubeName + ".F2)  and exists (select FID from " + tmpPeriod + " where FID = " + cubeName + ".FBgPeriodID)  and exists (select FID from " + tmpElement + " where FID = " + cubeName + ".FBgElementID)  and exists (select FID from " + tmpCurrency + " where FID = " + cubeName + ".FCurrencyID)  and exists (select FID from " + tmpScenario + " where FID = " + cubeName + ".FScenario)   and FVersion = ?");
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{unionId, orgUnitId, BgCslDimConstants.csl01, versionId});
            }
            BgDBUtils.executeUpdate((Connection)conn, (String)("delete from " + cubeName + " where exists (select FID from " + tmpTable + " where FID = " + cubeName + ".FID)"));
            BgDBUtils.executeUpdate((Connection)conn, (String)("delete from " + cubeEntry + " where exists (select FID from " + tmpTable + " where FID = " + cubeEntry + ".FDataID)"));
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (SQLException ex) {
            logger.error((Object)"cslForm audit sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (tmpTable != null) {
                pool.releaseTable(tmpTable);
            }
            SQLUtils.cleanup((Connection)conn);
        }
    }

    public void auditCsl08(Context ctx, TempTablePool pool, BgCslFormInfo bgCslForm, BgSchemeInfo schemeInfo, String audOrgUnitId) throws Exception {
        int[] states = new int[]{1, 5};
        this.updateCsl08State(ctx, pool, bgCslForm, schemeInfo, 9, states, audOrgUnitId);
    }

    public void unAuditCsl08(Context ctx, TempTablePool pool, BgCslFormInfo bgCslForm, BgSchemeInfo schemeInfo, String audOrgUnitId) throws Exception {
        int[] states = new int[]{9};
        this.updateCsl08State(ctx, pool, bgCslForm, schemeInfo, 1, states, audOrgUnitId);
    }

    private void updateCsl08State(Context ctx, TempTablePool pool, BgCslFormInfo bgCslForm, BgSchemeInfo schemeInfo, int toState, int[] fromState, String audOrgUnitId) throws Exception {
        String userId;
        if (ctx == null || bgCslForm == null || schemeInfo == null) {
            return;
        }
        if (pool == null) {
            pool = TempTablePool.getInstance((Context)ctx);
        }
        String billId = bgCslForm.getId().toString();
        String string = userId = 1 == toState ? null : ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        if (9 == toState && StringUtils.isEmpty((String)audOrgUnitId)) {
            audOrgUnitId = bgCslForm.getOrgUnit().getId().toString();
        }
        String audFormId = 1 == toState ? null : billId;
        String cubeName = BgCubeUtils.getCFSCubeName((String)schemeInfo.getRefCube());
        String cubeEntry = BgCubeUtils.getCFSEntryCubeName((String)schemeInfo.getRefCube());
        String adjCube = BgCubeUtils.getCFSAdjustCubeName((String)schemeInfo.getRefCube());
        String unionId = bgCslForm.getOrgTree().getId().toString();
        String orgUnitId = bgCslForm.getOrgUnit().getId().toString();
        int versionId = bgCslForm.getBgVersion().getVersionId();
        Object tmpTable = null;
        StringBuffer sql = new StringBuffer();
        IBgDimensionManagerBase manager = null;
        BgDimensionBaseInfo dimInfo = null;
        BgDimensionMember member = null;
        HashMap<String, Set<String>> mbgMemberMap = new HashMap<String, Set<String>>();
        Set<String> memberSet = null;
        IMbgViewBase view = null;
        String tmpIndex = null;
        String tmpPeriod = null;
        String tmpElement = null;
        String tmpCurrency = null;
        String tmpScenario = null;
        String field = null;
        String tmpCsl = null;
        ArrayList<String> tmpTables = new ArrayList<String>();
        ArrayList tmpList = new ArrayList();
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            Map mbgDimMap = DimUtils.getDimNumMap((Connection)conn, (Locale)ctx.getLocale());
            StringBuffer fields = new StringBuffer();
            TreeSet<String> extFieldSet = new TreeSet<String>(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    String str1 = o1.substring(1);
                    String str2 = o2.substring(1);
                    return Integer.valueOf(str1).compareTo(Integer.valueOf(str2));
                }
            });
            Set extDimNum = schemeInfo.getExtDimNums(DimensionConstants.CFS_DATA_TYPE);
            for (String dimNum : extDimNum) {
                extFieldSet.add(((MbgDimInfo)mbgDimMap.get(dimNum)).getRefField());
            }
            for (String f : extFieldSet) {
                fields.append(f + ", ");
            }
            sql.setLength(0);
            sql.append("update " + cubeName + " set FState = ?, FAudOrgUnitID = ?, FAudUserID = ?,FAudFormId = ? where FUnionId = ? and FOrgUnitID = ? and exists (select FDataId from " + cubeEntry + " where FFormID = ? and FDataId = " + cubeName + ".FID) and F100 = ? and FVersion = ? and FState IN " + BgDBUtils.getSqlParam((int[])fromState));
            BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{toState, audOrgUnitId, userId, audFormId, unionId, orgUnitId, billId, BgCslDimConstants.csl08, versionId});
            view = bgCslForm.getView(ctx, schemeInfo);
            if (view != null && view.getSheetManagers() != null) {
                int in = view.getSheetManagers().size();
                for (int i = 0; i < in; ++i) {
                    manager = ((IMbgSheetBase)view.getSheetManagers().get(i)).getDimensionManager();
                    if (manager == null) continue;
                    if (manager instanceof MbgViewListDimensionManager) {
                        DimUtils.transMbgDimMember((MbgViewListDimensionManager)((MbgViewListDimensionManager)manager));
                    }
                    for (int j = 0; j < manager.getDimension().size(); ++j) {
                        int x;
                        int xn;
                        if (!(manager.getDimension().get(j) instanceof BgDimensionBaseInfo)) continue;
                        dimInfo = (BgDimensionBaseInfo)manager.getDimension().get(j);
                        field = DimUtils.getDimensionField((BgDimensionBaseInfo)dimInfo);
                        if (mbgMemberMap.containsKey(field)) {
                            memberSet = (Set)mbgMemberMap.get(field);
                        } else {
                            memberSet = new HashSet();
                            mbgMemberMap.put(field, memberSet);
                        }
                        List memList = dimInfo.getMember();
                        if (memList == null || memList.isEmpty()) continue;
                        if (DimUtils.checkBaseDimension((BgDimensionBaseInfo)dimInfo)) {
                            xn = memList.size();
                            for (x = 0; x < xn; ++x) {
                                member = (BgDimensionMember)memList.get(x);
                                memberSet.add(member.getNumber());
                            }
                            continue;
                        }
                        xn = memList.size();
                        for (x = 0; x < xn; ++x) {
                            member = (BgDimensionMember)memList.get(x);
                            memberSet.add(DimUtils.getDimNumber((String)member.getSrcNumber(), (String)member.getNumber()));
                        }
                    }
                }
                if (mbgMemberMap.containsKey(DimensionConstants.DEF_PERIOD_FIELD)) {
                    memberSet = (Set)mbgMemberMap.get(DimensionConstants.DEF_PERIOD_FIELD);
                } else {
                    memberSet = new HashSet();
                    mbgMemberMap.put(DimensionConstants.DEF_PERIOD_FIELD, memberSet);
                }
                if (memberSet.isEmpty()) {
                    memberSet.add(bgCslForm.getBgPeriod().getNumber());
                }
                if (mbgMemberMap.containsKey(DimensionConstants.DEF_CURRENCY_FIELD)) {
                    memberSet = (Set)mbgMemberMap.get(DimensionConstants.DEF_CURRENCY_FIELD);
                } else {
                    memberSet = new HashSet();
                    mbgMemberMap.put(DimensionConstants.DEF_CURRENCY_FIELD, memberSet);
                }
                if (memberSet.isEmpty()) {
                    memberSet.add(bgCslForm.getCurrency().getNumber());
                }
            }
            if (!(mbgMemberMap.containsKey(DimensionBaseConstants.DEF_BGINDEX_FIELD) && mbgMemberMap.containsKey(DimensionBaseConstants.DEF_PERIOD_FIELD) && mbgMemberMap.containsKey(DimensionBaseConstants.DEF_ELEMENT_FIELD) && mbgMemberMap.containsKey(DimensionBaseConstants.DEF_CURRENCY_FIELD) && mbgMemberMap.containsKey(DimensionBaseConstants.DEF_SCENARIO_FIELD) && mbgMemberMap.containsKey(DimensionBaseConstants.DEF_CSL_FIELD))) {
                return;
            }
            tmpIndex = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FNumber NVARCHAR(84))");
            tmpTables.add(tmpIndex);
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpIndex + " (FNumber) values (?)"), (Collection)((Collection)mbgMemberMap.get(DimensionBaseConstants.DEF_BGINDEX_FIELD)));
            this.querySubMember(conn, schemeInfo, DimensionBaseConstants.DEF_INDEX_NUMBER, (Set)mbgMemberMap.get(DimensionBaseConstants.DEF_BGINDEX_FIELD), tmpIndex);
            tmpCsl = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FNumber NVARCHAR(84))");
            tmpTables.add(tmpCsl);
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpCsl + " (FNumber) values (?)"), (Collection)((Collection)mbgMemberMap.get(DimensionBaseConstants.DEF_CSL_FIELD)));
            tmpPeriod = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            tmpTables.add(tmpPeriod);
            tmpList.clear();
            if (this.getClosureMap() != null) {
                Set periodNumberSet = (Set)mbgMemberMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD);
                for (String periodNumber : periodNumberSet) {
                    if (this.getClosureMap().get(periodNumber) == null) continue;
                    tmpList.addAll(this.getClosureMap().get(periodNumber));
                }
            } else {
                tmpList.addAll((Collection)mbgMemberMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD));
            }
            BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpPeriod + " (FID) select FID from T_MBG_BgPeriod where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
            tmpElement = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            tmpTables.add(tmpElement);
            tmpList.clear();
            tmpList.addAll((Collection)mbgMemberMap.get(DimensionBaseConstants.DEF_ELEMENT_FIELD));
            BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpElement + " (FID) select FID from T_MBG_BgElement where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
            tmpCurrency = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            tmpTables.add(tmpCurrency);
            tmpList.clear();
            tmpList.addAll((Collection)mbgMemberMap.get(DimensionBaseConstants.DEF_CURRENCY_FIELD));
            BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpCurrency + " (FID) select FID from T_BD_Currency where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
            tmpScenario = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID INT DEFAULT 0)");
            tmpTables.add(tmpScenario);
            tmpList.clear();
            tmpList.addAll((Collection)mbgMemberMap.get(DimensionBaseConstants.DEF_SCENARIO_FIELD));
            BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpScenario + " (FID) select FScenarioId from T_MBG_BgScenario where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
            if (!bgCslForm.isOnlyDealCurBgForm()) {
                sql.setLength(0);
                sql.append("update " + cubeName + " set FState = ?, FAudOrgUnitID = ?, FAudUserID = ?,FAudFormId = ? where FUnionId = ? and FOrgUnitId = ? and F100 = ?  and exists (select FNumber from " + tmpIndex + " where FNumber = " + cubeName + ".F2)  and exists (select FID from " + tmpPeriod + " where FID = " + cubeName + ".FBgPeriodID)  and exists (select FID from " + tmpElement + " where FID = " + cubeName + ".FBgElementID)  and exists (select FID from " + tmpCurrency + " where FID = " + cubeName + ".FCurrencyID)  and exists (select FID from " + tmpScenario + " where FID = " + cubeName + ".FScenario)   and FVersion = ? and FState IN " + BgDBUtils.getSqlParam((int[])fromState));
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{toState, audOrgUnitId, userId, audFormId, unionId, orgUnitId, BgCslDimConstants.csl08, versionId});
            }
            if ((9 == toState || 1 == toState) && BgDBUtils.existTable((Connection)conn, (String)adjCube) == BgDBUtils.YES) {
                sql.setLength(0);
                sql.append("update " + adjCube + " set FState = ?, FValue = (select FValue from " + cubeName + " where FUnionId = " + adjCube + ".FUnionId and FOrgUnitId = " + adjCube + ".FOrgUnitId and FFormula = " + adjCube + ".FFormula and FVersion = " + adjCube + ".FVersion) ");
                if (bgCslForm.isOnlyDealCurBgForm()) {
                    sql.append(" where exists (select FID from " + cubeName + " na," + cubeEntry + " en where na.FID = en.FDataID and en.FFormID = '" + billId + "' and na.FUnionId = " + adjCube + ".FUnionId and na.FOrgUnitId = " + adjCube + ".FOrgUnitId and na.FFormula = " + adjCube + ".FFormula and na.FVersion = " + adjCube + ".FVersion) ");
                } else {
                    sql.append(" where exists (select FID from " + cubeName + " where FUnionId = " + adjCube + ".FUnionId and FOrgUnitId = " + adjCube + ".FOrgUnitId and FFormula = " + adjCube + ".FFormula and FVersion = " + adjCube + ".FVersion) ");
                }
                sql.append(" and FUnionId = ? and FOrgUnitId = ?  and exists (select FNumber from " + tmpIndex + " where FNumber = " + adjCube + ".F2)  and F100 = ?  and exists (select FID from " + tmpPeriod + " where FID = " + adjCube + ".FBgPeriodID)  and exists (select FID from " + tmpElement + " where FID = " + adjCube + ".FBgElementID)  and exists (select FID from " + tmpCurrency + " where FID = " + adjCube + ".FCurrencyID)  and exists (select FID from " + tmpScenario + " where FID = " + adjCube + ".FScenario)  and FVersion = ?");
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{toState, unionId, orgUnitId, BgCslDimConstants.csl08, versionId});
            }
            if (9 == toState && BgDBUtils.existTable((Connection)conn, (String)adjCube) == BgDBUtils.YES) {
                sql.setLength(0);
                sql.append("Insert Into " + adjCube + "(FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FUnionID, FOrgUnitID, FFormula, FValue, FTmpValue, F2, ").append(fields).append("FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState, FIsUpdate ) select newbosid('3BA4D30D'), '" + userId + "', NOW(), '" + userId + "',  NOW(), '" + unionId + "', FOrgUnitID, FFormula, FValue, FValue, F2, ").append(fields).append("FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, 9, 1 from " + cubeName + " where FUnionId = ? and FOrgUnitId = ? and F100 = ?  and exists (select FNumber from " + tmpIndex + " where FNumber = " + cubeName + ".F2)  and exists (select FID from " + tmpPeriod + " where FID = " + cubeName + ".FBgPeriodID)  and exists (select FID from " + tmpElement + " where FID = " + cubeName + ".FBgElementID)  and exists (select FID from " + tmpCurrency + " where FID = " + cubeName + ".FCurrencyID)  and exists (select FID from " + tmpScenario + " where FID = " + cubeName + ".FScenario)   and FVersion = ?  and not exists (select FID from " + adjCube + " where FOrgUnitID = " + cubeName + ".FOrgUnitID and FFormula = " + cubeName + ".FFormula and FVersion = " + cubeName + ".FVersion)");
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{unionId, orgUnitId, BgCslDimConstants.csl08, versionId});
            }
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (SQLException ex) {
            logger.error((Object)"cslForm audit sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (tmpTable != null) {
                BgDBUtils.releaseTmpTable((TempTablePool)pool, tmpTables);
            }
            SQLUtils.cleanup((Connection)conn);
        }
    }

    protected void querySubMember(Connection conn, BgSchemeInfo bgScheme, String mbgDimNumber, Set<String> dimNumbers, String tmpTable) throws EASBizException {
        if (conn == null || bgScheme == null || mbgDimNumber == null || dimNumbers == null || dimNumbers.isEmpty() || tmpTable == null) {
            return;
        }
        IRowSet rst = null;
        BOSUuid viewId = bgScheme.getViewId(mbgDimNumber);
        if (viewId == null) {
            return;
        }
        ArrayList<String> sqlParams = new ArrayList<String>();
        List rsts = null;
        Object[] objs = null;
        HashSet<String> factDataSet = new HashSet<String>();
        String longNumber = null;
        String[] numbers = null;
        StringBuffer sql = new StringBuffer();
        try {
            int i;
            String factTable = MbgVirtualView.getFactTable((Connection)conn, (BOSUuid)viewId);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)("select FLongNumber from " + factTable + " where exists (select FNumber from " + tmpTable + " where FNumber = " + factTable + ".FDimNumber)"));
            while (rst.next()) {
                sqlParams.add(rst.getString(1) + "!%");
            }
            SQLUtils.cleanup((ResultSet)rst);
            sql.append("select FDimLongNumber from " + factTable + " where FLongNumber like ? ");
            for (i = 1; i < 100; ++i) {
                sql.append(" OR FLongNumber like ? ");
            }
            rsts = BgDBUtils.executeBatchQuery((Connection)conn, (String)sql.toString(), sqlParams, (int)100);
            int in = rsts.size();
            for (i = 0; i < in; ++i) {
                objs = (Object[])rsts.get(i);
                longNumber = (String)objs[0];
                if (longNumber == null || (numbers = longNumber.split("!")) == null) continue;
                for (int j = 0; j < numbers.length; ++j) {
                    if (dimNumbers.contains(numbers[j])) continue;
                    factDataSet.add(numbers[j]);
                }
            }
            if (!factDataSet.isEmpty()) {
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTable + " (FNumber) values (?)"), factDataSet);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"querySubMember sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
    }
}

