/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.ma.base.BgPeriodDispCollection;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgPeriodDispInfo;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.BizCalcInfo;
import com.kingdee.eas.ma.biz.client.AbstractBizCalcExecuteUI;
import com.kingdee.eas.ma.biz.client.utils.BizCalcUtils;
import com.kingdee.eas.ma.biz.utils.BizConstants;
import com.kingdee.eas.ma.mbg.BgMemberSelectTypeEnum;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.client.common.BgProcessSelectDialog;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectDialog;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListResultData;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BizCalcExecuteUI
extends AbstractBizCalcExecuteUI {
    private static final Logger logger = CoreUIObject.getLogger(BizCalcExecuteUI.class);
    private boolean isCancle = true;
    protected BizCalcInfo bizCalcInfo = null;
    protected BgSchemeDimensionHelper helper = null;
    private Map<String, Set<String>> data = new HashMap<String, Set<String>>();
    private BgSchemeInfo bgSchemeInfo = null;
    private OrgUnitInfo orgUnitInfo = null;
    private BizCalcUtils utils = new BizCalcUtils();

    public boolean isCancle() {
        return this.isCancle;
    }

    public BgSchemeDimensionHelper getSchemeHelper() {
        if (this.helper == null) {
            try {
                this.helper = new BgSchemeDimensionHelper(this.getBgSchemeInfo().getId().toString());
            }
            catch (Exception ex) {
                logger.error((Object)"getSchemeHelper error:", (Throwable)ex);
                this.handUIExceptionAndAbort(ex);
            }
        }
        return this.helper;
    }

    public Map<String, Set<String>> getData() {
        return this.data;
    }

    public void setData(Map<String, Set<String>> data) {
        this.data = data;
    }

    public BgSchemeInfo getBgSchemeInfo() {
        return this.bgSchemeInfo;
    }

    public void setBgSchemeInfo(BgSchemeInfo bgSchemeInfo) {
        this.bgSchemeInfo = bgSchemeInfo;
    }

    public OrgUnitInfo getOrgUnitInfo() {
        return this.orgUnitInfo;
    }

    public void setOrgUnitInfo(OrgUnitInfo orgUnitInfo) {
        this.orgUnitInfo = orgUnitInfo;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initData();
        this.initPrmt();
        this.fillDefaultMember();
    }

    private void fillDefaultMember() {
        Map defaultMember = this.helper.getDefaultMember();
        if (defaultMember != null && !defaultMember.isEmpty()) {
            CurrencyInfo currencyInfo;
            BgPeriodInfo periodInfo;
            BgDimensionMember dimMember;
            ArrayList<BgDimensionMember> members;
            BgVersionInfo versionInfo;
            MbgViewListResultData data = null;
            if (defaultMember.get(DimensionBaseConstants.DEF_VERSION_NUMBER) != null && (versionInfo = (BgVersionInfo)defaultMember.get(DimensionBaseConstants.DEF_VERSION_NUMBER)) != null) {
                data = new MbgViewListResultData();
                data.setMemberType(BgMemberSelectTypeEnum.Member);
                members = new ArrayList<BgDimensionMember>();
                dimMember = new BgDimensionMember(DimensionBaseConstants.DEF_VERSION_NUMBER, DimensionBaseConstants.DEF_VERSION_FIELD, versionInfo.getName(), versionInfo.getNumber());
                members.add(dimMember);
                data.setMembers(members);
                this.prmtBgVersion.setData((Object)data);
            }
            if (defaultMember.get(DimensionBaseConstants.DEF_PERIOD_NUMBER) != null && (periodInfo = (BgPeriodInfo)defaultMember.get(DimensionBaseConstants.DEF_PERIOD_NUMBER)) != null) {
                data = new MbgViewListResultData();
                data.setMemberType(BgMemberSelectTypeEnum.Member);
                members = new ArrayList();
                dimMember = new BgDimensionMember(DimensionBaseConstants.DEF_PERIOD_NUMBER, DimensionBaseConstants.DEF_PERIOD_FIELD, periodInfo.getName(), periodInfo.getNumber());
                dimMember.setAlias(periodInfo.getName());
                members.add(dimMember);
                data.setMembers(members);
                this.prmtBgPeriod.setData((Object)data);
            }
            if (defaultMember.get(DimensionBaseConstants.DEF_VERSION_NUMBER) != null && (currencyInfo = (CurrencyInfo)defaultMember.get(DimensionBaseConstants.DEF_CURRENCY_NUMBER)) != null) {
                data = new MbgViewListResultData();
                data.setMemberType(BgMemberSelectTypeEnum.Member);
                members = new ArrayList();
                dimMember = new BgDimensionMember(DimensionBaseConstants.DEF_CURRENCY_NUMBER, DimensionBaseConstants.DEF_CURRENCY_FIELD, currencyInfo.getName(), currencyInfo.getNumber());
                members.add(dimMember);
                data.setMembers(members);
                this.prmtCurrency.setData((Object)data);
            }
        }
    }

    private void initData() throws BOSException {
        if (this.getUIContext().get("orgUnitInfo") != null) {
            this.orgUnitInfo = (OrgUnitInfo)this.getUIContext().get("orgUnitInfo");
        }
        if (this.getUIContext().get("bgSchemeInfo") != null) {
            this.bgSchemeInfo = (BgSchemeInfo)this.getUIContext().get("bgSchemeInfo");
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void initPrmt() {
        this.initF7Dialog(this.prmtBgOrgUnit, this.getSchemeHelper().getDimension(DimensionBaseConstants.DEF_ORGUNIT_NUMBER));
        this.initF7Dialog(this.prmtBgVersion, this.getSchemeHelper().getDimension(DimensionBaseConstants.DEF_VERSION_NUMBER));
        this.initF7Dialog(this.prmtBgPeriod, this.getSchemeHelper().getDimension(DimensionBaseConstants.DEF_PERIOD_NUMBER));
        this.initF7Dialog(this.prmtCurrency, this.getSchemeHelper().getDimension(DimensionBaseConstants.DEF_CURRENCY_NUMBER));
        this.initProcessType();
    }

    protected void initProcessType() {
        BgProcessSelectDialog dialog = new BgProcessSelectDialog((IUIObject)this, true);
        HashSet<String> filterMembers = new HashSet<String>();
        filterMembers.add(BgProcessEnum.C03.getName());
        dialog.setFilterMembers(filterMembers);
        this.prmtProcessType.setSelector((KDPromptSelector)dialog);
        this.prmtProcessType.setData((Object)BgProcessEnum.C01);
        HashSet<String> members = new HashSet<String>();
        members.add(((BgProcessEnum)this.prmtProcessType.getData()).getName());
        dialog.setSelectedMembers(members);
    }

    private void initF7Dialog(KDBizPromptBox prmt, Object dimension) {
        DimensionMemberSelectDialog dialog = this.getDimensionMemberSelectDialog(true, true);
        dialog.setDimension(dimension);
        dialog.setCanFillType(false);
        dialog.setOrgId(this.getOrgUnitInfo().getId().toString());
        dialog.setBgSchemeId(this.getBgSchemeInfo().getId().toString());
        dialog.setCanSelectType(false);
        dialog.setFilterRollVersion(true);
        Date beginDate = (Date)this.getUIContext().get("beginDate");
        Date endDate = (Date)this.getUIContext().get("endDate");
        if (beginDate == null) {
            beginDate = this.getBgSchemeInfo().getDateFrom();
        }
        if (endDate == null) {
            endDate = this.getBgSchemeInfo().getDateTo();
        }
        dialog.setBgPeriodBeginDate(beginDate);
        dialog.setBgPeriodEndDate(endDate);
        BgCommHelper.removeUndo((KDBizPromptBox)prmt);
        prmt.setSelector((KDPromptSelector)dialog);
        prmt.addDataChangeListener((DataChangeListener)dialog);
        prmt.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                Object obj = e.getSource();
                if (obj instanceof KDBizPromptBox && ((KDBizPromptBox)obj).getSelector() instanceof DimensionMemberSelectDialog) {
                    ((DimensionMemberSelectDialog)((KDBizPromptBox)obj).getSelector()).reSetF7UI();
                    ((DimensionMemberSelectDialog)((KDBizPromptBox)obj).getSelector()).setCurSelectFunction(null);
                    if (((KDBizPromptBox)obj).getData() instanceof MbgViewListResultData) {
                        ((DimensionMemberSelectDialog)((KDBizPromptBox)obj).getSelector()).setCurSelectFunction((MbgViewListResultData)((KDBizPromptBox)obj).getData());
                    }
                }
            }
        });
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.txtDiscription.setText(EASResource.getString((String)BizConstants.BIZ_RESOURCE, (String)"bizCalcExecuteDetail"));
    }

    protected DimensionMemberSelectDialog getDimensionMemberSelectDialog(boolean isMulti, boolean hasShowExtDim) {
        DimensionMemberSelectDialog dialog = this.getUtils().getDimensionMemberSelectDialog();
        dialog.setOwner((Component)((Object)this));
        dialog.setMulti(isMulti);
        dialog.setOnlySelectItem(true);
        dialog.setSelectCombinItem(false);
        dialog.setOnlyRefDim(hasShowExtDim);
        return dialog;
    }

    public BizCalcUtils getUtils() {
        return this.utils;
    }

    @Override
    protected void btnSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtProcessType.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)BizConstants.BIZ_RESOURCE, (String)"selectProcess"));
            return;
        }
        this.fillData(DimensionBaseConstants.DEF_ORGUNIT_FIELD, this.prmtBgOrgUnit.getData());
        this.fillData(DimensionBaseConstants.DEF_VERSION_FIELD, this.prmtBgVersion.getData());
        this.fillData(DimensionBaseConstants.DEF_PERIOD_FIELD, this.prmtBgPeriod.getData());
        this.fillData(DimensionBaseConstants.DEF_CURRENCY_FIELD, this.prmtCurrency.getData());
        this.dealDimensionData();
        this.isCancle = false;
        this.destroyWindow();
    }

    private void fillData(String dimensionNumber, Object prmtData) throws BOSException {
        if (prmtData != null && prmtData instanceof MbgViewListResultData) {
            HashSet<String> numbers = new HashSet<String>();
            MbgViewListResultData result = (MbgViewListResultData)prmtData;
            List members = result.getMembers();
            for (BgDimensionMember member : members) {
                numbers.add(member.getNumber());
            }
            this.data.put(dimensionNumber, numbers);
        }
    }

    private void dealDimensionData() throws BOSException {
        Object[] objectArray;
        String bgOrgViewId = this.helper.getBgOrgViewId();
        Set<String> numbers = null;
        if (this.data != null && this.data.get(DimensionBaseConstants.DEF_ORGUNIT_FIELD) != null) {
            numbers = this.data.get(DimensionBaseConstants.DEF_ORGUNIT_FIELD);
            BgOrgUnitCollection bgOrgUnits = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection("select id,number,longNumber,isLeaf where viewID = '" + bgOrgViewId + "'");
            HashSet<String> result = new HashSet<String>();
            if (bgOrgUnits != null && !bgOrgUnits.isEmpty()) {
                for (String string : numbers) {
                    int in = bgOrgUnits.size();
                    for (int i = 0; i < in; ++i) {
                        BgOrgUnitInfo bgOrgUnitInfo = bgOrgUnits.get(i);
                        if (!bgOrgUnitInfo.isIsLeaf() || bgOrgUnitInfo.getLongNumber().indexOf(string) <= -1) continue;
                        result.add(bgOrgUnitInfo.getNumber());
                    }
                }
            }
            this.data.get(DimensionBaseConstants.DEF_ORGUNIT_FIELD).addAll(result);
        }
        BgDimensionInfo dimension = this.helper.getDimension(DimensionBaseConstants.DEF_PERIOD_NUMBER);
        HashSet<String> typeIds = new HashSet<String>();
        List members = dimension.getMember();
        for (BgDimensionMember mber : members) {
            typeIds.add(mber.getAttribute());
        }
        if (this.data != null && this.data.get(DimensionBaseConstants.DEF_PERIOD_FIELD) != null) {
            numbers = this.data.get(DimensionBaseConstants.DEF_PERIOD_FIELD);
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("number");
            selector.add("longNumber");
            selector.add("isLeaf");
            entityViewInfo.setSelector(selector);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("type", typeIds, CompareType.INCLUDE));
            entityViewInfo.setFilter(filter);
            BgPeriodDispCollection bgPeriods = BgPeriodDispFactory.getRemoteInstance().getBgPeriodDispCollection(entityViewInfo);
            BgPeriodDispInfo periodInfo = null;
            HashSet<String> result = new HashSet<String>();
            if (bgPeriods != null && !bgPeriods.isEmpty()) {
                for (String number : numbers) {
                    int in = bgPeriods.size();
                    for (int i = 0; i < in; ++i) {
                        periodInfo = bgPeriods.get(i);
                        if (!periodInfo.isIsLeaf() || periodInfo.getLongNumber().indexOf(number) <= -1) continue;
                        result.add(periodInfo.getNumber());
                    }
                }
            }
            this.data.get(DimensionBaseConstants.DEF_PERIOD_FIELD).addAll(result);
        }
        if (this.prmtProcessType.getValue() != null && (objectArray = DimensionCommonHelper.getValues((Object)this.prmtProcessType.getValue())) != null && objectArray.length > 0) {
            HashSet<String> result = new HashSet<String>();
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof BgProcessEnum)) continue;
                result.add(((BgProcessEnum)objectArray[i]).getName());
            }
            this.data.put(DimensionBaseConstants.DEF_PROCESS_FIELD, result);
        }
    }

    @Override
    protected void btnCancle_actionPerformed(ActionEvent e) throws Exception {
        this.isCancle = true;
        this.destroyWindow();
    }
}

